/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2007-23-03
 * Description : a tool tip widget witch follow cursor movements 
 *               Tool tip content is displayed without delay.
 * 
 * Copyright (C) 2007 by Gilles Caulier  <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

// TQt includes.

#include <tqevent.h>
#include <tqtooltip.h>

// Local includes.

#include "dcursortracker.h"

namespace Digikam 
{

DCursorTracker::DCursorTracker(const TQString& txt, TQWidget *parent)
              : TQLabel(txt, 0, "", WX11BypassWM) 
{
    parent->setMouseTracking(true);
    parent->installEventFilter(this);
    setEnable(true);
}

/**
 * Overload to make sure the widget size is correct
 */
void DCursorTracker::setText(const TQString& txt) 
{
    TQLabel::setText(txt);
    adjustSize();
}

void DCursorTracker::setEnable(bool b) 
{
    m_enable = b;
}

bool DCursorTracker::eventFilter(TQObject *object, TQEvent *e) 
{
    TQWidget *widget = static_cast<TQWidget*>(object);

    switch (e->type()) 
    {
        case TQEvent::MouseMove: 
        {
            TQMouseEvent *event = static_cast<TQMouseEvent*>(e);
            if (m_enable && (widget->rect().contains(event->pos()) ||
                            (event->stateAfter() & TQt::LeftButton)))
            {
                show();
                TQPoint p = widget->mapToGlobal(TQPoint(widget->width()/2, 0));
                move(p.x()-width()/2, p.y()-height());
            }
            else 
            {
                hide();
            }
            break;
        }

        case TQEvent::MouseButtonRelease: 
        {
            TQMouseEvent* event = static_cast<TQMouseEvent*>(e);
            if ( !widget->rect().contains(event->pos()) )
            {
                hide();
            }
            break;
        }

        default:
            break;
    }

    return false;
}


DTipTracker::DTipTracker(const TQString& txt, TQWidget *parent)
           : DCursorTracker(txt, parent) 
{
    setPalette(TQToolTip::palette());
    setFrameStyle(TQFrame::Plain | TQFrame::Box);
    setLineWidth(1);
    setAlignment(AlignAuto | AlignTop);
}

} // namespace Digikam
