;;; pine-script-mode.el --- Major mode for TradingView Pine Script v6 and older -*- lexical-binding: t; -*-
;;
;;; Copyright (C) 2018  Free Software Foundation, Inc.
;;
;;; Author: Eric Crosson <eric.s.crosson@utexas.edu>
;; Package-Version: 3.5.4
;; Package-Revision: 203ba62b1c36
;; Keywords: extensions
;; Package-Requires: ((emacs "24"))
;; URL: https://github.com/ericcrosson/pine-script-mode
;;
;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.
;;
;;; Commentary:
;;
;; Provides a comprehensive major mode for editing TradingView Pine Script v6 and older files.
;; It correctly highlights variables, constants, functions, methods, types,
;; keywords, and annotations based on the v6 syntax.
;;
;; Add the following to your .emacs to install:
;;
;; Pine script mode automatically loads for ".pine", ".pinescript" files 
;;
;; (require 'pine-script-mode)
;; 
;; or:
;;
;; (use-package pine-script-mode :ensure t)
;; 
;; or:
;; 
;; (straight-use-package '(pine-script-mode :type git :host github :repo "EricCrosson/pine-script-mode"))
;; 

;;; Code:

(defvar pine-script-mode-syntax-table
  (let ((table (make-syntax-table)))
    (modify-syntax-entry ?\/ ". 12b" table)
    (modify-syntax-entry ?\n "> b" table)
    ;; String delimiters
    (modify-syntax-entry ?' "\"'" table)
    (modify-syntax-entry ?\" "\"\"" table)
    ;; Underscore is part of words
    (modify-syntax-entry ?_ "w" table)
    ;; Standard parenthesis matching
    (modify-syntax-entry ?\( "()" table)
    (modify-syntax-entry ?\) ")(" table)
    (modify-syntax-entry ?\{ "(}" table)
    (modify-syntax-entry ?\} "){" table)
    (modify-syntax-entry ?\[ "(]" table)
    (modify-syntax-entry ?\] ")[" table)
    table)
  "Syntax table for `pine-script-mode'.")

(defvar pine-script-font-lock-keywords
  `(
    ;; Version annotation - must come first
    ("^//@version=\\([0-9]+\\)" (0 font-lock-warning-face))
    
    ;; Comment annotations - @variable, @function, @param, @returns, @type, etc.
    ("\\(?://\\|/\\*\\).*?\\(@[a-zA-Z_][a-zA-Z0-9_]*\\)" 
     (1 font-lock-doc-face t))

    ;; TODO, FIXME, NOTE, XXX in comments
    ("\\(?://\\|/\\*\\).*?\\(\\(?:TODO\\|FIXME\\|NOTE\\|HACK\\|BUG\\)\\(?::\\|\\s-\\)\\)" 
     (1 font-lock-warning-face t))
    
    ;; Hex colors - MUST come before number highlighting
    ("#[0-9A-Fa-f]\\{6\\}\\|#[0-9A-Fa-f]\\{8\\}" . font-lock-constant-face)

    ;; Numbers (but not those that are part of hex colors)
    ("\\<[0-9]+\\(?:\\.[0-9]*\\)?\\(?:[eE][+-]?[0-9]+\\)?\\>" 
     . font-lock-constant-face)

    ;; Indicators/Strategy/Library declarations
    ("^\\(indicator\\|strategy\\|library\\)\\s-*(" 
     (1 font-lock-keyword-face))

    ;; Function definitions with optional export/method
    ("^\\s-*\\(?:\\(export\\|method\\)\\s-+\\)?\\([a-zA-Z_][a-zA-Z0-9_]*\\)\\s-*(" 
     (1 font-lock-keyword-face nil t)
     (2 font-lock-function-name-face))

    ;; Ternary operators ? and :
    ("\\([?]\\)\\s-*[^:]*\\s-*\\([:]\\)" 
     (1 font-lock-keyword-face)
     (2 font-lock-keyword-face))

    ;; Constants
    (,(regexp-opt '(
                    "adjustment.dividends"
                    "adjustment.none"
                    "adjustment.splits"
                    "alert.freq_all"
                    "alert.freq_once_per_bar"
                    "alert.freq_once_per_bar_close"
                    "backadjustment.inherit"
                    "backadjustment.off"
                    "backadjustment.on"
                    "barmerge.gaps_off"
                    "barmerge.gaps_on"
                    "barmerge.lookahead_off"
                    "barmerge.lookahead_on"
                    "color.aqua"
                    "color.black"
                    "color.blue"
                    "color.fuchsia"
                    "color.gray"
                    "color.green"
                    "color.lime"
                    "color.maroon"
                    "color.navy"
                    "color.olive"
                    "color.orange"
                    "color.purple"
                    "color.red"
                    "color.silver"
                    "color.teal"
                    "color.white"
                    "color.yellow"
                    "currency.AED"
                    "currency.ARS"
                    "currency.AUD"
                    "currency.BDT"
                    "currency.BHD"
                    "currency.BRL"
                    "currency.BTC"
                    "currency.CAD"
                    "currency.CHF"
                    "currency.CLP"
                    "currency.CNY"
                    "currency.COP"
                    "currency.CZK"
                    "currency.DKK"
                    "currency.EGP"
                    "currency.ETH"
                    "currency.EUR"
                    "currency.GBP"
                    "currency.HKD"
                    "currency.HUF"
                    "currency.IDR"
                    "currency.ILS"
                    "currency.INR"
                    "currency.ISK"
                    "currency.JPY"
                    "currency.KES"
                    "currency.KRW"
                    "currency.KWD"
                    "currency.LKR"
                    "currency.MAD"
                    "currency.MXN"
                    "currency.MYR"
                    "currency.NGN"
                    "currency.NOK"
                    "currency.NONE"
                    "currency.NZD"
                    "currency.PEN"
                    "currency.PHP"
                    "currency.PKR"
                    "currency.PLN"
                    "currency.QAR"
                    "currency.RON"
                    "currency.RSD"
                    "currency.RUB"
                    "currency.SAR"
                    "currency.SEK"
                    "currency.SGD"
                    "currency.THB"
                    "currency.TND"
                    "currency.TRY"
                    "currency.TWD"
                    "currency.USD"
                    "currency.USDT"
                    "currency.VES"
                    "currency.VND"
                    "currency.ZAR"
                    "dayofweek.friday"
                    "dayofweek.monday"
                    "dayofweek.saturday"
                    "dayofweek.sunday"
                    "dayofweek.thursday"
                    "dayofweek.tuesday"
                    "dayofweek.wednesday"
                    "display.all"
                    "display.data_window"
                    "display.none"
                    "display.pane"
                    "display.price_scale"
                    "display.status_line"
                    "dividends.gross"
                    "dividends.net"
                    "earnings.actual"
                    "earnings.estimate"
                    "earnings.standardized"
                    "extend.both"
                    "extend.left"
                    "extend.none"
                    "extend.right"
                    "false"
                    "font.family_default"
                    "font.family_monospace"
                    "format.inherit"
                    "format.mintick"
                    "format.percent"
                    "format.price"
                    "format.volume"
                    "hline.style_dashed"
                    "hline.style_dotted"
                    "hline.style_solid"
                    "label.style_arrowdown"
                    "label.style_arrowup"
                    "label.style_circle"
                    "label.style_cross"
                    "label.style_diamond"
                    "label.style_flag"
                    "label.style_label_center"
                    "label.style_label_down"
                    "label.style_label_left"
                    "label.style_label_lower_left"
                    "label.style_label_lower_right"
                    "label.style_label_right"
                    "label.style_label_up"
                    "label.style_label_upper_left"
                    "label.style_label_upper_right"
                    "label.style_none"
                    "label.style_square"
                    "label.style_text_outline"
                    "label.style_triangledown"
                    "label.style_triangleup"
                    "label.style_xcross"
                    "line.style_arrow_both"
                    "line.style_arrow_left"
                    "line.style_arrow_right"
                    "line.style_dashed"
                    "line.style_dotted"
                    "line.style_solid"
                    "location.abovebar"
                    "location.absolute"
                    "location.belowbar"
                    "location.bottom"
                    "location.top"
                    "math.e"
                    "math.phi"
                    "math.pi"
                    "math.rphi"
                    "order.ascending"
                    "order.descending"
                    "plot.style_area"
                    "plot.style_areabr"
                    "plot.style_circles"
                    "plot.style_columns"
                    "plot.style_cross"
                    "plot.style_histogram"
                    "plot.style_line"
                    "plot.style_linebr"
                    "plot.style_stepline"
                    "plot.style_stepline_diamond"
                    "plot.style_steplinebr"
                    "position.bottom_center"
                    "position.bottom_left"
                    "position.bottom_right"
                    "position.middle_center"
                    "position.middle_left"
                    "position.middle_right"
                    "position.top_center"
                    "position.top_left"
                    "position.top_right"
                    "scale.left"
                    "scale.none"
                    "scale.right"
                    "session.extended"
                    "session.regular"
                    "settlement_as_close.inherit"
                    "settlement_as_close.off"
                    "settlement_as_close.on"
                    "shape.arrowdown"
                    "shape.arrowup"
                    "shape.circle"
                    "shape.cross"
                    "shape.diamond"
                    "shape.flag"
                    "shape.labeldown"
                    "shape.labelup"
                    "shape.square"
                    "shape.triangledown"
                    "shape.triangleup"
                    "shape.xcross"
                    "size.auto"
                    "size.huge"
                    "size.large"
                    "size.normal"
                    "size.small"
                    "size.tiny"
                    "splits.denominator"
                    "splits.numerator"
                    "strategy.cash" 
                    "strategy.commission.cash_per_contract"
                    "strategy.commission.cash_per_order"
                    "strategy.commission.percent"
                    "strategy.direction.all"
                    "strategy.direction.long"
                    "strategy.direction.short" 
                    "strategy.fixed"
                    "strategy.long"
                    "strategy.oca.cancel"
                    "strategy.oca.none"
                    "strategy.oca.reduce"
                    "strategy.percent_of_equity"
                    "strategy.short"
                    "text.align_bottom"
                    "text.align_center"
                    "text.align_left" 
                    "text.align_right"
                    "text.align_top"
                    "text.format_bold"
                    "text.format_italic"
                    "text.format_none"
                    "text.wrap_auto"
                    "text.wrap_none"
                    "true"
                    "xloc.bar_index"
                    "xloc.bar_time"
                    "yloc.abovebar"
                    "yloc.belowbar"
                    "yloc.price"
                    ) 'words)
     (0 font-lock-constant-face))

    ;; Common built-in variables with namespaces
    (,(regexp-opt '(
                    "ask"
                    "bar_index"
                    "barstate.isconfirmed"
                    "barstate.isfirst"
                    "barstate.ishistory"
                    "barstate.islast"
                    "barstate.islastconfirmedhistory"
                    "barstate.isnew"
                    "barstate.isrealtime" 
                    "bid"
                    "box.all"
                    "chart.bg_color"
                    "chart.fg_color"
                    "chart.is_heikinashi"
                    "chart.is_kagi"
                    "chart.is_linebreak"
                    "chart.is_pnf"
                    "chart.is_range"
                    "chart.is_renko" 
                    "chart.is_standard"
                    "chart.left_visible_bar_time"
                    "chart.right_visible_bar_time"
                    "close"
                    "dayofmonth"
                    "dayofweek"
                    "dividends.future_amount"
                    "dividends.future_ex_date" 
                    "dividends.future_pay_date"
                    "earnings.future_eps"
                    "earnings.future_period_end_time"
                    "earnings.future_revenue"
                    "earnings.future_time"
                    "high"
                    "hl2"
                    "hlc3"
                    "hlcc4"
                    "hour" 
                    "label.all"
                    "last_bar_index"
                    "last_bar_time"
                    "line.all"
                    "linefill.all"
                    "low"
                    "minute"
                    "month"
                    "na"
                    "ohlc4"
                    "open"
                    "polyline.all"
                    "second"
                    "session.isfirstbar" 
                    "session.isfirstbar_regular"
                    "session.islastbar"
                    "session.islastbar_regular"
                    "session.ismarket"
                    "session.ispostmarket"
                    "session.ispremarket"
                    "strategy.account_currency" 
                    "strategy.avg_losing_trade"
                    "strategy.avg_losing_trade_percent"
                    "strategy.avg_trade"
                    "strategy.avg_trade_percent"
                    "strategy.avg_winning_trade"
                    "strategy.avg_winning_trade_percent" 
                    "strategy.closedtrades"
                    "strategy.closedtrades.first_index"
                    "strategy.equity"
                    "strategy.eventrades"
                    "strategy.grossloss"
                    "strategy.grossloss_percent"
                    "strategy.grossprofit" 
                    "strategy.grossprofit_percent"
                    "strategy.initial_capital"
                    "strategy.losstrades"
                    "strategy.margin_liquidation_price"
                    "strategy.max_contracts_held_all"
                    "strategy.max_contracts_held_long" 
                    "strategy.max_contracts_held_short"
                    "strategy.max_drawdown"
                    "strategy.max_drawdown_percent"
                    "strategy.max_runup"
                    "strategy.max_runup_percent"
                    "strategy.netprofit"
                    "strategy.netprofit_percent" 
                    "strategy.openprofit"
                    "strategy.openprofit_percent"
                    "strategy.opentrades"
                    "strategy.opentrades.capital_held"
                    "strategy.position_avg_price"
                    "strategy.position_entry_name"
                    "strategy.position_size" 
                    "strategy.wintrades"
                    "syminfo.basecurrency"
                    "syminfo.country"
                    "syminfo.currency"
                    "syminfo.current_contract"
                    "syminfo.description"
                    "syminfo.employees"
                    "syminfo.expiration_date"
                    "syminfo.industry" 
                    "syminfo.main_tickerid"
                    "syminfo.mincontract"
                    "syminfo.minmove"
                    "syminfo.mintick"
                    "syminfo.pointvalue"
                    "syminfo.prefix"
                    "syminfo.pricescale"
                    "syminfo.recommendations_buy" 
                    "syminfo.recommendations_buy_strong"
                    "syminfo.recommendations_date"
                    "syminfo.recommendations_hold"
                    "syminfo.recommendations_sell"
                    "syminfo.recommendations_sell_strong" 
                    "syminfo.recommendations_total"
                    "syminfo.root"
                    "syminfo.sector"
                    "syminfo.session"
                    "syminfo.shareholders"
                    "syminfo.shares_outstanding_float"
                    "syminfo.shares_outstanding_total" 
                    "syminfo.target_price_average"
                    "syminfo.target_price_date"
                    "syminfo.target_price_estimates"
                    "syminfo.target_price_high"
                    "syminfo.target_price_low"
                    "syminfo.target_price_median" 
                    "syminfo.ticker"
                    "syminfo.tickerid"
                    "syminfo.timezone"
                    "syminfo.type"
                    "syminfo.volumetype"
                    "ta.accdist"
                    "ta.iii"
                    "ta.nvi"
                    "ta.obv"
                    "ta.pvi"
                    "ta.pvt"
                    "ta.tr"
                    "ta.vwap"
                    "ta.wad"
                    "ta.wvad"
                    "table.all"
                    "time"
                    "time_close"
                    "time_tradingday"
                    "timeframe.isdaily"
                    "timeframe.isdwm"
                    "timeframe.isintraday"
                    "timeframe.isminutes"
                    "timeframe.ismonthly"
                    "timeframe.isseconds" 
                    "timeframe.isticks"
                    "timeframe.isweekly"
                    "timeframe.main_period"
                    "timeframe.multiplier"
                    "timeframe.period"
                    "timenow"
                    "volume"
                    "weekofyear"
                    "year" 
                    ) 'symbols)
     (0 font-lock-variable-name-face))

    ;; Common built-in functions
    (,(regexp-opt '(
                    "alert"
                    "alertcondition"
                    "array.abs"
                    "array.avg"
                    "array.binary_search"
                    "array.binary_search_leftmost"
                    "array.binary_search_rightmost"
                    "array.clear"
                    "array.concat" 
                    "array.copy"
                    "array.covariance"
                    "array.every"
                    "array.fill"
                    "array.first"
                    "array.from"
                    "array.get"
                    "array.includes"
                    "array.indexof"
                    "array.insert"
                    "array.join" 
                    "array.last"
                    "array.lastindexof"
                    "array.max"
                    "array.median"
                    "array.min"
                    "array.mode"
                    "array.new_bool"
                    "array.new_box"
                    "array.new_color"
                    "array.new_float" 
                    "array.new_int"
                    "array.new_label"
                    "array.new_line"
                    "array.new_linefill"
                    "array.new_string"
                    "array.new_table"
                    "array.new"
                    "array.percentile_linear_interpolation" 
                    "array.percentile_nearest_rank"
                    "array.percentrank"
                    "array.pop"
                    "array.push"
                    "array.range"
                    "array.remove"
                    "array.reverse"
                    "array.set"
                    "array.shift"
                    "array.size" 
                    "array.slice"
                    "array.some"
                    "array.sort"
                    "array.sort_indices"
                    "array.standardize"
                    "array.stdev"
                    "array.sum"
                    "array.unshift"
                    "array.variance"
                    "barcolor"
                    "bgcolor" 
                    "bool"
                    "box"
                    "box.copy"
                    "box.delete"
                    "box.get_bottom"
                    "box.get_left"
                    "box.get_right"
                    "box.get_top"
                    "box.new"
                    "box.set_bgcolor"
                    "box.set_border_color" 
                    "box.set_border_style"
                    "box.set_border_width"
                    "box.set_bottom"
                    "box.set_bottom_right_point"
                    "box.set_extend"
                    "box.set_left"
                    "box.set_lefttop"
                    "box.set_right" 
                    "box.set_rightbottom"
                    "box.set_text"
                    "box.set_text_color"
                    "box.set_text_font_family"
                    "box.set_text_formatting"
                    "box.set_text_halign"
                    "box.set_text_size" 
                    "box.set_text_valign"
                    "box.set_text_wrap"
                    "box.set_top"
                    "box.set_top_left_point"
                    "box.set_xloc"
                    "chart.point.copy"
                    "chart.point.from_index"
                    "chart.point.from_time" 
                    "chart.point.new"
                    "chart.point.now"
                    "color"
                    "color.b"
                    "color.from_gradient"
                    "color.g"
                    "color.new"
                    "color.r"
                    "color.rgb"
                    "color.t"
                    "dayofmonth"
                    "dayofweek"
                    "fill" 
                    "fixnan"
                    "float"
                    "hline"
                    "hour"
                    "indicator"
                    "input.bool"
                    "input.color"
                    "input.enum"
                    "input.float"
                    "input.int"
                    "input.price"
                    "input.session"
                    "input.source" 
                    "input.string"
                    "input.symbol"
                    "input.text_area"
                    "input.time"
                    "input.timeframe"
                    "int"
                    "label"
                    "label.copy"
                    "label.delete"
                    "label.get_text"
                    "label.get_x"
                    "label.get_y" 
                    "label.new"
                    "label.set_color"
                    "label.set_point"
                    "label.set_size"
                    "label.set_style"
                    "label.set_text"
                    "label.set_text_font_family"
                    "label.set_text_formatting" 
                    "label.set_textalign"
                    "label.set_textcolor"
                    "label.set_tooltip"
                    "label.set_x"
                    "label.set_xloc"
                    "label.set_xy"
                    "label.set_y"
                    "label.set_yloc"
                    "library"
                    "line"
                    "line.copy" 
                    "line.delete"
                    "line.get_price"
                    "line.get_x1"
                    "line.get_x2"
                    "line.get_y1"
                    "line.get_y2"
                    "line.new"
                    "line.set_color"
                    "line.set_extend"
                    "line.set_first_point"
                    "line.set_second_point" 
                    "line.set_style"
                    "line.set_width"
                    "line.set_x1"
                    "line.set_x2"
                    "line.set_xloc"
                    "line.set_xy1"
                    "line.set_xy2"
                    "line.set_y1"
                    "line.set_y2"
                    "linefill"
                    "linefill.delete"
                    "linefill.get_line1"
                    "linefill.get_line2"
                    "linefill.new" 
                    "linefill.set_color"
                    "log.error"
                    "log.info"
                    "log.warning"
                    "map.clear"
                    "map.contains"
                    "map.copy"
                    "map.get"
                    "map.keys"
                    "map.new"
                    "map.put"
                    "map.put_all"
                    "map.remove"
                    "map.size" 
                    "map.values"
                    "math.abs"
                    "math.acos"
                    "math.asin"
                    "math.atan"
                    "math.avg"
                    "math.ceil"
                    "math.cos"
                    "math.exp"
                    "math.floor"
                    "math.log"
                    "math.log10"
                    "math.max"
                    "math.min"
                    "math.pow" 
                    "math.random"
                    "math.round"
                    "math.round_to_mintick"
                    "math.sign"
                    "math.sin"
                    "math.sqrt"
                    "math.sum"
                    "math.tan"
                    "math.todegrees"
                    "math.toradians"
                    "matrix.add_col"
                    "matrix.add_row" 
                    "matrix.avg"
                    "matrix.col"
                    "matrix.columns"
                    "matrix.concat"
                    "matrix.copy"
                    "matrix.det"
                    "matrix.diff"
                    "matrix.eigenvalues"
                    "matrix.eigenvectors"
                    "matrix.elements_count"
                    "matrix.fill" 
                    "matrix.get"
                    "matrix.inv"
                    "matrix.is_antidiagonal"
                    "matrix.is_antisymmetric"
                    "matrix.is_binary"
                    "matrix.is_diagonal"
                    "matrix.is_identity"
                    "matrix.is_square"
                    "matrix.is_stochastic" 
                    "matrix.is_symmetric"
                    "matrix.is_triangular"
                    "matrix.is_zero"
                    "matrix.kron"
                    "matrix.max"
                    "matrix.median"
                    "matrix.min"
                    "matrix.mode"
                    "matrix.mult"
                    "matrix.new"
                    "matrix.pinv"
                    "matrix.pow" 
                    "matrix.rank"
                    "matrix.remove_col"
                    "matrix.remove_row"
                    "matrix.reshape"
                    "matrix.reverse"
                    "matrix.row"
                    "matrix.rows"
                    "matrix.set"
                    "matrix.sort"
                    "matrix.submatrix"
                    "matrix.sum"
                    "matrix.swap_columns" 
                    "matrix.swap_rows"
                    "matrix.trace"
                    "matrix.transpose"
                    "max_bars_back"
                    "minute"
                    "month"
                    "na"
                    "nz"
                    "plot"
                    "plotarrow"
                    "plotbar"
                    "plotcandle"
                    "plotchar"
                    "plotshape"
                    "polyline.delete"
                    "polyline.new" 
                    "request.currency_rate"
                    "request.dividends"
                    "request.earnings"
                    "request.economic"
                    "request.financial"
                    "request.quandl"
                    "request.security"
                    "request.security_lower_tf"
                    "request.seed"
                    "request.splits" 
                    "runtime.error"
                    "second"
                    "str.contains"
                    "str.endswith"
                    "str.format"
                    "str.format_time"
                    "str.length"
                    "str.lower"
                    "str.match"
                    "str.pos"
                    "str.repeat"
                    "str.replace"
                    "str.replace_all"
                    "str.split" 
                    "str.startswith"
                    "str.substring"
                    "str.tonumber"
                    "str.tostring"
                    "str.trim"
                    "str.upper"
                    "strategy"
                    "strategy.cancel"
                    "strategy.cancel_all"
                    "strategy.close"
                    "strategy.close_all" 
                    "strategy.closedtrades.commission"
                    "strategy.closedtrades.entry_bar_index"
                    "strategy.closedtrades.entry_comment"
                    "strategy.closedtrades.entry_id"
                    "strategy.closedtrades.entry_price" 
                    "strategy.closedtrades.entry_time"
                    "strategy.closedtrades.exit_bar_index"
                    "strategy.closedtrades.exit_comment"
                    "strategy.closedtrades.exit_id"
                    "strategy.closedtrades.exit_price" 
                    "strategy.closedtrades.exit_time"
                    "strategy.closedtrades.max_drawdown"
                    "strategy.closedtrades.max_drawdown_percent"
                    "strategy.closedtrades.max_runup"
                    "strategy.closedtrades.max_runup_percent" 
                    "strategy.closedtrades.profit"
                    "strategy.closedtrades.profit_percent"
                    "strategy.closedtrades.size"
                    "strategy.convert_to_account"
                    "strategy.convert_to_symbol"
                    "strategy.default_entry_qty" 
                    "strategy.entry"
                    "strategy.exit"
                    "strategy.opentrades.commission"
                    "strategy.opentrades.entry_bar_index"
                    "strategy.opentrades.entry_comment"
                    "strategy.opentrades.entry_id"
                    "strategy.opentrades.entry_price" 
                    "strategy.opentrades.entry_time"
                    "strategy.opentrades.max_drawdown"
                    "strategy.opentrades.max_drawdown_percent"
                    "strategy.opentrades.max_runup"
                    "strategy.opentrades.max_runup_percent" 
                    "strategy.opentrades.profit"
                    "strategy.opentrades.profit_percent"
                    "strategy.opentrades.size"
                    "strategy.order"
                    "strategy.risk.allow_entry_in"
                    "strategy.risk.max_cons_loss_days" 
                    "strategy.risk.max_drawdown"
                    "strategy.risk.max_intraday_filled_orders"
                    "strategy.risk.max_intraday_loss"
                    "strategy.risk.max_position_size"
                    "string"
                    "syminfo.prefix"
                    "syminfo.ticker" 
                    "ta.alma"
                    "ta.atr"
                    "ta.barssince"
                    "ta.bb"
                    "ta.bbw"
                    "ta.cci"
                    "ta.change"
                    "ta.cmo"
                    "ta.cog"
                    "ta.correlation"
                    "ta.cross"
                    "ta.crossover"
                    "ta.crossunder"
                    "ta.cum"
                    "ta.dev"
                    "ta.dmi"
                    "ta.ema" 
                    "ta.falling"
                    "ta.highest"
                    "ta.highestbars"
                    "ta.hma"
                    "ta.kc"
                    "ta.kcw"
                    "ta.linreg"
                    "ta.lowest"
                    "ta.lowestbars"
                    "ta.macd"
                    "ta.max"
                    "ta.median"
                    "ta.mfi"
                    "ta.min"
                    "ta.mode"
                    "ta.mom" 
                    "ta.percentile_linear_interpolation"
                    "ta.percentile_nearest_rank"
                    "ta.percentrank"
                    "ta.pivot_point_levels"
                    "ta.pivothigh"
                    "ta.pivotlow"
                    "ta.range"
                    "ta.rci"
                    "ta.rising"
                    "ta.rma" 
                    "ta.roc"
                    "ta.rsi"
                    "ta.sar"
                    "ta.sma"
                    "ta.stdev"
                    "ta.stoch"
                    "ta.supertrend"
                    "ta.swma"
                    "ta.tr"
                    "ta.tsi"
                    "ta.valuewhen"
                    "ta.variance"
                    "ta.vwap"
                    "ta.vwma"
                    "ta.wma"
                    "ta.wpr"
                    "table" 
                    "table.cell"
                    "table.cell_set_bgcolor"
                    "table.cell_set_height"
                    "table.cell_set_text"
                    "table.cell_set_text_color"
                    "table.cell_set_text_font_family"
                    "table.cell_set_text_formatting" 
                    "table.cell_set_text_halign"
                    "table.cell_set_text_size"
                    "table.cell_set_text_valign"
                    "table.cell_set_tooltip"
                    "table.cell_set_width"
                    "table.clear"
                    "table.delete"
                    "table.merge_cells" 
                    "table.new"
                    "table.set_bgcolor"
                    "table.set_border_color"
                    "table.set_border_width"
                    "table.set_frame_color"
                    "table.set_frame_width"
                    "table.set_position"
                    "ticker.heikinashi"
                    "ticker.inherit" 
                    "ticker.kagi"
                    "ticker.linebreak"
                    "ticker.modify"
                    "ticker.new"
                    "ticker.pointfigure"
                    "ticker.renko"
                    "ticker.standard"
                    "time"
                    "time_close"
                    "timeframe.change"
                    "timeframe.from_seconds" 
                    "timeframe.in_seconds"
                    "timestamp"
                    "weekofyear"
                    "year"
                    ) 'symbols)
     (0 font-lock-function-name-face))

    ;; Built-in namespaces
    (,(regexp-opt '("ta" "math" "str" "array" "matrix" "request" "input" 
                    "plot" "hline" "fill" "color" "line" "label" "box" 
                    "table" "alert" "log" "runtime" "time" "ticker"
                    "session" "syminfo" "strategy" "chart" "na" "bar_index") 'words)
     (0 font-lock-builtin-face))

    ;; Keywords
    (,(regexp-opt '("and" "array" "bool" "box" "chart.point" "color" "const" "enum" "export" "float" "for" "if" "import" "int" "label" "line" "linefill" "map"
                    "matrix" "method" "not" "or" "polyline" "series" "simple" "string" "switch" "table" "type" "Types" "var" "varip" "while"
                    ) 'words)
     (0 font-lock-keyword-face))

    )
  "Keyword highlighting specification for `pine-script-mode'.")

;;;###autoload
(define-derived-mode pine-script-mode prog-mode "PineScript"
  "A major mode for editing TradingView Pine Script v6 files."
  (setq-local comment-start "// ")
  (setq-local font-lock-defaults '(pine-script-font-lock-keywords)))

;;;###autoload
(add-to-list 'auto-mode-alist '("\\.pine\\'" . pine-script-mode))
;;;###autoload
(add-to-list 'auto-mode-alist '("\\.pinescript\\'" . pine-script-mode))

(provide 'pine-script-mode)
;;; pine-script-mode.el ends here
