
// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.


namespace std {

#if 0 /* numerics, skip it. */

#if 0
# if _G_HAVE_PRINTF_FP
#   include <printf.h>   /* non-standard */
    extern "C" int __printf_fp (_IO_FILE*, const struct printf_info*,
                               const void* const*);
# else
#   include "floatio.h"  /* non-standard */

#   define BUF             (MAXEXP+MAXFRACT+1)     /* + decimal point */
# endif
#else
#   define BUF     300   /* XXX this wrong in more ways than I can count. */
#endif


#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
# define LONGEST long long
#else
# define LONGEST long
#endif


/* Write VAL on STREAM.
   If SIGN<0, val is the absolute value of a negative number.
   If SIGN>0, val is a signed non-negative number.
   If SIGN==0, val is unsigned. */

static void
write_int (ostream& stream, unsigned LONGEST val, int sign)
{
#define WRITE_BUF_SIZE (10 + sizeof (unsigned LONGEST) * 4)
  char buf[WRITE_BUF_SIZE];
  char* buf_ptr = buf + WRITE_BUF_SIZE; // End of buf.
  const char* show_base = "";
  int show_base_len = 0;
  int show_pos = 0; // If 1, print a '+'.

  // Now do the actual conversion, placing the result at the *end* of
  // buf.  Note that we use separate code for decimal, octal, and hex,
  // so we can divide by optimizable constants.
  if ((stream.flags () & ios_base::basefield) == ios_base::oct)
    { // Octal
      do
	{
	  *--buf_ptr = (val & 7) + '0';
	  val = val >> 3;
        }
      while (val != 0);
      if ((stream.flags () & ios_base::showbase) && (*buf_ptr != '0'))
	*--buf_ptr = '0';
    }
  else if ((stream.flags () & ios_base::basefield) == ios_base::hex)
    { // Hex
      const char* xdigs = ((stream.flags () & ios::uppercase)
			   ? "0123456789ABCDEF0X" : "0123456789abcdef0x");
      do
	{
	  *--buf_ptr = xdigs[val & 15];
	  val = val >> 4;
        }
      while (val != 0);
      if ((stream.flags() & ios_base::showbase))
	{
	  show_base = xdigs + 16; // Either "0X" or "0x".
	  show_base_len = 2;
        }
    }
  else
    { // Decimal
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
      // Optimization:  Only use long long when we need to.
      while (val > UINT_MAX)
	{
	  *--buf_ptr = (val % 10) + '0';
	  val /= 10;
        }
      // Use more efficient (int) arithmetic for the rest.
      unsigned int ival = (unsigned int)val;
#else
      unsigned LONGEST ival = val;
#endif
      do
	{
	  *--buf_ptr = (ival % 10) + '0';
	  ival /= 10;
        }
      while (ival != 0);
      if (sign > 0 && (stream.flags() & ios::showpos))
	show_pos=1;
    }

  int buf_len = buf + WRITE_BUF_SIZE - buf_ptr;
  int w = stream.width (0);

  // Calculate padding.
  int len = buf_len + show_pos;
  if (sign < 0)
    ++len;
  len += show_base_len;
  int padding = len > w ? 0 : w - len;

  // Do actual output.
  streambuf* sbuf = stream.rdbuf ();
  ios_base::fmtflags pad_kind = stream.flags () & ios_base::adjustfield;
  char fill_char = stream.fill ();
  if (padding > 0
      && pad_kind != ios_base::left
      && pad_kind != ios_base::internal) // Default (right) adjust.
    if (_IO_padn (sbuf, fill_char, padding) < padding)
      goto failed;
  if (sign < 0 || show_pos)
    {
      char ch = sign < 0 ? '-' : '+';
      if (sbuf->sputc (ch) < 0)
	goto failed;
    }
  if (show_base_len)
    if (sbuf->sputn (show_base, show_base_len) != streamsize(show_base_len))
      goto failed;
  if (pad_kind == ios_base::internal && padding > 0)
    if (_IO_padn (sbuf, fill_char, padding) < padding)
      goto failed;
  if (sbuf->sputn (buf_ptr, buf_len) != streamsize(buf_len))
    goto failed;
  if (pad_kind == ios_base::left && padding > 0) // Left adjustment
    if (_IO_padn (sbuf, fill_char, padding) < padding)
      goto failed;

  return;
 failed:
  stream.setstate (ios_base::badbit);
}



#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
template <class _CharT, class _Traits>
basic_ostream<_CharT,_Traits> &
basic_ostream<_Chart,_Traits>::operator << (long long n)
{
  sentry cerb (*this);

  if (cerb)
    {
      int sign = 1;
      unsigned long long abs_n = (unsigned long long) n;
      if (n < 0 && (flags () & (ios_base::oct|ios_base::hex)) == 0)
	{
	  abs_n = -((unsigned long long) n);
	  sign = -1;
	}
      write_int (*this, abs_n, sign);
    }
  return *this;
}


template <class _CharT, class _Traits>
basic_ostream<_CharT,_Traits> &
basic_ostream<_Chart,_Traits>::operator << (unsigned long long n)
{
  sentry cerb (*this);

  if (cerb)
    write_int (*this, n, 0);
  return *this;
}
#endif /*__GNUC__*/


template <class _CharT, class _Traits>
basic_ostream<_CharT,_Traits> &
basic_ostream<_Chart,_Traits>::operator << (double n)
{
  sentry cerb (*this);

  if (cerb)
    {
      // Uses __cvt_double (renamed from static cvt), in Chris Torek's
      // stdio implementation.  The setup code uses the same logic as
      // in __vsbprintf.C (also based on Torek's code).
      int format_char;
      if ((flags () & ios_base::floatfield) == ios_base::fixed)
	format_char = 'f';
      else if ((flags () & ios_base::floatfield) == ios_base::scientific)
	format_char = flags () & ios_base::uppercase ? 'E' : 'e';
      else
	format_char = flags () & ios_base::uppercase ? 'G' : 'g';

      int prec = precision ();
      if (prec <= 0 && !(flags () & ios_base::fixed))
	prec = 6; /* default */

      // Do actual conversion.
#ifdef _G_HAVE_PRINTF_FP
      {
	struct printf_info info = { prec: prec,
				    width: width (0),
				    spec: format_char,
				    is_long_double: 0,
				    is_short: 0,
				    is_long: 0,
				    alt: flags () & ios_base::showpoint,
				    space: 0,
				    left: ios_base::left,
				    showsign: flags () & ios_base::showpos,
				    group: 0,
				    pad: fill (),
				    extra: 0};
	const void* ptr = &n;
	if (__printf_fp (rdbuf (), &info, &ptr) < 0)
	  setstate(ios_base::badbit | ios_base::failbit);
      }
#elif defined _IO_USE_DTOA
      if (_IO_outfloat (n, rdbuf (), format_char, width (0), prec, flags (),
			flags () & ios_base::showpos ? '+' : 0, fill ()) < 0)
	setstate (ios_base::badbit | ios_base::failbit); // ??
#else
# if 0
      int fpprec = 0; // 'Extra' (suppressed) floating precision.
      // XXX fixme -- we don't do floating point output, for now.
      // what is MAXFRACT anyway?

      if (prec > MAXFRACT)
	{
	  if (flags () &
	      (ios_base::fixed | ios_base::scientific) &
	      ios_base::showpos)
	    fpprec = prec - MAXFRACT;
	  prec = MAXFRACT;
        }
      int negative;
      char buf[BUF];
      int sign = '\0';
      char* cp = buf;
      *cp = 0;
      int size = __cvt_double (n, prec,
			       flags () & ios_base::showpoint ? 0x80 : 0,
			       &negative,
			       format_char, cp, buf + sizeof (buf));
      if (negative)
	sign = '-';
      else if (flags () & ios_base::showpos)
	sign = '+';
      if (*cp == 0)
	++cp;

      // Calculate padding.
      int fieldsize = size + fpprec;
      if (sign)
	fieldsize++;
      int padding = 0;
      int w = width (0);
      if (fieldsize < w)
	padding = w - fieldsize;

      // Do actual output.
      streambuf* sbuf = rdbuf ();
      // int i;
      char fill_char = fill ();
      ios_base::fmtflags pad_kind = flags () & ios_base::adjustfield;
      if (pad_kind != ios_base::left // Default (right) adjust.
	  && pad_kind != ios_base::internal)
	for (int i = padding; --i >= 0; )
	  sbuf->sputc (fill_char);
      if (sign)
	sbuf->sputc (sign);
      if (pad_kind == ios_base::internal)
	for (int i = padding; --i >= 0; ) sbuf->sputc (fill_char);

      // Emit the actual concented field, followed by extra zeros.
      sbuf->sputn (cp, size);
      for (int i = fpprec; --i >= 0; )
	sbuf->sputc ('0');

      if (pad_kind == ios_base::left) // Left adjustment
	for (int i = padding; --i >= 0; )
	  sbuf->sputc (fill_char);
# endif
#endif
    }
  return *this;
}

#if _G_HAVE_LONG_DOUBLE_IO
template <class _CharT, class _Traits>
basic_ostream<_CharT,_Traits> &
basic_ostream<_Chart,_Traits>::operator << (long double n)
{
  sentry cerb (*this);
  if (cerb)
    {
      int format_char;
      if ((flags () & ios_base::floatfield) == ios_base::fixed)
	format_char = 'f';
      else if ((flags () & ios_base::floatfield) == ios_base::scientific)
	format_char = flags () & ios_base::uppercase ? 'E' : 'e';
      else
	format_char = flags () & ios_base::uppercase ? 'G' : 'g';

      int prec = precision ();
      if (prec <= 0 && !(flags () & ios_base::fixed))
	prec = 6; /* default */

#ifdef _G_HAVE_PRINTF_FP
      // Do actual conversion.
      struct printf_info info = { prec: prec,
				  width: width (0),
				  spec: format_char,
				  is_long_double: 1,
				  is_short: 0,
				  is_long: 0,
				  alt: flags () & ios_base::showpoint,
				  space: 0,
				  left: ios::left,
				  showsign: flags () & ios::showpos,
				  group: 0,
				  pad: fill (),
				  extra: 0 };

      const void* ptr = &n;

      if (__printf_fp (rdbuf (), &info, &ptr) < 0)
	setstate (ios_base::badbit | ios_base::failbit);
#else
// XXX
// # error "long double I/O using dtoa or cvt_double is not implemented"
#endif
    }
  return *this;
}
#endif



#endif /* numerics */

template <class _CharT, class _Traits>
  basic_ostream<_CharT,_Traits>& 
  basic_ostream<_CharT,_Traits>::operator<<(bool __n)
{
  typename basic_ostream<_CharT,_Traits>::sentry cerb(*this);
  if (cerb) {
    // XXX should cache this facet!:
    num_put<_CharT> const& __np = use_facet<num_put<_CharT> >(_M_getloc());
    if (__np.put(*this, *this, this->fill(), __n).failed())
      this->setstate(this->failbit);
  }
  return *this;
}

template <class _CharT, class _Traits>
  basic_ostream<_CharT,_Traits>& 
  basic_ostream<_CharT,_Traits>::operator<<(long __n)
{
  typename basic_ostream<_CharT,_Traits>::sentry cerb(*this);
  if (cerb) {
    // XXX should cache this facet:
    num_put<_CharT> const& __np = use_facet<num_put<_CharT> >(_M_getloc());
    if (__np.put(*this, *this, this->fill(), __n).failed())
      this->setstate(this->failbit);
  }
  return *this;
}

template <class _CharT, class _Traits>
  basic_ostream<_CharT,_Traits>& 
  basic_ostream<_CharT,_Traits>::operator<<(unsigned long __n)
{
  typename basic_ostream<_CharT,_Traits>::sentry cerb(*this);
  if (cerb) {
    // XXX should cache this facet:
    num_put<_CharT> const& __np = use_facet<num_put<_CharT> >(_M_getloc());
    if (__np.put(*this, *this, this->fill(), __n).failed())
      this->setstate(this->failbit);
  }
  return *this;
}

template <class _CharT, class _Traits>
  basic_ostream<_CharT,_Traits>& 
  basic_ostream<_CharT,_Traits>::operator<<(double __n)
{
  typename basic_ostream<_CharT,_Traits>::sentry cerb(*this);
  if (cerb) {
    // XXX should cache this facet:
    num_put<_CharT> const& __np = use_facet<num_put<_CharT> >(_M_getloc());
    if (__np.put(*this, *this, this->fill(), __n).failed())
      this->setstate(this->failbit);
  }
  return *this;
}

template <class _CharT, class _Traits>
  basic_ostream<_CharT,_Traits>& 
  basic_ostream<_CharT,_Traits>::operator<<(long double __n)
{
  typename basic_ostream<_CharT,_Traits>::sentry cerb(*this);
  if (cerb) {
    // XXX should cache this facet:
    num_put<_CharT> const& __np = use_facet<num_put<_CharT> >(_M_getloc());
    if (__np.put(*this, *this, this->fill(), __n).failed())
      this->setstate(this->failbit);
  }
  return *this;
}

template <class _CharT, class _Traits>
  basic_ostream<_CharT,_Traits>& 
  basic_ostream<_CharT,_Traits>::operator<<(const void* __n)
{
  typename basic_ostream<_CharT,_Traits>::sentry cerb(*this);
  if (cerb) {
    // XXX should cache this facet:
    num_put<_CharT> const& __np = use_facet<num_put<_CharT> >(_M_getloc());
    if (__np.put(*this, *this, this->fill(), __n).failed())
      this->setstate(this->failbit);
  }
  return *this;
}


template <class _CharT, class _Traits>
basic_ostream<_CharT,_Traits>&
basic_ostream<_CharT,_Traits>::write (const _CharT* __s, streamsize __n)
{
  sentry __cerb (*this);
  if (__cerb)
    if (this->rdbuf ()->sputn (__s, __n) != __n)
      this->setstate (ios_base::failbit);
  return *this;
}



template <class _CharT, class _Traits>
typename basic_ostream<_CharT,_Traits>::pos_type
basic_ostream<_CharT,_Traits>::tellp ()
{
  streampos __pos =
    this->rdbuf ()->pubseekoff (0, ios_base::cur, ios_base::out);
#if 0
  if (__pos == streampos (traits_type::eof ()))  // XXX all wrong.
    this->setstate (ios_base::badbit);
#endif
  return __pos;
}


template <class _CharT, class _Traits>
basic_ostream<_CharT,_Traits>&
basic_ostream<_CharT,_Traits>::seekp (pos_type __pos)
{
  __pos = this->rdbuf ()->pubseekpos (__pos, ios_base::out);
#if 0
  if (__pos == streampos ()))  // XXX all wrong.
    this->setstate (ios_base::badbit);
#endif
  return *this;
}

template <class _CharT, class _Traits>
basic_ostream<_CharT,_Traits>&
basic_ostream<_CharT,_Traits>::seekp (off_type __off, ios_base::seekdir __dir)
{
  streampos __pos = rdbuf ()->pubseekoff (__off, __dir, this->out);
#if 0
  if (__pos == streampos())  // XXX all wrong.
    setstate (ios_base::badbit);
#endif
  return *this;
}


template <class _CharT, class _Traits>
basic_ostream<_CharT,_Traits>&
basic_ostream<_CharT,_Traits>::flush ()
{
  if (this->rdbuf ()->pubsync ())
    this->setstate (ios_base::badbit);
  return *this;
}

template <class _CharT, class _Traits>
void
basic_ostream<_CharT,_Traits>::_M_do_osfx ()
{
  if (flags () & ios_base::unitbuf)
    this->flush ();
#if 0  /* XXX */
  if (flags () & ios_base::stdio)
    {
      fflush (stdout);
      fflush (stderr);
    }
#endif
}


} // namespace std
