// File based streams -*- C++ -*-

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882: 27.8  File-based streams
//

namespace std
{

  template <class _CharT, class _Traits>
    basic_filebuf<_CharT,_Traits>::
    basic_filebuf(const char* __name, ios_base::openmode __way)
    : streambuf_type(), 
      _M_flags(0), _M_file(NULL), _M_state_cur(), _M_state_beg(), 
      _M_open(false), _M_last_overflowed(false)
    {
      // XXX This is a complete hack.
      try {
	_M_buf = new char_type[_M_buf_size];
      } 
      catch (...) {
	delete [] _M_buf;
	throw;
      }
      this->setg(_M_buf,_M_buf,_M_buf + _M_buf_size);
      this->setp(_M_buf,_M_buf + _M_buf_size);
     
      this->open(__name, __way);
   }

#if 0 
template <class _CharT, class _Traits>
  basic_filebuf<_CharT,_Traits>::
    basic_filebuf()
: _M_fd(-1)
, _M_state(_S_closed)
, _M_unbuffered(false)
, _M_ibuf_size(0)
, _M_ibuffer(0)
, _M_ebuffer(0)
, _M_can_write(false)
{
  try {
    _M_ibuf_size = _S_page_size/sizeof(_CharT);
    _M_ibuffer = new _CharT[_M_ibuf_size];
    _M_ebuffer = new char  [_S_page_size];
  } 
  catch (...) {
    delete [] _M_ibuffer;
    delete [] _M_ebuffer;
    throw;
  }
  this->setg(0,0,0);
  this->setp(0,0);
}


template <class _CharT, class _Traits>
  basic_filebuf<_CharT,_Traits>*
  basic_filebuf<_CharT,_Traits>::
    open(const char* __s, ios_base::openmode __mode)
{
  if (_M_state != _S_closed || (_M_fd = _S_os_raw_open(__s, __mode)) < 0)
    return 0;
  _M_state = _S_seeked;
  _M_can_write = ((__mode & ios_base::out) != 0);
  _M_can_read =  ((__mode & ios_base::in) != 0);
  return this;
}

template <class _CharT, class _Traits>
  void
  basic_filebuf<_CharT,_Traits>::
    _M_open(int __fd, ios_base::openmode __mode)
{
  if (_M_state != _S_closed || __fd < 0)
    return;
  _M_fd = __fd;
  _M_state = _S_seeked;
  _M_can_write = ((__mode & ios_base::out) != 0);
  _M_can_read =  ((__mode & ios_base::in)  != 0);
}

template <class _CharT, class _Traits>
  basic_filebuf<_CharT,_Traits>*
  basic_filebuf<_CharT,_Traits>::
    close ()
{
  if (_M_state == _S_closed)
    return 0;

  if (_M_state == _S_writing)
    this->sync();
  if (0 == _S_os_raw_close(_M_fd))
    return 0;

  _M_state = _S_closed;
  return this;
}

template <class _CharT, class _Traits>
  streamsize
  basic_filebuf<_CharT,_Traits>::
    xsputn(const char_type* __s, streamsize __n)
{
  // XXX far from optimal
  streamsize __i = 0;
  for (;__i < __n; ++__i)
    if (_Traits::eq_int_type(this->sputc(__s[__i]),_Traits::eof()))
      break;
  return __i;
}

template <class _CharT, class _Traits>
  typename _Traits::int_type
  basic_filebuf<_CharT,_Traits>::
    overflow(int_type __c)
{
  if (_M_state == _S_writing) {
    if (!_Traits::eq_int_type(__c,_Traits::eof())) {
      *this->pptr() = _Traits::to_char_type(__c);
      this->pbump(1);  // force it! now pptr() > epptr().
    }
    if (this->pubsync() == -1)
      return _Traits::eof();
  } else if (_M_state == _S_seeked && _M_can_write) {
    if (_M_unbuffered) {
       _M_state = _S_writing;
       _CharT __cb[1] = { _Traits::to_char_type(__c) };
       this->setp(__cb,__cb+1);
       this->pbump(1);
       if (this->pubsync() == -1)
         return _Traits::eof();
    } else {
      _M_state = _S_writing;
      this->setp(_M_ibuffer,_M_ibuffer+_M_ibuf_size-1);
      if (!_Traits::eq_int_type(__c,_Traits::eof())) {
        *this->pptr() = _Traits::to_char_type(__c);
        this->pbump(1);
      }
    }
  } else
     return _Traits::eof();
  return _Traits::not_eof(__c);
}

template <class _CharT, class _Traits>
  int
  basic_filebuf<_CharT,_Traits>::
    sync()
{
  int __result = 0;
  if (_M_state == _S_writing) {
    int __wrote_total = 0;
    int __towrite = this->pptr() - this->pbase();
    if (__towrite) {
#if 0
      if (_M_translating) {
         // XXX use facet codecvt.  Ignore for now.
      }
#endif
      _CharT* __start = this->pbase();
      int __wrote = 0;
      do {
        __wrote = _S_os_raw_write(_M_fd, __start, __towrite);
        if (__wrote == 0) {
          if (__wrote_total) {  // may succeed later with the rest.
             // XXX should be std::memmove
             memmove(this->pbase(), __start, __towrite);
             this->setp(_M_ibuffer, _M_ibuffer+_M_ibuf_size-1);
	     this->pbump(__towrite);
          } 
          return -1;
        }
        __wrote_total += __wrote;
        __start += __wrote;
      } while ((__towrite -= __wrote) != 0);
    }
    _M_state = _S_seeked;
    this->setp(0,0);
  } else if (_M_state == _S_reading) {
     // XXX clear buffer.
  }
  return __result;
}

#endif //981215 bkoz
} // namespace std







