# clang-plugin.m4 -*- Autoconf -*-
# Check clang plugin file.

dnl Copyright (C) 2025 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl
dnl
dnl CLANG_PLUGIN_FILE
dnl    (SHELL-CODE_HANDLER)
dnl
AC_DEFUN([CLANG_PLUGIN_FILE],[dnl
  AC_CACHE_CHECK([for clang], clang_cv_is_clang, [
    AC_EGREP_CPP(yes, [
#ifdef __clang__
  yes
#endif
    ], clang_cv_is_clang=yes, clang_cv_is_clang=no)])
  plugin_file=
  if test $clang_cv_is_clang = yes; then
    AC_MSG_CHECKING([for clang plugin file])
    plugin_names="LLVMgold.so"
    for plugin in $plugin_names; do
      plugin_file=`${CC} ${CFLAGS} --print-file-name $plugin`
      if test x$plugin_file = x$plugin; then
	AC_CHECK_TOOL(LLVM_CONFIG, llvm-config)
	if test "$?" != 0; then
	  AC_MSG_ERROR([Required tool 'llvm-config' not found on PATH.])
	fi
	clang_lib_dir=`$LLVM_CONFIG --libdir`
	if test -f $clang_lib_dir/$plugin; then
	  plugin_file=$clang_lib_dir/$plugin
	fi
	if test x$plugin_file != x$plugin; then
	  break;
	fi
      fi
    done
    if test -z $plugin_file; then
      AC_MSG_ERROR([Couldn't find clang plugin file for $CC.])
    fi
    dnl Check if ${AR} $plugin_option rc works.
    AC_CHECK_TOOL(AR, ar)
    if test "${AR}" = "" ; then
      AC_MSG_ERROR([Required archive tool 'ar' not found on PATH.])
    fi
    plugin_option="--plugin $plugin_file"
    touch conftest.c
    ${AR} $plugin_option rc conftest.a conftest.c
    if test "$?" != 0; then
      AC_MSG_WARN([Failed: $AR $plugin_option rc])
      plugin_file=
    fi
    rm -f conftest.*
    AC_MSG_RESULT($plugin_file)
  fi
  $1="$plugin_file"
])

dnl
dnl
dnl CLANG_PLUGIN_FILE_FOR_TARGET
dnl    (SHELL-CODE_HANDLER)
dnl
AC_DEFUN([CLANG_PLUGIN_FILE_FOR_TARGET],[dnl
  COMPILER_FOR_TARGET="${CC_FOR_TARGET}"
  if test x"${COMPILER_FOR_TARGET}" = x"\$(CC)"; then
    COMPILER_FOR_TARGET="$CC"
  fi
  saved_CC="$CC"
  CC="$COMPILER_FOR_TARGET"
  AC_CACHE_CHECK([for clang for target], clang_target_cv_working, [
    AC_TRY_COMPILE([
#ifndef __clang__
#error Not clang
#endif
    ],
    [],
    clang_target_cv_working=yes, clang_target_cv_working=no)])
  CC="$saved_CC"
  plugin_file=
  if test $clang_target_cv_working = yes; then
    AC_MSG_CHECKING([for clang plugin file for target])
    plugin_names="LLVMgold.so"
    dnl Check if the host compiler is used.
    for plugin in $plugin_names; do
      plugin_file=`${COMPILER_FOR_TARGET} ${CFLAGS_FOR_TARGET} --print-file-name $plugin`
      if test x$plugin_file = x$plugin; then
	GCC_TARGET_TOOL(llvm-config, LLVM_CONFIG_FOR_TARGET, LLVM_CONFIG)
	if test "$?" != 0; then
	  AC_MSG_ERROR([Required target tool 'llvm-config' not found.])
	fi
	clang_lib_dir=`$LLVM_CONFIG_FOR_TARGET --libdir`
	if test -f $clang_lib_dir/$plugin; then
	  plugin_file=$clang_lib_dir/$plugin
	fi
      fi
      if test x$plugin_file != x$plugin; then
	break;
      fi
      plugin_file=
    done
    if test -n $plugin_file; then
      AC_MSG_RESULT($plugin_file)
    else
      AC_MSG_RESULT([no])
    fi
  fi
  $1="$plugin_file"
])
