// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Class:
//   ParticleBCItem
//-----------------------------------------------------------------------------

#ifndef POOMA_PARTICLES_PARTICLEBCITEM_H
#define POOMA_PARTICLES_PARTICLEBCITEM_H

//////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
// Overview: 
//-----------------------------------------------------------------------------
//
// ParticleBCItem is an abstract base class for any boundary condition 
// applied to a Particles object.  The ParticleBCItems are stored in a
// ParticleBCList.  ParticleBCItem provides the virtual interface for
// applying a particle boundary condition.
//
//-----------------------------------------------------------------------------
// Typedefs:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------

#include <iosfwd>

//-----------------------------------------------------------------------------
// Forward Declarations:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//
// Full Description:
//
//-----------------------------------------------------------------------------

class ParticleBCItem
{
public:

  // Constructors.
  ParticleBCItem() {}
  ParticleBCItem(const ParticleBCItem&) {}

  // Destructor.
  virtual ~ParticleBCItem() {}

  // Apply boundary condition, either to all the patches or just
  // to a specified one (if pid < 0, apply to all).
  virtual void applyBoundaryCondition(int pid) = 0;

  inline void applyBoundaryCondition()
    {
      applyBoundaryCondition(-1);
    }

  // Print out to a stream
  virtual void print(std::ostream&) const = 0;
};


// Specialization of operator<< for ParticleBCItem, which invokes print method.

inline
std::ostream&
operator<<(std::ostream& o, const ParticleBCItem& bcitem)
{
  bcitem.print(o);
  return o;
}


#endif     // POOMA_PARTICLES_PARTICLEBCITEM_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: ParticleBCItem.h,v $   $Author: swhaney $
// $Revision: 1.7 $   $Date: 2000/03/07 13:17:49 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
