// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

// -----------------------------------------------------------------------------
// Class:
// MeshTraits
// 
// MeshTraits : Traits class for mesh classes. So far, this is only used to
//              designate whether a mesh class is logically rectilinear, and
//              the only non-null implementations (partial specializations) are
//              for UniformRectilinearMesh and RectilinearMesh. (These serve as
//              the one class template parameter "Mesh" for MeshTraits. The
//              averaging function/functors in r2/src/Field/DiffOps/Average.*
//              use this, for example (currently the only example).
// -----------------------------------------------------------------------------

#ifndef POOMA_MESHES_MESHTRAITS_H
#define POOMA_MESHES_MESHTRAITS_H

//////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
// Overview: 
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Typedefs:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Forward Declarations:
//-----------------------------------------------------------------------------

template<int Dim, class CoordinateSystem, class T>
class RectilinearMesh ;
template<int Dim, class CoordinateSystem, class T>
class UniformRectilinearMesh;
template<class Mesh>
class MeshView;

//-----------------------------------------------------------------------------
//
// Full Description:
//
//-----------------------------------------------------------------------------


// -----------------------------------------------------------------------------
// Generic MeshTraits template
// -----------------------------------------------------------------------------

template<class T>
class MeshTraits
{ 
public:
  static const bool isLogicallyRectilinear = false;
  static const bool isUniform = false;
};


// -----------------------------------------------------------------------------
// MeshTraits partial specializations:
// -----------------------------------------------------------------------------

template<int Dim, class CoordinateSystem, class T>
class MeshTraits<RectilinearMesh<Dim, CoordinateSystem, T> >
{
public:
  static const bool isLogicallyRectilinear = true;
  static const bool isUniform = false;
};

template<int Dim, class CoordinateSystem, class T>
class MeshTraits<UniformRectilinearMesh<Dim, CoordinateSystem, T> >
{
public:
  static const bool isLogicallyRectilinear = true;
  static const bool isUniform = true;
};

template<class Mesh>
class MeshTraits<MeshView<Mesh> >
{
public:
  static const bool isLogicallyRectilinear = 
    MeshTraits<Mesh>::isLogicallyRectilinear;
  static const bool isUniform = MeshTraits<Mesh>::isUniform;
};



//////////////////////////////////////////////////////////////////////

#endif     // POOMA_MESHES_MESHTRAITS_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: MeshTraits.h,v $   $Author: swhaney $
// $Revision: 1.3 $   $Date: 2000/03/07 13:17:40 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
