// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef POOMA_LAYOUT_MULTIPATCHLAYOUTTRAITS_H
#define POOMA_LAYOUT_MULTIPATCHLAYOUTTRAITS_H

//-----------------------------------------------------------------------------
// Classes: 
//   MultiPatchLayoutTraits<LayoutTag,Dim>
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Overview:
//
//   MultiPatchLayoutTraits<LayoutTag,Dim>
//     - a traits class specifying the layout and layout view types for
//       a particular layout tag.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Full Description:
// MultiPatchLayoutTraits<LayoutTag,Dim>
//
// General version of the MultiPatchLayoutTraits class:
// All layouts that are to be used by the MultiPatch-engine need to define 
// a layout tag and specialize this class to define their type and their view
// type.
//-----------------------------------------------------------------------------

// namespace Pooma {

template <class LayoutTag, int Dim>
struct MultiPatchLayoutTraits
{ };

// }; // namespace Pooma

#endif // POOMA_LAYOUT_MULTIPATCHLAYOUTTRAITS_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: MultiPatchLayoutTraits.h,v $   $Author: swhaney $
// $Revision: 1.2 $   $Date: 2000/03/07 13:17:35 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
