// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

// -----------------------------------------------------------------------------
// CommonRectilinearCenterings<Dim,NComponents,Direction> template definitions
// -----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Include files
//-----------------------------------------------------------------------------

#include "Geometry/CenteringTags.h"


// -----------------------------------------------------------------------------
// centering()
// 
// Return the 1D, one-component centering for the requested component along the
// requested direction. Specializations for the cases canned in the
// CommonRectilinearCenterings wrapper class, which is the primary user
// interface. Users will have to provide their own centering() implementations
// for specialized RectilinearCenterings classes outside this canned set.
// -----------------------------------------------------------------------------

// MWERKS: CW4 seems to have trouble putting these definitions in here; for
// now, just put them in the .h file. --TJW 4/6/1999

// template<int Dim, int NComponents, int Direction>
// PoomaRectilinearCentering 
// //trynot static PoomaRectilinearCentering 
// CommonRectilinearCenterings<Dim, NComponents, Direction>::
// AllCell::
// centering(int direction, int component)
// {
//   return cell;
// }
  
// template<int Dim, int NComponents, int Direction>
// static PoomaRectilinearCentering 
// CommonRectilinearCenterings<Dim, NComponents, Direction>::
// AllVertex::
// centering(int direction, int component)
// {
//   return vertex; 
// }

// template<int Dim, int NComponents, int Direction>
// static PoomaRectilinearCentering 
// CommonRectilinearCenterings<Dim, NComponents, Direction>::
// AllFace::
// centering(int direction, int component)
// { 
//   if (direction == Direction) {
//     return vertex;
//   } else {
//     return cell; 
//   }
// }

// template<int Dim, int NComponents, int Direction>
// static PoomaRectilinearCentering 
// CommonRectilinearCenterings<Dim, NComponents, Direction>::
// AllEdge::
// centering(int direction, int component)
// { 
//   if (direction == Direction) {
//     return cell; 
//   } else {
//     return vertex;
//   }
// }

// // The vectorFace and vectorEdge centerings are defined (currently) only for
// // Vectors of Dim components:

// template<int Dim, int NComponents, int Direction>
// static PoomaRectilinearCentering 
// CommonRectilinearCenterings<Dim, NComponents, Direction>::
// VectorFace::
// centering(int direction, int component)
// { 
//   PAssert(Dim == NComponents);
//   if (direction == component) {
//     return vertex;
//   } else {
//     return cell; 
//   }
// }

// template<int Dim, int NComponents, int Direction>
// static PoomaRectilinearCentering 
// CommonRectilinearCenterings<Dim, NComponents, Direction>::
// VectorEdge::
// centering(int direction, int component)
// {
//   PAssert(Dim == NComponents);
//   if (direction == component) {
//     return cell; 
//   } else {
//     return vertex;
//   }
// }


// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: CenteringTags.cpp,v $   $Author: swhaney $
// $Revision: 1.3 $   $Date: 2000/03/07 13:17:21 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
