// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Tests ConstantFaceBC
//-----------------------------------------------------------------------------

#include "Pooma/Fields.h"

#include <iostream>

int main(int argc, char *argv[])
{
  Pooma::initialize(argc, argv);
  
  UniformRectilinearMesh<2> mesh(6,6);
  DiscreteGeometry< Vert, UniformRectilinearMesh<2> > geom(mesh);
  Field< DiscreteGeometry< Vert, UniformRectilinearMesh<2> > > 
    a(geom);

  //   a = 3.0;
  //notyet  Interval<1> I(6);
  //notyet  Interval<1> J(6);
  //notyet  a = I + J;
  for (int i=0; i<6; i++) {
    for (int j=0; j<6; j++) {
      a(i,j) = i + j;
    }
  }
  std::cout << a << std::endl;

  // ConstantFaceBC, scalar (double) constant:
  ConstantFaceBC<double> zf(1, 42.0);
  
  BCondItem *bcScalar = zf.create(a);  
  
  Range<1> r(0,4), s(0,5);
  Range<2> rs(r, s), ss(s, s);
  
  bcScalar->notifyPreRead(rs);
  std::cout << a << std::endl;
  
  bcScalar->notifyPreRead(ss);
  std::cout << a << std::endl;
  
  Field< DiscreteGeometry< Vert, UniformRectilinearMesh<2> >, Vector<3> > 
    b(geom);

  //  b = Vector<3>(1.0, 2.0, 3.0);
  //notyet  Array<2,Loc<2>,CoordinateLattice> coordinates;
  //notyet  b = coordinates.comp(0) + coordinates.comp(1);
  for (int i=0; i<6; i++) {
    for (int j=0; j<6; j++) {
      for (int c=0; c<3; c++) {
	(b.comp(c))(i,j) = i + j + c;
      }
    }
  }
  std::cout << b << std::endl;
  
  // ConstantFaceBC, whole-vector ==> Vector<3,double> constant type :

  BCondList vbc;

  // Make ConstantFaceBC BCs:

  // Low Y face:
  Vector<3,double> vConstant2(-62,-63,-64);
  vbc.addBoundaryCondition(b,
    ConstantFaceBC< Vector<3,double> >(2, vConstant2));

  // High Y face:
  Vector<3,double> vConstant3(-72,-73,-74);
  vbc.addBoundaryCondition(b,
    ConstantFaceBC< Vector<3,double> >(3, vConstant3));
  
  // Low X face:
  Vector<3,double> vConstant0(-42,-43,-44);
  vbc.addBoundaryCondition(b,
    ConstantFaceBC< Vector<3,double> >(0, vConstant0));

  // High X face:
  Vector<3,double> vConstant1(-52,-53,-54);
  vbc.addBoundaryCondition(b,
    ConstantFaceBC< Vector<3,double> >(1, vConstant1));

  vbc.notifyPreRead(rs);
  std::cout << b << std::endl;
  
  vbc.notifyPreRead(ss);
  std::cout << b << std::endl;
  
  Pooma::finalize();

  return 0;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: bc_test3.cpp,v $   $Author: swhaney $
// $Revision: 1.7 $   $Date: 2000/03/07 13:16:15 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
