// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
// ----------------------------------------------------------------------
// Delete test #1.
//-----------------------------------------------------------------------------

#include "Utilities/algorithms.h"
#include "Utilities/Tester.h"
#include "Pooma/Pooma.h"

#include <algorithm>
#include <iostream>
#include <map>
#include <vector>

int randN(int n);

void test(Pooma::Tester &t, int numElements);

int main(int argc, char *argv[])
{
  Pooma::initialize(argc, argv);

  Pooma::Tester tester(argc, argv);

  test(tester, 0);
  test(tester, 1);
  test(tester, 10);
  test(tester, 15);

  int res = tester.results("find_most_common_test1 " );
  Pooma::finalize();

  return res;
}

// Generate a random number in the range [1,...,N]:

int randN(int n)
{
  return int(1 + n*(double(std::rand())/RAND_MAX));
}

// Test function.

void test(Pooma::Tester &t, int numElements)
{  
  std::vector<int> v;
  std::map<int, int> m;
  
  int i;
  for (i = 0; i < numElements; i++)
    {
      int e = randN(numElements);
      v.push_back(e);
      std::map<int, int>::iterator ei = m.find(e);
      if (ei != m.end())
        (*ei).second += 1;
      else
        m[e] = 1;
    }
  
  std::sort(v.begin(), v.end());
  for (i = 0; i < numElements; i++)
    t.out() << v[i] << " ";
  t.out() << std::endl;
      
  std::vector<int>::iterator mc = 
    Pooma::Algorithms::find_most_common(v.begin(), v.end());

  if (numElements == 0)
    // TMP    t.check("zero length", mc, v.end());
    t.check ("zero length", mc == v.end());
  else
    {  
      int cmc, nmc = -1;
      std::map<int, int>::const_iterator j = m.begin();
      while (j != m.end())
        {
          if ((*j).second > nmc)
            {
              nmc = (*j).second;
              cmc = (*j).first;
            }
          t.out() << (*j).first << ":" << (*j).second << " ";
          ++j;
        }
  
      t.out() << std::endl;  
      t.check("most common", *mc, cmc);
    }
}
