// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Class:
// ExpressionTraits
// ExpressionIsScalar
//-----------------------------------------------------------------------------

#ifndef POOMA_PETE_EXPRESSIONTRAITS_H
#define POOMA_PETE_EXPRESSIONTRAITS_H

//////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
// Overview: 
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Typedefs:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------

#include "PETE/PETE.h"

//-----------------------------------------------------------------------------
// Forward Declarations:
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//
// Full Description:
//
// ExpressionTraits<Expr>::Type_t is a traits class for expression objects.
// We use it to determine if an expression is an array expression or a field
// expression to decide what kind of object to wrap the expression inside.
//-----------------------------------------------------------------------------

template<class T>
struct ExpressionTraits
{
  // Some default here seems to be necessary.
  typedef void Type_t;
};

//-----------------------------------------------------------------------------
// ExpressionIsScalar is the return type for scalar expression objects.
//-----------------------------------------------------------------------------

struct ExpressionIsScalar { };

template<class T>
struct ExpressionTraits<Scalar<T> >
{
  typedef ExpressionIsScalar Type_t;
};

//-----------------------------------------------------------------------------
// CombineExpressionTraits<Trait1,Trait2>::Type_t is used to describe
// the result of various expression types.  If we ever decide to something
// wacky like sin(field) is a field but field+field is not, then we will
// have to replace this concept with a general ForEach computation.
//-----------------------------------------------------------------------------

template<class A, class B>
struct CombineExpressionTraits
{ };

//-----------------------------------------------------------------------------
// Determine the ExpressionTraits for all the expression objects:
//-----------------------------------------------------------------------------

template<class T>
struct ExpressionTraits<Reference<T> >
{
  typedef typename ExpressionTraits<T>::Type_t Type_t;
};

template<class Op, class Child>
struct ExpressionTraits<UnaryNode<Op, Child> >
{
  typedef typename ExpressionTraits<Child>::Type_t Type_t;
};

template<class Op, class Left, class Right>
struct ExpressionTraits<BinaryNode<Op, Left, Right> >
{
  typedef typename ExpressionTraits<Left>::Type_t  Left_t;
  typedef typename ExpressionTraits<Right>::Type_t Right_t;
  typedef typename CombineExpressionTraits<Left_t, Right_t>::Type_t Type_t;
};

template<class Op, class Left, class Middle, class Right>
struct ExpressionTraits<TrinaryNode<Op, Left, Middle, Right> >
{
  typedef typename ExpressionTraits<Left>::Type_t    Left_t;
  typedef typename ExpressionTraits<Middle>::Type_t  Middle_t;
  typedef typename ExpressionTraits<Right>::Type_t   Right_t;
  typedef typename CombineExpressionTraits<Left_t, Right_t>::Type_t Temp_t;
  typedef typename CombineExpressionTraits<Temp_t, Middle_t>::Type_t Type_t;
};

//////////////////////////////////////////////////////////////////////

#endif     // POOMA_PETE_EXPRESSIONTRAITS_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: ExpressionTraits.h,v $   $Author: swhaney $
// $Revision: 1.3 $   $Date: 2000/07/20 15:39:28 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
