// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// These helper functions are used to determine if a particular location
// or region of a object is defined. For all objects _not_ based
// on SparseTileLayout, simply return true. 
// For STL based objects, do a touches, and if anything is found, return true
// otherwise return false. 
//
// For Expression Engines, use the EngineFunctor to search the expression
// tree and do logic on the result. 
//
// Used in PrintArray....
//-----------------------------------------------------------------------------

template <class LayoutTag, class PatchTag>
struct MultiPatch;

template <class LayoutTag, class PatchTag, int Dim2>
struct MultiPatchView;

template<class Expr>
struct ExpressionTag;

#include "Engine/Engine.h"
#include "PETE/PETE.h"
#include "Utilities/WrappedInt.h"
#include "Engine/EngineFunctor.h"
#include "Layout/SparseTileLayout.h"

template<int Dim >
struct IsValid
{
  IsValid(Loc<Dim> loc) : loc_m(loc) { }
  typedef AndCombine Combine_t;
  Loc<Dim> loc_m;
};

//-----------------------------------------------------------------------------
// Scalars are always valid.
//-----------------------------------------------------------------------------

template<class T, int Dim>
struct EngineFunctorScalar<T, IsValid<Dim> >
{
  typedef bool Type_t;
  static inline
  Type_t apply(const T &, const IsValid<Dim> &)
  {
    return true;
  }
};

template<class Engine, int Dim>
struct EngineFunctorDefault<Engine, IsValid<Dim> >
{
  typedef bool  Type_t;
  static inline
  Type_t apply(const Engine &, const IsValid<Dim> &)
  {
    return true;
  }
};

template<int Dim,class T,class ptag>
struct EngineFunctor<Engine<Dim, T,MultiPatch<SparseTileTag,ptag> >, IsValid<Dim> >
{
  typedef Engine<Dim,T,MultiPatch<SparseTileTag,ptag> > Engine_t;

  typedef bool Type_t;

  static inline
  Type_t apply(const Engine_t &e, const IsValid<Dim> &f)
  {
    typedef typename Engine_t::Domain_t domain_t;
    typedef Node<domain_t,domain_t> node_t;
    std::vector<node_t> v;
    int count = e.layout().touches(f.loc_m,std::back_inserter(v));
    return (count!=0);
  }
};

template<class Object,class Dom,class tag>
inline bool isValidLocation(const Object &,
			    const Dom &,
			    const tag &)
{
 return true;
}
