// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// DomainRemoveOverlap test: Create Domains and use DomainRO function
//-----------------------------------------------------------------------------
#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"
#include "Domain/Interval.h"
#include "Domain/DomainRemoveOverlap.h"
#include <iostream>
#include <vector>

int main(int argc, char *argv[]) 
{
  // Initialize POOMA and output stream, using Tester class
  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv); 

  Interval<1> a(0,10),b(0,20),r(3,7);
  Interval<2> s(a,b),rr(r,r);
  typedef std::vector<Interval<2> > DomainList_t;
  DomainList_t res;

  tester.out() << " from " << s<< " remove "<<rr<<std::endl;

  res = DomainRemoveOverlap(s,rr);
 
  DomainList_t::iterator start = res.begin();
  DomainList_t::iterator end = res.end();
  for ( ; start!=end ; ++start)
    {
      tester.out() << *start << std::endl;
    }

  res.clear();
  Interval<2> k(Interval<1>(2,3),Interval<1>(-1,30));
  
  res = DomainRemoveOverlap(s,k);


  start = res.begin();
  end = res.end();
  for ( ; start!=end ; ++start)
    {
      tester.out() << *start << std::endl;
    }

  res.clear();

  Interval<2> k2(Interval<1>(2,3),Interval<1>(0,20));

  res = DomainRemoveOverlap(s,k2);
  tester.out() << " " <<std::endl;

  tester.out() <<"from " <<s<<" remove  "<<k2<<std::endl;

  tester.out() << " " <<std::endl;
  start = res.begin();
  end = res.end();
  for ( ; start!=end ; ++start)
    {
      tester.out() << *start << std::endl;
    }


  res.clear();

  Interval<2> k3(Interval<1>(-7,3),Interval<1>(-6,8));

  res = DomainRemoveOverlap(s,k3);
  tester.out() << " " <<std::endl;

  tester.out() <<"from "<< s<<"  remove "<<k3<<std::endl;

  tester.out() << " " <<std::endl;
  start = res.begin();
  end = res.end();
  for ( ; start!=end ; ++start)
    {
      tester.out() << *start << std::endl;
    }

  tester.out() << "-------------------------------------------" << std::endl;
  int retval = tester.results("DomainRO operations");
  Pooma::finalize();
  return retval;

}
		
		     
	      
	 
