# set up standard environment at start of each makefile.
# ACL:license
#  ----------------------------------------------------------------------
#  This software and ancillary information (herein called "SOFTWARE")
#  called POOMA (Parallel Object-Oriented Methods and Applications) is
#  made available under the terms described here.  The SOFTWARE has been
#  approved for release with associated LA-CC Number LA-CC-98-65.
#  
#  Unless otherwise indicated, this SOFTWARE has been authored by an
#  employee or employees of the University of California, operator of the
#  Los Alamos National Laboratory under Contract No.  W-7405-ENG-36 with
#  the U.S. Department of Energy.  The U.S. Government has rights to use,
#  reproduce, and distribute this SOFTWARE, and to allow others to do so.
#  The public may copy and use this SOFTWARE, FOR NONCOMMERCIAL USE ONLY,
#  without charge, provided that this Notice and any statement of
#  authorship are reproduced on all copies.  Neither the Government nor
#  the University makes any warranty, express or implied, or assumes any
#  liability or responsibility for the use of this SOFTWARE.
#  
#  If SOFTWARE is modified to produce derivative works, such modified
#  SOFTWARE should be clearly marked, so as not to confuse it with the
#  version available from LANL.
#  
#  For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
#  or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
#  ----------------------------------------------------------------------
# ACL:license

# NOTE: PROJECT_ROOT must be set before this file is included!!!

PROJECT      = POOMA

SHARED_ROOT  = $(PROJECT_ROOT)/config/Shared
CONFIG_ROOT  = $(PROJECT_ROOT)/config
SCRIPTS_ROOT = $(SHARED_ROOT)

ifndef TMPDIR
TMPDIR       = /tmp
endif

ifdef POOMASUITE
SUITE = $(POOMASUITE)
endif

ifndef SUITE
SUITE        := $(shell $(SHARED_ROOT)/findsuite.sh $(PROJECT_ROOT))
endif

LIBRARY_ROOT = $(PROJECT_ROOT)/lib/$(SUITE)

include $(SHARED_ROOT)/variables.mk

include $(CONFIG_ROOT)/$(SUITE).suite.mk

include include.mk


# ACL:rcsinfo
#  ----------------------------------------------------------------------
#  $RCSfile: head.mk,v $   $Author: julianc $
#  $Revision: 1.6 $   $Date: 1999/07/21 04:56:08 $
#  ----------------------------------------------------------------------
# ACL:rcsinfo
