#!/usr/bin/env perl 
# ACL:license
#  ----------------------------------------------------------------------
#  This software and ancillary information (herein called "SOFTWARE")
#  called POOMA (Parallel Object-Oriented Methods and Applications) is
#  made available under the terms described here.  The SOFTWARE has been
#  approved for release with associated LA-CC Number LA-CC-98-65.
#  
#  Unless otherwise indicated, this SOFTWARE has been authored by an
#  employee or employees of the University of California, operator of the
#  Los Alamos National Laboratory under Contract No.  W-7405-ENG-36 with
#  the U.S. Department of Energy.  The U.S. Government has rights to use,
#  reproduce, and distribute this SOFTWARE, and to allow others to do so.
#  The public may copy and use this SOFTWARE, FOR NONCOMMERCIAL USE ONLY,
#  without charge, provided that this Notice and any statement of
#  authorship are reproduced on all copies.  Neither the Government nor
#  the University makes any warranty, express or implied, or assumes any
#  liability or responsibility for the use of this SOFTWARE.
#  
#  If SOFTWARE is modified to produce derivative works, such modified
#  SOFTWARE should be clearly marked, so as not to confuse it with the
#  version available from LANL.
#  
#  For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
#  or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
#  ----------------------------------------------------------------------
# ACL:license

#####################################################################
#
# Prettify the link or compile commands by breaking them into 
# continued lines.
#
# Assumes we're reading just 1 line from stdin. Writes 1 or more
# lines to stdout.
#
# laa, 6/9/97
#####################################################################
local($DEBUG) = 0;
local($generic_target) = "<YOUR_TAGET_HERE>";
local($mode)  = shift(@ARGV);
local($target)= shift(@ARGV);
if ($DEBUG) {
	print "DEBUG = $DEBUG\n";
	print "mode  = $mode\n";
	print "target= $target\n";
}

$_ = <STDIN>;
if ($DEBUG) {
	print "-------------- Original Command Line --------------\n";
	print;
}

if ($mode =~ /ld/i) {		# clean up loader output
	s/ -L/ \\\n-L/g;
	s/\.o /.o \\\n/g;
	s/\.a /.a \\\n/g;
	s/ -l/ \\\n-l/g;
	s/ -o/ \\\n-o/g;
	s/ -I/ \\\n-I/g;	# These shouldn't be here, but...
}
elsif ($mode =~ /cc/i) {	# clean up compiler output
	s/ -o/ \\\n-o/g;
	s/ -I/ \\\n-I/g;
	s/ -D/ \\\n-D/;
#	s/(-I\S*)(.*)/$1 \\\n$2\n/g;	# put -I on a line by itself
#	s/(-I\S*)(.*)/$1 \n$2\n/g;	# put -I on a line by itself
	s/(-o \S*)(.*)/$1 \\\n$2\n/g;	# put -o on a line by itself
	s/\n (-.*)/\n$1/g;		# remove leading spaces
}
elsif ($mode =~ /ar/i) {	# clean up archiver output
	s/\.o /.o \\\n/g;
	s/\.a /.a \\\n/g;
}
else {
	print "Unknown mode for $ARGV[0]\n";
}
s/;/; \\\n/g;			# add newline to command separators
s/-o +${target}/-o ${generic_target}/g if ($target);	# substitute generic target description
s/-o ${generic_target} *(\W+)/-o ${generic_target} \\\n$1/g;	# substitute generic target description
s/\n\n/\n/g;				# remove completely blank lines
s/^\s*\\\s*$/\\/g;				# remove blank continued lines
s/\n \\//g;				# remove blank continued lines
$_ .= "\n";

if ($DEBUG) { print "\n-------------- Prettified Command Line --------------\n"; }
print;
if ($DEBUG) { print "-----------------------------------------------------\n"; }

print "\n\n";

# ACL:rcsinfo
#  ----------------------------------------------------------------------
#  $RCSfile: pretty.pl,v $   $Author: julianc $
#  $Revision: 1.10 $   $Date: 1999/07/21 22:19:35 $
#  ----------------------------------------------------------------------
# ACL:rcsinfo
