; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=loop-unroll -unroll-verify-domtree -verify-dom-info -S %s | FileCheck %s

define void @test() {
; CHECK-LABEL: @test(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    br label [[LOOP_LATCH:%.*]]
; CHECK:       loop.latch:
; CHECK-NEXT:    br i1 true, label [[LOOP_HEADER_1:%.*]], label [[LOOP_EXIT:%.*]]
; CHECK:       loop.header.1:
; CHECK-NEXT:    br i1 true, label [[EXIT_LOOPEXIT:%.*]], label [[LOOP_LATCH_1:%.*]]
; CHECK:       loop.latch.1:
; CHECK-NEXT:    br label [[LOOP_EXIT]]
; CHECK:       loop.exit:
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       exit.loopexit:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %exitcond = phi i1 [ true, %loop.latch ], [ false, %entry ]
  br i1 %exitcond, label %exit, label %loop.latch

loop.latch:
  br i1 true, label %loop.header, label %loop.exit

loop.exit:
  br label %exit

exit:
  ret void
}

define void @exiting_terminator_is_switch() {
; CHECK-LABEL: @exiting_terminator_is_switch(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    switch i1 true, label [[LOOP_BACKEDGE:%.*]] [
; CHECK-NEXT:    i1 true, label [[EXIT:%.*]]
; CHECK-NEXT:    i1 false, label [[LOOP_BACKEDGE]]
; CHECK-NEXT:    ]
; CHECK:       loop.backedge:
; CHECK-NEXT:    unreachable
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
bb:
  br label %loop

loop:
  switch i1 true, label %loop [
  i1 true, label %exit
  i1 false, label %loop
  ]

exit:
  ret void
}
