; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=r600-- -mcpu=redwood | FileCheck %s --check-prefixes=R600

define amdgpu_kernel void @build_vector2 (ptr addrspace(1) %out) {
; R600-LABEL: build_vector2:
; R600:       ; %bb.0: ; %entry
; R600-NEXT:    ALU 4, @4, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    ALU clause starting at 4:
; R600-NEXT:     MOV * T0.Y, literal.x,
; R600-NEXT:    6(8.407791e-45), 0(0.000000e+00)
; R600-NEXT:     MOV T0.X, literal.x,
; R600-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; R600-NEXT:    5(7.006492e-45), 2(2.802597e-45)
entry:
  store <2 x i32> <i32 5, i32 6>, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @build_vector4 (ptr addrspace(1) %out) {
; R600-LABEL: build_vector4:
; R600:       ; %bb.0: ; %entry
; R600-NEXT:    ALU 8, @4, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    ALU clause starting at 4:
; R600-NEXT:     MOV * T0.W, literal.x,
; R600-NEXT:    8(1.121039e-44), 0(0.000000e+00)
; R600-NEXT:     MOV * T0.Z, literal.x,
; R600-NEXT:    7(9.809089e-45), 0(0.000000e+00)
; R600-NEXT:     MOV * T0.Y, literal.x,
; R600-NEXT:    6(8.407791e-45), 0(0.000000e+00)
; R600-NEXT:     MOV T0.X, literal.x,
; R600-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; R600-NEXT:    5(7.006492e-45), 2(2.802597e-45)
entry:
  store <4 x i32> <i32 5, i32 6, i32 7, i32 8>, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @build_vector_v2i16 (ptr addrspace(1) %out) {
; R600-LABEL: build_vector_v2i16:
; R600:       ; %bb.0: ; %entry
; R600-NEXT:    ALU 2, @4, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.X, T5.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    ALU clause starting at 4:
; R600-NEXT:     MOV T4.X, literal.x,
; R600-NEXT:     LSHR * T5.X, KC0[2].Y, literal.y,
; R600-NEXT:    393221(5.510200e-40), 2(2.802597e-45)
entry:
  store <2 x i16> <i16 5, i16 6>, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @build_vector_v2i16_trunc (ptr addrspace(1) %out, i32 %a) {
; R600-LABEL: build_vector_v2i16_trunc:
; R600:       ; %bb.0:
; R600-NEXT:    ALU 4, @4, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T4.X, T5.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    ALU clause starting at 4:
; R600-NEXT:     LSHR * T0.W, KC0[2].Z, literal.x,
; R600-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; R600-NEXT:     OR_INT T4.X, PV.W, literal.x,
; R600-NEXT:     LSHR * T5.X, KC0[2].Y, literal.y,
; R600-NEXT:    327680(4.591775e-40), 2(2.802597e-45)
  %srl = lshr i32 %a, 16
  %trunc = trunc i32 %srl to i16
  %ins.0 = insertelement <2 x i16> poison, i16 %trunc, i32 0
  %ins.1 = insertelement <2 x i16> %ins.0, i16 5, i32 1
  store <2 x i16> %ins.1, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @build_v2i32_from_v4i16_shuffle(ptr addrspace(1) %out, <4 x i16> %in) {
; R600-LABEL: build_v2i32_from_v4i16_shuffle:
; R600:       ; %bb.0: ; %entry
; R600-NEXT:    ALU 0, @10, KC0[], KC1[]
; R600-NEXT:    TEX 1 @6
; R600-NEXT:    ALU 4, @11, KC0[CB0:0-32], KC1[]
; R600-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; R600-NEXT:    CF_END
; R600-NEXT:    PAD
; R600-NEXT:    Fetch clause starting at 6:
; R600-NEXT:     VTX_READ_16 T1.X, T0.X, 48, #3
; R600-NEXT:     VTX_READ_16 T0.X, T0.X, 44, #3
; R600-NEXT:    ALU clause starting at 10:
; R600-NEXT:     MOV * T0.X, 0.0,
; R600-NEXT:    ALU clause starting at 11:
; R600-NEXT:     LSHL * T0.Y, T1.X, literal.x,
; R600-NEXT:    16(2.242078e-44), 0(0.000000e+00)
; R600-NEXT:     LSHL T0.X, T0.X, literal.x,
; R600-NEXT:     LSHR * T1.X, KC0[2].Y, literal.y,
; R600-NEXT:    16(2.242078e-44), 2(2.802597e-45)
entry:
  %shuf = shufflevector <4 x i16> %in, <4 x i16> zeroinitializer, <2 x i32> <i32 0, i32 2>
  %zextended = zext <2 x i16> %shuf to <2 x i32>
  %shifted = shl <2 x i32> %zextended, <i32 16, i32 16>
  store <2 x i32> %shifted, ptr addrspace(1) %out
  ret void
}
