; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc < %s | FileCheck %s
; RUN: llc -aarch64-sve-vector-bits-min=256 < %s | FileCheck %s
; RUN: llc -aarch64-sve-vector-bits-min=512 < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

define <32 x i8> @test_v32i8(<32 x i8> %unused, <32 x i8> %a) #0 {
; CHECK-LABEL: test_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v1.16b, v3.16b
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    ret
  ret <32 x i8> %a
}

define <16 x i16> @test_v16i16(<16 x i16> %unused, <16 x i16> %a) #0 {
; CHECK-LABEL: test_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v1.16b, v3.16b
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    ret
  ret <16 x i16> %a
}

define <8 x i32> @test_v8i32(<8 x i32> %unused, <8 x i32> %a) #0 {
; CHECK-LABEL: test_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v1.16b, v3.16b
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    ret
  ret <8 x i32> %a
}

define <4 x i64> @test_v4i64(<4 x i64> %unused, <4 x i64> %a) #0 {
; CHECK-LABEL: test_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v1.16b, v3.16b
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    ret
  ret <4 x i64> %a
}

define <16 x half> @test_v16f16(<16 x half> %unused, <16 x half> %a) #0 {
; CHECK-LABEL: test_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v1.16b, v3.16b
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    ret
  ret <16 x half> %a
}

define <8 x float> @test_v8f32(<8 x float> %unused, <8 x float> %a) #0 {
; CHECK-LABEL: test_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v1.16b, v3.16b
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    ret
  ret <8 x float> %a
}

define <4 x double> @test_v4f64(<4 x double> %unused, <4 x double> %a) #0 {
; CHECK-LABEL: test_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v1.16b, v3.16b
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    ret
  ret <4 x double> %a
}

define <16 x bfloat> @test_v16bf16(<16 x bfloat> %unused, <16 x bfloat> %a) #0 {
; CHECK-LABEL: test_v16bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v1.16b, v3.16b
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    ret
  ret <16 x bfloat> %a
}

define <3 x i64> @test_v3i64(<3 x i64> %unused, <3 x i64> %a) #0 {
; CHECK-LABEL: test_v3i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov d2, d5
; CHECK-NEXT:    fmov d1, d4
; CHECK-NEXT:    fmov d0, d3
; CHECK-NEXT:    ret
  ret <3 x i64> %a
}

define <5 x i64> @test_v5i64(<5 x i64> %unused, <5 x i64> %a) #0 {
; CHECK-LABEL: test_v5i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov d1, d6
; CHECK-NEXT:    fmov d0, d5
; CHECK-NEXT:    fmov d2, d7
; CHECK-NEXT:    ldp d3, d4, [sp]
; CHECK-NEXT:    ret
  ret <5 x i64> %a
}

define <1 x i16> @test_v1i16(<1 x i16> %unused, <1 x i16> %a) #0 {
; CHECK-LABEL: test_v1i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov d0, d1
; CHECK-NEXT:    ret
  ret <1 x i16> %a
}

define <9 x i16> @test_v9i16(<9 x i16> %unused, <9 x i16> %a) #0 {
; CHECK-LABEL: test_v9i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr h0, [sp, #8]
; CHECK-NEXT:    add x9, sp, #16
; CHECK-NEXT:    ld1 { v0.h }[1], [x9]
; CHECK-NEXT:    add x9, sp, #24
; CHECK-NEXT:    ld1 { v0.h }[2], [x9]
; CHECK-NEXT:    add x9, sp, #32
; CHECK-NEXT:    ld1 { v0.h }[3], [x9]
; CHECK-NEXT:    add x9, sp, #40
; CHECK-NEXT:    ld1 { v0.h }[4], [x9]
; CHECK-NEXT:    add x9, sp, #48
; CHECK-NEXT:    ld1 { v0.h }[5], [x9]
; CHECK-NEXT:    add x9, sp, #56
; CHECK-NEXT:    ld1 { v0.h }[6], [x9]
; CHECK-NEXT:    add x9, sp, #64
; CHECK-NEXT:    ld1 { v0.h }[7], [x9]
; CHECK-NEXT:    ldrh w9, [sp, #72]
; CHECK-NEXT:    strh w9, [x8, #16]
; CHECK-NEXT:    str q0, [x8]
; CHECK-NEXT:    ret
  ret <9 x i16> %a
}

define <16 x i1> @test_v16i1(<16 x i1> %unused, <16 x i1> %a) #0 {
; CHECK-LABEL: test_v16i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
  ret <16 x i1> %a
}

; UTC_ARGS: --disable
; The output from this test is large and generally not useful, what matters is
; no vector registers are used.
define <32 x i1> @test_v32i1(<32 x i1> %unused, <32 x i1> %a) #0 {
; CHECK-LABEL: test_v32i1:
; CHECK:       // %bb.0:
; CHECK-NOT:     [q,v,z][0-9]+
; CHECK:         ret
  ret <32 x i1> %a
}
; UTC_ARGS: --enable

define <1 x i128> @test_v1i128(<1 x i128> %unused, <1 x i128> %a) #0 {
; CHECK-LABEL: test_v1i128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x1, x3
; CHECK-NEXT:    mov x0, x2
; CHECK-NEXT:    ret
  ret <1 x i128> %a
}

define <2 x i128> @test_v2i128(<2 x i128> %unused, <2 x i128> %a) #0 {
; CHECK-LABEL: test_v2i128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x3, x7
; CHECK-NEXT:    mov x2, x6
; CHECK-NEXT:    mov x0, x4
; CHECK-NEXT:    mov x1, x5
; CHECK-NEXT:    ret
  ret <2 x i128> %a
}

define <1 x i256> @test_v1i256(<1 x i256> %unused, <1 x i256> %a) #0 {
; CHECK-LABEL: test_v1i256:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x3, x7
; CHECK-NEXT:    mov x2, x6
; CHECK-NEXT:    mov x0, x4
; CHECK-NEXT:    mov x1, x5
; CHECK-NEXT:    ret
  ret <1 x i256> %a
}

define <2 x i256> @test_v2i256(<2 x i256> %unused, <2 x i256> %a) #0 {
; CHECK-LABEL: test_v2i256:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp x0, x1, [sp]
; CHECK-NEXT:    ldp x2, x3, [sp, #16]
; CHECK-NEXT:    ldp x4, x5, [sp, #32]
; CHECK-NEXT:    ldp x6, x7, [sp, #48]
; CHECK-NEXT:    ret
  ret <2 x i256> %a
}

define <1 x fp128> @test_v1f128(<1 x fp128> %unused, <1 x fp128> %a) #0 {
; CHECK-LABEL: test_v1f128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
  ret <1 x fp128> %a
}

define <2 x fp128> @test_v2f128(<2 x fp128> %unused, <2 x fp128> %a) #0 {
; CHECK-LABEL: test_v2f128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov v1.16b, v3.16b
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    ret
  ret <2 x fp128> %a
}

attributes #0 = { "target-features"="+sve,+bf16" }
