; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -mtriple=x86_64-unknown-unknown --show-mc-encoding -mattr=+avx10.2-256 | FileCheck %s --check-prefixes=X64
; RUN: llc < %s -verify-machineinstrs -mtriple=i686-unknown-unknown --show-mc-encoding -mattr=+avx10.2-256 | FileCheck %s --check-prefixes=X86

define <8 x bfloat> @test_int_x86_avx10_vminmaxbf16128(<8 x bfloat> %A, <8 x bfloat> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vminmaxbf16128:
; X64:       # %bb.0:
; X64-NEXT:    vminmaxbf16 $127, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7f,0x08,0x52,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vminmaxbf16128:
; X86:       # %bb.0:
; X86-NEXT:    vminmaxbf16 $127, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7f,0x08,0x52,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x bfloat> @llvm.x86.avx10.vminmaxbf16128(<8 x bfloat> %A, <8 x bfloat> %B, i32 127)
  ret <8 x bfloat> %ret
}

define <8 x bfloat> @test_int_x86_avx10_mask_vminmaxbf16128(<8 x bfloat> %A, <8 x bfloat> %B, <8 x bfloat> %C, i8 %D) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vminmaxbf16128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxbf16 $127, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0x7f,0x09,0x52,0xd1,0x7f]
; X64-NEXT:    vmovdqa %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x6f,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vminmaxbf16128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxbf16 $127, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0x7f,0x09,0x52,0xd1,0x7f]
; X86-NEXT:    vmovdqa %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x6f,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = call <8 x bfloat> @llvm.x86.avx10.vminmaxbf16128(<8 x bfloat> %A, <8 x bfloat> %B, i32 127)
  %1 = bitcast i8 %D to <8 x i1>
  %2 = select reassoc nsz arcp contract afn <8 x i1> %1, <8 x bfloat> %0, <8 x bfloat> %C
  ret <8 x bfloat> %2
}

declare <8 x bfloat> @llvm.x86.avx10.vminmaxbf16128(<8 x bfloat> %A, <8 x bfloat> %B, i32 %C)

define <8 x bfloat> @test_int_x86_avx10_maskz_vminmaxbf16128(<8 x bfloat> %A, <8 x bfloat> %B, i8 %C) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vminmaxbf16128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxbf16 $127, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0x7f,0x89,0x52,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vminmaxbf16128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxbf16 $127, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0x7f,0x89,0x52,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = call <8 x bfloat> @llvm.x86.avx10.vminmaxbf16128(<8 x bfloat> %A, <8 x bfloat> %B, i32 127)
  %1 = bitcast i8 %C to <8 x i1>
  %2 = select reassoc nsz arcp contract afn <8 x i1> %1, <8 x bfloat> %0, <8 x bfloat> zeroinitializer
  ret <8 x bfloat> %2
}

define <16 x bfloat> @test_int_x86_avx10_vminmaxbf16256(<16 x bfloat> %A, <16 x bfloat> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vminmaxbf16256:
; X64:       # %bb.0:
; X64-NEXT:    vminmaxbf16 $127, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x7f,0x28,0x52,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vminmaxbf16256:
; X86:       # %bb.0:
; X86-NEXT:    vminmaxbf16 $127, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x7f,0x28,0x52,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %ret = call <16 x bfloat> @llvm.x86.avx10.vminmaxbf16256(<16 x bfloat> %A, <16 x bfloat> %B, i32 127)
  ret <16 x bfloat> %ret
}

define <16 x bfloat> @test_int_x86_avx10_mask_vminmaxbf16256(<16 x bfloat> %A, <16 x bfloat> %B, <16 x bfloat> %C, i16 %D) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vminmaxbf16256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxbf16 $127, %ymm1, %ymm0, %ymm2 {%k1} # encoding: [0x62,0xf3,0x7f,0x29,0x52,0xd1,0x7f]
; X64-NEXT:    vmovdqa %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfd,0x6f,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vminmaxbf16256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxbf16 $127, %ymm1, %ymm0, %ymm2 {%k1} # encoding: [0x62,0xf3,0x7f,0x29,0x52,0xd1,0x7f]
; X86-NEXT:    vmovdqa %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfd,0x6f,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = call <16 x bfloat> @llvm.x86.avx10.vminmaxbf16256(<16 x bfloat> %A, <16 x bfloat> %B, i32 127)
  %1 = bitcast i16 %D to <16 x i1>
  %2 = select reassoc nsz arcp contract afn <16 x i1> %1, <16 x bfloat> %0, <16 x bfloat> %C
  ret <16 x bfloat> %2
}

declare <16 x bfloat> @llvm.x86.avx10.vminmaxbf16256(<16 x bfloat> %A, <16 x bfloat> %B, i32 %C)

define <16 x bfloat> @test_int_x86_avx10_maskz_vminmaxbf16256(<16 x bfloat> %A, <16 x bfloat> %B, i16 %C) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vminmaxbf16256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxbf16 $127, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x7f,0xa9,0x52,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vminmaxbf16256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxbf16 $127, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x7f,0xa9,0x52,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = call <16 x bfloat> @llvm.x86.avx10.vminmaxbf16256(<16 x bfloat> %A, <16 x bfloat> %B, i32 127)
  %1 = bitcast i16 %C to <16 x i1>
  %2 = select reassoc nsz arcp contract afn <16 x i1> %1, <16 x bfloat> %0, <16 x bfloat> zeroinitializer
  ret <16 x bfloat> %2
}

define <2 x double> @test_int_x86_avx10_vminmaxpd128(<2 x double> %A, <2 x double> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vminmaxpd128:
; X64:       # %bb.0:
; X64-NEXT:    vminmaxpd $127, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0xfd,0x08,0x52,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vminmaxpd128:
; X86:       # %bb.0:
; X86-NEXT:    vminmaxpd $127, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0xfd,0x08,0x52,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <2 x double> @llvm.x86.avx10.mask.vminmaxpd128(<2 x double> %A, <2 x double> %B, i32 127, <2 x double> zeroinitializer, i8 -1)
  ret <2 x double> %ret
}

define <2 x double> @test_int_x86_avx10_mask_vminmaxpd128(<2 x double> %A, <2 x double> %B, <2 x double> %C, i8 %D) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vminmaxpd128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxpd $127, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0xfd,0x09,0x52,0xd1,0x7f]
; X64-NEXT:    vmovapd %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vminmaxpd128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxpd $127, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0xfd,0x09,0x52,0xd1,0x7f]
; X86-NEXT:    vmovapd %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <2 x double> @llvm.x86.avx10.mask.vminmaxpd128(<2 x double> %A, <2 x double> %B, i32 127, <2 x double> %C, i8 %D)
  ret <2 x double> %ret
}

declare <2 x double> @llvm.x86.avx10.mask.vminmaxpd128(<2 x double> %A, <2 x double> %B, i32 %C, <2 x double> %D, i8 %E)

define <2 x double> @test_int_x86_avx10_maskz_vminmaxpd128(<2 x double> %A, <2 x double> %B, i8 %C) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vminmaxpd128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxpd $127, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0xfd,0x89,0x52,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vminmaxpd128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxpd $127, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0xfd,0x89,0x52,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <2 x double> @llvm.x86.avx10.mask.vminmaxpd128(<2 x double> %A, <2 x double> %B, i32 127, <2 x double> zeroinitializer, i8 %C)
  ret <2 x double> %ret
}

define <4 x double> @test_int_x86_avx10_vminmaxpd256(<4 x double> %A, <4 x double> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vminmaxpd256:
; X64:       # %bb.0:
; X64-NEXT:    vminmaxpd $127, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf3,0xfd,0x28,0x52,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vminmaxpd256:
; X86:       # %bb.0:
; X86-NEXT:    vminmaxpd $127, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf3,0xfd,0x28,0x52,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vminmaxpd256(<4 x double> %A, <4 x double> %B, i32 127, <4 x double> zeroinitializer, i8 -1)
  ret <4 x double> %ret
}

define <4 x double> @test_int_x86_avx10_mask_vminmaxpd256(<4 x double> %A, <4 x double> %B, <4 x double> %C, i8 %D) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vminmaxpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxpd $127, %ymm1, %ymm0, %ymm2 {%k1} # encoding: [0x62,0xf3,0xfd,0x29,0x52,0xd1,0x7f]
; X64-NEXT:    vmovapd %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfd,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vminmaxpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxpd $127, %ymm1, %ymm0, %ymm2 {%k1} # encoding: [0x62,0xf3,0xfd,0x29,0x52,0xd1,0x7f]
; X86-NEXT:    vmovapd %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfd,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vminmaxpd256(<4 x double> %A, <4 x double> %B, i32 127, <4 x double> %C, i8 %D)
  ret <4 x double> %ret
}

declare <4 x double> @llvm.x86.avx10.mask.vminmaxpd256(<4 x double> %A, <4 x double> %B, i32 %C, <4 x double> %D, i8 %E)

define <4 x double> @test_int_x86_avx10_maskz_vminmaxpd256(<4 x double> %A, <4 x double> %B, i8 %C) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vminmaxpd256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxpd $127, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0xfd,0xa9,0x52,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vminmaxpd256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxpd $127, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0xfd,0xa9,0x52,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <4 x double> @llvm.x86.avx10.mask.vminmaxpd256(<4 x double> %A, <4 x double> %B, i32 127, <4 x double> zeroinitializer, i8 %C)
  ret <4 x double> %ret
}

define <8 x half> @test_int_x86_avx10_vminmaxph128(<8 x half> %A, <8 x half> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vminmaxph128:
; X64:       # %bb.0:
; X64-NEXT:    vminmaxph $127, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7c,0x08,0x52,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vminmaxph128:
; X86:       # %bb.0:
; X86-NEXT:    vminmaxph $127, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7c,0x08,0x52,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vminmaxph128(<8 x half> %A, <8 x half> %B, i32 127, <8 x half> zeroinitializer, i8 -1)
  ret <8 x half> %ret
}


define <8 x half> @test_int_x86_avx10_mask_vminmaxph128(<8 x half> %A, <8 x half> %B, <8 x half> %C, i8 %D) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vminmaxph128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxph $127, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0x7c,0x09,0x52,0xd1,0x7f]
; X64-NEXT:    vmovaps %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vminmaxph128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxph $127, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0x7c,0x09,0x52,0xd1,0x7f]
; X86-NEXT:    vmovaps %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vminmaxph128(<8 x half> %A, <8 x half> %B, i32 127, <8 x half> %C, i8 %D)
  ret <8 x half> %ret
}

declare <8 x half> @llvm.x86.avx10.mask.vminmaxph128(<8 x half> %A, <8 x half> %B, i32 %C, <8 x half> %D, i8 %E)

define <8 x half> @test_int_x86_avx10_maskz_vminmaxph128(<8 x half> %A, <8 x half> %B, i8 %C) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vminmaxph128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxph $127, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0x7c,0x89,0x52,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vminmaxph128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxph $127, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0x7c,0x89,0x52,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vminmaxph128(<8 x half> %A, <8 x half> %B, i32 127, <8 x half> zeroinitializer, i8 %C)
  ret <8 x half> %ret
}

define <16 x half> @test_int_x86_avx10_vminmaxph256(<16 x half> %A, <16 x half> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vminmaxph256:
; X64:       # %bb.0:
; X64-NEXT:    vminmaxph $127, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x7c,0x28,0x52,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vminmaxph256:
; X86:       # %bb.0:
; X86-NEXT:    vminmaxph $127, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x7c,0x28,0x52,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vminmaxph256(<16 x half> %A, <16 x half> %B, i32 127, <16 x half> zeroinitializer, i16 -1)
  ret <16 x half> %ret
}

declare <16 x half> @llvm.x86.avx10.vminmaxph256(<16 x half> %A, <16 x half> %B, i32 %C)

define <16 x half> @test_int_x86_avx10_mask_vminmaxph256(<16 x half> %A, <16 x half> %B, <16 x half> %C, i16 %D) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vminmaxph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxph $127, %ymm1, %ymm0, %ymm2 {%k1} # encoding: [0x62,0xf3,0x7c,0x29,0x52,0xd1,0x7f]
; X64-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vminmaxph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxph $127, %ymm1, %ymm0, %ymm2 {%k1} # encoding: [0x62,0xf3,0x7c,0x29,0x52,0xd1,0x7f]
; X86-NEXT:    vmovaps %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfc,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vminmaxph256(<16 x half> %A, <16 x half> %B, i32 127, <16 x half> %C, i16 %D)
  ret <16 x half> %ret
}

declare <16 x half> @llvm.x86.avx10.mask.vminmaxph256(<16 x half> %A, <16 x half> %B, i32 %C, <16 x half> %D, i16 %E)

define <16 x half> @test_int_x86_avx10_maskz_vminmaxph256(<16 x half> %A, <16 x half> %B, i16 %C) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vminmaxph256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxph $127, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x7c,0xa9,0x52,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vminmaxph256:
; X86:       # %bb.0:
; X86-NEXT:    kmovw {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf8,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxph $127, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x7c,0xa9,0x52,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <16 x half> @llvm.x86.avx10.mask.vminmaxph256(<16 x half> %A, <16 x half> %B, i32 127, <16 x half> zeroinitializer, i16 %C)
  ret <16 x half> %ret
}

define <4 x float> @test_int_x86_avx10_vminmaxps128(<4 x float> %A, <4 x float> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vminmaxps128:
; X64:       # %bb.0:
; X64-NEXT:    vminmaxps $127, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7d,0x08,0x52,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vminmaxps128:
; X86:       # %bb.0:
; X86-NEXT:    vminmaxps $127, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7d,0x08,0x52,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <4 x float> @llvm.x86.avx10.mask.vminmaxps128(<4 x float> %A, <4 x float> %B, i32 127, <4 x float> zeroinitializer, i8 -1)
  ret <4 x float> %ret
}


define <4 x float> @test_int_x86_avx10_mask_vminmaxps128(<4 x float> %A, <4 x float> %B, <4 x float> %C, i8 %D) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vminmaxps128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxps $127, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0x7d,0x09,0x52,0xd1,0x7f]
; X64-NEXT:    vmovapd %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vminmaxps128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxps $127, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0x7d,0x09,0x52,0xd1,0x7f]
; X86-NEXT:    vmovapd %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <4 x float> @llvm.x86.avx10.mask.vminmaxps128(<4 x float> %A, <4 x float> %B, i32 127, <4 x float> %C, i8 %D)
  ret <4 x float> %ret
}

declare <4 x float> @llvm.x86.avx10.mask.vminmaxps128(<4 x float> %A, <4 x float> %B, i32 %C, <4 x float> %D, i8 %E)

define <4 x float> @test_int_x86_avx10_maskz_vminmaxps128(<4 x float> %A, <4 x float> %B, i8 %C) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vminmaxps128:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxps $127, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0x7d,0x89,0x52,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vminmaxps128:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxps $127, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0x7d,0x89,0x52,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <4 x float> @llvm.x86.avx10.mask.vminmaxps128(<4 x float> %A, <4 x float> %B, i32 127, <4 x float> zeroinitializer, i8 %C)
  ret <4 x float> %ret
}

define <8 x float> @test_int_x86_avx10_vminmaxps256(<8 x float> %A, <8 x float> %B) nounwind {
; X64-LABEL: test_int_x86_avx10_vminmaxps256:
; X64:       # %bb.0:
; X64-NEXT:    vminmaxps $127, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x7d,0x28,0x52,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_vminmaxps256:
; X86:       # %bb.0:
; X86-NEXT:    vminmaxps $127, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x7d,0x28,0x52,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vminmaxps256(<8 x float> %A, <8 x float> %B, i32 127, <8 x float> zeroinitializer, i8 -1)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_avx10_mask_vminmaxps256(<8 x float> %A, <8 x float> %B, <8 x float> %C, i8 %D) nounwind {
; X64-LABEL: test_int_x86_avx10_mask_vminmaxps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxps $127, %ymm1, %ymm0, %ymm2 {%k1} # encoding: [0x62,0xf3,0x7d,0x29,0x52,0xd1,0x7f]
; X64-NEXT:    vmovapd %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfd,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_vminmaxps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxps $127, %ymm1, %ymm0, %ymm2 {%k1} # encoding: [0x62,0xf3,0x7d,0x29,0x52,0xd1,0x7f]
; X86-NEXT:    vmovapd %ymm2, %ymm0 # EVEX TO VEX Compression encoding: [0xc5,0xfd,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vminmaxps256(<8 x float> %A, <8 x float> %B, i32 127, <8 x float> %C, i8 %D)
  ret <8 x float> %ret
}

declare <8 x float> @llvm.x86.avx10.mask.vminmaxps256(<8 x float> %A, <8 x float> %B, i32 %C, <8 x float> %D, i8 %E)

define <8 x float> @test_int_x86_avx10_maskz_vminmaxps256(<8 x float> %A, <8 x float> %B, i8 %C) nounwind {
; X64-LABEL: test_int_x86_avx10_maskz_vminmaxps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxps $127, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x7d,0xa9,0x52,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_vminmaxps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxps $127, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x7d,0xa9,0x52,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vminmaxps256(<8 x float> %A, <8 x float> %B, i32 127, <8 x float> zeroinitializer, i8 %C)
  ret <8 x float> %ret
}

define <8 x float >@test_int_x86_vminmaxps256(<8 x float> %A, <8 x float> %B) nounwind {
; X64-LABEL: test_int_x86_vminmaxps256:
; X64:       # %bb.0:
; X64-NEXT:    vminmaxps $127, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x7d,0x28,0x52,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_vminmaxps256:
; X86:       # %bb.0:
; X86-NEXT:    vminmaxps $127, %ymm1, %ymm0, %ymm0 # encoding: [0x62,0xf3,0x7d,0x28,0x52,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vminmaxps256(<8 x float> %A, <8 x float> %B, i32 127, <8 x float> poison, i8 -1)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_mask_vminmaxps256(<8 x float> %C, <8 x float> %A, <8 x float> %B, i8 %D) nounwind {
; X64-LABEL: test_int_x86_mask_vminmaxps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxps $127, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0x75,0x29,0x52,0xc2,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vminmaxps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxps $127, %ymm2, %ymm1, %ymm0 {%k1} # encoding: [0x62,0xf3,0x75,0x29,0x52,0xc2,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vminmaxps256(<8 x float> %A, <8 x float> %B, i32 127, <8 x float> %C, i8 %D)
  ret <8 x float> %ret
}

define <8 x float> @test_int_x86_maskz_vminmaxps256(<8 x float> %A, <8 x float> %B, i8 %C) nounwind {
; X64-LABEL: test_int_x86_maskz_vminmaxps256:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxps $127, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x7d,0xa9,0x52,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vminmaxps256:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxps $127, %ymm1, %ymm0, %ymm0 {%k1} {z} # encoding: [0x62,0xf3,0x7d,0xa9,0x52,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x float> @llvm.x86.avx10.mask.vminmaxps256(<8 x float> %A, <8 x float> %B, i32 127, <8 x float> zeroinitializer, i8 %C)
  ret <8 x float> %ret
}

define <2 x double>@test_int_x86_vminmaxsd(<2 x double> %A, <2 x double> %B) nounwind {
; X64-LABEL: test_int_x86_vminmaxsd:
; X64:       # %bb.0:
; X64-NEXT:    vminmaxsd $127, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0xfd,0x08,0x53,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_vminmaxsd:
; X86:       # %bb.0:
; X86-NEXT:    vminmaxsd $127, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0xfd,0x08,0x53,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <2 x double> @llvm.x86.avx10.mask.vminmaxsd.round(<2 x double> %A, <2 x double> %B, i32 127, <2 x double> poison, i8 -1, i32 4)
  ret <2 x double> %ret
}

define <2 x double>@test_int_x86_mask_vminmaxsd(<2 x double> %A, <2 x double> %B, <2 x double> %C, i8 %D) nounwind {
; X64-LABEL: test_int_x86_mask_vminmaxsd:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxsd $127, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0xfd,0x09,0x53,0xd1,0x7f]
; X64-NEXT:    vmovapd %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vminmaxsd:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxsd $127, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0xfd,0x09,0x53,0xd1,0x7f]
; X86-NEXT:    vmovapd %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <2 x double> @llvm.x86.avx10.mask.vminmaxsd.round(<2 x double> %A, <2 x double> %B, i32 127, <2 x double> %C, i8 %D, i32 4)
  ret <2 x double> %ret
}

define <2 x double>@test_int_x86_maskz_vminmaxsd(<2 x double> %A, <2 x double> %B, i8 %C) nounwind {
; X64-LABEL: test_int_x86_maskz_vminmaxsd:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxsd $127, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0xfd,0x89,0x53,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vminmaxsd:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxsd $127, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0xfd,0x89,0x53,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <2 x double> @llvm.x86.avx10.mask.vminmaxsd.round(<2 x double> %A, <2 x double> %B, i32 127, <2 x double> zeroinitializer, i8 %C, i32 4)
  ret <2 x double> %ret
}

define <2 x double>@test_int_x86_vminmaxsd_round(<2 x double> %A, <2 x double> %B) nounwind {
; X64-LABEL: test_int_x86_vminmaxsd_round:
; X64:       # %bb.0:
; X64-NEXT:    vminmaxsd $127, {sae}, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0xfd,0x18,0x53,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_vminmaxsd_round:
; X86:       # %bb.0:
; X86-NEXT:    vminmaxsd $127, {sae}, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0xfd,0x18,0x53,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <2 x double> @llvm.x86.avx10.mask.vminmaxsd.round(<2 x double> %A, <2 x double> %B, i32 127, <2 x double> poison, i8 -1, i32 8)
  ret <2 x double> %ret
}

define <2 x double>@test_int_x86_mask_vminmaxsd_round(<2 x double> %A, <2 x double> %B, <2 x double> %C, i8 %D) nounwind {
; X64-LABEL: test_int_x86_mask_vminmaxsd_round:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxsd $127, {sae}, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0xfd,0x19,0x53,0xd1,0x7f]
; X64-NEXT:    vmovapd %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vminmaxsd_round:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxsd $127, {sae}, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0xfd,0x19,0x53,0xd1,0x7f]
; X86-NEXT:    vmovapd %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf9,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <2 x double> @llvm.x86.avx10.mask.vminmaxsd.round(<2 x double> %A, <2 x double> %B, i32 127, <2 x double> %C, i8 %D, i32 8)
  ret <2 x double> %ret
}

define <2 x double>@test_int_x86_maskz_vminmaxsd_round(<2 x double> %A, <2 x double> %B, i8 %C) nounwind {
; X64-LABEL: test_int_x86_maskz_vminmaxsd_round:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxsd $127, {sae}, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0xfd,0x99,0x53,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vminmaxsd_round:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxsd $127, {sae}, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0xfd,0x99,0x53,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <2 x double> @llvm.x86.avx10.mask.vminmaxsd.round(<2 x double> %A, <2 x double> %B, i32 127, <2 x double> zeroinitializer, i8 %C, i32 8)
  ret <2 x double> %ret
}

declare<2 x double> @llvm.x86.avx10.mask.vminmaxsd.round(<2 x double> %A, <2 x double> %B, i32 %C, <2 x double> %D, i8 %E, i32 %F)

define <8 x half>@test_int_x86_vminmaxsh(<8 x half> %A, <8 x half> %B) nounwind {
; X64-LABEL: test_int_x86_vminmaxsh:
; X64:       # %bb.0:
; X64-NEXT:    vminmaxsh $127, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7c,0x08,0x53,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_vminmaxsh:
; X86:       # %bb.0:
; X86-NEXT:    vminmaxsh $127, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7c,0x08,0x53,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vminmaxsh.round(<8 x half> %A, <8 x half> %B, i32 127, <8 x half> poison, i8 -1, i32 4)
  ret <8 x half> %ret
}

define <8 x half>@test_int_x86_mask_vminmaxsh(<8 x half> %A, <8 x half> %B, <8 x half> %C, i8 %D) nounwind {
; X64-LABEL: test_int_x86_mask_vminmaxsh:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxsh $127, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0x7c,0x09,0x53,0xd1,0x7f]
; X64-NEXT:    vmovaps %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vminmaxsh:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxsh $127, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0x7c,0x09,0x53,0xd1,0x7f]
; X86-NEXT:    vmovaps %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vminmaxsh.round(<8 x half> %A, <8 x half> %B, i32 127, <8 x half> %C, i8 %D, i32 4)
  ret <8 x half> %ret
}

define <8 x half>@test_int_x86_maskz_vminmaxsh(<8 x half> %A, <8 x half> %B, i8 %C) nounwind {
; X64-LABEL: test_int_x86_maskz_vminmaxsh:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxsh $127, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0x7c,0x89,0x53,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vminmaxsh:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxsh $127, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0x7c,0x89,0x53,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vminmaxsh.round(<8 x half> %A, <8 x half> %B, i32 127, <8 x half> zeroinitializer, i8 %C, i32 4)
  ret <8 x half> %ret
}

define <8 x half>@test_int_x86_vminmaxsh_round(<8 x half> %A, <8 x half> %B) nounwind {
; X64-LABEL: test_int_x86_vminmaxsh_round:
; X64:       # %bb.0:
; X64-NEXT:    vminmaxsh $127, {sae}, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7c,0x18,0x53,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_vminmaxsh_round:
; X86:       # %bb.0:
; X86-NEXT:    vminmaxsh $127, {sae}, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7c,0x18,0x53,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vminmaxsh.round(<8 x half> %A, <8 x half> %B, i32 127, <8 x half> poison, i8 -1, i32 8)
  ret <8 x half> %ret
}

define <8 x half>@test_int_x86_mask_vminmaxsh_round(<8 x half> %A, <8 x half> %B, <8 x half> %C, i8 %D) nounwind {
; X64-LABEL: test_int_x86_mask_vminmaxsh_round:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxsh $127, {sae}, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0x7c,0x19,0x53,0xd1,0x7f]
; X64-NEXT:    vmovaps %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vminmaxsh_round:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxsh $127, {sae}, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0x7c,0x19,0x53,0xd1,0x7f]
; X86-NEXT:    vmovaps %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vminmaxsh.round(<8 x half> %A, <8 x half> %B, i32 127, <8 x half> %C, i8 %D, i32 8)
  ret <8 x half> %ret
}

define <8 x half>@test_int_x86_maskz_vminmaxsh_round(<8 x half> %A, <8 x half> %B, i8 %C) nounwind {
; X64-LABEL: test_int_x86_maskz_vminmaxsh_round:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxsh $127, {sae}, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0x7c,0x99,0x53,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vminmaxsh_round:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxsh $127, {sae}, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0x7c,0x99,0x53,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <8 x half> @llvm.x86.avx10.mask.vminmaxsh.round(<8 x half> %A, <8 x half> %B, i32 127, <8 x half> zeroinitializer, i8 %C, i32 8)
  ret <8 x half> %ret
}

declare<8 x half> @llvm.x86.avx10.mask.vminmaxsh.round(<8 x half> %A, <8 x half> %B, i32 %C, <8 x half> %D, i8 %E, i32 %F)

define <4 x float>@test_int_x86_vminmaxss(<4 x float> %A, <4 x float> %B) nounwind {
; X64-LABEL: test_int_x86_vminmaxss:
; X64:       # %bb.0:
; X64-NEXT:    vminmaxss $127, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7d,0x08,0x53,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_vminmaxss:
; X86:       # %bb.0:
; X86-NEXT:    vminmaxss $127, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7d,0x08,0x53,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <4 x float> @llvm.x86.avx10.mask.vminmaxss.round(<4 x float> %A, <4 x float> %B, i32 127, <4 x float> poison, i8 -1, i32 4)
  ret <4 x float> %ret
}

define <4 x float>@test_int_x86_mask_vminmaxss(<4 x float> %A, <4 x float> %B, <4 x float> %C, i8 %D) nounwind {
; X64-LABEL: test_int_x86_mask_vminmaxss:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxss $127, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0x7d,0x09,0x53,0xd1,0x7f]
; X64-NEXT:    vmovaps %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vminmaxss:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxss $127, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0x7d,0x09,0x53,0xd1,0x7f]
; X86-NEXT:    vmovaps %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <4 x float> @llvm.x86.avx10.mask.vminmaxss.round(<4 x float> %A, <4 x float> %B, i32 127, <4 x float> %C, i8 %D, i32 4)
  ret <4 x float> %ret
}

define <4 x float>@test_int_x86_maskz_vminmaxss(<4 x float> %A, <4 x float> %B, i8 %C) nounwind {
; X64-LABEL: test_int_x86_maskz_vminmaxss:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxss $127, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0x7d,0x89,0x53,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vminmaxss:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxss $127, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0x7d,0x89,0x53,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <4 x float> @llvm.x86.avx10.mask.vminmaxss.round(<4 x float> %A, <4 x float> %B, i32 127, <4 x float> zeroinitializer, i8 %C, i32 4)
  ret <4 x float> %ret
}

define <4 x float>@test_int_x86_vminmaxss_round(<4 x float> %A, <4 x float> %B) nounwind {
; X64-LABEL: test_int_x86_vminmaxss_round:
; X64:       # %bb.0:
; X64-NEXT:    vminmaxss $127, {sae}, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7d,0x18,0x53,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_vminmaxss_round:
; X86:       # %bb.0:
; X86-NEXT:    vminmaxss $127, {sae}, %xmm1, %xmm0, %xmm0 # encoding: [0x62,0xf3,0x7d,0x18,0x53,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <4 x float> @llvm.x86.avx10.mask.vminmaxss.round(<4 x float> %A, <4 x float> %B, i32 127, <4 x float> poison, i8 -1, i32 8)
  ret <4 x float> %ret
}

define <4 x float>@test_int_x86_mask_vminmaxss_round(<4 x float> %A, <4 x float> %B, <4 x float> %C, i8 %D) nounwind {
; X64-LABEL: test_int_x86_mask_vminmaxss_round:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxss $127, {sae}, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0x7d,0x19,0x53,0xd1,0x7f]
; X64-NEXT:    vmovaps %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_mask_vminmaxss_round:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxss $127, {sae}, %xmm1, %xmm0, %xmm2 {%k1} # encoding: [0x62,0xf3,0x7d,0x19,0x53,0xd1,0x7f]
; X86-NEXT:    vmovaps %xmm2, %xmm0 # EVEX TO VEX Compression encoding: [0xc5,0xf8,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <4 x float> @llvm.x86.avx10.mask.vminmaxss.round(<4 x float> %A, <4 x float> %B, i32 127, <4 x float> %C, i8 %D, i32 8)
  ret <4 x float> %ret
}

define <4 x float>@test_int_x86_maskz_vminmaxss_round(<4 x float> %A, <4 x float> %B, i8 %C) nounwind {
; X64-LABEL: test_int_x86_maskz_vminmaxss_round:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminmaxss $127, {sae}, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0x7d,0x99,0x53,0xc1,0x7f]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_maskz_vminmaxss_round:
; X86:       # %bb.0:
; X86-NEXT:    kmovb {{[0-9]+}}(%esp), %k1 # encoding: [0xc5,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminmaxss $127, {sae}, %xmm1, %xmm0, %xmm0 {%k1} {z} # encoding: [0x62,0xf3,0x7d,0x99,0x53,0xc1,0x7f]
; X86-NEXT:    retl # encoding: [0xc3]
  %ret = call <4 x float> @llvm.x86.avx10.mask.vminmaxss.round(<4 x float> %A, <4 x float> %B, i32 127, <4 x float> zeroinitializer, i8 %C, i32 8)
  ret <4 x float> %ret
}

declare<4 x float> @llvm.x86.avx10.mask.vminmaxss.round(<4 x float> %A, <4 x float> %B, i32 %C, <4 x float> %D, i8 %E, i32 %F)
