; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64 -mattr=+sve2p1 < %s | FileCheck %s
; RUN: llc -mtriple=aarch64 -mattr=+sme2 -force-streaming < %s | FileCheck %s
; RUN: llc -mtriple=aarch64 -mattr=+sme,+sve2p1 -force-streaming < %s | FileCheck %s

define <vscale x 16 x i1> @pext_b(target("aarch64.svcount") %x) nounwind {
; CHECK-LABEL: pext_b:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    pext p0.b, pn8[2]
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %res = call <vscale x 16 x i1> @llvm.aarch64.sve.pext.nxv16i1(target("aarch64.svcount") %x, i32 2)
  ret <vscale x 16 x i1> %res
}

define <vscale x 8 x i1> @pext_h(target("aarch64.svcount") %x) nounwind {
; CHECK-LABEL: pext_h:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    pext p0.h, pn8[2]
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %res = call <vscale x 8 x i1> @llvm.aarch64.sve.pext.nxv8i1(target("aarch64.svcount") %x, i32 2)
  ret <vscale x 8 x i1> %res
}

define <vscale x 4 x i1> @pext_s(target("aarch64.svcount") %x) nounwind {
; CHECK-LABEL: pext_s:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    pext p0.s, pn8[2]
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %res = call <vscale x 4 x i1> @llvm.aarch64.sve.pext.nxv4i1(target("aarch64.svcount") %x, i32 2)
  ret <vscale x 4 x i1> %res
}

define <vscale x 2 x i1> @pext_d(target("aarch64.svcount") %x) nounwind {
; CHECK-LABEL: pext_d:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    pext p0.d, pn8[2]
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %res = call <vscale x 2 x i1> @llvm.aarch64.sve.pext.nxv2i1(target("aarch64.svcount") %x, i32 2)
  ret <vscale x 2 x i1> %res
}

declare <vscale x 16 x i1> @llvm.aarch64.sve.pext.nxv16i1(target("aarch64.svcount"), i32)
declare <vscale x 8 x i1> @llvm.aarch64.sve.pext.nxv8i1(target("aarch64.svcount"), i32)
declare <vscale x 4 x i1> @llvm.aarch64.sve.pext.nxv4i1(target("aarch64.svcount"), i32)
declare <vscale x 2 x i1> @llvm.aarch64.sve.pext.nxv2i1(target("aarch64.svcount"), i32)

define  {<vscale x 16 x i1>,<vscale x 16 x i1>} @pext_x2_b(target("aarch64.svcount") %x) nounwind {
; CHECK-LABEL: pext_x2_b:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    pext { p0.b, p1.b }, pn8[1]
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %res = call {<vscale x 16 x i1>,<vscale x 16 x i1>} @llvm.aarch64.sve.pext.x2.nxv16i1(target("aarch64.svcount") %x, i32 1)
  ret  {<vscale x 16 x i1>,<vscale x 16 x i1>} %res
}

define {<vscale x 8 x i1>,<vscale x 8 x i1>} @pext_x2_h(target("aarch64.svcount") %x) nounwind {
; CHECK-LABEL: pext_x2_h:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    pext { p0.h, p1.h }, pn8[1]
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %res = call {<vscale x 8 x i1>,<vscale x 8 x i1>} @llvm.aarch64.sve.pext.x2.nxv8i1(target("aarch64.svcount") %x, i32 1)
  ret {<vscale x 8 x i1>,<vscale x 8 x i1>} %res
}

define {<vscale x 4 x i1>,<vscale x 4 x i1>} @pext_x2_s(target("aarch64.svcount") %x) nounwind {
; CHECK-LABEL: pext_x2_s:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    pext { p0.s, p1.s }, pn8[1]
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x i1>,<vscale x 4 x i1>} @llvm.aarch64.sve.pext.x2.nxv4i1(target("aarch64.svcount") %x, i32 1)
  ret {<vscale x 4 x i1>,<vscale x 4 x i1>} %res
}

define {<vscale x 2 x i1>,<vscale x 2 x i1>} @pext_x2_d(target("aarch64.svcount") %x) nounwind {
; CHECK-LABEL: pext_x2_d:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-1
; CHECK-NEXT:    str p8, [sp, #7, mul vl] // 2-byte Folded Spill
; CHECK-NEXT:    mov p8.b, p0.b
; CHECK-NEXT:    pext { p0.d, p1.d }, pn8[1]
; CHECK-NEXT:    ldr p8, [sp, #7, mul vl] // 2-byte Folded Reload
; CHECK-NEXT:    addvl sp, sp, #1
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x i1>,<vscale x 2 x i1>} @llvm.aarch64.sve.pext.x2.nxv2i1(target("aarch64.svcount") %x, i32 1)
  ret {<vscale x 2 x i1>,<vscale x 2 x i1>} %res
}

declare {<vscale x 16 x i1>,<vscale x 16 x i1>} @llvm.aarch64.sve.pext.x2.nxv16i1(target("aarch64.svcount"), i32)
declare {<vscale x 8 x i1>,<vscale x 8 x i1>} @llvm.aarch64.sve.pext.x2.nxv8i1(target("aarch64.svcount"), i32)
declare {<vscale x 4 x i1>,<vscale x 4 x i1>} @llvm.aarch64.sve.pext.x2.nxv4i1(target("aarch64.svcount"), i32)
declare {<vscale x 2 x i1>,<vscale x 2 x i1>} @llvm.aarch64.sve.pext.x2.nxv2i1(target("aarch64.svcount"), i32)

define target("aarch64.svcount") @ptrue_b() nounwind {
; CHECK-LABEL: ptrue_b:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue pn8.b
; CHECK-NEXT:    mov p0.b, p8.b
; CHECK-NEXT:    ret
  %res = call target("aarch64.svcount") @llvm.aarch64.sve.ptrue.c8()
  ret target("aarch64.svcount") %res
}

define target("aarch64.svcount") @ptrue_h() nounwind {
; CHECK-LABEL: ptrue_h:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue pn8.h
; CHECK-NEXT:    mov p0.b, p8.b
; CHECK-NEXT:    ret
  %res = call target("aarch64.svcount") @llvm.aarch64.sve.ptrue.c16()
  ret target("aarch64.svcount") %res
}

define target("aarch64.svcount") @ptrue_s() nounwind {
; CHECK-LABEL: ptrue_s:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue pn8.s
; CHECK-NEXT:    mov p0.b, p8.b
; CHECK-NEXT:    ret
  %res = call target("aarch64.svcount") @llvm.aarch64.sve.ptrue.c32()
  ret target("aarch64.svcount") %res
}

define target("aarch64.svcount") @ptrue_d() nounwind {
; CHECK-LABEL: ptrue_d:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue pn8.d
; CHECK-NEXT:    mov p0.b, p8.b
; CHECK-NEXT:    ret
  %res = call target("aarch64.svcount") @llvm.aarch64.sve.ptrue.c64()
  ret target("aarch64.svcount") %res
}

declare target("aarch64.svcount") @llvm.aarch64.sve.ptrue.c8()
declare target("aarch64.svcount") @llvm.aarch64.sve.ptrue.c16()
declare target("aarch64.svcount") @llvm.aarch64.sve.ptrue.c32()
declare target("aarch64.svcount") @llvm.aarch64.sve.ptrue.c64()
