; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; sext(A s< B) + zext(A s> B) => scmp(A, B)
define i8 @signed_add(i32 %a, i32 %b) {
; CHECK-LABEL: define i8 @signed_add(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    [[R:%.*]] = call i8 @llvm.scmp.i8.i32(i32 [[A]], i32 [[B]])
; CHECK-NEXT:    ret i8 [[R]]
;
  %lt = icmp slt i32 %a, %b
  %lt8 = sext i1 %lt to i8
  %gt = icmp sgt i32 %a, %b
  %gt8 = zext i1 %gt to i8
  %r = add i8 %lt8, %gt8
  ret i8 %r
}

; Unsigned version
define i8 @unsigned_add(i32 %a, i32 %b) {
; CHECK-LABEL: define i8 @unsigned_add(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    [[R:%.*]] = call i8 @llvm.ucmp.i8.i32(i32 [[A]], i32 [[B]])
; CHECK-NEXT:    ret i8 [[R]]
;
  %lt = icmp ult i32 %a, %b
  %lt8 = sext i1 %lt to i8
  %gt = icmp ugt i32 %a, %b
  %gt8 = zext i1 %gt to i8
  %r = add i8 %lt8, %gt8
  ret i8 %r
}

; Commuted operands
define i8 @signed_add_commuted1(i32 %a, i32 %b) {
; CHECK-LABEL: define i8 @signed_add_commuted1(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    [[R:%.*]] = call i8 @llvm.scmp.i8.i32(i32 [[B]], i32 [[A]])
; CHECK-NEXT:    ret i8 [[R]]
;
  %lt = icmp slt i32 %a, %b
  %lt8 = zext i1 %lt to i8
  %gt = icmp sgt i32 %a, %b
  %gt8 = sext i1 %gt to i8
  %r = add i8 %lt8, %gt8
  ret i8 %r
}

define i8 @signed_add_commuted2(i32 %a, i32 %b) {
; CHECK-LABEL: define i8 @signed_add_commuted2(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    [[R:%.*]] = call i8 @llvm.scmp.i8.i32(i32 [[A]], i32 [[B]])
; CHECK-NEXT:    ret i8 [[R]]
;
  %lt = icmp sgt i32 %b, %a
  %lt8 = sext i1 %lt to i8
  %gt = icmp sgt i32 %a, %b
  %gt8 = zext i1 %gt to i8
  %r = add i8 %lt8, %gt8
  ret i8 %r
}

; zext(A s> B) - zext(A s< B) => scmp(A, B)
define i8 @signed_sub(i32 %a, i32 %b) {
; CHECK-LABEL: define i8 @signed_sub(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    [[R:%.*]] = call i8 @llvm.scmp.i8.i32(i32 [[A]], i32 [[B]])
; CHECK-NEXT:    ret i8 [[R]]
;
  %lt = icmp slt i32 %a, %b
  %lt8 = zext i1 %lt to i8
  %gt = icmp sgt i32 %a, %b
  %gt8 = zext i1 %gt to i8
  %r = sub i8 %gt8, %lt8
  ret i8 %r
}

; Unsigned version
define i8 @unsigned_sub(i32 %a, i32 %b) {
; CHECK-LABEL: define i8 @unsigned_sub(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    [[R:%.*]] = call i8 @llvm.ucmp.i8.i32(i32 [[A]], i32 [[B]])
; CHECK-NEXT:    ret i8 [[R]]
;
  %lt = icmp ult i32 %a, %b
  %lt8 = zext i1 %lt to i8
  %gt = icmp ugt i32 %a, %b
  %gt8 = zext i1 %gt to i8
  %r = sub i8 %gt8, %lt8
  ret i8 %r
}

; Negative test: incorrect predicates
define i8 @signed_add_neg1(i32 %a, i32 %b) {
; CHECK-LABEL: define i8 @signed_add_neg1(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    [[LT:%.*]] = icmp sgt i32 [[A]], [[B]]
; CHECK-NEXT:    [[LT8:%.*]] = sext i1 [[LT]] to i8
; CHECK-NEXT:    [[GT:%.*]] = icmp sgt i32 [[A]], [[B]]
; CHECK-NEXT:    [[GT8:%.*]] = zext i1 [[GT]] to i8
; CHECK-NEXT:    [[R:%.*]] = add nsw i8 [[LT8]], [[GT8]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %lt = icmp sgt i32 %a, %b
  %lt8 = sext i1 %lt to i8
  %gt = icmp sgt i32 %a, %b
  %gt8 = zext i1 %gt to i8
  %r = add i8 %lt8, %gt8
  ret i8 %r
}

define i8 @signed_add_neg2(i32 %a, i32 %b) {
; CHECK-LABEL: define i8 @signed_add_neg2(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    [[LT:%.*]] = icmp slt i32 [[A]], [[B]]
; CHECK-NEXT:    [[LT8:%.*]] = sext i1 [[LT]] to i8
; CHECK-NEXT:    [[GT:%.*]] = icmp ne i32 [[A]], [[B]]
; CHECK-NEXT:    [[GT8:%.*]] = zext i1 [[GT]] to i8
; CHECK-NEXT:    [[R:%.*]] = add nsw i8 [[LT8]], [[GT8]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %lt = icmp slt i32 %a, %b
  %lt8 = sext i1 %lt to i8
  %gt = icmp ne i32 %a, %b
  %gt8 = zext i1 %gt to i8
  %r = add i8 %lt8, %gt8
  ret i8 %r
}

; Negative test: mismatched signedness of predicates
define i8 @signed_add_neg3(i32 %a, i32 %b) {
; CHECK-LABEL: define i8 @signed_add_neg3(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    [[LT:%.*]] = icmp slt i32 [[A]], [[B]]
; CHECK-NEXT:    [[LT8:%.*]] = sext i1 [[LT]] to i8
; CHECK-NEXT:    [[GT:%.*]] = icmp ugt i32 [[A]], [[B]]
; CHECK-NEXT:    [[GT8:%.*]] = zext i1 [[GT]] to i8
; CHECK-NEXT:    [[R:%.*]] = add nsw i8 [[LT8]], [[GT8]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %lt = icmp slt i32 %a, %b
  %lt8 = sext i1 %lt to i8
  %gt = icmp ugt i32 %a, %b
  %gt8 = zext i1 %gt to i8
  %r = add i8 %lt8, %gt8
  ret i8 %r
}

; Negative test: zext instead of sext or vice-versa (NOT commuted operands)
define i8 @signed_add_neg4(i32 %a, i32 %b) {
; CHECK-LABEL: define i8 @signed_add_neg4(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    [[LT:%.*]] = icmp slt i32 [[A]], [[B]]
; CHECK-NEXT:    [[LT8:%.*]] = sext i1 [[LT]] to i8
; CHECK-NEXT:    [[GT:%.*]] = icmp sgt i32 [[A]], [[B]]
; CHECK-NEXT:    [[GT8:%.*]] = sext i1 [[GT]] to i8
; CHECK-NEXT:    [[R:%.*]] = add nsw i8 [[LT8]], [[GT8]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %lt = icmp slt i32 %a, %b
  %lt8 = sext i1 %lt to i8
  %gt = icmp sgt i32 %a, %b
  %gt8 = sext i1 %gt to i8
  %r = add i8 %lt8, %gt8
  ret i8 %r
}

define i8 @signed_add_neg5(i32 %a, i32 %b) {
; CHECK-LABEL: define i8 @signed_add_neg5(
; CHECK-SAME: i32 [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    [[LT:%.*]] = icmp slt i32 [[A]], [[B]]
; CHECK-NEXT:    [[LT8:%.*]] = zext i1 [[LT]] to i8
; CHECK-NEXT:    [[GT:%.*]] = icmp sgt i32 [[A]], [[B]]
; CHECK-NEXT:    [[GT8:%.*]] = zext i1 [[GT]] to i8
; CHECK-NEXT:    [[R:%.*]] = add nuw nsw i8 [[LT8]], [[GT8]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %lt = icmp slt i32 %a, %b
  %lt8 = zext i1 %lt to i8
  %gt = icmp sgt i32 %a, %b
  %gt8 = zext i1 %gt to i8
  %r = add i8 %lt8, %gt8
  ret i8 %r
}
