; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zvfh,+zvfbfmin,+v \
; RUN:     -target-abi=ilp32d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv64 -mattr=+d,+zvfh,+v,+zvfbfmin \
; RUN:     -target-abi=lp64d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv32 -mattr=+d,+zvfhmin,+v,+zvfbfmin \
; RUN:     -target-abi=ilp32d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFHMIN
; RUN: llc -mtriple=riscv64 -mattr=+d,+zvfhmin,+v,+zvfbfmin \
; RUN:     -target-abi=lp64d -verify-machineinstrs < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,ZVFHMIN

define <vscale x 1 x i1> @vfptosi_nxv1bf16_nxv1i1(<vscale x 1 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv1bf16_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vfncvt.rtz.x.f.w v8, v9
; CHECK-NEXT:    vand.vi v8, v8, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 1 x bfloat> %va to <vscale x 1 x i1>
  ret <vscale x 1 x i1> %evec
}

define <vscale x 1 x i7> @vfptosi_nxv1bf16_nxv1i7(<vscale x 1 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv1bf16_nxv1i7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vfncvt.rtz.x.f.w v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 1 x bfloat> %va to <vscale x 1 x i7>
  ret <vscale x 1 x i7> %evec
}

define <vscale x 1 x i7> @vfptoui_nxv1bf16_nxv1i7(<vscale x 1 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv1bf16_nxv1i7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vfncvt.rtz.x.f.w v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 1 x bfloat> %va to <vscale x 1 x i7>
  ret <vscale x 1 x i7> %evec
}

define <vscale x 1 x i1> @vfptoui_nxv1bf16_nxv1i1(<vscale x 1 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv1bf16_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v8, v9
; CHECK-NEXT:    vand.vi v8, v8, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 1 x bfloat> %va to <vscale x 1 x i1>
  ret <vscale x 1 x i1> %evec
}

define <vscale x 1 x i8> @vfptosi_nxv1bf16_nxv1i8(<vscale x 1 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv1bf16_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vfncvt.rtz.x.f.w v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 1 x bfloat> %va to <vscale x 1 x i8>
  ret <vscale x 1 x i8> %evec
}

define <vscale x 1 x i8> @vfptoui_nxv1bf16_nxv1i8(<vscale x 1 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv1bf16_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 1 x bfloat> %va to <vscale x 1 x i8>
  ret <vscale x 1 x i8> %evec
}

define <vscale x 1 x i16> @vfptosi_nxv1bf16_nxv1i16(<vscale x 1 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv1bf16_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vfncvt.rtz.x.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 1 x bfloat> %va to <vscale x 1 x i16>
  ret <vscale x 1 x i16> %evec
}

define <vscale x 1 x i16> @vfptoui_nxv1bf16_nxv1i16(<vscale x 1 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv1bf16_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 1 x bfloat> %va to <vscale x 1 x i16>
  ret <vscale x 1 x i16> %evec
}

define <vscale x 1 x i32> @vfptosi_nxv1bf16_nxv1i32(<vscale x 1 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv1bf16_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v9
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 1 x bfloat> %va to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %evec
}

define <vscale x 1 x i32> @vfptoui_nxv1bf16_nxv1i32(<vscale x 1 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv1bf16_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v9
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 1 x bfloat> %va to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %evec
}

define <vscale x 1 x i64> @vfptosi_nxv1bf16_nxv1i64(<vscale x 1 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv1bf16_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v8, v9
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 1 x bfloat> %va to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %evec
}

define <vscale x 1 x i64> @vfptoui_nxv1bf16_nxv1i64(<vscale x 1 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv1bf16_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v8, v9
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 1 x bfloat> %va to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %evec
}

define <vscale x 2 x i1> @vfptosi_nxv2bf16_nxv2i1(<vscale x 2 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv2bf16_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vfncvt.rtz.x.f.w v8, v9
; CHECK-NEXT:    vand.vi v8, v8, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 2 x bfloat> %va to <vscale x 2 x i1>
  ret <vscale x 2 x i1> %evec
}

define <vscale x 2 x i1> @vfptoui_nxv2bf16_nxv2i1(<vscale x 2 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv2bf16_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v8, v9
; CHECK-NEXT:    vand.vi v8, v8, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 2 x bfloat> %va to <vscale x 2 x i1>
  ret <vscale x 2 x i1> %evec
}

define <vscale x 2 x i8> @vfptosi_nxv2bf16_nxv2i8(<vscale x 2 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv2bf16_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vfncvt.rtz.x.f.w v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 2 x bfloat> %va to <vscale x 2 x i8>
  ret <vscale x 2 x i8> %evec
}

define <vscale x 2 x i8> @vfptoui_nxv2bf16_nxv2i8(<vscale x 2 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv2bf16_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 2 x bfloat> %va to <vscale x 2 x i8>
  ret <vscale x 2 x i8> %evec
}

define <vscale x 2 x i16> @vfptosi_nxv2bf16_nxv2i16(<vscale x 2 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv2bf16_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vfncvt.rtz.x.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 2 x bfloat> %va to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %evec
}

define <vscale x 2 x i16> @vfptoui_nxv2bf16_nxv2i16(<vscale x 2 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv2bf16_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v8, v9
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 2 x bfloat> %va to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %evec
}

define <vscale x 2 x i32> @vfptosi_nxv2bf16_nxv2i32(<vscale x 2 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv2bf16_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v9
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 2 x bfloat> %va to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %evec
}

define <vscale x 2 x i32> @vfptoui_nxv2bf16_nxv2i32(<vscale x 2 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv2bf16_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v9
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 2 x bfloat> %va to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %evec
}

define <vscale x 2 x i64> @vfptosi_nxv2bf16_nxv2i64(<vscale x 2 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv2bf16_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v8, v10
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 2 x bfloat> %va to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %evec
}

define <vscale x 2 x i64> @vfptoui_nxv2bf16_nxv2i64(<vscale x 2 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv2bf16_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v8, v10
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 2 x bfloat> %va to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %evec
}

define <vscale x 4 x i1> @vfptosi_nxv4bf16_nxv4i1(<vscale x 4 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv4bf16_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vfncvt.rtz.x.f.w v8, v10
; CHECK-NEXT:    vand.vi v8, v8, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 4 x bfloat> %va to <vscale x 4 x i1>
  ret <vscale x 4 x i1> %evec
}

define <vscale x 4 x i1> @vfptoui_nxv4bf16_nxv4i1(<vscale x 4 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv4bf16_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v8, v10
; CHECK-NEXT:    vand.vi v8, v8, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 4 x bfloat> %va to <vscale x 4 x i1>
  ret <vscale x 4 x i1> %evec
}

define <vscale x 4 x i8> @vfptosi_nxv4bf16_nxv4i8(<vscale x 4 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv4bf16_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vfncvt.rtz.x.f.w v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 4 x bfloat> %va to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %evec
}

define <vscale x 4 x i8> @vfptoui_nxv4bf16_nxv4i8(<vscale x 4 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv4bf16_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 4 x bfloat> %va to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %evec
}

define <vscale x 4 x i16> @vfptosi_nxv4bf16_nxv4i16(<vscale x 4 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv4bf16_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vfncvt.rtz.x.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 4 x bfloat> %va to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %evec
}

define <vscale x 4 x i16> @vfptoui_nxv4bf16_nxv4i16(<vscale x 4 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv4bf16_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v8, v10
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 4 x bfloat> %va to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %evec
}

define <vscale x 4 x i32> @vfptosi_nxv4bf16_nxv4i32(<vscale x 4 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv4bf16_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v10
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 4 x bfloat> %va to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %evec
}

define <vscale x 4 x i32> @vfptoui_nxv4bf16_nxv4i32(<vscale x 4 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv4bf16_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v10
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 4 x bfloat> %va to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %evec
}

define <vscale x 4 x i64> @vfptosi_nxv4bf16_nxv4i64(<vscale x 4 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv4bf16_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v8, v12
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 4 x bfloat> %va to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %evec
}

define <vscale x 4 x i64> @vfptoui_nxv4bf16_nxv4i64(<vscale x 4 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv4bf16_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v8, v12
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 4 x bfloat> %va to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %evec
}

define <vscale x 8 x i1> @vfptosi_nxv8bf16_nxv8i1(<vscale x 8 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv8bf16_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vfncvt.rtz.x.f.w v8, v12
; CHECK-NEXT:    vand.vi v8, v8, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 8 x bfloat> %va to <vscale x 8 x i1>
  ret <vscale x 8 x i1> %evec
}

define <vscale x 8 x i1> @vfptoui_nxv8bf16_nxv8i1(<vscale x 8 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv8bf16_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v8, v12
; CHECK-NEXT:    vand.vi v8, v8, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 8 x bfloat> %va to <vscale x 8 x i1>
  ret <vscale x 8 x i1> %evec
}

define <vscale x 8 x i8> @vfptosi_nxv8bf16_nxv8i8(<vscale x 8 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv8bf16_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vfncvt.rtz.x.f.w v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 8 x bfloat> %va to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %evec
}

define <vscale x 8 x i8> @vfptoui_nxv8bf16_nxv8i8(<vscale x 8 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv8bf16_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v10, v12
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 8 x bfloat> %va to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %evec
}

define <vscale x 8 x i16> @vfptosi_nxv8bf16_nxv8i16(<vscale x 8 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv8bf16_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vfncvt.rtz.x.f.w v8, v12
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 8 x bfloat> %va to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %evec
}

define <vscale x 8 x i16> @vfptoui_nxv8bf16_nxv8i16(<vscale x 8 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv8bf16_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v8, v12
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 8 x bfloat> %va to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %evec
}

define <vscale x 8 x i32> @vfptosi_nxv8bf16_nxv8i32(<vscale x 8 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv8bf16_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v12
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 8 x bfloat> %va to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %evec
}

define <vscale x 8 x i32> @vfptoui_nxv8bf16_nxv8i32(<vscale x 8 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv8bf16_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v12
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 8 x bfloat> %va to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %evec
}

define <vscale x 8 x i64> @vfptosi_nxv8bf16_nxv8i64(<vscale x 8 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv8bf16_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v8, v16
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 8 x bfloat> %va to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %evec
}

define <vscale x 8 x i64> @vfptoui_nxv8bf16_nxv8i64(<vscale x 8 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv8bf16_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v8, v16
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 8 x bfloat> %va to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %evec
}

define <vscale x 16 x i1> @vfptosi_nxv16bf16_nxv16i1(<vscale x 16 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv16bf16_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vfncvt.rtz.x.f.w v8, v16
; CHECK-NEXT:    vand.vi v8, v8, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 16 x bfloat> %va to <vscale x 16 x i1>
  ret <vscale x 16 x i1> %evec
}

define <vscale x 16 x i1> @vfptoui_nxv16bf16_nxv16i1(<vscale x 16 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv16bf16_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v8, v16
; CHECK-NEXT:    vand.vi v8, v8, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 16 x bfloat> %va to <vscale x 16 x i1>
  ret <vscale x 16 x i1> %evec
}

define <vscale x 16 x i8> @vfptosi_nxv16bf16_nxv16i8(<vscale x 16 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv16bf16_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v16
; CHECK-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 16 x bfloat> %va to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %evec
}

define <vscale x 16 x i8> @vfptoui_nxv16bf16_nxv16i8(<vscale x 16 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv16bf16_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v16
; CHECK-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 16 x bfloat> %va to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %evec
}

define <vscale x 16 x i16> @vfptosi_nxv16bf16_nxv16i16(<vscale x 16 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv16bf16_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vfncvt.rtz.x.f.w v8, v16
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 16 x bfloat> %va to <vscale x 16 x i16>
  ret <vscale x 16 x i16> %evec
}

define <vscale x 16 x i16> @vfptoui_nxv16bf16_nxv16i16(<vscale x 16 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv16bf16_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v8, v16
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 16 x bfloat> %va to <vscale x 16 x i16>
  ret <vscale x 16 x i16> %evec
}

define <vscale x 16 x i32> @vfptosi_nxv16bf16_nxv16i32(<vscale x 16 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv16bf16_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v16
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 16 x bfloat> %va to <vscale x 16 x i32>
  ret <vscale x 16 x i32> %evec
}

define <vscale x 16 x i32> @vfptoui_nxv16bf16_nxv16i32(<vscale x 16 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv16bf16_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v16
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 16 x bfloat> %va to <vscale x 16 x i32>
  ret <vscale x 16 x i32> %evec
}

define <vscale x 32 x i1> @vfptosi_nxv32bf16_nxv32i1(<vscale x 32 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv32bf16_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v12
; CHECK-NEXT:    vfwcvtbf16.f.f.v v24, v8
; CHECK-NEXT:    srli a0, a0, 2
; CHECK-NEXT:    vfncvt.rtz.x.f.w v8, v16
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v24
; CHECK-NEXT:    vand.vi v8, v8, 1
; CHECK-NEXT:    vand.vi v12, v12, 1
; CHECK-NEXT:    vmsne.vi v16, v8, 0
; CHECK-NEXT:    vmsne.vi v0, v12, 0
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vslideup.vx v0, v16, a0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 32 x bfloat> %va to <vscale x 32 x i1>
  ret <vscale x 32 x i1> %evec
}

define <vscale x 32 x i1> @vfptoui_nxv32bf16_nxv32i1(<vscale x 32 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv32bf16_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v12
; CHECK-NEXT:    vfwcvtbf16.f.f.v v24, v8
; CHECK-NEXT:    srli a0, a0, 2
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v8, v16
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v24
; CHECK-NEXT:    vand.vi v8, v8, 1
; CHECK-NEXT:    vand.vi v12, v12, 1
; CHECK-NEXT:    vmsne.vi v16, v8, 0
; CHECK-NEXT:    vmsne.vi v0, v12, 0
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vslideup.vx v0, v16, a0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 32 x bfloat> %va to <vscale x 32 x i1>
  ret <vscale x 32 x i1> %evec
}

define <vscale x 32 x i8> @vfptosi_nxv32bf16_nxv32i8(<vscale x 32 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv32bf16_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vfwcvtbf16.f.f.v v24, v12
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v16
; CHECK-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v24
; CHECK-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v12, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 32 x bfloat> %va to <vscale x 32 x i8>
  ret <vscale x 32 x i8> %evec
}

define <vscale x 32 x i8> @vfptoui_nxv32bf16_nxv32i8(<vscale x 32 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv32bf16_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vfwcvtbf16.f.f.v v24, v12
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v16
; CHECK-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v24
; CHECK-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v12, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 32 x bfloat> %va to <vscale x 32 x i8>
  ret <vscale x 32 x i8> %evec
}

define <vscale x 32 x i16> @vfptosi_nxv32bf16_nxv32i16(<vscale x 32 x bfloat> %va) {
; CHECK-LABEL: vfptosi_nxv32bf16_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vfncvt.rtz.x.f.w v8, v16
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v12
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v16
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 32 x bfloat> %va to <vscale x 32 x i16>
  ret <vscale x 32 x i16> %evec
}

define <vscale x 32 x i16> @vfptoui_nxv32bf16_nxv32i16(<vscale x 32 x bfloat> %va) {
; CHECK-LABEL: vfptoui_nxv32bf16_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v8
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v8, v16
; CHECK-NEXT:    vfwcvtbf16.f.f.v v16, v12
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v16
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 32 x bfloat> %va to <vscale x 32 x i16>
  ret <vscale x 32 x i16> %evec
}

define <vscale x 1 x i1> @vfptosi_nxv1f16_nxv1i1(<vscale x 1 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv1f16_nxv1i1:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.x.f.w v9, v8
; ZVFH-NEXT:    vand.vi v8, v9, 1
; ZVFH-NEXT:    vmsne.vi v0, v8, 0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv1f16_nxv1i1:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v8, v9
; ZVFHMIN-NEXT:    vand.vi v8, v8, 1
; ZVFHMIN-NEXT:    vmsne.vi v0, v8, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 1 x half> %va to <vscale x 1 x i1>
  ret <vscale x 1 x i1> %evec
}

define <vscale x 1 x i7> @vfptosi_nxv1f16_nxv1i7(<vscale x 1 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv1f16_nxv1i7:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.x.f.w v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv1f16_nxv1i7:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v8, v9
; ZVFHMIN-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; ZVFHMIN-NEXT:    vnsrl.wi v8, v8, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 1 x half> %va to <vscale x 1 x i7>
  ret <vscale x 1 x i7> %evec
}

define <vscale x 1 x i7> @vfptoui_nxv1f16_nxv1i7(<vscale x 1 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv1f16_nxv1i7:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.x.f.w v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv1f16_nxv1i7:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v8, v9
; ZVFHMIN-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; ZVFHMIN-NEXT:    vnsrl.wi v8, v8, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 1 x half> %va to <vscale x 1 x i7>
  ret <vscale x 1 x i7> %evec
}

define <vscale x 1 x i1> @vfptoui_nxv1f16_nxv1i1(<vscale x 1 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv1f16_nxv1i1:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; ZVFH-NEXT:    vand.vi v8, v9, 1
; ZVFH-NEXT:    vmsne.vi v0, v8, 0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv1f16_nxv1i1:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v8, v9
; ZVFHMIN-NEXT:    vand.vi v8, v8, 1
; ZVFHMIN-NEXT:    vmsne.vi v0, v8, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 1 x half> %va to <vscale x 1 x i1>
  ret <vscale x 1 x i1> %evec
}

define <vscale x 1 x i8> @vfptosi_nxv1f16_nxv1i8(<vscale x 1 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv1f16_nxv1i8:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.x.f.w v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv1f16_nxv1i8:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v8, v9
; ZVFHMIN-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; ZVFHMIN-NEXT:    vnsrl.wi v8, v8, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 1 x half> %va to <vscale x 1 x i8>
  ret <vscale x 1 x i8> %evec
}

define <vscale x 1 x i8> @vfptoui_nxv1f16_nxv1i8(<vscale x 1 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv1f16_nxv1i8:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv1f16_nxv1i8:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v8, v9
; ZVFHMIN-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; ZVFHMIN-NEXT:    vnsrl.wi v8, v8, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 1 x half> %va to <vscale x 1 x i8>
  ret <vscale x 1 x i8> %evec
}

define <vscale x 1 x i16> @vfptosi_nxv1f16_nxv1i16(<vscale x 1 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv1f16_nxv1i16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfcvt.rtz.x.f.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv1f16_nxv1i16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 1 x half> %va to <vscale x 1 x i16>
  ret <vscale x 1 x i16> %evec
}

define <vscale x 1 x i16> @vfptoui_nxv1f16_nxv1i16(<vscale x 1 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv1f16_nxv1i16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv1f16_nxv1i16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 1 x half> %va to <vscale x 1 x i16>
  ret <vscale x 1 x i16> %evec
}

define <vscale x 1 x i32> @vfptosi_nxv1f16_nxv1i32(<vscale x 1 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv1f16_nxv1i32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfwcvt.rtz.x.f.v v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv1f16_nxv1i32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfcvt.rtz.x.f.v v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 1 x half> %va to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %evec
}

define <vscale x 1 x i32> @vfptoui_nxv1f16_nxv1i32(<vscale x 1 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv1f16_nxv1i32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfwcvt.rtz.xu.f.v v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv1f16_nxv1i32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfcvt.rtz.xu.f.v v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 1 x half> %va to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %evec
}

define <vscale x 1 x i64> @vfptosi_nxv1f16_nxv1i64(<vscale x 1 x half> %va) {
; CHECK-LABEL: vfptosi_nxv1f16_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v8, v9
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 1 x half> %va to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %evec
}

define <vscale x 1 x i64> @vfptoui_nxv1f16_nxv1i64(<vscale x 1 x half> %va) {
; CHECK-LABEL: vfptoui_nxv1f16_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v8, v9
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 1 x half> %va to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %evec
}

define <vscale x 2 x i1> @vfptosi_nxv2f16_nxv2i1(<vscale x 2 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv2f16_nxv2i1:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.x.f.w v9, v8
; ZVFH-NEXT:    vand.vi v8, v9, 1
; ZVFH-NEXT:    vmsne.vi v0, v8, 0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv2f16_nxv2i1:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v8, v9
; ZVFHMIN-NEXT:    vand.vi v8, v8, 1
; ZVFHMIN-NEXT:    vmsne.vi v0, v8, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 2 x half> %va to <vscale x 2 x i1>
  ret <vscale x 2 x i1> %evec
}

define <vscale x 2 x i1> @vfptoui_nxv2f16_nxv2i1(<vscale x 2 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv2f16_nxv2i1:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; ZVFH-NEXT:    vand.vi v8, v9, 1
; ZVFH-NEXT:    vmsne.vi v0, v8, 0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv2f16_nxv2i1:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v8, v9
; ZVFHMIN-NEXT:    vand.vi v8, v8, 1
; ZVFHMIN-NEXT:    vmsne.vi v0, v8, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 2 x half> %va to <vscale x 2 x i1>
  ret <vscale x 2 x i1> %evec
}

define <vscale x 2 x i8> @vfptosi_nxv2f16_nxv2i8(<vscale x 2 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv2f16_nxv2i8:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.x.f.w v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv2f16_nxv2i8:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v8, v9
; ZVFHMIN-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; ZVFHMIN-NEXT:    vnsrl.wi v8, v8, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 2 x half> %va to <vscale x 2 x i8>
  ret <vscale x 2 x i8> %evec
}

define <vscale x 2 x i8> @vfptoui_nxv2f16_nxv2i8(<vscale x 2 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv2f16_nxv2i8:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf4, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv2f16_nxv2i8:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v8, v9
; ZVFHMIN-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; ZVFHMIN-NEXT:    vnsrl.wi v8, v8, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 2 x half> %va to <vscale x 2 x i8>
  ret <vscale x 2 x i8> %evec
}

define <vscale x 2 x i16> @vfptosi_nxv2f16_nxv2i16(<vscale x 2 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv2f16_nxv2i16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfcvt.rtz.x.f.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv2f16_nxv2i16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 2 x half> %va to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %evec
}

define <vscale x 2 x i16> @vfptoui_nxv2f16_nxv2i16(<vscale x 2 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv2f16_nxv2i16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv2f16_nxv2i16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 2 x half> %va to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %evec
}

define <vscale x 2 x i32> @vfptosi_nxv2f16_nxv2i32(<vscale x 2 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv2f16_nxv2i32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfwcvt.rtz.x.f.v v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv2f16_nxv2i32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfcvt.rtz.x.f.v v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 2 x half> %va to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %evec
}

define <vscale x 2 x i32> @vfptoui_nxv2f16_nxv2i32(<vscale x 2 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv2f16_nxv2i32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfwcvt.rtz.xu.f.v v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv2f16_nxv2i32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfcvt.rtz.xu.f.v v8, v9
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 2 x half> %va to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %evec
}

define <vscale x 2 x i64> @vfptosi_nxv2f16_nxv2i64(<vscale x 2 x half> %va) {
; CHECK-LABEL: vfptosi_nxv2f16_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v8, v10
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 2 x half> %va to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %evec
}

define <vscale x 2 x i64> @vfptoui_nxv2f16_nxv2i64(<vscale x 2 x half> %va) {
; CHECK-LABEL: vfptoui_nxv2f16_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v8, v10
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 2 x half> %va to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %evec
}

define <vscale x 4 x i1> @vfptosi_nxv4f16_nxv4i1(<vscale x 4 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv4f16_nxv4i1:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.x.f.w v9, v8
; ZVFH-NEXT:    vand.vi v8, v9, 1
; ZVFH-NEXT:    vmsne.vi v0, v8, 0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv4f16_nxv4i1:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v8, v10
; ZVFHMIN-NEXT:    vand.vi v8, v8, 1
; ZVFHMIN-NEXT:    vmsne.vi v0, v8, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 4 x half> %va to <vscale x 4 x i1>
  ret <vscale x 4 x i1> %evec
}

define <vscale x 4 x i1> @vfptoui_nxv4f16_nxv4i1(<vscale x 4 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv4f16_nxv4i1:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; ZVFH-NEXT:    vand.vi v8, v9, 1
; ZVFH-NEXT:    vmsne.vi v0, v8, 0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv4f16_nxv4i1:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v8, v10
; ZVFHMIN-NEXT:    vand.vi v8, v8, 1
; ZVFHMIN-NEXT:    vmsne.vi v0, v8, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 4 x half> %va to <vscale x 4 x i1>
  ret <vscale x 4 x i1> %evec
}

define <vscale x 4 x i8> @vfptosi_nxv4f16_nxv4i8(<vscale x 4 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv4f16_nxv4i8:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.x.f.w v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv4f16_nxv4i8:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; ZVFHMIN-NEXT:    vnsrl.wi v8, v8, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 4 x half> %va to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %evec
}

define <vscale x 4 x i8> @vfptoui_nxv4f16_nxv4i8(<vscale x 4 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv4f16_nxv4i8:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, mf2, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; ZVFH-NEXT:    vmv1r.v v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv4f16_nxv4i8:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v8, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; ZVFHMIN-NEXT:    vnsrl.wi v8, v8, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 4 x half> %va to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %evec
}

define <vscale x 4 x i16> @vfptosi_nxv4f16_nxv4i16(<vscale x 4 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv4f16_nxv4i16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfcvt.rtz.x.f.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv4f16_nxv4i16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 4 x half> %va to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %evec
}

define <vscale x 4 x i16> @vfptoui_nxv4f16_nxv4i16(<vscale x 4 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv4f16_nxv4i16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv4f16_nxv4i16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v8, v10
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 4 x half> %va to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %evec
}

define <vscale x 4 x i32> @vfptosi_nxv4f16_nxv4i32(<vscale x 4 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv4f16_nxv4i32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vmv1r.v v10, v8
; ZVFH-NEXT:    vfwcvt.rtz.x.f.v v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv4f16_nxv4i32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfcvt.rtz.x.f.v v8, v10
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 4 x half> %va to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %evec
}

define <vscale x 4 x i32> @vfptoui_nxv4f16_nxv4i32(<vscale x 4 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv4f16_nxv4i32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vmv1r.v v10, v8
; ZVFH-NEXT:    vfwcvt.rtz.xu.f.v v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv4f16_nxv4i32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfcvt.rtz.xu.f.v v8, v10
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 4 x half> %va to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %evec
}

define <vscale x 4 x i64> @vfptosi_nxv4f16_nxv4i64(<vscale x 4 x half> %va) {
; CHECK-LABEL: vfptosi_nxv4f16_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v8, v12
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 4 x half> %va to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %evec
}

define <vscale x 4 x i64> @vfptoui_nxv4f16_nxv4i64(<vscale x 4 x half> %va) {
; CHECK-LABEL: vfptoui_nxv4f16_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v8, v12
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 4 x half> %va to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %evec
}

define <vscale x 8 x i1> @vfptosi_nxv8f16_nxv8i1(<vscale x 8 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv8f16_nxv8i1:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.x.f.w v10, v8
; ZVFH-NEXT:    vand.vi v8, v10, 1
; ZVFH-NEXT:    vmsne.vi v0, v8, 0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv8f16_nxv8i1:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v8, v12
; ZVFHMIN-NEXT:    vand.vi v8, v8, 1
; ZVFHMIN-NEXT:    vmsne.vi v0, v8, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 8 x half> %va to <vscale x 8 x i1>
  ret <vscale x 8 x i1> %evec
}

define <vscale x 8 x i1> @vfptoui_nxv8f16_nxv8i1(<vscale x 8 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv8f16_nxv8i1:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.xu.f.w v10, v8
; ZVFH-NEXT:    vand.vi v8, v10, 1
; ZVFH-NEXT:    vmsne.vi v0, v8, 0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv8f16_nxv8i1:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v8, v12
; ZVFHMIN-NEXT:    vand.vi v8, v8, 1
; ZVFHMIN-NEXT:    vmsne.vi v0, v8, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 8 x half> %va to <vscale x 8 x i1>
  ret <vscale x 8 x i1> %evec
}

define <vscale x 8 x i8> @vfptosi_nxv8f16_nxv8i8(<vscale x 8 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv8f16_nxv8i8:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.x.f.w v10, v8
; ZVFH-NEXT:    vmv.v.v v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv8f16_nxv8i8:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; ZVFHMIN-NEXT:    vnsrl.wi v8, v10, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 8 x half> %va to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %evec
}

define <vscale x 8 x i8> @vfptoui_nxv8f16_nxv8i8(<vscale x 8 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv8f16_nxv8i8:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.xu.f.w v10, v8
; ZVFH-NEXT:    vmv.v.v v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv8f16_nxv8i8:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v10, v12
; ZVFHMIN-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; ZVFHMIN-NEXT:    vnsrl.wi v8, v10, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 8 x half> %va to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %evec
}

define <vscale x 8 x i16> @vfptosi_nxv8f16_nxv8i16(<vscale x 8 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv8f16_nxv8i16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfcvt.rtz.x.f.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv8f16_nxv8i16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v8, v12
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 8 x half> %va to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %evec
}

define <vscale x 8 x i16> @vfptoui_nxv8f16_nxv8i16(<vscale x 8 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv8f16_nxv8i16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv8f16_nxv8i16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v8, v12
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 8 x half> %va to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %evec
}

define <vscale x 8 x i32> @vfptosi_nxv8f16_nxv8i32(<vscale x 8 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv8f16_nxv8i32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmv2r.v v12, v8
; ZVFH-NEXT:    vfwcvt.rtz.x.f.v v8, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv8f16_nxv8i32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfcvt.rtz.x.f.v v8, v12
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 8 x half> %va to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %evec
}

define <vscale x 8 x i32> @vfptoui_nxv8f16_nxv8i32(<vscale x 8 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv8f16_nxv8i32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vmv2r.v v12, v8
; ZVFH-NEXT:    vfwcvt.rtz.xu.f.v v8, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv8f16_nxv8i32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfcvt.rtz.xu.f.v v8, v12
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 8 x half> %va to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %evec
}

define <vscale x 8 x i64> @vfptosi_nxv8f16_nxv8i64(<vscale x 8 x half> %va) {
; CHECK-LABEL: vfptosi_nxv8f16_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v8, v16
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 8 x half> %va to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %evec
}

define <vscale x 8 x i64> @vfptoui_nxv8f16_nxv8i64(<vscale x 8 x half> %va) {
; CHECK-LABEL: vfptoui_nxv8f16_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v8, v16
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 8 x half> %va to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %evec
}

define <vscale x 16 x i1> @vfptosi_nxv16f16_nxv16i1(<vscale x 16 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv16f16_nxv16i1:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.x.f.w v12, v8
; ZVFH-NEXT:    vand.vi v8, v12, 1
; ZVFH-NEXT:    vmsne.vi v0, v8, 0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv16f16_nxv16i1:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v8, v16
; ZVFHMIN-NEXT:    vand.vi v8, v8, 1
; ZVFHMIN-NEXT:    vmsne.vi v0, v8, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 16 x half> %va to <vscale x 16 x i1>
  ret <vscale x 16 x i1> %evec
}

define <vscale x 16 x i1> @vfptoui_nxv16f16_nxv16i1(<vscale x 16 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv16f16_nxv16i1:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; ZVFH-NEXT:    vand.vi v8, v12, 1
; ZVFH-NEXT:    vmsne.vi v0, v8, 0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv16f16_nxv16i1:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v8, v16
; ZVFHMIN-NEXT:    vand.vi v8, v8, 1
; ZVFHMIN-NEXT:    vmsne.vi v0, v8, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 16 x half> %va to <vscale x 16 x i1>
  ret <vscale x 16 x i1> %evec
}

define <vscale x 16 x i8> @vfptosi_nxv16f16_nxv16i8(<vscale x 16 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv16f16_nxv16i8:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.x.f.w v12, v8
; ZVFH-NEXT:    vmv.v.v v8, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv16f16_nxv16i8:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v12, v16
; ZVFHMIN-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; ZVFHMIN-NEXT:    vnsrl.wi v8, v12, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 16 x half> %va to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %evec
}

define <vscale x 16 x i8> @vfptoui_nxv16f16_nxv16i8(<vscale x 16 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv16f16_nxv16i8:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; ZVFH-NEXT:    vmv.v.v v8, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv16f16_nxv16i8:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v12, v16
; ZVFHMIN-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; ZVFHMIN-NEXT:    vnsrl.wi v8, v12, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 16 x half> %va to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %evec
}

define <vscale x 16 x i16> @vfptosi_nxv16f16_nxv16i16(<vscale x 16 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv16f16_nxv16i16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfcvt.rtz.x.f.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv16f16_nxv16i16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v8, v16
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 16 x half> %va to <vscale x 16 x i16>
  ret <vscale x 16 x i16> %evec
}

define <vscale x 16 x i16> @vfptoui_nxv16f16_nxv16i16(<vscale x 16 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv16f16_nxv16i16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv16f16_nxv16i16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v8, v16
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 16 x half> %va to <vscale x 16 x i16>
  ret <vscale x 16 x i16> %evec
}

define <vscale x 16 x i32> @vfptosi_nxv16f16_nxv16i32(<vscale x 16 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv16f16_nxv16i32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vmv4r.v v16, v8
; ZVFH-NEXT:    vfwcvt.rtz.x.f.v v8, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv16f16_nxv16i32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfcvt.rtz.x.f.v v8, v16
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 16 x half> %va to <vscale x 16 x i32>
  ret <vscale x 16 x i32> %evec
}

define <vscale x 16 x i32> @vfptoui_nxv16f16_nxv16i32(<vscale x 16 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv16f16_nxv16i32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vmv4r.v v16, v8
; ZVFH-NEXT:    vfwcvt.rtz.xu.f.v v8, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv16f16_nxv16i32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfcvt.rtz.xu.f.v v8, v16
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 16 x half> %va to <vscale x 16 x i32>
  ret <vscale x 16 x i32> %evec
}

define <vscale x 32 x i1> @vfptosi_nxv32f16_nxv32i1(<vscale x 32 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv32f16_nxv32i1:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.x.f.w v16, v8
; ZVFH-NEXT:    vand.vi v8, v16, 1
; ZVFH-NEXT:    vmsne.vi v0, v8, 0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv32f16_nxv32i1:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v8
; ZVFHMIN-NEXT:    srli a0, a0, 2
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v8, v16
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v12, v24
; ZVFHMIN-NEXT:    vand.vi v8, v8, 1
; ZVFHMIN-NEXT:    vand.vi v12, v12, 1
; ZVFHMIN-NEXT:    vmsne.vi v16, v8, 0
; ZVFHMIN-NEXT:    vmsne.vi v0, v12, 0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; ZVFHMIN-NEXT:    vslideup.vx v0, v16, a0
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 32 x half> %va to <vscale x 32 x i1>
  ret <vscale x 32 x i1> %evec
}

define <vscale x 32 x i1> @vfptoui_nxv32f16_nxv32i1(<vscale x 32 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv32f16_nxv32i1:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.xu.f.w v16, v8
; ZVFH-NEXT:    vand.vi v8, v16, 1
; ZVFH-NEXT:    vmsne.vi v0, v8, 0
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv32f16_nxv32i1:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    csrr a0, vlenb
; ZVFHMIN-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v8
; ZVFHMIN-NEXT:    srli a0, a0, 2
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v8, v16
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v12, v24
; ZVFHMIN-NEXT:    vand.vi v8, v8, 1
; ZVFHMIN-NEXT:    vand.vi v12, v12, 1
; ZVFHMIN-NEXT:    vmsne.vi v16, v8, 0
; ZVFHMIN-NEXT:    vmsne.vi v0, v12, 0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; ZVFHMIN-NEXT:    vslideup.vx v0, v16, a0
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 32 x half> %va to <vscale x 32 x i1>
  ret <vscale x 32 x i1> %evec
}

define <vscale x 32 x i8> @vfptosi_nxv32f16_nxv32i8(<vscale x 32 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv32f16_nxv32i8:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.x.f.w v16, v8
; ZVFH-NEXT:    vmv.v.v v8, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv32f16_nxv32i8:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v12
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v12, v16
; ZVFHMIN-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; ZVFHMIN-NEXT:    vnsrl.wi v8, v12, 0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v12, v24
; ZVFHMIN-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; ZVFHMIN-NEXT:    vnsrl.wi v10, v12, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 32 x half> %va to <vscale x 32 x i8>
  ret <vscale x 32 x i8> %evec
}

define <vscale x 32 x i8> @vfptoui_nxv32f16_nxv32i8(<vscale x 32 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv32f16_nxv32i8:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; ZVFH-NEXT:    vfncvt.rtz.xu.f.w v16, v8
; ZVFH-NEXT:    vmv.v.v v8, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv32f16_nxv32i8:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v12
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v12, v16
; ZVFHMIN-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; ZVFHMIN-NEXT:    vnsrl.wi v8, v12, 0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v12, v24
; ZVFHMIN-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; ZVFHMIN-NEXT:    vnsrl.wi v10, v12, 0
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 32 x half> %va to <vscale x 32 x i8>
  ret <vscale x 32 x i8> %evec
}

define <vscale x 32 x i16> @vfptosi_nxv32f16_nxv32i16(<vscale x 32 x half> %va) {
; ZVFH-LABEL: vfptosi_nxv32f16_nxv32i16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; ZVFH-NEXT:    vfcvt.rtz.x.f.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptosi_nxv32f16_nxv32i16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v8, v16
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v12
; ZVFHMIN-NEXT:    vfncvt.rtz.x.f.w v12, v16
; ZVFHMIN-NEXT:    ret
  %evec = fptosi <vscale x 32 x half> %va to <vscale x 32 x i16>
  ret <vscale x 32 x i16> %evec
}

define <vscale x 32 x i16> @vfptoui_nxv32f16_nxv32i16(<vscale x 32 x half> %va) {
; ZVFH-LABEL: vfptoui_nxv32f16_nxv32i16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; ZVFH-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfptoui_nxv32f16_nxv32i16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v8
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v8, v16
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v12
; ZVFHMIN-NEXT:    vfncvt.rtz.xu.f.w v12, v16
; ZVFHMIN-NEXT:    ret
  %evec = fptoui <vscale x 32 x half> %va to <vscale x 32 x i16>
  ret <vscale x 32 x i16> %evec
}

define <vscale x 1 x i1> @vfptosi_nxv1f32_nxv1i1(<vscale x 1 x float> %va) {
; CHECK-LABEL: vfptosi_nxv1f32_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 1 x float> %va to <vscale x 1 x i1>
  ret <vscale x 1 x i1> %evec
}

define <vscale x 1 x i1> @vfptoui_nxv1f32_nxv1i1(<vscale x 1 x float> %va) {
; CHECK-LABEL: vfptoui_nxv1f32_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 1 x float> %va to <vscale x 1 x i1>
  ret <vscale x 1 x i1> %evec
}

define <vscale x 1 x i8> @vfptosi_nxv1f32_nxv1i8(<vscale x 1 x float> %va) {
; CHECK-LABEL: vfptosi_nxv1f32_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 1 x float> %va to <vscale x 1 x i8>
  ret <vscale x 1 x i8> %evec
}

define <vscale x 1 x i8> @vfptoui_nxv1f32_nxv1i8(<vscale x 1 x float> %va) {
; CHECK-LABEL: vfptoui_nxv1f32_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 1 x float> %va to <vscale x 1 x i8>
  ret <vscale x 1 x i8> %evec
}

define <vscale x 1 x i16> @vfptosi_nxv1f32_nxv1i16(<vscale x 1 x float> %va) {
; CHECK-LABEL: vfptosi_nxv1f32_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 1 x float> %va to <vscale x 1 x i16>
  ret <vscale x 1 x i16> %evec
}

define <vscale x 1 x i16> @vfptoui_nxv1f32_nxv1i16(<vscale x 1 x float> %va) {
; CHECK-LABEL: vfptoui_nxv1f32_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 1 x float> %va to <vscale x 1 x i16>
  ret <vscale x 1 x i16> %evec
}

define <vscale x 1 x i32> @vfptosi_nxv1f32_nxv1i32(<vscale x 1 x float> %va) {
; CHECK-LABEL: vfptosi_nxv1f32_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 1 x float> %va to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %evec
}

define <vscale x 1 x i32> @vfptoui_nxv1f32_nxv1i32(<vscale x 1 x float> %va) {
; CHECK-LABEL: vfptoui_nxv1f32_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 1 x float> %va to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %evec
}

define <vscale x 1 x i64> @vfptosi_nxv1f32_nxv1i64(<vscale x 1 x float> %va) {
; CHECK-LABEL: vfptosi_nxv1f32_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 1 x float> %va to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %evec
}

define <vscale x 1 x i64> @vfptoui_nxv1f32_nxv1i64(<vscale x 1 x float> %va) {
; CHECK-LABEL: vfptoui_nxv1f32_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 1 x float> %va to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %evec
}

define <vscale x 2 x i1> @vfptosi_nxv2f32_nxv2i1(<vscale x 2 x float> %va) {
; CHECK-LABEL: vfptosi_nxv2f32_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 2 x float> %va to <vscale x 2 x i1>
  ret <vscale x 2 x i1> %evec
}

define <vscale x 2 x i1> @vfptoui_nxv2f32_nxv2i1(<vscale x 2 x float> %va) {
; CHECK-LABEL: vfptoui_nxv2f32_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 2 x float> %va to <vscale x 2 x i1>
  ret <vscale x 2 x i1> %evec
}

define <vscale x 2 x i8> @vfptosi_nxv2f32_nxv2i8(<vscale x 2 x float> %va) {
; CHECK-LABEL: vfptosi_nxv2f32_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 2 x float> %va to <vscale x 2 x i8>
  ret <vscale x 2 x i8> %evec
}

define <vscale x 2 x i8> @vfptoui_nxv2f32_nxv2i8(<vscale x 2 x float> %va) {
; CHECK-LABEL: vfptoui_nxv2f32_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 2 x float> %va to <vscale x 2 x i8>
  ret <vscale x 2 x i8> %evec
}

define <vscale x 2 x i16> @vfptosi_nxv2f32_nxv2i16(<vscale x 2 x float> %va) {
; CHECK-LABEL: vfptosi_nxv2f32_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 2 x float> %va to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %evec
}

define <vscale x 2 x i16> @vfptoui_nxv2f32_nxv2i16(<vscale x 2 x float> %va) {
; CHECK-LABEL: vfptoui_nxv2f32_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 2 x float> %va to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %evec
}

define <vscale x 2 x i32> @vfptosi_nxv2f32_nxv2i32(<vscale x 2 x float> %va) {
; CHECK-LABEL: vfptosi_nxv2f32_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 2 x float> %va to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %evec
}

define <vscale x 2 x i32> @vfptoui_nxv2f32_nxv2i32(<vscale x 2 x float> %va) {
; CHECK-LABEL: vfptoui_nxv2f32_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 2 x float> %va to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %evec
}

define <vscale x 2 x i64> @vfptosi_nxv2f32_nxv2i64(<vscale x 2 x float> %va) {
; CHECK-LABEL: vfptosi_nxv2f32_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v8, v10
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 2 x float> %va to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %evec
}

define <vscale x 2 x i64> @vfptoui_nxv2f32_nxv2i64(<vscale x 2 x float> %va) {
; CHECK-LABEL: vfptoui_nxv2f32_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v8, v10
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 2 x float> %va to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %evec
}

define <vscale x 4 x i1> @vfptosi_nxv4f32_nxv4i1(<vscale x 4 x float> %va) {
; CHECK-LABEL: vfptosi_nxv4f32_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v10, v8
; CHECK-NEXT:    vand.vi v8, v10, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 4 x float> %va to <vscale x 4 x i1>
  ret <vscale x 4 x i1> %evec
}

define <vscale x 4 x i1> @vfptoui_nxv4f32_nxv4i1(<vscale x 4 x float> %va) {
; CHECK-LABEL: vfptoui_nxv4f32_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v10, v8
; CHECK-NEXT:    vand.vi v8, v10, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 4 x float> %va to <vscale x 4 x i1>
  ret <vscale x 4 x i1> %evec
}

define <vscale x 4 x i8> @vfptosi_nxv4f32_nxv4i8(<vscale x 4 x float> %va) {
; CHECK-LABEL: vfptosi_nxv4f32_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 4 x float> %va to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %evec
}

define <vscale x 4 x i8> @vfptoui_nxv4f32_nxv4i8(<vscale x 4 x float> %va) {
; CHECK-LABEL: vfptoui_nxv4f32_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 4 x float> %va to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %evec
}

define <vscale x 4 x i16> @vfptosi_nxv4f32_nxv4i16(<vscale x 4 x float> %va) {
; CHECK-LABEL: vfptosi_nxv4f32_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 4 x float> %va to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %evec
}

define <vscale x 4 x i16> @vfptoui_nxv4f32_nxv4i16(<vscale x 4 x float> %va) {
; CHECK-LABEL: vfptoui_nxv4f32_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 4 x float> %va to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %evec
}

define <vscale x 4 x i32> @vfptosi_nxv4f32_nxv4i32(<vscale x 4 x float> %va) {
; CHECK-LABEL: vfptosi_nxv4f32_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 4 x float> %va to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %evec
}

define <vscale x 4 x i32> @vfptoui_nxv4f32_nxv4i32(<vscale x 4 x float> %va) {
; CHECK-LABEL: vfptoui_nxv4f32_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 4 x float> %va to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %evec
}

define <vscale x 4 x i64> @vfptosi_nxv4f32_nxv4i64(<vscale x 4 x float> %va) {
; CHECK-LABEL: vfptosi_nxv4f32_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v8, v12
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 4 x float> %va to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %evec
}

define <vscale x 4 x i64> @vfptoui_nxv4f32_nxv4i64(<vscale x 4 x float> %va) {
; CHECK-LABEL: vfptoui_nxv4f32_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vmv2r.v v12, v8
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v8, v12
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 4 x float> %va to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %evec
}

define <vscale x 8 x i1> @vfptosi_nxv8f32_nxv8i1(<vscale x 8 x float> %va) {
; CHECK-LABEL: vfptosi_nxv8f32_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v8
; CHECK-NEXT:    vand.vi v8, v12, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 8 x float> %va to <vscale x 8 x i1>
  ret <vscale x 8 x i1> %evec
}

define <vscale x 8 x i1> @vfptoui_nxv8f32_nxv8i1(<vscale x 8 x float> %va) {
; CHECK-LABEL: vfptoui_nxv8f32_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; CHECK-NEXT:    vand.vi v8, v12, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 8 x float> %va to <vscale x 8 x i1>
  ret <vscale x 8 x i1> %evec
}

define <vscale x 8 x i8> @vfptosi_nxv8f32_nxv8i8(<vscale x 8 x float> %va) {
; CHECK-LABEL: vfptosi_nxv8f32_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 8 x float> %va to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %evec
}

define <vscale x 8 x i8> @vfptoui_nxv8f32_nxv8i8(<vscale x 8 x float> %va) {
; CHECK-LABEL: vfptoui_nxv8f32_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 8 x float> %va to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %evec
}

define <vscale x 8 x i16> @vfptosi_nxv8f32_nxv8i16(<vscale x 8 x float> %va) {
; CHECK-LABEL: vfptosi_nxv8f32_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 8 x float> %va to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %evec
}

define <vscale x 8 x i16> @vfptoui_nxv8f32_nxv8i16(<vscale x 8 x float> %va) {
; CHECK-LABEL: vfptoui_nxv8f32_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 8 x float> %va to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %evec
}

define <vscale x 8 x i32> @vfptosi_nxv8f32_nxv8i32(<vscale x 8 x float> %va) {
; CHECK-LABEL: vfptosi_nxv8f32_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 8 x float> %va to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %evec
}

define <vscale x 8 x i32> @vfptoui_nxv8f32_nxv8i32(<vscale x 8 x float> %va) {
; CHECK-LABEL: vfptoui_nxv8f32_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 8 x float> %va to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %evec
}

define <vscale x 8 x i64> @vfptosi_nxv8f32_nxv8i64(<vscale x 8 x float> %va) {
; CHECK-LABEL: vfptosi_nxv8f32_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv4r.v v16, v8
; CHECK-NEXT:    vfwcvt.rtz.x.f.v v8, v16
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 8 x float> %va to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %evec
}

define <vscale x 8 x i64> @vfptoui_nxv8f32_nxv8i64(<vscale x 8 x float> %va) {
; CHECK-LABEL: vfptoui_nxv8f32_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vmv4r.v v16, v8
; CHECK-NEXT:    vfwcvt.rtz.xu.f.v v8, v16
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 8 x float> %va to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %evec
}

define <vscale x 16 x i1> @vfptosi_nxv16f32_nxv16i1(<vscale x 16 x float> %va) {
; CHECK-LABEL: vfptosi_nxv16f32_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v16, v8
; CHECK-NEXT:    vand.vi v8, v16, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 16 x float> %va to <vscale x 16 x i1>
  ret <vscale x 16 x i1> %evec
}

define <vscale x 16 x i1> @vfptoui_nxv16f32_nxv16i1(<vscale x 16 x float> %va) {
; CHECK-LABEL: vfptoui_nxv16f32_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v16, v8
; CHECK-NEXT:    vand.vi v8, v16, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 16 x float> %va to <vscale x 16 x i1>
  ret <vscale x 16 x i1> %evec
}

define <vscale x 16 x i8> @vfptosi_nxv16f32_nxv16i8(<vscale x 16 x float> %va) {
; CHECK-LABEL: vfptosi_nxv16f32_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v16, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 16 x float> %va to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %evec
}

define <vscale x 16 x i8> @vfptoui_nxv16f32_nxv16i8(<vscale x 16 x float> %va) {
; CHECK-LABEL: vfptoui_nxv16f32_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v16, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 16 x float> %va to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %evec
}

define <vscale x 16 x i16> @vfptosi_nxv16f32_nxv16i16(<vscale x 16 x float> %va) {
; CHECK-LABEL: vfptosi_nxv16f32_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v16, v8
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 16 x float> %va to <vscale x 16 x i16>
  ret <vscale x 16 x i16> %evec
}

define <vscale x 16 x i16> @vfptoui_nxv16f32_nxv16i16(<vscale x 16 x float> %va) {
; CHECK-LABEL: vfptoui_nxv16f32_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v16, v8
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 16 x float> %va to <vscale x 16 x i16>
  ret <vscale x 16 x i16> %evec
}

define <vscale x 16 x i32> @vfptosi_nxv16f32_nxv16i32(<vscale x 16 x float> %va) {
; CHECK-LABEL: vfptosi_nxv16f32_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 16 x float> %va to <vscale x 16 x i32>
  ret <vscale x 16 x i32> %evec
}

define <vscale x 16 x i32> @vfptoui_nxv16f32_nxv16i32(<vscale x 16 x float> %va) {
; CHECK-LABEL: vfptoui_nxv16f32_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 16 x float> %va to <vscale x 16 x i32>
  ret <vscale x 16 x i32> %evec
}

define <vscale x 1 x i1> @vfptosi_nxv1f64_nxv1i1(<vscale x 1 x double> %va) {
; CHECK-LABEL: vfptosi_nxv1f64_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 1 x double> %va to <vscale x 1 x i1>
  ret <vscale x 1 x i1> %evec
}

define <vscale x 1 x i1> @vfptoui_nxv1f64_nxv1i1(<vscale x 1 x double> %va) {
; CHECK-LABEL: vfptoui_nxv1f64_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vand.vi v8, v9, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 1 x double> %va to <vscale x 1 x i1>
  ret <vscale x 1 x i1> %evec
}

define <vscale x 1 x i8> @vfptosi_nxv1f64_nxv1i8(<vscale x 1 x double> %va) {
; CHECK-LABEL: vfptosi_nxv1f64_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 1 x double> %va to <vscale x 1 x i8>
  ret <vscale x 1 x i8> %evec
}

define <vscale x 1 x i8> @vfptoui_nxv1f64_nxv1i8(<vscale x 1 x double> %va) {
; CHECK-LABEL: vfptoui_nxv1f64_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 1 x double> %va to <vscale x 1 x i8>
  ret <vscale x 1 x i8> %evec
}

define <vscale x 1 x i16> @vfptosi_nxv1f64_nxv1i16(<vscale x 1 x double> %va) {
; CHECK-LABEL: vfptosi_nxv1f64_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 1 x double> %va to <vscale x 1 x i16>
  ret <vscale x 1 x i16> %evec
}

define <vscale x 1 x i16> @vfptoui_nxv1f64_nxv1i16(<vscale x 1 x double> %va) {
; CHECK-LABEL: vfptoui_nxv1f64_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v9, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 1 x double> %va to <vscale x 1 x i16>
  ret <vscale x 1 x i16> %evec
}

define <vscale x 1 x i32> @vfptosi_nxv1f64_nxv1i32(<vscale x 1 x double> %va) {
; CHECK-LABEL: vfptosi_nxv1f64_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 1 x double> %va to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %evec
}

define <vscale x 1 x i32> @vfptoui_nxv1f64_nxv1i32(<vscale x 1 x double> %va) {
; CHECK-LABEL: vfptoui_nxv1f64_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v9, v8
; CHECK-NEXT:    vmv1r.v v8, v9
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 1 x double> %va to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %evec
}

define <vscale x 1 x i64> @vfptosi_nxv1f64_nxv1i64(<vscale x 1 x double> %va) {
; CHECK-LABEL: vfptosi_nxv1f64_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 1 x double> %va to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %evec
}

define <vscale x 1 x i64> @vfptoui_nxv1f64_nxv1i64(<vscale x 1 x double> %va) {
; CHECK-LABEL: vfptoui_nxv1f64_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 1 x double> %va to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %evec
}

define <vscale x 2 x i1> @vfptosi_nxv2f64_nxv2i1(<vscale x 2 x double> %va) {
; CHECK-LABEL: vfptosi_nxv2f64_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v10, v8
; CHECK-NEXT:    vand.vi v8, v10, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 2 x double> %va to <vscale x 2 x i1>
  ret <vscale x 2 x i1> %evec
}

define <vscale x 2 x i1> @vfptoui_nxv2f64_nxv2i1(<vscale x 2 x double> %va) {
; CHECK-LABEL: vfptoui_nxv2f64_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v10, v8
; CHECK-NEXT:    vand.vi v8, v10, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 2 x double> %va to <vscale x 2 x i1>
  ret <vscale x 2 x i1> %evec
}

define <vscale x 2 x i8> @vfptosi_nxv2f64_nxv2i8(<vscale x 2 x double> %va) {
; CHECK-LABEL: vfptosi_nxv2f64_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 2 x double> %va to <vscale x 2 x i8>
  ret <vscale x 2 x i8> %evec
}

define <vscale x 2 x i8> @vfptoui_nxv2f64_nxv2i8(<vscale x 2 x double> %va) {
; CHECK-LABEL: vfptoui_nxv2f64_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 2 x double> %va to <vscale x 2 x i8>
  ret <vscale x 2 x i8> %evec
}

define <vscale x 2 x i16> @vfptosi_nxv2f64_nxv2i16(<vscale x 2 x double> %va) {
; CHECK-LABEL: vfptosi_nxv2f64_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 2 x double> %va to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %evec
}

define <vscale x 2 x i16> @vfptoui_nxv2f64_nxv2i16(<vscale x 2 x double> %va) {
; CHECK-LABEL: vfptoui_nxv2f64_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 2 x double> %va to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %evec
}

define <vscale x 2 x i32> @vfptosi_nxv2f64_nxv2i32(<vscale x 2 x double> %va) {
; CHECK-LABEL: vfptosi_nxv2f64_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 2 x double> %va to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %evec
}

define <vscale x 2 x i32> @vfptoui_nxv2f64_nxv2i32(<vscale x 2 x double> %va) {
; CHECK-LABEL: vfptoui_nxv2f64_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v10, v8
; CHECK-NEXT:    vmv.v.v v8, v10
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 2 x double> %va to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %evec
}

define <vscale x 2 x i64> @vfptosi_nxv2f64_nxv2i64(<vscale x 2 x double> %va) {
; CHECK-LABEL: vfptosi_nxv2f64_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 2 x double> %va to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %evec
}

define <vscale x 2 x i64> @vfptoui_nxv2f64_nxv2i64(<vscale x 2 x double> %va) {
; CHECK-LABEL: vfptoui_nxv2f64_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 2 x double> %va to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %evec
}

define <vscale x 4 x i1> @vfptosi_nxv4f64_nxv4i1(<vscale x 4 x double> %va) {
; CHECK-LABEL: vfptosi_nxv4f64_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v8
; CHECK-NEXT:    vand.vi v8, v12, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 4 x double> %va to <vscale x 4 x i1>
  ret <vscale x 4 x i1> %evec
}

define <vscale x 4 x i1> @vfptoui_nxv4f64_nxv4i1(<vscale x 4 x double> %va) {
; CHECK-LABEL: vfptoui_nxv4f64_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; CHECK-NEXT:    vand.vi v8, v12, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 4 x double> %va to <vscale x 4 x i1>
  ret <vscale x 4 x i1> %evec
}

define <vscale x 4 x i8> @vfptosi_nxv4f64_nxv4i8(<vscale x 4 x double> %va) {
; CHECK-LABEL: vfptosi_nxv4f64_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 4 x double> %va to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %evec
}

define <vscale x 4 x i8> @vfptoui_nxv4f64_nxv4i8(<vscale x 4 x double> %va) {
; CHECK-LABEL: vfptoui_nxv4f64_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 4 x double> %va to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %evec
}

define <vscale x 4 x i16> @vfptosi_nxv4f64_nxv4i16(<vscale x 4 x double> %va) {
; CHECK-LABEL: vfptosi_nxv4f64_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 4 x double> %va to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %evec
}

define <vscale x 4 x i16> @vfptoui_nxv4f64_nxv4i16(<vscale x 4 x double> %va) {
; CHECK-LABEL: vfptoui_nxv4f64_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 4 x double> %va to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %evec
}

define <vscale x 4 x i32> @vfptosi_nxv4f64_nxv4i32(<vscale x 4 x double> %va) {
; CHECK-LABEL: vfptosi_nxv4f64_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 4 x double> %va to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %evec
}

define <vscale x 4 x i32> @vfptoui_nxv4f64_nxv4i32(<vscale x 4 x double> %va) {
; CHECK-LABEL: vfptoui_nxv4f64_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v12, v8
; CHECK-NEXT:    vmv.v.v v8, v12
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 4 x double> %va to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %evec
}

define <vscale x 4 x i64> @vfptosi_nxv4f64_nxv4i64(<vscale x 4 x double> %va) {
; CHECK-LABEL: vfptosi_nxv4f64_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 4 x double> %va to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %evec
}

define <vscale x 4 x i64> @vfptoui_nxv4f64_nxv4i64(<vscale x 4 x double> %va) {
; CHECK-LABEL: vfptoui_nxv4f64_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 4 x double> %va to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %evec
}

define <vscale x 8 x i1> @vfptosi_nxv8f64_nxv8i1(<vscale x 8 x double> %va) {
; CHECK-LABEL: vfptosi_nxv8f64_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v16, v8
; CHECK-NEXT:    vand.vi v8, v16, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 8 x double> %va to <vscale x 8 x i1>
  ret <vscale x 8 x i1> %evec
}

define <vscale x 8 x i1> @vfptoui_nxv8f64_nxv8i1(<vscale x 8 x double> %va) {
; CHECK-LABEL: vfptoui_nxv8f64_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v16, v8
; CHECK-NEXT:    vand.vi v8, v16, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 8 x double> %va to <vscale x 8 x i1>
  ret <vscale x 8 x i1> %evec
}

define <vscale x 8 x i8> @vfptosi_nxv8f64_nxv8i8(<vscale x 8 x double> %va) {
; CHECK-LABEL: vfptosi_nxv8f64_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v16, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 8 x double> %va to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %evec
}

define <vscale x 8 x i8> @vfptoui_nxv8f64_nxv8i8(<vscale x 8 x double> %va) {
; CHECK-LABEL: vfptoui_nxv8f64_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v16, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 8 x double> %va to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %evec
}

define <vscale x 8 x i16> @vfptosi_nxv8f64_nxv8i16(<vscale x 8 x double> %va) {
; CHECK-LABEL: vfptosi_nxv8f64_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v16, 0
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 8 x double> %va to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %evec
}

define <vscale x 8 x i16> @vfptoui_nxv8f64_nxv8i16(<vscale x 8 x double> %va) {
; CHECK-LABEL: vfptoui_nxv8f64_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v16, 0
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 8 x double> %va to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %evec
}

define <vscale x 8 x i32> @vfptosi_nxv8f64_nxv8i32(<vscale x 8 x double> %va) {
; CHECK-LABEL: vfptosi_nxv8f64_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.x.f.w v16, v8
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 8 x double> %va to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %evec
}

define <vscale x 8 x i32> @vfptoui_nxv8f64_nxv8i32(<vscale x 8 x double> %va) {
; CHECK-LABEL: vfptoui_nxv8f64_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.rtz.xu.f.w v16, v8
; CHECK-NEXT:    vmv.v.v v8, v16
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 8 x double> %va to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %evec
}

define <vscale x 8 x i64> @vfptosi_nxv8f64_nxv8i64(<vscale x 8 x double> %va) {
; CHECK-LABEL: vfptosi_nxv8f64_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfcvt.rtz.x.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = fptosi <vscale x 8 x double> %va to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %evec
}

define <vscale x 8 x i64> @vfptoui_nxv8f64_nxv8i64(<vscale x 8 x double> %va) {
; CHECK-LABEL: vfptoui_nxv8f64_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfcvt.rtz.xu.f.v v8, v8
; CHECK-NEXT:    ret
  %evec = fptoui <vscale x 8 x double> %va to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %evec
}
