; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64

define void @splat_v16i8(ptr %x, i8 %y) {
; CHECK-LABEL: splat_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a1
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %a = insertelement <16 x i8> poison, i8 %y, i32 0
  %b = shufflevector <16 x i8> %a, <16 x i8> poison, <16 x i32> zeroinitializer
  store <16 x i8> %b, ptr %x
  ret void
}

define void @splat_v8i16(ptr %x, i16 %y) {
; CHECK-LABEL: splat_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a1
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = insertelement <8 x i16> poison, i16 %y, i32 0
  %b = shufflevector <8 x i16> %a, <8 x i16> poison, <8 x i32> zeroinitializer
  store <8 x i16> %b, ptr %x
  ret void
}

define void @splat_v4i32(ptr %x, i32 %y) {
; CHECK-LABEL: splat_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a1
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = insertelement <4 x i32> poison, i32 %y, i32 0
  %b = shufflevector <4 x i32> %a, <4 x i32> poison, <4 x i32> zeroinitializer
  store <4 x i32> %b, ptr %x
  ret void
}

define void @splat_v2i64(ptr %x, i64 %y) {
; RV32-LABEL: splat_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    sw a2, 12(sp)
; RV32-NEXT:    addi a1, sp, 8
; RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v8, (a1), zero
; RV32-NEXT:    vse64.v v8, (a0)
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    .cfi_def_cfa_offset 0
; RV32-NEXT:    ret
;
; RV64-LABEL: splat_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV64-NEXT:    vmv.v.x v8, a1
; RV64-NEXT:    vse64.v v8, (a0)
; RV64-NEXT:    ret
  %a = insertelement <2 x i64> poison, i64 %y, i32 0
  %b = shufflevector <2 x i64> %a, <2 x i64> poison, <2 x i32> zeroinitializer
  store <2 x i64> %b, ptr %x
  ret void
}

define void @splat_v32i8(ptr %x, i8 %y) {
; CHECK-LABEL: splat_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e8, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a1
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %a = insertelement <32 x i8> poison, i8 %y, i32 0
  %b = shufflevector <32 x i8> %a, <32 x i8> poison, <32 x i32> zeroinitializer
  store <32 x i8> %b, ptr %x
  ret void
}

define void @splat_v16i16(ptr %x, i16 %y) {
; CHECK-LABEL: splat_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a1
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %a = insertelement <16 x i16> poison, i16 %y, i32 0
  %b = shufflevector <16 x i16> %a, <16 x i16> poison, <16 x i32> zeroinitializer
  store <16 x i16> %b, ptr %x
  ret void
}

define void @splat_v8i32(ptr %x, i32 %y) {
; CHECK-LABEL: splat_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vmv.v.x v8, a1
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %a = insertelement <8 x i32> poison, i32 %y, i32 0
  %b = shufflevector <8 x i32> %a, <8 x i32> poison, <8 x i32> zeroinitializer
  store <8 x i32> %b, ptr %x
  ret void
}

define void @splat_v4i64(ptr %x, i64 %y) {
; RV32-LABEL: splat_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    sw a2, 12(sp)
; RV32-NEXT:    addi a1, sp, 8
; RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; RV32-NEXT:    vlse64.v v8, (a1), zero
; RV32-NEXT:    vse64.v v8, (a0)
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    .cfi_def_cfa_offset 0
; RV32-NEXT:    ret
;
; RV64-LABEL: splat_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; RV64-NEXT:    vmv.v.x v8, a1
; RV64-NEXT:    vse64.v v8, (a0)
; RV64-NEXT:    ret
  %a = insertelement <4 x i64> poison, i64 %y, i32 0
  %b = shufflevector <4 x i64> %a, <4 x i64> poison, <4 x i32> zeroinitializer
  store <4 x i64> %b, ptr %x
  ret void
}

define void @splat_zero_v16i8(ptr %x) {
; CHECK-LABEL: splat_zero_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  store <16 x i8> splat (i8 0), ptr %x
  ret void
}

define void @splat_zero_v8i16(ptr %x) {
; CHECK-LABEL: splat_zero_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  store <8 x i16> splat (i16 0), ptr %x
  ret void
}

define void @splat_zero_v4i32(ptr %x) {
; CHECK-LABEL: splat_zero_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  store <4 x i32> splat (i32 0), ptr %x
  ret void
}

define void @splat_zero_v2i64(ptr %x) {
; CHECK-LABEL: splat_zero_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  store <2 x i64> splat (i64 0), ptr %x
  ret void
}

define void @splat_zero_v32i8(ptr %x) {
; CHECK-LABEL: splat_zero_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  store <32 x i8> splat (i8 0), ptr %x
  ret void
}

define void @splat_zero_v16i16(ptr %x) {
; CHECK-LABEL: splat_zero_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  store <16 x i16> splat (i16 0), ptr %x
  ret void
}

define void @splat_zero_v8i32(ptr %x) {
; CHECK-LABEL: splat_zero_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  store <8 x i32> splat (i32 0), ptr %x
  ret void
}

define void @splat_zero_v4i64(ptr %x) {
; CHECK-LABEL: splat_zero_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  store <4 x i64> splat (i64 0), ptr %x
  ret void
}

define void @splat_zero_v2i16(ptr %p) {
; CHECK-LABEL: splat_zero_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sw zero, 0(a0)
; CHECK-NEXT:    ret
  store <2 x i16> zeroinitializer, ptr %p
  ret void
}

define void @splat_zero_v2i16_unaligned(ptr %p) {
; CHECK-LABEL: splat_zero_v2i16_unaligned:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  store <2 x i16> zeroinitializer, ptr %p, align 1
  ret void
}

define void @splat_zero_v4i16(ptr %p) {
; RV32-LABEL: splat_zero_v4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV32-NEXT:    vmv.v.i v8, 0
; RV32-NEXT:    vse16.v v8, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: splat_zero_v4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    sd zero, 0(a0)
; RV64-NEXT:    ret
  store <4 x i16> zeroinitializer, ptr %p
  ret void
}

define void @splat_zero_v2i32(ptr %p) {
; RV32-LABEL: splat_zero_v2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; RV32-NEXT:    vmv.v.i v8, 0
; RV32-NEXT:    vse32.v v8, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: splat_zero_v2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    sd zero, 0(a0)
; RV64-NEXT:    ret
  store <2 x i32> zeroinitializer, ptr %p
  ret void
}

; Not a power of two and requires more than two scalar stores.
define void @splat_zero_v7i16(ptr %p) {
; CHECK-LABEL: splat_zero_v7i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 7, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  store <7 x i16> zeroinitializer, ptr %p
  ret void
}

define void @splat_allones_v16i8(ptr %x) {
; CHECK-LABEL: splat_allones_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, -1
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  store <16 x i8> splat (i8 -1), ptr %x
  ret void
}

define void @splat_allones_v8i16(ptr %x) {
; CHECK-LABEL: splat_allones_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, -1
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  store <8 x i16> splat (i16 -1), ptr %x
  ret void
}

define void @splat_allones_v4i32(ptr %x) {
; CHECK-LABEL: splat_allones_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, -1
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  store <4 x i32> splat (i32 -1), ptr %x
  ret void
}

define void @splat_allones_v2i64(ptr %x) {
; CHECK-LABEL: splat_allones_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vmv.v.i v8, -1
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  store <2 x i64> splat (i64 -1), ptr %x
  ret void
}

define void @splat_allones_v32i8(ptr %x) {
; CHECK-LABEL: splat_allones_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, -1
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  store <32 x i8> splat (i8 -1), ptr %x
  ret void
}

define void @splat_allones_v16i16(ptr %x) {
; CHECK-LABEL: splat_allones_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, -1
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  store <16 x i16> splat (i16 -1), ptr %x
  ret void
}

define void @splat_allones_v8i32(ptr %x) {
; CHECK-LABEL: splat_allones_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, -1
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  store <8 x i32> splat (i32 -1), ptr %x
  ret void
}

define void @splat_allones_v4i64(ptr %x) {
; CHECK-LABEL: splat_allones_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vmv.v.i v8, -1
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  store <4 x i64> splat (i64 -1), ptr %x
  ret void
}

; This requires a bitcast on RV32 due to type legalization rewriting the
; build_vector to v8i32.
; FIXME: We should prevent this and use the implicit sign extension of vmv.v.x
; with SEW=64 on RV32.
define void @splat_allones_with_use_v4i64(ptr %x) {
; CHECK-LABEL: splat_allones_with_use_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vadd.vi v8, v8, -1
; CHECK-NEXT:    vse64.v v8, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i64>, ptr %x
  %b = add <4 x i64> %a, <i64 -1, i64 -1, i64 -1, i64 -1>
  store <4 x i64> %b, ptr %x
  ret void
}

; This test used to crash at LMUL=8 when inserting a v16i64 subvector into
; nxv8i64 at index 0: the v16i64 type was used to get the LMUL, the size of
; which exceeded maximum-expected size of 512. The scalable container type of
; nxv8i64 should have been used instead.
define void @vadd_vx_v16i64(ptr %a, i64 %b, ptr %c) {
; RV32-LABEL: vadd_vx_v16i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    sw a2, 12(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vadd.vv v8, v8, v16
; RV32-NEXT:    vse64.v v8, (a3)
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    .cfi_def_cfa_offset 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vadd_vx_v16i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    vadd.vx v8, v8, a1
; RV64-NEXT:    vse64.v v8, (a2)
; RV64-NEXT:    ret
  %va = load <16 x i64>, ptr %a
  %head = insertelement <16 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <16 x i64> %head, <16 x i64> poison, <16 x i32> zeroinitializer
  %vc = add <16 x i64> %va, %splat
  store <16 x i64> %vc, ptr %c
  ret void
}

define <2 x i64> @vadd_vx_v2i64_to_sub(<2 x i64> %va) {
; RV32-LABEL: vadd_vx_v2i64_to_sub:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    li a0, -256
; RV32-NEXT:    li a1, 1
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vadd.vv v8, v8, v9
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    .cfi_def_cfa_offset 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vadd_vx_v2i64_to_sub:
; RV64:       # %bb.0:
; RV64-NEXT:    li a0, -1
; RV64-NEXT:    srli a0, a0, 24
; RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV64-NEXT:    vsub.vx v8, v8, a0
; RV64-NEXT:    ret
  %v = add <2 x i64> splat (i64 -1099511627775), %va
  ret <2 x i64> %v
}

define <2 x i64> @vadd_vx_v2i64_to_sub_swapped(<2 x i64> %va) {
; RV32-LABEL: vadd_vx_v2i64_to_sub_swapped:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    li a0, -256
; RV32-NEXT:    li a1, 1
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vadd.vv v8, v8, v9
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    .cfi_def_cfa_offset 0
; RV32-NEXT:    ret
;
; RV64-LABEL: vadd_vx_v2i64_to_sub_swapped:
; RV64:       # %bb.0:
; RV64-NEXT:    li a0, -1
; RV64-NEXT:    srli a0, a0, 24
; RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV64-NEXT:    vsub.vx v8, v8, a0
; RV64-NEXT:    ret
  %v = add <2 x i64> %va, splat (i64 -1099511627775)
  ret <2 x i64> %v
}
