; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt -disable-output "-passes=print<scalar-evolution>" \
; RUN:  -scalar-evolution-classify-expressions=0 < %s 2>&1 | FileCheck %s

define i32 @exit_count_samesign(i32 %iter.count, ptr %ptr) {
; CHECK-LABEL: 'exit_count_samesign'
; CHECK-NEXT:  Determining loop execution counts for: @exit_count_samesign
; CHECK-NEXT:  Loop %inner.loop: backedge-taken count is {(-2 + %iter.count),+,-1}<nw><%outer.loop>
; CHECK-NEXT:  Loop %inner.loop: constant max backedge-taken count is i32 2147483646
; CHECK-NEXT:  Loop %inner.loop: symbolic max backedge-taken count is {(-2 + %iter.count),+,-1}<nw><%outer.loop>
; CHECK-NEXT:  Loop %inner.loop: Trip multiple is 1
; CHECK-NEXT:  Loop %outer.loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %outer.loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %outer.loop: Unpredictable symbolic max backedge-taken count.
;
entry:
  br label %outer.loop

ph:
  br label %outer.loop

outer.loop:
  %iv.outer = phi i32 [ %iv.outer.1, %ph ], [ %iter.count, %entry ]
  %iv.outer.1 = add nsw i32 %iv.outer, -1
  %ext.outer = zext nneg i32 %iv.outer.1 to i64
  %gep.outer = getelementptr double, ptr %ptr, i64 %ext.outer
  store double poison, ptr %gep.outer
  %exit.cond.outer = icmp samesign ugt i32 %iv.outer, 1
  br i1 %exit.cond.outer, label %inner.loop, label %ph

inner.loop:
  %iv.inner = phi i32 [ %iv.next, %inner.loop ], [ 0, %outer.loop ]
  %ext.inner = zext nneg i32 %iv.inner to i64
  %gep.inner = getelementptr double, ptr %ptr, i64 %ext.inner
  store double poison, ptr %gep.inner
  %iv.next = add nuw nsw i32 %iv.inner, 1
  %exit.cond.inner = icmp slt i32 %iv.next, %iv.outer.1
  br i1 %exit.cond.inner, label %inner.loop, label %ph

exit:
  ret i32 0
}
