; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=CHECK

; In the following patterns, lhs and rhs of the or instruction have no common bits.
; Therefore, "add" and "or" instructions are equal.

define <2 x i32> @or_and_and_rhs_neg_vec_i32(<2 x i32> %x, <2 x i32> %y, <2 x i32> %z) {
; CHECK-LABEL: or_and_and_rhs_neg_vec_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorps %xmm0, %xmm0
; CHECK-NEXT:    retq
  %and1 = and <2 x i32> %z, %y
  %xor = xor <2 x i32> %y, <i32 -1, i32 -1>
  %and2 = and <2 x i32> %x, %xor
  %or = or <2 x i32> %and1, %and2
  %add = add <2 x i32> %and1, %and2
  %sub = sub <2 x i32> %or, %add
  ret <2 x i32> %sub
}

define <2 x i32> @or_and_and_lhs_neg_vec_i32(<2 x i32> %x, <2 x i32> %y, <2 x i32> %z) {
; CHECK-LABEL: or_and_and_lhs_neg_vec_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorps %xmm0, %xmm0
; CHECK-NEXT:    retq
  %and1 = and <2 x i32> %z, %y
  %xor = xor <2 x i32> %y, <i32 -1, i32 -1>
  %and2 = and <2 x i32> %xor, %x
  %or = or <2 x i32> %and1, %and2
  %add = add <2 x i32> %and1, %and2
  %sub = sub <2 x i32> %or, %add
  ret <2 x i32> %sub
}

define <2 x i32> @or_and_rhs_neg_and_vec_i32(<2 x i32> %x, <2 x i32> %y, <2 x i32> %z) {
; CHECK-LABEL: or_and_rhs_neg_and_vec_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorps %xmm0, %xmm0
; CHECK-NEXT:    retq
  %xor = xor <2 x i32> %y, <i32 -1, i32 -1>
  %and1 = and <2 x i32> %z, %xor
  %and2 = and <2 x i32> %x, %y
  %or = or <2 x i32> %and1, %and2
  %add = add <2 x i32> %and1, %and2
  %sub = sub <2 x i32> %or, %add
  ret <2 x i32> %sub
}

define <2 x i32> @or_and_lhs_neg_and_vec_i32(<2 x i32> %x, <2 x i32> %y, <2 x i32> %z) {
; CHECK-LABEL: or_and_lhs_neg_and_vec_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorps %xmm0, %xmm0
; CHECK-NEXT:    retq
  %xor = xor <2 x i32> %y, <i32 -1, i32 -1>
  %and1 = and <2 x i32> %xor, %z
  %and2 = and <2 x i32> %x, %y
  %or = or <2 x i32> %and1, %and2
  %add = add <2 x i32> %and1, %and2
  %sub = sub <2 x i32> %or, %add
  ret <2 x i32> %sub
}

define <2 x i64> @or_and_and_rhs_neg_vec_i64(<2 x i64> %x, <2 x i64> %y, <2 x i64> %z) {
; CHECK-LABEL: or_and_and_rhs_neg_vec_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorps %xmm0, %xmm0
; CHECK-NEXT:    retq
  %and1 = and <2 x i64> %z, %y
  %xor = xor <2 x i64> %y, <i64 -1, i64 -1>
  %and2 = and <2 x i64> %x, %xor
  %or = or <2 x i64> %and1, %and2
  %add = add <2 x i64> %and1, %and2
  %sub = sub <2 x i64> %or, %add
  ret <2 x i64> %sub
}

define <2 x i64> @or_and_and_lhs_neg_vec_i64(<2 x i64> %x, <2 x i64> %y, <2 x i64> %z) {
; CHECK-LABEL: or_and_and_lhs_neg_vec_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorps %xmm0, %xmm0
; CHECK-NEXT:    retq
  %and1 = and <2 x i64> %z, %y
  %xor = xor <2 x i64> %y, <i64 -1, i64 -1>
  %and2 = and <2 x i64> %xor, %x
  %or = or <2 x i64> %and1, %and2
  %add = add <2 x i64> %and1, %and2
  %sub = sub <2 x i64> %or, %add
  ret <2 x i64> %sub
}

define <2 x i64> @or_and_rhs_neg_and_vec_i64(<2 x i64> %x, <2 x i64> %y, <2 x i64> %z) {
; CHECK-LABEL: or_and_rhs_neg_and_vec_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorps %xmm0, %xmm0
; CHECK-NEXT:    retq
  %xor = xor <2 x i64> %y, <i64 -1, i64 -1>
  %and1 = and <2 x i64> %z, %xor
  %and2 = and <2 x i64> %x, %y
  %or = or <2 x i64> %and1, %and2
  %add = add <2 x i64> %and1, %and2
  %sub = sub <2 x i64> %or, %add
  ret <2 x i64> %sub
}

define <2 x i64> @or_and_lhs_neg_and_vec_i64(<2 x i64> %x, <2 x i64> %y, <2 x i64> %z) {
; CHECK-LABEL: or_and_lhs_neg_and_vec_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorps %xmm0, %xmm0
; CHECK-NEXT:    retq
  %xor = xor <2 x i64> %y, <i64 -1, i64 -1>
  %and1 = and <2 x i64> %xor, %z
  %and2 = and <2 x i64> %x, %y
  %or = or <2 x i64> %and1, %and2
  %add = add <2 x i64> %and1, %and2
  %sub = sub <2 x i64> %or, %add
  ret <2 x i64> %sub
}
