; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; Test 128-bit division and remainder in vector registers on z13 using libcalls
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s

; Divide signed.
define i128 @f1(i128 %a, i128 %b) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    stmg %r13, %r15, 104(%r15)
; CHECK-NEXT:    .cfi_offset %r13, -56
; CHECK-NEXT:    .cfi_offset %r14, -48
; CHECK-NEXT:    .cfi_offset %r15, -40
; CHECK-NEXT:    aghi %r15, -208
; CHECK-NEXT:    .cfi_def_cfa_offset 368
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    lgr %r13, %r2
; CHECK-NEXT:    la %r2, 192(%r15)
; CHECK-NEXT:    la %r3, 176(%r15)
; CHECK-NEXT:    la %r4, 160(%r15)
; CHECK-NEXT:    vst %v1, 160(%r15), 3
; CHECK-NEXT:    vst %v0, 176(%r15), 3
; CHECK-NEXT:    brasl %r14, __divti3@PLT
; CHECK-NEXT:    vl %v0, 192(%r15), 3
; CHECK-NEXT:    vst %v0, 0(%r13), 3
; CHECK-NEXT:    lmg %r13, %r15, 312(%r15)
; CHECK-NEXT:    br %r14
  %res = sdiv i128 %a, %b
  ret i128 %res
}

; Divide unsigned.
define i128 @f2(i128 %a, i128 %b) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    stmg %r13, %r15, 104(%r15)
; CHECK-NEXT:    .cfi_offset %r13, -56
; CHECK-NEXT:    .cfi_offset %r14, -48
; CHECK-NEXT:    .cfi_offset %r15, -40
; CHECK-NEXT:    aghi %r15, -208
; CHECK-NEXT:    .cfi_def_cfa_offset 368
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    lgr %r13, %r2
; CHECK-NEXT:    la %r2, 192(%r15)
; CHECK-NEXT:    la %r3, 176(%r15)
; CHECK-NEXT:    la %r4, 160(%r15)
; CHECK-NEXT:    vst %v1, 160(%r15), 3
; CHECK-NEXT:    vst %v0, 176(%r15), 3
; CHECK-NEXT:    brasl %r14, __udivti3@PLT
; CHECK-NEXT:    vl %v0, 192(%r15), 3
; CHECK-NEXT:    vst %v0, 0(%r13), 3
; CHECK-NEXT:    lmg %r13, %r15, 312(%r15)
; CHECK-NEXT:    br %r14
  %res = udiv i128 %a, %b
  ret i128 %res
}

; Remainder signed.
define i128 @f3(i128 %a, i128 %b) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    stmg %r13, %r15, 104(%r15)
; CHECK-NEXT:    .cfi_offset %r13, -56
; CHECK-NEXT:    .cfi_offset %r14, -48
; CHECK-NEXT:    .cfi_offset %r15, -40
; CHECK-NEXT:    aghi %r15, -208
; CHECK-NEXT:    .cfi_def_cfa_offset 368
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    lgr %r13, %r2
; CHECK-NEXT:    la %r2, 192(%r15)
; CHECK-NEXT:    la %r3, 176(%r15)
; CHECK-NEXT:    la %r4, 160(%r15)
; CHECK-NEXT:    vst %v1, 160(%r15), 3
; CHECK-NEXT:    vst %v0, 176(%r15), 3
; CHECK-NEXT:    brasl %r14, __modti3@PLT
; CHECK-NEXT:    vl %v0, 192(%r15), 3
; CHECK-NEXT:    vst %v0, 0(%r13), 3
; CHECK-NEXT:    lmg %r13, %r15, 312(%r15)
; CHECK-NEXT:    br %r14
  %res = srem i128 %a, %b
  ret i128 %res
}

; Remainder unsigned.
define i128 @f4(i128 %a, i128 %b) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    stmg %r13, %r15, 104(%r15)
; CHECK-NEXT:    .cfi_offset %r13, -56
; CHECK-NEXT:    .cfi_offset %r14, -48
; CHECK-NEXT:    .cfi_offset %r15, -40
; CHECK-NEXT:    aghi %r15, -208
; CHECK-NEXT:    .cfi_def_cfa_offset 368
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    lgr %r13, %r2
; CHECK-NEXT:    la %r2, 192(%r15)
; CHECK-NEXT:    la %r3, 176(%r15)
; CHECK-NEXT:    la %r4, 160(%r15)
; CHECK-NEXT:    vst %v1, 160(%r15), 3
; CHECK-NEXT:    vst %v0, 176(%r15), 3
; CHECK-NEXT:    brasl %r14, __umodti3@PLT
; CHECK-NEXT:    vl %v0, 192(%r15), 3
; CHECK-NEXT:    vst %v0, 0(%r13), 3
; CHECK-NEXT:    lmg %r13, %r15, 312(%r15)
; CHECK-NEXT:    br %r14
  %res = urem i128 %a, %b
  ret i128 %res
}
