; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx700 < %s | FileCheck -check-prefixes=GFX7,GFX7-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx801 < %s | FileCheck -check-prefixes=GFX8,GFX8-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx942 < %s | FileCheck -check-prefixes=GFX9,GFX9-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1010 < %s | FileCheck -check-prefixes=GFX10,GFX10-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-SDAG,GFX11-SDAG-TRUE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-SDAG,GFX11-SDAG-FAKE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-SDAG,GFX12-SDAG-TRUE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-SDAG,GFX12-SDAG-FAKE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-GISEL,GFX12-GISEL-TRUE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-GISEL,GFX12-GISEL-FAKE16 %s

define half @test_vector_reduce_fminimum_v2half(<2 x half> %v) {
; GFX7-LABEL: test_vector_reduce_fminimum_v2half:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_mov_b32_e32 v2, 0x7fc00000
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_min_f32_e32 v3, v0, v1
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fminimum_v2half:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX8-NEXT:    v_min_f16_e32 v2, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v3, 0x7e00
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fminimum_v2half:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_min_f16_sdwa v1, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x7e00
; GFX9-NEXT:    v_cmp_o_f16_sdwa vcc, v0, v0 src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fminimum_v2half:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_min_f16_sdwa v1, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v0, v0 src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v1, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_fminimum_v2half:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_min_f16_e32 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x7e00, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_fminimum_v2half:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_min_f16_e32 v2, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_fminimum_v2half:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_minimum_f16 v0.l, v0.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_fminimum_v2half:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_minimum_f16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-TRUE16-LABEL: test_vector_reduce_fminimum_v2half:
; GFX12-GISEL-TRUE16:       ; %bb.0: ; %entry
; GFX12-GISEL-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v0.l, v0.l, v0.h
; GFX12-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-FAKE16-LABEL: test_vector_reduce_fminimum_v2half:
; GFX12-GISEL-FAKE16:       ; %bb.0: ; %entry
; GFX12-GISEL-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call half @llvm.vector.reduce.fminimum.v2half(<2 x half> %v)
  ret half %res
}

define half @test_vector_reduce_fminimum_v3half(<3 x half> %v) {
; GFX7-LABEL: test_vector_reduce_fminimum_v3half:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_mov_b32_e32 v4, 0x7fc00000
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_min_f32_e32 v3, v0, v1
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v4, v3, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v4, v1, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fminimum_v3half:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX8-NEXT:    v_min_f16_e32 v3, v0, v2
; GFX8-NEXT:    v_mov_b32_e32 v4, 0x7e00
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v4, v3, vcc
; GFX8-NEXT:    v_min_f16_e32 v2, v0, v1
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fminimum_v3half:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_min_f16_sdwa v2, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_mov_b32_e32 v3, 0x7e00
; GFX9-NEXT:    v_cmp_o_f16_sdwa vcc, v0, v0 src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    v_min_f16_e32 v2, v0, v1
; GFX9-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fminimum_v3half:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_min_f16_sdwa v2, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v0, v0 src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX10-NEXT:    v_min_f16_e32 v2, v0, v1
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_fminimum_v3half:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_min_f16_e32 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x7e00, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_min_f16_e32 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x7e00, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_fminimum_v3half:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_min_f16_e32 v3, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_min_f16_e32 v2, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_fminimum_v3half:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.h, 0x7c00
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_pk_minimum_f16 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    v_minimum_f16 v0.l, v0.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_fminimum_v3half:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_movk_i32 s0, 0x7c00
; GFX12-SDAG-FAKE16-NEXT:    s_wait_alu 0xfffe
; GFX12-SDAG-FAKE16-NEXT:    v_perm_b32 v1, s0, v1, 0x5040100
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_pk_minimum_f16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_minimum_f16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-TRUE16-LABEL: test_vector_reduce_fminimum_v3half:
; GFX12-GISEL-TRUE16:       ; %bb.0: ; %entry
; GFX12-GISEL-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v0.l, v0.l, v0.h
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-FAKE16-LABEL: test_vector_reduce_fminimum_v3half:
; GFX12-GISEL-FAKE16:       ; %bb.0: ; %entry
; GFX12-GISEL-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v0, v0, v2
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call half @llvm.vector.reduce.fminimum.v3half(<3 x half> %v)
  ret half %res
}

define half @test_vector_reduce_fminimum_v4half(<4 x half> %v) {
; GFX7-LABEL: test_vector_reduce_fminimum_v4half:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX7-NEXT:    v_min_f32_e32 v4, v0, v1
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v5, v4, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v5, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v3
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v3
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v5, v1, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fminimum_v4half:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX8-NEXT:    v_min_f16_e32 v4, v0, v3
; GFX8-NEXT:    v_mov_b32_e32 v5, 0x7e00
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v5, v4, vcc
; GFX8-NEXT:    v_min_f16_e32 v3, v0, v1
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v5, v3, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v2
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v5, v1, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fminimum_v4half:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_min_f16_sdwa v2, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_mov_b32_e32 v3, 0x7e00
; GFX9-NEXT:    v_cmp_o_f16_sdwa vcc, v0, v0 src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    v_min_f16_e32 v2, v0, v1
; GFX9-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    v_min_f16_sdwa v2, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_cmp_o_f16_sdwa vcc, v0, v1 src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fminimum_v4half:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_min_f16_sdwa v2, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v0, v0 src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX10-NEXT:    v_min_f16_e32 v2, v0, v1
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX10-NEXT:    v_min_f16_sdwa v2, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v0, v1 src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_fminimum_v4half:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_min_f16_e32 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x7e00, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_min_f16_e32 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x7e00, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0.l, v1.h
; GFX11-SDAG-TRUE16-NEXT:    v_min_f16_e32 v0.l, v0.l, v1.h
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x7e00, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_fminimum_v4half:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_min_f16_e32 v3, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_min_f16_e32 v2, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_min_f16_e32 v1, v0, v3
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v3
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v1, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_fminimum_v4half:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_pk_minimum_f16 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_minimum_f16 v0.l, v0.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_fminimum_v4half:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_pk_minimum_f16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    v_minimum_f16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-TRUE16-LABEL: test_vector_reduce_fminimum_v4half:
; GFX12-GISEL-TRUE16:       ; %bb.0: ; %entry
; GFX12-GISEL-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v0.l, v0.l, v0.h
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v0.h, v1.l, v1.h
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v0.l, v0.l, v0.h
; GFX12-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-FAKE16-LABEL: test_vector_reduce_fminimum_v4half:
; GFX12-GISEL-FAKE16:       ; %bb.0: ; %entry
; GFX12-GISEL-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v0, v0, v2
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v1, v1, v3
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call half @llvm.vector.reduce.fminimum.v4half(<4 x half> %v)
  ret half %res
}

define half @test_vector_reduce_fminimum_v8half(<8 x half> %v) {
; GFX7-LABEL: test_vector_reduce_fminimum_v8half:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_min_f32_e32 v8, v0, v1
; GFX7-NEXT:    v_mov_b32_e32 v9, 0x7fc00000
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v9, v8, vcc
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v3
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v3
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v4
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v4
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v5
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v5
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v6
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v6
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v7
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v7
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fminimum_v8half:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 16, v0
; GFX8-NEXT:    v_min_f16_e32 v8, v0, v7
; GFX8-NEXT:    v_mov_b32_e32 v9, 0x7e00
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v9, v8, vcc
; GFX8-NEXT:    v_min_f16_e32 v7, v0, v1
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v9, v7, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v6
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v2
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v5
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v3
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v4
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fminimum_v8half:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_min_f16 v4, v0, v2
; GFX9-NEXT:    v_mov_b32_e32 v5, 0x7e00
; GFX9-NEXT:    v_cmp_o_f16_e32 vcc, v0, v2
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v5, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX9-NEXT:    v_cmp_o_f16_sdwa vcc, v0, v2 src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v4, vcc
; GFX9-NEXT:    v_min_f16_e32 v2, v6, v0
; GFX9-NEXT:    v_cmp_o_f16_e32 vcc, v6, v0
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    v_pk_min_f16 v2, v1, v3
; GFX9-NEXT:    v_cmp_o_f16_e32 vcc, v1, v3
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v5, v2, vcc
; GFX9-NEXT:    v_min_f16_e32 v6, v0, v4
; GFX9-NEXT:    v_cmp_o_f16_e32 vcc, v0, v4
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v6, vcc
; GFX9-NEXT:    v_cmp_o_f16_sdwa vcc, v1, v3 src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_sdwa v1, v5, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_min_f16_e32 v2, v0, v1
; GFX9-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v2, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fminimum_v8half:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_min_f16 v4, v0, v2
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v4, 0x7e00, v4, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v0, v2 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_pk_min_f16 v2, v1, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v5, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v3
; GFX10-NEXT:    v_min_f16_e32 v5, v4, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v6, 0x7e00, v2, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v4, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v5, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v1, v3 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_mov_b32_e32 v1, 0x7e00
; GFX10-NEXT:    v_min_f16_e32 v4, v0, v6
; GFX10-NEXT:    v_cmp_o_f16_e64 s4, v0, v6
; GFX10-NEXT:    v_cndmask_b32_sdwa v1, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 0x7e00, v4, s4
; GFX10-NEXT:    v_min_f16_e32 v2, v0, v1
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_fminimum_v8half:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_min_f16 v4, v0, v2
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e64 s0, v0.h, v2.h
; GFX11-SDAG-TRUE16-NEXT:    v_pk_min_f16 v2, v1, v3
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x7e00, v4.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, 0x7e00, v4.h, s0
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e64 s0, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_min_f16_e32 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, 0x7e00, v2.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1.h, v3.h
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x7e00, v0.l, s0
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e64 s0, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_min_f16_e32 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, 0x7e00, v2.h, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x7e00, v0.l, s0
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_min_f16_e32 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x7e00, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_fminimum_v8half:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_pk_min_f16 v4, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v4
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v6, v5
; GFX11-SDAG-FAKE16-NEXT:    v_pk_min_f16 v4, v1, v3
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v2, 0x7e00, v7, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v3
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    v_min_f16_e32 v5, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v6, 0x7e00, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v5, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_min_f16_e32 v3, v0, v6
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v6
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v3, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v2
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_min_f16_e32 v2, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_fminimum_v8half:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_pk_minimum_f16 v1, v1, v3
; GFX12-SDAG-TRUE16-NEXT:    v_pk_minimum_f16 v0, v0, v2
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_pk_minimum_f16 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    v_minimum_f16 v0.l, v0.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_fminimum_v8half:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_pk_minimum_f16 v1, v1, v3
; GFX12-SDAG-FAKE16-NEXT:    v_pk_minimum_f16 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_pk_minimum_f16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_minimum_f16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-TRUE16-LABEL: test_vector_reduce_fminimum_v8half:
; GFX12-GISEL-TRUE16:       ; %bb.0: ; %entry
; GFX12-GISEL-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v0.l, v0.l, v0.h
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v0.h, v1.l, v1.h
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v1.l, v2.l, v2.h
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v1.h, v3.l, v3.h
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v0.l, v0.l, v0.h
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v0.h, v1.l, v1.h
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v0.l, v0.l, v0.h
; GFX12-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-FAKE16-LABEL: test_vector_reduce_fminimum_v8half:
; GFX12-GISEL-FAKE16:       ; %bb.0: ; %entry
; GFX12-GISEL-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v0, v0, v4
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v1, v1, v5
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v2, v2, v6
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v3, v3, v7
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v1, v2, v3
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call half @llvm.vector.reduce.fminimum.v8half(<8 x half> %v)
  ret half %res
}

define half @test_vector_reduce_fminimum_v16half(<16 x half> %v) {
; GFX7-LABEL: test_vector_reduce_fminimum_v16half:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_min_f32_e32 v16, v0, v1
; GFX7-NEXT:    v_mov_b32_e32 v17, 0x7fc00000
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v16, vcc
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v3
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v3
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v8
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v4
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v4
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_cvt_f16_f32_e32 v9, v9
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v5
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v5
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_cvt_f16_f32_e32 v10, v10
; GFX7-NEXT:    v_cvt_f32_f16_e32 v8, v8
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v6
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v6
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_cvt_f16_f32_e32 v11, v11
; GFX7-NEXT:    v_cvt_f32_f16_e32 v9, v9
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v7
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v7
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_cvt_f16_f32_e32 v12, v12
; GFX7-NEXT:    v_cvt_f32_f16_e32 v10, v10
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v8
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v8
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_cvt_f16_f32_e32 v13, v13
; GFX7-NEXT:    v_cvt_f32_f16_e32 v11, v11
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v9
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v9
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_cvt_f16_f32_e32 v14, v14
; GFX7-NEXT:    v_cvt_f32_f16_e32 v12, v12
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v10
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v10
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_cvt_f16_f32_e32 v15, v15
; GFX7-NEXT:    v_cvt_f32_f16_e32 v13, v13
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v11
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v11
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_cvt_f32_f16_e32 v14, v14
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v12
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v12
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_cvt_f32_f16_e32 v15, v15
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v13
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v13
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v14
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v14
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v15
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v15
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fminimum_v16half:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v15, 16, v0
; GFX8-NEXT:    v_min_f16_e32 v16, v0, v15
; GFX8-NEXT:    v_mov_b32_e32 v17, 0x7e00
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v15
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v16, vcc
; GFX8-NEXT:    v_min_f16_e32 v15, v0, v1
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v14, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v15, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v14
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v14
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v2
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 16, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v13
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v13
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v3
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 16, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v12
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v12
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v4
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 16, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v11
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v5
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v5
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 16, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v10
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v10
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v6
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v6
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 16, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v9
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v7
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v7
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 16, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f16_e32 v1, v0, v8
; GFX8-NEXT:    v_cmp_o_f16_e32 vcc, v0, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fminimum_v16half:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_min_f16 v8, v2, v6
; GFX9-NEXT:    v_mov_b32_e32 v9, 0x7e00
; GFX9-NEXT:    v_cmp_o_f16_e32 vcc, v2, v6
; GFX9-NEXT:    s_mov_b32 s0, 0x5040100
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_cndmask_b32_e32 v10, v9, v8, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; GFX9-NEXT:    v_cmp_o_f16_sdwa vcc, v2, v6 src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v9, v8, vcc
; GFX9-NEXT:    v_pk_min_f16 v8, v0, v4
; GFX9-NEXT:    v_cmp_o_f16_e32 vcc, v0, v4
; GFX9-NEXT:    v_perm_b32 v6, v2, v10, s0
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_cndmask_b32_e32 v11, v9, v8, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; GFX9-NEXT:    v_cmp_o_f16_sdwa vcc, v0, v4 src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v9, v8, vcc
; GFX9-NEXT:    v_perm_b32 v4, v0, v11, s0
; GFX9-NEXT:    v_pk_min_f16 v4, v4, v6
; GFX9-NEXT:    v_cmp_o_f16_e32 vcc, v11, v10
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v9, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX9-NEXT:    v_cmp_o_f16_e32 vcc, v0, v2
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v9, v4, vcc
; GFX9-NEXT:    v_min_f16_e32 v2, v6, v0
; GFX9-NEXT:    v_cmp_o_f16_e32 vcc, v6, v0
; GFX9-NEXT:    v_pk_min_f16 v6, v1, v5
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v9, v2, vcc
; GFX9-NEXT:    v_pk_min_f16 v2, v3, v7
; GFX9-NEXT:    v_cmp_o_f16_e32 vcc, v3, v7
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v9, v2, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_cmp_o_f16_sdwa vcc, v3, v7 src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v9, v2, vcc
; GFX9-NEXT:    v_cmp_o_f16_e32 vcc, v1, v5
; GFX9-NEXT:    v_perm_b32 v3, v2, v4, s0
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v9, v6, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; GFX9-NEXT:    v_cmp_o_f16_sdwa vcc, v1, v5 src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v9, v6, vcc
; GFX9-NEXT:    v_perm_b32 v5, v1, v7, s0
; GFX9-NEXT:    v_pk_min_f16 v3, v5, v3
; GFX9-NEXT:    v_cmp_o_f16_e32 vcc, v7, v4
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v9, v3, vcc
; GFX9-NEXT:    v_min_f16_e32 v5, v0, v4
; GFX9-NEXT:    v_cmp_o_f16_e32 vcc, v0, v4
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v9, v5, vcc
; GFX9-NEXT:    v_cmp_o_f16_e32 vcc, v1, v2
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_sdwa v1, v9, v3, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_min_f16_e32 v2, v0, v1
; GFX9-NEXT:    v_cmp_o_f16_e32 vcc, v0, v1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v9, v2, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fminimum_v16half:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_pk_min_f16 v8, v2, v6
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v2, v6
; GFX10-NEXT:    v_pk_min_f16 v9, v0, v4
; GFX10-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v8, 0x7e00, v8, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v2, v6 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v11, 16, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v2, 0x7e00, v10, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v6, 0x7e00, v9, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v0, v4 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_pk_min_f16 v9, v3, v7
; GFX10-NEXT:    v_perm_b32 v4, v2, v8, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v11, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v3, v7
; GFX10-NEXT:    v_lshrrev_b32_e32 v12, 16, v9
; GFX10-NEXT:    v_pk_min_f16 v11, v1, v5
; GFX10-NEXT:    v_perm_b32 v10, v0, v6, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v9, 0x7e00, v9, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v3, v7 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_pk_min_f16 v4, v10, v4
; GFX10-NEXT:    v_lshrrev_b32_e32 v10, 16, v11
; GFX10-NEXT:    v_cndmask_b32_e32 v3, 0x7e00, v12, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v7, 0x7e00, v11, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_sdwa vcc_lo, v1, v5 src0_sel:WORD_1 src1_sel:WORD_1
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v10, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v6, v8
; GFX10-NEXT:    v_perm_b32 v6, v3, v9, 0x5040100
; GFX10-NEXT:    v_perm_b32 v8, v1, v7, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v4, 0x7e00, v4, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v2
; GFX10-NEXT:    v_pk_min_f16 v2, v8, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v5, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v7, v9
; GFX10-NEXT:    v_min_f16_e32 v5, v4, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v6, 0x7e00, v2, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v4, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v5, vcc_lo
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v3
; GFX10-NEXT:    v_mov_b32_e32 v1, 0x7e00
; GFX10-NEXT:    v_min_f16_e32 v4, v0, v6
; GFX10-NEXT:    v_cmp_o_f16_e64 s4, v0, v6
; GFX10-NEXT:    v_cndmask_b32_sdwa v1, v1, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 0x7e00, v4, s4
; GFX10-NEXT:    v_min_f16_e32 v2, v0, v1
; GFX10-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_fminimum_v16half:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v2.l, v6.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_min_f16 v8, v2, v6
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e64 s0, v2.h, v6.h
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e64 s1, v0.l, v4.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_min_f16 v2, v0, v4
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e64 s2, v0.h, v4.h
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x7e00, v8.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, 0x7e00, v8.h, s0
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e64 s0, v3.l, v7.l
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v2.l, 0x7e00, v2.l, s1
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v2.h, 0x7e00, v2.h, s2
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e64 s1, v3.h, v7.h
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e64 s2, v1.l, v5.l
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e64 s3, v1.h, v5.h
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v2.l, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_min_f16 v4, v2, v0
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x7e00, v4.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v2.h, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_pk_min_f16 v2, v3, v7
; GFX11-SDAG-TRUE16-NEXT:    v_pk_min_f16 v3, v1, v5
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, 0x7e00, v4.h, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v1.l, 0x7e00, v2.l, s0
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v1.h, 0x7e00, v2.h, s1
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v2.l, 0x7e00, v3.l, s2
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v2.h, 0x7e00, v3.h, s3
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_min_f16_e32 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e64 s0, v2.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_pk_min_f16 v3, v2, v1
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x7e00, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, 0x7e00, v3.l, s0
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e64 s0, v2.h, v1.h
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_min_f16_e32 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.h, 0x7e00, v3.h, s0
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x7e00, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_min_f16_e32 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_cndmask_b16 v0.l, 0x7e00, v0.l, vcc_lo
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_fminimum_v16half:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_pk_min_f16 v8, v2, v6
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v2, v6
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-SDAG-FAKE16-NEXT:    v_pk_min_f16 v10, v0, v4
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v11, 16, v4
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v9, 0x7e00, v8, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v2, v6
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v12, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v13, 16, v10
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v14, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v2, 0x7e00, v8, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_perm_b32 v6, v2, v9, 0x5040100
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v10, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v12, v11
; GFX11-SDAG-FAKE16-NEXT:    v_pk_min_f16 v10, v3, v7
; GFX11-SDAG-FAKE16-NEXT:    v_pk_min_f16 v12, v1, v5
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v4, 0x7e00, v13, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v3, v7
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v13, 16, v5
; GFX11-SDAG-FAKE16-NEXT:    v_perm_b32 v8, v4, v0, 0x5040100
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v15, 16, v12
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-SDAG-FAKE16-NEXT:    v_pk_min_f16 v6, v8, v6
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v8, 0x7e00, v10, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v10
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v3, v7
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v11, 16, v6
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v3, 0x7e00, v10, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v5
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v12, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v14, v13
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v5, 0x7e00, v15, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v9
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v6, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v4, v2
; GFX11-SDAG-FAKE16-NEXT:    v_perm_b32 v4, v3, v8, 0x5040100
; GFX11-SDAG-FAKE16-NEXT:    v_perm_b32 v6, v5, v1, 0x5040100
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v2, 0x7e00, v11, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_pk_min_f16 v4, v6, v4
; GFX11-SDAG-FAKE16-NEXT:    v_min_f16_e32 v7, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v7, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v1, v8
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-SDAG-FAKE16-NEXT:    v_min_f16_e32 v2, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v5, v3
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v1, 0x7e00, v4, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    v_min_f16_e32 v2, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_cmp_o_f16_e32 vcc_lo, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_cndmask_b32_e32 v0, 0x7e00, v2, vcc_lo
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_fminimum_v16half:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_pk_minimum_f16 v3, v3, v7
; GFX12-SDAG-TRUE16-NEXT:    v_pk_minimum_f16 v1, v1, v5
; GFX12-SDAG-TRUE16-NEXT:    v_pk_minimum_f16 v2, v2, v6
; GFX12-SDAG-TRUE16-NEXT:    v_pk_minimum_f16 v0, v0, v4
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_pk_minimum_f16 v1, v1, v3
; GFX12-SDAG-TRUE16-NEXT:    v_pk_minimum_f16 v0, v0, v2
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_pk_minimum_f16 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    v_minimum_f16 v0.l, v0.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_fminimum_v16half:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_pk_minimum_f16 v3, v3, v7
; GFX12-SDAG-FAKE16-NEXT:    v_pk_minimum_f16 v1, v1, v5
; GFX12-SDAG-FAKE16-NEXT:    v_pk_minimum_f16 v2, v2, v6
; GFX12-SDAG-FAKE16-NEXT:    v_pk_minimum_f16 v0, v0, v4
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_pk_minimum_f16 v1, v1, v3
; GFX12-SDAG-FAKE16-NEXT:    v_pk_minimum_f16 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_pk_minimum_f16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_minimum_f16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-TRUE16-LABEL: test_vector_reduce_fminimum_v16half:
; GFX12-GISEL-TRUE16:       ; %bb.0: ; %entry
; GFX12-GISEL-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v0.l, v0.l, v0.h
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v0.h, v1.l, v1.h
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v1.l, v2.l, v2.h
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v1.h, v3.l, v3.h
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v2.l, v4.l, v4.h
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v2.h, v5.l, v5.h
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v3.l, v6.l, v6.h
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v3.h, v7.l, v7.h
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v0.l, v0.l, v0.h
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v0.h, v1.l, v1.h
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v1.l, v2.l, v2.h
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v1.h, v3.l, v3.h
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v0.l, v0.l, v0.h
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v0.h, v1.l, v1.h
; GFX12-GISEL-TRUE16-NEXT:    v_minimum_f16 v0.l, v0.l, v0.h
; GFX12-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-FAKE16-LABEL: test_vector_reduce_fminimum_v16half:
; GFX12-GISEL-FAKE16:       ; %bb.0: ; %entry
; GFX12-GISEL-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v8, 16, v0
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 16, v1
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v2
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v11, 16, v3
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v12, 16, v4
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v13, 16, v5
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v14, 16, v6
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v15, 16, v7
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v0, v0, v8
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v1, v1, v9
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v2, v2, v10
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v3, v3, v11
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v4, v4, v12
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v5, v5, v13
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v6, v6, v14
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v7, v7, v15
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v1, v2, v3
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v2, v4, v5
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v3, v6, v7
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v1, v2, v3
; GFX12-GISEL-FAKE16-NEXT:    v_minimum_f16 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call half @llvm.vector.reduce.fminimum.v16half(<16 x half> %v)
  ret half %res
}

define float @test_vector_reduce_fminimum_v2float(<2 x float> %v) {
; GFX7-LABEL: test_vector_reduce_fminimum_v2float:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_min_f32_e32 v2, v0, v1
; GFX7-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fminimum_v2float:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_min_f32_e32 v2, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fminimum_v2float:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_min_f32_e32 v2, v0, v1
; GFX9-NEXT:    v_mov_b32_e32 v3, 0x7fc00000
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fminimum_v2float:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_min_f32_e32 v2, v0, v1
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v2, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fminimum_v2float:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f32_e32 v2, v0, v1
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v2, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_fminimum_v2float:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_minimum_f32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call float @llvm.vector.reduce.fminimum.v2float(<2 x float> %v)
  ret float %res
}

define float @test_vector_reduce_fminimum_v3float(<3 x float> %v) {
; GFX7-LABEL: test_vector_reduce_fminimum_v3float:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_min_f32_e32 v3, v0, v1
; GFX7-NEXT:    v_mov_b32_e32 v4, 0x7fc00000
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v4, v3, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v4, v1, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fminimum_v3float:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_min_f32_e32 v3, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v4, 0x7fc00000
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v4, v3, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v4, v1, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fminimum_v3float:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_min_f32_e32 v3, v0, v1
; GFX9-NEXT:    v_mov_b32_e32 v4, 0x7fc00000
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v3, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v2
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v1, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fminimum_v3float:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_min_f32_e32 v3, v0, v1
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v3, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fminimum_v3float:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f32_e32 v3, v0, v1
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v3, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_fminimum_v3float:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_minimum3_f32 v0, v0, v1, v2
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_fminimum_v3float:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_minimum_f32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_minimum_f32 v0, v0, v2
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call float @llvm.vector.reduce.fminimum.v3float(<3 x float> %v)
  ret float %res
}

define float @test_vector_reduce_fminimum_v4float(<4 x float> %v) {
; GFX7-LABEL: test_vector_reduce_fminimum_v4float:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_min_f32_e32 v4, v0, v1
; GFX7-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v5, v4, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v5, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v3
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v3
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v5, v1, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fminimum_v4float:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_min_f32_e32 v4, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v5, v4, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v5, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v3
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v5, v1, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fminimum_v4float:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_min_f32_e32 v4, v0, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, 0x7fc00000
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v4, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v2
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v3
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v3
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v5, v1, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fminimum_v4float:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_min_f32_e32 v4, v0, v1
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v4, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v3
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fminimum_v4float:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f32_e32 v4, v0, v1
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v4, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v3
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_fminimum_v4float:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_minimum_f32 v0, v0, v1
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_minimum3_f32 v0, v0, v2, v3
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_fminimum_v4float:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_minimum_f32 v0, v0, v1
; GFX12-GISEL-NEXT:    v_minimum_f32 v1, v2, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_minimum_f32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call float @llvm.vector.reduce.fminimum.v4float(<4 x float> %v)
  ret float %res
}

define float @test_vector_reduce_fminimum_v8float(<8 x float> %v) {
; GFX7-LABEL: test_vector_reduce_fminimum_v8float:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_min_f32_e32 v8, v0, v1
; GFX7-NEXT:    v_mov_b32_e32 v9, 0x7fc00000
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v9, v8, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v3
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v3
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v4
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v4
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v5
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v5
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v6
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v6
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v7
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v7
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fminimum_v8float:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_min_f32_e32 v8, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v9, 0x7fc00000
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v9, v8, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v3
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v4
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v5
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v6
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v7
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fminimum_v8float:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_min_f32_e32 v8, v0, v1
; GFX9-NEXT:    v_mov_b32_e32 v9, 0x7fc00000
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v9, v8, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v2
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v3
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v3
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v4
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v4
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v5
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v5
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v6
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v6
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v7
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v7
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v9, v1, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fminimum_v8float:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_min_f32_e32 v8, v0, v1
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v8, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v3
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v4
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v5
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v6
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v7
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fminimum_v8float:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f32_e32 v8, v0, v1
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v8, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v3
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v4
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v5
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v6
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v7
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_fminimum_v8float:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_minimum_f32 v0, v0, v1
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_minimum3_f32 v0, v0, v2, v3
; GFX12-SDAG-NEXT:    v_minimum3_f32 v0, v0, v4, v5
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_minimum3_f32 v0, v0, v6, v7
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_fminimum_v8float:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_minimum_f32 v0, v0, v1
; GFX12-GISEL-NEXT:    v_minimum_f32 v1, v2, v3
; GFX12-GISEL-NEXT:    v_minimum_f32 v2, v4, v5
; GFX12-GISEL-NEXT:    v_minimum_f32 v3, v6, v7
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_minimum_f32 v0, v0, v1
; GFX12-GISEL-NEXT:    v_minimum_f32 v1, v2, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_minimum_f32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call float @llvm.vector.reduce.fminimum.v8float(<8 x float> %v)
  ret float %res
}

define float @test_vector_reduce_fminimum_v16float(<16 x float> %v) {
; GFX7-LABEL: test_vector_reduce_fminimum_v16float:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_min_f32_e32 v16, v0, v1
; GFX7-NEXT:    v_mov_b32_e32 v17, 0x7fc00000
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v16, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v3
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v3
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v4
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v4
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v5
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v5
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v6
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v6
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v7
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v7
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v8
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v8
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v9
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v9
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v10
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v10
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v11
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v11
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v12
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v12
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v13
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v13
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v14
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v14
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    v_min_f32_e32 v1, v0, v15
; GFX7-NEXT:    v_cmp_o_f32_e32 vcc, v0, v15
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fminimum_v16float:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_min_f32_e32 v16, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v17, 0x7fc00000
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v16, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v3
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v4
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v5
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v6
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v7
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v8
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v9
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v10
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v10
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v11
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v12
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v12
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v13
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v13
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v14
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v14
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    v_min_f32_e32 v1, v0, v15
; GFX8-NEXT:    v_cmp_o_f32_e32 vcc, v0, v15
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fminimum_v16float:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_min_f32_e32 v16, v0, v1
; GFX9-NEXT:    v_mov_b32_e32 v17, 0x7fc00000
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v1
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v17, v16, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v2
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v3
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v3
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v4
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v4
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v5
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v5
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v6
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v6
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v7
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v7
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v8
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v8
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v9
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v9
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v10
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v10
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v11
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v11
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v12
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v12
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v13
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v13
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v14
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v14
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX9-NEXT:    v_min_f32_e32 v1, v0, v15
; GFX9-NEXT:    v_cmp_o_f32_e32 vcc, v0, v15
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v17, v1, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fminimum_v16float:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_min_f32_e32 v16, v0, v1
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v16, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v3
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v4
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v5
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v6
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v7
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v8
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v9
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v10
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v11
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v11
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v12
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v12
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v13
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v13
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v14
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v14
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    v_min_f32_e32 v1, v0, v15
; GFX10-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v15
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fminimum_v16float:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f32_e32 v16, v0, v1
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v16, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v2
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v3
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v4
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v5
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v6
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v7
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v8
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v8
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v9
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v10
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v10
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v11
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v11
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v12
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v12
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v13
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v13
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v14
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v14
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    v_min_f32_e32 v1, v0, v15
; GFX11-NEXT:    v_cmp_o_f32_e32 vcc_lo, v0, v15
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x7fc00000, v1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_fminimum_v16float:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_minimum_f32 v0, v0, v1
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_minimum3_f32 v0, v0, v2, v3
; GFX12-SDAG-NEXT:    v_minimum3_f32 v0, v0, v4, v5
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_minimum3_f32 v0, v0, v6, v7
; GFX12-SDAG-NEXT:    v_minimum3_f32 v0, v0, v8, v9
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_minimum3_f32 v0, v0, v10, v11
; GFX12-SDAG-NEXT:    v_minimum3_f32 v0, v0, v12, v13
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_minimum3_f32 v0, v0, v14, v15
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_fminimum_v16float:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_minimum_f32 v0, v0, v1
; GFX12-GISEL-NEXT:    v_minimum_f32 v1, v2, v3
; GFX12-GISEL-NEXT:    v_minimum_f32 v2, v4, v5
; GFX12-GISEL-NEXT:    v_minimum_f32 v3, v6, v7
; GFX12-GISEL-NEXT:    v_minimum_f32 v4, v8, v9
; GFX12-GISEL-NEXT:    v_minimum_f32 v5, v10, v11
; GFX12-GISEL-NEXT:    v_minimum_f32 v6, v12, v13
; GFX12-GISEL-NEXT:    v_minimum_f32 v7, v14, v15
; GFX12-GISEL-NEXT:    v_minimum_f32 v0, v0, v1
; GFX12-GISEL-NEXT:    v_minimum_f32 v1, v2, v3
; GFX12-GISEL-NEXT:    v_minimum_f32 v2, v4, v5
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-GISEL-NEXT:    v_minimum_f32 v3, v6, v7
; GFX12-GISEL-NEXT:    v_minimum_f32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_minimum_f32 v1, v2, v3
; GFX12-GISEL-NEXT:    v_minimum_f32 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call float @llvm.vector.reduce.fminimum.v16float(<16 x float> %v)
  ret float %res
}


define double @test_vector_reduce_fminimum_v2double(<2 x double> %v) {
; GFX7-LABEL: test_vector_reduce_fminimum_v2double:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_min_f64 v[4:5], v[0:1], v[2:3]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[2:3]
; GFX7-NEXT:    v_mov_b32_e32 v1, 0x7ff80000
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v4, 0, vcc
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fminimum_v2double:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_min_f64 v[4:5], v[0:1], v[2:3]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v1, 0x7ff80000
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v4, 0, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fminimum_v2double:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_min_f64 v[4:5], v[0:1], v[2:3]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x7ff80000
; GFX9-NEXT:    s_nop 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v4, 0, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fminimum_v2double:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_min_f64 v[4:5], v[0:1], v[2:3]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[2:3]
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v4, 0, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v5, 0x7ff80000, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fminimum_v2double:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f64 v[4:5], v[0:1], v[2:3]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v4, 0, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v5, 0x7ff80000, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_fminimum_v2double:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[2:3]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call double @llvm.vector.reduce.fminimum.v2double(<2 x double> %v)
  ret double %res
}

define double @test_vector_reduce_fminimum_v3double(<3 x double> %v) {
; GFX7-LABEL: test_vector_reduce_fminimum_v3double:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_min_f64 v[6:7], v[0:1], v[2:3]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[2:3]
; GFX7-NEXT:    v_mov_b32_e32 v8, 0x7ff80000
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v7, v8, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v6, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[4:5]
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v8, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fminimum_v3double:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_min_f64 v[6:7], v[0:1], v[2:3]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v8, 0x7ff80000
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v7, v8, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v6, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[4:5]
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v8, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fminimum_v3double:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_min_f64 v[6:7], v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v8, 0x7ff80000
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v7, v8, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v6, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[4:5]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v8, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fminimum_v3double:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_min_f64 v[6:7], v[0:1], v[2:3]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[2:3]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v7, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v6, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fminimum_v3double:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f64 v[6:7], v[0:1], v[2:3]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v7, 0x7ff80000, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v6, 0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_fminimum_v3double:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[2:3]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[4:5]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call double @llvm.vector.reduce.fminimum.v3double(<3 x double> %v)
  ret double %res
}

define double @test_vector_reduce_fminimum_v4double(<4 x double> %v) {
; GFX7-LABEL: test_vector_reduce_fminimum_v4double:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_min_f64 v[8:9], v[0:1], v[2:3]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[2:3]
; GFX7-NEXT:    v_mov_b32_e32 v10, 0x7ff80000
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v9, v10, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v8, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v10, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[6:7]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[6:7]
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v10, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fminimum_v4double:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_min_f64 v[8:9], v[0:1], v[2:3]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v10, 0x7ff80000
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v8, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[6:7]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[6:7]
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v10, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fminimum_v4double:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_min_f64 v[8:9], v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v10, 0x7ff80000
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v9, v10, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v8, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[4:5]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v10, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[6:7]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[6:7]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v10, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fminimum_v4double:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_min_f64 v[8:9], v[0:1], v[2:3]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[2:3]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v9, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v8, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[6:7]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[6:7]
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fminimum_v4double:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f64 v[8:9], v[0:1], v[2:3]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v9, 0x7ff80000, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v8, 0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[6:7]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[6:7]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_fminimum_v4double:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[2:3]
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[4:5]
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[6:7]
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_fminimum_v4double:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[2:3]
; GFX12-GISEL-NEXT:    v_minimum_f64 v[2:3], v[4:5], v[6:7]
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[2:3]
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call double @llvm.vector.reduce.fminimum.v4double(<4 x double> %v)
  ret double %res
}

define double @test_vector_reduce_fminimum_v8double(<8 x double> %v) {
; GFX7-LABEL: test_vector_reduce_fminimum_v8double:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_min_f64 v[16:17], v[0:1], v[2:3]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[2:3]
; GFX7-NEXT:    v_mov_b32_e32 v18, 0x7ff80000
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v17, v18, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v16, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[4:5]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v18, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[6:7]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[6:7]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v18, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[8:9]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[8:9]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v18, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[10:11]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[10:11]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v18, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[12:13]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[12:13]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v18, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[14:15]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[14:15]
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v18, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fminimum_v8double:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_min_f64 v[16:17], v[0:1], v[2:3]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v18, 0x7ff80000
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v17, v18, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v16, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v18, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[6:7]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[6:7]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v18, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[8:9]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[8:9]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v18, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[10:11]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[10:11]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v18, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[12:13]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[12:13]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v18, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[14:15]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[14:15]
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v18, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fminimum_v8double:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_min_f64 v[16:17], v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v18, 0x7ff80000
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v17, v18, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v16, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[4:5]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v18, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[6:7]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[6:7]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v18, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[8:9]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[8:9]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v18, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[10:11]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[10:11]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v18, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[12:13]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[12:13]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v18, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[14:15]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[14:15]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v18, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fminimum_v8double:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_min_f64 v[16:17], v[0:1], v[2:3]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[2:3]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v17, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v16, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[6:7]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[6:7]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[8:9]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[8:9]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[10:11]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[10:11]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[12:13]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[12:13]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[14:15]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[14:15]
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fminimum_v8double:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f64 v[16:17], v[0:1], v[2:3]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v17, 0x7ff80000, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v16, 0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[6:7]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[6:7]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[8:9]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[8:9]
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[10:11]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[10:11]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[12:13]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[12:13]
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[14:15]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[14:15]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_fminimum_v8double:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[2:3]
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[4:5]
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[6:7]
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[8:9]
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[10:11]
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[12:13]
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[14:15]
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_fminimum_v8double:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[2:3]
; GFX12-GISEL-NEXT:    v_minimum_f64 v[2:3], v[4:5], v[6:7]
; GFX12-GISEL-NEXT:    v_minimum_f64 v[4:5], v[8:9], v[10:11]
; GFX12-GISEL-NEXT:    v_minimum_f64 v[6:7], v[12:13], v[14:15]
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[2:3]
; GFX12-GISEL-NEXT:    v_minimum_f64 v[2:3], v[4:5], v[6:7]
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[2:3]
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call double @llvm.vector.reduce.fminimum.v8double(<8 x double> %v)
  ret double %res
}

define double @test_vector_reduce_fminimum_v16double(<16 x double> %v) {
; GFX7-LABEL: test_vector_reduce_fminimum_v16double:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_min_f64 v[31:32], v[0:1], v[2:3]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[2:3]
; GFX7-NEXT:    v_mov_b32_e32 v33, 0x7ff80000
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v32, v33, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v31, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[4:5]
; GFX7-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[6:7]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[6:7]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[8:9]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[8:9]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[10:11]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[10:11]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[12:13]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[12:13]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[14:15]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[14:15]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[16:17]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[16:17]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[18:19]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[18:19]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[20:21]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[20:21]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[22:23]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[22:23]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[24:25]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[24:25]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[26:27]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[26:27]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[28:29]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[28:29]
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_min_f64 v[2:3], v[0:1], v[30:31]
; GFX7-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[30:31]
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fminimum_v16double:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_min_f64 v[31:32], v[0:1], v[2:3]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v33, 0x7ff80000
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v32, v33, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v31, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[4:5]
; GFX8-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[6:7]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[6:7]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[8:9]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[8:9]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[10:11]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[10:11]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[12:13]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[12:13]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[14:15]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[14:15]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[16:17]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[16:17]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[18:19]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[18:19]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[20:21]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[20:21]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[22:23]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[22:23]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[24:25]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[24:25]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[26:27]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[26:27]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[28:29]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[28:29]
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_min_f64 v[2:3], v[0:1], v[30:31]
; GFX8-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[30:31]
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v33, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fminimum_v16double:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    scratch_load_dword v31, off, s32
; GFX9-NEXT:    v_min_f64 v[32:33], v[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v34, 0x7ff80000
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[2:3]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v33, v34, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v32, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[4:5]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v34, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[6:7]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[6:7]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v34, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[8:9]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[8:9]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v34, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[10:11]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[10:11]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v34, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[12:13]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[12:13]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v34, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[14:15]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[14:15]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v34, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[16:17]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[16:17]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v34, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[18:19]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[18:19]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v34, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[20:21]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[20:21]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v34, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[22:23]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[22:23]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v34, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[24:25]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[24:25]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v34, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[26:27]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[26:27]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v34, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[28:29]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[28:29]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v34, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_min_f64 v[2:3], v[0:1], v[30:31]
; GFX9-NEXT:    v_cmp_u_f64_e32 vcc, v[0:1], v[30:31]
; GFX9-NEXT:    s_nop 1
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v34, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fminimum_v16double:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_min_f64 v[31:32], v[0:1], v[2:3]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[2:3]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v32, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v31, 0, vcc_lo
; GFX10-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[6:7]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[6:7]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[8:9]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[8:9]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[10:11]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[10:11]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[12:13]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[12:13]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[14:15]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[14:15]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[16:17]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[16:17]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[18:19]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[18:19]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[20:21]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[20:21]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[22:23]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[22:23]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[24:25]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[24:25]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[26:27]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[26:27]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[28:29]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[28:29]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_min_f64 v[2:3], v[0:1], v[30:31]
; GFX10-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[30:31]
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fminimum_v16double:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f64 v[31:32], v[0:1], v[2:3]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v32, 0x7ff80000, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v31, 0, vcc_lo
; GFX11-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[4:5]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[6:7]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[6:7]
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[8:9]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[8:9]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[10:11]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[10:11]
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[12:13]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[12:13]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[14:15]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[14:15]
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[16:17]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[16:17]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[18:19]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[18:19]
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[20:21]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[20:21]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[22:23]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[22:23]
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[24:25]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[24:25]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[26:27]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[26:27]
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[28:29]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[28:29]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_min_f64 v[2:3], v[0:1], v[30:31]
; GFX11-NEXT:    v_cmp_u_f64_e32 vcc_lo, v[0:1], v[30:31]
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v2, 0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v3, 0x7ff80000, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_fminimum_v16double:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[2:3]
; GFX12-SDAG-NEXT:    scratch_load_b32 v31, off, s32
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[4:5]
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[6:7]
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[8:9]
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[10:11]
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[12:13]
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[14:15]
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[16:17]
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[18:19]
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[20:21]
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[22:23]
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[24:25]
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[26:27]
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[28:29]
; GFX12-SDAG-NEXT:    s_wait_loadcnt 0x0
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[30:31]
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_fminimum_v16double:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    scratch_load_b32 v31, off, s32
; GFX12-GISEL-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[2:3]
; GFX12-GISEL-NEXT:    v_minimum_f64 v[2:3], v[4:5], v[6:7]
; GFX12-GISEL-NEXT:    v_minimum_f64 v[4:5], v[8:9], v[10:11]
; GFX12-GISEL-NEXT:    v_minimum_f64 v[6:7], v[12:13], v[14:15]
; GFX12-GISEL-NEXT:    v_minimum_f64 v[8:9], v[16:17], v[18:19]
; GFX12-GISEL-NEXT:    v_minimum_f64 v[10:11], v[20:21], v[22:23]
; GFX12-GISEL-NEXT:    v_minimum_f64 v[12:13], v[24:25], v[26:27]
; GFX12-GISEL-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[2:3]
; GFX12-GISEL-NEXT:    v_minimum_f64 v[2:3], v[4:5], v[6:7]
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_minimum_f64 v[4:5], v[8:9], v[10:11]
; GFX12-GISEL-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[2:3]
; GFX12-GISEL-NEXT:    s_wait_loadcnt 0x0
; GFX12-GISEL-NEXT:    v_minimum_f64 v[14:15], v[28:29], v[30:31]
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_minimum_f64 v[6:7], v[12:13], v[14:15]
; GFX12-GISEL-NEXT:    v_minimum_f64 v[2:3], v[4:5], v[6:7]
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_minimum_f64 v[0:1], v[0:1], v[2:3]
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call double @llvm.vector.reduce.fminimum.v16double(<16 x double> %v)
  ret double %res
}

declare half @llvm.vector.reduce.fminimum.v2half(<2 x half>)
declare half @llvm.vector.reduce.fminimum.v3half(<3 x half>)
declare half @llvm.vector.reduce.fminimum.v4half(<4 x half>)
declare half @llvm.vector.reduce.fminimum.v8half(<8 x half>)
declare half @llvm.vector.reduce.fminimum.v16half(<16 x half>)
declare float @llvm.vector.reduce.fminimum.v2float(<2 x float>)
declare float @llvm.vector.reduce.fminimum.v3float(<3 x float>)
declare float @llvm.vector.reduce.fminimum.v4float(<4 x float>)
declare float @llvm.vector.reduce.fminimum.v8float(<8 x float>)
declare float @llvm.vector.reduce.fminimum.v16float(<16 x float>)
declare double @llvm.vector.reduce.fminimum.v2double(<2 x double>)
declare double @llvm.vector.reduce.fminimum.v3double(<3 x double>)
declare double @llvm.vector.reduce.fminimum.v4double(<4 x double>)
declare double @llvm.vector.reduce.fminimum.v8double(<8 x double>)
declare double @llvm.vector.reduce.fminimum.v16double(<16 x double>)
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX10-SDAG: {{.*}}
; GFX11-SDAG: {{.*}}
; GFX7-SDAG: {{.*}}
; GFX8-SDAG: {{.*}}
; GFX9-SDAG: {{.*}}
