; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=aarch64 | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc < %s -mtriple=aarch64 -global-isel | FileCheck %s --check-prefixes=CHECK,CHECK-GI

declare void @t()

define void @test1(i32 %a) {
; CHECK-LABEL: test1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cmp w0, #12
; CHECK-NEXT:    b.mi .LBB0_2
; CHECK-NEXT:  // %bb.1: // %if.end
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB0_2: // %if.then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %sub = add nsw i32 %a, -12
  %cmp = icmp slt i32 %sub, 0
  br i1 %cmp, label %if.then, label %if.end


if.then:
  call void @t()
  br label %if.end

if.end:
  ret void
}

define void @test2(i64 %a) {
; CHECK-LABEL: test2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cmp x0, #12
; CHECK-NEXT:    b.mi .LBB1_2
; CHECK-NEXT:  // %bb.1: // %if.end
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB1_2: // %if.then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %sub = add nsw i64 %a, -12
  %cmp = icmp slt i64 %sub, 0
  br i1 %cmp, label %if.then, label %if.end


if.then:
  call void @t()
  br label %if.end

if.end:
  ret void
}

define void @test3(i32 %a) {
; CHECK-LABEL: test3:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cmp w0, #12
; CHECK-NEXT:    b.mi .LBB2_2
; CHECK-NEXT:  // %bb.1: // %if.then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB2_2: // %if.end
; CHECK-NEXT:    ret
entry:
  %sub = add nsw i32 %a, -12
  %cmp = icmp sgt i32 %sub, -1
  br i1 %cmp, label %if.then, label %if.end


if.then:
  call void @t()
  br label %if.end

if.end:
  ret void
}

define void @test4(i64 %a) {
; CHECK-LABEL: test4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cmp x0, #12
; CHECK-NEXT:    b.mi .LBB3_2
; CHECK-NEXT:  // %bb.1: // %if.then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB3_2: // %if.end
; CHECK-NEXT:    ret
entry:
  %sub = add nsw i64 %a, -12
  %cmp = icmp sgt i64 %sub, -1
  br i1 %cmp, label %if.then, label %if.end


if.then:
  call void @t()
  br label %if.end

if.end:
  ret void
}

define void @test5(i32 %a) {
; CHECK-LABEL: test5:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cmp w0, #12
; CHECK-NEXT:    b.mi .LBB4_2
; CHECK-NEXT:  // %bb.1: // %if.then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB4_2: // %if.end
; CHECK-NEXT:    ret
entry:
  %sub = add nsw i32 %a, -12
  %cmp = icmp sge i32 %sub, 0
  br i1 %cmp, label %if.then, label %if.end


if.then:
  call void @t()
  br label %if.end

if.end:
  ret void
}

define void @test6(i64 %a) {
; CHECK-LABEL: test6:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cmp x0, #12
; CHECK-NEXT:    b.mi .LBB5_2
; CHECK-NEXT:  // %bb.1: // %if.then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB5_2: // %if.end
; CHECK-NEXT:    ret
entry:
  %sub = add nsw i64 %a, -12
  %cmp = icmp sge i64 %sub, 0
  br i1 %cmp, label %if.then, label %if.end


if.then:
  call void @t()
  br label %if.end

if.end:
  ret void
}

define void @test7(i32 %a) {
; CHECK-LABEL: test7:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cmp w0, #12
; CHECK-NEXT:    b.mi .LBB6_2
; CHECK-NEXT:  // %bb.1: // %if.end
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB6_2: // %if.then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %sub = sub nsw i32 %a, 12
  %cmp = icmp slt i32 %sub, 0
  br i1 %cmp, label %if.then, label %if.end


if.then:
  call void @t()
  br label %if.end

if.end:
  ret void
}

define void @test8(i64 %val1, i64 %val2, i64 %val3) {
; CHECK-SD-LABEL: test8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    tst x0, x1
; CHECK-SD-NEXT:    b.ge .LBB7_3
; CHECK-SD-NEXT:  // %bb.1:
; CHECK-SD-NEXT:    and x8, x1, x2
; CHECK-SD-NEXT:    tbnz x8, #63, .LBB7_3
; CHECK-SD-NEXT:  // %bb.2: // %if.then2
; CHECK-SD-NEXT:    tst x0, x1, lsl #63
; CHECK-SD-NEXT:    b.lt .LBB7_4
; CHECK-SD-NEXT:  .LBB7_3: // %if.end
; CHECK-SD-NEXT:    ret
; CHECK-SD-NEXT:  .LBB7_4: // %if.then3
; CHECK-SD-NEXT:    tst x0, x1, lsl #62
; CHECK-SD-NEXT:    b.lt .LBB7_3
; CHECK-SD-NEXT:  // %bb.5: // %if.then4
; CHECK-SD-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-SD-NEXT:    .cfi_def_cfa_offset 16
; CHECK-SD-NEXT:    .cfi_offset w30, -16
; CHECK-SD-NEXT:    bl t
; CHECK-SD-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: test8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    tst x0, x1
; CHECK-GI-NEXT:    b.ge .LBB7_3
; CHECK-GI-NEXT:  // %bb.1:
; CHECK-GI-NEXT:    tst x1, x2
; CHECK-GI-NEXT:    b.lt .LBB7_3
; CHECK-GI-NEXT:  // %bb.2: // %if.then2
; CHECK-GI-NEXT:    tst x0, x1, lsl #63
; CHECK-GI-NEXT:    b.lt .LBB7_4
; CHECK-GI-NEXT:  .LBB7_3: // %if.end
; CHECK-GI-NEXT:    ret
; CHECK-GI-NEXT:  .LBB7_4: // %if.then3
; CHECK-GI-NEXT:    tst x0, x1, lsl #62
; CHECK-GI-NEXT:    b.lt .LBB7_3
; CHECK-GI-NEXT:  // %bb.5: // %if.then4
; CHECK-GI-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-GI-NEXT:    .cfi_def_cfa_offset 16
; CHECK-GI-NEXT:    .cfi_offset w30, -16
; CHECK-GI-NEXT:    bl t
; CHECK-GI-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-GI-NEXT:    ret
  %and1 = and i64 %val1, %val2
  %tst1 = icmp slt i64 %and1, 0
  br i1 %tst1, label %if.then1, label %if.end


if.then1:
  %and2 = and i64 %val2, %val3
  %tst2 = icmp sge i64 %and2, 0
  br i1 %tst2, label %if.then2, label %if.end


if.then2:
  %shifted_op1 = shl i64 %val2, 63
  %shifted_and1 = and i64 %val1, %shifted_op1
  %tst3 = icmp slt i64 %shifted_and1, 0
  br i1 %tst3, label %if.then3, label %if.end


if.then3:
  %shifted_op2 = shl i64 %val2, 62
  %shifted_and2 = and i64 %val1, %shifted_op2
  %tst4 = icmp sge i64 %shifted_and2, 0
  br i1 %tst4, label %if.then4, label %if.end


if.then4:
  call void @t()
  br label %if.end

if.end:
  ret void
}

define void @test9(i64 %val1) {
; CHECK-LABEL: test9:
; CHECK:       // %bb.0:
; CHECK-NEXT:    tbnz x0, #63, .LBB8_2
; CHECK-NEXT:  // %bb.1: // %if.end
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB8_2: // %if.then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %tst = icmp slt i64 %val1, 0
  br i1 %tst, label %if.then, label %if.end


if.then:
  call void @t()
  br label %if.end

if.end:
  ret void
}

define void @test10(i64 %val1) {
; CHECK-LABEL: test10:
; CHECK:       // %bb.0:
; CHECK-NEXT:    tbnz x0, #63, .LBB9_2
; CHECK-NEXT:  // %bb.1: // %if.end
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB9_2: // %if.then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %tst = icmp slt i64 %val1, 0
  br i1 %tst, label %if.then, label %if.end


if.then:
  call void @t()
  br label %if.end

if.end:
  ret void
}

define void @test11(i64 %val1, ptr %ptr) {
; CHECK-LABEL: test11:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr x8, [x1]
; CHECK-NEXT:    tbnz x8, #63, .LBB10_2
; CHECK-NEXT:  // %bb.1: // %if.end
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB10_2: // %if.then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret


  %val = load i64, ptr %ptr
  %tst = icmp slt i64 %val, 0
  br i1 %tst, label %if.then, label %if.end

if.then:
  call void @t()
  br label %if.end

if.end:
  ret void
}

define void @test12(i64 %val1) {
; CHECK-LABEL: test12:
; CHECK:       // %bb.0:
; CHECK-NEXT:    tbnz x0, #63, .LBB11_2
; CHECK-NEXT:  // %bb.1: // %if.end
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB11_2: // %if.then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %tst = icmp slt i64 %val1, 0
  br i1 %tst, label %if.then, label %if.end


if.then:
  call void @t()
  br label %if.end

if.end:
  ret void
}

define void @test13(i64 %val1, i64 %val2) {
; CHECK-LABEL: test13:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr x8, x0, x1
; CHECK-NEXT:    tbnz x8, #63, .LBB12_2
; CHECK-NEXT:  // %bb.1: // %if.end
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB12_2: // %if.then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %or = or i64 %val1, %val2
  %tst = icmp slt i64 %or, 0
  br i1 %tst, label %if.then, label %if.end


if.then:
  call void @t()
  br label %if.end

if.end:
  ret void
}

define void @test14(i1 %cond) {
; CHECK-LABEL: test14:
; CHECK:       // %bb.0:
; CHECK-NEXT:    tbnz w0, #0, .LBB13_2
; CHECK-NEXT:  // %bb.1: // %if.then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB13_2: // %if.end
; CHECK-NEXT:    ret
  br i1 %cond, label %if.end, label %if.then


if.then:
  call void @t()
  br label %if.end

if.end:
  ret void
}

define void @test15(i1 %cond) {
; CHECK-LABEL: test15:
; CHECK:       // %bb.0:
; CHECK-NEXT:    tbnz w0, #0, .LBB14_2
; CHECK-NEXT:  // %bb.1: // %if.then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB14_2: // %if.end
; CHECK-NEXT:    ret
  %cond1 = xor i1 %cond, -1
  br i1 %cond1, label %if.then, label %if.end


if.then:
  call void @t()
  br label %if.end

if.end:
  ret void
}

define void @test16(i64 %in) {
; CHECK-LABEL: test16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    tbnz w0, #2, .LBB15_2
; CHECK-NEXT:  // %bb.1: // %then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB15_2: // %end
; CHECK-NEXT:    ret
  %shl = shl i64 %in, 3
  %and = and i64 %shl, 32
  %cond = icmp eq i64 %and, 0
  br i1 %cond, label %then, label %end


then:
  call void @t()
  br label %end

end:
  ret void
}

define void @test17(i64 %in) {
; CHECK-LABEL: test17:
; CHECK:       // %bb.0:
; CHECK-NEXT:    tbnz w0, #3, .LBB16_2
; CHECK-NEXT:  // %bb.1: // %then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB16_2: // %end
; CHECK-NEXT:    ret
  %shr = ashr i64 %in, 3
  %and = and i64 %shr, 1
  %cond = icmp eq i64 %and, 0
  br i1 %cond, label %then, label %end


then:
  call void @t()
  br label %end

end:
  ret void
}

define void @test18(i32 %in) {
; CHECK-LABEL: test18:
; CHECK:       // %bb.0:
; CHECK-NEXT:    tbnz w0, #31, .LBB17_2
; CHECK-NEXT:  // %bb.1: // %then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB17_2: // %end
; CHECK-NEXT:    ret
  %shr = ashr i32 %in, 2
  %cond = icmp sge i32 %shr, 0
  br i1 %cond, label %then, label %end


then:
  call void @t()
  br label %end

end:
  ret void
}

define void @test19(i64 %in) {
; CHECK-LABEL: test19:
; CHECK:       // %bb.0:
; CHECK-NEXT:    tbnz w0, #3, .LBB18_2
; CHECK-NEXT:  // %bb.1: // %then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB18_2: // %end
; CHECK-NEXT:    ret
  %shl = lshr i64 %in, 3
  %trunc = trunc i64 %shl to i32
  %and = and i32 %trunc, 1
  %cond = icmp eq i32 %and, 0
  br i1 %cond, label %then, label %end


then:
  call void @t()
  br label %end

end:
  ret void
}

define void @test20(i32 %in) nounwind {
; CHECK-LABEL: test20:
; CHECK:       // %bb.0:
; CHECK-NEXT:    tbnz w0, #2, .LBB19_2
; CHECK-NEXT:  // %bb.1: // %then
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl t
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB19_2: // %end
; CHECK-NEXT:    ret
  %shl = shl i32 %in, 3
  %zext = zext i32 %shl to i64
  %and = and i64 %zext, 32
  %cond = icmp eq i64 %and, 0
  br i1 %cond, label %then, label %end


then:
  call void @t()
  br label %end

end:
  ret void
}

