; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --filter-out "\b(sp)\b" --filter "^\s*(ld|st[^r]|swp|cas|bl|add|and|eor|orn|orr|sub|mvn|sxt|cmp|ccmp|csel|dmb)"
; The base test file was generated by ./llvm/test/CodeGen/AArch64/Atomics/generate-tests.py
; RUN: llc %s -o - -verify-machineinstrs -mtriple=aarch64_be -mattr=+v8.1a -O0 | FileCheck %s --check-prefixes=CHECK,-O0
; RUN: llc %s -o - -verify-machineinstrs -mtriple=aarch64_be -mattr=+v8.1a -O1 | FileCheck %s --check-prefixes=CHECK,-O1

define dso_local i8 @load_atomic_i8_aligned_unordered(ptr %ptr) {
; CHECK-LABEL: load_atomic_i8_aligned_unordered:
; CHECK:    ldrb w0, [x0]
    %r = load atomic i8, ptr %ptr unordered, align 1
    ret i8 %r
}

define dso_local i8 @load_atomic_i8_aligned_unordered_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i8_aligned_unordered_const:
; CHECK:    ldrb w0, [x0]
    %r = load atomic i8, ptr %ptr unordered, align 1
    ret i8 %r
}

define dso_local i8 @load_atomic_i8_aligned_monotonic(ptr %ptr) {
; CHECK-LABEL: load_atomic_i8_aligned_monotonic:
; CHECK:    ldrb w0, [x0]
    %r = load atomic i8, ptr %ptr monotonic, align 1
    ret i8 %r
}

define dso_local i8 @load_atomic_i8_aligned_monotonic_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i8_aligned_monotonic_const:
; CHECK:    ldrb w0, [x0]
    %r = load atomic i8, ptr %ptr monotonic, align 1
    ret i8 %r
}

define dso_local i8 @load_atomic_i8_aligned_acquire(ptr %ptr) {
; CHECK-LABEL: load_atomic_i8_aligned_acquire:
; CHECK:    ldarb w0, [x0]
    %r = load atomic i8, ptr %ptr acquire, align 1
    ret i8 %r
}

define dso_local i8 @load_atomic_i8_aligned_acquire_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i8_aligned_acquire_const:
; CHECK:    ldarb w0, [x0]
    %r = load atomic i8, ptr %ptr acquire, align 1
    ret i8 %r
}

define dso_local i8 @load_atomic_i8_aligned_seq_cst(ptr %ptr) {
; CHECK-LABEL: load_atomic_i8_aligned_seq_cst:
; CHECK:    ldarb w0, [x0]
    %r = load atomic i8, ptr %ptr seq_cst, align 1
    ret i8 %r
}

define dso_local i8 @load_atomic_i8_aligned_seq_cst_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i8_aligned_seq_cst_const:
; CHECK:    ldarb w0, [x0]
    %r = load atomic i8, ptr %ptr seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @load_atomic_i16_aligned_unordered(ptr %ptr) {
; CHECK-LABEL: load_atomic_i16_aligned_unordered:
; CHECK:    ldrh w0, [x0]
    %r = load atomic i16, ptr %ptr unordered, align 2
    ret i16 %r
}

define dso_local i16 @load_atomic_i16_aligned_unordered_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i16_aligned_unordered_const:
; CHECK:    ldrh w0, [x0]
    %r = load atomic i16, ptr %ptr unordered, align 2
    ret i16 %r
}

define dso_local i16 @load_atomic_i16_aligned_monotonic(ptr %ptr) {
; CHECK-LABEL: load_atomic_i16_aligned_monotonic:
; CHECK:    ldrh w0, [x0]
    %r = load atomic i16, ptr %ptr monotonic, align 2
    ret i16 %r
}

define dso_local i16 @load_atomic_i16_aligned_monotonic_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i16_aligned_monotonic_const:
; CHECK:    ldrh w0, [x0]
    %r = load atomic i16, ptr %ptr monotonic, align 2
    ret i16 %r
}

define dso_local i16 @load_atomic_i16_aligned_acquire(ptr %ptr) {
; CHECK-LABEL: load_atomic_i16_aligned_acquire:
; CHECK:    ldarh w0, [x0]
    %r = load atomic i16, ptr %ptr acquire, align 2
    ret i16 %r
}

define dso_local i16 @load_atomic_i16_aligned_acquire_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i16_aligned_acquire_const:
; CHECK:    ldarh w0, [x0]
    %r = load atomic i16, ptr %ptr acquire, align 2
    ret i16 %r
}

define dso_local i16 @load_atomic_i16_aligned_seq_cst(ptr %ptr) {
; CHECK-LABEL: load_atomic_i16_aligned_seq_cst:
; CHECK:    ldarh w0, [x0]
    %r = load atomic i16, ptr %ptr seq_cst, align 2
    ret i16 %r
}

define dso_local i16 @load_atomic_i16_aligned_seq_cst_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i16_aligned_seq_cst_const:
; CHECK:    ldarh w0, [x0]
    %r = load atomic i16, ptr %ptr seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @load_atomic_i32_aligned_unordered(ptr %ptr) {
; CHECK-LABEL: load_atomic_i32_aligned_unordered:
; CHECK:    ldr w0, [x0]
    %r = load atomic i32, ptr %ptr unordered, align 4
    ret i32 %r
}

define dso_local i32 @load_atomic_i32_aligned_unordered_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i32_aligned_unordered_const:
; CHECK:    ldr w0, [x0]
    %r = load atomic i32, ptr %ptr unordered, align 4
    ret i32 %r
}

define dso_local i32 @load_atomic_i32_aligned_monotonic(ptr %ptr) {
; CHECK-LABEL: load_atomic_i32_aligned_monotonic:
; CHECK:    ldr w0, [x0]
    %r = load atomic i32, ptr %ptr monotonic, align 4
    ret i32 %r
}

define dso_local i32 @load_atomic_i32_aligned_monotonic_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i32_aligned_monotonic_const:
; CHECK:    ldr w0, [x0]
    %r = load atomic i32, ptr %ptr monotonic, align 4
    ret i32 %r
}

define dso_local i32 @load_atomic_i32_aligned_acquire(ptr %ptr) {
; CHECK-LABEL: load_atomic_i32_aligned_acquire:
; CHECK:    ldar w0, [x0]
    %r = load atomic i32, ptr %ptr acquire, align 4
    ret i32 %r
}

define dso_local i32 @load_atomic_i32_aligned_acquire_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i32_aligned_acquire_const:
; CHECK:    ldar w0, [x0]
    %r = load atomic i32, ptr %ptr acquire, align 4
    ret i32 %r
}

define dso_local i32 @load_atomic_i32_aligned_seq_cst(ptr %ptr) {
; CHECK-LABEL: load_atomic_i32_aligned_seq_cst:
; CHECK:    ldar w0, [x0]
    %r = load atomic i32, ptr %ptr seq_cst, align 4
    ret i32 %r
}

define dso_local i32 @load_atomic_i32_aligned_seq_cst_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i32_aligned_seq_cst_const:
; CHECK:    ldar w0, [x0]
    %r = load atomic i32, ptr %ptr seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @load_atomic_i64_aligned_unordered(ptr %ptr) {
; CHECK-LABEL: load_atomic_i64_aligned_unordered:
; CHECK:    ldr x0, [x0]
    %r = load atomic i64, ptr %ptr unordered, align 8
    ret i64 %r
}

define dso_local i64 @load_atomic_i64_aligned_unordered_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i64_aligned_unordered_const:
; CHECK:    ldr x0, [x0]
    %r = load atomic i64, ptr %ptr unordered, align 8
    ret i64 %r
}

define dso_local i64 @load_atomic_i64_aligned_monotonic(ptr %ptr) {
; CHECK-LABEL: load_atomic_i64_aligned_monotonic:
; CHECK:    ldr x0, [x0]
    %r = load atomic i64, ptr %ptr monotonic, align 8
    ret i64 %r
}

define dso_local i64 @load_atomic_i64_aligned_monotonic_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i64_aligned_monotonic_const:
; CHECK:    ldr x0, [x0]
    %r = load atomic i64, ptr %ptr monotonic, align 8
    ret i64 %r
}

define dso_local i64 @load_atomic_i64_aligned_acquire(ptr %ptr) {
; CHECK-LABEL: load_atomic_i64_aligned_acquire:
; CHECK:    ldar x0, [x0]
    %r = load atomic i64, ptr %ptr acquire, align 8
    ret i64 %r
}

define dso_local i64 @load_atomic_i64_aligned_acquire_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i64_aligned_acquire_const:
; CHECK:    ldar x0, [x0]
    %r = load atomic i64, ptr %ptr acquire, align 8
    ret i64 %r
}

define dso_local i64 @load_atomic_i64_aligned_seq_cst(ptr %ptr) {
; CHECK-LABEL: load_atomic_i64_aligned_seq_cst:
; CHECK:    ldar x0, [x0]
    %r = load atomic i64, ptr %ptr seq_cst, align 8
    ret i64 %r
}

define dso_local i64 @load_atomic_i64_aligned_seq_cst_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i64_aligned_seq_cst_const:
; CHECK:    ldar x0, [x0]
    %r = load atomic i64, ptr %ptr seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @load_atomic_i128_aligned_unordered(ptr %ptr) {
; CHECK-LABEL: load_atomic_i128_aligned_unordered:
; CHECK:    casp x2, x3, x2, x3, [x0]
    %r = load atomic i128, ptr %ptr unordered, align 16
    ret i128 %r
}

define dso_local i128 @load_atomic_i128_aligned_unordered_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i128_aligned_unordered_const:
; CHECK:    casp x2, x3, x2, x3, [x0]
    %r = load atomic i128, ptr %ptr unordered, align 16
    ret i128 %r
}

define dso_local i128 @load_atomic_i128_aligned_monotonic(ptr %ptr) {
; CHECK-LABEL: load_atomic_i128_aligned_monotonic:
; CHECK:    casp x2, x3, x2, x3, [x0]
    %r = load atomic i128, ptr %ptr monotonic, align 16
    ret i128 %r
}

define dso_local i128 @load_atomic_i128_aligned_monotonic_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i128_aligned_monotonic_const:
; CHECK:    casp x2, x3, x2, x3, [x0]
    %r = load atomic i128, ptr %ptr monotonic, align 16
    ret i128 %r
}

define dso_local i128 @load_atomic_i128_aligned_acquire(ptr %ptr) {
; CHECK-LABEL: load_atomic_i128_aligned_acquire:
; CHECK:    caspa x2, x3, x2, x3, [x0]
    %r = load atomic i128, ptr %ptr acquire, align 16
    ret i128 %r
}

define dso_local i128 @load_atomic_i128_aligned_acquire_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i128_aligned_acquire_const:
; CHECK:    caspa x2, x3, x2, x3, [x0]
    %r = load atomic i128, ptr %ptr acquire, align 16
    ret i128 %r
}

define dso_local i128 @load_atomic_i128_aligned_seq_cst(ptr %ptr) {
; CHECK-LABEL: load_atomic_i128_aligned_seq_cst:
; CHECK:    caspal x2, x3, x2, x3, [x0]
    %r = load atomic i128, ptr %ptr seq_cst, align 16
    ret i128 %r
}

define dso_local i128 @load_atomic_i128_aligned_seq_cst_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i128_aligned_seq_cst_const:
; CHECK:    caspal x2, x3, x2, x3, [x0]
    %r = load atomic i128, ptr %ptr seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @load_atomic_i8_unaligned_unordered(ptr %ptr) {
; CHECK-LABEL: load_atomic_i8_unaligned_unordered:
; CHECK:    ldrb w0, [x0]
    %r = load atomic i8, ptr %ptr unordered, align 1
    ret i8 %r
}

define dso_local i8 @load_atomic_i8_unaligned_unordered_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i8_unaligned_unordered_const:
; CHECK:    ldrb w0, [x0]
    %r = load atomic i8, ptr %ptr unordered, align 1
    ret i8 %r
}

define dso_local i8 @load_atomic_i8_unaligned_monotonic(ptr %ptr) {
; CHECK-LABEL: load_atomic_i8_unaligned_monotonic:
; CHECK:    ldrb w0, [x0]
    %r = load atomic i8, ptr %ptr monotonic, align 1
    ret i8 %r
}

define dso_local i8 @load_atomic_i8_unaligned_monotonic_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i8_unaligned_monotonic_const:
; CHECK:    ldrb w0, [x0]
    %r = load atomic i8, ptr %ptr monotonic, align 1
    ret i8 %r
}

define dso_local i8 @load_atomic_i8_unaligned_acquire(ptr %ptr) {
; CHECK-LABEL: load_atomic_i8_unaligned_acquire:
; CHECK:    ldarb w0, [x0]
    %r = load atomic i8, ptr %ptr acquire, align 1
    ret i8 %r
}

define dso_local i8 @load_atomic_i8_unaligned_acquire_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i8_unaligned_acquire_const:
; CHECK:    ldarb w0, [x0]
    %r = load atomic i8, ptr %ptr acquire, align 1
    ret i8 %r
}

define dso_local i8 @load_atomic_i8_unaligned_seq_cst(ptr %ptr) {
; CHECK-LABEL: load_atomic_i8_unaligned_seq_cst:
; CHECK:    ldarb w0, [x0]
    %r = load atomic i8, ptr %ptr seq_cst, align 1
    ret i8 %r
}

define dso_local i8 @load_atomic_i8_unaligned_seq_cst_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i8_unaligned_seq_cst_const:
; CHECK:    ldarb w0, [x0]
    %r = load atomic i8, ptr %ptr seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @load_atomic_i16_unaligned_unordered(ptr %ptr) {
; CHECK-LABEL: load_atomic_i16_unaligned_unordered:
; CHECK:    bl __atomic_load
    %r = load atomic i16, ptr %ptr unordered, align 1
    ret i16 %r
}

define dso_local i16 @load_atomic_i16_unaligned_unordered_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i16_unaligned_unordered_const:
; CHECK:    bl __atomic_load
    %r = load atomic i16, ptr %ptr unordered, align 1
    ret i16 %r
}

define dso_local i16 @load_atomic_i16_unaligned_monotonic(ptr %ptr) {
; CHECK-LABEL: load_atomic_i16_unaligned_monotonic:
; CHECK:    bl __atomic_load
    %r = load atomic i16, ptr %ptr monotonic, align 1
    ret i16 %r
}

define dso_local i16 @load_atomic_i16_unaligned_monotonic_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i16_unaligned_monotonic_const:
; CHECK:    bl __atomic_load
    %r = load atomic i16, ptr %ptr monotonic, align 1
    ret i16 %r
}

define dso_local i16 @load_atomic_i16_unaligned_acquire(ptr %ptr) {
; CHECK-LABEL: load_atomic_i16_unaligned_acquire:
; CHECK:    bl __atomic_load
    %r = load atomic i16, ptr %ptr acquire, align 1
    ret i16 %r
}

define dso_local i16 @load_atomic_i16_unaligned_acquire_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i16_unaligned_acquire_const:
; CHECK:    bl __atomic_load
    %r = load atomic i16, ptr %ptr acquire, align 1
    ret i16 %r
}

define dso_local i16 @load_atomic_i16_unaligned_seq_cst(ptr %ptr) {
; CHECK-LABEL: load_atomic_i16_unaligned_seq_cst:
; CHECK:    bl __atomic_load
    %r = load atomic i16, ptr %ptr seq_cst, align 1
    ret i16 %r
}

define dso_local i16 @load_atomic_i16_unaligned_seq_cst_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i16_unaligned_seq_cst_const:
; CHECK:    bl __atomic_load
    %r = load atomic i16, ptr %ptr seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @load_atomic_i32_unaligned_unordered(ptr %ptr) {
; CHECK-LABEL: load_atomic_i32_unaligned_unordered:
; CHECK:    bl __atomic_load
    %r = load atomic i32, ptr %ptr unordered, align 1
    ret i32 %r
}

define dso_local i32 @load_atomic_i32_unaligned_unordered_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i32_unaligned_unordered_const:
; CHECK:    bl __atomic_load
    %r = load atomic i32, ptr %ptr unordered, align 1
    ret i32 %r
}

define dso_local i32 @load_atomic_i32_unaligned_monotonic(ptr %ptr) {
; CHECK-LABEL: load_atomic_i32_unaligned_monotonic:
; CHECK:    bl __atomic_load
    %r = load atomic i32, ptr %ptr monotonic, align 1
    ret i32 %r
}

define dso_local i32 @load_atomic_i32_unaligned_monotonic_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i32_unaligned_monotonic_const:
; CHECK:    bl __atomic_load
    %r = load atomic i32, ptr %ptr monotonic, align 1
    ret i32 %r
}

define dso_local i32 @load_atomic_i32_unaligned_acquire(ptr %ptr) {
; CHECK-LABEL: load_atomic_i32_unaligned_acquire:
; CHECK:    bl __atomic_load
    %r = load atomic i32, ptr %ptr acquire, align 1
    ret i32 %r
}

define dso_local i32 @load_atomic_i32_unaligned_acquire_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i32_unaligned_acquire_const:
; CHECK:    bl __atomic_load
    %r = load atomic i32, ptr %ptr acquire, align 1
    ret i32 %r
}

define dso_local i32 @load_atomic_i32_unaligned_seq_cst(ptr %ptr) {
; CHECK-LABEL: load_atomic_i32_unaligned_seq_cst:
; CHECK:    bl __atomic_load
    %r = load atomic i32, ptr %ptr seq_cst, align 1
    ret i32 %r
}

define dso_local i32 @load_atomic_i32_unaligned_seq_cst_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i32_unaligned_seq_cst_const:
; CHECK:    bl __atomic_load
    %r = load atomic i32, ptr %ptr seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @load_atomic_i64_unaligned_unordered(ptr %ptr) {
; CHECK-LABEL: load_atomic_i64_unaligned_unordered:
; CHECK:    bl __atomic_load
    %r = load atomic i64, ptr %ptr unordered, align 1
    ret i64 %r
}

define dso_local i64 @load_atomic_i64_unaligned_unordered_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i64_unaligned_unordered_const:
; CHECK:    bl __atomic_load
    %r = load atomic i64, ptr %ptr unordered, align 1
    ret i64 %r
}

define dso_local i64 @load_atomic_i64_unaligned_monotonic(ptr %ptr) {
; CHECK-LABEL: load_atomic_i64_unaligned_monotonic:
; CHECK:    bl __atomic_load
    %r = load atomic i64, ptr %ptr monotonic, align 1
    ret i64 %r
}

define dso_local i64 @load_atomic_i64_unaligned_monotonic_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i64_unaligned_monotonic_const:
; CHECK:    bl __atomic_load
    %r = load atomic i64, ptr %ptr monotonic, align 1
    ret i64 %r
}

define dso_local i64 @load_atomic_i64_unaligned_acquire(ptr %ptr) {
; CHECK-LABEL: load_atomic_i64_unaligned_acquire:
; CHECK:    bl __atomic_load
    %r = load atomic i64, ptr %ptr acquire, align 1
    ret i64 %r
}

define dso_local i64 @load_atomic_i64_unaligned_acquire_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i64_unaligned_acquire_const:
; CHECK:    bl __atomic_load
    %r = load atomic i64, ptr %ptr acquire, align 1
    ret i64 %r
}

define dso_local i64 @load_atomic_i64_unaligned_seq_cst(ptr %ptr) {
; CHECK-LABEL: load_atomic_i64_unaligned_seq_cst:
; CHECK:    bl __atomic_load
    %r = load atomic i64, ptr %ptr seq_cst, align 1
    ret i64 %r
}

define dso_local i64 @load_atomic_i64_unaligned_seq_cst_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i64_unaligned_seq_cst_const:
; CHECK:    bl __atomic_load
    %r = load atomic i64, ptr %ptr seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @load_atomic_i128_unaligned_unordered(ptr %ptr) {
; CHECK-LABEL: load_atomic_i128_unaligned_unordered:
; CHECK:    bl __atomic_load
    %r = load atomic i128, ptr %ptr unordered, align 1
    ret i128 %r
}

define dso_local i128 @load_atomic_i128_unaligned_unordered_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i128_unaligned_unordered_const:
; CHECK:    bl __atomic_load
    %r = load atomic i128, ptr %ptr unordered, align 1
    ret i128 %r
}

define dso_local i128 @load_atomic_i128_unaligned_monotonic(ptr %ptr) {
; CHECK-LABEL: load_atomic_i128_unaligned_monotonic:
; CHECK:    bl __atomic_load
    %r = load atomic i128, ptr %ptr monotonic, align 1
    ret i128 %r
}

define dso_local i128 @load_atomic_i128_unaligned_monotonic_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i128_unaligned_monotonic_const:
; CHECK:    bl __atomic_load
    %r = load atomic i128, ptr %ptr monotonic, align 1
    ret i128 %r
}

define dso_local i128 @load_atomic_i128_unaligned_acquire(ptr %ptr) {
; CHECK-LABEL: load_atomic_i128_unaligned_acquire:
; CHECK:    bl __atomic_load
    %r = load atomic i128, ptr %ptr acquire, align 1
    ret i128 %r
}

define dso_local i128 @load_atomic_i128_unaligned_acquire_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i128_unaligned_acquire_const:
; CHECK:    bl __atomic_load
    %r = load atomic i128, ptr %ptr acquire, align 1
    ret i128 %r
}

define dso_local i128 @load_atomic_i128_unaligned_seq_cst(ptr %ptr) {
; CHECK-LABEL: load_atomic_i128_unaligned_seq_cst:
; CHECK:    bl __atomic_load
    %r = load atomic i128, ptr %ptr seq_cst, align 1
    ret i128 %r
}

define dso_local i128 @load_atomic_i128_unaligned_seq_cst_const(ptr readonly %ptr) {
; CHECK-LABEL: load_atomic_i128_unaligned_seq_cst_const:
; CHECK:    bl __atomic_load
    %r = load atomic i128, ptr %ptr seq_cst, align 1
    ret i128 %r
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; -O0: {{.*}}
; -O1: {{.*}}
