#include <stdio.h>

#define TESTINST(instruction, in, in1, pos, size)                          \
{                                                                          \
   unsigned long long out;                                                 \
   __asm__ __volatile__(                                                   \
      "move        $t0, %2"                  "\n\t"                        \
      "move        $t1, %1"                  "\n\t"                        \
      instruction" $t0, $t1, "#pos", "#size  "\n\t"                        \
      "move        %0,  $t0"                 "\n\t"                        \
      : "=r" (out)                                                         \
      : "r" (in), "r" (in1)                                                \
      : "t0", "t1"                                                         \
   );                                                                      \
   printf("%s :: in 0x%llx, in1 0x%llx, out 0x%llx, pos: %d, size: %d\n",  \
          instruction, (long long) in, (long long) in1, out, pos, size);   \
}

int main()
{
#if (__mips == 64) && (__mips_isa_rev >= 2)
   printf("--- INS ---\n");
   /* The values of pos and size must satisfy all of the following relations:
      0 <= pos < 32
      0 < size <= 32
      0 < pos+size <= 32 */
   TESTINST("ins", 0x0,                0x0,                0, 1);
   TESTINST("ins", 0x0,                0xffffffffffffffff, 0, 1);
   TESTINST("ins", 0x0,                0x98765432,         0, 1);
   TESTINST("ins", 0x0,                0xffffffffff865421, 0, 1);
   TESTINST("ins", 0xffffffffffffffff, 0x0,                0, 1);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffffffffff, 0, 1);
   TESTINST("ins", 0xffffffffffffffff, 0x98765432,         0, 1);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffff865421, 0, 1);
   TESTINST("ins", 0x98765432,         0x0,                0, 1);
   TESTINST("ins", 0x98765432,         0xffffffffffffffff, 0, 1);
   TESTINST("ins", 0x98765432,         0x98765432,         0, 1);
   TESTINST("ins", 0x98765432,         0xffffffffff865421, 0, 1);
   TESTINST("ins", 0xffffffffff865421, 0x0,                0, 1);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffffffffff, 0, 1);
   TESTINST("ins", 0xffffffffff865421, 0x98765432,         0, 1);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffff865421, 0, 1);
   TESTINST("ins", 0x0,                0x0,                0, 4);
   TESTINST("ins", 0x0,                0xffffffffffffffff, 0, 4);
   TESTINST("ins", 0x0,                0x98765432,         0, 4);
   TESTINST("ins", 0x0,                0xffffffffff865421, 0, 4);
   TESTINST("ins", 0xffffffffffffffff, 0x0,                0, 4);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffffffffff, 0, 4);
   TESTINST("ins", 0xffffffffffffffff, 0x98765432,         0, 4);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffff865421, 0, 4);
   TESTINST("ins", 0x98765432,         0x0,                0, 4);
   TESTINST("ins", 0x98765432,         0xffffffffffffffff, 0, 4);
   TESTINST("ins", 0x98765432,         0x98765432,         0, 4);
   TESTINST("ins", 0x98765432,         0xffffffffff865421, 0, 4);
   TESTINST("ins", 0xffffffffff865421, 0x0,                0, 4);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffffffffff, 0, 4);
   TESTINST("ins", 0xffffffffff865421, 0x98765432,         0, 4);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffff865421, 0, 4);
   TESTINST("ins", 0x0,                0x0,                0, 16);
   TESTINST("ins", 0x0,                0xffffffffffffffff, 0, 16);
   TESTINST("ins", 0x0,                0x98765432,         0, 16);
   TESTINST("ins", 0x0,                0xffffffffff865421, 0, 16);
   TESTINST("ins", 0xffffffffffffffff, 0x0,                0, 16);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffffffffff, 0, 16);
   TESTINST("ins", 0xffffffffffffffff, 0x98765432,         0, 16);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffff865421, 0, 16);
   TESTINST("ins", 0x98765432,         0x0,                0, 16);
   TESTINST("ins", 0x98765432,         0xffffffffffffffff, 0, 16);
   TESTINST("ins", 0x98765432,         0x98765432,         0, 16);
   TESTINST("ins", 0x98765432,         0xffffffffff865421, 0, 16);
   TESTINST("ins", 0xffffffffff865421, 0x0,                0, 16);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffffffffff, 0, 16);
   TESTINST("ins", 0xffffffffff865421, 0x98765432,         0, 16);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffff865421, 0, 16);
   TESTINST("ins", 0x0,                0x0,                0, 32);
   TESTINST("ins", 0x0,                0xffffffffffffffff, 0, 32);
   TESTINST("ins", 0x0,                0x98765432,         0, 32);
   TESTINST("ins", 0x0,                0xffffffffff865421, 0, 32);
   TESTINST("ins", 0xffffffffffffffff, 0x0,                0, 32);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffffffffff, 0, 32);
   TESTINST("ins", 0xffffffffffffffff, 0x98765432,         0, 32);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffff865421, 0, 32);
   TESTINST("ins", 0x98765432,         0x0,                0, 32);
   TESTINST("ins", 0x98765432,         0xffffffffffffffff, 0, 32);
   TESTINST("ins", 0x98765432,         0x98765432,         0, 32);
   TESTINST("ins", 0x98765432,         0xffffffffff865421, 0, 32);
   TESTINST("ins", 0xffffffffff865421, 0x0,                0, 32);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffffffffff, 0, 32);
   TESTINST("ins", 0xffffffffff865421, 0x98765432,         0, 32);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffff865421, 0, 32);

   TESTINST("ins", 0x0,                0x0,                4, 1);
   TESTINST("ins", 0x0,                0xffffffffffffffff, 4, 1);
   TESTINST("ins", 0x0,                0x98765432,         4, 1);
   TESTINST("ins", 0x0,                0xffffffffff865421, 4, 1);
   TESTINST("ins", 0xffffffffffffffff, 0x0,                4, 1);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffffffffff, 4, 1);
   TESTINST("ins", 0xffffffffffffffff, 0x98765432,         4, 1);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffff865421, 4, 1);
   TESTINST("ins", 0x98765432,         0x0,                4, 1);
   TESTINST("ins", 0x98765432,         0xffffffffffffffff, 4, 1);
   TESTINST("ins", 0x98765432,         0x98765432,         4, 1);
   TESTINST("ins", 0x98765432,         0xffffffffff865421, 4, 1);
   TESTINST("ins", 0xffffffffff865421, 0x0,                4, 1);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffffffffff, 4, 1);
   TESTINST("ins", 0xffffffffff865421, 0x98765432,         4, 1);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffff865421, 4, 1);
   TESTINST("ins", 0x0,                0x0,                4, 4);
   TESTINST("ins", 0x0,                0xffffffffffffffff, 4, 4);
   TESTINST("ins", 0x0,                0x98765432,         4, 4);
   TESTINST("ins", 0x0,                0xffffffffff865421, 4, 4);
   TESTINST("ins", 0xffffffffffffffff, 0x0,                4, 4);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffffffffff, 4, 4);
   TESTINST("ins", 0xffffffffffffffff, 0x98765432,         4, 4);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffff865421, 4, 4);
   TESTINST("ins", 0x98765432,         0x0,                4, 4);
   TESTINST("ins", 0x98765432,         0xffffffffffffffff, 4, 4);
   TESTINST("ins", 0x98765432,         0x98765432,         4, 4);
   TESTINST("ins", 0x98765432,         0xffffffffff865421, 4, 4);
   TESTINST("ins", 0xffffffffff865421, 0x0,                4, 4);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffffffffff, 4, 4);
   TESTINST("ins", 0xffffffffff865421, 0x98765432,         4, 4);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffff865421, 4, 4);
   TESTINST("ins", 0x0,                0x0,                4, 16);
   TESTINST("ins", 0x0,                0xffffffffffffffff, 4, 16);
   TESTINST("ins", 0x0,                0x98765432,         4, 16);
   TESTINST("ins", 0x0,                0xffffffffff865421, 4, 16);
   TESTINST("ins", 0xffffffffffffffff, 0x0,                4, 16);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffffffffff, 4, 16);
   TESTINST("ins", 0xffffffffffffffff, 0x98765432,         4, 16);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffff865421, 4, 16);
   TESTINST("ins", 0x98765432,         0x0,                4, 16);
   TESTINST("ins", 0x98765432,         0xffffffffffffffff, 4, 16);
   TESTINST("ins", 0x98765432,         0x98765432,         4, 16);
   TESTINST("ins", 0x98765432,         0xffffffffff865421, 4, 16);
   TESTINST("ins", 0xffffffffff865421, 0x0,                4, 16);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffffffffff, 4, 16);
   TESTINST("ins", 0xffffffffff865421, 0x98765432,         4, 16);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffff865421, 4, 16);
   TESTINST("ins", 0x0,                0x0,                4, 28);
   TESTINST("ins", 0x0,                0xffffffffffffffff, 4, 28);
   TESTINST("ins", 0x0,                0x98765432,         4, 28);
   TESTINST("ins", 0x0,                0xffffffffff865421, 4, 28);
   TESTINST("ins", 0xffffffffffffffff, 0x0,                4, 28);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffffffffff, 4, 28);
   TESTINST("ins", 0xffffffffffffffff, 0x98765432,         4, 28);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffff865421, 4, 28);
   TESTINST("ins", 0x98765432,         0x0,                4, 28);
   TESTINST("ins", 0x98765432,         0xffffffffffffffff, 4, 28);
   TESTINST("ins", 0x98765432,         0x98765432,         4, 28);
   TESTINST("ins", 0x98765432,         0xffffffffff865421, 4, 28);
   TESTINST("ins", 0xffffffffff865421, 0x0,                4, 28);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffffffffff, 4, 28);
   TESTINST("ins", 0xffffffffff865421, 0x98765432,         4, 28);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffff865421, 4, 28);

   TESTINST("ins", 0x0,                0x0,                16, 1);
   TESTINST("ins", 0x0,                0xffffffffffffffff, 16, 1);
   TESTINST("ins", 0x0,                0x98765432,         16, 1);
   TESTINST("ins", 0x0,                0xffffffffff865421, 16, 1);
   TESTINST("ins", 0xffffffffffffffff, 0x0,                16, 1);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffffffffff, 16, 1);
   TESTINST("ins", 0xffffffffffffffff, 0x98765432,         16, 1);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffff865421, 16, 1);
   TESTINST("ins", 0x98765432,         0x0,                16, 1);
   TESTINST("ins", 0x98765432,         0xffffffffffffffff, 16, 1);
   TESTINST("ins", 0x98765432,         0x98765432,         16, 1);
   TESTINST("ins", 0x98765432,         0xffffffffff865421, 16, 1);
   TESTINST("ins", 0xffffffffff865421, 0x0,                16, 1);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffffffffff, 16, 1);
   TESTINST("ins", 0xffffffffff865421, 0x98765432,         16, 1);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffff865421, 16, 1);
   TESTINST("ins", 0x0,                0x0,                16, 4);
   TESTINST("ins", 0x0,                0xffffffffffffffff, 16, 4);
   TESTINST("ins", 0x0,                0x98765432,         16, 4);
   TESTINST("ins", 0x0,                0xffffffffff865421, 16, 4);
   TESTINST("ins", 0xffffffffffffffff, 0x0,                16, 4);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffffffffff, 16, 4);
   TESTINST("ins", 0xffffffffffffffff, 0x98765432,         16, 4);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffff865421, 16, 4);
   TESTINST("ins", 0x98765432,         0x0,                16, 4);
   TESTINST("ins", 0x98765432,         0xffffffffffffffff, 16, 4);
   TESTINST("ins", 0x98765432,         0x98765432,         16, 4);
   TESTINST("ins", 0x98765432,         0xffffffffff865421, 16, 4);
   TESTINST("ins", 0xffffffffff865421, 0x0,                16, 4);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffffffffff, 16, 4);
   TESTINST("ins", 0xffffffffff865421, 0x98765432,         16, 4);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffff865421, 16, 4);
   TESTINST("ins", 0x0,                0x0,                16, 16);
   TESTINST("ins", 0x0,                0xffffffffffffffff, 16, 16);
   TESTINST("ins", 0x0,                0x98765432,         16, 16);
   TESTINST("ins", 0x0,                0xffffffffff865421, 16, 16);
   TESTINST("ins", 0xffffffffffffffff, 0x0,                16, 16);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffffffffff, 16, 16);
   TESTINST("ins", 0xffffffffffffffff, 0x98765432,         16, 16);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffff865421, 16, 16);
   TESTINST("ins", 0x98765432,         0x0,                16, 16);
   TESTINST("ins", 0x98765432,         0xffffffffffffffff, 16, 16);
   TESTINST("ins", 0x98765432,         0x98765432,         16, 16);
   TESTINST("ins", 0x98765432,         0xffffffffff865421, 16, 16);
   TESTINST("ins", 0xffffffffff865421, 0x0,                16, 16);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffffffffff, 16, 16);
   TESTINST("ins", 0xffffffffff865421, 0x98765432,         16, 16);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffff865421, 16, 16);

   TESTINST("ins", 0x0,                0x0,                31, 1);
   TESTINST("ins", 0x0,                0xffffffffffffffff, 31, 1);
   TESTINST("ins", 0x0,                0x98765432,         31, 1);
   TESTINST("ins", 0x0,                0xffffffffff865421, 31, 1);
   TESTINST("ins", 0xffffffffffffffff, 0x0,                31, 1);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffffffffff, 31, 1);
   TESTINST("ins", 0xffffffffffffffff, 0x98765432,         31, 1);
   TESTINST("ins", 0xffffffffffffffff, 0xffffffffff865421, 31, 1);
   TESTINST("ins", 0x98765432,         0x0,                31, 1);
   TESTINST("ins", 0x98765432,         0xffffffffffffffff, 31, 1);
   TESTINST("ins", 0x98765432,         0x98765432,         31, 1);
   TESTINST("ins", 0x98765432,         0xffffffffff865421, 31, 1);
   TESTINST("ins", 0xffffffffff865421, 0x0,                31, 1);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffffffffff, 31, 1);
   TESTINST("ins", 0xffffffffff865421, 0x98765432,         31, 1);
   TESTINST("ins", 0xffffffffff865421, 0xffffffffff865421, 31, 1);

   printf("--- EXT ---\n");
   /* The values of pos and size must satisfy all of the following relations:
      0 <= pos < 32
      0 < size <= 32
      0 < pos+size <= 32 */
   TESTINST("ext", 0x0,                0x0,                0, 1);
   TESTINST("ext", 0x0,                0xffffffffffffffff, 0, 1);
   TESTINST("ext", 0x0,                0x98765432,         0, 1);
   TESTINST("ext", 0x0,                0xffffffffff865421, 0, 1);
   TESTINST("ext", 0xffffffffffffffff, 0x0,                0, 1);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffffffffff, 0, 1);
   TESTINST("ext", 0xffffffffffffffff, 0x98765432,         0, 1);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffff865421, 0, 1);
   TESTINST("ext", 0x98765432,         0x0,                0, 1);
   TESTINST("ext", 0x98765432,         0xffffffffffffffff, 0, 1);
   TESTINST("ext", 0x98765432,         0x98765432,         0, 1);
   TESTINST("ext", 0x98765432,         0xffffffffff865421, 0, 1);
   TESTINST("ext", 0xffffffffff865421, 0x0,                0, 1);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffffffffff, 0, 1);
   TESTINST("ext", 0xffffffffff865421, 0x98765432,         0, 1);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffff865421, 0, 1);
   TESTINST("ext", 0x0,                0x0,                0, 4);
   TESTINST("ext", 0x0,                0xffffffffffffffff, 0, 4);
   TESTINST("ext", 0x0,                0x98765432,         0, 4);
   TESTINST("ext", 0x0,                0xffffffffff865421, 0, 4);
   TESTINST("ext", 0xffffffffffffffff, 0x0,                0, 4);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffffffffff, 0, 4);
   TESTINST("ext", 0xffffffffffffffff, 0x98765432,         0, 4);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffff865421, 0, 4);
   TESTINST("ext", 0x98765432,         0x0,                0, 4);
   TESTINST("ext", 0x98765432,         0xffffffffffffffff, 0, 4);
   TESTINST("ext", 0x98765432,         0x98765432,         0, 4);
   TESTINST("ext", 0x98765432,         0xffffffffff865421, 0, 4);
   TESTINST("ext", 0xffffffffff865421, 0x0,                0, 4);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffffffffff, 0, 4);
   TESTINST("ext", 0xffffffffff865421, 0x98765432,         0, 4);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffff865421, 0, 4);
   TESTINST("ext", 0x0,                0x0,                0, 16);
   TESTINST("ext", 0x0,                0xffffffffffffffff, 0, 16);
   TESTINST("ext", 0x0,                0x98765432,         0, 16);
   TESTINST("ext", 0x0,                0xffffffffff865421, 0, 16);
   TESTINST("ext", 0xffffffffffffffff, 0x0,                0, 16);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffffffffff, 0, 16);
   TESTINST("ext", 0xffffffffffffffff, 0x98765432,         0, 16);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffff865421, 0, 16);
   TESTINST("ext", 0x98765432,         0x0,                0, 16);
   TESTINST("ext", 0x98765432,         0xffffffffffffffff, 0, 16);
   TESTINST("ext", 0x98765432,         0x98765432,         0, 16);
   TESTINST("ext", 0x98765432,         0xffffffffff865421, 0, 16);
   TESTINST("ext", 0xffffffffff865421, 0x0,                0, 16);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffffffffff, 0, 16);
   TESTINST("ext", 0xffffffffff865421, 0x98765432,         0, 16);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffff865421, 0, 16);
   TESTINST("ext", 0x0,                0x0,                0, 32);
   TESTINST("ext", 0x0,                0xffffffffffffffff, 0, 32);
   TESTINST("ext", 0x0,                0x98765432,         0, 32);
   TESTINST("ext", 0x0,                0xffffffffff865421, 0, 32);
   TESTINST("ext", 0xffffffffffffffff, 0x0,                0, 32);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffffffffff, 0, 32);
   TESTINST("ext", 0xffffffffffffffff, 0x98765432,         0, 32);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffff865421, 0, 32);
   TESTINST("ext", 0x98765432,         0x0,                0, 32);
   TESTINST("ext", 0x98765432,         0xffffffffffffffff, 0, 32);
   TESTINST("ext", 0x98765432,         0x98765432,         0, 32);
   TESTINST("ext", 0x98765432,         0xffffffffff865421, 0, 32);
   TESTINST("ext", 0xffffffffff865421, 0x0,                0, 32);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffffffffff, 0, 32);
   TESTINST("ext", 0xffffffffff865421, 0x98765432,         0, 32);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffff865421, 0, 32);

   TESTINST("ext", 0x0,                0x0,                4, 1);
   TESTINST("ext", 0x0,                0xffffffffffffffff, 4, 1);
   TESTINST("ext", 0x0,                0x98765432,         4, 1);
   TESTINST("ext", 0x0,                0xffffffffff865421, 4, 1);
   TESTINST("ext", 0xffffffffffffffff, 0x0,                4, 1);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffffffffff, 4, 1);
   TESTINST("ext", 0xffffffffffffffff, 0x98765432,         4, 1);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffff865421, 4, 1);
   TESTINST("ext", 0x98765432,         0x0,                4, 1);
   TESTINST("ext", 0x98765432,         0xffffffffffffffff, 4, 1);
   TESTINST("ext", 0x98765432,         0x98765432,         4, 1);
   TESTINST("ext", 0x98765432,         0xffffffffff865421, 4, 1);
   TESTINST("ext", 0xffffffffff865421, 0x0,                4, 1);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffffffffff, 4, 1);
   TESTINST("ext", 0xffffffffff865421, 0x98765432,         4, 1);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffff865421, 4, 1);
   TESTINST("ext", 0x0,                0x0,                4, 4);
   TESTINST("ext", 0x0,                0xffffffffffffffff, 4, 4);
   TESTINST("ext", 0x0,                0x98765432,         4, 4);
   TESTINST("ext", 0x0,                0xffffffffff865421, 4, 4);
   TESTINST("ext", 0xffffffffffffffff, 0x0,                4, 4);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffffffffff, 4, 4);
   TESTINST("ext", 0xffffffffffffffff, 0x98765432,         4, 4);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffff865421, 4, 4);
   TESTINST("ext", 0x98765432,         0x0,                4, 4);
   TESTINST("ext", 0x98765432,         0xffffffffffffffff, 4, 4);
   TESTINST("ext", 0x98765432,         0x98765432,         4, 4);
   TESTINST("ext", 0x98765432,         0xffffffffff865421, 4, 4);
   TESTINST("ext", 0xffffffffff865421, 0x0,                4, 4);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffffffffff, 4, 4);
   TESTINST("ext", 0xffffffffff865421, 0x98765432,         4, 4);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffff865421, 4, 4);
   TESTINST("ext", 0x0,                0x0,                4, 16);
   TESTINST("ext", 0x0,                0xffffffffffffffff, 4, 16);
   TESTINST("ext", 0x0,                0x98765432,         4, 16);
   TESTINST("ext", 0x0,                0xffffffffff865421, 4, 16);
   TESTINST("ext", 0xffffffffffffffff, 0x0,                4, 16);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffffffffff, 4, 16);
   TESTINST("ext", 0xffffffffffffffff, 0x98765432,         4, 16);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffff865421, 4, 16);
   TESTINST("ext", 0x98765432,         0x0,                4, 16);
   TESTINST("ext", 0x98765432,         0xffffffffffffffff, 4, 16);
   TESTINST("ext", 0x98765432,         0x98765432,         4, 16);
   TESTINST("ext", 0x98765432,         0xffffffffff865421, 4, 16);
   TESTINST("ext", 0xffffffffff865421, 0x0,                4, 16);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffffffffff, 4, 16);
   TESTINST("ext", 0xffffffffff865421, 0x98765432,         4, 16);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffff865421, 4, 16);
   TESTINST("ext", 0x0,                0x0,                4, 28);
   TESTINST("ext", 0x0,                0xffffffffffffffff, 4, 28);
   TESTINST("ext", 0x0,                0x98765432,         4, 28);
   TESTINST("ext", 0x0,                0xffffffffff865421, 4, 28);
   TESTINST("ext", 0xffffffffffffffff, 0x0,                4, 28);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffffffffff, 4, 28);
   TESTINST("ext", 0xffffffffffffffff, 0x98765432,         4, 28);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffff865421, 4, 28);
   TESTINST("ext", 0x98765432,         0x0,                4, 28);
   TESTINST("ext", 0x98765432,         0xffffffffffffffff, 4, 28);
   TESTINST("ext", 0x98765432,         0x98765432,         4, 28);
   TESTINST("ext", 0x98765432,         0xffffffffff865421, 4, 28);
   TESTINST("ext", 0xffffffffff865421, 0x0,                4, 28);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffffffffff, 4, 28);
   TESTINST("ext", 0xffffffffff865421, 0x98765432,         4, 28);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffff865421, 4, 28);

   TESTINST("ext", 0x0,                0x0,                16, 1);
   TESTINST("ext", 0x0,                0xffffffffffffffff, 16, 1);
   TESTINST("ext", 0x0,                0x98765432,         16, 1);
   TESTINST("ext", 0x0,                0xffffffffff865421, 16, 1);
   TESTINST("ext", 0xffffffffffffffff, 0x0,                16, 1);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffffffffff, 16, 1);
   TESTINST("ext", 0xffffffffffffffff, 0x98765432,         16, 1);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffff865421, 16, 1);
   TESTINST("ext", 0x98765432,         0x0,                16, 1);
   TESTINST("ext", 0x98765432,         0xffffffffffffffff, 16, 1);
   TESTINST("ext", 0x98765432,         0x98765432,         16, 1);
   TESTINST("ext", 0x98765432,         0xffffffffff865421, 16, 1);
   TESTINST("ext", 0xffffffffff865421, 0x0,                16, 1);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffffffffff, 16, 1);
   TESTINST("ext", 0xffffffffff865421, 0x98765432,         16, 1);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffff865421, 16, 1);
   TESTINST("ext", 0x0,                0x0,                16, 4);
   TESTINST("ext", 0x0,                0xffffffffffffffff, 16, 4);
   TESTINST("ext", 0x0,                0x98765432,         16, 4);
   TESTINST("ext", 0x0,                0xffffffffff865421, 16, 4);
   TESTINST("ext", 0xffffffffffffffff, 0x0,                16, 4);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffffffffff, 16, 4);
   TESTINST("ext", 0xffffffffffffffff, 0x98765432,         16, 4);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffff865421, 16, 4);
   TESTINST("ext", 0x98765432,         0x0,                16, 4);
   TESTINST("ext", 0x98765432,         0xffffffffffffffff, 16, 4);
   TESTINST("ext", 0x98765432,         0x98765432,         16, 4);
   TESTINST("ext", 0x98765432,         0xffffffffff865421, 16, 4);
   TESTINST("ext", 0xffffffffff865421, 0x0,                16, 4);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffffffffff, 16, 4);
   TESTINST("ext", 0xffffffffff865421, 0x98765432,         16, 4);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffff865421, 16, 4);
   TESTINST("ext", 0x0,                0x0,                16, 16);
   TESTINST("ext", 0x0,                0xffffffffffffffff, 16, 16);
   TESTINST("ext", 0x0,                0x98765432,         16, 16);
   TESTINST("ext", 0x0,                0xffffffffff865421, 16, 16);
   TESTINST("ext", 0xffffffffffffffff, 0x0,                16, 16);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffffffffff, 16, 16);
   TESTINST("ext", 0xffffffffffffffff, 0x98765432,         16, 16);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffff865421, 16, 16);
   TESTINST("ext", 0x98765432,         0x0,                16, 16);
   TESTINST("ext", 0x98765432,         0xffffffffffffffff, 16, 16);
   TESTINST("ext", 0x98765432,         0x98765432,         16, 16);
   TESTINST("ext", 0x98765432,         0xffffffffff865421, 16, 16);
   TESTINST("ext", 0xffffffffff865421, 0x0,                16, 16);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffffffffff, 16, 16);
   TESTINST("ext", 0xffffffffff865421, 0x98765432,         16, 16);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffff865421, 16, 16);

   TESTINST("ext", 0x0,                0x0,                31, 1);
   TESTINST("ext", 0x0,                0xffffffffffffffff, 31, 1);
   TESTINST("ext", 0x0,                0x98765432,         31, 1);
   TESTINST("ext", 0x0,                0xffffffffff865421, 31, 1);
   TESTINST("ext", 0xffffffffffffffff, 0x0,                31, 1);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffffffffff, 31, 1);
   TESTINST("ext", 0xffffffffffffffff, 0x98765432,         31, 1);
   TESTINST("ext", 0xffffffffffffffff, 0xffffffffff865421, 31, 1);
   TESTINST("ext", 0x98765432,         0x0,                31, 1);
   TESTINST("ext", 0x98765432,         0xffffffffffffffff, 31, 1);
   TESTINST("ext", 0x98765432,         0x98765432,         31, 1);
   TESTINST("ext", 0x98765432,         0xffffffffff865421, 31, 1);
   TESTINST("ext", 0xffffffffff865421, 0x0,                31, 1);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffffffffff, 31, 1);
   TESTINST("ext", 0xffffffffff865421, 0x98765432,         31, 1);
   TESTINST("ext", 0xffffffffff865421, 0xffffffffff865421, 31, 1);

   printf("--- DEXT ---\n");
   /* The values of pos and size must satisfy all of the following relations:
      0 <= pos < 32
      0 < size <= 32
      0 < pos+size <= 63 */
   TESTINST("dext", 0x0,                0x0,                0, 1);
   TESTINST("dext", 0x0,                0xffffffffffffffff, 0, 1);
   TESTINST("dext", 0x0,                0x98765432,         0, 1);
   TESTINST("dext", 0x0,                0xffffffffff865421, 0, 1);
   TESTINST("dext", 0xffffffffffffffff, 0x0,                0, 1);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffffffffff, 0, 1);
   TESTINST("dext", 0xffffffffffffffff, 0x98765432,         0, 1);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffff865421, 0, 1);
   TESTINST("dext", 0x98765432,         0x0,                0, 1);
   TESTINST("dext", 0x98765432,         0xffffffffffffffff, 0, 1);
   TESTINST("dext", 0x98765432,         0x98765432,         0, 1);
   TESTINST("dext", 0x98765432,         0xffffffffff865421, 0, 1);
   TESTINST("dext", 0xffffffffff865421, 0x0,                0, 1);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffffffffff, 0, 1);
   TESTINST("dext", 0xffffffffff865421, 0x98765432,         0, 1);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffff865421, 0, 1);
   TESTINST("dext", 0x0,                0x0,                0, 4);
   TESTINST("dext", 0x0,                0xffffffffffffffff, 0, 4);
   TESTINST("dext", 0x0,                0x98765432,         0, 4);
   TESTINST("dext", 0x0,                0xffffffffff865421, 0, 4);
   TESTINST("dext", 0xffffffffffffffff, 0x0,                0, 4);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffffffffff, 0, 4);
   TESTINST("dext", 0xffffffffffffffff, 0x98765432,         0, 4);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffff865421, 0, 4);
   TESTINST("dext", 0x98765432,         0x0,                0, 4);
   TESTINST("dext", 0x98765432,         0xffffffffffffffff, 0, 4);
   TESTINST("dext", 0x98765432,         0x98765432,         0, 4);
   TESTINST("dext", 0x98765432,         0xffffffffff865421, 0, 4);
   TESTINST("dext", 0xffffffffff865421, 0x0,                0, 4);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffffffffff, 0, 4);
   TESTINST("dext", 0xffffffffff865421, 0x98765432,         0, 4);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffff865421, 0, 4);
   TESTINST("dext", 0x0,                0x0,                0, 16);
   TESTINST("dext", 0x0,                0xffffffffffffffff, 0, 16);
   TESTINST("dext", 0x0,                0x98765432,         0, 16);
   TESTINST("dext", 0x0,                0xffffffffff865421, 0, 16);
   TESTINST("dext", 0xffffffffffffffff, 0x0,                0, 16);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffffffffff, 0, 16);
   TESTINST("dext", 0xffffffffffffffff, 0x98765432,         0, 16);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffff865421, 0, 16);
   TESTINST("dext", 0x98765432,         0x0,                0, 16);
   TESTINST("dext", 0x98765432,         0xffffffffffffffff, 0, 16);
   TESTINST("dext", 0x98765432,         0x98765432,         0, 16);
   TESTINST("dext", 0x98765432,         0xffffffffff865421, 0, 16);
   TESTINST("dext", 0xffffffffff865421, 0x0,                0, 16);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffffffffff, 0, 16);
   TESTINST("dext", 0xffffffffff865421, 0x98765432,         0, 16);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffff865421, 0, 16);
   TESTINST("dext", 0x0,                0x0,                0, 32);
   TESTINST("dext", 0x0,                0xffffffffffffffff, 0, 32);
   TESTINST("dext", 0x0,                0x98765432,         0, 32);
   TESTINST("dext", 0x0,                0xffffffffff865421, 0, 32);
   TESTINST("dext", 0xffffffffffffffff, 0x0,                0, 32);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffffffffff, 0, 32);
   TESTINST("dext", 0xffffffffffffffff, 0x98765432,         0, 32);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffff865421, 0, 32);
   TESTINST("dext", 0x98765432,         0x0,                0, 32);
   TESTINST("dext", 0x98765432,         0xffffffffffffffff, 0, 32);
   TESTINST("dext", 0x98765432,         0x98765432,         0, 32);
   TESTINST("dext", 0x98765432,         0xffffffffff865421, 0, 32);
   TESTINST("dext", 0xffffffffff865421, 0x0,                0, 32);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffffffffff, 0, 32);
   TESTINST("dext", 0xffffffffff865421, 0x98765432,         0, 32);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffff865421, 0, 32);

   TESTINST("dext", 0x0,                0x0,                4, 1);
   TESTINST("dext", 0x0,                0xffffffffffffffff, 4, 1);
   TESTINST("dext", 0x0,                0x98765432,         4, 1);
   TESTINST("dext", 0x0,                0xffffffffff865421, 4, 1);
   TESTINST("dext", 0xffffffffffffffff, 0x0,                4, 1);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffffffffff, 4, 1);
   TESTINST("dext", 0xffffffffffffffff, 0x98765432,         4, 1);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffff865421, 4, 1);
   TESTINST("dext", 0x98765432,         0x0,                4, 1);
   TESTINST("dext", 0x98765432,         0xffffffffffffffff, 4, 1);
   TESTINST("dext", 0x98765432,         0x98765432,         4, 1);
   TESTINST("dext", 0x98765432,         0xffffffffff865421, 4, 1);
   TESTINST("dext", 0xffffffffff865421, 0x0,                4, 1);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffffffffff, 4, 1);
   TESTINST("dext", 0xffffffffff865421, 0x98765432,         4, 1);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffff865421, 4, 1);
   TESTINST("dext", 0x0,                0x0,                4, 4);
   TESTINST("dext", 0x0,                0xffffffffffffffff, 4, 4);
   TESTINST("dext", 0x0,                0x98765432,         4, 4);
   TESTINST("dext", 0x0,                0xffffffffff865421, 4, 4);
   TESTINST("dext", 0xffffffffffffffff, 0x0,                4, 4);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffffffffff, 4, 4);
   TESTINST("dext", 0xffffffffffffffff, 0x98765432,         4, 4);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffff865421, 4, 4);
   TESTINST("dext", 0x98765432,         0x0,                4, 4);
   TESTINST("dext", 0x98765432,         0xffffffffffffffff, 4, 4);
   TESTINST("dext", 0x98765432,         0x98765432,         4, 4);
   TESTINST("dext", 0x98765432,         0xffffffffff865421, 4, 4);
   TESTINST("dext", 0xffffffffff865421, 0x0,                4, 4);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffffffffff, 4, 4);
   TESTINST("dext", 0xffffffffff865421, 0x98765432,         4, 4);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffff865421, 4, 4);
   TESTINST("dext", 0x0,                0x0,                4, 16);
   TESTINST("dext", 0x0,                0xffffffffffffffff, 4, 16);
   TESTINST("dext", 0x0,                0x98765432,         4, 16);
   TESTINST("dext", 0x0,                0xffffffffff865421, 4, 16);
   TESTINST("dext", 0xffffffffffffffff, 0x0,                4, 16);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffffffffff, 4, 16);
   TESTINST("dext", 0xffffffffffffffff, 0x98765432,         4, 16);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffff865421, 4, 16);
   TESTINST("dext", 0x98765432,         0x0,                4, 16);
   TESTINST("dext", 0x98765432,         0xffffffffffffffff, 4, 16);
   TESTINST("dext", 0x98765432,         0x98765432,         4, 16);
   TESTINST("dext", 0x98765432,         0xffffffffff865421, 4, 16);
   TESTINST("dext", 0xffffffffff865421, 0x0,                4, 16);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffffffffff, 4, 16);
   TESTINST("dext", 0xffffffffff865421, 0x98765432,         4, 16);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffff865421, 4, 16);
   TESTINST("dext", 0x0,                0x0,                4, 32);
   TESTINST("dext", 0x0,                0xffffffffffffffff, 4, 32);
   TESTINST("dext", 0x0,                0x98765432,         4, 32);
   TESTINST("dext", 0x0,                0xffffffffff865421, 4, 32);
   TESTINST("dext", 0xffffffffffffffff, 0x0,                4, 32);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffffffffff, 4, 32);
   TESTINST("dext", 0xffffffffffffffff, 0x98765432,         4, 32);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffff865421, 4, 32);
   TESTINST("dext", 0x98765432,         0x0,                4, 32);
   TESTINST("dext", 0x98765432,         0xffffffffffffffff, 4, 32);
   TESTINST("dext", 0x98765432,         0x98765432,         4, 32);
   TESTINST("dext", 0x98765432,         0xffffffffff865421, 4, 32);
   TESTINST("dext", 0xffffffffff865421, 0x0,                4, 32);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffffffffff, 4, 32);
   TESTINST("dext", 0xffffffffff865421, 0x98765432,         4, 32);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffff865421, 4, 32);

   TESTINST("dext", 0x0,                0x0,                16, 1);
   TESTINST("dext", 0x0,                0xffffffffffffffff, 16, 1);
   TESTINST("dext", 0x0,                0x98765432,         16, 1);
   TESTINST("dext", 0x0,                0xffffffffff865421, 16, 1);
   TESTINST("dext", 0xffffffffffffffff, 0x0,                16, 1);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffffffffff, 16, 1);
   TESTINST("dext", 0xffffffffffffffff, 0x98765432,         16, 1);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffff865421, 16, 1);
   TESTINST("dext", 0x98765432,         0x0,                16, 1);
   TESTINST("dext", 0x98765432,         0xffffffffffffffff, 16, 1);
   TESTINST("dext", 0x98765432,         0x98765432,         16, 1);
   TESTINST("dext", 0x98765432,         0xffffffffff865421, 16, 1);
   TESTINST("dext", 0xffffffffff865421, 0x0,                16, 1);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffffffffff, 16, 1);
   TESTINST("dext", 0xffffffffff865421, 0x98765432,         16, 1);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffff865421, 16, 1);
   TESTINST("dext", 0x0,                0x0,                16, 4);
   TESTINST("dext", 0x0,                0xffffffffffffffff, 16, 4);
   TESTINST("dext", 0x0,                0x98765432,         16, 4);
   TESTINST("dext", 0x0,                0xffffffffff865421, 16, 4);
   TESTINST("dext", 0xffffffffffffffff, 0x0,                16, 4);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffffffffff, 16, 4);
   TESTINST("dext", 0xffffffffffffffff, 0x98765432,         16, 4);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffff865421, 16, 4);
   TESTINST("dext", 0x98765432,         0x0,                16, 4);
   TESTINST("dext", 0x98765432,         0xffffffffffffffff, 16, 4);
   TESTINST("dext", 0x98765432,         0x98765432,         16, 4);
   TESTINST("dext", 0x98765432,         0xffffffffff865421, 16, 4);
   TESTINST("dext", 0xffffffffff865421, 0x0,                16, 4);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffffffffff, 16, 4);
   TESTINST("dext", 0xffffffffff865421, 0x98765432,         16, 4);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffff865421, 16, 4);
   TESTINST("dext", 0x0,                0x0,                16, 16);
   TESTINST("dext", 0x0,                0xffffffffffffffff, 16, 16);
   TESTINST("dext", 0x0,                0x98765432,         16, 16);
   TESTINST("dext", 0x0,                0xffffffffff865421, 16, 16);
   TESTINST("dext", 0xffffffffffffffff, 0x0,                16, 16);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffffffffff, 16, 16);
   TESTINST("dext", 0xffffffffffffffff, 0x98765432,         16, 16);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffff865421, 16, 16);
   TESTINST("dext", 0x98765432,         0x0,                16, 16);
   TESTINST("dext", 0x98765432,         0xffffffffffffffff, 16, 16);
   TESTINST("dext", 0x98765432,         0x98765432,         16, 16);
   TESTINST("dext", 0x98765432,         0xffffffffff865421, 16, 16);
   TESTINST("dext", 0xffffffffff865421, 0x0,                16, 16);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffffffffff, 16, 16);
   TESTINST("dext", 0xffffffffff865421, 0x98765432,         16, 16);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffff865421, 16, 16);
   TESTINST("dext", 0x0,                0x0,                16, 32);
   TESTINST("dext", 0x0,                0xffffffffffffffff, 16, 32);
   TESTINST("dext", 0x0,                0x98765432,         16, 32);
   TESTINST("dext", 0x0,                0xffffffffff865421, 16, 32);
   TESTINST("dext", 0xffffffffffffffff, 0x0,                16, 32);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffffffffff, 16, 32);
   TESTINST("dext", 0xffffffffffffffff, 0x98765432,         16, 32);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffff865421, 16, 32);
   TESTINST("dext", 0x98765432,         0x0,                16, 32);
   TESTINST("dext", 0x98765432,         0xffffffffffffffff, 16, 32);
   TESTINST("dext", 0x98765432,         0x98765432,         16, 32);
   TESTINST("dext", 0x98765432,         0xffffffffff865421, 16, 32);
   TESTINST("dext", 0xffffffffff865421, 0x0,                16, 32);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffffffffff, 16, 32);
   TESTINST("dext", 0xffffffffff865421, 0x98765432,         16, 32);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffff865421, 16, 32);

   TESTINST("dext", 0x0,                0x0,                31, 1);
   TESTINST("dext", 0x0,                0xffffffffffffffff, 31, 1);
   TESTINST("dext", 0x0,                0x98765432,         31, 1);
   TESTINST("dext", 0x0,                0xffffffffff865421, 31, 1);
   TESTINST("dext", 0xffffffffffffffff, 0x0,                31, 1);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffffffffff, 31, 1);
   TESTINST("dext", 0xffffffffffffffff, 0x98765432,         31, 1);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffff865421, 31, 1);
   TESTINST("dext", 0x98765432,         0x0,                31, 1);
   TESTINST("dext", 0x98765432,         0xffffffffffffffff, 31, 1);
   TESTINST("dext", 0x98765432,         0x98765432,         31, 1);
   TESTINST("dext", 0x98765432,         0xffffffffff865421, 31, 1);
   TESTINST("dext", 0xffffffffff865421, 0x0,                31, 1);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffffffffff, 31, 1);
   TESTINST("dext", 0xffffffffff865421, 0x98765432,         31, 1);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffff865421, 31, 1);
   TESTINST("dext", 0x0,                0x0,                31, 4);
   TESTINST("dext", 0x0,                0xffffffffffffffff, 31, 4);
   TESTINST("dext", 0x0,                0x98765432,         31, 4);
   TESTINST("dext", 0x0,                0xffffffffff865421, 31, 4);
   TESTINST("dext", 0xffffffffffffffff, 0x0,                31, 4);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffffffffff, 31, 4);
   TESTINST("dext", 0xffffffffffffffff, 0x98765432,         31, 4);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffff865421, 31, 4);
   TESTINST("dext", 0x98765432,         0x0,                31, 4);
   TESTINST("dext", 0x98765432,         0xffffffffffffffff, 31, 4);
   TESTINST("dext", 0x98765432,         0x98765432,         31, 4);
   TESTINST("dext", 0x98765432,         0xffffffffff865421, 31, 4);
   TESTINST("dext", 0xffffffffff865421, 0x0,                31, 4);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffffffffff, 31, 4);
   TESTINST("dext", 0xffffffffff865421, 0x98765432,         31, 4);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffff865421, 31, 4);
   TESTINST("dext", 0x0,                0x0,                31, 16);
   TESTINST("dext", 0x0,                0xffffffffffffffff, 31, 16);
   TESTINST("dext", 0x0,                0x98765432,         31, 16);
   TESTINST("dext", 0x0,                0xffffffffff865421, 31, 16);
   TESTINST("dext", 0xffffffffffffffff, 0x0,                31, 16);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffffffffff, 31, 16);
   TESTINST("dext", 0xffffffffffffffff, 0x98765432,         31, 16);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffff865421, 31, 16);
   TESTINST("dext", 0x98765432,         0x0,                31, 16);
   TESTINST("dext", 0x98765432,         0xffffffffffffffff, 31, 16);
   TESTINST("dext", 0x98765432,         0x98765432,         31, 16);
   TESTINST("dext", 0x98765432,         0xffffffffff865421, 31, 16);
   TESTINST("dext", 0xffffffffff865421, 0x0,                31, 16);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffffffffff, 31, 16);
   TESTINST("dext", 0xffffffffff865421, 0x98765432,         31, 16);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffff865421, 31, 16);
   TESTINST("dext", 0x0,                0x0,                31, 32);
   TESTINST("dext", 0x0,                0xffffffffffffffff, 31, 32);
   TESTINST("dext", 0x0,                0x98765432,         31, 32);
   TESTINST("dext", 0x0,                0xffffffffff865421, 31, 32);
   TESTINST("dext", 0xffffffffffffffff, 0x0,                31, 32);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffffffffff, 31, 32);
   TESTINST("dext", 0xffffffffffffffff, 0x98765432,         31, 32);
   TESTINST("dext", 0xffffffffffffffff, 0xffffffffff865421, 31, 32);
   TESTINST("dext", 0x98765432,         0x0,                31, 32);
   TESTINST("dext", 0x98765432,         0xffffffffffffffff, 31, 32);
   TESTINST("dext", 0x98765432,         0x98765432,         31, 32);
   TESTINST("dext", 0x98765432,         0xffffffffff865421, 31, 32);
   TESTINST("dext", 0xffffffffff865421, 0x0,                31, 32);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffffffffff, 31, 32);
   TESTINST("dext", 0xffffffffff865421, 0x98765432,         31, 32);
   TESTINST("dext", 0xffffffffff865421, 0xffffffffff865421, 31, 32);

   TESTINST("dext", 0x2002ffffffffffff, 0xfffffffff0000fff, 4,  4);
   TESTINST("dext", 0xffff0000ffffffff, 0xff0000ffffffffff, 8,  4);
   TESTINST("dext", 0x2000ffffffffffff, 0xffff0000ffffffff, 16, 4);
   TESTINST("dext", 0x2000ffffffddddff, 0xffffffffffff0008, 24, 2);
   TESTINST("dext", 0x2000ffffffffeeee, 0xfffffff31415927f, 24, 4);
   TESTINST("dext", 0x31415927ffffffff, 0x2000ffffffffffff, 9,  2);
   TESTINST("dext", 0x2000ffffffffaaaa, 0x2000ffffffff2222, 16, 4);
   TESTINST("dext", 0x2000ffffffbbbbff, 0x7fffffffddddffff, 16, 4);
   TESTINST("dext", 0xeeeeff33ff22ffff, 0x2000ffffffffffff, 7,  4);
   TESTINST("dext", 0x2000ffffffffffff, 0x2000ffffffffbbbb, 5,  4);
   TESTINST("dext", 0x2000ffffffffbbbb, 0xfffffffff0000fff, 3,  4);
   TESTINST("dext", 0x2000ffffffffffff, 0xffff0000ffffffff, 16, 16);
   TESTINST("dext", 0x7fffffffddddffff, 0xffffffffffff0008, 16, 32);
   TESTINST("dext", 0x2000ffffffff2222, 0xfffffff31415927f, 2,  60);
   TESTINST("dext", 0x2000ffffffffffff, 0x2000ffffffffffff, 16, 6);
   TESTINST("dext", 0xfffffff31415927f, 0x2000ffffffff2222, 31, 32);
   TESTINST("dext", 0xffffffffffff0008, 0x7fffffffddddffff, 8,  2);
   TESTINST("dext", 0xffff0000ffffffff, 0x2000ffffffffffff, 16, 4);
   TESTINST("dext", 0xff0000ffffffffff, 0,                  8,  4);
   TESTINST("dext", 0xfffffffff0000fff, 0,                  16, 4);

   printf("--- DEXTM ---\n");
   /* The values of pos and size must satisfy all of the following relations:
      0 <= pos < 32
      32 < size <= 64
      32 < pos+size <= 64 */
   TESTINST("dextm", 0x0,                0x0,                0, 33);
   TESTINST("dextm", 0x0,                0xffffffffffffffff, 0, 33);
   TESTINST("dextm", 0x0,                0x98765432,         0, 33);
   TESTINST("dextm", 0x0,                0xffffffffff865421, 0, 33);
   TESTINST("dextm", 0xffffffffffffffff, 0x0,                0, 33);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffffffffff, 0, 33);
   TESTINST("dextm", 0xffffffffffffffff, 0x98765432,         0, 33);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffff865421, 0, 33);
   TESTINST("dextm", 0x98765432,         0x0,                0, 33);
   TESTINST("dextm", 0x98765432,         0xffffffffffffffff, 0, 33);
   TESTINST("dextm", 0x98765432,         0x98765432,         0, 33);
   TESTINST("dextm", 0x98765432,         0xffffffffff865421, 0, 33);
   TESTINST("dextm", 0xffffffffff865421, 0x0,                0, 33);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffffffffff, 0, 33);
   TESTINST("dextm", 0xffffffffff865421, 0x98765432,         0, 33);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffff865421, 0, 33);
   TESTINST("dextm", 0x0,                0x0,                0, 37);
   TESTINST("dextm", 0x0,                0xffffffffffffffff, 0, 37);
   TESTINST("dextm", 0x0,                0x98765432,         0, 37);
   TESTINST("dextm", 0x0,                0xffffffffff865421, 0, 37);
   TESTINST("dextm", 0xffffffffffffffff, 0x0,                0, 37);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffffffffff, 0, 37);
   TESTINST("dextm", 0xffffffffffffffff, 0x98765432,         0, 37);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffff865421, 0, 37);
   TESTINST("dextm", 0x98765432,         0x0,                0, 37);
   TESTINST("dextm", 0x98765432,         0xffffffffffffffff, 0, 37);
   TESTINST("dextm", 0x98765432,         0x98765432,         0, 37);
   TESTINST("dextm", 0x98765432,         0xffffffffff865421, 0, 37);
   TESTINST("dextm", 0xffffffffff865421, 0x0,                0, 37);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffffffffff, 0, 37);
   TESTINST("dextm", 0xffffffffff865421, 0x98765432,         0, 37);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffff865421, 0, 37);
   TESTINST("dextm", 0x0,                0x0,                0, 48);
   TESTINST("dextm", 0x0,                0xffffffffffffffff, 0, 48);
   TESTINST("dextm", 0x0,                0x98765432,         0, 48);
   TESTINST("dextm", 0x0,                0xffffffffff865421, 0, 48);
   TESTINST("dextm", 0xffffffffffffffff, 0x0,                0, 48);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffffffffff, 0, 48);
   TESTINST("dextm", 0xffffffffffffffff, 0x98765432,         0, 48);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffff865421, 0, 48);
   TESTINST("dextm", 0x98765432,         0x0,                0, 48);
   TESTINST("dextm", 0x98765432,         0xffffffffffffffff, 0, 48);
   TESTINST("dextm", 0x98765432,         0x98765432,         0, 48);
   TESTINST("dextm", 0x98765432,         0xffffffffff865421, 0, 48);
   TESTINST("dextm", 0xffffffffff865421, 0x0,                0, 48);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffffffffff, 0, 48);
   TESTINST("dextm", 0xffffffffff865421, 0x98765432,         0, 48);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffff865421, 0, 48);
   TESTINST("dextm", 0x0,                0x0,                0, 64);
   TESTINST("dextm", 0x0,                0xffffffffffffffff, 0, 64);
   TESTINST("dextm", 0x0,                0x98765432,         0, 64);
   TESTINST("dextm", 0x0,                0xffffffffff865421, 0, 64);
   TESTINST("dextm", 0xffffffffffffffff, 0x0,                0, 64);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffffffffff, 0, 64);
   TESTINST("dextm", 0xffffffffffffffff, 0x98765432,         0, 64);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffff865421, 0, 64);
   TESTINST("dextm", 0x98765432,         0x0,                0, 64);
   TESTINST("dextm", 0x98765432,         0xffffffffffffffff, 0, 64);
   TESTINST("dextm", 0x98765432,         0x98765432,         0, 64);
   TESTINST("dextm", 0x98765432,         0xffffffffff865421, 0, 64);
   TESTINST("dextm", 0xffffffffff865421, 0x0,                0, 64);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffffffffff, 0, 64);
   TESTINST("dextm", 0xffffffffff865421, 0x98765432,         0, 64);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffff865421, 0, 64);

   TESTINST("dextm", 0x0,                0x0,                4, 33);
   TESTINST("dextm", 0x0,                0xffffffffffffffff, 4, 33);
   TESTINST("dextm", 0x0,                0x98765432,         4, 33);
   TESTINST("dextm", 0x0,                0xffffffffff865421, 4, 33);
   TESTINST("dextm", 0xffffffffffffffff, 0x0,                4, 33);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffffffffff, 4, 33);
   TESTINST("dextm", 0xffffffffffffffff, 0x98765432,         4, 33);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffff865421, 4, 33);
   TESTINST("dextm", 0x98765432,         0x0,                4, 33);
   TESTINST("dextm", 0x98765432,         0xffffffffffffffff, 4, 33);
   TESTINST("dextm", 0x98765432,         0x98765432,         4, 33);
   TESTINST("dextm", 0x98765432,         0xffffffffff865421, 4, 33);
   TESTINST("dextm", 0xffffffffff865421, 0x0,                4, 33);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffffffffff, 4, 33);
   TESTINST("dextm", 0xffffffffff865421, 0x98765432,         4, 33);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffff865421, 4, 33);
   TESTINST("dextm", 0x0,                0x0,                4, 37);
   TESTINST("dextm", 0x0,                0xffffffffffffffff, 4, 37);
   TESTINST("dextm", 0x0,                0x98765432,         4, 37);
   TESTINST("dextm", 0x0,                0xffffffffff865421, 4, 37);
   TESTINST("dextm", 0xffffffffffffffff, 0x0,                4, 37);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffffffffff, 4, 37);
   TESTINST("dextm", 0xffffffffffffffff, 0x98765432,         4, 37);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffff865421, 4, 37);
   TESTINST("dextm", 0x98765432,         0x0,                4, 37);
   TESTINST("dextm", 0x98765432,         0xffffffffffffffff, 4, 37);
   TESTINST("dextm", 0x98765432,         0x98765432,         4, 37);
   TESTINST("dextm", 0x98765432,         0xffffffffff865421, 4, 37);
   TESTINST("dextm", 0xffffffffff865421, 0x0,                4, 37);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffffffffff, 4, 37);
   TESTINST("dextm", 0xffffffffff865421, 0x98765432,         4, 37);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffff865421, 4, 37);
   TESTINST("dextm", 0x0,                0x0,                4, 48);
   TESTINST("dextm", 0x0,                0xffffffffffffffff, 4, 48);
   TESTINST("dextm", 0x0,                0x98765432,         4, 48);
   TESTINST("dextm", 0x0,                0xffffffffff865421, 4, 48);
   TESTINST("dextm", 0xffffffffffffffff, 0x0,                4, 48);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffffffffff, 4, 48);
   TESTINST("dextm", 0xffffffffffffffff, 0x98765432,         4, 48);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffff865421, 4, 48);
   TESTINST("dextm", 0x98765432,         0x0,                4, 48);
   TESTINST("dextm", 0x98765432,         0xffffffffffffffff, 4, 48);
   TESTINST("dextm", 0x98765432,         0x98765432,         4, 48);
   TESTINST("dextm", 0x98765432,         0xffffffffff865421, 4, 48);
   TESTINST("dextm", 0xffffffffff865421, 0x0,                4, 48);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffffffffff, 4, 48);
   TESTINST("dextm", 0xffffffffff865421, 0x98765432,         4, 48);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffff865421, 4, 48);
   TESTINST("dextm", 0x0,                0x0,                4, 60);
   TESTINST("dextm", 0x0,                0xffffffffffffffff, 4, 60);
   TESTINST("dextm", 0x0,                0x98765432,         4, 60);
   TESTINST("dextm", 0x0,                0xffffffffff865421, 4, 60);
   TESTINST("dextm", 0xffffffffffffffff, 0x0,                4, 60);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffffffffff, 4, 60);
   TESTINST("dextm", 0xffffffffffffffff, 0x98765432,         4, 60);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffff865421, 4, 60);
   TESTINST("dextm", 0x98765432,         0x0,                4, 60);
   TESTINST("dextm", 0x98765432,         0xffffffffffffffff, 4, 60);
   TESTINST("dextm", 0x98765432,         0x98765432,         4, 60);
   TESTINST("dextm", 0x98765432,         0xffffffffff865421, 4, 60);
   TESTINST("dextm", 0xffffffffff865421, 0x0,                4, 60);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffffffffff, 4, 60);
   TESTINST("dextm", 0xffffffffff865421, 0x98765432,         4, 60);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffff865421, 4, 60);

   TESTINST("dextm", 0x0,                0x0,                16, 33);
   TESTINST("dextm", 0x0,                0xffffffffffffffff, 16, 33);
   TESTINST("dextm", 0x0,                0x98765432,         16, 33);
   TESTINST("dextm", 0x0,                0xffffffffff865421, 16, 33);
   TESTINST("dextm", 0xffffffffffffffff, 0x0,                16, 33);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffffffffff, 16, 33);
   TESTINST("dextm", 0xffffffffffffffff, 0x98765432,         16, 33);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffff865421, 16, 33);
   TESTINST("dextm", 0x98765432,         0x0,                16, 33);
   TESTINST("dextm", 0x98765432,         0xffffffffffffffff, 16, 33);
   TESTINST("dextm", 0x98765432,         0x98765432,         16, 33);
   TESTINST("dextm", 0x98765432,         0xffffffffff865421, 16, 33);
   TESTINST("dextm", 0xffffffffff865421, 0x0,                16, 33);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffffffffff, 16, 33);
   TESTINST("dextm", 0xffffffffff865421, 0x98765432,         16, 33);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffff865421, 16, 33);
   TESTINST("dextm", 0x0,                0x0,                16, 37);
   TESTINST("dextm", 0x0,                0xffffffffffffffff, 16, 37);
   TESTINST("dextm", 0x0,                0x98765432,         16, 37);
   TESTINST("dextm", 0x0,                0xffffffffff865421, 16, 37);
   TESTINST("dextm", 0xffffffffffffffff, 0x0,                16, 37);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffffffffff, 16, 37);
   TESTINST("dextm", 0xffffffffffffffff, 0x98765432,         16, 37);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffff865421, 16, 37);
   TESTINST("dextm", 0x98765432,         0x0,                16, 37);
   TESTINST("dextm", 0x98765432,         0xffffffffffffffff, 16, 37);
   TESTINST("dextm", 0x98765432,         0x98765432,         16, 37);
   TESTINST("dextm", 0x98765432,         0xffffffffff865421, 16, 37);
   TESTINST("dextm", 0xffffffffff865421, 0x0,                16, 37);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffffffffff, 16, 37);
   TESTINST("dextm", 0xffffffffff865421, 0x98765432,         16, 37);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffff865421, 16, 37);
   TESTINST("dextm", 0x0,                0x0,                16, 48);
   TESTINST("dextm", 0x0,                0xffffffffffffffff, 16, 48);
   TESTINST("dextm", 0x0,                0x98765432,         16, 48);
   TESTINST("dextm", 0x0,                0xffffffffff865421, 16, 48);
   TESTINST("dextm", 0xffffffffffffffff, 0x0,                16, 48);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffffffffff, 16, 48);
   TESTINST("dextm", 0xffffffffffffffff, 0x98765432,         16, 48);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffff865421, 16, 48);
   TESTINST("dextm", 0x98765432,         0x0,                16, 48);
   TESTINST("dextm", 0x98765432,         0xffffffffffffffff, 16, 48);
   TESTINST("dextm", 0x98765432,         0x98765432,         16, 48);
   TESTINST("dextm", 0x98765432,         0xffffffffff865421, 16, 48);
   TESTINST("dextm", 0xffffffffff865421, 0x0,                16, 48);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffffffffff, 16, 48);
   TESTINST("dextm", 0xffffffffff865421, 0x98765432,         16, 48);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffff865421, 16, 48);

   TESTINST("dextm", 0x0,                0x0,                31, 33);
   TESTINST("dextm", 0x0,                0xffffffffffffffff, 31, 33);
   TESTINST("dextm", 0x0,                0x98765432,         31, 33);
   TESTINST("dextm", 0x0,                0xffffffffff865421, 31, 33);
   TESTINST("dextm", 0xffffffffffffffff, 0x0,                31, 33);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffffffffff, 31, 33);
   TESTINST("dextm", 0xffffffffffffffff, 0x98765432,         31, 33);
   TESTINST("dextm", 0xffffffffffffffff, 0xffffffffff865421, 31, 33);
   TESTINST("dextm", 0x98765432,         0x0,                31, 33);
   TESTINST("dextm", 0x98765432,         0xffffffffffffffff, 31, 33);
   TESTINST("dextm", 0x98765432,         0x98765432,         31, 33);
   TESTINST("dextm", 0x98765432,         0xffffffffff865421, 31, 33);
   TESTINST("dextm", 0xffffffffff865421, 0x0,                31, 33);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffffffffff, 31, 33);
   TESTINST("dextm", 0xffffffffff865421, 0x98765432,         31, 33);
   TESTINST("dextm", 0xffffffffff865421, 0xffffffffff865421, 31, 33);

   TESTINST("dextm", 0x2002ffffffffffff, 0xfffffffff0000fff, 4,  35);
   TESTINST("dextm", 0xffff0000ffffffff, 0xff0000ffffffffff, 8,  33);
   TESTINST("dextm", 0x2000ffffffffffff, 0xffff0000ffffffff, 16, 34);
   TESTINST("dextm", 0x2000ffffffddddff, 0xffffffffffff0008, 4,  46);
   TESTINST("dextm", 0x2000ffffffffeeee, 0xfffffff31415927f, 3,  56);
   TESTINST("dextm", 0x31415927ffffffff, 0x2000ffffffffffff, 0,  64);
   TESTINST("dextm", 0x2000ffffffffaaaa, 0x2000ffffffff2222, 16, 40);
   TESTINST("dextm", 0x2000ffffffbbbbff, 0x7fffffffddddffff, 16, 42);
   TESTINST("dextm", 0xeeeeff33ff22ffff, 0x2000ffffffffffff, 7,  43);
   TESTINST("dextm", 0x2000ffffffffffff, 0x2000ffffffffbbbb, 5,  48);
   TESTINST("dextm", 0x2000ffffffffbbbb, 0x2000ffffffffffff, 3,  52);
   TESTINST("dextm", 0x2000ffffffffffff, 0xeeeeff33ff22ffff, 1,  54);
   TESTINST("dextm", 0x7fffffffddddffff, 0x2000ffffffbbbbff, 2,  54);
   TESTINST("dextm", 0x2000ffffffff2222, 0x2000ffffffffaaaa, 2,  48);
   TESTINST("dextm", 0x2000ffffffffffff, 0x31415927ffffffff, 5,  53);
   TESTINST("dextm", 0xfffffff31415927f, 0x2000ffffffffeeee, 2,  60);
   TESTINST("dextm", 0xffffffffffff0008, 0x2000ffffffddddff, 3,  61);
   TESTINST("dextm", 0xffff0000ffffffff, 0x2000ffffffffffff, 1,  62);
   TESTINST("dextm", 0xff0000ffffffffff, 0,                  8,  38);
   TESTINST("dextm", 0xfffffffff0000fff, 0,                  16, 39);

   printf("--- DEXTU ---\n");
   /* The values of pos and size must satisfy all of the following relations:
      32 <= pos < 64
      0 < size <= 32
      32 < pos+size <= 64 */
   TESTINST("dextu", 0x0,                0x0,                32, 1);
   TESTINST("dextu", 0x0,                0xffffffffffffffff, 32, 1);
   TESTINST("dextu", 0x0,                0x98765432,         32, 1);
   TESTINST("dextu", 0x0,                0xffffffffff865421, 32, 1);
   TESTINST("dextu", 0xffffffffffffffff, 0x0,                32, 1);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffffffffff, 32, 1);
   TESTINST("dextu", 0xffffffffffffffff, 0x98765432,         32, 1);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffff865421, 32, 1);
   TESTINST("dextu", 0x98765432,         0x0,                32, 1);
   TESTINST("dextu", 0x98765432,         0xffffffffffffffff, 32, 1);
   TESTINST("dextu", 0x98765432,         0x98765432,         32, 1);
   TESTINST("dextu", 0x98765432,         0xffffffffff865421, 32, 1);
   TESTINST("dextu", 0xffffffffff865421, 0x0,                32, 1);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffffffffff, 32, 1);
   TESTINST("dextu", 0xffffffffff865421, 0x98765432,         32, 1);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffff865421, 32, 1);
   TESTINST("dextu", 0x0,                0x0,                32, 4);
   TESTINST("dextu", 0x0,                0xffffffffffffffff, 32, 4);
   TESTINST("dextu", 0x0,                0x98765432,         32, 4);
   TESTINST("dextu", 0x0,                0xffffffffff865421, 32, 4);
   TESTINST("dextu", 0xffffffffffffffff, 0x0,                32, 4);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffffffffff, 32, 4);
   TESTINST("dextu", 0xffffffffffffffff, 0x98765432,         32, 4);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffff865421, 32, 4);
   TESTINST("dextu", 0x98765432,         0x0,                32, 4);
   TESTINST("dextu", 0x98765432,         0xffffffffffffffff, 32, 4);
   TESTINST("dextu", 0x98765432,         0x98765432,         32, 4);
   TESTINST("dextu", 0x98765432,         0xffffffffff865421, 32, 4);
   TESTINST("dextu", 0xffffffffff865421, 0x0,                32, 4);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffffffffff, 32, 4);
   TESTINST("dextu", 0xffffffffff865421, 0x98765432,         32, 4);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffff865421, 32, 4);
   TESTINST("dextu", 0x0,                0x0,                32, 16);
   TESTINST("dextu", 0x0,                0xffffffffffffffff, 32, 16);
   TESTINST("dextu", 0x0,                0x98765432,         32, 16);
   TESTINST("dextu", 0x0,                0xffffffffff865421, 32, 16);
   TESTINST("dextu", 0xffffffffffffffff, 0x0,                32, 16);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffffffffff, 32, 16);
   TESTINST("dextu", 0xffffffffffffffff, 0x98765432,         32, 16);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffff865421, 32, 16);
   TESTINST("dextu", 0x98765432,         0x0,                32, 16);
   TESTINST("dextu", 0x98765432,         0xffffffffffffffff, 32, 16);
   TESTINST("dextu", 0x98765432,         0x98765432,         32, 16);
   TESTINST("dextu", 0x98765432,         0xffffffffff865421, 32, 16);
   TESTINST("dextu", 0xffffffffff865421, 0x0,                32, 16);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffffffffff, 32, 16);
   TESTINST("dextu", 0xffffffffff865421, 0x98765432,         32, 16);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffff865421, 32, 16);
   TESTINST("dextu", 0x0,                0x0,                32, 32);
   TESTINST("dextu", 0x0,                0xffffffffffffffff, 32, 32);
   TESTINST("dextu", 0x0,                0x98765432,         32, 32);
   TESTINST("dextu", 0x0,                0xffffffffff865421, 32, 32);
   TESTINST("dextu", 0xffffffffffffffff, 0x0,                32, 32);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffffffffff, 32, 32);
   TESTINST("dextu", 0xffffffffffffffff, 0x98765432,         32, 32);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffff865421, 32, 32);
   TESTINST("dextu", 0x98765432,         0x0,                32, 32);
   TESTINST("dextu", 0x98765432,         0xffffffffffffffff, 32, 32);
   TESTINST("dextu", 0x98765432,         0x98765432,         32, 32);
   TESTINST("dextu", 0x98765432,         0xffffffffff865421, 32, 32);
   TESTINST("dextu", 0xffffffffff865421, 0x0,                32, 32);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffffffffff, 32, 32);
   TESTINST("dextu", 0xffffffffff865421, 0x98765432,         32, 32);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffff865421, 32, 32);

   TESTINST("dextu", 0x0,                0x0,                36, 1);
   TESTINST("dextu", 0x0,                0xffffffffffffffff, 36, 1);
   TESTINST("dextu", 0x0,                0x98765432,         36, 1);
   TESTINST("dextu", 0x0,                0xffffffffff865421, 36, 1);
   TESTINST("dextu", 0xffffffffffffffff, 0x0,                36, 1);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffffffffff, 36, 1);
   TESTINST("dextu", 0xffffffffffffffff, 0x98765432,         36, 1);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffff865421, 36, 1);
   TESTINST("dextu", 0x98765432,         0x0,                36, 1);
   TESTINST("dextu", 0x98765432,         0xffffffffffffffff, 36, 1);
   TESTINST("dextu", 0x98765432,         0x98765432,         36, 1);
   TESTINST("dextu", 0x98765432,         0xffffffffff865421, 36, 1);
   TESTINST("dextu", 0xffffffffff865421, 0x0,                36, 1);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffffffffff, 36, 1);
   TESTINST("dextu", 0xffffffffff865421, 0x98765432,         36, 1);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffff865421, 36, 1);
   TESTINST("dextu", 0x0,                0x0,                36, 4);
   TESTINST("dextu", 0x0,                0xffffffffffffffff, 36, 4);
   TESTINST("dextu", 0x0,                0x98765432,         36, 4);
   TESTINST("dextu", 0x0,                0xffffffffff865421, 36, 4);
   TESTINST("dextu", 0xffffffffffffffff, 0x0,                36, 4);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffffffffff, 36, 4);
   TESTINST("dextu", 0xffffffffffffffff, 0x98765432,         36, 4);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffff865421, 36, 4);
   TESTINST("dextu", 0x98765432,         0x0,                36, 4);
   TESTINST("dextu", 0x98765432,         0xffffffffffffffff, 36, 4);
   TESTINST("dextu", 0x98765432,         0x98765432,         36, 4);
   TESTINST("dextu", 0x98765432,         0xffffffffff865421, 36, 4);
   TESTINST("dextu", 0xffffffffff865421, 0x0,                36, 4);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffffffffff, 36, 4);
   TESTINST("dextu", 0xffffffffff865421, 0x98765432,         36, 4);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffff865421, 36, 4);
   TESTINST("dextu", 0x0,                0x0,                36, 16);
   TESTINST("dextu", 0x0,                0xffffffffffffffff, 36, 16);
   TESTINST("dextu", 0x0,                0x98765432,         36, 16);
   TESTINST("dextu", 0x0,                0xffffffffff865421, 36, 16);
   TESTINST("dextu", 0xffffffffffffffff, 0x0,                36, 16);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffffffffff, 36, 16);
   TESTINST("dextu", 0xffffffffffffffff, 0x98765432,         36, 16);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffff865421, 36, 16);
   TESTINST("dextu", 0x98765432,         0x0,                36, 16);
   TESTINST("dextu", 0x98765432,         0xffffffffffffffff, 36, 16);
   TESTINST("dextu", 0x98765432,         0x98765432,         36, 16);
   TESTINST("dextu", 0x98765432,         0xffffffffff865421, 36, 16);
   TESTINST("dextu", 0xffffffffff865421, 0x0,                36, 16);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffffffffff, 36, 16);
   TESTINST("dextu", 0xffffffffff865421, 0x98765432,         36, 16);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffff865421, 36, 16);
   TESTINST("dextu", 0x0,                0x0,                36, 28);
   TESTINST("dextu", 0x0,                0xffffffffffffffff, 36, 28);
   TESTINST("dextu", 0x0,                0x98765432,         36, 28);
   TESTINST("dextu", 0x0,                0xffffffffff865421, 36, 28);
   TESTINST("dextu", 0xffffffffffffffff, 0x0,                36, 28);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffffffffff, 36, 28);
   TESTINST("dextu", 0xffffffffffffffff, 0x98765432,         36, 28);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffff865421, 36, 28);
   TESTINST("dextu", 0x98765432,         0x0,                36, 28);
   TESTINST("dextu", 0x98765432,         0xffffffffffffffff, 36, 28);
   TESTINST("dextu", 0x98765432,         0x98765432,         36, 28);
   TESTINST("dextu", 0x98765432,         0xffffffffff865421, 36, 28);
   TESTINST("dextu", 0xffffffffff865421, 0x0,                36, 28);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffffffffff, 36, 28);
   TESTINST("dextu", 0xffffffffff865421, 0x98765432,         36, 28);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffff865421, 36, 28);

   TESTINST("dextu", 0x0,                0x0,                48, 1);
   TESTINST("dextu", 0x0,                0xffffffffffffffff, 48, 1);
   TESTINST("dextu", 0x0,                0x98765432,         48, 1);
   TESTINST("dextu", 0x0,                0xffffffffff865421, 48, 1);
   TESTINST("dextu", 0xffffffffffffffff, 0x0,                48, 1);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffffffffff, 48, 1);
   TESTINST("dextu", 0xffffffffffffffff, 0x98765432,         48, 1);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffff865421, 48, 1);
   TESTINST("dextu", 0x98765432,         0x0,                48, 1);
   TESTINST("dextu", 0x98765432,         0xffffffffffffffff, 48, 1);
   TESTINST("dextu", 0x98765432,         0x98765432,         48, 1);
   TESTINST("dextu", 0x98765432,         0xffffffffff865421, 48, 1);
   TESTINST("dextu", 0xffffffffff865421, 0x0,                48, 1);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffffffffff, 48, 1);
   TESTINST("dextu", 0xffffffffff865421, 0x98765432,         48, 1);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffff865421, 48, 1);
   TESTINST("dextu", 0x0,                0x0,                48, 4);
   TESTINST("dextu", 0x0,                0xffffffffffffffff, 48, 4);
   TESTINST("dextu", 0x0,                0x98765432,         48, 4);
   TESTINST("dextu", 0x0,                0xffffffffff865421, 48, 4);
   TESTINST("dextu", 0xffffffffffffffff, 0x0,                48, 4);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffffffffff, 48, 4);
   TESTINST("dextu", 0xffffffffffffffff, 0x98765432,         48, 4);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffff865421, 48, 4);
   TESTINST("dextu", 0x98765432,         0x0,                48, 4);
   TESTINST("dextu", 0x98765432,         0xffffffffffffffff, 48, 4);
   TESTINST("dextu", 0x98765432,         0x98765432,         48, 4);
   TESTINST("dextu", 0x98765432,         0xffffffffff865421, 48, 4);
   TESTINST("dextu", 0xffffffffff865421, 0x0,                48, 4);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffffffffff, 48, 4);
   TESTINST("dextu", 0xffffffffff865421, 0x98765432,         48, 4);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffff865421, 48, 4);
   TESTINST("dextu", 0x0,                0x0,                48, 16);
   TESTINST("dextu", 0x0,                0xffffffffffffffff, 48, 16);
   TESTINST("dextu", 0x0,                0x98765432,         48, 16);
   TESTINST("dextu", 0x0,                0xffffffffff865421, 48, 16);
   TESTINST("dextu", 0xffffffffffffffff, 0x0,                48, 16);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffffffffff, 48, 16);
   TESTINST("dextu", 0xffffffffffffffff, 0x98765432,         48, 16);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffff865421, 48, 16);
   TESTINST("dextu", 0x98765432,         0x0,                48, 16);
   TESTINST("dextu", 0x98765432,         0xffffffffffffffff, 48, 16);
   TESTINST("dextu", 0x98765432,         0x98765432,         48, 16);
   TESTINST("dextu", 0x98765432,         0xffffffffff865421, 48, 16);
   TESTINST("dextu", 0xffffffffff865421, 0x0,                48, 16);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffffffffff, 48, 16);
   TESTINST("dextu", 0xffffffffff865421, 0x98765432,         48, 16);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffff865421, 48, 16);

   TESTINST("dextu", 0x0,                0x0,                63, 1);
   TESTINST("dextu", 0x0,                0xffffffffffffffff, 63, 1);
   TESTINST("dextu", 0x0,                0x98765432,         63, 1);
   TESTINST("dextu", 0x0,                0xffffffffff865421, 63, 1);
   TESTINST("dextu", 0xffffffffffffffff, 0x0,                63, 1);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffffffffff, 63, 1);
   TESTINST("dextu", 0xffffffffffffffff, 0x98765432,         63, 1);
   TESTINST("dextu", 0xffffffffffffffff, 0xffffffffff865421, 63, 1);
   TESTINST("dextu", 0x98765432,         0x0,                63, 1);
   TESTINST("dextu", 0x98765432,         0xffffffffffffffff, 63, 1);
   TESTINST("dextu", 0x98765432,         0x98765432,         63, 1);
   TESTINST("dextu", 0x98765432,         0xffffffffff865421, 63, 1);
   TESTINST("dextu", 0xffffffffff865421, 0x0,                63, 1);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffffffffff, 63, 1);
   TESTINST("dextu", 0xffffffffff865421, 0x98765432,         63, 1);
   TESTINST("dextu", 0xffffffffff865421, 0xffffffffff865421, 63, 1);

   TESTINST("dextu", 0x2002ffffffffffff, 0xfffffffff0000fff, 33, 4);
   TESTINST("dextu", 0xffff0000ffffffff, 0xff0000ffffffffff, 60, 4);
   TESTINST("dextu", 0x2000ffffffffffff, 0xffff0000ffffffff, 54, 4);
   TESTINST("dextu", 0x2000ffffffddddff, 0xffffffffffff0008, 56, 2);
   TESTINST("dextu", 0x2000ffffffffeeee, 0xfffffff31415927f, 40, 4);
   TESTINST("dextu", 0x31415927ffffffff, 0x2000ffffffffffff, 51, 2);
   TESTINST("dextu", 0x2000ffffffffaaaa, 0x2000ffffffff2222, 48, 4);
   TESTINST("dextu", 0x2000ffffffbbbbff, 0x7fffffffddddffff, 38, 4);
   TESTINST("dextu", 0xeeeeff33ff22ffff, 0x2000ffffffffffff, 35, 4);
   TESTINST("dextu", 0x2000ffffffffffff, 0x2000ffffffffbbbb, 36, 4);
   TESTINST("dextu", 0x2000ffffffffbbbb, 0x2000ffffffffffff, 45, 1);
   TESTINST("dextu", 0x2000ffffffffffff, 0xeeeeff33ff22ffff, 46, 4);
   TESTINST("dextu", 0x7fffffffddddffff, 0x2000ffffffbbbbff, 52, 4);
   TESTINST("dextu", 0x2000ffffffff2222, 0x2000ffffffffaaaa, 40, 8);
   TESTINST("dextu", 0x2000ffffffffffff, 0x31415927ffffffff, 39, 4);
   TESTINST("dextu", 0xfffffff31415927f, 0x2000ffffffffeeee, 60, 4);
   TESTINST("dextu", 0xffffffffffff0008, 0x2000ffffffddddff, 63, 1);
   TESTINST("dextu", 0xffff0000ffffffff, 0x2000ffffffffffff, 50, 4);
   TESTINST("dextu", 0xff0000ffffffffff, 0,                  36, 4);
   TESTINST("dextu", 0xfffffffff0000fff, 0,                  46, 4);

   printf("--- DINS ---\n");
   /* The values of pos and size must satisfy all of the following relations:
      0 <= pos < 32
      0 < size <= 32
      0 < pos+size <= 32 */
   TESTINST("dins", 0x0,                0x0,                0, 1);
   TESTINST("dins", 0x0,                0xffffffffffffffff, 0, 1);
   TESTINST("dins", 0x0,                0x98765432,         0, 1);
   TESTINST("dins", 0x0,                0xffffffffff865421, 0, 1);
   TESTINST("dins", 0xffffffffffffffff, 0x0,                0, 1);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffffffffff, 0, 1);
   TESTINST("dins", 0xffffffffffffffff, 0x98765432,         0, 1);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffff865421, 0, 1);
   TESTINST("dins", 0x98765432,         0x0,                0, 1);
   TESTINST("dins", 0x98765432,         0xffffffffffffffff, 0, 1);
   TESTINST("dins", 0x98765432,         0x98765432,         0, 1);
   TESTINST("dins", 0x98765432,         0xffffffffff865421, 0, 1);
   TESTINST("dins", 0xffffffffff865421, 0x0,                0, 1);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffffffffff, 0, 1);
   TESTINST("dins", 0xffffffffff865421, 0x98765432,         0, 1);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffff865421, 0, 1);
   TESTINST("dins", 0x0,                0x0,                0, 4);
   TESTINST("dins", 0x0,                0xffffffffffffffff, 0, 4);
   TESTINST("dins", 0x0,                0x98765432,         0, 4);
   TESTINST("dins", 0x0,                0xffffffffff865421, 0, 4);
   TESTINST("dins", 0xffffffffffffffff, 0x0,                0, 4);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffffffffff, 0, 4);
   TESTINST("dins", 0xffffffffffffffff, 0x98765432,         0, 4);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffff865421, 0, 4);
   TESTINST("dins", 0x98765432,         0x0,                0, 4);
   TESTINST("dins", 0x98765432,         0xffffffffffffffff, 0, 4);
   TESTINST("dins", 0x98765432,         0x98765432,         0, 4);
   TESTINST("dins", 0x98765432,         0xffffffffff865421, 0, 4);
   TESTINST("dins", 0xffffffffff865421, 0x0,                0, 4);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffffffffff, 0, 4);
   TESTINST("dins", 0xffffffffff865421, 0x98765432,         0, 4);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffff865421, 0, 4);
   TESTINST("dins", 0x0,                0x0,                0, 16);
   TESTINST("dins", 0x0,                0xffffffffffffffff, 0, 16);
   TESTINST("dins", 0x0,                0x98765432,         0, 16);
   TESTINST("dins", 0x0,                0xffffffffff865421, 0, 16);
   TESTINST("dins", 0xffffffffffffffff, 0x0,                0, 16);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffffffffff, 0, 16);
   TESTINST("dins", 0xffffffffffffffff, 0x98765432,         0, 16);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffff865421, 0, 16);
   TESTINST("dins", 0x98765432,         0x0,                0, 16);
   TESTINST("dins", 0x98765432,         0xffffffffffffffff, 0, 16);
   TESTINST("dins", 0x98765432,         0x98765432,         0, 16);
   TESTINST("dins", 0x98765432,         0xffffffffff865421, 0, 16);
   TESTINST("dins", 0xffffffffff865421, 0x0,                0, 16);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffffffffff, 0, 16);
   TESTINST("dins", 0xffffffffff865421, 0x98765432,         0, 16);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffff865421, 0, 16);
   TESTINST("dins", 0x0,                0x0,                0, 32);
   TESTINST("dins", 0x0,                0xffffffffffffffff, 0, 32);
   TESTINST("dins", 0x0,                0x98765432,         0, 32);
   TESTINST("dins", 0x0,                0xffffffffff865421, 0, 32);
   TESTINST("dins", 0xffffffffffffffff, 0x0,                0, 32);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffffffffff, 0, 32);
   TESTINST("dins", 0xffffffffffffffff, 0x98765432,         0, 32);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffff865421, 0, 32);
   TESTINST("dins", 0x98765432,         0x0,                0, 32);
   TESTINST("dins", 0x98765432,         0xffffffffffffffff, 0, 32);
   TESTINST("dins", 0x98765432,         0x98765432,         0, 32);
   TESTINST("dins", 0x98765432,         0xffffffffff865421, 0, 32);
   TESTINST("dins", 0xffffffffff865421, 0x0,                0, 32);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffffffffff, 0, 32);
   TESTINST("dins", 0xffffffffff865421, 0x98765432,         0, 32);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffff865421, 0, 32);

   TESTINST("dins", 0x0,                0x0,                4, 1);
   TESTINST("dins", 0x0,                0xffffffffffffffff, 4, 1);
   TESTINST("dins", 0x0,                0x98765432,         4, 1);
   TESTINST("dins", 0x0,                0xffffffffff865421, 4, 1);
   TESTINST("dins", 0xffffffffffffffff, 0x0,                4, 1);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffffffffff, 4, 1);
   TESTINST("dins", 0xffffffffffffffff, 0x98765432,         4, 1);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffff865421, 4, 1);
   TESTINST("dins", 0x98765432,         0x0,                4, 1);
   TESTINST("dins", 0x98765432,         0xffffffffffffffff, 4, 1);
   TESTINST("dins", 0x98765432,         0x98765432,         4, 1);
   TESTINST("dins", 0x98765432,         0xffffffffff865421, 4, 1);
   TESTINST("dins", 0xffffffffff865421, 0x0,                4, 1);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffffffffff, 4, 1);
   TESTINST("dins", 0xffffffffff865421, 0x98765432,         4, 1);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffff865421, 4, 1);
   TESTINST("dins", 0x0,                0x0,                4, 4);
   TESTINST("dins", 0x0,                0xffffffffffffffff, 4, 4);
   TESTINST("dins", 0x0,                0x98765432,         4, 4);
   TESTINST("dins", 0x0,                0xffffffffff865421, 4, 4);
   TESTINST("dins", 0xffffffffffffffff, 0x0,                4, 4);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffffffffff, 4, 4);
   TESTINST("dins", 0xffffffffffffffff, 0x98765432,         4, 4);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffff865421, 4, 4);
   TESTINST("dins", 0x98765432,         0x0,                4, 4);
   TESTINST("dins", 0x98765432,         0xffffffffffffffff, 4, 4);
   TESTINST("dins", 0x98765432,         0x98765432,         4, 4);
   TESTINST("dins", 0x98765432,         0xffffffffff865421, 4, 4);
   TESTINST("dins", 0xffffffffff865421, 0x0,                4, 4);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffffffffff, 4, 4);
   TESTINST("dins", 0xffffffffff865421, 0x98765432,         4, 4);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffff865421, 4, 4);
   TESTINST("dins", 0x0,                0x0,                4, 16);
   TESTINST("dins", 0x0,                0xffffffffffffffff, 4, 16);
   TESTINST("dins", 0x0,                0x98765432,         4, 16);
   TESTINST("dins", 0x0,                0xffffffffff865421, 4, 16);
   TESTINST("dins", 0xffffffffffffffff, 0x0,                4, 16);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffffffffff, 4, 16);
   TESTINST("dins", 0xffffffffffffffff, 0x98765432,         4, 16);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffff865421, 4, 16);
   TESTINST("dins", 0x98765432,         0x0,                4, 16);
   TESTINST("dins", 0x98765432,         0xffffffffffffffff, 4, 16);
   TESTINST("dins", 0x98765432,         0x98765432,         4, 16);
   TESTINST("dins", 0x98765432,         0xffffffffff865421, 4, 16);
   TESTINST("dins", 0xffffffffff865421, 0x0,                4, 16);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffffffffff, 4, 16);
   TESTINST("dins", 0xffffffffff865421, 0x98765432,         4, 16);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffff865421, 4, 16);
   TESTINST("dins", 0x0,                0x0,                4, 28);
   TESTINST("dins", 0x0,                0xffffffffffffffff, 4, 28);
   TESTINST("dins", 0x0,                0x98765432,         4, 28);
   TESTINST("dins", 0x0,                0xffffffffff865421, 4, 28);
   TESTINST("dins", 0xffffffffffffffff, 0x0,                4, 28);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffffffffff, 4, 28);
   TESTINST("dins", 0xffffffffffffffff, 0x98765432,         4, 28);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffff865421, 4, 28);
   TESTINST("dins", 0x98765432,         0x0,                4, 28);
   TESTINST("dins", 0x98765432,         0xffffffffffffffff, 4, 28);
   TESTINST("dins", 0x98765432,         0x98765432,         4, 28);
   TESTINST("dins", 0x98765432,         0xffffffffff865421, 4, 28);
   TESTINST("dins", 0xffffffffff865421, 0x0,                4, 28);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffffffffff, 4, 28);
   TESTINST("dins", 0xffffffffff865421, 0x98765432,         4, 28);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffff865421, 4, 28);

   TESTINST("dins", 0x0,                0x0,                16, 1);
   TESTINST("dins", 0x0,                0xffffffffffffffff, 16, 1);
   TESTINST("dins", 0x0,                0x98765432,         16, 1);
   TESTINST("dins", 0x0,                0xffffffffff865421, 16, 1);
   TESTINST("dins", 0xffffffffffffffff, 0x0,                16, 1);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffffffffff, 16, 1);
   TESTINST("dins", 0xffffffffffffffff, 0x98765432,         16, 1);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffff865421, 16, 1);
   TESTINST("dins", 0x98765432,         0x0,                16, 1);
   TESTINST("dins", 0x98765432,         0xffffffffffffffff, 16, 1);
   TESTINST("dins", 0x98765432,         0x98765432,         16, 1);
   TESTINST("dins", 0x98765432,         0xffffffffff865421, 16, 1);
   TESTINST("dins", 0xffffffffff865421, 0x0,                16, 1);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffffffffff, 16, 1);
   TESTINST("dins", 0xffffffffff865421, 0x98765432,         16, 1);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffff865421, 16, 1);
   TESTINST("dins", 0x0,                0x0,                16, 4);
   TESTINST("dins", 0x0,                0xffffffffffffffff, 16, 4);
   TESTINST("dins", 0x0,                0x98765432,         16, 4);
   TESTINST("dins", 0x0,                0xffffffffff865421, 16, 4);
   TESTINST("dins", 0xffffffffffffffff, 0x0,                16, 4);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffffffffff, 16, 4);
   TESTINST("dins", 0xffffffffffffffff, 0x98765432,         16, 4);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffff865421, 16, 4);
   TESTINST("dins", 0x98765432,         0x0,                16, 4);
   TESTINST("dins", 0x98765432,         0xffffffffffffffff, 16, 4);
   TESTINST("dins", 0x98765432,         0x98765432,         16, 4);
   TESTINST("dins", 0x98765432,         0xffffffffff865421, 16, 4);
   TESTINST("dins", 0xffffffffff865421, 0x0,                16, 4);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffffffffff, 16, 4);
   TESTINST("dins", 0xffffffffff865421, 0x98765432,         16, 4);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffff865421, 16, 4);
   TESTINST("dins", 0x0,                0x0,                16, 16);
   TESTINST("dins", 0x0,                0xffffffffffffffff, 16, 16);
   TESTINST("dins", 0x0,                0x98765432,         16, 16);
   TESTINST("dins", 0x0,                0xffffffffff865421, 16, 16);
   TESTINST("dins", 0xffffffffffffffff, 0x0,                16, 16);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffffffffff, 16, 16);
   TESTINST("dins", 0xffffffffffffffff, 0x98765432,         16, 16);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffff865421, 16, 16);
   TESTINST("dins", 0x98765432,         0x0,                16, 16);
   TESTINST("dins", 0x98765432,         0xffffffffffffffff, 16, 16);
   TESTINST("dins", 0x98765432,         0x98765432,         16, 16);
   TESTINST("dins", 0x98765432,         0xffffffffff865421, 16, 16);
   TESTINST("dins", 0xffffffffff865421, 0x0,                16, 16);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffffffffff, 16, 16);
   TESTINST("dins", 0xffffffffff865421, 0x98765432,         16, 16);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffff865421, 16, 16);

   TESTINST("dins", 0x0,                0x0,                31, 1);
   TESTINST("dins", 0x0,                0xffffffffffffffff, 31, 1);
   TESTINST("dins", 0x0,                0x98765432,         31, 1);
   TESTINST("dins", 0x0,                0xffffffffff865421, 31, 1);
   TESTINST("dins", 0xffffffffffffffff, 0x0,                31, 1);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffffffffff, 31, 1);
   TESTINST("dins", 0xffffffffffffffff, 0x98765432,         31, 1);
   TESTINST("dins", 0xffffffffffffffff, 0xffffffffff865421, 31, 1);
   TESTINST("dins", 0x98765432,         0x0,                31, 1);
   TESTINST("dins", 0x98765432,         0xffffffffffffffff, 31, 1);
   TESTINST("dins", 0x98765432,         0x98765432,         31, 1);
   TESTINST("dins", 0x98765432,         0xffffffffff865421, 31, 1);
   TESTINST("dins", 0xffffffffff865421, 0x0,                31, 1);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffffffffff, 31, 1);
   TESTINST("dins", 0xffffffffff865421, 0x98765432,         31, 1);
   TESTINST("dins", 0xffffffffff865421, 0xffffffffff865421, 31, 1);

   TESTINST("dins", 0x2002ffffffffffff, 0xfffffffff0000fff, 4,  4);
   TESTINST("dins", 0xffff0000ffffffff, 0xff0000ffffffffff, 8,  4);
   TESTINST("dins", 0x2000ffffffffffff, 0xffff0000ffffffff, 16, 4);
   TESTINST("dins", 0x2000ffffffddddff, 0xffffffffffff0008, 24, 2);
   TESTINST("dins", 0x2000ffffffffeeee, 0xfffffff31415927f, 24, 4);
   TESTINST("dins", 0x31415927ffffffff, 0x2000ffffffffffff, 9,  2);
   TESTINST("dins", 0x2000ffffffffaaaa, 0x2000ffffffff2222, 16, 4);
   TESTINST("dins", 0x2000ffffffbbbbff, 0x7fffffffddddffff, 16, 4);
   TESTINST("dins", 0xeeeeff33ff22ffff, 0x2000ffffffffffff, 7,  4);
   TESTINST("dins", 0x2000ffffffffffff, 0x2000ffffffffbbbb, 5,  4);
   TESTINST("dins", 0x2000ffffffffbbbb, 0x2000ffffffffffff, 3,  4);
   TESTINST("dins", 0x2000ffffffffffff, 0xeeeeff33ff22ffff, 16, 4);
   TESTINST("dins", 0x7fffffffddddffff, 0x2000ffffffbbbbff, 16, 2);
   TESTINST("dins", 0x2000ffffffff2222, 0x2000ffffffffaaaa, 2,  8);
   TESTINST("dins", 0x2000ffffffffffff, 0x2000ffffffffeeee, 0,  32);
   TESTINST("dins", 0xfffffff31415927f, 0x2000ffffffddddff, 16, 16);
   TESTINST("dins", 0xffffffffffff0008, 0x2000ffffffddddff, 8,  2);
   TESTINST("dins", 0xffff0000ffffffff, 0x2000ffffffffffff, 16, 4);
   TESTINST("dins", 0xff0000ffffffffff, 0xffff0000ffffffff, 8,  4);
   TESTINST("dins", 0xfffffffff0000fff, 0,                  0,  31);

   printf("--- DINSM ---\n");
   /* The values of pos and size must satisfy all of the following relations:
      0 <= pos < 32
      2 <= size <= 64
      32 < pos+size <= 64 */
   TESTINST("dinsm", 0x0,                0x0,                0, 33);
   TESTINST("dinsm", 0x0,                0xffffffffffffffff, 0, 33);
   TESTINST("dinsm", 0x0,                0x98765432,         0, 33);
   TESTINST("dinsm", 0x0,                0xffffffffff865421, 0, 33);
   TESTINST("dinsm", 0xffffffffffffffff, 0x0,                0, 33);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffffffffff, 0, 33);
   TESTINST("dinsm", 0xffffffffffffffff, 0x98765432,         0, 33);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffff865421, 0, 33);
   TESTINST("dinsm", 0x98765432,         0x0,                0, 33);
   TESTINST("dinsm", 0x98765432,         0xffffffffffffffff, 0, 33);
   TESTINST("dinsm", 0x98765432,         0x98765432,         0, 33);
   TESTINST("dinsm", 0x98765432,         0xffffffffff865421, 0, 33);
   TESTINST("dinsm", 0xffffffffff865421, 0x0,                0, 33);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffffffffff, 0, 33);
   TESTINST("dinsm", 0xffffffffff865421, 0x98765432,         0, 33);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffff865421, 0, 33);
   TESTINST("dinsm", 0x0,                0x0,                0, 37);
   TESTINST("dinsm", 0x0,                0xffffffffffffffff, 0, 37);
   TESTINST("dinsm", 0x0,                0x98765432,         0, 37);
   TESTINST("dinsm", 0x0,                0xffffffffff865421, 0, 37);
   TESTINST("dinsm", 0xffffffffffffffff, 0x0,                0, 37);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffffffffff, 0, 37);
   TESTINST("dinsm", 0xffffffffffffffff, 0x98765432,         0, 37);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffff865421, 0, 37);
   TESTINST("dinsm", 0x98765432,         0x0,                0, 37);
   TESTINST("dinsm", 0x98765432,         0xffffffffffffffff, 0, 37);
   TESTINST("dinsm", 0x98765432,         0x98765432,         0, 37);
   TESTINST("dinsm", 0x98765432,         0xffffffffff865421, 0, 37);
   TESTINST("dinsm", 0xffffffffff865421, 0x0,                0, 37);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffffffffff, 0, 37);
   TESTINST("dinsm", 0xffffffffff865421, 0x98765432,         0, 37);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffff865421, 0, 37);
   TESTINST("dinsm", 0x0,                0x0,                0, 48);
   TESTINST("dinsm", 0x0,                0xffffffffffffffff, 0, 48);
   TESTINST("dinsm", 0x0,                0x98765432,         0, 48);
   TESTINST("dinsm", 0x0,                0xffffffffff865421, 0, 48);
   TESTINST("dinsm", 0xffffffffffffffff, 0x0,                0, 48);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffffffffff, 0, 48);
   TESTINST("dinsm", 0xffffffffffffffff, 0x98765432,         0, 48);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffff865421, 0, 48);
   TESTINST("dinsm", 0x98765432,         0x0,                0, 48);
   TESTINST("dinsm", 0x98765432,         0xffffffffffffffff, 0, 48);
   TESTINST("dinsm", 0x98765432,         0x98765432,         0, 48);
   TESTINST("dinsm", 0x98765432,         0xffffffffff865421, 0, 48);
   TESTINST("dinsm", 0xffffffffff865421, 0x0,                0, 48);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffffffffff, 0, 48);
   TESTINST("dinsm", 0xffffffffff865421, 0x98765432,         0, 48);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffff865421, 0, 48);
   TESTINST("dinsm", 0x0,                0x0,                0, 64);
   TESTINST("dinsm", 0x0,                0xffffffffffffffff, 0, 64);
   TESTINST("dinsm", 0x0,                0x98765432,         0, 64);
   TESTINST("dinsm", 0x0,                0xffffffffff865421, 0, 64);
   TESTINST("dinsm", 0xffffffffffffffff, 0x0,                0, 64);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffffffffff, 0, 64);
   TESTINST("dinsm", 0xffffffffffffffff, 0x98765432,         0, 64);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffff865421, 0, 64);
   TESTINST("dinsm", 0x98765432,         0x0,                0, 64);
   TESTINST("dinsm", 0x98765432,         0xffffffffffffffff, 0, 64);
   TESTINST("dinsm", 0x98765432,         0x98765432,         0, 64);
   TESTINST("dinsm", 0x98765432,         0xffffffffff865421, 0, 64);
   TESTINST("dinsm", 0xffffffffff865421, 0x0,                0, 64);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffffffffff, 0, 64);
   TESTINST("dinsm", 0xffffffffff865421, 0x98765432,         0, 64);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffff865421, 0, 64);

   TESTINST("dinsm", 0x0,                0x0,                4, 29);
   TESTINST("dinsm", 0x0,                0xffffffffffffffff, 4, 29);
   TESTINST("dinsm", 0x0,                0x98765432,         4, 29);
   TESTINST("dinsm", 0x0,                0xffffffffff865421, 4, 29);
   TESTINST("dinsm", 0xffffffffffffffff, 0x0,                4, 29);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffffffffff, 4, 29);
   TESTINST("dinsm", 0xffffffffffffffff, 0x98765432,         4, 29);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffff865421, 4, 29);
   TESTINST("dinsm", 0x98765432,         0x0,                4, 29);
   TESTINST("dinsm", 0x98765432,         0xffffffffffffffff, 4, 29);
   TESTINST("dinsm", 0x98765432,         0x98765432,         4, 29);
   TESTINST("dinsm", 0x98765432,         0xffffffffff865421, 4, 29);
   TESTINST("dinsm", 0xffffffffff865421, 0x0,                4, 29);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffffffffff, 4, 29);
   TESTINST("dinsm", 0xffffffffff865421, 0x98765432,         4, 29);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffff865421, 4, 29);
   TESTINST("dinsm", 0x0,                0x0,                4, 32);
   TESTINST("dinsm", 0x0,                0xffffffffffffffff, 4, 32);
   TESTINST("dinsm", 0x0,                0x98765432,         4, 32);
   TESTINST("dinsm", 0x0,                0xffffffffff865421, 4, 32);
   TESTINST("dinsm", 0xffffffffffffffff, 0x0,                4, 32);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffffffffff, 4, 32);
   TESTINST("dinsm", 0xffffffffffffffff, 0x98765432,         4, 32);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffff865421, 4, 32);
   TESTINST("dinsm", 0x98765432,         0x0,                4, 32);
   TESTINST("dinsm", 0x98765432,         0xffffffffffffffff, 4, 32);
   TESTINST("dinsm", 0x98765432,         0x98765432,         4, 32);
   TESTINST("dinsm", 0x98765432,         0xffffffffff865421, 4, 32);
   TESTINST("dinsm", 0xffffffffff865421, 0x0,                4, 32);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffffffffff, 4, 32);
   TESTINST("dinsm", 0xffffffffff865421, 0x98765432,         4, 32);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffff865421, 4, 32);
   TESTINST("dinsm", 0x0,                0x0,                4, 37);
   TESTINST("dinsm", 0x0,                0xffffffffffffffff, 4, 37);
   TESTINST("dinsm", 0x0,                0x98765432,         4, 37);
   TESTINST("dinsm", 0x0,                0xffffffffff865421, 4, 37);
   TESTINST("dinsm", 0xffffffffffffffff, 0x0,                4, 37);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffffffffff, 4, 37);
   TESTINST("dinsm", 0xffffffffffffffff, 0x98765432,         4, 37);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffff865421, 4, 37);
   TESTINST("dinsm", 0x98765432,         0x0,                4, 37);
   TESTINST("dinsm", 0x98765432,         0xffffffffffffffff, 4, 37);
   TESTINST("dinsm", 0x98765432,         0x98765432,         4, 37);
   TESTINST("dinsm", 0x98765432,         0xffffffffff865421, 4, 37);
   TESTINST("dinsm", 0xffffffffff865421, 0x0,                4, 37);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffffffffff, 4, 37);
   TESTINST("dinsm", 0xffffffffff865421, 0x98765432,         4, 37);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffff865421, 4, 37);
   TESTINST("dinsm", 0x0,                0x0,                4, 48);
   TESTINST("dinsm", 0x0,                0xffffffffffffffff, 4, 48);
   TESTINST("dinsm", 0x0,                0x98765432,         4, 48);
   TESTINST("dinsm", 0x0,                0xffffffffff865421, 4, 48);
   TESTINST("dinsm", 0xffffffffffffffff, 0x0,                4, 48);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffffffffff, 4, 48);
   TESTINST("dinsm", 0xffffffffffffffff, 0x98765432,         4, 48);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffff865421, 4, 48);
   TESTINST("dinsm", 0x98765432,         0x0,                4, 48);
   TESTINST("dinsm", 0x98765432,         0xffffffffffffffff, 4, 48);
   TESTINST("dinsm", 0x98765432,         0x98765432,         4, 48);
   TESTINST("dinsm", 0x98765432,         0xffffffffff865421, 4, 48);
   TESTINST("dinsm", 0xffffffffff865421, 0x0,                4, 48);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffffffffff, 4, 48);
   TESTINST("dinsm", 0xffffffffff865421, 0x98765432,         4, 48);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffff865421, 4, 48);
   TESTINST("dinsm", 0x0,                0x0,                4, 60);
   TESTINST("dinsm", 0x0,                0xffffffffffffffff, 4, 60);
   TESTINST("dinsm", 0x0,                0x98765432,         4, 60);
   TESTINST("dinsm", 0x0,                0xffffffffff865421, 4, 60);
   TESTINST("dinsm", 0xffffffffffffffff, 0x0,                4, 60);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffffffffff, 4, 60);
   TESTINST("dinsm", 0xffffffffffffffff, 0x98765432,         4, 60);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffff865421, 4, 60);
   TESTINST("dinsm", 0x98765432,         0x0,                4, 60);
   TESTINST("dinsm", 0x98765432,         0xffffffffffffffff, 4, 60);
   TESTINST("dinsm", 0x98765432,         0x98765432,         4, 60);
   TESTINST("dinsm", 0x98765432,         0xffffffffff865421, 4, 60);
   TESTINST("dinsm", 0xffffffffff865421, 0x0,                4, 60);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffffffffff, 4, 60);
   TESTINST("dinsm", 0xffffffffff865421, 0x98765432,         4, 60);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffff865421, 4, 60);

   TESTINST("dinsm", 0x0,                0x0,                16, 17);
   TESTINST("dinsm", 0x0,                0xffffffffffffffff, 16, 17);
   TESTINST("dinsm", 0x0,                0x98765432,         16, 17);
   TESTINST("dinsm", 0x0,                0xffffffffff865421, 16, 17);
   TESTINST("dinsm", 0xffffffffffffffff, 0x0,                16, 17);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffffffffff, 16, 17);
   TESTINST("dinsm", 0xffffffffffffffff, 0x98765432,         16, 17);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffff865421, 16, 17);
   TESTINST("dinsm", 0x98765432,         0x0,                16, 17);
   TESTINST("dinsm", 0x98765432,         0xffffffffffffffff, 16, 17);
   TESTINST("dinsm", 0x98765432,         0x98765432,         16, 17);
   TESTINST("dinsm", 0x98765432,         0xffffffffff865421, 16, 17);
   TESTINST("dinsm", 0xffffffffff865421, 0x0,                16, 17);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffffffffff, 16, 17);
   TESTINST("dinsm", 0xffffffffff865421, 0x98765432,         16, 17);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffff865421, 16, 17);
   TESTINST("dinsm", 0x0,                0x0,                16, 32);
   TESTINST("dinsm", 0x0,                0xffffffffffffffff, 16, 32);
   TESTINST("dinsm", 0x0,                0x98765432,         16, 32);
   TESTINST("dinsm", 0x0,                0xffffffffff865421, 16, 32);
   TESTINST("dinsm", 0xffffffffffffffff, 0x0,                16, 32);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffffffffff, 16, 32);
   TESTINST("dinsm", 0xffffffffffffffff, 0x98765432,         16, 32);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffff865421, 16, 32);
   TESTINST("dinsm", 0x98765432,         0x0,                16, 32);
   TESTINST("dinsm", 0x98765432,         0xffffffffffffffff, 16, 32);
   TESTINST("dinsm", 0x98765432,         0x98765432,         16, 32);
   TESTINST("dinsm", 0x98765432,         0xffffffffff865421, 16, 32);
   TESTINST("dinsm", 0xffffffffff865421, 0x0,                16, 32);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffffffffff, 16, 32);
   TESTINST("dinsm", 0xffffffffff865421, 0x98765432,         16, 32);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffff865421, 16, 32);
   TESTINST("dinsm", 0x0,                0x0,                16, 37);
   TESTINST("dinsm", 0x0,                0xffffffffffffffff, 16, 37);
   TESTINST("dinsm", 0x0,                0x98765432,         16, 37);
   TESTINST("dinsm", 0x0,                0xffffffffff865421, 16, 37);
   TESTINST("dinsm", 0xffffffffffffffff, 0x0,                16, 37);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffffffffff, 16, 37);
   TESTINST("dinsm", 0xffffffffffffffff, 0x98765432,         16, 37);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffff865421, 16, 37);
   TESTINST("dinsm", 0x98765432,         0x0,                16, 37);
   TESTINST("dinsm", 0x98765432,         0xffffffffffffffff, 16, 37);
   TESTINST("dinsm", 0x98765432,         0x98765432,         16, 37);
   TESTINST("dinsm", 0x98765432,         0xffffffffff865421, 16, 37);
   TESTINST("dinsm", 0xffffffffff865421, 0x0,                16, 37);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffffffffff, 16, 37);
   TESTINST("dinsm", 0xffffffffff865421, 0x98765432,         16, 37);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffff865421, 16, 37);
   TESTINST("dinsm", 0x0,                0x0,                16, 48);
   TESTINST("dinsm", 0x0,                0xffffffffffffffff, 16, 48);
   TESTINST("dinsm", 0x0,                0x98765432,         16, 48);
   TESTINST("dinsm", 0x0,                0xffffffffff865421, 16, 48);
   TESTINST("dinsm", 0xffffffffffffffff, 0x0,                16, 48);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffffffffff, 16, 48);
   TESTINST("dinsm", 0xffffffffffffffff, 0x98765432,         16, 48);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffff865421, 16, 48);
   TESTINST("dinsm", 0x98765432,         0x0,                16, 48);
   TESTINST("dinsm", 0x98765432,         0xffffffffffffffff, 16, 48);
   TESTINST("dinsm", 0x98765432,         0x98765432,         16, 48);
   TESTINST("dinsm", 0x98765432,         0xffffffffff865421, 16, 48);
   TESTINST("dinsm", 0xffffffffff865421, 0x0,                16, 48);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffffffffff, 16, 48);
   TESTINST("dinsm", 0xffffffffff865421, 0x98765432,         16, 48);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffff865421, 16, 48);

   TESTINST("dinsm", 0x0,                0x0,                31, 2);
   TESTINST("dinsm", 0x0,                0xffffffffffffffff, 31, 2);
   TESTINST("dinsm", 0x0,                0x98765432,         31, 2);
   TESTINST("dinsm", 0x0,                0xffffffffff865421, 31, 2);
   TESTINST("dinsm", 0xffffffffffffffff, 0x0,                31, 2);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffffffffff, 31, 2);
   TESTINST("dinsm", 0xffffffffffffffff, 0x98765432,         31, 2);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffff865421, 31, 2);
   TESTINST("dinsm", 0x98765432,         0x0,                31, 2);
   TESTINST("dinsm", 0x98765432,         0xffffffffffffffff, 31, 2);
   TESTINST("dinsm", 0x98765432,         0x98765432,         31, 2);
   TESTINST("dinsm", 0x98765432,         0xffffffffff865421, 31, 2);
   TESTINST("dinsm", 0xffffffffff865421, 0x0,                31, 2);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffffffffff, 31, 2);
   TESTINST("dinsm", 0xffffffffff865421, 0x98765432,         31, 2);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffff865421, 31, 2);
   TESTINST("dinsm", 0x0,                0x0,                31, 16);
   TESTINST("dinsm", 0x0,                0xffffffffffffffff, 31, 16);
   TESTINST("dinsm", 0x0,                0x98765432,         31, 16);
   TESTINST("dinsm", 0x0,                0xffffffffff865421, 31, 16);
   TESTINST("dinsm", 0xffffffffffffffff, 0x0,                31, 16);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffffffffff, 31, 16);
   TESTINST("dinsm", 0xffffffffffffffff, 0x98765432,         31, 16);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffff865421, 31, 16);
   TESTINST("dinsm", 0x98765432,         0x0,                31, 16);
   TESTINST("dinsm", 0x98765432,         0xffffffffffffffff, 31, 16);
   TESTINST("dinsm", 0x98765432,         0x98765432,         31, 16);
   TESTINST("dinsm", 0x98765432,         0xffffffffff865421, 31, 16);
   TESTINST("dinsm", 0xffffffffff865421, 0x0,                31, 16);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffffffffff, 31, 16);
   TESTINST("dinsm", 0xffffffffff865421, 0x98765432,         31, 16);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffff865421, 31, 16);
   TESTINST("dinsm", 0x0,                0x0,                31, 32);
   TESTINST("dinsm", 0x0,                0xffffffffffffffff, 31, 32);
   TESTINST("dinsm", 0x0,                0x98765432,         31, 32);
   TESTINST("dinsm", 0x0,                0xffffffffff865421, 31, 32);
   TESTINST("dinsm", 0xffffffffffffffff, 0x0,                31, 32);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffffffffff, 31, 32);
   TESTINST("dinsm", 0xffffffffffffffff, 0x98765432,         31, 32);
   TESTINST("dinsm", 0xffffffffffffffff, 0xffffffffff865421, 31, 32);
   TESTINST("dinsm", 0x98765432,         0x0,                31, 32);
   TESTINST("dinsm", 0x98765432,         0xffffffffffffffff, 31, 32);
   TESTINST("dinsm", 0x98765432,         0x98765432,         31, 32);
   TESTINST("dinsm", 0x98765432,         0xffffffffff865421, 31, 32);
   TESTINST("dinsm", 0xffffffffff865421, 0x0,                31, 32);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffffffffff, 31, 32);
   TESTINST("dinsm", 0xffffffffff865421, 0x98765432,         31, 32);
   TESTINST("dinsm", 0xffffffffff865421, 0xffffffffff865421, 31, 32);

   TESTINST("dinsm", 0x2002ffffffffffff, 0xfffffffff0000fff, 4,  35);
   TESTINST("dinsm", 0xffff0000ffffffff, 0xff0000ffffffffff, 8,  33);
   TESTINST("dinsm", 0x2000ffffffffffff, 0xffff0000ffffffff, 16, 34);
   TESTINST("dinsm", 0x2000ffffffddddff, 0xffffffffffff0008, 4,  46);
   TESTINST("dinsm", 0x2000ffffffffeeee, 0xfffffff31415927f, 3,  56);
   TESTINST("dinsm", 0x31415927ffffffff, 0x2000ffffffffffff, 0,  64);
   TESTINST("dinsm", 0x2000ffffffffaaaa, 0x2000ffffffff2222, 16, 40);
   TESTINST("dinsm", 0x2000ffffffbbbbff, 0x7fffffffddddffff, 16, 42);
   TESTINST("dinsm", 0xeeeeff33ff22ffff, 0x2000ffffffffffff, 7,  43);
   TESTINST("dinsm", 0x2000ffffffffffff, 0x2000ffffffffbbbb, 5,  48);
   TESTINST("dinsm", 0x2000ffffffffbbbb, 0x2000ffffffffffff, 3,  52);
   TESTINST("dinsm", 0x2000ffffffffffff, 0xeeeeff33ff22ffff, 1,  54);
   TESTINST("dinsm", 0x7fffffffddddffff, 0x2000ffffffbbbbff, 2,  54);
   TESTINST("dinsm", 0x2000ffffffff2222, 0x2000ffffffffaaaa, 2,  48);
   TESTINST("dinsm", 0x2000ffffffffffff, 0x31415927ffffffff, 5,  53);
   TESTINST("dinsm", 0xfffffff31415927f, 0x2000ffffffffeeee, 2,  60);
   TESTINST("dinsm", 0xffffffffffff0008, 0x2000ffffffddddff, 3,  61);
   TESTINST("dinsm", 0xffff0000ffffffff, 0x2000ffffffffffff, 1,  62);
   TESTINST("dinsm", 0xff0000ffffffffff, 0,                  8,  38);
   TESTINST("dinsm", 0xfffffffff0000fff, 0,                  16, 39);

   printf("--- DINSU ---\n");
   /* The values of pos and size must satisfy all of the following relations:
      32 <= pos < 64
      1 <= size <= 32
      32 < pos+size <= 64 */
   TESTINST("dinsu", 0x0,                0x0,                32, 1);
   TESTINST("dinsu", 0x0,                0xffffffffffffffff, 32, 1);
   TESTINST("dinsu", 0x0,                0x98765432,         32, 1);
   TESTINST("dinsu", 0x0,                0xffffffffff865421, 32, 1);
   TESTINST("dinsu", 0xffffffffffffffff, 0x0,                32, 1);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffffffffff, 32, 1);
   TESTINST("dinsu", 0xffffffffffffffff, 0x98765432,         32, 1);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffff865421, 32, 1);
   TESTINST("dinsu", 0x98765432,         0x0,                32, 1);
   TESTINST("dinsu", 0x98765432,         0xffffffffffffffff, 32, 1);
   TESTINST("dinsu", 0x98765432,         0x98765432,         32, 1);
   TESTINST("dinsu", 0x98765432,         0xffffffffff865421, 32, 1);
   TESTINST("dinsu", 0xffffffffff865421, 0x0,                32, 1);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffffffffff, 32, 1);
   TESTINST("dinsu", 0xffffffffff865421, 0x98765432,         32, 1);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffff865421, 32, 1);
   TESTINST("dinsu", 0x0,                0x0,                32, 4);
   TESTINST("dinsu", 0x0,                0xffffffffffffffff, 32, 4);
   TESTINST("dinsu", 0x0,                0x98765432,         32, 4);
   TESTINST("dinsu", 0x0,                0xffffffffff865421, 32, 4);
   TESTINST("dinsu", 0xffffffffffffffff, 0x0,                32, 4);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffffffffff, 32, 4);
   TESTINST("dinsu", 0xffffffffffffffff, 0x98765432,         32, 4);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffff865421, 32, 4);
   TESTINST("dinsu", 0x98765432,         0x0,                32, 4);
   TESTINST("dinsu", 0x98765432,         0xffffffffffffffff, 32, 4);
   TESTINST("dinsu", 0x98765432,         0x98765432,         32, 4);
   TESTINST("dinsu", 0x98765432,         0xffffffffff865421, 32, 4);
   TESTINST("dinsu", 0xffffffffff865421, 0x0,                32, 4);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffffffffff, 32, 4);
   TESTINST("dinsu", 0xffffffffff865421, 0x98765432,         32, 4);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffff865421, 32, 4);
   TESTINST("dinsu", 0x0,                0x0,                32, 16);
   TESTINST("dinsu", 0x0,                0xffffffffffffffff, 32, 16);
   TESTINST("dinsu", 0x0,                0x98765432,         32, 16);
   TESTINST("dinsu", 0x0,                0xffffffffff865421, 32, 16);
   TESTINST("dinsu", 0xffffffffffffffff, 0x0,                32, 16);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffffffffff, 32, 16);
   TESTINST("dinsu", 0xffffffffffffffff, 0x98765432,         32, 16);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffff865421, 32, 16);
   TESTINST("dinsu", 0x98765432,         0x0,                32, 16);
   TESTINST("dinsu", 0x98765432,         0xffffffffffffffff, 32, 16);
   TESTINST("dinsu", 0x98765432,         0x98765432,         32, 16);
   TESTINST("dinsu", 0x98765432,         0xffffffffff865421, 32, 16);
   TESTINST("dinsu", 0xffffffffff865421, 0x0,                32, 16);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffffffffff, 32, 16);
   TESTINST("dinsu", 0xffffffffff865421, 0x98765432,         32, 16);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffff865421, 32, 16);
   TESTINST("dinsu", 0x0,                0x0,                32, 32);
   TESTINST("dinsu", 0x0,                0xffffffffffffffff, 32, 32);
   TESTINST("dinsu", 0x0,                0x98765432,         32, 32);
   TESTINST("dinsu", 0x0,                0xffffffffff865421, 32, 32);
   TESTINST("dinsu", 0xffffffffffffffff, 0x0,                32, 32);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffffffffff, 32, 32);
   TESTINST("dinsu", 0xffffffffffffffff, 0x98765432,         32, 32);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffff865421, 32, 32);
   TESTINST("dinsu", 0x98765432,         0x0,                32, 32);
   TESTINST("dinsu", 0x98765432,         0xffffffffffffffff, 32, 32);
   TESTINST("dinsu", 0x98765432,         0x98765432,         32, 32);
   TESTINST("dinsu", 0x98765432,         0xffffffffff865421, 32, 32);
   TESTINST("dinsu", 0xffffffffff865421, 0x0,                32, 32);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffffffffff, 32, 32);
   TESTINST("dinsu", 0xffffffffff865421, 0x98765432,         32, 32);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffff865421, 32, 32);

   TESTINST("dinsu", 0x0,                0x0,                36, 1);
   TESTINST("dinsu", 0x0,                0xffffffffffffffff, 36, 1);
   TESTINST("dinsu", 0x0,                0x98765432,         36, 1);
   TESTINST("dinsu", 0x0,                0xffffffffff865421, 36, 1);
   TESTINST("dinsu", 0xffffffffffffffff, 0x0,                36, 1);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffffffffff, 36, 1);
   TESTINST("dinsu", 0xffffffffffffffff, 0x98765432,         36, 1);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffff865421, 36, 1);
   TESTINST("dinsu", 0x98765432,         0x0,                36, 1);
   TESTINST("dinsu", 0x98765432,         0xffffffffffffffff, 36, 1);
   TESTINST("dinsu", 0x98765432,         0x98765432,         36, 1);
   TESTINST("dinsu", 0x98765432,         0xffffffffff865421, 36, 1);
   TESTINST("dinsu", 0xffffffffff865421, 0x0,                36, 1);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffffffffff, 36, 1);
   TESTINST("dinsu", 0xffffffffff865421, 0x98765432,         36, 1);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffff865421, 36, 1);
   TESTINST("dinsu", 0x0,                0x0,                36, 4);
   TESTINST("dinsu", 0x0,                0xffffffffffffffff, 36, 4);
   TESTINST("dinsu", 0x0,                0x98765432,         36, 4);
   TESTINST("dinsu", 0x0,                0xffffffffff865421, 36, 4);
   TESTINST("dinsu", 0xffffffffffffffff, 0x0,                36, 4);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffffffffff, 36, 4);
   TESTINST("dinsu", 0xffffffffffffffff, 0x98765432,         36, 4);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffff865421, 36, 4);
   TESTINST("dinsu", 0x98765432,         0x0,                36, 4);
   TESTINST("dinsu", 0x98765432,         0xffffffffffffffff, 36, 4);
   TESTINST("dinsu", 0x98765432,         0x98765432,         36, 4);
   TESTINST("dinsu", 0x98765432,         0xffffffffff865421, 36, 4);
   TESTINST("dinsu", 0xffffffffff865421, 0x0,                36, 4);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffffffffff, 36, 4);
   TESTINST("dinsu", 0xffffffffff865421, 0x98765432,         36, 4);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffff865421, 36, 4);
   TESTINST("dinsu", 0x0,                0x0,                36, 16);
   TESTINST("dinsu", 0x0,                0xffffffffffffffff, 36, 16);
   TESTINST("dinsu", 0x0,                0x98765432,         36, 16);
   TESTINST("dinsu", 0x0,                0xffffffffff865421, 36, 16);
   TESTINST("dinsu", 0xffffffffffffffff, 0x0,                36, 16);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffffffffff, 36, 16);
   TESTINST("dinsu", 0xffffffffffffffff, 0x98765432,         36, 16);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffff865421, 36, 16);
   TESTINST("dinsu", 0x98765432,         0x0,                36, 16);
   TESTINST("dinsu", 0x98765432,         0xffffffffffffffff, 36, 16);
   TESTINST("dinsu", 0x98765432,         0x98765432,         36, 16);
   TESTINST("dinsu", 0x98765432,         0xffffffffff865421, 36, 16);
   TESTINST("dinsu", 0xffffffffff865421, 0x0,                36, 16);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffffffffff, 36, 16);
   TESTINST("dinsu", 0xffffffffff865421, 0x98765432,         36, 16);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffff865421, 36, 16);
   TESTINST("dinsu", 0x0,                0x0,                36, 28);
   TESTINST("dinsu", 0x0,                0xffffffffffffffff, 36, 28);
   TESTINST("dinsu", 0x0,                0x98765432,         36, 28);
   TESTINST("dinsu", 0x0,                0xffffffffff865421, 36, 28);
   TESTINST("dinsu", 0xffffffffffffffff, 0x0,                36, 28);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffffffffff, 36, 28);
   TESTINST("dinsu", 0xffffffffffffffff, 0x98765432,         36, 28);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffff865421, 36, 28);
   TESTINST("dinsu", 0x98765432,         0x0,                36, 28);
   TESTINST("dinsu", 0x98765432,         0xffffffffffffffff, 36, 28);
   TESTINST("dinsu", 0x98765432,         0x98765432,         36, 28);
   TESTINST("dinsu", 0x98765432,         0xffffffffff865421, 36, 28);
   TESTINST("dinsu", 0xffffffffff865421, 0x0,                36, 28);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffffffffff, 36, 28);
   TESTINST("dinsu", 0xffffffffff865421, 0x98765432,         36, 28);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffff865421, 36, 28);

   TESTINST("dinsu", 0x0,                0x0,                48, 1);
   TESTINST("dinsu", 0x0,                0xffffffffffffffff, 48, 1);
   TESTINST("dinsu", 0x0,                0x98765432,         48, 1);
   TESTINST("dinsu", 0x0,                0xffffffffff865421, 48, 1);
   TESTINST("dinsu", 0xffffffffffffffff, 0x0,                48, 1);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffffffffff, 48, 1);
   TESTINST("dinsu", 0xffffffffffffffff, 0x98765432,         48, 1);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffff865421, 48, 1);
   TESTINST("dinsu", 0x98765432,         0x0,                48, 1);
   TESTINST("dinsu", 0x98765432,         0xffffffffffffffff, 48, 1);
   TESTINST("dinsu", 0x98765432,         0x98765432,         48, 1);
   TESTINST("dinsu", 0x98765432,         0xffffffffff865421, 48, 1);
   TESTINST("dinsu", 0xffffffffff865421, 0x0,                48, 1);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffffffffff, 48, 1);
   TESTINST("dinsu", 0xffffffffff865421, 0x98765432,         48, 1);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffff865421, 48, 1);
   TESTINST("dinsu", 0x0,                0x0,                48, 4);
   TESTINST("dinsu", 0x0,                0xffffffffffffffff, 48, 4);
   TESTINST("dinsu", 0x0,                0x98765432,         48, 4);
   TESTINST("dinsu", 0x0,                0xffffffffff865421, 48, 4);
   TESTINST("dinsu", 0xffffffffffffffff, 0x0,                48, 4);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffffffffff, 48, 4);
   TESTINST("dinsu", 0xffffffffffffffff, 0x98765432,         48, 4);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffff865421, 48, 4);
   TESTINST("dinsu", 0x98765432,         0x0,                48, 4);
   TESTINST("dinsu", 0x98765432,         0xffffffffffffffff, 48, 4);
   TESTINST("dinsu", 0x98765432,         0x98765432,         48, 4);
   TESTINST("dinsu", 0x98765432,         0xffffffffff865421, 48, 4);
   TESTINST("dinsu", 0xffffffffff865421, 0x0,                48, 4);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffffffffff, 48, 4);
   TESTINST("dinsu", 0xffffffffff865421, 0x98765432,         48, 4);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffff865421, 48, 4);
   TESTINST("dinsu", 0x0,                0x0,                48, 16);
   TESTINST("dinsu", 0x0,                0xffffffffffffffff, 48, 16);
   TESTINST("dinsu", 0x0,                0x98765432,         48, 16);
   TESTINST("dinsu", 0x0,                0xffffffffff865421, 48, 16);
   TESTINST("dinsu", 0xffffffffffffffff, 0x0,                48, 16);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffffffffff, 48, 16);
   TESTINST("dinsu", 0xffffffffffffffff, 0x98765432,         48, 16);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffff865421, 48, 16);
   TESTINST("dinsu", 0x98765432,         0x0,                48, 16);
   TESTINST("dinsu", 0x98765432,         0xffffffffffffffff, 48, 16);
   TESTINST("dinsu", 0x98765432,         0x98765432,         48, 16);
   TESTINST("dinsu", 0x98765432,         0xffffffffff865421, 48, 16);
   TESTINST("dinsu", 0xffffffffff865421, 0x0,                48, 16);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffffffffff, 48, 16);
   TESTINST("dinsu", 0xffffffffff865421, 0x98765432,         48, 16);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffff865421, 48, 16);

   TESTINST("dinsu", 0x0,                0x0,                63, 1);
   TESTINST("dinsu", 0x0,                0xffffffffffffffff, 63, 1);
   TESTINST("dinsu", 0x0,                0x98765432,         63, 1);
   TESTINST("dinsu", 0x0,                0xffffffffff865421, 63, 1);
   TESTINST("dinsu", 0xffffffffffffffff, 0x0,                63, 1);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffffffffff, 63, 1);
   TESTINST("dinsu", 0xffffffffffffffff, 0x98765432,         63, 1);
   TESTINST("dinsu", 0xffffffffffffffff, 0xffffffffff865421, 63, 1);
   TESTINST("dinsu", 0x98765432,         0x0,                63, 1);
   TESTINST("dinsu", 0x98765432,         0xffffffffffffffff, 63, 1);
   TESTINST("dinsu", 0x98765432,         0x98765432,         63, 1);
   TESTINST("dinsu", 0x98765432,         0xffffffffff865421, 63, 1);
   TESTINST("dinsu", 0xffffffffff865421, 0x0,                63, 1);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffffffffff, 63, 1);
   TESTINST("dinsu", 0xffffffffff865421, 0x98765432,         63, 1);
   TESTINST("dinsu", 0xffffffffff865421, 0xffffffffff865421, 63, 1);

   TESTINST("dinsu", 0x2002ffffffffffff, 0xfffffffff0000fff, 33, 4);
   TESTINST("dinsu", 0xffff0000ffffffff, 0xff0000ffffffffff, 60, 4);
   TESTINST("dinsu", 0x2000ffffffffffff, 0xffff0000ffffffff, 54, 4);
   TESTINST("dinsu", 0x2000ffffffddddff, 0xffffffffffff0008, 56, 2);
   TESTINST("dinsu", 0x2000ffffffffeeee, 0xfffffff31415927f, 40, 4);
   TESTINST("dinsu", 0x31415927ffffffff, 0x2000ffffffffffff, 51, 2);
   TESTINST("dinsu", 0x2000ffffffffaaaa, 0x2000ffffffff2222, 48, 4);
   TESTINST("dinsu", 0x2000ffffffbbbbff, 0x7fffffffddddffff, 38, 4);
   TESTINST("dinsu", 0xeeeeff33ff22ffff, 0x2000ffffffffffff, 35, 4);
   TESTINST("dinsu", 0x2000ffffffffffff, 0x2000ffffffffbbbb, 36, 4);
   TESTINST("dinsu", 0x2000ffffffffbbbb, 0x2000ffffffffffff, 45, 1);
   TESTINST("dinsu", 0x2000ffffffffffff, 0xeeeeff33ff22ffff, 46, 4);
   TESTINST("dinsu", 0x7fffffffddddffff, 0x2000ffffffbbbbff, 52, 4);
   TESTINST("dinsu", 0x2000ffffffff2222, 0x2000ffffffffaaaa, 40, 8);
   TESTINST("dinsu", 0x2000ffffffffffff, 0x31415927ffffffff, 39, 4);
   TESTINST("dinsu", 0xfffffff31415927f, 0x31415927ffffffff, 60, 4);
   TESTINST("dinsu", 0xffffffffffff0008, 0x2000ffffffddddff, 63, 1);
   TESTINST("dinsu", 0xffff0000ffffffff, 0x2000ffffffffffff, 50, 4);
   TESTINST("dinsu", 0xff0000ffffffffff, 0,                  36, 4);
   TESTINST("dinsu", 0xfffffffff0000fff, 0,                  46, 4);
#else
   printf("This test is testing mips64r2 instructions.\n");
#endif

   return 0;
}
