; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv6-none-eabi -float-abi=soft %s -o - | FileCheck %s --check-prefixes=SOFT
; RUN: llc -mtriple=thumbv7-none-eabi -mattr=+vfp2 %s -o - | FileCheck %s --check-prefixes=VFP,VFP2
; RUN: llc -mtriple=thumbv8.1m.main-eabi -mattr=+fullfp16,+fp64 %s -o - | FileCheck %s --check-prefixes=VFP,FP16

;
; 32-bit float to signed integer
;

declare   i1 @llvm.fptosi.sat.i1.f32  (float)
declare   i8 @llvm.fptosi.sat.i8.f32  (float)
declare  i13 @llvm.fptosi.sat.i13.f32 (float)
declare  i16 @llvm.fptosi.sat.i16.f32 (float)
declare  i19 @llvm.fptosi.sat.i19.f32 (float)
declare  i32 @llvm.fptosi.sat.i32.f32 (float)
declare  i50 @llvm.fptosi.sat.i50.f32 (float)
declare  i64 @llvm.fptosi.sat.i64.f32 (float)
declare i100 @llvm.fptosi.sat.i100.f32(float)
declare i128 @llvm.fptosi.sat.i128.f32(float)

define i1 @test_signed_i1_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i1_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    ldr r1, .LCPI0_0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    movs r5, #0
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB0_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    b .LBB0_3
; SOFT-NEXT:  .LBB0_2:
; SOFT-NEXT:    mvns r6, r5
; SOFT-NEXT:  .LBB0_3:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:    bne .LBB0_5
; SOFT-NEXT:  @ %bb.4:
; SOFT-NEXT:    mov r7, r6
; SOFT-NEXT:  .LBB0_5:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    bne .LBB0_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    mov r5, r7
; SOFT-NEXT:  .LBB0_7:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:  .LCPI0_0:
; SOFT-NEXT:    .long 3212836864 @ 0xbf800000
;
; VFP2-LABEL: test_signed_i1_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov s2, r0
; VFP2-NEXT:    vmov.f32 s0, #-1.000000e+00
; VFP2-NEXT:    vcvt.s32.f32 s4, s2
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    vmov r0, s4
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt.w r0, #-1
; VFP2-NEXT:    vcmp.f32 s2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r0, #0
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    bx lr
;
; FP16-LABEL: test_signed_i1_f32:
; FP16:       @ %bb.0:
; FP16-NEXT:    vmov s2, r0
; FP16-NEXT:    vldr s4, .LCPI0_0
; FP16-NEXT:    vmov.f32 s0, #-1.000000e+00
; FP16-NEXT:    vmaxnm.f32 s0, s2, s0
; FP16-NEXT:    vcmp.f32 s2, s2
; FP16-NEXT:    vminnm.f32 s0, s0, s4
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcvt.s32.f32 s0, s0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    it vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI0_0:
; FP16-NEXT:    .long 0x00000000 @ float 0
    %x = call i1 @llvm.fptosi.sat.i1.f32(float %f)
    ret i1 %x
}

define i8 @test_signed_i8_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i8_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r0, #195
; SOFT-NEXT:    lsls r1, r0, #24
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    movs r5, #127
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB1_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    b .LBB1_3
; SOFT-NEXT:  .LBB1_2:
; SOFT-NEXT:    mvns r6, r5
; SOFT-NEXT:  .LBB1_3:
; SOFT-NEXT:    ldr r1, .LCPI1_0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    bne .LBB1_5
; SOFT-NEXT:  @ %bb.4:
; SOFT-NEXT:    mov r5, r6
; SOFT-NEXT:  .LBB1_5:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB1_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    movs r5, #0
; SOFT-NEXT:  .LBB1_7:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:  .LCPI1_0:
; SOFT-NEXT:    .long 1123942400 @ 0x42fe0000
;
; VFP2-LABEL: test_signed_i8_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s2, .LCPI1_0
; VFP2-NEXT:    vldr s6, .LCPI1_1
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s6
; VFP2-NEXT:    vmov r0, s4
; VFP2-NEXT:    it lt
; VFP2-NEXT:    mvnlt r0, #127
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r0, #127
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    bx lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI1_0:
; VFP2-NEXT:    .long 0xc3000000 @ float -128
; VFP2-NEXT:  .LCPI1_1:
; VFP2-NEXT:    .long 0x42fe0000 @ float 127
;
; FP16-LABEL: test_signed_i8_f32:
; FP16:       @ %bb.0:
; FP16-NEXT:    vldr s0, .LCPI1_0
; FP16-NEXT:    vmov s2, r0
; FP16-NEXT:    vldr s4, .LCPI1_1
; FP16-NEXT:    vmaxnm.f32 s0, s2, s0
; FP16-NEXT:    vcmp.f32 s2, s2
; FP16-NEXT:    vminnm.f32 s0, s0, s4
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcvt.s32.f32 s0, s0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    it vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI1_0:
; FP16-NEXT:    .long 0xc3000000 @ float -128
; FP16-NEXT:  .LCPI1_1:
; FP16-NEXT:    .long 0x42fe0000 @ float 127
    %x = call i8 @llvm.fptosi.sat.i8.f32(float %f)
    ret i8 %x
}

define i13 @test_signed_i13_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i13_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    ldr r1, .LCPI2_0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB2_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    b .LBB2_3
; SOFT-NEXT:  .LBB2_2:
; SOFT-NEXT:    ldr r5, .LCPI2_1
; SOFT-NEXT:  .LBB2_3:
; SOFT-NEXT:    ldr r1, .LCPI2_2
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB2_5
; SOFT-NEXT:  @ %bb.4:
; SOFT-NEXT:    ldr r5, .LCPI2_3
; SOFT-NEXT:  .LBB2_5:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB2_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    movs r5, #0
; SOFT-NEXT:  .LBB2_7:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:  .LCPI2_0:
; SOFT-NEXT:    .long 3313500160 @ 0xc5800000
; SOFT-NEXT:  .LCPI2_1:
; SOFT-NEXT:    .long 4294963200 @ 0xfffff000
; SOFT-NEXT:  .LCPI2_2:
; SOFT-NEXT:    .long 1166012416 @ 0x457ff000
; SOFT-NEXT:  .LCPI2_3:
; SOFT-NEXT:    .long 4095 @ 0xfff
;
; VFP2-LABEL: test_signed_i13_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s2, .LCPI2_0
; VFP2-NEXT:    vldr s6, .LCPI2_1
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s6
; VFP2-NEXT:    vmov r0, s4
; VFP2-NEXT:    itt lt
; VFP2-NEXT:    movwlt r0, #61440
; VFP2-NEXT:    movtlt r0, #65535
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movwgt r0, #4095
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    bx lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI2_0:
; VFP2-NEXT:    .long 0xc5800000 @ float -4096
; VFP2-NEXT:  .LCPI2_1:
; VFP2-NEXT:    .long 0x457ff000 @ float 4095
;
; FP16-LABEL: test_signed_i13_f32:
; FP16:       @ %bb.0:
; FP16-NEXT:    vldr s0, .LCPI2_0
; FP16-NEXT:    vmov s2, r0
; FP16-NEXT:    vldr s4, .LCPI2_1
; FP16-NEXT:    vmaxnm.f32 s0, s2, s0
; FP16-NEXT:    vcmp.f32 s2, s2
; FP16-NEXT:    vminnm.f32 s0, s0, s4
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcvt.s32.f32 s0, s0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    it vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI2_0:
; FP16-NEXT:    .long 0xc5800000 @ float -4096
; FP16-NEXT:  .LCPI2_1:
; FP16-NEXT:    .long 0x457ff000 @ float 4095
    %x = call i13 @llvm.fptosi.sat.i13.f32(float %f)
    ret i13 %x
}

define i16 @test_signed_i16_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i16_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r0, #199
; SOFT-NEXT:    lsls r1, r0, #24
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB3_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    b .LBB3_3
; SOFT-NEXT:  .LBB3_2:
; SOFT-NEXT:    ldr r5, .LCPI3_0
; SOFT-NEXT:  .LBB3_3:
; SOFT-NEXT:    ldr r1, .LCPI3_1
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB3_5
; SOFT-NEXT:  @ %bb.4:
; SOFT-NEXT:    ldr r5, .LCPI3_2
; SOFT-NEXT:  .LBB3_5:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB3_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    movs r5, #0
; SOFT-NEXT:  .LBB3_7:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:  .LCPI3_0:
; SOFT-NEXT:    .long 4294934528 @ 0xffff8000
; SOFT-NEXT:  .LCPI3_1:
; SOFT-NEXT:    .long 1191181824 @ 0x46fffe00
; SOFT-NEXT:  .LCPI3_2:
; SOFT-NEXT:    .long 32767 @ 0x7fff
;
; VFP2-LABEL: test_signed_i16_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s2, .LCPI3_0
; VFP2-NEXT:    vldr s6, .LCPI3_1
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s6
; VFP2-NEXT:    vmov r0, s4
; VFP2-NEXT:    itt lt
; VFP2-NEXT:    movwlt r0, #32768
; VFP2-NEXT:    movtlt r0, #65535
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movwgt r0, #32767
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    bx lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI3_0:
; VFP2-NEXT:    .long 0xc7000000 @ float -32768
; VFP2-NEXT:  .LCPI3_1:
; VFP2-NEXT:    .long 0x46fffe00 @ float 32767
;
; FP16-LABEL: test_signed_i16_f32:
; FP16:       @ %bb.0:
; FP16-NEXT:    vldr s0, .LCPI3_0
; FP16-NEXT:    vmov s2, r0
; FP16-NEXT:    vldr s4, .LCPI3_1
; FP16-NEXT:    vmaxnm.f32 s0, s2, s0
; FP16-NEXT:    vcmp.f32 s2, s2
; FP16-NEXT:    vminnm.f32 s0, s0, s4
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcvt.s32.f32 s0, s0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    it vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI3_0:
; FP16-NEXT:    .long 0xc7000000 @ float -32768
; FP16-NEXT:  .LCPI3_1:
; FP16-NEXT:    .long 0x46fffe00 @ float 32767
    %x = call i16 @llvm.fptosi.sat.i16.f32(float %f)
    ret i16 %x
}

define i19 @test_signed_i19_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i19_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    ldr r1, .LCPI4_0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB4_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    b .LBB4_3
; SOFT-NEXT:  .LBB4_2:
; SOFT-NEXT:    ldr r5, .LCPI4_1
; SOFT-NEXT:  .LBB4_3:
; SOFT-NEXT:    ldr r1, .LCPI4_2
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB4_5
; SOFT-NEXT:  @ %bb.4:
; SOFT-NEXT:    ldr r5, .LCPI4_3
; SOFT-NEXT:  .LBB4_5:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB4_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    movs r5, #0
; SOFT-NEXT:  .LBB4_7:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:  .LCPI4_0:
; SOFT-NEXT:    .long 3363831808 @ 0xc8800000
; SOFT-NEXT:  .LCPI4_1:
; SOFT-NEXT:    .long 4294705152 @ 0xfffc0000
; SOFT-NEXT:  .LCPI4_2:
; SOFT-NEXT:    .long 1216348096 @ 0x487fffc0
; SOFT-NEXT:  .LCPI4_3:
; SOFT-NEXT:    .long 262143 @ 0x3ffff
;
; VFP2-LABEL: test_signed_i19_f32:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s2, .LCPI4_0
; VFP2-NEXT:    vldr s6, .LCPI4_1
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s6
; VFP2-NEXT:    vmov r0, s4
; VFP2-NEXT:    itt lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    movtlt r0, #65532
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    itt gt
; VFP2-NEXT:    movwgt r0, #65535
; VFP2-NEXT:    movtgt r0, #3
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    bx lr
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI4_0:
; VFP2-NEXT:    .long 0xc8800000 @ float -262144
; VFP2-NEXT:  .LCPI4_1:
; VFP2-NEXT:    .long 0x487fffc0 @ float 262143
;
; FP16-LABEL: test_signed_i19_f32:
; FP16:       @ %bb.0:
; FP16-NEXT:    vldr s0, .LCPI4_0
; FP16-NEXT:    vmov s2, r0
; FP16-NEXT:    vldr s4, .LCPI4_1
; FP16-NEXT:    vmaxnm.f32 s0, s2, s0
; FP16-NEXT:    vcmp.f32 s2, s2
; FP16-NEXT:    vminnm.f32 s0, s0, s4
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcvt.s32.f32 s0, s0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    it vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI4_0:
; FP16-NEXT:    .long 0xc8800000 @ float -262144
; FP16-NEXT:  .LCPI4_1:
; FP16-NEXT:    .long 0x487fffc0 @ float 262143
    %x = call i19 @llvm.fptosi.sat.i19.f32(float %f)
    ret i19 %x
}

define i32 @test_signed_i32_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i32_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r0, #207
; SOFT-NEXT:    lsls r1, r0, #24
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB5_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    b .LBB5_3
; SOFT-NEXT:  .LBB5_2:
; SOFT-NEXT:    movs r0, #1
; SOFT-NEXT:    lsls r5, r0, #31
; SOFT-NEXT:  .LBB5_3:
; SOFT-NEXT:    ldr r1, .LCPI5_0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB5_5
; SOFT-NEXT:  @ %bb.4:
; SOFT-NEXT:    ldr r5, .LCPI5_1
; SOFT-NEXT:  .LBB5_5:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB5_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    movs r5, #0
; SOFT-NEXT:  .LBB5_7:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:  .LCPI5_0:
; SOFT-NEXT:    .long 1325400063 @ 0x4effffff
; SOFT-NEXT:  .LCPI5_1:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP-LABEL: test_signed_i32_f32:
; VFP:       @ %bb.0:
; VFP-NEXT:    vmov s0, r0
; VFP-NEXT:    vcvt.s32.f32 s0, s0
; VFP-NEXT:    vmov r0, s0
; VFP-NEXT:    bx lr
    %x = call i32 @llvm.fptosi.sat.i32.f32(float %f)
    ret i32 %x
}

define i50 @test_signed_i50_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i50_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r0, #27
; SOFT-NEXT:    lsls r1, r0, #27
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB6_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r5, r7
; SOFT-NEXT:  .LBB6_2:
; SOFT-NEXT:    beq .LBB6_4
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:    str r1, [sp] @ 4-byte Spill
; SOFT-NEXT:    b .LBB6_5
; SOFT-NEXT:  .LBB6_4:
; SOFT-NEXT:    ldr r0, .LCPI6_0
; SOFT-NEXT:    str r0, [sp] @ 4-byte Spill
; SOFT-NEXT:  .LBB6_5:
; SOFT-NEXT:    ldr r1, .LCPI6_1
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    movs r7, #0
; SOFT-NEXT:    mvns r6, r7
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB6_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    ldr r0, .LCPI6_2
; SOFT-NEXT:    str r0, [sp] @ 4-byte Spill
; SOFT-NEXT:  .LBB6_7:
; SOFT-NEXT:    bne .LBB6_9
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:    mov r6, r5
; SOFT-NEXT:  .LBB6_9:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    bne .LBB6_11
; SOFT-NEXT:  @ %bb.10:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:  .LBB6_11:
; SOFT-NEXT:    bne .LBB6_13
; SOFT-NEXT:  @ %bb.12:
; SOFT-NEXT:    ldr r7, [sp] @ 4-byte Reload
; SOFT-NEXT:  .LBB6_13:
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.14:
; SOFT-NEXT:  .LCPI6_0:
; SOFT-NEXT:    .long 4294836224 @ 0xfffe0000
; SOFT-NEXT:  .LCPI6_1:
; SOFT-NEXT:    .long 1476395007 @ 0x57ffffff
; SOFT-NEXT:  .LCPI6_2:
; SOFT-NEXT:    .long 131071 @ 0x1ffff
;
; VFP-LABEL: test_signed_i50_f32:
; VFP:       @ %bb.0:
; VFP-NEXT:    .save {r4, lr}
; VFP-NEXT:    push {r4, lr}
; VFP-NEXT:    mov r4, r0
; VFP-NEXT:    bl __aeabi_f2lz
; VFP-NEXT:    vldr s0, .LCPI6_0
; VFP-NEXT:    vmov s2, r4
; VFP-NEXT:    vldr s4, .LCPI6_1
; VFP-NEXT:    vcmp.f32 s2, s0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    ittt lt
; VFP-NEXT:    movlt r1, #0
; VFP-NEXT:    movtlt r1, #65534
; VFP-NEXT:    movlt r0, #0
; VFP-NEXT:    vcmp.f32 s2, s4
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    it gt
; VFP-NEXT:    movgt.w r0, #-1
; VFP-NEXT:    vcmp.f32 s2, s2
; VFP-NEXT:    itt gt
; VFP-NEXT:    movwgt r1, #65535
; VFP-NEXT:    movtgt r1, #1
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    itt vs
; VFP-NEXT:    movvs r0, #0
; VFP-NEXT:    movvs r1, #0
; VFP-NEXT:    pop {r4, pc}
; VFP-NEXT:    .p2align 2
; VFP-NEXT:  @ %bb.1:
; VFP-NEXT:  .LCPI6_0:
; VFP-NEXT:    .long 0xd8000000 @ float -5.62949953E+14
; VFP-NEXT:  .LCPI6_1:
; VFP-NEXT:    .long 0x57ffffff @ float 5.6294992E+14
    %x = call i50 @llvm.fptosi.sat.i50.f32(float %f)
    ret i50 %x
}

define i64 @test_signed_i64_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i64_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r0, #223
; SOFT-NEXT:    lsls r1, r0, #24
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    movs r2, #1
; SOFT-NEXT:    lsls r7, r2, #31
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB7_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:  .LBB7_2:
; SOFT-NEXT:    str r0, [sp] @ 4-byte Spill
; SOFT-NEXT:    beq .LBB7_4
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:  .LBB7_4:
; SOFT-NEXT:    ldr r1, .LCPI7_0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    mvns r5, r6
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB7_6
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:    ldr r7, .LCPI7_1
; SOFT-NEXT:  .LBB7_6:
; SOFT-NEXT:    bne .LBB7_8
; SOFT-NEXT:  @ %bb.7:
; SOFT-NEXT:    ldr r5, [sp] @ 4-byte Reload
; SOFT-NEXT:  .LBB7_8:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bne .LBB7_10
; SOFT-NEXT:  @ %bb.9:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:  .LBB7_10:
; SOFT-NEXT:    bne .LBB7_12
; SOFT-NEXT:  @ %bb.11:
; SOFT-NEXT:    mov r6, r7
; SOFT-NEXT:  .LBB7_12:
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.13:
; SOFT-NEXT:  .LCPI7_0:
; SOFT-NEXT:    .long 1593835519 @ 0x5effffff
; SOFT-NEXT:  .LCPI7_1:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP-LABEL: test_signed_i64_f32:
; VFP:       @ %bb.0:
; VFP-NEXT:    .save {r4, lr}
; VFP-NEXT:    push {r4, lr}
; VFP-NEXT:    mov r4, r0
; VFP-NEXT:    bl __aeabi_f2lz
; VFP-NEXT:    vldr s0, .LCPI7_0
; VFP-NEXT:    vmov s2, r4
; VFP-NEXT:    vldr s4, .LCPI7_1
; VFP-NEXT:    vcmp.f32 s2, s0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    itt lt
; VFP-NEXT:    movlt r0, #0
; VFP-NEXT:    movlt.w r1, #-2147483648
; VFP-NEXT:    vcmp.f32 s2, s4
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    itt gt
; VFP-NEXT:    mvngt r1, #-2147483648
; VFP-NEXT:    movgt.w r0, #-1
; VFP-NEXT:    vcmp.f32 s2, s2
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    itt vs
; VFP-NEXT:    movvs r0, #0
; VFP-NEXT:    movvs r1, #0
; VFP-NEXT:    pop {r4, pc}
; VFP-NEXT:    .p2align 2
; VFP-NEXT:  @ %bb.1:
; VFP-NEXT:  .LCPI7_0:
; VFP-NEXT:    .long 0xdf000000 @ float -9.22337203E+18
; VFP-NEXT:  .LCPI7_1:
; VFP-NEXT:    .long 0x5effffff @ float 9.22337149E+18
    %x = call i64 @llvm.fptosi.sat.i64.f32(float %f)
    ret i64 %x
}

define i100 @test_signed_i100_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i100_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #20
; SOFT-NEXT:    sub sp, #20
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r0, #241
; SOFT-NEXT:    lsls r1, r0, #24
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __fixsfti
; SOFT-NEXT:    movs r5, #7
; SOFT-NEXT:    str r5, [sp, #16] @ 4-byte Spill
; SOFT-NEXT:    mvns r7, r5
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB8_17
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    beq .LBB8_18
; SOFT-NEXT:  .LBB8_2:
; SOFT-NEXT:    bne .LBB8_4
; SOFT-NEXT:  .LBB8_3:
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:  .LBB8_4:
; SOFT-NEXT:    str r2, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    str r1, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    str r0, [sp, #12] @ 4-byte Spill
; SOFT-NEXT:    beq .LBB8_6
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:    mov r7, r3
; SOFT-NEXT:  .LBB8_6:
; SOFT-NEXT:    ldr r1, .LCPI8_0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    mvns r5, r6
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB8_19
; SOFT-NEXT:  @ %bb.7:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    beq .LBB8_20
; SOFT-NEXT:  .LBB8_8:
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:    beq .LBB8_21
; SOFT-NEXT:  .LBB8_9:
; SOFT-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    bne .LBB8_11
; SOFT-NEXT:  .LBB8_10:
; SOFT-NEXT:    ldr r5, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:  .LBB8_11:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    beq .LBB8_22
; SOFT-NEXT:  @ %bb.12:
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    beq .LBB8_23
; SOFT-NEXT:  .LBB8_13:
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    beq .LBB8_24
; SOFT-NEXT:  .LBB8_14:
; SOFT-NEXT:    bne .LBB8_16
; SOFT-NEXT:  .LBB8_15:
; SOFT-NEXT:    ldr r6, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:  .LBB8_16:
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:    add sp, #20
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB8_17:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bne .LBB8_2
; SOFT-NEXT:  .LBB8_18:
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    beq .LBB8_3
; SOFT-NEXT:    b .LBB8_4
; SOFT-NEXT:  .LBB8_19:
; SOFT-NEXT:    str r7, [sp, #16] @ 4-byte Spill
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    bne .LBB8_8
; SOFT-NEXT:  .LBB8_20:
; SOFT-NEXT:    ldr r0, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:    bne .LBB8_9
; SOFT-NEXT:  .LBB8_21:
; SOFT-NEXT:    ldr r7, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    beq .LBB8_10
; SOFT-NEXT:    b .LBB8_11
; SOFT-NEXT:  .LBB8_22:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    bne .LBB8_13
; SOFT-NEXT:  .LBB8_23:
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    bne .LBB8_14
; SOFT-NEXT:  .LBB8_24:
; SOFT-NEXT:    ldr r2, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    beq .LBB8_15
; SOFT-NEXT:    b .LBB8_16
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.25:
; SOFT-NEXT:  .LCPI8_0:
; SOFT-NEXT:    .long 1895825407 @ 0x70ffffff
;
; VFP-LABEL: test_signed_i100_f32:
; VFP:       @ %bb.0:
; VFP-NEXT:    .save {r4, lr}
; VFP-NEXT:    push {r4, lr}
; VFP-NEXT:    mov r4, r0
; VFP-NEXT:    bl __fixsfti
; VFP-NEXT:    vldr s0, .LCPI8_0
; VFP-NEXT:    vmov s2, r4
; VFP-NEXT:    vldr s4, .LCPI8_1
; VFP-NEXT:    vcmp.f32 s2, s0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    itttt lt
; VFP-NEXT:    movlt r0, #0
; VFP-NEXT:    movlt r1, #0
; VFP-NEXT:    movlt r2, #0
; VFP-NEXT:    mvnlt r3, #7
; VFP-NEXT:    vcmp.f32 s2, s4
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    itttt gt
; VFP-NEXT:    movgt r3, #7
; VFP-NEXT:    movgt.w r2, #-1
; VFP-NEXT:    movgt.w r1, #-1
; VFP-NEXT:    movgt.w r0, #-1
; VFP-NEXT:    vcmp.f32 s2, s2
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    itttt vs
; VFP-NEXT:    movvs r0, #0
; VFP-NEXT:    movvs r1, #0
; VFP-NEXT:    movvs r2, #0
; VFP-NEXT:    movvs r3, #0
; VFP-NEXT:    pop {r4, pc}
; VFP-NEXT:    .p2align 2
; VFP-NEXT:  @ %bb.1:
; VFP-NEXT:  .LCPI8_0:
; VFP-NEXT:    .long 0xf1000000 @ float -6.338253E+29
; VFP-NEXT:  .LCPI8_1:
; VFP-NEXT:    .long 0x70ffffff @ float 6.33825262E+29
    %x = call i100 @llvm.fptosi.sat.i100.f32(float %f)
    ret i100 %x
}

define i128 @test_signed_i128_f32(float %f) nounwind {
; SOFT-LABEL: test_signed_i128_f32:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #20
; SOFT-NEXT:    sub sp, #20
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r0, #255
; SOFT-NEXT:    lsls r1, r0, #24
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __fixsfti
; SOFT-NEXT:    movs r5, #1
; SOFT-NEXT:    lsls r7, r5, #31
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB9_18
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    beq .LBB9_19
; SOFT-NEXT:  .LBB9_2:
; SOFT-NEXT:    bne .LBB9_4
; SOFT-NEXT:  .LBB9_3:
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:  .LBB9_4:
; SOFT-NEXT:    str r2, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    str r1, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    str r0, [sp, #12] @ 4-byte Spill
; SOFT-NEXT:    beq .LBB9_6
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:    mov r7, r3
; SOFT-NEXT:  .LBB9_6:
; SOFT-NEXT:    ldr r1, .LCPI9_0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    mvns r5, r6
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB9_8
; SOFT-NEXT:  @ %bb.7:
; SOFT-NEXT:    ldr r7, .LCPI9_1
; SOFT-NEXT:  .LBB9_8:
; SOFT-NEXT:    str r7, [sp, #16] @ 4-byte Spill
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    beq .LBB9_20
; SOFT-NEXT:  @ %bb.9:
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:    beq .LBB9_21
; SOFT-NEXT:  .LBB9_10:
; SOFT-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    bne .LBB9_12
; SOFT-NEXT:  .LBB9_11:
; SOFT-NEXT:    ldr r5, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:  .LBB9_12:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    beq .LBB9_22
; SOFT-NEXT:  @ %bb.13:
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    beq .LBB9_23
; SOFT-NEXT:  .LBB9_14:
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    beq .LBB9_24
; SOFT-NEXT:  .LBB9_15:
; SOFT-NEXT:    ldr r3, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:    bne .LBB9_17
; SOFT-NEXT:  .LBB9_16:
; SOFT-NEXT:    mov r6, r3
; SOFT-NEXT:  .LBB9_17:
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:    add sp, #20
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB9_18:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bne .LBB9_2
; SOFT-NEXT:  .LBB9_19:
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    beq .LBB9_3
; SOFT-NEXT:    b .LBB9_4
; SOFT-NEXT:  .LBB9_20:
; SOFT-NEXT:    ldr r0, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:    bne .LBB9_10
; SOFT-NEXT:  .LBB9_21:
; SOFT-NEXT:    ldr r7, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    beq .LBB9_11
; SOFT-NEXT:    b .LBB9_12
; SOFT-NEXT:  .LBB9_22:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    bne .LBB9_14
; SOFT-NEXT:  .LBB9_23:
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    bne .LBB9_15
; SOFT-NEXT:  .LBB9_24:
; SOFT-NEXT:    ldr r2, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    ldr r3, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:    beq .LBB9_16
; SOFT-NEXT:    b .LBB9_17
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.25:
; SOFT-NEXT:  .LCPI9_0:
; SOFT-NEXT:    .long 2130706431 @ 0x7effffff
; SOFT-NEXT:  .LCPI9_1:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP-LABEL: test_signed_i128_f32:
; VFP:       @ %bb.0:
; VFP-NEXT:    .save {r4, lr}
; VFP-NEXT:    push {r4, lr}
; VFP-NEXT:    mov r4, r0
; VFP-NEXT:    bl __fixsfti
; VFP-NEXT:    vldr s0, .LCPI9_0
; VFP-NEXT:    vmov s2, r4
; VFP-NEXT:    vldr s4, .LCPI9_1
; VFP-NEXT:    vcmp.f32 s2, s0
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    itttt lt
; VFP-NEXT:    movlt r0, #0
; VFP-NEXT:    movlt r1, #0
; VFP-NEXT:    movlt r2, #0
; VFP-NEXT:    movlt.w r3, #-2147483648
; VFP-NEXT:    vcmp.f32 s2, s4
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    itttt gt
; VFP-NEXT:    mvngt r3, #-2147483648
; VFP-NEXT:    movgt.w r2, #-1
; VFP-NEXT:    movgt.w r1, #-1
; VFP-NEXT:    movgt.w r0, #-1
; VFP-NEXT:    vcmp.f32 s2, s2
; VFP-NEXT:    vmrs APSR_nzcv, fpscr
; VFP-NEXT:    itttt vs
; VFP-NEXT:    movvs r0, #0
; VFP-NEXT:    movvs r1, #0
; VFP-NEXT:    movvs r2, #0
; VFP-NEXT:    movvs r3, #0
; VFP-NEXT:    pop {r4, pc}
; VFP-NEXT:    .p2align 2
; VFP-NEXT:  @ %bb.1:
; VFP-NEXT:  .LCPI9_0:
; VFP-NEXT:    .long 0xff000000 @ float -1.70141183E+38
; VFP-NEXT:  .LCPI9_1:
; VFP-NEXT:    .long 0x7effffff @ float 1.70141173E+38
    %x = call i128 @llvm.fptosi.sat.i128.f32(float %f)
    ret i128 %x
}

;
; 64-bit float to signed integer
;

declare   i1 @llvm.fptosi.sat.i1.f64  (double)
declare   i8 @llvm.fptosi.sat.i8.f64  (double)
declare  i13 @llvm.fptosi.sat.i13.f64 (double)
declare  i16 @llvm.fptosi.sat.i16.f64 (double)
declare  i19 @llvm.fptosi.sat.i19.f64 (double)
declare  i32 @llvm.fptosi.sat.i32.f64 (double)
declare  i50 @llvm.fptosi.sat.i50.f64 (double)
declare  i64 @llvm.fptosi.sat.i64.f64 (double)
declare i100 @llvm.fptosi.sat.i100.f64(double)
declare i128 @llvm.fptosi.sat.i128.f64(double)

define i1 @test_signed_i1_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i1_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    movs r4, #0
; SOFT-NEXT:    ldr r3, .LCPI10_0
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    bl __aeabi_d2iz
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB10_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mvns r0, r4
; SOFT-NEXT:  .LBB10_2:
; SOFT-NEXT:    str r0, [sp] @ 4-byte Spill
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r7, r4
; SOFT-NEXT:    bne .LBB10_4
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:    ldr r7, [sp] @ 4-byte Reload
; SOFT-NEXT:  .LBB10_4:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    bne .LBB10_6
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:    mov r4, r7
; SOFT-NEXT:  .LBB10_6:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.7:
; SOFT-NEXT:  .LCPI10_0:
; SOFT-NEXT:    .long 3220176896 @ 0xbff00000
;
; VFP2-LABEL: test_signed_i1_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov.f64 d17, #-1.000000e+00
; VFP2-NEXT:    vmov d16, r0, r1
; VFP2-NEXT:    vcmp.f64 d16, d17
; VFP2-NEXT:    vcvt.s32.f64 s0, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    vcmp.f64 d16, #0
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt.w r0, #-1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r0, #0
; VFP2-NEXT:    vcmp.f64 d16, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    bx lr
;
; FP16-LABEL: test_signed_i1_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    vmov.f64 d0, #-1.000000e+00
; FP16-NEXT:    vmov d1, r0, r1
; FP16-NEXT:    vldr d2, .LCPI10_0
; FP16-NEXT:    vmaxnm.f64 d0, d1, d0
; FP16-NEXT:    vminnm.f64 d0, d0, d2
; FP16-NEXT:    vcmp.f64 d1, d1
; FP16-NEXT:    vcvt.s32.f64 s0, d0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 3
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI10_0:
; FP16-NEXT:    .long 0 @ double 0
; FP16-NEXT:    .long 0
    %x = call i1 @llvm.fptosi.sat.i1.f64(double %f)
    ret i1 %x
}

define i8 @test_signed_i8_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i8_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    movs r4, #0
; SOFT-NEXT:    ldr r3, .LCPI11_0
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    bl __aeabi_d2iz
; SOFT-NEXT:    movs r1, #127
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB11_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    str r0, [sp] @ 4-byte Spill
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    b .LBB11_3
; SOFT-NEXT:  .LBB11_2:
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:    mvns r0, r1
; SOFT-NEXT:    str r0, [sp] @ 4-byte Spill
; SOFT-NEXT:  .LBB11_3:
; SOFT-NEXT:    ldr r3, .LCPI11_1
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    bne .LBB11_5
; SOFT-NEXT:  @ %bb.4:
; SOFT-NEXT:    ldr r7, [sp] @ 4-byte Reload
; SOFT-NEXT:  .LBB11_5:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    bne .LBB11_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    mov r4, r7
; SOFT-NEXT:  .LBB11_7:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:  .LCPI11_0:
; SOFT-NEXT:    .long 3227516928 @ 0xc0600000
; SOFT-NEXT:  .LCPI11_1:
; SOFT-NEXT:    .long 1080016896 @ 0x405fc000
;
; VFP2-LABEL: test_signed_i8_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov d16, r0, r1
; VFP2-NEXT:    vldr d17, .LCPI11_0
; VFP2-NEXT:    vldr d18, .LCPI11_1
; VFP2-NEXT:    vcvt.s32.f64 s0, d16
; VFP2-NEXT:    vcmp.f64 d16, d17
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    vcmp.f64 d16, d18
; VFP2-NEXT:    it lt
; VFP2-NEXT:    mvnlt r0, #127
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r0, #127
; VFP2-NEXT:    vcmp.f64 d16, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    bx lr
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI11_0:
; VFP2-NEXT:    .long 0 @ double -128
; VFP2-NEXT:    .long 3227516928
; VFP2-NEXT:  .LCPI11_1:
; VFP2-NEXT:    .long 0 @ double 127
; VFP2-NEXT:    .long 1080016896
;
; FP16-LABEL: test_signed_i8_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    vldr d0, .LCPI11_0
; FP16-NEXT:    vmov d1, r0, r1
; FP16-NEXT:    vldr d2, .LCPI11_1
; FP16-NEXT:    vmaxnm.f64 d0, d1, d0
; FP16-NEXT:    vcmp.f64 d1, d1
; FP16-NEXT:    vminnm.f64 d0, d0, d2
; FP16-NEXT:    vcvt.s32.f64 s0, d0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 3
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI11_0:
; FP16-NEXT:    .long 0 @ double -128
; FP16-NEXT:    .long 3227516928
; FP16-NEXT:  .LCPI11_1:
; FP16-NEXT:    .long 0 @ double 127
; FP16-NEXT:    .long 1080016896
    %x = call i8 @llvm.fptosi.sat.i8.f64(double %f)
    ret i8 %x
}

define i13 @test_signed_i13_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i13_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    movs r4, #0
; SOFT-NEXT:    ldr r3, .LCPI12_0
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    bl __aeabi_d2iz
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB12_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    b .LBB12_3
; SOFT-NEXT:  .LBB12_2:
; SOFT-NEXT:    ldr r7, .LCPI12_1
; SOFT-NEXT:  .LBB12_3:
; SOFT-NEXT:    ldr r3, .LCPI12_2
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB12_5
; SOFT-NEXT:  @ %bb.4:
; SOFT-NEXT:    ldr r7, .LCPI12_3
; SOFT-NEXT:  .LBB12_5:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    bne .LBB12_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    mov r4, r7
; SOFT-NEXT:  .LBB12_7:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:  .LCPI12_0:
; SOFT-NEXT:    .long 3232759808 @ 0xc0b00000
; SOFT-NEXT:  .LCPI12_1:
; SOFT-NEXT:    .long 4294963200 @ 0xfffff000
; SOFT-NEXT:  .LCPI12_2:
; SOFT-NEXT:    .long 1085275648 @ 0x40affe00
; SOFT-NEXT:  .LCPI12_3:
; SOFT-NEXT:    .long 4095 @ 0xfff
;
; VFP2-LABEL: test_signed_i13_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov d16, r0, r1
; VFP2-NEXT:    vldr d17, .LCPI12_0
; VFP2-NEXT:    vldr d18, .LCPI12_1
; VFP2-NEXT:    vcvt.s32.f64 s0, d16
; VFP2-NEXT:    vcmp.f64 d16, d17
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    vcmp.f64 d16, d18
; VFP2-NEXT:    itt lt
; VFP2-NEXT:    movwlt r0, #61440
; VFP2-NEXT:    movtlt r0, #65535
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movwgt r0, #4095
; VFP2-NEXT:    vcmp.f64 d16, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    bx lr
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI12_0:
; VFP2-NEXT:    .long 0 @ double -4096
; VFP2-NEXT:    .long 3232759808
; VFP2-NEXT:  .LCPI12_1:
; VFP2-NEXT:    .long 0 @ double 4095
; VFP2-NEXT:    .long 1085275648
;
; FP16-LABEL: test_signed_i13_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    vldr d0, .LCPI12_0
; FP16-NEXT:    vmov d1, r0, r1
; FP16-NEXT:    vldr d2, .LCPI12_1
; FP16-NEXT:    vmaxnm.f64 d0, d1, d0
; FP16-NEXT:    vcmp.f64 d1, d1
; FP16-NEXT:    vminnm.f64 d0, d0, d2
; FP16-NEXT:    vcvt.s32.f64 s0, d0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 3
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI12_0:
; FP16-NEXT:    .long 0 @ double -4096
; FP16-NEXT:    .long 3232759808
; FP16-NEXT:  .LCPI12_1:
; FP16-NEXT:    .long 0 @ double 4095
; FP16-NEXT:    .long 1085275648
    %x = call i13 @llvm.fptosi.sat.i13.f64(double %f)
    ret i13 %x
}

define i16 @test_signed_i16_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i16_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    movs r4, #0
; SOFT-NEXT:    ldr r3, .LCPI13_0
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    bl __aeabi_d2iz
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB13_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    b .LBB13_3
; SOFT-NEXT:  .LBB13_2:
; SOFT-NEXT:    ldr r7, .LCPI13_1
; SOFT-NEXT:  .LBB13_3:
; SOFT-NEXT:    ldr r3, .LCPI13_2
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB13_5
; SOFT-NEXT:  @ %bb.4:
; SOFT-NEXT:    ldr r7, .LCPI13_3
; SOFT-NEXT:  .LBB13_5:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    bne .LBB13_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    mov r4, r7
; SOFT-NEXT:  .LBB13_7:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:  .LCPI13_0:
; SOFT-NEXT:    .long 3235905536 @ 0xc0e00000
; SOFT-NEXT:  .LCPI13_1:
; SOFT-NEXT:    .long 4294934528 @ 0xffff8000
; SOFT-NEXT:  .LCPI13_2:
; SOFT-NEXT:    .long 1088421824 @ 0x40dfffc0
; SOFT-NEXT:  .LCPI13_3:
; SOFT-NEXT:    .long 32767 @ 0x7fff
;
; VFP2-LABEL: test_signed_i16_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov d16, r0, r1
; VFP2-NEXT:    vldr d17, .LCPI13_0
; VFP2-NEXT:    vldr d18, .LCPI13_1
; VFP2-NEXT:    vcvt.s32.f64 s0, d16
; VFP2-NEXT:    vcmp.f64 d16, d17
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    vcmp.f64 d16, d18
; VFP2-NEXT:    itt lt
; VFP2-NEXT:    movwlt r0, #32768
; VFP2-NEXT:    movtlt r0, #65535
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movwgt r0, #32767
; VFP2-NEXT:    vcmp.f64 d16, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    bx lr
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI13_0:
; VFP2-NEXT:    .long 0 @ double -32768
; VFP2-NEXT:    .long 3235905536
; VFP2-NEXT:  .LCPI13_1:
; VFP2-NEXT:    .long 0 @ double 32767
; VFP2-NEXT:    .long 1088421824
;
; FP16-LABEL: test_signed_i16_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    vldr d0, .LCPI13_0
; FP16-NEXT:    vmov d1, r0, r1
; FP16-NEXT:    vldr d2, .LCPI13_1
; FP16-NEXT:    vmaxnm.f64 d0, d1, d0
; FP16-NEXT:    vcmp.f64 d1, d1
; FP16-NEXT:    vminnm.f64 d0, d0, d2
; FP16-NEXT:    vcvt.s32.f64 s0, d0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 3
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI13_0:
; FP16-NEXT:    .long 0 @ double -32768
; FP16-NEXT:    .long 3235905536
; FP16-NEXT:  .LCPI13_1:
; FP16-NEXT:    .long 0 @ double 32767
; FP16-NEXT:    .long 1088421824
    %x = call i16 @llvm.fptosi.sat.i16.f64(double %f)
    ret i16 %x
}

define i19 @test_signed_i19_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i19_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    movs r4, #0
; SOFT-NEXT:    ldr r3, .LCPI14_0
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    bl __aeabi_d2iz
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB14_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    b .LBB14_3
; SOFT-NEXT:  .LBB14_2:
; SOFT-NEXT:    ldr r7, .LCPI14_1
; SOFT-NEXT:  .LBB14_3:
; SOFT-NEXT:    ldr r3, .LCPI14_2
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB14_5
; SOFT-NEXT:  @ %bb.4:
; SOFT-NEXT:    ldr r7, .LCPI14_3
; SOFT-NEXT:  .LBB14_5:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    bne .LBB14_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    mov r4, r7
; SOFT-NEXT:  .LBB14_7:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:  .LCPI14_0:
; SOFT-NEXT:    .long 3239051264 @ 0xc1100000
; SOFT-NEXT:  .LCPI14_1:
; SOFT-NEXT:    .long 4294705152 @ 0xfffc0000
; SOFT-NEXT:  .LCPI14_2:
; SOFT-NEXT:    .long 1091567608 @ 0x410ffff8
; SOFT-NEXT:  .LCPI14_3:
; SOFT-NEXT:    .long 262143 @ 0x3ffff
;
; VFP2-LABEL: test_signed_i19_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov d16, r0, r1
; VFP2-NEXT:    vldr d17, .LCPI14_0
; VFP2-NEXT:    vldr d18, .LCPI14_1
; VFP2-NEXT:    vcvt.s32.f64 s0, d16
; VFP2-NEXT:    vcmp.f64 d16, d17
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    vcmp.f64 d16, d18
; VFP2-NEXT:    itt lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    movtlt r0, #65532
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itt gt
; VFP2-NEXT:    movwgt r0, #65535
; VFP2-NEXT:    movtgt r0, #3
; VFP2-NEXT:    vcmp.f64 d16, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    bx lr
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI14_0:
; VFP2-NEXT:    .long 0 @ double -262144
; VFP2-NEXT:    .long 3239051264
; VFP2-NEXT:  .LCPI14_1:
; VFP2-NEXT:    .long 0 @ double 262143
; VFP2-NEXT:    .long 1091567608
;
; FP16-LABEL: test_signed_i19_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    vldr d0, .LCPI14_0
; FP16-NEXT:    vmov d1, r0, r1
; FP16-NEXT:    vldr d2, .LCPI14_1
; FP16-NEXT:    vmaxnm.f64 d0, d1, d0
; FP16-NEXT:    vcmp.f64 d1, d1
; FP16-NEXT:    vminnm.f64 d0, d0, d2
; FP16-NEXT:    vcvt.s32.f64 s0, d0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 3
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI14_0:
; FP16-NEXT:    .long 0 @ double -262144
; FP16-NEXT:    .long 3239051264
; FP16-NEXT:  .LCPI14_1:
; FP16-NEXT:    .long 0 @ double 262143
; FP16-NEXT:    .long 1091567608
    %x = call i19 @llvm.fptosi.sat.i19.f64(double %f)
    ret i19 %x
}

define i32 @test_signed_i32_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i32_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    movs r4, #0
; SOFT-NEXT:    ldr r3, .LCPI15_0
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    bl __aeabi_d2iz
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB15_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    b .LBB15_3
; SOFT-NEXT:  .LBB15_2:
; SOFT-NEXT:    movs r0, #1
; SOFT-NEXT:    lsls r7, r0, #31
; SOFT-NEXT:  .LBB15_3:
; SOFT-NEXT:    ldr r2, .LCPI15_1
; SOFT-NEXT:    ldr r3, .LCPI15_2
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB15_5
; SOFT-NEXT:  @ %bb.4:
; SOFT-NEXT:    ldr r7, .LCPI15_3
; SOFT-NEXT:  .LBB15_5:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    bne .LBB15_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    mov r4, r7
; SOFT-NEXT:  .LBB15_7:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:  .LCPI15_0:
; SOFT-NEXT:    .long 3252682752 @ 0xc1e00000
; SOFT-NEXT:  .LCPI15_1:
; SOFT-NEXT:    .long 4290772992 @ 0xffc00000
; SOFT-NEXT:  .LCPI15_2:
; SOFT-NEXT:    .long 1105199103 @ 0x41dfffff
; SOFT-NEXT:  .LCPI15_3:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP2-LABEL: test_signed_i32_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    vmov d16, r0, r1
; VFP2-NEXT:    vcvt.s32.f64 s0, d16
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    bx lr
;
; FP16-LABEL: test_signed_i32_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    vmov d0, r0, r1
; FP16-NEXT:    vcvt.s32.f64 s0, d0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
    %x = call i32 @llvm.fptosi.sat.i32.f64(double %f)
    ret i32 %x
}

define i50 @test_signed_i50_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i50_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #12
; SOFT-NEXT:    sub sp, #12
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    movs r0, #195
; SOFT-NEXT:    lsls r3, r0, #24
; SOFT-NEXT:    movs r4, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    bl __aeabi_d2lz
; SOFT-NEXT:    str r0, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB16_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    str r7, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:  .LBB16_2:
; SOFT-NEXT:    beq .LBB16_4
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:    str r1, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    b .LBB16_5
; SOFT-NEXT:  .LBB16_4:
; SOFT-NEXT:    ldr r0, .LCPI16_0
; SOFT-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:  .LBB16_5:
; SOFT-NEXT:    movs r0, #15
; SOFT-NEXT:    mvns r2, r0
; SOFT-NEXT:    ldr r3, .LCPI16_1
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    mvns r7, r4
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB16_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    ldr r0, .LCPI16_2
; SOFT-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:  .LBB16_7:
; SOFT-NEXT:    bne .LBB16_9
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:    ldr r7, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:  .LBB16_9:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bne .LBB16_11
; SOFT-NEXT:  @ %bb.10:
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:  .LBB16_11:
; SOFT-NEXT:    bne .LBB16_13
; SOFT-NEXT:  @ %bb.12:
; SOFT-NEXT:    ldr r4, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:  .LBB16_13:
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    add sp, #12
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.14:
; SOFT-NEXT:  .LCPI16_0:
; SOFT-NEXT:    .long 4294836224 @ 0xfffe0000
; SOFT-NEXT:  .LCPI16_1:
; SOFT-NEXT:    .long 1124073471 @ 0x42ffffff
; SOFT-NEXT:  .LCPI16_2:
; SOFT-NEXT:    .long 131071 @ 0x1ffff
;
; VFP2-LABEL: test_signed_i50_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r4, r5, r7, lr}
; VFP2-NEXT:    push {r4, r5, r7, lr}
; VFP2-NEXT:    mov r4, r1
; VFP2-NEXT:    mov r5, r0
; VFP2-NEXT:    bl __aeabi_d2lz
; VFP2-NEXT:    vldr d16, .LCPI16_0
; VFP2-NEXT:    vmov d17, r5, r4
; VFP2-NEXT:    vldr d18, .LCPI16_1
; VFP2-NEXT:    vcmp.f64 d17, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    ittt lt
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    movtlt r1, #65534
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vcmp.f64 d17, d18
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r0, #-1
; VFP2-NEXT:    vcmp.f64 d17, d17
; VFP2-NEXT:    itt gt
; VFP2-NEXT:    movwgt r1, #65535
; VFP2-NEXT:    movtgt r1, #1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itt vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    pop {r4, r5, r7, pc}
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI16_0:
; VFP2-NEXT:    .long 0 @ double -562949953421312
; VFP2-NEXT:    .long 3271557120
; VFP2-NEXT:  .LCPI16_1:
; VFP2-NEXT:    .long 4294967280 @ double 562949953421311
; VFP2-NEXT:    .long 1124073471
;
; FP16-LABEL: test_signed_i50_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    .save {r7, lr}
; FP16-NEXT:    push {r7, lr}
; FP16-NEXT:    .vsave {d8}
; FP16-NEXT:    vpush {d8}
; FP16-NEXT:    vldr d0, .LCPI16_0
; FP16-NEXT:    vmov d8, r0, r1
; FP16-NEXT:    vldr d1, .LCPI16_1
; FP16-NEXT:    vmaxnm.f64 d0, d8, d0
; FP16-NEXT:    vminnm.f64 d0, d0, d1
; FP16-NEXT:    vmov r0, r1, d0
; FP16-NEXT:    bl __aeabi_d2lz
; FP16-NEXT:    vcmp.f64 d8, d8
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itt vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    movvs r1, #0
; FP16-NEXT:    vpop {d8}
; FP16-NEXT:    pop {r7, pc}
; FP16-NEXT:    .p2align 3
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI16_0:
; FP16-NEXT:    .long 0 @ double -562949953421312
; FP16-NEXT:    .long 3271557120
; FP16-NEXT:  .LCPI16_1:
; FP16-NEXT:    .long 4294967280 @ double 562949953421311
; FP16-NEXT:    .long 1124073471
    %x = call i50 @llvm.fptosi.sat.i50.f64(double %f)
    ret i50 %x
}

define i64 @test_signed_i64_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i64_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #12
; SOFT-NEXT:    sub sp, #12
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    movs r4, #0
; SOFT-NEXT:    ldr r3, .LCPI17_0
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    bl __aeabi_d2lz
; SOFT-NEXT:    str r0, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    movs r0, #1
; SOFT-NEXT:    lsls r0, r0, #31
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB17_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    str r7, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:  .LBB17_2:
; SOFT-NEXT:    beq .LBB17_4
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:    mov r0, r1
; SOFT-NEXT:  .LBB17_4:
; SOFT-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    mvns r7, r4
; SOFT-NEXT:    ldr r3, .LCPI17_1
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB17_6
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:    ldr r0, .LCPI17_2
; SOFT-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:  .LBB17_6:
; SOFT-NEXT:    bne .LBB17_8
; SOFT-NEXT:  @ %bb.7:
; SOFT-NEXT:    ldr r7, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:  .LBB17_8:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bne .LBB17_10
; SOFT-NEXT:  @ %bb.9:
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:  .LBB17_10:
; SOFT-NEXT:    bne .LBB17_12
; SOFT-NEXT:  @ %bb.11:
; SOFT-NEXT:    ldr r4, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:  .LBB17_12:
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    add sp, #12
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.13:
; SOFT-NEXT:  .LCPI17_0:
; SOFT-NEXT:    .long 3286237184 @ 0xc3e00000
; SOFT-NEXT:  .LCPI17_1:
; SOFT-NEXT:    .long 1138753535 @ 0x43dfffff
; SOFT-NEXT:  .LCPI17_2:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP2-LABEL: test_signed_i64_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r4, r5, r7, lr}
; VFP2-NEXT:    push {r4, r5, r7, lr}
; VFP2-NEXT:    mov r4, r1
; VFP2-NEXT:    mov r5, r0
; VFP2-NEXT:    bl __aeabi_d2lz
; VFP2-NEXT:    vldr d16, .LCPI17_0
; VFP2-NEXT:    vmov d17, r5, r4
; VFP2-NEXT:    vldr d18, .LCPI17_1
; VFP2-NEXT:    vcmp.f64 d17, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itt lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    movlt.w r1, #-2147483648
; VFP2-NEXT:    vcmp.f64 d17, d18
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itt gt
; VFP2-NEXT:    mvngt r1, #-2147483648
; VFP2-NEXT:    movgt.w r0, #-1
; VFP2-NEXT:    vcmp.f64 d17, d17
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itt vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    pop {r4, r5, r7, pc}
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI17_0:
; VFP2-NEXT:    .long 0 @ double -9.2233720368547758E+18
; VFP2-NEXT:    .long 3286237184
; VFP2-NEXT:  .LCPI17_1:
; VFP2-NEXT:    .long 4294967295 @ double 9.2233720368547748E+18
; VFP2-NEXT:    .long 1138753535
;
; FP16-LABEL: test_signed_i64_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    .save {r4, r5, r7, lr}
; FP16-NEXT:    push {r4, r5, r7, lr}
; FP16-NEXT:    mov r4, r1
; FP16-NEXT:    mov r5, r0
; FP16-NEXT:    bl __aeabi_d2lz
; FP16-NEXT:    vldr d0, .LCPI17_0
; FP16-NEXT:    vmov d1, r5, r4
; FP16-NEXT:    vldr d2, .LCPI17_1
; FP16-NEXT:    vcmp.f64 d1, d0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itt lt
; FP16-NEXT:    movlt r0, #0
; FP16-NEXT:    movlt.w r1, #-2147483648
; FP16-NEXT:    vcmp.f64 d1, d2
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itt gt
; FP16-NEXT:    mvngt r1, #-2147483648
; FP16-NEXT:    movgt.w r0, #-1
; FP16-NEXT:    vcmp.f64 d1, d1
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itt vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    movvs r1, #0
; FP16-NEXT:    pop {r4, r5, r7, pc}
; FP16-NEXT:    .p2align 3
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI17_0:
; FP16-NEXT:    .long 0 @ double -9.2233720368547758E+18
; FP16-NEXT:    .long 3286237184
; FP16-NEXT:  .LCPI17_1:
; FP16-NEXT:    .long 4294967295 @ double 9.2233720368547748E+18
; FP16-NEXT:    .long 1138753535
    %x = call i64 @llvm.fptosi.sat.i64.f64(double %f)
    ret i64 %x
}

define i100 @test_signed_i100_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i100_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #20
; SOFT-NEXT:    sub sp, #20
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    movs r4, #0
; SOFT-NEXT:    ldr r3, .LCPI18_0
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    bl __fixdfti
; SOFT-NEXT:    str r0, [sp, #12] @ 4-byte Spill
; SOFT-NEXT:    str r1, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    str r2, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    movs r0, #7
; SOFT-NEXT:    str r0, [sp, #16] @ 4-byte Spill
; SOFT-NEXT:    mvns r0, r0
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB18_17
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    beq .LBB18_18
; SOFT-NEXT:  .LBB18_2:
; SOFT-NEXT:    beq .LBB18_19
; SOFT-NEXT:  .LBB18_3:
; SOFT-NEXT:    beq .LBB18_5
; SOFT-NEXT:  .LBB18_4:
; SOFT-NEXT:    mov r0, r3
; SOFT-NEXT:  .LBB18_5:
; SOFT-NEXT:    str r0, [sp] @ 4-byte Spill
; SOFT-NEXT:    mvns r7, r4
; SOFT-NEXT:    ldr r3, .LCPI18_1
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB18_20
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    beq .LBB18_21
; SOFT-NEXT:  .LBB18_7:
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    bne .LBB18_9
; SOFT-NEXT:  .LBB18_8:
; SOFT-NEXT:    ldr r1, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:  .LBB18_9:
; SOFT-NEXT:    str r1, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    bne .LBB18_11
; SOFT-NEXT:  @ %bb.10:
; SOFT-NEXT:    ldr r7, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:  .LBB18_11:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    beq .LBB18_22
; SOFT-NEXT:  @ %bb.12:
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    beq .LBB18_23
; SOFT-NEXT:  .LBB18_13:
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    beq .LBB18_24
; SOFT-NEXT:  .LBB18_14:
; SOFT-NEXT:    bne .LBB18_16
; SOFT-NEXT:  .LBB18_15:
; SOFT-NEXT:    ldr r4, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:  .LBB18_16:
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    add sp, #20
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB18_17:
; SOFT-NEXT:    str r7, [sp, #12] @ 4-byte Spill
; SOFT-NEXT:    bne .LBB18_2
; SOFT-NEXT:  .LBB18_18:
; SOFT-NEXT:    str r7, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    bne .LBB18_3
; SOFT-NEXT:  .LBB18_19:
; SOFT-NEXT:    str r7, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    bne .LBB18_4
; SOFT-NEXT:    b .LBB18_5
; SOFT-NEXT:  .LBB18_20:
; SOFT-NEXT:    ldr r0, [sp] @ 4-byte Reload
; SOFT-NEXT:    str r0, [sp, #16] @ 4-byte Spill
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    bne .LBB18_7
; SOFT-NEXT:  .LBB18_21:
; SOFT-NEXT:    ldr r0, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    beq .LBB18_8
; SOFT-NEXT:    b .LBB18_9
; SOFT-NEXT:  .LBB18_22:
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bne .LBB18_13
; SOFT-NEXT:  .LBB18_23:
; SOFT-NEXT:    ldr r1, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    bne .LBB18_14
; SOFT-NEXT:  .LBB18_24:
; SOFT-NEXT:    ldr r2, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    beq .LBB18_15
; SOFT-NEXT:    b .LBB18_16
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.25:
; SOFT-NEXT:  .LCPI18_0:
; SOFT-NEXT:    .long 3323985920 @ 0xc6200000
; SOFT-NEXT:  .LCPI18_1:
; SOFT-NEXT:    .long 1176502271 @ 0x461fffff
;
; VFP2-LABEL: test_signed_i100_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r4, r5, r7, lr}
; VFP2-NEXT:    push {r4, r5, r7, lr}
; VFP2-NEXT:    mov r4, r1
; VFP2-NEXT:    mov r5, r0
; VFP2-NEXT:    bl __fixdfti
; VFP2-NEXT:    vldr d16, .LCPI18_0
; VFP2-NEXT:    vmov d17, r5, r4
; VFP2-NEXT:    vldr d18, .LCPI18_1
; VFP2-NEXT:    vcmp.f64 d17, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itttt lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    movlt r2, #0
; VFP2-NEXT:    mvnlt r3, #7
; VFP2-NEXT:    vcmp.f64 d17, d18
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itttt gt
; VFP2-NEXT:    movgt r3, #7
; VFP2-NEXT:    movgt.w r2, #-1
; VFP2-NEXT:    movgt.w r1, #-1
; VFP2-NEXT:    movgt.w r0, #-1
; VFP2-NEXT:    vcmp.f64 d17, d17
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itttt vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    movvs r2, #0
; VFP2-NEXT:    movvs r3, #0
; VFP2-NEXT:    pop {r4, r5, r7, pc}
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI18_0:
; VFP2-NEXT:    .long 0 @ double -6.338253001141147E+29
; VFP2-NEXT:    .long 3323985920
; VFP2-NEXT:  .LCPI18_1:
; VFP2-NEXT:    .long 4294967295 @ double 6.3382530011411463E+29
; VFP2-NEXT:    .long 1176502271
;
; FP16-LABEL: test_signed_i100_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    .save {r4, r5, r7, lr}
; FP16-NEXT:    push {r4, r5, r7, lr}
; FP16-NEXT:    mov r4, r1
; FP16-NEXT:    mov r5, r0
; FP16-NEXT:    bl __fixdfti
; FP16-NEXT:    vldr d0, .LCPI18_0
; FP16-NEXT:    vmov d1, r5, r4
; FP16-NEXT:    vldr d2, .LCPI18_1
; FP16-NEXT:    vcmp.f64 d1, d0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itttt lt
; FP16-NEXT:    movlt r0, #0
; FP16-NEXT:    movlt r1, #0
; FP16-NEXT:    movlt r2, #0
; FP16-NEXT:    mvnlt r3, #7
; FP16-NEXT:    vcmp.f64 d1, d2
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itttt gt
; FP16-NEXT:    movgt r3, #7
; FP16-NEXT:    movgt.w r2, #-1
; FP16-NEXT:    movgt.w r1, #-1
; FP16-NEXT:    movgt.w r0, #-1
; FP16-NEXT:    vcmp.f64 d1, d1
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itttt vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    movvs r1, #0
; FP16-NEXT:    movvs r2, #0
; FP16-NEXT:    movvs r3, #0
; FP16-NEXT:    pop {r4, r5, r7, pc}
; FP16-NEXT:    .p2align 3
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI18_0:
; FP16-NEXT:    .long 0 @ double -6.338253001141147E+29
; FP16-NEXT:    .long 3323985920
; FP16-NEXT:  .LCPI18_1:
; FP16-NEXT:    .long 4294967295 @ double 6.3382530011411463E+29
; FP16-NEXT:    .long 1176502271
    %x = call i100 @llvm.fptosi.sat.i100.f64(double %f)
    ret i100 %x
}

define i128 @test_signed_i128_f64(double %f) nounwind {
; SOFT-LABEL: test_signed_i128_f64:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #20
; SOFT-NEXT:    sub sp, #20
; SOFT-NEXT:    mov r5, r1
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    movs r4, #0
; SOFT-NEXT:    ldr r3, .LCPI19_0
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    bl __aeabi_dcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    bl __fixdfti
; SOFT-NEXT:    str r0, [sp, #12] @ 4-byte Spill
; SOFT-NEXT:    str r1, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    str r2, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    movs r0, #1
; SOFT-NEXT:    lsls r0, r0, #31
; SOFT-NEXT:    str r0, [sp, #16] @ 4-byte Spill
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB19_17
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    beq .LBB19_18
; SOFT-NEXT:  .LBB19_2:
; SOFT-NEXT:    beq .LBB19_19
; SOFT-NEXT:  .LBB19_3:
; SOFT-NEXT:    beq .LBB19_5
; SOFT-NEXT:  .LBB19_4:
; SOFT-NEXT:    str r3, [sp, #16] @ 4-byte Spill
; SOFT-NEXT:  .LBB19_5:
; SOFT-NEXT:    mvns r7, r4
; SOFT-NEXT:    ldr r3, .LCPI19_1
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r7
; SOFT-NEXT:    bl __aeabi_dcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    bne .LBB19_20
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    beq .LBB19_21
; SOFT-NEXT:  .LBB19_7:
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    bne .LBB19_9
; SOFT-NEXT:  .LBB19_8:
; SOFT-NEXT:    ldr r1, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:  .LBB19_9:
; SOFT-NEXT:    str r1, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    bne .LBB19_11
; SOFT-NEXT:  @ %bb.10:
; SOFT-NEXT:    ldr r7, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:  .LBB19_11:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    mov r3, r5
; SOFT-NEXT:    bl __aeabi_dcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    beq .LBB19_22
; SOFT-NEXT:  @ %bb.12:
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    beq .LBB19_23
; SOFT-NEXT:  .LBB19_13:
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    beq .LBB19_24
; SOFT-NEXT:  .LBB19_14:
; SOFT-NEXT:    bne .LBB19_16
; SOFT-NEXT:  .LBB19_15:
; SOFT-NEXT:    ldr r4, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:  .LBB19_16:
; SOFT-NEXT:    mov r3, r4
; SOFT-NEXT:    add sp, #20
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB19_17:
; SOFT-NEXT:    str r7, [sp, #12] @ 4-byte Spill
; SOFT-NEXT:    bne .LBB19_2
; SOFT-NEXT:  .LBB19_18:
; SOFT-NEXT:    str r7, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    bne .LBB19_3
; SOFT-NEXT:  .LBB19_19:
; SOFT-NEXT:    str r7, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    bne .LBB19_4
; SOFT-NEXT:    b .LBB19_5
; SOFT-NEXT:  .LBB19_20:
; SOFT-NEXT:    ldr r0, .LCPI19_2
; SOFT-NEXT:    str r0, [sp, #16] @ 4-byte Spill
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    bne .LBB19_7
; SOFT-NEXT:  .LBB19_21:
; SOFT-NEXT:    ldr r0, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    beq .LBB19_8
; SOFT-NEXT:    b .LBB19_9
; SOFT-NEXT:  .LBB19_22:
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bne .LBB19_13
; SOFT-NEXT:  .LBB19_23:
; SOFT-NEXT:    ldr r1, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:    mov r2, r4
; SOFT-NEXT:    bne .LBB19_14
; SOFT-NEXT:  .LBB19_24:
; SOFT-NEXT:    ldr r2, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    beq .LBB19_15
; SOFT-NEXT:    b .LBB19_16
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.25:
; SOFT-NEXT:  .LCPI19_0:
; SOFT-NEXT:    .long 3353346048 @ 0xc7e00000
; SOFT-NEXT:  .LCPI19_1:
; SOFT-NEXT:    .long 1205862399 @ 0x47dfffff
; SOFT-NEXT:  .LCPI19_2:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP2-LABEL: test_signed_i128_f64:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r4, r5, r7, lr}
; VFP2-NEXT:    push {r4, r5, r7, lr}
; VFP2-NEXT:    mov r4, r1
; VFP2-NEXT:    mov r5, r0
; VFP2-NEXT:    bl __fixdfti
; VFP2-NEXT:    vldr d16, .LCPI19_0
; VFP2-NEXT:    vmov d17, r5, r4
; VFP2-NEXT:    vldr d18, .LCPI19_1
; VFP2-NEXT:    vcmp.f64 d17, d16
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itttt lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    movlt r2, #0
; VFP2-NEXT:    movlt.w r3, #-2147483648
; VFP2-NEXT:    vcmp.f64 d17, d18
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itttt gt
; VFP2-NEXT:    mvngt r3, #-2147483648
; VFP2-NEXT:    movgt.w r2, #-1
; VFP2-NEXT:    movgt.w r1, #-1
; VFP2-NEXT:    movgt.w r0, #-1
; VFP2-NEXT:    vcmp.f64 d17, d17
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itttt vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    movvs r2, #0
; VFP2-NEXT:    movvs r3, #0
; VFP2-NEXT:    pop {r4, r5, r7, pc}
; VFP2-NEXT:    .p2align 3
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI19_0:
; VFP2-NEXT:    .long 0 @ double -1.7014118346046923E+38
; VFP2-NEXT:    .long 3353346048
; VFP2-NEXT:  .LCPI19_1:
; VFP2-NEXT:    .long 4294967295 @ double 1.7014118346046921E+38
; VFP2-NEXT:    .long 1205862399
;
; FP16-LABEL: test_signed_i128_f64:
; FP16:       @ %bb.0:
; FP16-NEXT:    .save {r4, r5, r7, lr}
; FP16-NEXT:    push {r4, r5, r7, lr}
; FP16-NEXT:    mov r4, r1
; FP16-NEXT:    mov r5, r0
; FP16-NEXT:    bl __fixdfti
; FP16-NEXT:    vldr d0, .LCPI19_0
; FP16-NEXT:    vmov d1, r5, r4
; FP16-NEXT:    vldr d2, .LCPI19_1
; FP16-NEXT:    vcmp.f64 d1, d0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itttt lt
; FP16-NEXT:    movlt r0, #0
; FP16-NEXT:    movlt r1, #0
; FP16-NEXT:    movlt r2, #0
; FP16-NEXT:    movlt.w r3, #-2147483648
; FP16-NEXT:    vcmp.f64 d1, d2
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itttt gt
; FP16-NEXT:    mvngt r3, #-2147483648
; FP16-NEXT:    movgt.w r2, #-1
; FP16-NEXT:    movgt.w r1, #-1
; FP16-NEXT:    movgt.w r0, #-1
; FP16-NEXT:    vcmp.f64 d1, d1
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itttt vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    movvs r1, #0
; FP16-NEXT:    movvs r2, #0
; FP16-NEXT:    movvs r3, #0
; FP16-NEXT:    pop {r4, r5, r7, pc}
; FP16-NEXT:    .p2align 3
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI19_0:
; FP16-NEXT:    .long 0 @ double -1.7014118346046923E+38
; FP16-NEXT:    .long 3353346048
; FP16-NEXT:  .LCPI19_1:
; FP16-NEXT:    .long 4294967295 @ double 1.7014118346046921E+38
; FP16-NEXT:    .long 1205862399
    %x = call i128 @llvm.fptosi.sat.i128.f64(double %f)
    ret i128 %x
}

;
; 16-bit float to signed integer
;

declare   i1 @llvm.fptosi.sat.i1.f16  (half)
declare   i8 @llvm.fptosi.sat.i8.f16  (half)
declare  i13 @llvm.fptosi.sat.i13.f16 (half)
declare  i16 @llvm.fptosi.sat.i16.f16 (half)
declare  i19 @llvm.fptosi.sat.i19.f16 (half)
declare  i32 @llvm.fptosi.sat.i32.f16 (half)
declare  i50 @llvm.fptosi.sat.i50.f16 (half)
declare  i64 @llvm.fptosi.sat.i64.f16 (half)
declare i100 @llvm.fptosi.sat.i100.f16(half)
declare i128 @llvm.fptosi.sat.i128.f16(half)

define i1 @test_signed_i1_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i1_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    ldr r1, .LCPI20_0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    movs r5, #0
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB20_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    b .LBB20_3
; SOFT-NEXT:  .LBB20_2:
; SOFT-NEXT:    mvns r6, r5
; SOFT-NEXT:  .LBB20_3:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r5
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:    bne .LBB20_5
; SOFT-NEXT:  @ %bb.4:
; SOFT-NEXT:    mov r7, r6
; SOFT-NEXT:  .LBB20_5:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    bne .LBB20_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    mov r5, r7
; SOFT-NEXT:  .LBB20_7:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:  .LCPI20_0:
; SOFT-NEXT:    .long 3212836864 @ 0xbf800000
;
; VFP2-LABEL: test_signed_i1_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s2, r0
; VFP2-NEXT:    vmov.f32 s0, #-1.000000e+00
; VFP2-NEXT:    vcvt.s32.f32 s4, s2
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    vmov r0, s4
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it lt
; VFP2-NEXT:    movlt.w r0, #-1
; VFP2-NEXT:    vcmp.f32 s2, #0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r0, #0
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    pop {r7, pc}
;
; FP16-LABEL: test_signed_i1_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vldr s2, .LCPI20_0
; FP16-NEXT:    vcvtb.f32.f16 s0, s0
; FP16-NEXT:    vmov.f32 s4, #-1.000000e+00
; FP16-NEXT:    vmaxnm.f32 s4, s0, s4
; FP16-NEXT:    vcmp.f32 s0, s0
; FP16-NEXT:    vminnm.f32 s2, s4, s2
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcvt.s32.f32 s2, s2
; FP16-NEXT:    vmov r0, s2
; FP16-NEXT:    it vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI20_0:
; FP16-NEXT:    .long 0x00000000 @ float 0
    %x = call i1 @llvm.fptosi.sat.i1.f16(half %f)
    ret i1 %x
}

define i8 @test_signed_i8_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i8_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r0, #195
; SOFT-NEXT:    lsls r1, r0, #24
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    movs r5, #127
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    beq .LBB21_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    b .LBB21_3
; SOFT-NEXT:  .LBB21_2:
; SOFT-NEXT:    mvns r6, r5
; SOFT-NEXT:  .LBB21_3:
; SOFT-NEXT:    ldr r1, .LCPI21_0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    bne .LBB21_5
; SOFT-NEXT:  @ %bb.4:
; SOFT-NEXT:    mov r5, r6
; SOFT-NEXT:  .LBB21_5:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB21_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    movs r5, #0
; SOFT-NEXT:  .LBB21_7:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:  .LCPI21_0:
; SOFT-NEXT:    .long 1123942400 @ 0x42fe0000
;
; VFP2-LABEL: test_signed_i8_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s2, .LCPI21_0
; VFP2-NEXT:    vldr s6, .LCPI21_1
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s6
; VFP2-NEXT:    vmov r0, s4
; VFP2-NEXT:    it lt
; VFP2-NEXT:    mvnlt r0, #127
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt r0, #127
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    pop {r7, pc}
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI21_0:
; VFP2-NEXT:    .long 0xc3000000 @ float -128
; VFP2-NEXT:  .LCPI21_1:
; VFP2-NEXT:    .long 0x42fe0000 @ float 127
;
; FP16-LABEL: test_signed_i8_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vldr s4, .LCPI21_1
; FP16-NEXT:    vcvtb.f32.f16 s0, s0
; FP16-NEXT:    vldr s2, .LCPI21_0
; FP16-NEXT:    vmaxnm.f32 s4, s0, s4
; FP16-NEXT:    vcmp.f32 s0, s0
; FP16-NEXT:    vminnm.f32 s2, s4, s2
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcvt.s32.f32 s2, s2
; FP16-NEXT:    vmov r0, s2
; FP16-NEXT:    it vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI21_0:
; FP16-NEXT:    .long 0x42fe0000 @ float 127
; FP16-NEXT:  .LCPI21_1:
; FP16-NEXT:    .long 0xc3000000 @ float -128
    %x = call i8 @llvm.fptosi.sat.i8.f16(half %f)
    ret i8 %x
}

define i13 @test_signed_i13_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i13_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    ldr r1, .LCPI22_0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB22_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    b .LBB22_3
; SOFT-NEXT:  .LBB22_2:
; SOFT-NEXT:    ldr r5, .LCPI22_1
; SOFT-NEXT:  .LBB22_3:
; SOFT-NEXT:    ldr r1, .LCPI22_2
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB22_5
; SOFT-NEXT:  @ %bb.4:
; SOFT-NEXT:    ldr r5, .LCPI22_3
; SOFT-NEXT:  .LBB22_5:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB22_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    movs r5, #0
; SOFT-NEXT:  .LBB22_7:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:  .LCPI22_0:
; SOFT-NEXT:    .long 3313500160 @ 0xc5800000
; SOFT-NEXT:  .LCPI22_1:
; SOFT-NEXT:    .long 4294963200 @ 0xfffff000
; SOFT-NEXT:  .LCPI22_2:
; SOFT-NEXT:    .long 1166012416 @ 0x457ff000
; SOFT-NEXT:  .LCPI22_3:
; SOFT-NEXT:    .long 4095 @ 0xfff
;
; VFP2-LABEL: test_signed_i13_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s2, .LCPI22_0
; VFP2-NEXT:    vldr s6, .LCPI22_1
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s6
; VFP2-NEXT:    vmov r0, s4
; VFP2-NEXT:    itt lt
; VFP2-NEXT:    movwlt r0, #61440
; VFP2-NEXT:    movtlt r0, #65535
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movwgt r0, #4095
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    pop {r7, pc}
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI22_0:
; VFP2-NEXT:    .long 0xc5800000 @ float -4096
; VFP2-NEXT:  .LCPI22_1:
; VFP2-NEXT:    .long 0x457ff000 @ float 4095
;
; FP16-LABEL: test_signed_i13_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vldr s4, .LCPI22_1
; FP16-NEXT:    vcvtb.f32.f16 s0, s0
; FP16-NEXT:    vldr s2, .LCPI22_0
; FP16-NEXT:    vmaxnm.f32 s4, s0, s4
; FP16-NEXT:    vcmp.f32 s0, s0
; FP16-NEXT:    vminnm.f32 s2, s4, s2
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcvt.s32.f32 s2, s2
; FP16-NEXT:    vmov r0, s2
; FP16-NEXT:    it vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI22_0:
; FP16-NEXT:    .long 0x457ff000 @ float 4095
; FP16-NEXT:  .LCPI22_1:
; FP16-NEXT:    .long 0xc5800000 @ float -4096
    %x = call i13 @llvm.fptosi.sat.i13.f16(half %f)
    ret i13 %x
}

define i16 @test_signed_i16_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i16_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r0, #199
; SOFT-NEXT:    lsls r1, r0, #24
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB23_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    b .LBB23_3
; SOFT-NEXT:  .LBB23_2:
; SOFT-NEXT:    ldr r5, .LCPI23_0
; SOFT-NEXT:  .LBB23_3:
; SOFT-NEXT:    ldr r1, .LCPI23_1
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB23_5
; SOFT-NEXT:  @ %bb.4:
; SOFT-NEXT:    ldr r5, .LCPI23_2
; SOFT-NEXT:  .LBB23_5:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB23_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    movs r5, #0
; SOFT-NEXT:  .LBB23_7:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:  .LCPI23_0:
; SOFT-NEXT:    .long 4294934528 @ 0xffff8000
; SOFT-NEXT:  .LCPI23_1:
; SOFT-NEXT:    .long 1191181824 @ 0x46fffe00
; SOFT-NEXT:  .LCPI23_2:
; SOFT-NEXT:    .long 32767 @ 0x7fff
;
; VFP2-LABEL: test_signed_i16_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s2, .LCPI23_0
; VFP2-NEXT:    vldr s6, .LCPI23_1
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s6
; VFP2-NEXT:    vmov r0, s4
; VFP2-NEXT:    itt lt
; VFP2-NEXT:    movwlt r0, #32768
; VFP2-NEXT:    movtlt r0, #65535
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movwgt r0, #32767
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    pop {r7, pc}
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI23_0:
; VFP2-NEXT:    .long 0xc7000000 @ float -32768
; VFP2-NEXT:  .LCPI23_1:
; VFP2-NEXT:    .long 0x46fffe00 @ float 32767
;
; FP16-LABEL: test_signed_i16_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vldr s4, .LCPI23_1
; FP16-NEXT:    vcvtb.f32.f16 s0, s0
; FP16-NEXT:    vldr s2, .LCPI23_0
; FP16-NEXT:    vmaxnm.f32 s4, s0, s4
; FP16-NEXT:    vcmp.f32 s0, s0
; FP16-NEXT:    vminnm.f32 s2, s4, s2
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcvt.s32.f32 s2, s2
; FP16-NEXT:    vmov r0, s2
; FP16-NEXT:    it vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI23_0:
; FP16-NEXT:    .long 0x46fffe00 @ float 32767
; FP16-NEXT:  .LCPI23_1:
; FP16-NEXT:    .long 0xc7000000 @ float -32768
    %x = call i16 @llvm.fptosi.sat.i16.f16(half %f)
    ret i16 %x
}

define i19 @test_signed_i19_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i19_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    ldr r1, .LCPI24_0
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB24_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    b .LBB24_3
; SOFT-NEXT:  .LBB24_2:
; SOFT-NEXT:    ldr r5, .LCPI24_1
; SOFT-NEXT:  .LBB24_3:
; SOFT-NEXT:    ldr r1, .LCPI24_2
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB24_5
; SOFT-NEXT:  @ %bb.4:
; SOFT-NEXT:    ldr r5, .LCPI24_3
; SOFT-NEXT:  .LBB24_5:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB24_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    movs r5, #0
; SOFT-NEXT:  .LBB24_7:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:  .LCPI24_0:
; SOFT-NEXT:    .long 3363831808 @ 0xc8800000
; SOFT-NEXT:  .LCPI24_1:
; SOFT-NEXT:    .long 4294705152 @ 0xfffc0000
; SOFT-NEXT:  .LCPI24_2:
; SOFT-NEXT:    .long 1216348096 @ 0x487fffc0
; SOFT-NEXT:  .LCPI24_3:
; SOFT-NEXT:    .long 262143 @ 0x3ffff
;
; VFP2-LABEL: test_signed_i19_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vldr s2, .LCPI24_0
; VFP2-NEXT:    vldr s6, .LCPI24_1
; VFP2-NEXT:    vcvt.s32.f32 s4, s0
; VFP2-NEXT:    vcmp.f32 s0, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s6
; VFP2-NEXT:    vmov r0, s4
; VFP2-NEXT:    itt lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    movtlt r0, #65532
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    vcmp.f32 s0, s0
; VFP2-NEXT:    itt gt
; VFP2-NEXT:    movwgt r0, #65535
; VFP2-NEXT:    movtgt r0, #3
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    pop {r7, pc}
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI24_0:
; VFP2-NEXT:    .long 0xc8800000 @ float -262144
; VFP2-NEXT:  .LCPI24_1:
; VFP2-NEXT:    .long 0x487fffc0 @ float 262143
;
; FP16-LABEL: test_signed_i19_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vldr s4, .LCPI24_1
; FP16-NEXT:    vcvtb.f32.f16 s0, s0
; FP16-NEXT:    vldr s2, .LCPI24_0
; FP16-NEXT:    vmaxnm.f32 s4, s0, s4
; FP16-NEXT:    vcmp.f32 s0, s0
; FP16-NEXT:    vminnm.f32 s2, s4, s2
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    vcvt.s32.f32 s2, s2
; FP16-NEXT:    vmov r0, s2
; FP16-NEXT:    it vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    bx lr
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI24_0:
; FP16-NEXT:    .long 0x487fffc0 @ float 262143
; FP16-NEXT:  .LCPI24_1:
; FP16-NEXT:    .long 0xc8800000 @ float -262144
    %x = call i19 @llvm.fptosi.sat.i19.f16(half %f)
    ret i19 %x
}

define i32 @test_signed_i32_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i32_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, lr}
; SOFT-NEXT:    push {r4, r5, r6, lr}
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r0, #207
; SOFT-NEXT:    lsls r1, r0, #24
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2iz
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB25_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    b .LBB25_3
; SOFT-NEXT:  .LBB25_2:
; SOFT-NEXT:    movs r0, #1
; SOFT-NEXT:    lsls r5, r0, #31
; SOFT-NEXT:  .LBB25_3:
; SOFT-NEXT:    ldr r1, .LCPI25_0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB25_5
; SOFT-NEXT:  @ %bb.4:
; SOFT-NEXT:    ldr r5, .LCPI25_1
; SOFT-NEXT:  .LBB25_5:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB25_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    movs r5, #0
; SOFT-NEXT:  .LBB25_7:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    pop {r4, r5, r6, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:  .LCPI25_0:
; SOFT-NEXT:    .long 1325400063 @ 0x4effffff
; SOFT-NEXT:  .LCPI25_1:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP2-LABEL: test_signed_i32_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r7, lr}
; VFP2-NEXT:    push {r7, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    vmov s0, r0
; VFP2-NEXT:    vcvt.s32.f32 s0, s0
; VFP2-NEXT:    vmov r0, s0
; VFP2-NEXT:    pop {r7, pc}
;
; FP16-LABEL: test_signed_i32_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vcvt.s32.f16 s0, s0
; FP16-NEXT:    vmov r0, s0
; FP16-NEXT:    bx lr
    %x = call i32 @llvm.fptosi.sat.i32.f16(half %f)
    ret i32 %x
}

define i50 @test_signed_i50_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i50_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r0, #27
; SOFT-NEXT:    lsls r1, r0, #27
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r7, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    mov r5, r0
; SOFT-NEXT:    cmp r7, #0
; SOFT-NEXT:    bne .LBB26_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r5, r7
; SOFT-NEXT:  .LBB26_2:
; SOFT-NEXT:    beq .LBB26_4
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:    str r1, [sp] @ 4-byte Spill
; SOFT-NEXT:    b .LBB26_5
; SOFT-NEXT:  .LBB26_4:
; SOFT-NEXT:    ldr r0, .LCPI26_0
; SOFT-NEXT:    str r0, [sp] @ 4-byte Spill
; SOFT-NEXT:  .LBB26_5:
; SOFT-NEXT:    ldr r1, .LCPI26_1
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    movs r7, #0
; SOFT-NEXT:    mvns r6, r7
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB26_7
; SOFT-NEXT:  @ %bb.6:
; SOFT-NEXT:    ldr r0, .LCPI26_2
; SOFT-NEXT:    str r0, [sp] @ 4-byte Spill
; SOFT-NEXT:  .LBB26_7:
; SOFT-NEXT:    bne .LBB26_9
; SOFT-NEXT:  @ %bb.8:
; SOFT-NEXT:    mov r6, r5
; SOFT-NEXT:  .LBB26_9:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r7
; SOFT-NEXT:    bne .LBB26_11
; SOFT-NEXT:  @ %bb.10:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:  .LBB26_11:
; SOFT-NEXT:    bne .LBB26_13
; SOFT-NEXT:  @ %bb.12:
; SOFT-NEXT:    ldr r7, [sp] @ 4-byte Reload
; SOFT-NEXT:  .LBB26_13:
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.14:
; SOFT-NEXT:  .LCPI26_0:
; SOFT-NEXT:    .long 4294836224 @ 0xfffe0000
; SOFT-NEXT:  .LCPI26_1:
; SOFT-NEXT:    .long 1476395007 @ 0x57ffffff
; SOFT-NEXT:  .LCPI26_2:
; SOFT-NEXT:    .long 131071 @ 0x1ffff
;
; VFP2-LABEL: test_signed_i50_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r4, lr}
; VFP2-NEXT:    push {r4, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    mov r4, r0
; VFP2-NEXT:    bl __aeabi_f2lz
; VFP2-NEXT:    vldr s0, .LCPI26_0
; VFP2-NEXT:    vmov s2, r4
; VFP2-NEXT:    vldr s4, .LCPI26_1
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    ittt lt
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    movtlt r1, #65534
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    it gt
; VFP2-NEXT:    movgt.w r0, #-1
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    itt gt
; VFP2-NEXT:    movwgt r1, #65535
; VFP2-NEXT:    movtgt r1, #1
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itt vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    pop {r4, pc}
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI26_0:
; VFP2-NEXT:    .long 0xd8000000 @ float -5.62949953E+14
; VFP2-NEXT:  .LCPI26_1:
; VFP2-NEXT:    .long 0x57ffffff @ float 5.6294992E+14
;
; FP16-LABEL: test_signed_i50_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    .save {r7, lr}
; FP16-NEXT:    push {r7, lr}
; FP16-NEXT:    .vsave {d8}
; FP16-NEXT:    vpush {d8}
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vcvtb.f32.f16 s16, s0
; FP16-NEXT:    vmov r0, s16
; FP16-NEXT:    bl __aeabi_f2lz
; FP16-NEXT:    vldr s0, .LCPI26_0
; FP16-NEXT:    vldr s2, .LCPI26_1
; FP16-NEXT:    vcmp.f32 s16, s0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    ittt lt
; FP16-NEXT:    movlt r1, #0
; FP16-NEXT:    movtlt r1, #65534
; FP16-NEXT:    movlt r0, #0
; FP16-NEXT:    vcmp.f32 s16, s2
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    it gt
; FP16-NEXT:    movgt.w r0, #-1
; FP16-NEXT:    vcmp.f32 s16, s16
; FP16-NEXT:    itt gt
; FP16-NEXT:    movwgt r1, #65535
; FP16-NEXT:    movtgt r1, #1
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itt vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    movvs r1, #0
; FP16-NEXT:    vpop {d8}
; FP16-NEXT:    pop {r7, pc}
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI26_0:
; FP16-NEXT:    .long 0xd8000000 @ float -5.62949953E+14
; FP16-NEXT:  .LCPI26_1:
; FP16-NEXT:    .long 0x57ffffff @ float 5.6294992E+14
    %x = call i50 @llvm.fptosi.sat.i50.f16(half %f)
    ret i50 %x
}

define i64 @test_signed_i64_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i64_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #4
; SOFT-NEXT:    sub sp, #4
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r0, #223
; SOFT-NEXT:    lsls r1, r0, #24
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_f2lz
; SOFT-NEXT:    movs r2, #1
; SOFT-NEXT:    lsls r7, r2, #31
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    bne .LBB27_2
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:  .LBB27_2:
; SOFT-NEXT:    str r0, [sp] @ 4-byte Spill
; SOFT-NEXT:    beq .LBB27_4
; SOFT-NEXT:  @ %bb.3:
; SOFT-NEXT:    mov r7, r1
; SOFT-NEXT:  .LBB27_4:
; SOFT-NEXT:    ldr r1, .LCPI27_0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    mvns r5, r6
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB27_6
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:    ldr r7, .LCPI27_1
; SOFT-NEXT:  .LBB27_6:
; SOFT-NEXT:    bne .LBB27_8
; SOFT-NEXT:  @ %bb.7:
; SOFT-NEXT:    ldr r5, [sp] @ 4-byte Reload
; SOFT-NEXT:  .LBB27_8:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bne .LBB27_10
; SOFT-NEXT:  @ %bb.9:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:  .LBB27_10:
; SOFT-NEXT:    bne .LBB27_12
; SOFT-NEXT:  @ %bb.11:
; SOFT-NEXT:    mov r6, r7
; SOFT-NEXT:  .LBB27_12:
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    add sp, #4
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.13:
; SOFT-NEXT:  .LCPI27_0:
; SOFT-NEXT:    .long 1593835519 @ 0x5effffff
; SOFT-NEXT:  .LCPI27_1:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP2-LABEL: test_signed_i64_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r4, lr}
; VFP2-NEXT:    push {r4, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    mov r4, r0
; VFP2-NEXT:    bl __aeabi_f2lz
; VFP2-NEXT:    vldr s0, .LCPI27_0
; VFP2-NEXT:    vmov s2, r4
; VFP2-NEXT:    vldr s4, .LCPI27_1
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itt lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    movlt.w r1, #-2147483648
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itt gt
; VFP2-NEXT:    mvngt r1, #-2147483648
; VFP2-NEXT:    movgt.w r0, #-1
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itt vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    pop {r4, pc}
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI27_0:
; VFP2-NEXT:    .long 0xdf000000 @ float -9.22337203E+18
; VFP2-NEXT:  .LCPI27_1:
; VFP2-NEXT:    .long 0x5effffff @ float 9.22337149E+18
;
; FP16-LABEL: test_signed_i64_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    .save {r7, lr}
; FP16-NEXT:    push {r7, lr}
; FP16-NEXT:    .vsave {d8}
; FP16-NEXT:    vpush {d8}
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vcvtb.f32.f16 s16, s0
; FP16-NEXT:    vmov r0, s16
; FP16-NEXT:    bl __aeabi_f2lz
; FP16-NEXT:    vldr s0, .LCPI27_0
; FP16-NEXT:    vldr s2, .LCPI27_1
; FP16-NEXT:    vcmp.f32 s16, s0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itt lt
; FP16-NEXT:    movlt r0, #0
; FP16-NEXT:    movlt.w r1, #-2147483648
; FP16-NEXT:    vcmp.f32 s16, s2
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itt gt
; FP16-NEXT:    mvngt r1, #-2147483648
; FP16-NEXT:    movgt.w r0, #-1
; FP16-NEXT:    vcmp.f32 s16, s16
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itt vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    movvs r1, #0
; FP16-NEXT:    vpop {d8}
; FP16-NEXT:    pop {r7, pc}
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI27_0:
; FP16-NEXT:    .long 0xdf000000 @ float -9.22337203E+18
; FP16-NEXT:  .LCPI27_1:
; FP16-NEXT:    .long 0x5effffff @ float 9.22337149E+18
    %x = call i64 @llvm.fptosi.sat.i64.f16(half %f)
    ret i64 %x
}

define i100 @test_signed_i100_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i100_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #20
; SOFT-NEXT:    sub sp, #20
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r0, #241
; SOFT-NEXT:    lsls r1, r0, #24
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __fixsfti
; SOFT-NEXT:    movs r5, #7
; SOFT-NEXT:    str r5, [sp, #16] @ 4-byte Spill
; SOFT-NEXT:    mvns r7, r5
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB28_17
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    beq .LBB28_18
; SOFT-NEXT:  .LBB28_2:
; SOFT-NEXT:    bne .LBB28_4
; SOFT-NEXT:  .LBB28_3:
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:  .LBB28_4:
; SOFT-NEXT:    str r2, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    str r1, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    str r0, [sp, #12] @ 4-byte Spill
; SOFT-NEXT:    beq .LBB28_6
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:    mov r7, r3
; SOFT-NEXT:  .LBB28_6:
; SOFT-NEXT:    ldr r1, .LCPI28_0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    mvns r5, r6
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB28_19
; SOFT-NEXT:  @ %bb.7:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    beq .LBB28_20
; SOFT-NEXT:  .LBB28_8:
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:    beq .LBB28_21
; SOFT-NEXT:  .LBB28_9:
; SOFT-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    bne .LBB28_11
; SOFT-NEXT:  .LBB28_10:
; SOFT-NEXT:    ldr r5, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:  .LBB28_11:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    beq .LBB28_22
; SOFT-NEXT:  @ %bb.12:
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    beq .LBB28_23
; SOFT-NEXT:  .LBB28_13:
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    beq .LBB28_24
; SOFT-NEXT:  .LBB28_14:
; SOFT-NEXT:    bne .LBB28_16
; SOFT-NEXT:  .LBB28_15:
; SOFT-NEXT:    ldr r6, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:  .LBB28_16:
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:    add sp, #20
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB28_17:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bne .LBB28_2
; SOFT-NEXT:  .LBB28_18:
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    beq .LBB28_3
; SOFT-NEXT:    b .LBB28_4
; SOFT-NEXT:  .LBB28_19:
; SOFT-NEXT:    str r7, [sp, #16] @ 4-byte Spill
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    bne .LBB28_8
; SOFT-NEXT:  .LBB28_20:
; SOFT-NEXT:    ldr r0, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:    bne .LBB28_9
; SOFT-NEXT:  .LBB28_21:
; SOFT-NEXT:    ldr r7, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    beq .LBB28_10
; SOFT-NEXT:    b .LBB28_11
; SOFT-NEXT:  .LBB28_22:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    bne .LBB28_13
; SOFT-NEXT:  .LBB28_23:
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    bne .LBB28_14
; SOFT-NEXT:  .LBB28_24:
; SOFT-NEXT:    ldr r2, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    beq .LBB28_15
; SOFT-NEXT:    b .LBB28_16
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.25:
; SOFT-NEXT:  .LCPI28_0:
; SOFT-NEXT:    .long 1895825407 @ 0x70ffffff
;
; VFP2-LABEL: test_signed_i100_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r4, lr}
; VFP2-NEXT:    push {r4, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    mov r4, r0
; VFP2-NEXT:    bl __fixsfti
; VFP2-NEXT:    vldr s0, .LCPI28_0
; VFP2-NEXT:    vmov s2, r4
; VFP2-NEXT:    vldr s4, .LCPI28_1
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itttt lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    movlt r2, #0
; VFP2-NEXT:    mvnlt r3, #7
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itttt gt
; VFP2-NEXT:    movgt r3, #7
; VFP2-NEXT:    movgt.w r2, #-1
; VFP2-NEXT:    movgt.w r1, #-1
; VFP2-NEXT:    movgt.w r0, #-1
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itttt vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    movvs r2, #0
; VFP2-NEXT:    movvs r3, #0
; VFP2-NEXT:    pop {r4, pc}
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI28_0:
; VFP2-NEXT:    .long 0xf1000000 @ float -6.338253E+29
; VFP2-NEXT:  .LCPI28_1:
; VFP2-NEXT:    .long 0x70ffffff @ float 6.33825262E+29
;
; FP16-LABEL: test_signed_i100_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    .save {r7, lr}
; FP16-NEXT:    push {r7, lr}
; FP16-NEXT:    .vsave {d8}
; FP16-NEXT:    vpush {d8}
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vcvtb.f32.f16 s16, s0
; FP16-NEXT:    vmov r0, s16
; FP16-NEXT:    bl __fixsfti
; FP16-NEXT:    vldr s0, .LCPI28_0
; FP16-NEXT:    vldr s2, .LCPI28_1
; FP16-NEXT:    vcmp.f32 s16, s0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itttt lt
; FP16-NEXT:    movlt r0, #0
; FP16-NEXT:    movlt r1, #0
; FP16-NEXT:    movlt r2, #0
; FP16-NEXT:    mvnlt r3, #7
; FP16-NEXT:    vcmp.f32 s16, s2
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itttt gt
; FP16-NEXT:    movgt r3, #7
; FP16-NEXT:    movgt.w r2, #-1
; FP16-NEXT:    movgt.w r1, #-1
; FP16-NEXT:    movgt.w r0, #-1
; FP16-NEXT:    vcmp.f32 s16, s16
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itttt vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    movvs r1, #0
; FP16-NEXT:    movvs r2, #0
; FP16-NEXT:    movvs r3, #0
; FP16-NEXT:    vpop {d8}
; FP16-NEXT:    pop {r7, pc}
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI28_0:
; FP16-NEXT:    .long 0xf1000000 @ float -6.338253E+29
; FP16-NEXT:  .LCPI28_1:
; FP16-NEXT:    .long 0x70ffffff @ float 6.33825262E+29
    %x = call i100 @llvm.fptosi.sat.i100.f16(half %f)
    ret i100 %x
}

define i128 @test_signed_i128_f16(half %f) nounwind {
; SOFT-LABEL: test_signed_i128_f16:
; SOFT:       @ %bb.0:
; SOFT-NEXT:    .save {r4, r5, r6, r7, lr}
; SOFT-NEXT:    push {r4, r5, r6, r7, lr}
; SOFT-NEXT:    .pad #20
; SOFT-NEXT:    sub sp, #20
; SOFT-NEXT:    uxth r0, r0
; SOFT-NEXT:    bl __aeabi_h2f
; SOFT-NEXT:    mov r4, r0
; SOFT-NEXT:    movs r0, #255
; SOFT-NEXT:    lsls r1, r0, #24
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpge
; SOFT-NEXT:    mov r6, r0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __fixsfti
; SOFT-NEXT:    movs r5, #1
; SOFT-NEXT:    lsls r7, r5, #31
; SOFT-NEXT:    cmp r6, #0
; SOFT-NEXT:    beq .LBB29_18
; SOFT-NEXT:  @ %bb.1:
; SOFT-NEXT:    beq .LBB29_19
; SOFT-NEXT:  .LBB29_2:
; SOFT-NEXT:    bne .LBB29_4
; SOFT-NEXT:  .LBB29_3:
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:  .LBB29_4:
; SOFT-NEXT:    str r2, [sp, #4] @ 4-byte Spill
; SOFT-NEXT:    str r1, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    str r0, [sp, #12] @ 4-byte Spill
; SOFT-NEXT:    beq .LBB29_6
; SOFT-NEXT:  @ %bb.5:
; SOFT-NEXT:    mov r7, r3
; SOFT-NEXT:  .LBB29_6:
; SOFT-NEXT:    ldr r1, .LCPI29_0
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    bl __aeabi_fcmpgt
; SOFT-NEXT:    movs r6, #0
; SOFT-NEXT:    mvns r5, r6
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    beq .LBB29_8
; SOFT-NEXT:  @ %bb.7:
; SOFT-NEXT:    ldr r7, .LCPI29_1
; SOFT-NEXT:  .LBB29_8:
; SOFT-NEXT:    str r7, [sp, #16] @ 4-byte Spill
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    beq .LBB29_20
; SOFT-NEXT:  @ %bb.9:
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:    beq .LBB29_21
; SOFT-NEXT:  .LBB29_10:
; SOFT-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    bne .LBB29_12
; SOFT-NEXT:  .LBB29_11:
; SOFT-NEXT:    ldr r5, [sp, #12] @ 4-byte Reload
; SOFT-NEXT:  .LBB29_12:
; SOFT-NEXT:    mov r0, r4
; SOFT-NEXT:    mov r1, r4
; SOFT-NEXT:    bl __aeabi_fcmpun
; SOFT-NEXT:    cmp r0, #0
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    beq .LBB29_22
; SOFT-NEXT:  @ %bb.13:
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    beq .LBB29_23
; SOFT-NEXT:  .LBB29_14:
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    beq .LBB29_24
; SOFT-NEXT:  .LBB29_15:
; SOFT-NEXT:    ldr r3, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:    bne .LBB29_17
; SOFT-NEXT:  .LBB29_16:
; SOFT-NEXT:    mov r6, r3
; SOFT-NEXT:  .LBB29_17:
; SOFT-NEXT:    mov r3, r6
; SOFT-NEXT:    add sp, #20
; SOFT-NEXT:    pop {r4, r5, r6, r7, pc}
; SOFT-NEXT:  .LBB29_18:
; SOFT-NEXT:    mov r0, r6
; SOFT-NEXT:    bne .LBB29_2
; SOFT-NEXT:  .LBB29_19:
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    beq .LBB29_3
; SOFT-NEXT:    b .LBB29_4
; SOFT-NEXT:  .LBB29_20:
; SOFT-NEXT:    ldr r0, [sp, #4] @ 4-byte Reload
; SOFT-NEXT:    mov r7, r5
; SOFT-NEXT:    bne .LBB29_10
; SOFT-NEXT:  .LBB29_21:
; SOFT-NEXT:    ldr r7, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; SOFT-NEXT:    beq .LBB29_11
; SOFT-NEXT:    b .LBB29_12
; SOFT-NEXT:  .LBB29_22:
; SOFT-NEXT:    mov r0, r5
; SOFT-NEXT:    mov r1, r6
; SOFT-NEXT:    bne .LBB29_14
; SOFT-NEXT:  .LBB29_23:
; SOFT-NEXT:    mov r1, r7
; SOFT-NEXT:    mov r2, r6
; SOFT-NEXT:    bne .LBB29_15
; SOFT-NEXT:  .LBB29_24:
; SOFT-NEXT:    ldr r2, [sp, #8] @ 4-byte Reload
; SOFT-NEXT:    ldr r3, [sp, #16] @ 4-byte Reload
; SOFT-NEXT:    beq .LBB29_16
; SOFT-NEXT:    b .LBB29_17
; SOFT-NEXT:    .p2align 2
; SOFT-NEXT:  @ %bb.25:
; SOFT-NEXT:  .LCPI29_0:
; SOFT-NEXT:    .long 2130706431 @ 0x7effffff
; SOFT-NEXT:  .LCPI29_1:
; SOFT-NEXT:    .long 2147483647 @ 0x7fffffff
;
; VFP2-LABEL: test_signed_i128_f16:
; VFP2:       @ %bb.0:
; VFP2-NEXT:    .save {r4, lr}
; VFP2-NEXT:    push {r4, lr}
; VFP2-NEXT:    bl __aeabi_h2f
; VFP2-NEXT:    mov r4, r0
; VFP2-NEXT:    bl __fixsfti
; VFP2-NEXT:    vldr s0, .LCPI29_0
; VFP2-NEXT:    vmov s2, r4
; VFP2-NEXT:    vldr s4, .LCPI29_1
; VFP2-NEXT:    vcmp.f32 s2, s0
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itttt lt
; VFP2-NEXT:    movlt r0, #0
; VFP2-NEXT:    movlt r1, #0
; VFP2-NEXT:    movlt r2, #0
; VFP2-NEXT:    movlt.w r3, #-2147483648
; VFP2-NEXT:    vcmp.f32 s2, s4
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itttt gt
; VFP2-NEXT:    mvngt r3, #-2147483648
; VFP2-NEXT:    movgt.w r2, #-1
; VFP2-NEXT:    movgt.w r1, #-1
; VFP2-NEXT:    movgt.w r0, #-1
; VFP2-NEXT:    vcmp.f32 s2, s2
; VFP2-NEXT:    vmrs APSR_nzcv, fpscr
; VFP2-NEXT:    itttt vs
; VFP2-NEXT:    movvs r0, #0
; VFP2-NEXT:    movvs r1, #0
; VFP2-NEXT:    movvs r2, #0
; VFP2-NEXT:    movvs r3, #0
; VFP2-NEXT:    pop {r4, pc}
; VFP2-NEXT:    .p2align 2
; VFP2-NEXT:  @ %bb.1:
; VFP2-NEXT:  .LCPI29_0:
; VFP2-NEXT:    .long 0xff000000 @ float -1.70141183E+38
; VFP2-NEXT:  .LCPI29_1:
; VFP2-NEXT:    .long 0x7effffff @ float 1.70141173E+38
;
; FP16-LABEL: test_signed_i128_f16:
; FP16:       @ %bb.0:
; FP16-NEXT:    .save {r7, lr}
; FP16-NEXT:    push {r7, lr}
; FP16-NEXT:    .vsave {d8}
; FP16-NEXT:    vpush {d8}
; FP16-NEXT:    vmov.f16 s0, r0
; FP16-NEXT:    vcvtb.f32.f16 s16, s0
; FP16-NEXT:    vmov r0, s16
; FP16-NEXT:    bl __fixsfti
; FP16-NEXT:    vldr s0, .LCPI29_0
; FP16-NEXT:    vldr s2, .LCPI29_1
; FP16-NEXT:    vcmp.f32 s16, s0
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itttt lt
; FP16-NEXT:    movlt r0, #0
; FP16-NEXT:    movlt r1, #0
; FP16-NEXT:    movlt r2, #0
; FP16-NEXT:    movlt.w r3, #-2147483648
; FP16-NEXT:    vcmp.f32 s16, s2
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itttt gt
; FP16-NEXT:    mvngt r3, #-2147483648
; FP16-NEXT:    movgt.w r2, #-1
; FP16-NEXT:    movgt.w r1, #-1
; FP16-NEXT:    movgt.w r0, #-1
; FP16-NEXT:    vcmp.f32 s16, s16
; FP16-NEXT:    vmrs APSR_nzcv, fpscr
; FP16-NEXT:    itttt vs
; FP16-NEXT:    movvs r0, #0
; FP16-NEXT:    movvs r1, #0
; FP16-NEXT:    movvs r2, #0
; FP16-NEXT:    movvs r3, #0
; FP16-NEXT:    vpop {d8}
; FP16-NEXT:    pop {r7, pc}
; FP16-NEXT:    .p2align 2
; FP16-NEXT:  @ %bb.1:
; FP16-NEXT:  .LCPI29_0:
; FP16-NEXT:    .long 0xff000000 @ float -1.70141183E+38
; FP16-NEXT:  .LCPI29_1:
; FP16-NEXT:    .long 0x7effffff @ float 1.70141173E+38
    %x = call i128 @llvm.fptosi.sat.i128.f16(half %f)
    ret i128 %x
}
