; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx700 < %s | FileCheck -check-prefixes=GFX7,GFX7-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx700 < %s | FileCheck -check-prefixes=GFX7,GFX7-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx801 < %s | FileCheck -check-prefixes=GFX8,GFX8-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx801 < %s | FileCheck -check-prefixes=GFX8,GFX8-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx942 < %s | FileCheck -check-prefixes=GFX9,GFX9-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx942 < %s | FileCheck -check-prefixes=GFX9,GFX9-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1010 < %s | FileCheck -check-prefixes=GFX10,GFX10-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1010 < %s | FileCheck -check-prefixes=GFX10,GFX10-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-SDAG,GFX11-SDAG-TRUE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-SDAG,GFX11-SDAG-FAKE16 %s
; FIXME-TRUE16. enable gisel
; XUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-GISEL,GFX11-GISEL-TRUE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-GISEL,GFX11-GISEL-FAKE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-SDAG,GFX12-SDAG-TRUE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-SDAG,GFX12-SDAG-FAKE16 %s
; XUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-GISEL,GFX12-GISEL-TRUE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-GISEL,GFX12-GISEL-FAKE16 %s

define i8 @test_vector_reduce_add_v2i8(<2 x i8> %v) {
; GFX7-LABEL: test_vector_reduce_add_v2i8:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_add_v2i8:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_add_v2i8:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_add_v2i8:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_add_v2i8:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_add_v2i8:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_add_v2i8:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_add_v2i8:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_add_v2i8:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_add_v2i8:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i8 @llvm.vector.reduce.add.v2i8(<2 x i8> %v)
  ret i8 %res
}

define i8 @test_vector_reduce_add_v3i8(<3 x i8> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_add_v3i8:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_add_v3i8:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_add_v3i8:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_add_v3i8:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_add_v3i8:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_add_v3i8:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_add_v3i8:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_add_v3i8:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_add_v3i8:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_add_v3i8:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_add_v3i8:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_add_v3i8:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_add_v3i8:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_add_v3i8:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i8 @llvm.vector.reduce.add.v3i8(<3 x i8> %v)
  ret i8 %res
}

define i8 @test_vector_reduce_add_v4i8(<4 x i8> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_add_v4i8:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-SDAG-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v0
; GFX7-SDAG-NEXT:    v_bfe_u32 v0, v0, 8, 8
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v1, v0
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_add_v4i8:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_add_v4i8:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v1, v1, v3 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_add_v4i8:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_add_u16_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_add_v4i8:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_u16_sdwa v1, v1, v3 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-SDAG-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX9-SDAG-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_add_v4i8:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_add_u16_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_add_v4i8:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX10-SDAG-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v2, 8
; GFX10-SDAG-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX10-SDAG-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-SDAG-NEXT:    v_lshrrev_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-SDAG-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_add_v4i8:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_add_v4i8:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v1.l, v1.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b16 v1.l, 8, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-SDAG-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_add_v4i8:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX11-SDAG-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v2
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_add_v4i8:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX11-GISEL-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX11-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_add_v4i8:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v1.l, v1.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b16 v1.l, 8, v1.l
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX12-SDAG-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v2
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_add_v4i8:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX12-SDAG-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v2
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_add_v4i8:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX12-GISEL-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX12-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i8 @llvm.vector.reduce.add.v4i8(<4 x i8> %v)
  ret i8 %res
}

define i8 @test_vector_reduce_add_v8i8(<8 x i8> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_add_v8i8:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v3, v7
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-SDAG-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v0
; GFX7-SDAG-NEXT:    v_bfe_u32 v0, v0, 8, 8
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v1, v0
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_add_v8i8:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX7-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX7-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v3, v7
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_add_v8i8:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u16_e32 v2, v2, v6
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v4
; GFX8-SDAG-NEXT:    v_add_u16_e32 v3, v3, v7
; GFX8-SDAG-NEXT:    v_add_u16_e32 v1, v1, v5
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v1, v1, v3 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_add_v8i8:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_add_u16_e32 v1, v1, v5
; GFX8-GISEL-NEXT:    v_add_u16_e32 v2, v2, v6
; GFX8-GISEL-NEXT:    v_add_u16_e32 v3, v3, v7
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_add_u16_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_add_v8i8:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_u16_e32 v2, v2, v6
; GFX9-SDAG-NEXT:    v_add_u16_e32 v0, v0, v4
; GFX9-SDAG-NEXT:    v_add_u16_e32 v3, v3, v7
; GFX9-SDAG-NEXT:    v_add_u16_e32 v1, v1, v5
; GFX9-SDAG-NEXT:    v_add_u16_sdwa v1, v1, v3 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-SDAG-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX9-SDAG-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_add_v8i8:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u16_e32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_add_u16_e32 v1, v1, v5
; GFX9-GISEL-NEXT:    v_add_u16_e32 v2, v2, v6
; GFX9-GISEL-NEXT:    v_add_u16_e32 v3, v3, v7
; GFX9-GISEL-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_add_u16_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_add_v8i8:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_nc_u16 v3, v3, v7
; GFX10-SDAG-NEXT:    v_add_nc_u16 v1, v1, v5
; GFX10-SDAG-NEXT:    v_add_nc_u16 v2, v2, v6
; GFX10-SDAG-NEXT:    v_add_nc_u16 v0, v0, v4
; GFX10-SDAG-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX10-SDAG-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v2, 8
; GFX10-SDAG-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX10-SDAG-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-SDAG-NEXT:    v_lshrrev_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-SDAG-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_add_v8i8:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, v4
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, v1, v5
; GFX10-GISEL-NEXT:    v_add_nc_u16 v2, v2, v6
; GFX10-GISEL-NEXT:    v_add_nc_u16 v3, v3, v7
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_add_v8i8:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v1.h, v3.l, v7.l
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v1.l, v1.l, v5.l
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v4.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.h, v1.l, v1.h
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v1.l, v2.l, v6.l
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b16 v2.l, 8, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_add_v8i8:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v3, v3, v7
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v1, v1, v5
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v2, v2, v6
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX11-SDAG-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v2
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_add_v8i8:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_nc_u16 v0, v0, v4
; GFX11-GISEL-NEXT:    v_add_nc_u16 v1, v1, v5
; GFX11-GISEL-NEXT:    v_add_nc_u16 v2, v2, v6
; GFX11-GISEL-NEXT:    v_add_nc_u16 v3, v3, v7
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX11-GISEL-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX11-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_add_v8i8:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v1.h, v3.l, v7.l
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v1.l, v1.l, v5.l
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v4.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.h, v1.l, v1.h
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v1.l, v2.l, v6.l
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b16 v2.l, 8, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_add_v8i8:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v3, v3, v7
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v1, v1, v5
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v2, v2, v6
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v4
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX12-SDAG-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v2
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_add_v8i8:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_add_nc_u16 v0, v0, v4
; GFX12-GISEL-NEXT:    v_add_nc_u16 v1, v1, v5
; GFX12-GISEL-NEXT:    v_add_nc_u16 v2, v2, v6
; GFX12-GISEL-NEXT:    v_add_nc_u16 v3, v3, v7
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX12-GISEL-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX12-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i8 @llvm.vector.reduce.add.v8i8(<8 x i8> %v)
  ret i8 %res
}

define i8 @test_vector_reduce_add_v16i8(<16 x i8> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_add_v16i8:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v5, vcc, v5, v13
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v9
; GFX7-SDAG-NEXT:    v_add_i32_e32 v7, vcc, v7, v15
; GFX7-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v3, v11
; GFX7-SDAG-NEXT:    v_add_i32_e32 v4, vcc, v4, v12
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v8
; GFX7-SDAG-NEXT:    v_add_i32_e32 v6, vcc, v6, v14
; GFX7-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v10
; GFX7-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v3, v7
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX7-SDAG-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v0
; GFX7-SDAG-NEXT:    v_bfe_u32 v0, v0, 8, 8
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v1, v0
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_add_v16i8:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v8
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v9
; GFX7-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v10
; GFX7-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v3, v11
; GFX7-GISEL-NEXT:    v_add_i32_e32 v4, vcc, v4, v12
; GFX7-GISEL-NEXT:    v_add_i32_e32 v5, vcc, v5, v13
; GFX7-GISEL-NEXT:    v_add_i32_e32 v6, vcc, v6, v14
; GFX7-GISEL-NEXT:    v_add_i32_e32 v7, vcc, v7, v15
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX7-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX7-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v3, v7
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_add_v16i8:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u16_e32 v5, v5, v13
; GFX8-SDAG-NEXT:    v_add_u16_e32 v1, v1, v9
; GFX8-SDAG-NEXT:    v_add_u16_e32 v7, v7, v15
; GFX8-SDAG-NEXT:    v_add_u16_e32 v3, v3, v11
; GFX8-SDAG-NEXT:    v_add_u16_e32 v4, v4, v12
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v8
; GFX8-SDAG-NEXT:    v_add_u16_e32 v6, v6, v14
; GFX8-SDAG-NEXT:    v_add_u16_e32 v2, v2, v10
; GFX8-SDAG-NEXT:    v_add_u16_e32 v2, v2, v6
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v4
; GFX8-SDAG-NEXT:    v_add_u16_e32 v3, v3, v7
; GFX8-SDAG-NEXT:    v_add_u16_e32 v1, v1, v5
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v1, v1, v3 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_add_v16i8:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, v0, v8
; GFX8-GISEL-NEXT:    v_add_u16_e32 v1, v1, v9
; GFX8-GISEL-NEXT:    v_add_u16_e32 v2, v2, v10
; GFX8-GISEL-NEXT:    v_add_u16_e32 v3, v3, v11
; GFX8-GISEL-NEXT:    v_add_u16_e32 v4, v4, v12
; GFX8-GISEL-NEXT:    v_add_u16_e32 v5, v5, v13
; GFX8-GISEL-NEXT:    v_add_u16_e32 v6, v6, v14
; GFX8-GISEL-NEXT:    v_add_u16_e32 v7, v7, v15
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, v0, v4
; GFX8-GISEL-NEXT:    v_add_u16_e32 v1, v1, v5
; GFX8-GISEL-NEXT:    v_add_u16_e32 v2, v2, v6
; GFX8-GISEL-NEXT:    v_add_u16_e32 v3, v3, v7
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_add_u16_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_add_v16i8:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_u16_e32 v5, v5, v13
; GFX9-SDAG-NEXT:    v_add_u16_e32 v1, v1, v9
; GFX9-SDAG-NEXT:    v_add_u16_e32 v7, v7, v15
; GFX9-SDAG-NEXT:    v_add_u16_e32 v3, v3, v11
; GFX9-SDAG-NEXT:    v_add_u16_e32 v4, v4, v12
; GFX9-SDAG-NEXT:    v_add_u16_e32 v0, v0, v8
; GFX9-SDAG-NEXT:    v_add_u16_e32 v6, v6, v14
; GFX9-SDAG-NEXT:    v_add_u16_e32 v2, v2, v10
; GFX9-SDAG-NEXT:    v_add_u16_e32 v2, v2, v6
; GFX9-SDAG-NEXT:    v_add_u16_e32 v0, v0, v4
; GFX9-SDAG-NEXT:    v_add_u16_e32 v3, v3, v7
; GFX9-SDAG-NEXT:    v_add_u16_e32 v1, v1, v5
; GFX9-SDAG-NEXT:    v_add_u16_sdwa v1, v1, v3 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-SDAG-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX9-SDAG-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX9-SDAG-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_add_v16i8:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u16_e32 v0, v0, v8
; GFX9-GISEL-NEXT:    v_add_u16_e32 v1, v1, v9
; GFX9-GISEL-NEXT:    v_add_u16_e32 v2, v2, v10
; GFX9-GISEL-NEXT:    v_add_u16_e32 v3, v3, v11
; GFX9-GISEL-NEXT:    v_add_u16_e32 v4, v4, v12
; GFX9-GISEL-NEXT:    v_add_u16_e32 v5, v5, v13
; GFX9-GISEL-NEXT:    v_add_u16_e32 v6, v6, v14
; GFX9-GISEL-NEXT:    v_add_u16_e32 v7, v7, v15
; GFX9-GISEL-NEXT:    v_add_u16_e32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_add_u16_e32 v1, v1, v5
; GFX9-GISEL-NEXT:    v_add_u16_e32 v2, v2, v6
; GFX9-GISEL-NEXT:    v_add_u16_e32 v3, v3, v7
; GFX9-GISEL-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX9-GISEL-NEXT:    v_add_u16_e32 v1, v1, v3
; GFX9-GISEL-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_add_v16i8:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_nc_u16 v5, v5, v13
; GFX10-SDAG-NEXT:    v_add_nc_u16 v7, v7, v15
; GFX10-SDAG-NEXT:    v_add_nc_u16 v3, v3, v11
; GFX10-SDAG-NEXT:    v_add_nc_u16 v1, v1, v9
; GFX10-SDAG-NEXT:    v_add_nc_u16 v4, v4, v12
; GFX10-SDAG-NEXT:    v_add_nc_u16 v6, v6, v14
; GFX10-SDAG-NEXT:    v_add_nc_u16 v2, v2, v10
; GFX10-SDAG-NEXT:    v_add_nc_u16 v3, v3, v7
; GFX10-SDAG-NEXT:    v_add_nc_u16 v1, v1, v5
; GFX10-SDAG-NEXT:    v_add_nc_u16 v0, v0, v8
; GFX10-SDAG-NEXT:    v_add_nc_u16 v2, v2, v6
; GFX10-SDAG-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX10-SDAG-NEXT:    v_add_nc_u16 v0, v0, v4
; GFX10-SDAG-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX10-SDAG-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v2, 8
; GFX10-SDAG-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-SDAG-NEXT:    v_lshrrev_b32_sdwa v1, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-SDAG-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_add_v16i8:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, v8
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, v1, v9
; GFX10-GISEL-NEXT:    v_add_nc_u16 v2, v2, v10
; GFX10-GISEL-NEXT:    v_add_nc_u16 v3, v3, v11
; GFX10-GISEL-NEXT:    v_add_nc_u16 v4, v4, v12
; GFX10-GISEL-NEXT:    v_add_nc_u16 v5, v5, v13
; GFX10-GISEL-NEXT:    v_add_nc_u16 v6, v6, v14
; GFX10-GISEL-NEXT:    v_add_nc_u16 v7, v7, v15
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, v4
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, v1, v5
; GFX10-GISEL-NEXT:    v_add_nc_u16 v2, v2, v6
; GFX10-GISEL-NEXT:    v_add_nc_u16 v3, v3, v7
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_add_v16i8:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v1.h, v5.l, v13.l
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v1.l, v1.l, v9.l
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v3.h, v7.l, v15.l
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v3.l, v3.l, v11.l
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v2.h, v6.l, v14.l
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v2.l, v2.l, v10.l
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v1.l, v1.l, v1.h
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v1.h, v4.l, v12.l
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.h, v3.l, v3.h
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v8.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.h, v1.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v1.l, v2.l, v2.h
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.h
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_lshlrev_b16 v2.l, 8, v0.h
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-SDAG-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_add_v16i8:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v5, v5, v13
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v1, v1, v9
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v7, v7, v15
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v3, v3, v11
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v4, v4, v12
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v8
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v6, v6, v14
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v2, v2, v10
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v3, v3, v7
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v1, v1, v5
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v2, v2, v6
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-SDAG-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_add_v16i8:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_nc_u16 v0, v0, v8
; GFX11-GISEL-NEXT:    v_add_nc_u16 v1, v1, v9
; GFX11-GISEL-NEXT:    v_add_nc_u16 v2, v2, v10
; GFX11-GISEL-NEXT:    v_add_nc_u16 v3, v3, v11
; GFX11-GISEL-NEXT:    v_add_nc_u16 v4, v4, v12
; GFX11-GISEL-NEXT:    v_add_nc_u16 v5, v5, v13
; GFX11-GISEL-NEXT:    v_add_nc_u16 v6, v6, v14
; GFX11-GISEL-NEXT:    v_add_nc_u16 v7, v7, v15
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_add_nc_u16 v0, v0, v4
; GFX11-GISEL-NEXT:    v_add_nc_u16 v1, v1, v5
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_add_nc_u16 v2, v2, v6
; GFX11-GISEL-NEXT:    v_add_nc_u16 v3, v3, v7
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX11-GISEL-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX11-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_add_v16i8:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v1.h, v5.l, v13.l
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v1.l, v1.l, v9.l
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v3.h, v7.l, v15.l
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v3.l, v3.l, v11.l
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v2.h, v6.l, v14.l
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v2.l, v2.l, v10.l
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v1.l, v1.l, v1.h
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v1.h, v4.l, v12.l
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.h, v3.l, v3.h
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v8.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.h, v1.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v1.l, v2.l, v2.h
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.h
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_lshlrev_b16 v2.l, 8, v0.h
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX12-SDAG-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v1
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_add_v16i8:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v5, v5, v13
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v1, v1, v9
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v7, v7, v15
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v3, v3, v11
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v4, v4, v12
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v8
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v6, v6, v14
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v2, v2, v10
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v3, v3, v7
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v1, v1, v5
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v4
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v2, v2, v6
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    v_lshlrev_b16 v1, 8, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX12-SDAG-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_add_v16i8:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_add_nc_u16 v0, v0, v8
; GFX12-GISEL-NEXT:    v_add_nc_u16 v1, v1, v9
; GFX12-GISEL-NEXT:    v_add_nc_u16 v2, v2, v10
; GFX12-GISEL-NEXT:    v_add_nc_u16 v3, v3, v11
; GFX12-GISEL-NEXT:    v_add_nc_u16 v4, v4, v12
; GFX12-GISEL-NEXT:    v_add_nc_u16 v5, v5, v13
; GFX12-GISEL-NEXT:    v_add_nc_u16 v6, v6, v14
; GFX12-GISEL-NEXT:    v_add_nc_u16 v7, v7, v15
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_add_nc_u16 v0, v0, v4
; GFX12-GISEL-NEXT:    v_add_nc_u16 v1, v1, v5
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-GISEL-NEXT:    v_add_nc_u16 v2, v2, v6
; GFX12-GISEL-NEXT:    v_add_nc_u16 v3, v3, v7
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX12-GISEL-NEXT:    v_add_nc_u16 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX12-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 8
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i8 @llvm.vector.reduce.add.v16i8(<16 x i8> %v)
  ret i8 %res
}

define i16 @test_vector_reduce_add_v2i16(<2 x i16> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_add_v2i16:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_add_v2i16:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 16
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_add_v2i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_add_v2i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    s_and_b32 s4, 0xffff, s4
; GFX8-GISEL-NEXT:    v_add_u16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-GISEL-NEXT:    s_lshl_b32 s4, s4, 16
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, s4, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_add_v2i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_u16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_add_v2i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_add_v2i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-SDAG-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_add_v2i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_add_v2i16:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_add_v2i16:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_add_v2i16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_add_v2i16:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_add_v2i16:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_add_v2i16:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i16 @llvm.vector.reduce.add.v2i16(<2 x i16> %v)
  ret i16 %res
}

define i16 @test_vector_reduce_add_v3i16(<3 x i16> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_add_v3i16:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-SDAG-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-SDAG-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_add_v3i16:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_add_v3i16:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_add_v3i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_add_u16 v1, v0, v1
; GFX9-SDAG-NEXT:    s_nop 0
; GFX9-SDAG-NEXT:    v_add_u16_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_add_v3i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-GISEL-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_add_v3i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX10-SDAG-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_add_v3i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_add_v3i16:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_pk_add_u16 v1, v0, v1
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v1.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_add_v3i16:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_add_v3i16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX11-GISEL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_add_v3i16:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_pk_add_u16 v1, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v1.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_add_v3i16:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_add_v3i16:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_add_nc_u16 v0, v0, v2
; GFX12-GISEL-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i16 @llvm.vector.reduce.add.v3i16(<3 x i16> %v)
  ret i16 %res
}

define i16 @test_vector_reduce_add_v4i16(<4 x i16> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_add_v4i16:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-SDAG-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_add_v4i16:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 16
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_add_v4i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v2, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_add_v4i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u16_e32 v2, v0, v1
; GFX8-GISEL-NEXT:    v_add_u16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    s_and_b32 s4, 0xffff, s4
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, v2, v0
; GFX8-GISEL-NEXT:    s_lshl_b32 s4, s4, 16
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, s4, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_add_v4i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX9-SDAG-NEXT:    s_nop 0
; GFX9-SDAG-NEXT:    v_add_u16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_add_v4i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX9-GISEL-NEXT:    s_nop 0
; GFX9-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_add_v4i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-SDAG-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_add_v4i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_add_v4i16:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_add_v4i16:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_add_v4i16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_add_v4i16:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_add_v4i16:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_add_v4i16:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i16 @llvm.vector.reduce.add.v4i16(<4 x i16> %v)
  ret i16 %res
}

define i16 @test_vector_reduce_add_v8i16(<8 x i16> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_add_v8i16:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v3, v7
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-SDAG-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_add_v8i16:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX7-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX7-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v3, v7
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 16
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_add_v8i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v4, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v5, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_add_u16_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_add_u16_e32 v2, v5, v4
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_add_v8i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u16_e32 v4, v0, v2
; GFX8-GISEL-NEXT:    v_add_u16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_add_u16_e32 v2, v1, v3
; GFX8-GISEL-NEXT:    v_add_u16_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_add_u16_e32 v2, v4, v2
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    s_and_b32 s4, 0xffff, s4
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, v2, v0
; GFX8-GISEL-NEXT:    s_lshl_b32 s4, s4, 16
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, s4, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_add_v8i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX9-SDAG-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX9-SDAG-NEXT:    s_nop 0
; GFX9-SDAG-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX9-SDAG-NEXT:    s_nop 0
; GFX9-SDAG-NEXT:    v_add_u16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_add_v8i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX9-GISEL-NEXT:    s_nop 0
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX9-GISEL-NEXT:    s_nop 0
; GFX9-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_add_v8i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX10-SDAG-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-SDAG-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_add_v8i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_add_v8i16:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX11-SDAG-TRUE16-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_add_v8i16:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX11-SDAG-FAKE16-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_add_v8i16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX11-GISEL-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_add_v8i16:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX12-SDAG-TRUE16-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_add_v8i16:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX12-SDAG-FAKE16-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_add_v8i16:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX12-GISEL-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX12-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i16 @llvm.vector.reduce.add.v8i16(<8 x i16> %v)
  ret i16 %res
}

define i16 @test_vector_reduce_add_v16i16(<16 x i16> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_add_v16i16:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v5, vcc, v5, v13
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v9
; GFX7-SDAG-NEXT:    v_add_i32_e32 v7, vcc, v7, v15
; GFX7-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v3, v11
; GFX7-SDAG-NEXT:    v_add_i32_e32 v4, vcc, v4, v12
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v8
; GFX7-SDAG-NEXT:    v_add_i32_e32 v6, vcc, v6, v14
; GFX7-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v10
; GFX7-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v3, v7
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-SDAG-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX7-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-SDAG-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-SDAG-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_add_v16i16:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v8
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v9
; GFX7-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v10
; GFX7-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v3, v11
; GFX7-GISEL-NEXT:    v_add_i32_e32 v4, vcc, v4, v12
; GFX7-GISEL-NEXT:    v_add_i32_e32 v5, vcc, v5, v13
; GFX7-GISEL-NEXT:    v_add_i32_e32 v6, vcc, v6, v14
; GFX7-GISEL-NEXT:    v_add_i32_e32 v7, vcc, v7, v15
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX7-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX7-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v3, v7
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-GISEL-NEXT:    v_bfe_u32 v0, v0, 0, 16
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_add_v16i16:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v8, v2, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v9, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v10, v3, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_add_u16_sdwa v11, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_add_u16_e32 v2, v2, v6
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v4
; GFX8-SDAG-NEXT:    v_add_u16_e32 v3, v3, v7
; GFX8-SDAG-NEXT:    v_add_u16_e32 v1, v1, v5
; GFX8-SDAG-NEXT:    v_add_u16_e32 v4, v11, v10
; GFX8-SDAG-NEXT:    v_add_u16_e32 v5, v9, v8
; GFX8-SDAG-NEXT:    v_add_u16_e32 v1, v1, v3
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    v_add_u16_e32 v2, v5, v4
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_add_v16i16:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u16_e32 v8, v0, v4
; GFX8-GISEL-NEXT:    v_add_u16_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_add_u16_e32 v4, v1, v5
; GFX8-GISEL-NEXT:    v_add_u16_sdwa v1, v1, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_add_u16_e32 v5, v2, v6
; GFX8-GISEL-NEXT:    v_add_u16_sdwa v2, v2, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_add_u16_e32 v6, v3, v7
; GFX8-GISEL-NEXT:    v_add_u16_sdwa v3, v3, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_add_u16_e32 v5, v8, v5
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX8-GISEL-NEXT:    v_add_u16_e32 v2, v4, v6
; GFX8-GISEL-NEXT:    v_add_u16_e32 v1, v1, v3
; GFX8-GISEL-NEXT:    v_add_u16_e32 v2, v5, v2
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    s_and_b32 s4, 0xffff, s4
; GFX8-GISEL-NEXT:    v_add_u16_e32 v0, v2, v0
; GFX8-GISEL-NEXT:    s_lshl_b32 s4, s4, 16
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, s4, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_add_v16i16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_pk_add_u16 v2, v2, v6
; GFX9-SDAG-NEXT:    v_pk_add_u16 v0, v0, v4
; GFX9-SDAG-NEXT:    v_pk_add_u16 v3, v3, v7
; GFX9-SDAG-NEXT:    v_pk_add_u16 v1, v1, v5
; GFX9-SDAG-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX9-SDAG-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX9-SDAG-NEXT:    s_nop 0
; GFX9-SDAG-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX9-SDAG-NEXT:    s_nop 0
; GFX9-SDAG-NEXT:    v_add_u16_sdwa v0, v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_add_v16i16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v0, v4
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v1, v5
; GFX9-GISEL-NEXT:    v_pk_add_u16 v2, v2, v6
; GFX9-GISEL-NEXT:    v_pk_add_u16 v3, v3, v7
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX9-GISEL-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX9-GISEL-NEXT:    s_nop 0
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX9-GISEL-NEXT:    s_nop 0
; GFX9-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX9-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_add_v16i16:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_pk_add_u16 v2, v2, v6
; GFX10-SDAG-NEXT:    v_pk_add_u16 v3, v3, v7
; GFX10-SDAG-NEXT:    v_pk_add_u16 v1, v1, v5
; GFX10-SDAG-NEXT:    v_pk_add_u16 v0, v0, v4
; GFX10-SDAG-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX10-SDAG-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX10-SDAG-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-SDAG-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_add_v16i16:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v0, v4
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v1, v5
; GFX10-GISEL-NEXT:    v_pk_add_u16 v2, v2, v6
; GFX10-GISEL-NEXT:    v_pk_add_u16 v3, v3, v7
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX10-GISEL-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX10-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_add_v16i16:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_pk_add_u16 v2, v2, v6
; GFX11-SDAG-TRUE16-NEXT:    v_pk_add_u16 v3, v3, v7
; GFX11-SDAG-TRUE16-NEXT:    v_pk_add_u16 v1, v1, v5
; GFX11-SDAG-TRUE16-NEXT:    v_pk_add_u16 v0, v0, v4
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-TRUE16-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX11-SDAG-TRUE16-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX11-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v0.h
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_add_v16i16:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_pk_add_u16 v2, v2, v6
; GFX11-SDAG-FAKE16-NEXT:    v_pk_add_u16 v3, v3, v7
; GFX11-SDAG-FAKE16-NEXT:    v_pk_add_u16 v1, v1, v5
; GFX11-SDAG-FAKE16-NEXT:    v_pk_add_u16 v0, v0, v4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX11-SDAG-FAKE16-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_add_v16i16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_pk_add_u16 v0, v0, v4
; GFX11-GISEL-NEXT:    v_pk_add_u16 v1, v1, v5
; GFX11-GISEL-NEXT:    v_pk_add_u16 v2, v2, v6
; GFX11-GISEL-NEXT:    v_pk_add_u16 v3, v3, v7
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX11-GISEL-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_add_v16i16:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_pk_add_u16 v2, v2, v6
; GFX12-SDAG-TRUE16-NEXT:    v_pk_add_u16 v3, v3, v7
; GFX12-SDAG-TRUE16-NEXT:    v_pk_add_u16 v1, v1, v5
; GFX12-SDAG-TRUE16-NEXT:    v_pk_add_u16 v0, v0, v4
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-TRUE16-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX12-SDAG-TRUE16-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX12-SDAG-TRUE16-NEXT:    v_add_nc_u16 v0.l, v0.l, v0.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_add_v16i16:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_pk_add_u16 v2, v2, v6
; GFX12-SDAG-FAKE16-NEXT:    v_pk_add_u16 v3, v3, v7
; GFX12-SDAG-FAKE16-NEXT:    v_pk_add_u16 v1, v1, v5
; GFX12-SDAG-FAKE16-NEXT:    v_pk_add_u16 v0, v0, v4
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX12-SDAG-FAKE16-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_add_nc_u16 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_add_v16i16:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_pk_add_u16 v0, v0, v4
; GFX12-GISEL-NEXT:    v_pk_add_u16 v1, v1, v5
; GFX12-GISEL-NEXT:    v_pk_add_u16 v2, v2, v6
; GFX12-GISEL-NEXT:    v_pk_add_u16 v3, v3, v7
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_pk_add_u16 v0, v0, v2
; GFX12-GISEL-NEXT:    v_pk_add_u16 v1, v1, v3
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX12-GISEL-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_pk_add_u16 v0, v0, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i16 @llvm.vector.reduce.add.v16i16(<16 x i16> %v)
  ret i16 %res
}


define i32 @test_vector_reduce_add_v2i32(<2 x i32> %v) {
; GFX7-LABEL: test_vector_reduce_add_v2i32:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_add_v2i32:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_add_v2i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_add_v2i32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_add_v2i32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_add_v2i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_nc_u32_e32 v0, v0, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i32 @llvm.vector.reduce.add.v2i32(<2 x i32> %v)
  ret i32 %res
}

define i32 @test_vector_reduce_add_v3i32(<3 x i32> %v) {
; GFX7-LABEL: test_vector_reduce_add_v3i32:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_add_v3i32:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_add_v3i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add3_u32 v0, v0, v1, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_add_v3i32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add3_u32 v0, v0, v1, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_add_v3i32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add3_u32 v0, v0, v1, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_add_v3i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add3_u32 v0, v0, v1, v2
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i32 @llvm.vector.reduce.add.v3i32(<3 x i32> %v)
  ret i32 %res
}

define i32 @test_vector_reduce_add_v4i32(<4 x i32> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_add_v4i32:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_add_v4i32:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_add_v4i32:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v1, v3
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_add_v4i32:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, v1, v3
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_add_v4i32:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v1, v1, v3
; GFX9-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_add_v4i32:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v1, v1, v3
; GFX10-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_add_v4i32:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, v1, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_add_v4i32:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_nc_u32_e32 v1, v1, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %v)
  ret i32 %res
}

define i32 @test_vector_reduce_add_v8i32(<8 x i32> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_add_v8i32:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v3, v7
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_add_v8i32:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX7-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX7-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v3, v7
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_add_v8i32:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v2, v6
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v4
; GFX8-SDAG-NEXT:    v_add_u32_e32 v3, vcc, v3, v7
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v1, v5
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v1, v3
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_add_v8i32:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v4
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, v1, v5
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, v2, v6
; GFX8-GISEL-NEXT:    v_add_u32_e32 v3, vcc, v3, v7
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, v1, v3
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_add_v8i32:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_u32_e32 v3, v3, v7
; GFX9-SDAG-NEXT:    v_add_u32_e32 v2, v2, v6
; GFX9-SDAG-NEXT:    v_add_u32_e32 v0, v0, v4
; GFX9-SDAG-NEXT:    v_add3_u32 v1, v1, v5, v3
; GFX9-SDAG-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_add_v8i32:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u32_e32 v3, v3, v7
; GFX9-GISEL-NEXT:    v_add_u32_e32 v0, v0, v4
; GFX9-GISEL-NEXT:    v_add_u32_e32 v2, v2, v6
; GFX9-GISEL-NEXT:    v_add3_u32 v1, v1, v5, v3
; GFX9-GISEL-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_add_v8i32:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v3, v3, v7
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v2, v2, v6
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v0, v0, v4
; GFX10-SDAG-NEXT:    v_add3_u32 v1, v1, v5, v3
; GFX10-SDAG-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_add_v8i32:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v3, v3, v7
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v0, v0, v4
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v2, v2, v6
; GFX10-GISEL-NEXT:    v_add3_u32 v1, v1, v5, v3
; GFX10-GISEL-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_add_v8i32:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_nc_u32_e32 v3, v3, v7
; GFX11-SDAG-NEXT:    v_add_nc_u32_e32 v2, v2, v6
; GFX11-SDAG-NEXT:    v_add_nc_u32_e32 v0, v0, v4
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add3_u32 v1, v1, v5, v3
; GFX11-SDAG-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_add_v8i32:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v3, v3, v7
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v0, v0, v4
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v2, v2, v6
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add3_u32 v1, v1, v5, v3
; GFX11-GISEL-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_add_v8i32:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_nc_u32_e32 v3, v3, v7
; GFX12-SDAG-NEXT:    v_add_nc_u32_e32 v2, v2, v6
; GFX12-SDAG-NEXT:    v_add_nc_u32_e32 v0, v0, v4
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_add3_u32 v1, v1, v5, v3
; GFX12-SDAG-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_add_v8i32:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_add_nc_u32_e32 v3, v3, v7
; GFX12-GISEL-NEXT:    v_add_nc_u32_e32 v0, v0, v4
; GFX12-GISEL-NEXT:    v_add_nc_u32_e32 v2, v2, v6
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_add3_u32 v1, v1, v5, v3
; GFX12-GISEL-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i32 @llvm.vector.reduce.add.v8i32(<8 x i32> %v)
  ret i32 %res
}

define i32 @test_vector_reduce_add_v16i32(<16 x i32> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_add_v16i32:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v5, vcc, v5, v13
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v9
; GFX7-SDAG-NEXT:    v_add_i32_e32 v7, vcc, v7, v15
; GFX7-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v3, v11
; GFX7-SDAG-NEXT:    v_add_i32_e32 v4, vcc, v4, v12
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v8
; GFX7-SDAG-NEXT:    v_add_i32_e32 v6, vcc, v6, v14
; GFX7-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v10
; GFX7-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-SDAG-NEXT:    v_add_i32_e32 v3, vcc, v3, v7
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX7-SDAG-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_add_v16i32:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v8
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v9
; GFX7-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v10
; GFX7-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v3, v11
; GFX7-GISEL-NEXT:    v_add_i32_e32 v4, vcc, v4, v12
; GFX7-GISEL-NEXT:    v_add_i32_e32 v5, vcc, v5, v13
; GFX7-GISEL-NEXT:    v_add_i32_e32 v6, vcc, v6, v14
; GFX7-GISEL-NEXT:    v_add_i32_e32 v7, vcc, v7, v15
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX7-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX7-GISEL-NEXT:    v_add_i32_e32 v3, vcc, v3, v7
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-GISEL-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_add_v16i32:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u32_e32 v5, vcc, v5, v13
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v1, v9
; GFX8-SDAG-NEXT:    v_add_u32_e32 v7, vcc, v7, v15
; GFX8-SDAG-NEXT:    v_add_u32_e32 v3, vcc, v3, v11
; GFX8-SDAG-NEXT:    v_add_u32_e32 v4, vcc, v4, v12
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v8
; GFX8-SDAG-NEXT:    v_add_u32_e32 v6, vcc, v6, v14
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v2, v10
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v2, v6
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v4
; GFX8-SDAG-NEXT:    v_add_u32_e32 v3, vcc, v3, v7
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v1, v5
; GFX8-SDAG-NEXT:    v_add_u32_e32 v1, vcc, v1, v3
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_add_v16i32:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v8
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, v1, v9
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, v2, v10
; GFX8-GISEL-NEXT:    v_add_u32_e32 v3, vcc, v3, v11
; GFX8-GISEL-NEXT:    v_add_u32_e32 v4, vcc, v4, v12
; GFX8-GISEL-NEXT:    v_add_u32_e32 v5, vcc, v5, v13
; GFX8-GISEL-NEXT:    v_add_u32_e32 v6, vcc, v6, v14
; GFX8-GISEL-NEXT:    v_add_u32_e32 v7, vcc, v7, v15
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v4
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, v1, v5
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, v2, v6
; GFX8-GISEL-NEXT:    v_add_u32_e32 v3, vcc, v3, v7
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-GISEL-NEXT:    v_add_u32_e32 v1, vcc, v1, v3
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_add_v16i32:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_add_u32_e32 v7, v7, v15
; GFX9-SDAG-NEXT:    v_add_u32_e32 v5, v5, v13
; GFX9-SDAG-NEXT:    v_add_u32_e32 v1, v1, v9
; GFX9-SDAG-NEXT:    v_add_u32_e32 v4, v4, v12
; GFX9-SDAG-NEXT:    v_add_u32_e32 v6, v6, v14
; GFX9-SDAG-NEXT:    v_add3_u32 v3, v3, v11, v7
; GFX9-SDAG-NEXT:    v_add3_u32 v2, v2, v10, v6
; GFX9-SDAG-NEXT:    v_add3_u32 v0, v0, v8, v4
; GFX9-SDAG-NEXT:    v_add3_u32 v1, v1, v5, v3
; GFX9-SDAG-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_add_v16i32:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_u32_e32 v7, v7, v15
; GFX9-GISEL-NEXT:    v_add_u32_e32 v1, v1, v9
; GFX9-GISEL-NEXT:    v_add_u32_e32 v4, v4, v12
; GFX9-GISEL-NEXT:    v_add_u32_e32 v5, v5, v13
; GFX9-GISEL-NEXT:    v_add_u32_e32 v6, v6, v14
; GFX9-GISEL-NEXT:    v_add3_u32 v3, v3, v11, v7
; GFX9-GISEL-NEXT:    v_add3_u32 v0, v0, v8, v4
; GFX9-GISEL-NEXT:    v_add3_u32 v2, v2, v10, v6
; GFX9-GISEL-NEXT:    v_add3_u32 v1, v1, v5, v3
; GFX9-GISEL-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_add_v16i32:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v7, v7, v15
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v5, v5, v13
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v1, v1, v9
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v6, v6, v14
; GFX10-SDAG-NEXT:    v_add_nc_u32_e32 v4, v4, v12
; GFX10-SDAG-NEXT:    v_add3_u32 v3, v3, v11, v7
; GFX10-SDAG-NEXT:    v_add3_u32 v2, v2, v10, v6
; GFX10-SDAG-NEXT:    v_add3_u32 v0, v0, v8, v4
; GFX10-SDAG-NEXT:    v_add3_u32 v1, v1, v5, v3
; GFX10-SDAG-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_add_v16i32:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v7, v7, v15
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v1, v1, v9
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v4, v4, v12
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v5, v5, v13
; GFX10-GISEL-NEXT:    v_add_nc_u32_e32 v6, v6, v14
; GFX10-GISEL-NEXT:    v_add3_u32 v3, v3, v11, v7
; GFX10-GISEL-NEXT:    v_add3_u32 v0, v0, v8, v4
; GFX10-GISEL-NEXT:    v_add3_u32 v2, v2, v10, v6
; GFX10-GISEL-NEXT:    v_add3_u32 v1, v1, v5, v3
; GFX10-GISEL-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_add_v16i32:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_nc_u32_e32 v7, v7, v15
; GFX11-SDAG-NEXT:    v_add_nc_u32_e32 v5, v5, v13
; GFX11-SDAG-NEXT:    v_add_nc_u32_e32 v1, v1, v9
; GFX11-SDAG-NEXT:    v_add_nc_u32_e32 v6, v6, v14
; GFX11-SDAG-NEXT:    v_add_nc_u32_e32 v4, v4, v12
; GFX11-SDAG-NEXT:    v_add3_u32 v3, v3, v11, v7
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-SDAG-NEXT:    v_add3_u32 v2, v2, v10, v6
; GFX11-SDAG-NEXT:    v_add3_u32 v0, v0, v8, v4
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add3_u32 v1, v1, v5, v3
; GFX11-SDAG-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_add_v16i32:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v7, v7, v15
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v1, v1, v9
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v4, v4, v12
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v5, v5, v13
; GFX11-GISEL-NEXT:    v_add_nc_u32_e32 v6, v6, v14
; GFX11-GISEL-NEXT:    v_add3_u32 v3, v3, v11, v7
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-GISEL-NEXT:    v_add3_u32 v0, v0, v8, v4
; GFX11-GISEL-NEXT:    v_add3_u32 v2, v2, v10, v6
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add3_u32 v1, v1, v5, v3
; GFX11-GISEL-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_add_v16i32:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_nc_u32_e32 v7, v7, v15
; GFX12-SDAG-NEXT:    v_add_nc_u32_e32 v5, v5, v13
; GFX12-SDAG-NEXT:    v_add_nc_u32_e32 v1, v1, v9
; GFX12-SDAG-NEXT:    v_add_nc_u32_e32 v6, v6, v14
; GFX12-SDAG-NEXT:    v_add_nc_u32_e32 v4, v4, v12
; GFX12-SDAG-NEXT:    v_add3_u32 v3, v3, v11, v7
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-SDAG-NEXT:    v_add3_u32 v2, v2, v10, v6
; GFX12-SDAG-NEXT:    v_add3_u32 v0, v0, v8, v4
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_add3_u32 v1, v1, v5, v3
; GFX12-SDAG-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_add_v16i32:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_add_nc_u32_e32 v7, v7, v15
; GFX12-GISEL-NEXT:    v_add_nc_u32_e32 v1, v1, v9
; GFX12-GISEL-NEXT:    v_add_nc_u32_e32 v4, v4, v12
; GFX12-GISEL-NEXT:    v_add_nc_u32_e32 v5, v5, v13
; GFX12-GISEL-NEXT:    v_add_nc_u32_e32 v6, v6, v14
; GFX12-GISEL-NEXT:    v_add3_u32 v3, v3, v11, v7
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-GISEL-NEXT:    v_add3_u32 v0, v0, v8, v4
; GFX12-GISEL-NEXT:    v_add3_u32 v2, v2, v10, v6
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_add3_u32 v1, v1, v5, v3
; GFX12-GISEL-NEXT:    v_add3_u32 v0, v0, v2, v1
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i32 @llvm.vector.reduce.add.v16i32(<16 x i32> %v)
  ret i32 %res
}

define i64 @test_vector_reduce_add_v2i64(<2 x i64> %v) {
; GFX7-LABEL: test_vector_reduce_add_v2i64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_add_v2i64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_add_v2i64:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[0:1], v[0:1], 0, v[2:3]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_add_v2i64:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_add_v2i64:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_add_v2i64:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_add_v2i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i64 @llvm.vector.reduce.add.v2i64(<2 x i64> %v)
  ret i64 %res
}

define i64 @test_vector_reduce_add_v3i64(<3 x i64> %v) {
; GFX7-LABEL: test_vector_reduce_add_v3i64:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, v1, v5, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_add_v3i64:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v0, v4
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, v1, v5, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_add_v3i64:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[0:1], v[0:1], 0, v[2:3]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[0:1], v[0:1], 0, v[4:5]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_add_v3i64:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v4
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v5, vcc
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_add_v3i64:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v5, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_add_v3i64:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v5, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_add_v3i64:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX12-NEXT:    s_wait_alu 0xfffd
; GFX12-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v5, vcc_lo
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i64 @llvm.vector.reduce.add.v3i64(<3 x i64> %v)
  ret i64 %res
}

define i64 @test_vector_reduce_add_v4i64(<4 x i64> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_add_v4i64:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v3, vcc, v3, v7, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v5, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_add_v4i64:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v1, v5, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v3, vcc, v3, v7, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_add_v4i64:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v2, v6
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v3, vcc, v3, v7, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v4
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v5, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_add_v4i64:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v4
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v1, v5, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, v2, v6
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v3, vcc, v3, v7, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_add_v4i64:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[2:3], v[2:3], 0, v[6:7]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[0:1], v[0:1], 0, v[4:5]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[0:1], v[0:1], 0, v[2:3]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_add_v4i64:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v4
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v5, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v6
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v7, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_add_v4i64:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, v3, v7, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v5, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_add_v4i64:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v5, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, v3, v7, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_add_v4i64:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v7, vcc_lo
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v5, vcc_lo
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_add_v4i64:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v5, vcc_lo
; GFX11-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v7, vcc_lo
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_add_v4i64:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v7, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v5, vcc_lo
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_add_v4i64:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v5, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v7, vcc_lo
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i64 @llvm.vector.reduce.add.v4i64(<4 x i64> %v)
  ret i64 %res
}

define i64 @test_vector_reduce_add_v8i64(<8 x i64> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_add_v8i64:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v4, vcc, v4, v12
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v5, vcc, v5, v13, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v8
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v9, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v6, vcc, v6, v14
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v7, vcc, v7, v15, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v10
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v3, vcc, v3, v11, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v3, vcc, v3, v7, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v5, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_add_v8i64:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v8
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v1, v9, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v10
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v3, vcc, v3, v11, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v4, vcc, v4, v12
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v5, vcc, v5, v13, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v6, vcc, v6, v14
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v7, vcc, v7, v15, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v1, v5, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v3, vcc, v3, v7, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_add_v8i64:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u32_e32 v4, vcc, v4, v12
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v5, vcc, v5, v13, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v8
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v9, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v6, vcc, v6, v14
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v7, vcc, v7, v15, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v2, v10
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v3, vcc, v3, v11, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v2, v6
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v3, vcc, v3, v7, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v4
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v5, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_add_v8i64:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v8
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v1, v9, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, v2, v10
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v3, vcc, v3, v11, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v4, vcc, v4, v12
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v5, vcc, v5, v13, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v6, vcc, v6, v14
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v7, vcc, v7, v15, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v4
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v1, v5, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, v2, v6
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v3, vcc, v3, v7, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_add_v8i64:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[4:5], v[4:5], 0, v[12:13]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[0:1], v[0:1], 0, v[8:9]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[6:7], v[6:7], 0, v[14:15]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[2:3], v[2:3], 0, v[10:11]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[2:3], v[2:3], 0, v[6:7]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[0:1], v[0:1], 0, v[4:5]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[0:1], v[0:1], 0, v[2:3]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_add_v8i64:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v8
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v9, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v10
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v11, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v4, vcc, v4, v12
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v5, vcc, v5, v13, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v6, vcc, v6, v14
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v7, vcc, v7, v15, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v4
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v5, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v6
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v7, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_add_v8i64:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v12
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, v5, v13, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v6, vcc_lo, v6, v14
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v7, vcc_lo, v7, v15, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v10
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, v3, v11, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v8
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v9, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, v3, v7, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v5, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_add_v8i64:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v8
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v9, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v10
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, v3, v11, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v12
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, v5, v13, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v6, vcc_lo, v6, v14
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v7, vcc_lo, v7, v15, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v5, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, v3, v7, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_add_v8i64:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v12
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v5, null, v5, v13, vcc_lo
; GFX11-SDAG-NEXT:    v_add_co_u32 v6, vcc_lo, v6, v14
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v7, null, v7, v15, vcc_lo
; GFX11-SDAG-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v10
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v11, vcc_lo
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v8
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v9, vcc_lo
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v7, vcc_lo
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v5, vcc_lo
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_add_v8i64:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v8
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v9, vcc_lo
; GFX11-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v10
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v11, vcc_lo
; GFX11-GISEL-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v12
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v5, null, v5, v13, vcc_lo
; GFX11-GISEL-NEXT:    v_add_co_u32 v6, vcc_lo, v6, v14
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v7, null, v7, v15, vcc_lo
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v5, vcc_lo
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v7, vcc_lo
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_add_v8i64:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v12
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v5, null, v5, v13, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v6, vcc_lo, v6, v14
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v7, null, v7, v15, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v10
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v11, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v8
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v9, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v7, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v5, vcc_lo
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_add_v8i64:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v8
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v9, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v10
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v11, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v12
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v5, null, v5, v13, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v6, vcc_lo, v6, v14
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v7, null, v7, v15, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v5, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v7, vcc_lo
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i64 @llvm.vector.reduce.add.v8i64(<8 x i64> %v)
  ret i64 %res
}

define i64 @test_vector_reduce_add_v16i64(<16 x i64> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_add_v16i64:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_add_i32_e32 v10, vcc, v10, v26
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v11, vcc, v11, v27, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v18
; GFX7-SDAG-NEXT:    buffer_load_dword v18, off, s[0:3], s32
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v3, vcc, v3, v19, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v6, vcc, v6, v22
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v7, vcc, v7, v23, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v8, vcc, v8, v24
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v9, vcc, v9, v25, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v16
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v17, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v12, vcc, v12, v28
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v13, vcc, v13, v29, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v4, vcc, v4, v20
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v5, vcc, v5, v21, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v4, vcc, v4, v12
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v5, vcc, v5, v13, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v8
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v9, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v10
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v3, vcc, v3, v11, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v8, vcc, v14, v30
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v9, vcc, v15, v18, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v6, vcc, v6, v8
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v7, vcc, v7, v9, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v3, vcc, v3, v7, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v5, vcc
; GFX7-SDAG-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_add_v16i64:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v16
; GFX7-GISEL-NEXT:    buffer_load_dword v16, off, s[0:3], s32
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v1, v17, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v18
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v3, vcc, v3, v19, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v4, vcc, v4, v20
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v5, vcc, v5, v21, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v6, vcc, v6, v22
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v7, vcc, v7, v23, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v8, vcc, v8, v24
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v9, vcc, v9, v25, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v10, vcc, v10, v26
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v11, vcc, v11, v27, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v12, vcc, v12, v28
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v13, vcc, v13, v29, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v8
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v1, v9, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v10
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v3, vcc, v3, v11, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v4, vcc, v4, v12
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v5, vcc, v5, v13, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v8, vcc, v14, v30
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v9, vcc, v15, v16, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v6, vcc, v6, v8
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v7, vcc, v7, v9, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v1, v5, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v3, vcc, v3, v7, vcc
; GFX7-GISEL-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX7-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_add_v16i64:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_add_u32_e32 v10, vcc, v10, v26
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v11, vcc, v11, v27, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v2, v18
; GFX8-SDAG-NEXT:    buffer_load_dword v18, off, s[0:3], s32
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v3, vcc, v3, v19, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v6, vcc, v6, v22
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v7, vcc, v7, v23, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v8, vcc, v8, v24
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v9, vcc, v9, v25, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v16
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v17, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v12, vcc, v12, v28
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v13, vcc, v13, v29, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v4, vcc, v4, v20
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v5, vcc, v5, v21, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v4, vcc, v4, v12
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v5, vcc, v5, v13, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v8
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v9, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v2, v10
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v3, vcc, v3, v11, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v8, vcc, v14, v30
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v9, vcc, v15, v18, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v6, vcc, v6, v8
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v7, vcc, v7, v9, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v2, vcc, v2, v6
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v3, vcc, v3, v7, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v4
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v5, vcc
; GFX8-SDAG-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-SDAG-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_add_v16i64:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v16
; GFX8-GISEL-NEXT:    buffer_load_dword v16, off, s[0:3], s32
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v1, v17, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, v2, v18
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v3, vcc, v3, v19, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v4, vcc, v4, v20
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v5, vcc, v5, v21, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v6, vcc, v6, v22
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v7, vcc, v7, v23, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v8, vcc, v8, v24
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v9, vcc, v9, v25, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v10, vcc, v10, v26
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v11, vcc, v11, v27, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v12, vcc, v12, v28
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v13, vcc, v13, v29, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v8
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v1, v9, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, v2, v10
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v3, vcc, v3, v11, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v4, vcc, v4, v12
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v5, vcc, v5, v13, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v8, vcc, v14, v30
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v9, vcc, v15, v16, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v6, vcc, v6, v8
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v7, vcc, v7, v9, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v4
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v1, v5, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v2, vcc, v2, v6
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v3, vcc, v3, v7, vcc
; GFX8-GISEL-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-GISEL-NEXT:    v_addc_u32_e32 v1, vcc, v1, v3, vcc
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_add_v16i64:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    scratch_load_dword v31, off, s32
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[8:9], v[8:9], 0, v[24:25]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[0:1], v[0:1], 0, v[16:17]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[12:13], v[12:13], 0, v[28:29]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[4:5], v[4:5], 0, v[20:21]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[4:5], v[4:5], 0, v[12:13]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[0:1], v[0:1], 0, v[8:9]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[10:11], v[10:11], 0, v[26:27]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[2:3], v[2:3], 0, v[18:19]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[6:7], v[6:7], 0, v[22:23]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[0:1], v[0:1], 0, v[4:5]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[2:3], v[2:3], 0, v[10:11]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[4:5], v[14:15], 0, v[30:31]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[4:5], v[6:7], 0, v[4:5]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[2:3], v[2:3], 0, v[4:5]
; GFX9-SDAG-NEXT:    v_lshl_add_u64 v[0:1], v[0:1], 0, v[2:3]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_add_v16i64:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    scratch_load_dword v31, off, s32
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v16
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v17, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v18
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v19, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v4, vcc, v4, v20
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v5, vcc, v5, v21, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v6, vcc, v6, v22
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v7, vcc, v7, v23, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v8, vcc, v8, v24
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v9, vcc, v9, v25, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v10, vcc, v10, v26
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v11, vcc, v11, v27, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v12, vcc, v12, v28
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v13, vcc, v13, v29, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v8
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v9, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v10
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v11, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v4, vcc, v4, v12
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v5, vcc, v5, v13, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v8, vcc, v14, v30
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    s_nop 0
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v9, vcc, v15, v31, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v6, vcc, v6, v8
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v7, vcc, v7, v9, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v4
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v5, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v2, vcc, v2, v6
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v7, vcc
; GFX9-GISEL-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v2
; GFX9-GISEL-NEXT:    s_nop 1
; GFX9-GISEL-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_add_v16i64:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX10-SDAG-NEXT:    v_add_co_u32 v10, vcc_lo, v10, v26
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v11, vcc_lo, v11, v27, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v18
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, v3, v19, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v6, vcc_lo, v6, v22
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v7, vcc_lo, v7, v23, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v8, vcc_lo, v8, v24
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v9, vcc_lo, v9, v25, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v12, vcc_lo, v12, v28
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v13, vcc_lo, v13, v29, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v20
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, v5, v21, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v16
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v17, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v12
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, v5, v13, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v12, vcc_lo, v14, v30
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v13, vcc_lo, v15, v31, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v10
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, v3, v11, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v6, vcc_lo, v6, v12
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v7, vcc_lo, v7, v13, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v8
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v9, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, v3, v7, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v5, vcc_lo
; GFX10-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-SDAG-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_add_v16i64:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v16
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v17, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v18
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, v3, v19, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v20
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, v5, v21, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v6, vcc_lo, v6, v22
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v7, vcc_lo, v7, v23, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v8, vcc_lo, v8, v24
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v9, vcc_lo, v9, v25, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v10, vcc_lo, v10, v26
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v11, vcc_lo, v11, v27, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v12, vcc_lo, v12, v28
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v13, vcc_lo, v13, v29, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v8
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v9, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v10
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, v3, v11, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v8, vcc_lo, v14, v30
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v9, vcc_lo, v15, v31, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v12
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, v5, v13, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v6, vcc_lo, v6, v8
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v7, vcc_lo, v7, v9, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v5, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, v3, v7, vcc_lo
; GFX10-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX10-GISEL-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, v1, v3, vcc_lo
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_add_v16i64:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-SDAG-NEXT:    v_add_co_u32 v10, vcc_lo, v10, v26
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v11, null, v11, v27, vcc_lo
; GFX11-SDAG-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v18
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v19, vcc_lo
; GFX11-SDAG-NEXT:    v_add_co_u32 v6, vcc_lo, v6, v22
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v7, null, v7, v23, vcc_lo
; GFX11-SDAG-NEXT:    v_add_co_u32 v8, vcc_lo, v8, v24
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v9, null, v9, v25, vcc_lo
; GFX11-SDAG-NEXT:    v_add_co_u32 v12, vcc_lo, v12, v28
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v13, null, v13, v29, vcc_lo
; GFX11-SDAG-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v20
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v5, null, v5, v21, vcc_lo
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v16
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v17, vcc_lo
; GFX11-SDAG-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v12
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v5, null, v5, v13, vcc_lo
; GFX11-SDAG-NEXT:    v_add_co_u32 v12, vcc_lo, v14, v30
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v13, null, v15, v31, vcc_lo
; GFX11-SDAG-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v10
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v11, vcc_lo
; GFX11-SDAG-NEXT:    v_add_co_u32 v6, vcc_lo, v6, v12
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v7, null, v7, v13, vcc_lo
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v8
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v9, vcc_lo
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v7, vcc_lo
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v5, vcc_lo
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_add_v16i64:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v16
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v17, vcc_lo
; GFX11-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v18
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v19, vcc_lo
; GFX11-GISEL-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v20
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v5, null, v5, v21, vcc_lo
; GFX11-GISEL-NEXT:    v_add_co_u32 v6, vcc_lo, v6, v22
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v7, null, v7, v23, vcc_lo
; GFX11-GISEL-NEXT:    v_add_co_u32 v8, vcc_lo, v8, v24
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v9, null, v9, v25, vcc_lo
; GFX11-GISEL-NEXT:    v_add_co_u32 v10, vcc_lo, v10, v26
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v11, null, v11, v27, vcc_lo
; GFX11-GISEL-NEXT:    v_add_co_u32 v12, vcc_lo, v12, v28
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v13, null, v13, v29, vcc_lo
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v8
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v9, vcc_lo
; GFX11-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v10
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v11, vcc_lo
; GFX11-GISEL-NEXT:    v_add_co_u32 v8, vcc_lo, v14, v30
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v9, null, v15, v31, vcc_lo
; GFX11-GISEL-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v12
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v5, null, v5, v13, vcc_lo
; GFX11-GISEL-NEXT:    v_add_co_u32 v6, vcc_lo, v6, v8
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v7, null, v7, v9, vcc_lo
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v5, vcc_lo
; GFX11-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v7, vcc_lo
; GFX11-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_add_v16i64:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    scratch_load_b32 v31, off, s32
; GFX12-SDAG-NEXT:    v_add_co_u32 v10, vcc_lo, v10, v26
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v11, null, v11, v27, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v18
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v19, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v6, vcc_lo, v6, v22
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v7, null, v7, v23, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v8, vcc_lo, v8, v24
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v9, null, v9, v25, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v12, vcc_lo, v12, v28
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v13, null, v13, v29, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v20
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v5, null, v5, v21, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v16
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v17, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v12
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v5, null, v5, v13, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v12, vcc_lo, v14, v30
; GFX12-SDAG-NEXT:    s_wait_loadcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v13, null, v15, v31, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v10
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v11, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v6, vcc_lo, v6, v12
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v7, null, v7, v13, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v8
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v9, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v7, vcc_lo
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v5, vcc_lo
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-SDAG-NEXT:    s_wait_alu 0xfffd
; GFX12-SDAG-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_add_v16i64:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    scratch_load_b32 v31, off, s32
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v16
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v17, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v18
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v19, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v20
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v5, null, v5, v21, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v6, vcc_lo, v6, v22
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v7, null, v7, v23, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v8, vcc_lo, v8, v24
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v9, null, v9, v25, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v10, vcc_lo, v10, v26
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v11, null, v11, v27, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v12, vcc_lo, v12, v28
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v13, null, v13, v29, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v8
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v9, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v10
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v11, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v8, vcc_lo, v14, v30
; GFX12-GISEL-NEXT:    s_wait_loadcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v9, null, v15, v31, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v4, vcc_lo, v4, v12
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v5, null, v5, v13, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v6, vcc_lo, v6, v8
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v7, null, v7, v9, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v4
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v5, vcc_lo
; GFX12-GISEL-NEXT:    v_add_co_u32 v2, vcc_lo, v2, v6
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v3, null, v3, v7, vcc_lo
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-NEXT:    v_add_co_u32 v0, vcc_lo, v0, v2
; GFX12-GISEL-NEXT:    s_wait_alu 0xfffd
; GFX12-GISEL-NEXT:    v_add_co_ci_u32_e64 v1, null, v1, v3, vcc_lo
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call i64 @llvm.vector.reduce.add.v16i64(<16 x i64> %v)
  ret i64 %res
}

declare i8 @llvm.vector.reduce.add.v2i8(<2 x i8>)
declare i8 @llvm.vector.reduce.add.v3i8(<3 x i8>)
declare i8 @llvm.vector.reduce.add.v4i8(<4 x i8>)
declare i8 @llvm.vector.reduce.add.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.add.v16i8(<16 x i8>)

declare i16 @llvm.vector.reduce.add.v2i16(<2 x i16>)
declare i16 @llvm.vector.reduce.add.v3i16(<3 x i16>)
declare i16 @llvm.vector.reduce.add.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.add.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.add.v16i16(<16 x i16>)

declare i32 @llvm.vector.reduce.add.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.add.v3i32(<3 x i32>)
declare i32 @llvm.vector.reduce.add.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.add.v8i32(<8 x i32>)
declare i32 @llvm.vector.reduce.add.v16i32(<16 x i32>)

declare i64 @llvm.vector.reduce.add.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.add.v3i64(<3 x i64>)
declare i64 @llvm.vector.reduce.add.v4i64(<4 x i64>)
declare i64 @llvm.vector.reduce.add.v8i64(<8 x i64>)
declare i64 @llvm.vector.reduce.add.v16i64(<16 x i64>)
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX11-GISEL-FAKE16: {{.*}}
; GFX12-GISEL-FAKE16: {{.*}}
