# Checks for LZMA codec support
#
# Copyright © 2015 Open Microscopy Environment / University of Dundee
# Copyright © 2021 Roger Leigh <rleigh@codelibre.net>
# Written by Roger Leigh <rleigh@codelibre.net>
#
# Permission to use, copy, modify, distribute, and sell this software and
# its documentation for any purpose is hereby granted without fee, provided
# that (i) the above copyright notices and this permission notice appear in
# all copies of the software and related documentation, and (ii) the names of
# Sam Leffler and Silicon Graphics may not be used in any advertising or
# publicity relating to the software without the specific, prior written
# permission of Sam Leffler and Silicon Graphics.
#
# THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
# EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
# WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
#
# IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
# ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
# OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
# WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
# LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
# OF THIS SOFTWARE.


# libzstd
set(ZSTD_SUPPORT FALSE)
set(ZSTD_USABLE FALSE)

find_package(ZSTD)

if(ZSTD_FOUND)
    if(TARGET zstd::libzstd_shared)
        add_library(ZSTD::ZSTD ALIAS zstd::libzstd_shared)
        set(ZSTD_HAVE_DECOMPRESS_STREAM ON)
    elseif(TARGET zstd::libzstd_static)
        add_library(ZSTD::ZSTD ALIAS zstd::libzstd_static)
        set(ZSTD_HAVE_DECOMPRESS_STREAM ON)
    endif()

    if(NOT DEFINED ZSTD_HAVE_DECOMPRESS_STREAM)
      set(CMAKE_REQUIRED_INCLUDES_SAVE ${CMAKE_REQUIRED_INCLUDES})
      set(CMAKE_REQUIRED_INCLUDES ${CMAKE_REQUIRED_INCLUDES} ${ZSTD_INCLUDE_DIRS})
      set(CMAKE_REQUIRED_LIBRARIES_SAVE ${CMAKE_REQUIRED_LIBRARIES})
      set(CMAKE_REQUIRED_LIBRARIES ${CMAKE_REQUIRED_LIBRARIES} ${ZSTD_LIBRARIES})
      check_symbol_exists(ZSTD_decompressStream "zstd.h" ZSTD_HAVE_DECOMPRESS_STREAM)
      set(CMAKE_REQUIRED_INCLUDES ${CMAKE_REQUIRED_INCLUDES_SAVE})
      set(CMAKE_REQUIRED_LIBRARIES ${CMAKE_REQUIRED_LIBRARIES_SAVE})
    endif()
    set(ZSTD_RECENT_ENOUGH ${ZSTD_HAVE_DECOMPRESS_STREAM})

    if (ZSTD_RECENT_ENOUGH)
        set(ZSTD_USABLE TRUE)
    else()
        message(WARNING "Found ZSTD library, but not recent enough. Use zstd >= 1.0")
    endif()
endif()

option(zstd "use libzstd (required for ZSTD compression)" ${ZSTD_USABLE})

if (zstd AND ZSTD_USABLE)
    set(ZSTD_SUPPORT TRUE)
endif()
