/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.task;

import org.jsampler.CC;
import org.jsampler.JSI18n;
import org.jsampler.task.EnhancedTask;
import org.jsampler.view.JSChannel;
import org.linuxsampler.lscp.Client;
import org.linuxsampler.lscp.SamplerChannel;

public class DuplicateChannels
extends EnhancedTask {
    SamplerChannel[] chnS;

    public DuplicateChannels(SamplerChannel samplerChannel) {
        this.initTask();
        this.chnS = new SamplerChannel[1];
        this.chnS[0] = samplerChannel;
    }

    public DuplicateChannels(JSChannel[] jSChannelArray) {
        this.initTask();
        this.chnS = new SamplerChannel[jSChannelArray.length];
        for (int i = 0; i < jSChannelArray.length; ++i) {
            this.chnS[i] = jSChannelArray[i].getChannelInfo();
        }
    }

    private void initTask() {
        this.setTitle("DuplicateChannels_task");
        this.setDescription(JSI18n.i18n.getMessage("DuplicateChannels.description"));
    }

    @Override
    public void exec() throws Exception {
        for (SamplerChannel samplerChannel : this.chnS) {
            this.duplicateSettings(samplerChannel, CC.getClient().addSamplerChannel());
        }
    }

    private void duplicateSettings(SamplerChannel samplerChannel, int n) throws Exception {
        Client client = CC.getClient();
        if (samplerChannel.getMidiInputDevice() >= 0) {
            client.setChannelMidiInputDevice(n, samplerChannel.getMidiInputDevice());
            client.setChannelMidiInputPort(n, samplerChannel.getMidiInputPort());
            client.setChannelMidiInputChannel(n, samplerChannel.getMidiInputChannel());
        }
        if (samplerChannel.getAudioOutputDevice() >= 0) {
            client.setChannelAudioOutputDevice(n, samplerChannel.getAudioOutputDevice());
        }
        if (samplerChannel.getEngine() != null) {
            client.loadSamplerEngine(samplerChannel.getEngine().getName(), n);
            client.setChannelVolume(n, samplerChannel.getVolume());
            if (samplerChannel.isSoloChannel()) {
                client.setChannelSolo(n, true);
            }
            if (samplerChannel.isMuted() && !samplerChannel.isMutedBySolo()) {
                client.setChannelMute(n, true);
            }
            if (samplerChannel.getInstrumentFile() != null) {
                client.loadInstrument(samplerChannel.getInstrumentFile(), samplerChannel.getInstrumentIndex(), n, true);
            }
        }
    }
}

