# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.keyvault.aio import KeyVaultManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestKeyVaultManagementManagedHsmKeysOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(KeyVaultManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_hsm_keys_create_if_not_exist(self, resource_group):
        response = await self.client.managed_hsm_keys.create_if_not_exist(
            resource_group_name=resource_group.name,
            name="str",
            key_name="str",
            parameters={
                "properties": {
                    "attributes": {
                        "created": 0,
                        "enabled": bool,
                        "exp": 0,
                        "exportable": bool,
                        "nbf": 0,
                        "recoveryLevel": "str",
                        "updated": 0,
                    },
                    "curveName": "str",
                    "keyOps": ["str"],
                    "keySize": 0,
                    "keyUri": "str",
                    "keyUriWithVersion": "str",
                    "kty": "str",
                    "release_policy": {
                        "contentType": "application/json; charset=utf-8",
                        "data": bytes("bytes", encoding="utf-8"),
                    },
                    "rotationPolicy": {
                        "attributes": {"created": 0, "expiryTime": "str", "updated": 0},
                        "lifetimeActions": [
                            {
                                "action": {"type": "str"},
                                "trigger": {"timeAfterCreate": "str", "timeBeforeExpiry": "str"},
                            }
                        ],
                    },
                },
                "tags": {"str": "str"},
            },
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_hsm_keys_get(self, resource_group):
        response = await self.client.managed_hsm_keys.get(
            resource_group_name=resource_group.name,
            name="str",
            key_name="str",
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_hsm_keys_list(self, resource_group):
        response = self.client.managed_hsm_keys.list(
            resource_group_name=resource_group.name,
            name="str",
            api_version="2025-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_hsm_keys_get_version(self, resource_group):
        response = await self.client.managed_hsm_keys.get_version(
            resource_group_name=resource_group.name,
            name="str",
            key_name="str",
            key_version="str",
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_hsm_keys_list_versions(self, resource_group):
        response = self.client.managed_hsm_keys.list_versions(
            resource_group_name=resource_group.name,
            name="str",
            key_name="str",
            api_version="2025-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
