"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getComponentDirectives = getComponentDirectives;
const language_core_1 = require("@vue/language-core");
const utils_1 = require("./utils");
function getComponentDirectives(fileName) {
    const { typescript: ts, language, languageService, getFileId } = this;
    const volarFile = language.scripts.get(getFileId(fileName));
    if (!(volarFile?.generated?.root instanceof language_core_1.VueVirtualCode)) {
        return;
    }
    const vueCode = volarFile.generated.root;
    const directives = (0, utils_1.getVariableType)(ts, languageService, vueCode, '__VLS_directives');
    if (!directives) {
        return [];
    }
    return directives.type.getProperties()
        .map(({ name }) => name)
        .filter(name => name.startsWith('v') && name.length >= 2 && name[1] === name[1].toUpperCase())
        .filter(name => !['vBind', 'vIf', 'vOn', 'VOnce', 'vShow', 'VSlot'].includes(name));
}
//# sourceMappingURL=getComponentDirectives.js.map