/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.Version;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.indexmanagement.util.OpenForTesting;

@OpenForTesting
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@RX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@RX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/SkipExecution;", "", "()V", "<set-?>", "", "flag", "getFlag", "()Z", "hasLegacyPlugin", "getHasLegacyPlugin", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "sweepISMPluginVersion", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "opensearch-index-management"})
public class SkipExecution {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private volatile boolean flag;
    private volatile boolean hasLegacyPlugin;

    public final boolean getFlag() {
        return this.flag;
    }

    public final boolean getHasLegacyPlugin() {
        return this.hasLegacyPlugin;
    }

    public void sweepISMPluginVersion(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        try {
            Version currentMinVersion = clusterService.state().getNodes().getMinNodeVersion();
            Version currentMaxVersion = clusterService.state().getNodes().getMaxNodeVersion();
            if (currentMinVersion != null && !currentMinVersion.equals((Object)currentMaxVersion)) {
                this.flag = true;
                this.logger.info("There are multiple versions of Index Management plugins in the cluster: [" + currentMaxVersion + ", " + currentMinVersion + "]");
            } else {
                this.flag = false;
            }
            if (currentMinVersion.major > Version.CURRENT.major && !Intrinsics.areEqual((Object)currentMinVersion, (Object)currentMaxVersion)) {
                this.hasLegacyPlugin = true;
                this.logger.info("Found legacy plugin versions [" + currentMinVersion + "] and opensearch plugins versions [" + currentMaxVersion + "] in the cluster");
            } else {
                this.hasLegacyPlugin = false;
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to fetch node versions from cluster service", (Throwable)e);
        }
    }
}

