include(CMakeFindDependencyMacro)

set(REQUIRED_VARS)

if(TRUE)
	find_dependency(ZLIB)
	list(APPEND REQUIRED_VARS ZLIB_FOUND)
endif()

if(1)
  find_dependency(PkgConfig REQUIRED)
  pkg_search_module(zstd IMPORTED_TARGET GLOBAL libzstd)
	list(APPEND REQUIRED_VARS zstd_FOUND)
endif()

if()
	find_dependency(nvcomp)
	list(APPEND REQUIRED_VARS NVCOMP_FOUND)
endif()

if()
	find_dependency(CUDAToolkit)
	list(APPEND REQUIRED_VARS CUDAToolkit_FOUND)
endif()

if()
	find_dependency(MOAB)
	list(APPEND REQUIRED_VARS MOAB_FOUND)
endif()

if(1)
	find_package(PkgConfig REQUIRED)
	pkg_search_module(protobuf IMPORTED_TARGET GLOBAL REQUIRED protobuf>=3.0.0)
	list(APPEND REQUIRED_VARS protobuf_FOUND)
endif()

if(TRUE)
	find_dependency(OpenMP)
	list(APPEND REQUIRED_VARS OpenMP_FOUND)
endif()

include(FindPackageHandleStandardArgs)
set(${CMAKE_FIND_PACKAGE_NAME}_CONFIG ${CMAKE_CURRENT_LIST_FILE})
find_package_handle_standard_args(
	${CMAKE_FIND_PACKAGE_NAME}
	REQUIRED_VARS ${REQUIRED_VARS}
	CONFIG_MODE
)

set(MGARD_ENABLE_SERIAL ON)
set(MGARD_ENABLE_CUDA OFF)
set(MGARD_ENABLE_HIP OFF)
set(MGARD_ENABLE_SYCL OFF)
set(MGARD_ENABLE_OPENMP ON)
set(MGARD_ENABLE_LEGACY_CUDA OFF)
set(MGARD_ENABLE_COORDINATE_NORMALIZATION ON)
set(MGARD_ENABLE_MDR ON)

if(NOT TARGET mgard::mgard)
  include("${CMAKE_CURRENT_LIST_DIR}/mgard-targets.cmake")
endif()

set(MGARD_LIBRARIES mgard::mgard)
set(MGARD_INCLUDE_DIRS
  $<TARGET_PROPERTY:mgard::mgard,INTERFACE_INCLUDE_DIRECTORIES>
)
