/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.monitor;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.ext.thread.Mutex;
import org.jruby.runtime.Block;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Monitor"})
public class Monitor
extends RubyObject {
    private final Mutex mutex;
    private volatile RubyThread owner;
    private volatile long count;

    public Monitor(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.mutex = new Mutex(runtime2, runtime2.getMutex());
    }

    public static void createMonitorClass(ThreadContext context) {
        Define.defineClass(context, "Monitor", Access.objectClass(context), Monitor::new).defineMethods(context, Monitor.class);
    }

    @JRubyMethod
    public RubyBoolean try_enter(ThreadContext context) {
        if (!this.ownedByCurrentThread(context)) {
            if (!this.mutex.tryLock(context)) {
                return context.fals;
            }
            this.owner = context.getThread();
            this.count = 0L;
        }
        ++this.count;
        return context.tru;
    }

    @JRubyMethod
    public IRubyObject enter(ThreadContext context) {
        if (!this.ownedByCurrentThread(context)) {
            this.mutex.lock(context);
            this.owner = context.getThread();
            this.count = 0L;
        }
        ++this.count;
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject exit(ThreadContext context) {
        this.mon_check_owner(context);
        if (this.count <= 0L) {
            throw Error.runtimeError(context, "monitor_exit: count:" + this.count + "\n");
        }
        --this.count;
        if (this.count == 0L) {
            this.owner = null;
            this.mutex.unlock(context);
        }
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject synchronize(ThreadContext context, Block block) {
        this.enter(context);
        try {
            IRubyObject iRubyObject = block.yieldSpecific(context);
            return iRubyObject;
        }
        finally {
            this.exit(context);
        }
    }

    @JRubyMethod(name={"mon_locked?"})
    public IRubyObject mon_locked_p(ThreadContext context) {
        return this.mutex.locked_p(context);
    }

    @JRubyMethod
    public IRubyObject mon_check_owner(ThreadContext context) {
        this.checkOwner(context);
        return context.nil;
    }

    @JRubyMethod(name={"mon_owned?"})
    public RubyBoolean mon_owned_p(ThreadContext context) {
        return Convert.asBoolean(context, this.ownedByCurrentThread(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject wait_for_cond(ThreadContext context, IRubyObject cond, IRubyObject timeout2) {
        long count2 = this.exitForCondition();
        try {
            Monitor.sites((ThreadContext)context).wait.call(context, cond, cond, (IRubyObject)this.mutex, timeout2);
            RubyBoolean rubyBoolean = context.tru;
            return rubyBoolean;
        }
        finally {
            this.owner = context.getThread();
            this.count = count2;
        }
    }

    private boolean ownedByCurrentThread(ThreadContext context) {
        return this.owner == context.getThread();
    }

    private void checkOwner(ThreadContext context) {
        if (!this.ownedByCurrentThread(context)) {
            throw context.runtime.newThreadError("current thread not owner");
        }
    }

    private long exitForCondition() {
        long cnt = this.count;
        this.owner = null;
        this.count = 0L;
        return cnt;
    }

    private static JavaSites.MonitorSites sites(ThreadContext context) {
        return context.sites.Monitor;
    }
}

