/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.jruby.anno.MethodDescriptor;

public class ExecutableElementDescriptor
extends MethodDescriptor<ExecutableElement> {
    public final ExecutableElement method;

    public ExecutableElementDescriptor(ExecutableElement method2) {
        super(method2);
        this.method = method2;
    }

    @Override
    protected <A extends Annotation> A getAnnotation(ExecutableElement methodObject, Class<A> annotationType) {
        return methodObject.getAnnotation(annotationType);
    }

    @Override
    protected int getModifiers(ExecutableElement methodObject) {
        Set<Modifier> mods = methodObject.getModifiers();
        int modifierTmp = 0;
        try {
            for (Modifier mod : mods) {
                modifierTmp |= ((Integer)java.lang.reflect.Modifier.class.getField(mod.name()).get(null)).intValue();
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return modifierTmp;
    }

    @Override
    protected String getDeclaringClassName(ExecutableElement methodObject) {
        return ExecutableElementDescriptor.getActualQualifiedName((TypeElement)methodObject.getEnclosingElement()).toString();
    }

    @Override
    protected String getSimpleName(ExecutableElement methodObject) {
        return methodObject.getSimpleName().toString();
    }

    @Override
    protected boolean hasContext(ExecutableElement methodObject) {
        List<? extends VariableElement> symbolicParameters = methodObject.getParameters();
        if (symbolicParameters.size() > 0) {
            return symbolicParameters.get(0).asType().toString().equals("org.jruby.runtime.ThreadContext");
        }
        return false;
    }

    @Override
    protected boolean hasBlock(ExecutableElement methodObject) {
        List<? extends VariableElement> symbolicParameters = methodObject.getParameters();
        if (symbolicParameters.size() > 0) {
            return symbolicParameters.get(symbolicParameters.size() - 1).asType().toString().equals("org.jruby.runtime.Block");
        }
        return false;
    }

    @Override
    protected int parameterCount(ExecutableElement methodObject) {
        return methodObject.getParameters().size();
    }

    @Override
    protected String parameterAsString(ExecutableElement methodObject, int index2) {
        return methodObject.getParameters().get(index2).asType().toString();
    }

    public static CharSequence getActualQualifiedName(TypeElement td) {
        if (td.getNestingKind() == NestingKind.MEMBER) {
            return String.valueOf(ExecutableElementDescriptor.getActualQualifiedName((TypeElement)td.getEnclosingElement())) + "$" + String.valueOf(td.getSimpleName());
        }
        return td.getQualifiedName().toString();
    }
}

