package Affa::lib;

use strict;
use Date::Format;
use Errno;
use File::Path;
use Time::Local;
require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(ExecCmd setlog lg dbg);

sub dbg( $ );
sub lg( $ );
sub setlog( $ );
sub ExecCmd( \@$ );

our $ExecCmdOutout='';
our $logdir = '/var/log/affa'; # Logdir
our $logfile = "$logdir/affa.log"; # Logfile
our @Messages=(); # List of all log messages
File::Path::mkpath( $logdir, 0, 0700 ) if not -d $logdir;

sub setlog( $ )
	{
	my $s=shift;
	$logfile = "$logdir/$s";
	}

sub lg( $ )
	{
	my $str	= shift(@_);
	chomp($str);
	if (defined($logfile))	
		{
		if( $main::interrupt )
			{
			my $txt=$main::interrupt;
			$main::interrupt='';
			lg( $txt ) 
			}
		open( LOG, ">> $logfile") or die "Error: Couldn't open logfile $logfile for writing\n";
		my $tag = Date::Format::time2str("%a %b %e %T",time()) . "[".($logfile =~ /\/affa.log$/ && $main::jobname?"$main::jobname.":'')."$main::process_id]:";
		$tag .= "  " if( ($main::Command||'') =~ /^(daily|weekly|monthly|yearly)$/ );
		my @s = split( /[\r\n]+/, $str );
		foreach my $se (@s) 
			{
			print LOG "$tag $se\n";
			}
		close(LOG) or warn "Error: Couldn't close logfile $logfile\n";
		chown( 0, 101, $logfile );
		chmod( 0640, $logfile );
		}
	push( @Messages, $str );
	}

sub dbg( $ )
	{
	if( $main::job{'Debug'} eq 'yes' )
		{
		lg( shift(@_) );
		}
	else
		{
		push( @Messages, @_ );
		}
	}


sub ExecCmd( \@$ )
	{
	(my $cmdRef, my $forcelog) = @_;
	my @cmd = @$cmdRef;
	my $pipestatus='';
	$forcelog=1 if $main::job{'Debug'};
	die "Fork failed: $!\n" unless defined( my $pid=open(RCHILD, "-|"));
	if( $pid )
		{
		$ExecCmdOutout='';
		while(<RCHILD>)
			{
			chomp( $_ );
			next if $_ eq '';
			dbg( "Exec Out: $pipestatus" ) if $forcelog and $pipestatus; # one step offset
			$ExecCmdOutout.="$_\n";
			$pipestatus=$_;
			}
		close( RCHILD );
		}
	else
		{
		dbg( "Exec Cmd: @cmd" );
		exec( "@cmd 2>&1; echo \${PIPESTATUS}" ) or die "exec failed: $!\n";
		}
	$ExecCmdOutout =~ s/$pipestatus\n$//;
	$pipestatus =  $? if not $pipestatus;
	dbg( "Exec Out: exitstatus=$pipestatus" ) if $forcelog;
	return $pipestatus;
	}
1;
