#!/usr/bin/perl -w

# FOR USE WITH CYGWIN RSYNCD ON A WINDOWS COMPUTER 

# Important: Values must not contain a '|' (pipe) character

# EDIT THIS:
# used as a key for db and as a filename! 
# Choose a name with <= 10 chars.
my $jobname=''; 

# EDIT THIS:
my %job=(
	'remoteHostName'=>'', # FQHN or IP address
	'rsyncdPassword'=>'', # set rsyncd password here
	'Include[0]'=>'', # files or directories to include, MANDATORY
	#'Include[1]'=>'', 
	#'Include[2]'=>'', 
	'Exclude[0]'=>'', # files or directories to exclude from backup
	#'Exclude[1]'=>'', 
	#'Exclude[2]'=>'', 
	'TimeSchedule'=>'2230', # HHMM,HHMM,...
	'Description'=>'', # text string.
	'scheduledKeep'=>1, # integer >= 1
	'dailyKeep'=>7, # integer >= 0
	'weeklyKeep'=>4,# integer >= 0
	'monthlyKeep'=>12,# integer >= 0
	'yearlyKeep'=>2,# integer >= 0
	'DiskSpaceWarn'=>'strict', # strict | normal | risky | none
	'localNice'=>0, # -19...+19
	'rsyncTimeout'=>900, # seconds
	'rsyncCompress'=>'no', # yes | no
	'EmailAddresses'=>'', # name@domain.com,name@domain.com,...
	'chattyOnSuccess'=>0, # send N success notifications
	'RetryAfter'=>600, # retry after 10 minutes
	'RetryAttempts'=>3,# number of retries
	'RetryNotification'=>'yes', # notify when retrying
	'postJobCommand'=>'', # full path to local program/script
	'preJobCommand'=>'', # full path to local program/script
	'AutomountDevice'=>'', # Device to auto mount (e.g. USB drive)
	'AutomountPoint'=>'', # the mountpoint for AutomountDevice
	'AutomountOptions'=>'', # Optionstring passed to mount command e.g. '-t cifs'
	'AutoUnmount'=>'yes', # umount if fs was not mounted before Affa ran
	'RootDir'=>'/var/affa', # where to save the archives. Don't use /root or /home/e-smith
	'SambaShare'=>'yes', # enable Samba access to the archives
	'Debug'=>'no', # yes | no
	'rsync--modify-window'=>0, # integer >= 0, timestamp window
	'status'=>'enabled', # enabled | disabled

	# do not modify the following properties
	'SMEServer'=>'no',
	'RPMCheck'=>'no',
	'Watchdog'=>'no', # do not modify!
	'rsyncdMode'=>'yes', # do not modify!
	'rsyncdModule'=>'AFFA', # do not modify!
	'rsyncdUser'=>'affa', # do not modify!
	'remoteOS'=>'cygwin', # only used by the send-key option. Not needed for backups.
	);

### nothing to edit below this line ####










# vi: ft=perl
`/sbin/e-smith/affa --version`; # this creates affa db if not exists
use strict;
use esmith::DB::db;


if( not $jobname )
	{
	print "Error: jobname is not set!\n";exit -1;
	} 

if( not $job{'remoteHostName'} )
	{
	print "Error: remoteHostName is not set!\n";exit -1;
	} 

my $affa = esmith::DB::db->open("/home/e-smith/db/affa") or die "Error: Couldn't open /home/e-smith/db/affa db file.";
my $jobconf;
$jobconf = $affa->get($jobname);
if( $jobconf )
	{
	foreach my $k ('doneDaily','doneWeekly','doneMonthly','doneYearly','chattyOnSuccess') # preserve those
		{
		$job{$k} = $affa->get_prop($jobname,$k) unless $job{$k};
		}
	$affa->get($jobname)->delete;
	}
$jobconf = $affa->new_record($jobname);
$jobconf->set_prop('type','job');
while( (my $prop,my$val) = each %job )
	{
	$jobconf->set_prop($prop,$val);
	}
system( '/sbin/e-smith/db', '/home/e-smith/db/affa', 'show', $jobname );
system( '/sbin/e-smith/affa', '--make-cronjobs');
exit 0;
