#!/bin/bash

# This script is part of the Affa package
# Michael Weinberger 2008

export PATH=/bin:/usr/bin
set -o pipefail

ROOTDIR=$1
JOB=$2
ARCHIVE=$3
RESTORE=$4
OUTFILE=$5
BASENAME=`basename $OUTFILE`
SIZE=$6


errorexit()
	{
	STATUS=$?
	if [ ! -z $1 ] ; then
		STATUS=$1
	fi
	echo
	test -f $OUTFILE && rm -f $OUTFILE
	rm -f $OUTFILE.md5sum $PIPE
	exit $STATUS
	}

verifyint()
	{
	echo "Verify terminated by user"
	rm -f $PIPE
	if [ $OUTFILE.md5sum ] ; then
		cat $OUTFILE.md5sum | sed -e s/-/$BASENAME/ > $OUTFILE.md5sum
	fi
	exit 0
	}

trap errorexit SIGTERM SIGINT ERR

echo "Writing $OUTFILE"
PIPE=/tmp/affa.$$.$(date +%s)
rm -f $PIPE
mkfifo $PIPE
(md5sum < $PIPE & /bin/tar -C $ROOTDIR/$JOB/$ARCHIVE -cf -  $RESTORE | /usr/bin/pv -i 0.3 -s $SIZE | /bin/gzip --fast | tee $PIPE > $OUTFILE) > $OUTFILE.md5sum 

STATUS=$?
if [ $STATUS != 0 ] ; then
	errorexit $STATUS
fi

trap verifyint SIGTERM SIGINT 

rm -f $PIPE

GSIZE=$(find $OUTFILE -printf "%s")
if [ $SIZE -gt 0 ] ; then
	CR=$(echo "scale=5; $SIZE/$GSIZE" | bc)
	SPACESAVING=$(echo "scale=5; 100-$GSIZE/$SIZE*100" | bc)
	printf "Compression Ratio: %.1f (%.1f %%)\n" $CR $SPACESAVING
fi

echo "Verifying $OUTFILE (hit CTRL-C to skip)"
cat $OUTFILE | /usr/bin/pv -i 0.1 -s $GSIZE | md5sum --status -c $OUTFILE.md5sum
STATUS=$?
if [ $STATUS != 0 ] ; then
	echo "Verify FAILED"
	errorexit $STATUS
fi

cat $OUTFILE.md5sum | sed -e s/-/$BASENAME/ > $OUTFILE.md5sum

exit 0
