/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Locale;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.Record;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLStringizer;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SupportedGroupsExtension;

final class ECPointFormatsExtension {
    static final HandshakeProducer chNetworkProducer = new CHECPointFormatsProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new CHECPointFormatsConsumer();
    static final SSLExtension.ExtensionConsumer shOnLoadConsumer = new SHECPointFormatsConsumer();
    static final SSLStringizer epfStringizer = new ECPointFormatsStringizer();

    ECPointFormatsExtension() {
    }

    private static final class CHECPointFormatsConsumer
    implements SSLExtension.ExtensionConsumer {
        private CHECPointFormatsConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            ECPointFormatsSpec eCPointFormatsSpec;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_EC_POINT_FORMATS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable ec_point_formats extension", new Object[0]);
                }
                return;
            }
            try {
                eCPointFormatsSpec = new ECPointFormatsSpec(byteBuffer);
            }
            catch (IOException iOException) {
                serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
                return;
            }
            if (!eCPointFormatsSpec.hasUncompressedFormat()) {
                serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Invalid ec_point_formats extension data: peer does not support uncompressed points");
            }
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.CH_EC_POINT_FORMATS, eCPointFormatsSpec);
        }
    }

    private static final class CHECPointFormatsProducer
    implements HandshakeProducer {
        private CHECPointFormatsProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_EC_POINT_FORMATS)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Ignore unavailable ec_point_formats extension", new Object[0]);
                }
                return null;
            }
            if (SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_ECDHE.isSupported(clientHandshakeContext.activeCipherSuites)) {
                byte[] byArray = new byte[]{1, 0};
                clientHandshakeContext.handshakeExtensions.put(SSLExtension.CH_EC_POINT_FORMATS, ECPointFormatsSpec.DEFAULT);
                return byArray;
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Need no ec_point_formats extension", new Object[0]);
            }
            return null;
        }
    }

    private static enum ECPointFormat {
        UNCOMPRESSED(0, "uncompressed"),
        ANSIX962_COMPRESSED_PRIME(1, "ansiX962_compressed_prime"),
        FMT_ANSIX962_COMPRESSED_CHAR2(2, "ansiX962_compressed_char2");

        final byte id;
        final String name;

        private ECPointFormat(byte by, String string2) {
            this.id = by;
            this.name = string2;
        }

        static String nameOf(int n) {
            for (ECPointFormat eCPointFormat : ECPointFormat.values()) {
                if (eCPointFormat.id != n) continue;
                return eCPointFormat.name;
            }
            return "UNDEFINED-EC-POINT-FORMAT(" + n + ")";
        }
    }

    static class ECPointFormatsSpec
    implements SSLExtension.SSLExtensionSpec {
        static final ECPointFormatsSpec DEFAULT = new ECPointFormatsSpec(new byte[]{ECPointFormat.UNCOMPRESSED.id});
        final byte[] formats;

        ECPointFormatsSpec(byte[] byArray) {
            this.formats = byArray;
        }

        private ECPointFormatsSpec(ByteBuffer byteBuffer) throws IOException {
            if (!byteBuffer.hasRemaining()) {
                throw new SSLProtocolException("Invalid ec_point_formats extension: insufficient data");
            }
            this.formats = Record.getBytes8(byteBuffer);
        }

        private boolean hasUncompressedFormat() {
            for (byte by : this.formats) {
                if (by != ECPointFormat.UNCOMPRESSED.id) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"formats\": '['{0}']'", Locale.ENGLISH);
            if (this.formats == null || this.formats.length == 0) {
                Object[] objectArray = new Object[]{"<no EC point format specified>"};
                return messageFormat.format(objectArray);
            }
            StringBuilder stringBuilder = new StringBuilder(512);
            boolean bl = true;
            for (byte by : this.formats) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(ECPointFormat.nameOf(by));
            }
            Object[] objectArray = new Object[]{stringBuilder.toString()};
            return messageFormat.format(objectArray);
        }
    }

    private static final class ECPointFormatsStringizer
    implements SSLStringizer {
        private ECPointFormatsStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new ECPointFormatsSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }

    private static final class SHECPointFormatsConsumer
    implements SSLExtension.ExtensionConsumer {
        private SHECPointFormatsConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            ECPointFormatsSpec eCPointFormatsSpec;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            ECPointFormatsSpec eCPointFormatsSpec2 = (ECPointFormatsSpec)clientHandshakeContext.handshakeExtensions.get(SSLExtension.CH_EC_POINT_FORMATS);
            if (eCPointFormatsSpec2 == null) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected ec_point_formats extension in ServerHello");
            }
            try {
                eCPointFormatsSpec = new ECPointFormatsSpec(byteBuffer);
            }
            catch (IOException iOException) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
                return;
            }
            if (!eCPointFormatsSpec.hasUncompressedFormat()) {
                clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Invalid ec_point_formats extension data: peer does not support uncompressed points");
            }
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.CH_EC_POINT_FORMATS, eCPointFormatsSpec);
        }
    }
}

