/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mscapi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.SecurityPermission;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import sun.security.mscapi.CKey;
import sun.security.mscapi.CPrivateKey;

abstract class CKeyStore
extends KeyStoreSpi {
    private CertificateFactory certificateFactory = null;
    private static final String KEYSTORE_COMPATIBILITY_MODE_PROP = "sun.security.mscapi.keyStoreCompatibilityMode";
    private final boolean keyStoreCompatibilityMode;
    private Map<String, KeyEntry> entries = new HashMap<String, KeyEntry>();
    private final String storeName;

    CKeyStore(String string) {
        String string2 = AccessController.doPrivileged(() -> System.getProperty(KEYSTORE_COMPATIBILITY_MODE_PROP));
        this.keyStoreCompatibilityMode = !"false".equalsIgnoreCase(string2);
        this.storeName = string;
    }

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (string == null) {
            return null;
        }
        if (cArray != null && !this.keyStoreCompatibilityMode) {
            throw new UnrecoverableKeyException("Password must be null");
        }
        if (!this.engineIsKeyEntry(string)) {
            return null;
        }
        KeyEntry keyEntry = this.entries.get(string);
        return keyEntry == null ? null : keyEntry.getPrivateKey();
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        if (string == null) {
            return null;
        }
        KeyEntry keyEntry = this.entries.get(string);
        X509Certificate[] x509CertificateArray = keyEntry == null ? null : keyEntry.getCertificateChain();
        return x509CertificateArray == null ? null : (Certificate[])x509CertificateArray.clone();
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        if (string == null) {
            return null;
        }
        KeyEntry keyEntry = this.entries.get(string);
        X509Certificate[] x509CertificateArray = keyEntry == null ? null : keyEntry.getCertificateChain();
        return x509CertificateArray == null || x509CertificateArray.length == 0 ? null : x509CertificateArray[0];
    }

    @Override
    public Date engineGetCreationDate(String string) {
        if (string == null) {
            return null;
        }
        return new Date();
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (string == null) {
            throw new KeyStoreException("alias must not be null");
        }
        if (cArray != null && !this.keyStoreCompatibilityMode) {
            throw new KeyStoreException("Password must be null");
        }
        if (key instanceof RSAPrivateCrtKey) {
            X509Certificate[] x509CertificateArray;
            KeyEntry keyEntry = this.entries.get(string);
            if (certificateArray != null) {
                if (certificateArray instanceof X509Certificate[]) {
                    x509CertificateArray = (X509Certificate[])certificateArray;
                } else {
                    x509CertificateArray = new X509Certificate[certificateArray.length];
                    System.arraycopy(certificateArray, 0, x509CertificateArray, 0, certificateArray.length);
                }
            } else {
                x509CertificateArray = null;
            }
            if (keyEntry == null) {
                keyEntry = new KeyEntry(string, null, x509CertificateArray);
                this.storeWithUniqueAlias(string, keyEntry);
            }
            keyEntry.setAlias(string);
            try {
                keyEntry.setRSAPrivateKey(key);
                keyEntry.setCertificateChain(x509CertificateArray);
            }
            catch (CertificateException certificateException) {
                throw new KeyStoreException(certificateException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new KeyStoreException(invalidKeyException);
            }
        } else {
            throw new UnsupportedOperationException("Cannot assign the key to the given alias.");
        }
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new UnsupportedOperationException("Cannot assign the encoded key to the given alias.");
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (string == null) {
            throw new KeyStoreException("alias must not be null");
        }
        if (certificate instanceof X509Certificate) {
            X509Certificate[] x509CertificateArray = new X509Certificate[]{(X509Certificate)certificate};
            KeyEntry keyEntry = this.entries.get(string);
            if (keyEntry == null) {
                keyEntry = new KeyEntry(string, null, x509CertificateArray);
                this.storeWithUniqueAlias(string, keyEntry);
            }
            if (keyEntry.getPrivateKey() == null) {
                keyEntry.setAlias(string);
                try {
                    keyEntry.setCertificateChain(x509CertificateArray);
                }
                catch (CertificateException certificateException) {
                    throw new KeyStoreException(certificateException);
                }
            }
        } else {
            throw new UnsupportedOperationException("Cannot assign the certificate to the given alias.");
        }
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        if (string == null) {
            throw new KeyStoreException("alias must not be null");
        }
        KeyEntry keyEntry = this.entries.remove(string);
        if (keyEntry != null) {
            Object object;
            X509Certificate[] x509CertificateArray = keyEntry.getCertificateChain();
            if (x509CertificateArray != null && x509CertificateArray.length > 0) {
                try {
                    object = x509CertificateArray[0].getEncoded();
                    this.removeCertificate(this.getName(), keyEntry.getAlias(), (byte[])object, ((Object)object).length);
                }
                catch (CertificateException certificateException) {
                    throw new KeyStoreException("Cannot remove entry: ", certificateException);
                }
            }
            if ((object = keyEntry.getPrivateKey()) != null) {
                this.destroyKeyContainer(CKey.getContainerName(((CKey)object).getHCryptProvider()));
            }
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        final Iterator<String> iterator = this.entries.keySet().iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)iterator.next();
            }
        };
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this.entries.containsKey(string);
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        if (string == null) {
            return false;
        }
        KeyEntry keyEntry = this.entries.get(string);
        return keyEntry != null && keyEntry.getPrivateKey() != null;
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        if (string == null) {
            return false;
        }
        KeyEntry keyEntry = this.entries.get(string);
        return keyEntry != null && keyEntry.getPrivateKey() == null;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        for (Map.Entry<String, KeyEntry> entry : this.entries.entrySet()) {
            KeyEntry keyEntry = entry.getValue();
            if (keyEntry.certChain == null || keyEntry.certChain.length <= 0 || !keyEntry.certChain[0].equals(certificate)) continue;
            return keyEntry.getAlias();
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (outputStream != null && !this.keyStoreCompatibilityMode) {
            throw new IOException("Keystore output stream must be null");
        }
        if (cArray != null && !this.keyStoreCompatibilityMode) {
            throw new IOException("Keystore password must be null");
        }
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (inputStream != null && !this.keyStoreCompatibilityMode) {
            throw new IOException("Keystore input stream must be null");
        }
        if (cArray != null && !this.keyStoreCompatibilityMode) {
            throw new IOException("Keystore password must be null");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("authProvider.SunMSCAPI"));
        }
        this.entries.clear();
        try {
            this.loadKeysOrCertificateChains(this.getName());
        }
        catch (KeyStoreException keyStoreException) {
            throw new IOException(keyStoreException);
        }
    }

    private void storeWithUniqueAlias(String string, KeyEntry keyEntry) {
        String string2 = string;
        int n = 1;
        while (this.entries.putIfAbsent(string2, keyEntry) != null) {
            string2 = string + " (" + n++ + ")";
        }
    }

    private void generateCertificateChain(String string, Collection<? extends Certificate> collection) {
        try {
            X509Certificate[] x509CertificateArray = new X509Certificate[collection.size()];
            int n = 0;
            Iterator<? extends Certificate> iterator = collection.iterator();
            while (iterator.hasNext()) {
                x509CertificateArray[n] = (X509Certificate)iterator.next();
                ++n;
            }
            this.storeWithUniqueAlias(string, new KeyEntry(string, null, x509CertificateArray));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void generateKeyAndCertificateChain(boolean bl, String string, long l, long l2, int n, Collection<? extends Certificate> collection) {
        try {
            X509Certificate[] x509CertificateArray = new X509Certificate[collection.size()];
            int n2 = 0;
            Iterator<? extends Certificate> iterator = collection.iterator();
            while (iterator.hasNext()) {
                x509CertificateArray[n2] = (X509Certificate)iterator.next();
                ++n2;
            }
            this.storeWithUniqueAlias(string, new KeyEntry(string, CPrivateKey.of(bl ? "RSA" : "EC", l, l2, n), x509CertificateArray));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void generateCertificate(byte[] byArray, Collection<Certificate> collection) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            if (this.certificateFactory == null) {
                this.certificateFactory = CertificateFactory.getInstance("X.509", "SUN");
            }
            Collection<? extends Certificate> collection2 = this.certificateFactory.generateCertificates(byteArrayInputStream);
            collection.addAll(collection2);
        }
        catch (CertificateException certificateException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getName() {
        return this.storeName;
    }

    private native void loadKeysOrCertificateChains(String var1) throws KeyStoreException;

    private native void storeCertificate(String var1, String var2, byte[] var3, int var4, long var5, long var7) throws CertificateException, KeyStoreException;

    private native void removeCertificate(String var1, String var2, byte[] var3, int var4) throws CertificateException, KeyStoreException;

    private native void destroyKeyContainer(String var1) throws KeyStoreException;

    private native byte[] generateRSAPrivateKeyBlob(int var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, byte[] var9) throws InvalidKeyException;

    private native CPrivateKey storePrivateKey(String var1, byte[] var2, String var3, int var4) throws KeyStoreException;

    class KeyEntry {
        private CKey privateKey;
        private X509Certificate[] certChain;
        private String alias;

        KeyEntry(CKey cKey, X509Certificate[] x509CertificateArray) {
            this(null, cKey, x509CertificateArray);
        }

        KeyEntry(String string, CKey cKey, X509Certificate[] x509CertificateArray) {
            this.privateKey = cKey;
            this.certChain = x509CertificateArray;
            this.alias = string == null ? Integer.toString(x509CertificateArray[0].hashCode()) : string;
        }

        String getAlias() {
            return this.alias;
        }

        void setAlias(String string) {
            this.alias = string;
        }

        CKey getPrivateKey() {
            return this.privateKey;
        }

        void setRSAPrivateKey(Key key) throws InvalidKeyException, KeyStoreException {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
            byte[] byArray = rSAPrivateCrtKey.getModulus().toByteArray();
            int n = byArray[0] == 0 ? (byArray.length - 1) * 8 : byArray.length * 8;
            byte[] byArray2 = CKeyStore.this.generateRSAPrivateKeyBlob(n, byArray, rSAPrivateCrtKey.getPublicExponent().toByteArray(), rSAPrivateCrtKey.getPrivateExponent().toByteArray(), rSAPrivateCrtKey.getPrimeP().toByteArray(), rSAPrivateCrtKey.getPrimeQ().toByteArray(), rSAPrivateCrtKey.getPrimeExponentP().toByteArray(), rSAPrivateCrtKey.getPrimeExponentQ().toByteArray(), rSAPrivateCrtKey.getCrtCoefficient().toByteArray());
            this.privateKey = CKeyStore.this.storePrivateKey("RSA", Objects.requireNonNull(byArray2), "{" + UUID.randomUUID().toString() + "}", n);
        }

        X509Certificate[] getCertificateChain() {
            return this.certChain;
        }

        void setCertificateChain(X509Certificate[] x509CertificateArray) throws CertificateException, KeyStoreException {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                byte[] byArray = x509CertificateArray[i].getEncoded();
                if (i == 0 && this.privateKey != null) {
                    CKeyStore.this.storeCertificate(CKeyStore.this.getName(), this.alias, byArray, byArray.length, this.privateKey.getHCryptProvider(), this.privateKey.getHCryptKey());
                    continue;
                }
                CKeyStore.this.storeCertificate(CKeyStore.this.getName(), this.alias, byArray, byArray.length, 0L, 0L);
            }
            this.certChain = x509CertificateArray;
        }
    }

    public static final class ROOT
    extends CKeyStore {
        public ROOT() {
            super("ROOT");
        }
    }

    public static final class MY
    extends CKeyStore {
        public MY() {
            super("MY");
        }
    }
}

