;;; moe-light-theme.el --- An eye-candy theme for Emacser  -*- lexical-binding: t; -*-

;; Copyright (C) 2013-2022 kuanyui

;; Author: kuanyui<azazabc123@gmail.com>
;; Based on "tango-dark-theme"

;; This file is not part of GNU Emacs.
;;
;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

;;; Code:

(deftheme moe-light
  "Face colors for 256 colors terminal (light background).
Moe, moe, kyun!")

(let ((class '((class color) (min-colors 89)))
      ;; Palette colors.
      (yellow-1 "#fce94f") (yellow-2 "#ffd700") (yellow-3 "#c4a000") (yellow-3-5 "#aaaa11") (yellow-4 "#875f00")
      (orange-1 "#ffaf5f") (orange-2 "#ff8700") (orange-3 "#ff5d17") (orange-4 "#d75f00") (orange-5 "#af5f00")
      (magenta-1 "#ff7bbb") (magenta-2 "#ff4ea3") (magenta-3 "#ff1f8b")
      (green-1 "#afff00") (green-2 "#a1db00") (green-3 "#00af00") (green-4 "#008700") (green-5 "#005f00")
      (blue-1 "#5fafd7") (blue-2 "#1f5bff") (blue-3 "#005f87") (blue-4 "#005faf") (blue-5 "#0000af")
      (cyan-1 "#87ffff") (cyan-2 "#87d7af") (cyan-3 "#00d7af") (cyan-4 "#00ac8a") (cyan-5 "#18b2b2") (cyan-6 "#005f5f") (cyan-7 "#236f73") (cyan-8 "#00af87") (cyan-9 "#005f87")
      (purple-1 "#d18aff") (purple-2 "#b218b2") (purple-3 "#6c0099") (purple-4 "#6c0099")
      (red-1 "#ef2929")  (red-2 "#cc0000")  (red-3 "#a40000")
      (white-1 "#eeeeee") (white-2 "#dadada") (white-3 "#c6c6c6") (white-4 "#b2b2b2") (black-1 "#9e9e9e")
      (black-2 "#8a8a8a") (black-3 "#767676") (black-4 "#626262") (black-5 "#5f5f5f") (black-6 "#3a3a3a")
      (LIGHT_BG "#fdfdf6") (white-0 "#ffffff")
      (green-02 "#5fd700") (green-01 "#d7ff00") (green-0 "#d7ff5f") (green-00 "#d7ff87")  (green-00 "#d7ff87")
      (cyan-0 "#d7ffd7")
      (blue-01 "#c3c9f8") (blue-0 "#afd7ff") (blue-00 "#d7d7ff") (blue-000 "#d4e5ff")
      (yellow-0 "#ffff87") (yellow-00 "#ffffaf") (yellow-2-5 "#ffba27")
      (purple-0 "#af87ff") (purple-00 "#e6a8df")
      (red-0 "#ff4b4b") (red-00 "#ffafaf") (red-000 "#ffd5e5")
      (magenta-0 "#ffafd7") (magenta-00 "#ffd7ff")
      (orange-0 "#ffaf87") (orange-00 "#ffd787") (orange-000 "#ffd7af")
      (linum-dark "#87875f") (linum-light "#d7d7af")
      )
  ;; Customize color
  (defconst -moe-light-bg                        LIGHT_BG)
  (defconst -moe-light-fg                        black-5)
  (defconst -moe-light-builtin                   purple-2)
  (defconst -moe-light-comment-delimiter         white-4)
  (defconst -moe-light-comment                   white-4)
  (defconst -moe-light-constant                  blue-2)
  (defconst -moe-light-doc                       red-2)
  (defconst -moe-light-doc-string                yellow-3)
  (defconst -moe-light-function-name             red-1)
  (defconst -moe-light-keyword                   green-3)
  (defconst -moe-light-negation-char             red-2)
  (defconst -moe-light-preprocessor              purple-2)
  (defconst -moe-light-regexp-grouping-backslash orange-2)
  (defconst -moe-light-regexp-grouping-construct purple-2)
  (defconst -moe-light-string                    magenta-3)
  (defconst -moe-light-type                      cyan-5)
  (defconst -moe-light-variable-name             orange-2)
  (defconst -moe-light-warning                   red-2)

  (defvar moe-light-bg                        -moe-light-bg                       )
  (defvar moe-light-fg                        -moe-light-fg                       )
  (defvar moe-light-builtin                   -moe-light-builtin                  )
  (defvar moe-light-comment-delimiter         -moe-light-comment-delimiter        )
  (defvar moe-light-comment                   -moe-light-comment                  )
  (defvar moe-light-constant                  -moe-light-constant                 )
  (defvar moe-light-doc                       -moe-light-doc                      )
  (defvar moe-light-doc-string                -moe-light-doc-string               )
  (defvar moe-light-function-name             -moe-light-function-name            )
  (defvar moe-light-keyword                   -moe-light-keyword                  )
  (defvar moe-light-negation-char             -moe-light-negation-char            )
  (defvar moe-light-preprocessor              -moe-light-preprocessor             )
  (defvar moe-light-regexp-grouping-backslash -moe-light-regexp-grouping-backslash)
  (defvar moe-light-regexp-grouping-construct -moe-light-regexp-grouping-construct)
  (defvar moe-light-string                    -moe-light-string                   )
  (defvar moe-light-type                      -moe-light-type                     )
  (defvar moe-light-variable-name             -moe-light-variable-name            )
  (defvar moe-light-warning                   -moe-light-warning                  )

  (custom-theme-set-faces
   'moe-light
   ;; Font-lock faces
   `(font-lock-builtin-face              ((,class (:background unspecified :foreground ,moe-light-builtin                  ))))
   `(font-lock-comment-delimiter-face    ((,class (:background unspecified :foreground ,moe-light-comment-delimiter        :slant italic))))
   `(font-lock-comment-face              ((,class (:background unspecified :foreground ,moe-light-comment                  :slant italic))))
   `(font-lock-constant-face             ((,class (:background unspecified :foreground ,moe-light-constant                 ))))
   `(font-lock-doc-face                  ((,class (:background unspecified :foreground ,moe-light-doc                      ))))
   `(font-lock-doc-string-face           ((,class (:background unspecified :foreground ,moe-light-doc-string               ))))
   `(font-lock-function-name-face        ((,class (:background unspecified :foreground ,moe-light-function-name            ))))
   `(font-lock-keyword-face              ((,class (:background unspecified :foreground ,moe-light-keyword                  ))))
   `(font-lock-negation-char-face        ((,class (:background unspecified :foreground ,moe-light-negation-char            ))))
   `(font-lock-preprocessor-face         ((,class (:background unspecified :foreground ,moe-light-preprocessor             ))))
   `(font-lock-regexp-grouping-backslash ((,class (:background unspecified :foreground ,moe-light-regexp-grouping-backslash))))
   `(font-lock-regexp-grouping-construct ((,class (:background unspecified :foreground ,moe-light-regexp-grouping-construct))))
   `(font-lock-string-face               ((,class (:background unspecified :foreground ,moe-light-string                   ))))
   `(font-lock-type-face                 ((,class (:background unspecified :foreground ,moe-light-type                     ))))
   `(font-lock-variable-name-face        ((,class (:background unspecified :foreground ,moe-light-variable-name            ))))
   `(font-lock-warning-face              ((,class (:background unspecified :foreground ,moe-light-warning               :weight bold))))
   ;; Ensure sufficient contrast on low-color terminals.
   `(default ((((class color) (min-colors 4096)) (:foreground ,moe-light-fg :background ,moe-light-bg))
              (((class color) (min-colors 256)) (:foreground ,moe-light-fg :background ,moe-light-bg))
              (,class (:foreground ,moe-light-fg :background ,moe-light-bg))))
   `(cursor ((,class (:background ,moe-light-fg))))

   ;; Highlighting faces
   `(fringe ((,class (:foreground ,black-1 :background ,linum-light))))
   `(linum ((,class (:foreground ,linum-dark :background ,linum-light))))
   `(line-number ((,class (:foreground ,linum-dark :background ,linum-light))))
   `(linum-highlight-face ((,class (:background ,linum-dark :foreground ,linum-light))))
   `(line-number-current-line ((,class (:background ,linum-dark :foreground ,linum-light))))
   `(highlight ((,class (:background ,green-0))))
   `(hl-line ((,class (:background ,green-00)))) ; Embedded strings of IM (e.g. fcitx) would be very unreadable... orz
   `(highlight-symbol-face ((,class (:background ,green-00))))
   `(region ((,class (:foreground ,white-0 :background ,blue-1))))
   `(secondary-selection ((,class (:background ,blue-3 :foreground ,white-0))))
   `(isearch ((,class (:foreground ,white-0 :background ,orange-3))))
   `(lazy-highlight ((,class (:background ,magenta-3 :foreground ,white-0))))
   `(trailing-whitespace ((,class (:background ,red-3))))
   `(show-paren-match ((,class (:background ,blue-00))))
   `(header-line ((,class (:background ,blue-0 :foreground ,blue-3))))
   `(help-argument-name ((,class (:foreground ,magenta-3 :italic t))))
   `(eldoc-highlight-function-argument ((,class (:foreground ,green-3 :bold t :underline t :background ,green-00))))
   ;; Mode line & frames' faces
   `(mode-line ((,class (:box nil :background ,blue-1 :foreground ,white-0))))
   `(mode-line-inactive ((,class (:box nil :background ,white-2 :foreground ,black-1))))
   `(mode-line-buffer-id ((,class (:box nil :foreground ,black-6 :background unspecified :bold t))))
   `(vertical-border ((,class (:foreground "#d7d7af" :background "#d7d7af"))))

   `(fixed-pitch-serif ((,class (:inherit (fixed-pitch)))))
   `(Info-quoted ((,class (:background ,white-2 :foreground ,black-6))))

   ;; Escape and prompt faces
   `(minibuffer-prompt ((,class (:foreground ,black-5 :background ,green-2 :bold nil))))
   `(escape-glyph ((,class (:foreground ,yellow-3))))
   `(error ((,class (:foreground ,red-0))))
   `(warning ((,class (:foreground ,orange-2 :bold t))))
   `(success ((,class (:foreground ,green-2))))

   ;; Completions
   `(completions-annotations ((,class (:foreground ,green-3))))
   `(completions-common-part ((,class (:foreground ,white-3))))
   `(completions-first-difference ((,class (:weight bold :foreground ,orange-2))))

   ;; org-mode
   `(org-document-title ((,class (:foreground ,blue-3 :background ,LIGHT_BG :weight bold))))
   `(org-document-info ((,class (:foreground ,blue-1 :background ,LIGHT_BG :weight bold))))
   `(org-document-info-keyword ((,class (:foreground ,orange-4 :background ,yellow-00))))
   `(org-archived ((,class (:slant italic))))
   `(org-checkbox ((,class (:background ,white-2 :foreground ,black-3
                                        :box (:line-width 1 :style released-button)))))
   `(org-date ((,class (:foreground ,blue-2 :underline t))))
   `(org-done ((,class (:bold t :weight bold :foreground ,green-4 :background ,green-00
                              :box (:line-width 1 :style nil)))))
   `(org-todo ((,class (:bold t :weight bold :foreground ,red-3 :background ,orange-0
                              :box (:line-width 1 :style nil)))))
   `(org-level-1 ((,class (:bold t :foreground ,blue-1))))
   `(org-level-2 ((,class (:bold t :foreground ,green-02))))
   `(org-level-3 ((,class (:bold t :foreground ,orange-2))))
   `(org-level-4 ((,class (:bold t :foreground ,cyan-3))))
   `(org-level-5 ((,class (:bold t :foreground ,red-2))))
   `(org-level-6 ((,class (:bold t :foreground ,purple-2))))
   `(org-level-7 ((,class (:bold t :foreground ,magenta-2))))
   `(org-level-8 ((,class (:bold t :foreground ,yellow-2))))
   `(org-tag ((,class (:background ,black-1 :foreground ,white-0 :bold t :weight bold))))
   `(org-column ((,class (:background ,yellow-00 :foreground ,black-3))))
   `(org-column-title ((,class (:background ,blue-0 :foreground ,black-5 :underline t :weight bold))))
   `(org-agenda-structure ((,class (:foreground ,cyan-4 :background unspecified :bold nil))))
   `(org-deadline-announce ((,class (:foreground ,red-3))))
   `(org-scheduled ((,class (:foreground ,black-2))))
   `(org-scheduled-previously ((,class (:foreground ,red-1))))
   `(org-scheduled-today ((,class (:foreground ,blue-2))))
   `(org-special-keyword ((,class (:background ,yellow-1 :foreground ,yellow-4))))
   `(org-table ((,class (:background ,yellow-0 :foreground ,black-3))))
   `(org-time-grid ((,class (:foreground ,white-4))))
   `(org-upcoming-deadline ((,class (:foreground ,red-3))))
   `(org-warning ((,class (:bold t :foreground ,white-0 :background ,red-3))))
   `(org-formula ((,class (:foreground ,purple-2))))
   `(org-headline-done ((,class (:foreground ,green-2))))
   `(org-hide ((,class (:foreground ,LIGHT_BG))))
   `(org-code ((,class (:foreground ,blue-2 :background ,white-1))))
   `(org-link ((,class (:foreground ,blue-2 :underline ,blue-2))))
   `(org-footnote ((,class (:foreground ,magenta-3))))
   `(org-ellipsis ((,class (:foreground ,red-2))))
   `(org-agenda-clocking ((,class (:foreground ,blue-3 :background ,blue-0 :bold t))))
   `(org-agenda-date ((,class (:foreground ,blue-2 :background unspecified :underline nil))))
   `(org-agenda-date-weekend ((,class (:foreground ,purple-2 :background unspecified :slant italic :bold nil))))
   `(org-agenda-date-today ((,class (:foreground ,blue-2 :background ,blue-000 :weight bold :underline t))))
   `(org-agenda-column-dateline ((,class (:foreground ,white-0 :background ,yellow-0 :underline t))))
   `(org-agenda-todo ((,class (:foreground ,white-0 :background ,red-2))))
   `(org-agenda-done ((,class (:foreground ,green-3 :background unspecified))))
   `(org-agenda-dimmed-todo-face ((,class (:foreground ,white-0 :background ,red-2))))
   `(org-priority ((,class (:foreground ,red-3 :background unspecified))))
   `(org-block ((,class (:foreground ,blue-3 :background ,blue-00))))
   `(org-block-background ((,class (:background ,white-1))))
   `(org-block-begin-line ((,class (:foreground ,blue-3 :background ,blue-0))))
   `(org-block-end-line ((,class (:foreground ,white-2 :background ,white-1))))
   `(org-quote ((,class (:foreground ,blue-3 :background ,blue-00))))
   `(org-mode-line-clock ((,class (:foreground ,blue-3 :background ,blue-0 :bold t))))
   `(org-mode-line-clock-overrun ((,class (:foreground ,white-0 :background ,red-1 :bold t))))
   `(org-verbatim ((,class (:foreground ,blue-3 :background ,blue-00 :bold nil))))

   ;; outline
   `(outline-1 ((,class (:bold t :foreground ,blue-1))))
   `(outline-2 ((,class (:bold t :foreground ,green-02))))
   `(outline-3 ((,class (:bold t :foreground ,orange-2))))
   `(outline-4 ((,class (:bold t :foreground ,cyan-3))))
   `(outline-5 ((,class (:bold t :foreground ,red-2))))
   `(outline-6 ((,class (:bold t :foreground ,purple-2))))
   `(outline-7 ((,class (:bold t :foreground ,magenta-2))))
   `(outline-8 ((,class (:bold t :foreground ,yellow-2))))

   ;; undo-tree
   `(undo-tree-visualizer-default-face ((,class (:foreground ,black-5))))
   `(undo-tree-visualizer-current-face ((,class (:foreground ,green-2 :weight bold))))
   `(undo-tree-visualizer-active-branch-face ((,class (:foreground ,red-2))))
   `(undo-tree-visualizer-register-face ((,class (:foreground ,yellow-2))))

   ;; Markdown-mode
   `(markdown-blockquote-face ((,class (:foreground ,green-3 :background ,green-00 :italic t))))
   `(markdown-bold-face ((,class (:foreground ,black-5 :bold t))))
   `(markdown-comment-face ((,class (:foreground ,white-4 :italic t))))
   `(markdown-header-delimiter-face ((,class (:foreground ,orange-3 :bold t))))
   `(markdown-header-face ((,class (:foreground ,orange-2 :bold t))))
   `(markdown-header-rule-face ((,class (:foreground ,orange-2 :bold t))))
   `(markdown-header-face-1 ((,class (:foreground ,orange-2 :bold t))))
   `(markdown-header-face-2 ((,class (:foreground ,orange-2 :bold t))))
   `(markdown-header-face-3 ((,class (:foreground ,orange-2 :bold t))))
   `(markdown-header-face-4 ((,class (:foreground ,orange-2 :bold t))))
   `(markdown-header-face-5 ((,class (:foreground ,orange-2 :bold t))))
   `(markdown-header-face-6 ((,class (:foreground ,orange-2 :bold t))))
   `(markdown-link-face ((,class (:foreground ,magenta-1 :bold t :underline ,magenta-1))))
   `(markdown-inline-code-face ((,class (:foreground ,black-4 :background ,white-1))))
   `(markdown-code-face ((,class (:foreground unspecified :background unspecified))))
   `(markdown-markup-face  ((,class (:foreground ,black-1 :background unspecified))))
   `(markdown-italic-face ((,class (:foreground ,black-5 :italic t :underline ,black-5))))
   `(markdown-list-face ((,class (:foreground ,orange-2 :background ,LIGHT_BG :bold t))))
   `(markdown-math-face ((,class (:foreground ,purple-2))))
   `(markdown-missing-link-face ((,class (:foreground ,red-1 :bold t))))
   `(markdown-pre-face ((,class (:foreground ,black-4 :background ,white-1))))
   `(markdown-reference-face ((,class (:foreground ,orange-2 :italic t))))
   `(markdown-url-face ((,class (:foreground ,magenta-3 :underline ,magenta-3))))

   ;; Twittering-mode
   `(twittering-username-face ((,class (:foreground ,blue-3 :background ,blue-00 :bold t :underline t))))
   `(twittering-uri-face ((,class (:foreground ,blue-2 :underline ,blue-2))))
   `(twittering-timeline-footer-face ((,class (:foreground ,black-1 :bold t))))
   `(twittering-timeline-header-face ((,class (:foreground ,black-1 :bold t))))

   ;; Jabber
   `(jabber-activity-face ((,class (:foreground ,magenta-2))))
   `(jabber-activity-personal-face ((,class (:foreground ,cyan-4))))
   `(jabber-chat-error ((,class (:foreground ,red-3 :background ,red-00 :bold t))))
   `(jabber-chat-prompt-foreign ((,class (:foreground ,orange-3 :bold t))))
   `(jabber-chat-prompt-local ((,class (:foreground ,blue-2 :bold t))))
   `(jabber-chat-prompt-system ((,class (:foreground ,yellow-3 :weight bold))))
   `(jabber-chat-text-foreign ((,class (:foreground ,black-5))))
   `(jabber-chat-text-local ((,class (:foreground ,black-2))))
   `(jabber-rare-time-face ((,class (:foreground ,white-4))))
   `(jabber-roster-user-away ((,class (:foreground ,orange-2))))
   `(jabber-roster-user-chatty ((,class (:foreground ,purple-2))))
   `(jabber-roster-user-dnd ((,class (:foreground ,red-1))))
   `(jabber-roster-user-error ((,class (:foreground ,red-3 :background ,red-00))))
   `(jabber-roster-user-offline ((,class (:foreground ,black-1))))
   `(jabber-roster-user-online ((,class (:foreground ,green-3))))
   `(jabber-roster-user-xa ((,class (:foreground ,white-4))))

   ;; popup
   `(popup-face ((,class (:background ,black-5 :foreground ,blue-1))))
   `(popup-isearch-match ((,class (:background ,black-5 :foreground ,magenta-2 :bold t))))
   `(popup-menu-face ((,class (:background ,black-5 :foreground ,blue-1))))
   `(popup-menu-mouse-face ((,class (:background ,green-0 :foreground ,black-5))))
   `(popup-menu-selection-face ((,class (:background ,black-2 :foreground ,blue-00))))
   `(popup-menu-summary-face ((,class (:background ,black-5 :foreground ,blue-1))))
   `(popup-scroll-bar-background-face ((,class (:background ,black-5 :foreground ,black-5))))
   `(popup-scroll-bar-foreground-face ((,class (:background ,black-2 :foreground ,white-3))))
   `(popup-summary-face ((,class (:background ,black-5 :foreground ,blue-1))))
   `(popup-tip-face ((,class (:background ,black-2 :foreground ,white-1))))

   ;; company
   `(company-echo ((,class (:background unspecified :foreground ,black-5))))
   `(company-echo-common ((,class (:background ,red-000 :foreground ,red-2))))
   `(company-preview ((,class (:background ,black-5 :foreground ,magenta-2))))
   `(company-preview-common ((,class (:background ,black-5 :foreground ,magenta-2))))
   `(company-preview-search ((,class (:background ,black-4 :foreground ,magenta-2 :bold t))))
   `(company-scrollbar-bg ((,class (:background ,black-5))))
   `(company-scrollbar-fg ((,class (:background ,black-1))))
   `(company-template-field ((,class (:background ,yellow-00 :foreground ,black-4))))
   `(company-tooltip ((,class (:background ,black-6 :foreground ,blue-1))))
   `(company-tooltip-annotation ((,class (:background ,black-4 :foreground ,red-1))))
   `(company-tooltip-common ((,class (:background ,black-5 :foreground ,blue-1))))
   `(company-tooltip-common-selection ((,class (:background ,black-3 :foreground ,blue-0 :bold t))))
   `(company-tooltip-mouse ((,class (:background ,green-0 :foreground ,black-5))))
   `(company-tooltip-selection ((,class (:background ,black-4 :foreground ,blue-0))))

   ;; Button and link faces
   `(link ((,class (:underline t :foreground ,blue-1))))
   `(link-visited ((,class (:underline t :foreground ,blue-2))))

   ;; Gnus
   `(gnus-button ((,class (:weight normal :foreground ,blue-2 :underline t))))
   `(gnus-cite-1 ((,class (:foreground ,blue-1 :background ,LIGHT_BG :slant italic))))
   `(gnus-cite-10 ((,class (:foreground ,magenta-1 :background ,LIGHT_BG :slant italic))))
   `(gnus-cite-11 ((,class (:foreground ,cyan-3 :background ,LIGHT_BG :slant italic))))
   `(gnus-cite-2 ((,class (:foreground ,green-2 :background ,LIGHT_BG :slant italic))))
   `(gnus-cite-3 ((,class (:foreground ,magenta-1 :background ,LIGHT_BG :slant italic))))
   `(gnus-cite-4 ((,class (:foreground ,cyan-3 :background ,LIGHT_BG :slant italic))))
   `(gnus-cite-5 ((,class (:foreground ,red-2 :background ,LIGHT_BG :slant italic))))
   `(gnus-cite-6 ((,class (:foreground ,purple-2 :background ,LIGHT_BG :slant italic))))
   `(gnus-cite-7 ((,class (:foreground ,orange-2 :background ,LIGHT_BG :slant italic))))
   `(gnus-cite-8 ((,class (:foreground ,blue-1 :background ,LIGHT_BG :slant italic))))
   `(gnus-cite-9 ((,class (:foreground ,green-2 :background ,LIGHT_BG :slant italic))))
   `(gnus-emphasis-highlight-words ((,class (:foreground ,red-3 :background ,red-00 :bold t))))
   `(gnus-group-mail-1 ((,class (:foreground ,blue-2))))
   `(gnus-group-mail-1-empty ((,class (:foreground ,black-2))))
   `(gnus-group-mail-1-low ((,class (:foreground ,blue-1))))
   `(gnus-group-mail-2 ((,class (:foreground ,orange-3))))
   `(gnus-group-mail-2-empty ((,class (:foreground ,black-2))))
   `(gnus-group-mail-2-low ((,class (:foreground ,orange-2))))
   `(gnus-group-mail-3 ((,class (:foreground ,magenta-3))))
   `(gnus-group-mail-3-empty ((,class (:foreground ,black-2))))
   `(gnus-group-mail-3-low ((,class (:foreground ,magenta-2))))
   `(gnus-group-mail-low ((,class (:foreground ,yellow-3))))
   `(gnus-group-mail-low-empty ((,class (:foreground ,black-2))))
   `(gnus-group-news-1 ((,class (:foreground ,blue-2))))
   `(gnus-group-news-1-empty ((,class (:foreground ,black-2))))
   `(gnus-group-news-1-low ((,class (:foreground ,blue-1))))
   `(gnus-group-news-2 ((,class (:foreground ,orange-3))))
   `(gnus-group-news-2-empty ((,class (:foreground ,black-2))))
   `(gnus-group-news-2-low ((,class (:foreground ,orange-2))))
   `(gnus-group-news-3 ((,class (:foreground ,magenta-3))))
   `(gnus-group-news-3-empty ((,class (:foreground ,black-2))))
   `(gnus-group-news-3-low ((,class (:foreground ,magenta-2))))
   `(gnus-group-news-4 ((,class (:foreground ,purple-2))))
   `(gnus-group-news-4-empty ((,class (:foreground ,black-2))))
   `(gnus-group-news-4-low ((,class (:foreground ,purple-1))))
   `(gnus-group-news-5 ((,class (:foreground ,cyan-4))))
   `(gnus-group-news-5-empty ((,class (:foreground ,black-2))))
   `(gnus-group-news-5-low ((,class (:foreground ,cyan-2))))
   `(gnus-group-news-6 ((,class (:foreground ,green-3))))
   `(gnus-group-news-6-empty ((,class (:foreground ,black-2))))
   `(gnus-group-news-6-low ((,class (:foreground ,green-2))))
   `(gnus-group-news-low ((,class (:foreground ,yellow-3))))
   `(gnus-group-news-low-empty ((,class (:foreground ,black-2))))
   `(gnus-header-content ((,class (:foreground ,magenta-2 ))))
   `(gnus-header-from ((,class (:foreground ,blue-2 :underline t))))
   `(gnus-header-name ((,class (:foreground ,black-1))))
   `(gnus-header-newsgroups ((,class (:foreground ,magenta-2))))
   `(gnus-header-subject ((,class (:foreground ,black-4 :bold t))))
   `(gnus-server-agent ((,class (:foreground ,black-2))))
   `(gnus-server-closed ((,class (:foreground ,black-2))))
   `(gnus-server-denied ((,class (:foreground ,black-2))))
   `(gnus-server-offline ((,class (:foreground ,black-2))))
   `(gnus-server-opened ((,class (:foreground ,black-2))))
   `(gnus-signature ((,class (:slant italic :foreground ,black-5))))
   `(gnus-splash ((,class (:foreground ,black-1))))
   `(gnus-summary-cancelled ((,class (:foreground ,white-3 :background ,LIGHT_BG))))
   `(gnus-summary-high-ancient ((,class (:bold t :foreground ,red-1 :background unspecified))))
   `(gnus-summary-high-read ((,class (:bold t :foreground ,black-2))))
   `(gnus-summary-high-ticked ((,class (:bold t :foreground ,red-2 :background unspecified :slant italic))))
   `(gnus-summary-high-undownloaded ((,class (:slant italic :foreground ,red-2 :background unspecified))))
   `(gnus-summary-high-unread ((,class (:bold t :foreground ,red-3))))
   `(gnus-summary-low-ancient ((,class (:foreground ,green-2))))
   `(gnus-summary-low-read ((,class (:foreground ,black-2))))
   `(gnus-summary-low-ticked ((,class (:foreground ,green-3 :bold t))))
   `(gnus-summary-low-undownloaded ((,class (:foreground ,green-3 :slant italic))))
   `(gnus-summary-low-unread ((,class (:foreground ,green-4 :bold t))))
   `(gnus-summary-normal-ancient ((,class (:foreground ,blue-2))))
   `(gnus-summary-normal-read ((,class (:foreground ,black-2))))
   `(gnus-summary-normal-ticked ((,class (:foreground ,blue-1 :bold t :slant italic))))
   `(gnus-summary-normal-undownloaded ((,class (:foreground ,blue-1 :slant italic))))
   `(gnus-summary-normal-unread ((,class (:foreground ,blue-3 :bold t))))
   `(gnus-summary-selected ((,class (:background ,green-0 :foreground ,green-5))))

   ;; Helm
   `(helm-bookmark-directory ((,class (:foreground ,blue-1 :background ,black-5 :bold t))))
   `(helm-bookmark-file ((,class (:foreground ,yellow-4 :background ,yellow-0))))
   `(helm-bookmark-info ((,class (:foreground ,green-4 :background ,green-0))))
   `(helm-buffer-directory ((,class (:foreground ,blue-1 :bold t))))
   `(helm-buffer-process ((,class (:foreground ,magenta-2))))
   `(helm-buffer-saved-out ((,class (:foreground ,red-2 :background ,LIGHT_BG))))
   `(helm-buffer-size ((,class (:foreground ,orange-2))))
   `(helm-candidate-number ((,class (:foreground ,blue-3 :background ,white-0))))
   `(helm-ff-directory ((,class (:foreground ,blue-1 :background ,LIGHT_BG :bold t))))
   `(helm-ff-excutable ((,class (:foreground ,green-2 :background ,LIGHT_BG :bold t))))
   `(helm-ff-file ((,class (:foreground ,black-5 :background ,LIGHT_BG))))
   `(helm-ff-invalid-symlink ((,class (:foreground ,white-0 :background ,red-2))))
   `(helm-ff-prefix ((,class (:foreground ,white-0 :background ,orange-2))))
   `(helm-grep-cmd-line ((,class (:foreground ,green-3 :background ,green-00 :bold t))))
   `(helm-grep-file ((,class (:foreground ,purple-2))))
   `(helm-grep-finish ((,class (:foreground ,green-3))))
   `(helm-grep-lineno ((,class (:foreground ,orange-2))))
   `(helm-grep-match ((,class (:background ,green-0 :foreground ,black-4))))
   `(helm-grep-running ((,class (:foreground ,red-2 :background unspecified))))
   `(helm-header ((,class (:foreground ,blue-3 :background ,white-0))))
   `(helm-lisp-show-completion ((,class (:foreground ,white-0 :background ,blue-1))))
   `(helm-match ((,class (:foreground ,green-2 :background ,LIGHT_BG :bold t))))
   `(helm-selection ((,class (:foreground ,black-3 :background ,green-01))))
   `(helm-selection-line ((,class (:foreground ,black-3 :background ,green-01))))
   `(helm-source-header ((,class (:foreground ,white-0 :background ,blue-3 :bold nil))))
   `(helm-visible-mark ((,class (:foreground ,magenta-2 :background ,magenta-00))))

   ;; Dired/Dired+/Diredfl
   `(dired-directory ((,class (:foreground ,blue-1 :bold t))))
   `(dired-flagged ((,class (:foreground ,red-1))))
   `(dired-header ((,class (:foreground ,black-5  :background ,green-01 :bold t))))
   `(dired-ignored ((,class (:foreground ,white-4))))
   `(dired-mark ((,class (:foreground ,green-1))))
   `(dired-marked ((,class (:foreground ,green-2))))
   `(dired-perm-write ((,class (:foreground ,red-2 :bold t))))
   `(dired-symlink ((,class (:foreground ,magenta-2))))
   `(dired-warning ((,class (:foreground ,white-0 :background ,red-1 :bold t))))
   `(diredp-compressed-file-name ((,class (:foreground ,white-4))))
   `(diredp-compressed-file-suffix ((,class (:foreground ,purple-2))))
   `(diredp-date-time ((,class (:foreground ,blue-3 :background ,blue-00))))
   `(diredp-deletion ((,class (:foreground ,white-0, :background ,red-3))))
   `(diredp-deletion-file-name ((,class (:foreground ,red-2))))
   `(diredp-dir-heading ((,class (:foreground ,black-5 :background ,green-01 :bold t))))
   `(diredp-dir-name ((,class (:foreground ,blue-1 :background ,LIGHT_BG :bold t))))
   `(diredp-dir-priv ((,class (:foreground ,blue-1 :background ,LIGHT_BG))))
   `(diredp-display-msg ((,class (:foreground ,orange-2))))
   `(diredp-exec-priv ((,class (:foreground ,red-3 :background ,orange-0))))
   `(diredp-executable-tag ((,class (:foreground ,green-2))))
   `(diredp-file-name ((,class (:foreground ,black-5))))
   `(diredp-file-suffix ((,class (:foreground ,orange-3))))
   `(diredp-flag-mark ((,class (:foreground ,white-0 :background ,magenta-3 :bold t))))
   `(diredp-flag-mark-line ((,class (:foreground ,black-5 :background ,magenta-1))))
   `(diredp-ignored-file-name ((,class (:foreground ,white-4))))
   `(diredp-link-priv ((,class (:foreground ,magenta-3))))
   `(diredp-mode-line-flagged ((,class (:foreground ,black-5 :background ,green-2))))
   `(diredp-mode-line-marked ((,class (:foreground ,white-0 :background ,magenta-3 bold t))))
   `(diredp-no-priv ((,class (:foreground ,yellow-3 :background ,yellow-00))))
   `(diredp-number ((,class (:foreground ,green-3))))
   `(diredp-other-priv ((,class (:foreground ,white-0 :background ,blue-3))))
   `(diredp-rare-priv ((,class (:foreground ,white-0 :background ,purple-2))))
   `(diredp-read-priv ((,class (:foreground ,green-4 :background ,green-0))))
   `(diredp-symlink ((,class (:foreground ,magenta-3))))
   `(diredp-write-priv ((,class (:foreground ,blue-5 :background ,blue-0))))
   `(diredfl-autofile-name ((,class (:foreground ,cyan-2))))
   `(diredfl-compressed-file-name ((,class (:foreground ,white-4))))
   `(diredfl-compressed-file-suffix ((,class (:foreground ,purple-2))))
   `(diredfl-date-time ((,class (:foreground ,blue-3 :background ,blue-00))))
   `(diredfl-deletion ((,class (:foreground ,white-0, :background ,red-3))))
   `(diredfl-deletion-file-name ((,class (:foreground ,red-2))))
   `(diredfl-dir-heading ((,class (:foreground ,black-5 :background ,green-01 :bold t))))
   `(diredfl-dir-name ((,class (:foreground ,blue-1 :background ,LIGHT_BG :bold t))))
   `(diredfl-dir-priv ((,class (:foreground ,blue-1 :background ,LIGHT_BG))))
   `(diredfl-exec-priv ((,class (:foreground ,red-3 :background ,orange-0))))
   `(diredfl-executable-tag ((,class (:foreground ,green-2))))
   `(diredfl-file-name ((,class (:foreground ,black-5))))
   `(diredfl-file-suffix ((,class (:foreground ,orange-3))))
   `(diredfl-flag-mark ((,class (:foreground ,white-0 :background ,magenta-3 :bold t))))
   `(diredfl-flag-mark-line ((,class (:foreground ,black-5 :background ,magenta-1))))
   `(diredfl-ignored-file-name ((,class (:foreground ,white-4))))
   `(diredfl-link-priv ((,class (:foreground ,magenta-3))))
   `(diredfl-no-priv ((,class (:foreground ,yellow-3 :background ,yellow-00))))
   `(diredfl-number ((,class (:foreground ,green-3))))
   `(diredfl-other-priv ((,class (:foreground ,white-0 :background ,blue-3))))
   `(diredfl-rare-priv ((,class (:foreground ,white-0 :background ,purple-2))))
   `(diredfl-read-priv ((,class (:foreground ,green-4 :background ,green-0))))
   `(diredfl-symlink ((,class (:foreground ,magenta-3))))
   `(diredfl-tagged-autofile-name ((,class (:foreground ,cyan-3))))
   `(diredfl-write-priv ((,class (:foreground ,blue-5 :background ,blue-0))))


   ;; Transient (Mainly used in Magit)
   `(transient-argument ((,class (:foreground ,orange-3 :background ,orange-000 :weight bold))))
   `(transient-inactive-argument ((,class (:foreground ,white-2 :background unspecified :weight bold))))
   `(transient-value ((,class (:foreground ,magenta-3 :background ,magenta-00 :weight bold))))
   `(transient-inactive-value ((,class (:foreground ,white-2 :background unspecified :weight bold))))
   `(transient-heading ((,class (:foreground ,green-3 :background unspecified :underline t))))
   `(transient-higher-level ((,class (:foreground ,black-6 :background unspecified :underline t))))
   `(transient-key ((,class (:foreground ,purple-2 :background unspecified :weight bold))))
   `(transient-key-exit ((,class (:foreground ,blue-2 :background unspecified :weight bold))))
   `(transient-key-stay ((,class (:foreground ,orange-2 :background unspecified :weight bold))))
   `(transient-key-return ((,class (:foreground ,green-2 :background unspecified :weight bold))))
   `(transient-unreachable ((,class (:foreground ,white-4 :background unspecified :strike-through t))))
   `(transient-unreachable-key ((,class (:foreground ,white-4 :background unspecified :strike-through t))))
   `(transient-inapt-suffix ((,class (:foreground ,white-4 :background unspecified :strike-through t :slant italic))))
   `(transient-mismatched-key ((,class (:foreground unspecified :background unspecified :box (:line-width (1 . 1) :color ,magenta-3)))))
   `(transient-nonstandard-key ((,class (:foreground unspecified :background unspecified :box (:line-width (1 . 1) :color ,cyan-1)))))


   ;; Magit >= 2.1.0
   `(magit-bisect-bad ((,class (:foreground ,red-3 :background ,red-00))))
   `(magit-bisect-good ((,class (:foreground ,green-4 :background ,green-0))))
   `(magit-bisect-skip ((,class (:foreground ,yellow-4 :background ,orange-00))))
   `(magit-blame-date ((,class (:foreground ,orange-2 :background ,yellow-00))))
   `(magit-blame-hash ((,class (:foreground ,orange-2 :background ,yellow-00))))
   `(magit-blame-heading ((,class (:foreground ,white-4 :background ,yellow-00))))
   `(magit-blame-name ((,class (:foreground ,green-3 :background ,yellow-00))))
   `(magit-blame-summary ((,class (:foreground ,black-2 :background ,yellow-00))))
   `(magit-branch-current ((,class (:foreground ,white-0 :background ,orange-2 :bold t :underline t :box (:line-width (1 . 1) :color ,orange-5)))))
   `(magit-branch-local ((,class (:foreground ,green-4 :background ,green-00 :bold t :underline nil))))
   `(magit-branch-remote ((,class (:foreground ,blue-3 :background ,blue-0 :bold t :underline nil))))
   `(magit-cherry-equivalent ((,class (:foreground ,purple-2))))
   `(magit-cherry-unmatched ((,class (:foreground ,cyan-4))))
   `(magit-diff-added ((,class (:foreground ,green-3 :background unspecified :bold t))))
   `(magit-diff-added-highlight ((,class (:foreground ,green-3 :bold t :inherit (magit-section-highlight)))))
   `(magit-diff-base ((,class (:foreground ,yellow-4 :background unspecified))))
   `(magit-diff-base-highlight ((,class (:foreground ,yellow-4 :background ,yellow-00))))
   `(magit-diff-conflict-heading ((,class (:foreground ,white-0 :background ,orange-2))))
   `(magit-diff-context ((,class (:foreground ,white-4 :background unspecified))))
   `(magit-diff-context-highlight ((,class (:foreground ,black-1 :inherit (magit-section-highlight)))))
   `(magit-diff-file-heading ((,class (:foreground ,black-4 :bold t))))
   `(magit-diff-file-heading-highlight ((,class (:background ,green-00 :bold t))))
   `(magit-diff-file-heading-selection ((,class (:foreground ,white-0 :background ,black-4 :bold t))))
   `(magit-diff-hunk-heading ((,class (:foreground ,white-4 :background ,white-1 :bold t))))
   `(magit-diff-hunk-heading-highlight ((,class (:foreground ,white-0 :background ,black-1))))
   `(magit-diff-hunk-heading-selection ((,class (:foreground ,white-1 :background ,black-4))))
   `(magit-diff-lines-boundary ((,class (:foreground ,black-5 :background ,red-0))))
   `(magit-diff-lines-heading ((,class (:foreground ,black-5 :background ,red-0))))
   `(magit-diff-our ((,class (:foreground ,magenta-3))))
   `(magit-diff-our-highlight ((,class (:foreground ,magenta-3 :background ,magenta-00))))
   `(magit-diff-removed ((,class (:foreground ,red-2 :background unspecified :bold t))))
   `(magit-diff-removed-highlight ((,class (:foreground ,red-2 :bold t :inherit (magit-section-highlight)))))
   `(magit-diff-revision-summary ((,class (:foreground ,yellow-4 :bold t))))
   `(magit-diff-revision-summary-highlight ((,class (:foreground ,yellow-4 :background ,yellow-1 :bold t))))
   `(magit-diff-their ((,class (:foreground ,cyan-4)))) ;
   `(magit-diff-their-highlight ((,class (:foreground ,cyan-6 :background ,cyan-1))))
   `(magit-diff-whitespace-warning ((,class (:foreground ,red-3 :background ,red-3))))
   `(magit-diffstat-added ((,class (:foreground ,green-3 :background ,green-0 :bold t))))
   `(magit-diffstat-removed ((,class (:foreground ,red-3 :background ,red-0 :bold t))))
   `(magit-dimmed ((,class (:foreground ,white-3))))
   `(magit-filename ((,class (:foreground ,blue-3))))
   `(magit-hash ((,class (:foreground ,orange-2 :background unspecified))))
   `(magit-head ((,class (:foreground ,orange-4 :background ,orange-000))))
   `(magit-header-line ((,class (:foreground ,orange-2))))
   `(magit-log-author ((,class (:foreground ,green-3 :background ,LIGHT_BG))))
   `(magit-log-date ((,class (:foreground ,black-1 :background ,LIGHT_BG))))
   `(magit-log-graph ((,class (:foreground ,black-2 :background ,LIGHT_BG))))
   `(magit-process-ng ((,class (:foreground ,red-3 :background ,red-00 :underline t))))
   `(magit-process-ok ((,class (:foreground ,green-3 :background ,green-00 :underline t))))
   `(magit-reflog-amend ((,class (:foreground ,magenta-3 :background ,magenta-00))))
   `(magit-reflog-checkout ((,class (:foreground ,green-3 :background ,green-00))))
   `(magit-reflog-cherry-pick ((,class (:foreground ,orange-4 :background ,orange-00))))
   `(magit-reflog-commit ((,class (:foreground ,yellow-4 :background ,yellow-0))))
   `(magit-reflog-merge ((,class (:foreground ,purple-4 :background ,purple-00))))
   `(magit-reflog-other ((,class (:foreground ,white-0 :background ,black-3))))
   `(magit-reflog-rebase ((,class (:foreground ,cyan-6 :background ,cyan-2))))
   `(magit-reflog-remote ((,class (:foreground ,blue-4 :background ,blue-0))))
   `(magit-reflog-reset ((,class (:foreground ,red-3 :background ,red-00))))
   `(magit-section-heading ((,class (:foreground ,orange-3 :background unspecified :bold t :underline t))))
   `(magit-section-heading-selection ((,class (:foreground ,black-6 :background ,blue-0))))
   `(magit-section-highlight ((,class (:background ,yellow-0, :foreground ,black-5))))
   `(magit-sequence-done ((,class (:foreground ,green-3))))
   `(magit-sequence-drop ((,class (:foreground ,orange-2))))
   `(magit-sequence-head ((,class (:foreground ,blue-2))))
   `(magit-sequence-onto ((,class (:foreground ,purple-2))))
   `(magit-sequence-part ((,class (:foreground ,cyan-4))))
   `(magit-sequence-pick ((,class (:foreground ,magenta-2))))
   `(magit-sequence-stop ((,class (:foreground ,red-3))))
   `(magit-signature-bad ((,class (:foreground ,red-2))))
   `(magit-signature-good ((,class (:foreground ,green-3))))
   `(magit-signature-untrusted ((,class (:foreground ,yellow-3))))
   `(magit-tag ((,class (:foreground ,purple-4 :background ,purple-00))))
   `(magit-valid-signature ((,class (:foreground ,cyan-4 :background ,LIGHT_BG :bold t))))
   `(magit-whitespace-warning-face ((,class (:foreground ,white-0 :background ,red-2 :bold t))))

   ;; Magit
   `(magit-branch ((,class (:foreground ,green-4 :background ,green-0 :bold t :underline t))))
   `(magit-diff-add ((,class (:foreground ,green-3 :background unspecified :bold t))))
   `(magit-diff-del ((,class (:foreground ,red-2 :background unspecified :bold t))))
   `(magit-diff-file-header ((,class (:foreground ,black-4 :background ,white-3 :bold t))))
   `(magit-diff-hunk-header ((,class (:foreground ,black-2 :background ,white-1 :bold t))))
   `(magit-diff-merge-current ((,class (:foreground ,purple-1))))
   `(magit-diff-merge-diff3-separator ((,class (:foreground ,purple-1))))
   `(magit-diff-merge-proposed ((,class (:foreground ,purple-1))))
   `(magit-diff-merge-separator ((,class (:foreground ,purple-1))))
   `(magit-diff-none ((,class (:foreground ,white-4))))
   `(magit-header ((,class (:foreground ,blue-2 :background ,white-0 :underline ,blue-2))))
   `(magit-item-highlight ((,class (:background ,yellow-00 :foreground ,black-5))))
   `(magit-item-mark ((,class (:foreground ,white-0 :background ,magenta-2))))
   `(magit-log-author ((,class (:foreground ,green-3 :background ,LIGHT_BG))))
   `(magit-log-author-date-cutoff ((,class (:foreground ,red-1 :bold t))))
   `(magit-log-date ((,class (:foreground ,black-1 :background ,LIGHT_BG))))
   `(magit-log-graph ((,class (:foreground ,black-2 :background ,LIGHT_BG))))
   `(magit-log-head-label-bisect-bad ((,class (:foreground ,red-3 :background ,red-00))))
   `(magit-log-head-label-bisect-good ((,class (:foreground ,green-4 :background ,green-0))))
   `(magit-log-head-label-bisect-skip ((,class (:foreground ,yellow-4 :background ,orange-00))))
   `(magit-log-head-label-default ((,class (:foreground ,green-4 :background ,green-2 :bold t :underline t))))
   `(magit-log-head-label-head ((,class (:foreground ,green-4 :background ,green-01 :bold t :underline t))))
   `(magit-log-head-label-local ((,class (:foreground ,green-4 :background ,green-00 :bold t :underline t))))
   `(magit-log-head-label-patches ((,class (:foreground ,orange-4 :background ,orange-0 :bold t :underline t))))
   `(magit-log-head-label-remote ((,class (:foreground ,blue-3 :background ,blue-0 :bold t :underline t))))
   `(magit-log-head-label-tags ((,class (:foreground ,yellow-4 :background ,yellow-00 :bold t :underline t))))
   `(magit-log-head-label-wip ((,class (:foreground ,black-2 :background ,white-2 :bold t :underline t))))
   `(magit-log-message ((,class (:foreground ,black-5 :background unspecified))))
   `(magit-log-reflog-label-amend ((,class (:foreground ,magenta-3 :background ,magenta-0))))
   `(magit-log-reflog-label-checkout ((,class (:foreground ,green-3 :background ,green-00))))
   `(magit-log-reflog-label-cherry-pick ((,class (:foreground ,orange-4 :background ,orange-00))))
   `(magit-log-reflog-label-commit ((,class (:foreground ,yellow-4 :background ,yellow-0))))
   `(magit-log-reflog-label-merge ((,class (:foreground ,purple-4 :background ,purple-00))))
   `(magit-log-reflog-label-other ((,class (:foreground ,white-0 :background ,black-3))))
   `(magit-log-reflog-label-rebase ((,class (:foreground ,cyan-6 :background ,cyan-2))))
   `(magit-log-reflog-label-remote ((,class (:foreground ,blue-4 :background ,blue-0))))
   `(magit-log-reflog-label-reset ((,class (:foreground ,red-3 :background ,red-00))))
   `(magit-log-sha1 ((,class (:foreground ,orange-2 :background ,LIGHT_BG))))
   `(magit-process-ng ((,class (:foreground ,red-3 :background ,red-00 :underline t))))
   `(magit-process-ok ((,class (:foreground ,green-3 :background ,green-00 :underline t))))
   `(magit-section-title ((,class (:foreground ,orange-3 :background ,LIGHT_BG :underline ,orange-3 :bold ,t))))
   `(magit-signature-bad ((,class (:foreground ,red-2))))
   `(magit-signature-good ((,class (:foreground ,green-3))))
   `(magit-signature-none ((,class (:foreground ,black-4))))
   `(magit-signature-untrusted ((,class (:foreground ,cyan-3))))
   `(magit-tag ((,class (:foreground ,purple-4 :background ,purple-00))))
   `(magit-valid-signature ((,class (:foreground ,cyan-4 :background ,LIGHT_BG :bold t))))
   `(magit-whitespace-warning-face ((,class (:foreground ,white-0 :background ,red-2 :bold t))))
   `(magit-refname ((,class (:foreground ,white-0 :background ,black-4 :underline unspecified :bold t))))

   ;; git-commit-mode
   `(git-commit-branch-face ((,class (:foreground ,blue-4 :background ,blue-0 :underline t))))
   `(git-commit-comment-action-face ((,class (:foreground ,orange-3 :background ,LIGHT_BG :underline t))))
   `(git-commit-comment-file-face ((,class (:foreground ,magenta-2))))
   `(git-commit-comment-heading-face ((,class (:foreground ,green-4 :background ,green-00 :bold t))))
   `(git-commit-known-pseudo-header-face ((,class (:foreground ,green-2))))
   `(git-commit-no-branch-face ((,class (:foreground ,orange-3))))
   `(git-commit-nonempty-second-line-face ((,class (:foreground ,red-2))))
   `(git-commit-note-face ((,class (:foreground ,cyan-3))))
   `(git-commit-overlong-summary-face ((,class (:foreground ,red-2))))
   `(git-commit-pseudo-header-face ((,class (:foreground ,magenta-3))))
   `(git-commit-summary-face ((,class (:foreground ,blue-2))))
   `(git-rebase-description-face ((,class (:foreground ,white-3))))
   `(git-rebase-killed-action-face ((,class (:foreground ,white-3))))

   ;; Message
   `(message-cited-text ((,class (:foreground ,green-2))))
   `(message-header-cc ((,class (:foreground ,blue-1))))
   `(message-header-name ((,class (:foreground ,black-2))))
   `(message-header-newsgroups ((,class (:foreground ,blue-3 :bold t))))
   `(message-header-other ((,class (:foreground ,magenta-2))))
   `(message-header-subject ((,class (:foreground ,black-5 :bold t))))
   `(message-header-to ((,class (:foreground ,blue-2 :underline t :bold t))))
   `(message-header-xheader ((,class (:foreground ,white-4))))
   `(message-mml ((,class (:foreground ,orange-2))))
   `(message-separator ((,class (:foreground ,white-3))))

   ;; Tab-bar & Tab-line for Emacs 27
   `(tab-bar ((,class (:background ,linum-light :foreground ,linum-dark :underline ,linum-light))))
   `(tab-bar-tab ((,class (:background "#e7e7bf" :foreground ,black-5 :underline ,black-5 :bold t))))
   `(tab-bar-tab-inactive ((,class (:background ,linum-light :foreground ,black-2))))

   `(tab-line ((,class (:background ,linum-light :foreground ,linum-dark))))
   `(tab-line-close-highlight ((,class (:background ,linum-light :foreground ,linum-dark))))
   `(tab-line-highlight ((,class (:background "#e7e7bf" :foreground ,linum-dark))))
   `(tab-line-tab ((,class (:background ,linum-light :foreground ,linum-dark))))
   `(tab-line-tab-current ((,class (:background "#e7e7bf" :foreground ,black-6 :underline ,black-6))))
   `(tab-line-tab-inactive ((,class (:background ,linum-light :foreground ,black-2))))

   ;; Grep
   `(grep-context-face ((,class (:foreground ,red-2))))
   `(grep-error-face ((,class (:foreground ,red-1 :weight bold :underline t))))
   `(grep-hit-face ((,class (:foreground ,green-2))))
   `(grep-match-face ((,class (:foreground unspecified :background unspecified :inherit match))))

   ;; diff-hl
   `(diff-hl-change ((,class (:foreground ,blue-4 :background ,blue-1 :bold t))))
   `(diff-hl-delete ((,class (:foreground ,red-3 :background ,red-1 :bold t))))
   `(diff-hl-insert ((,class (:foreground ,green-4, :background ,green-2 :bold t))))
   `(diff-hl-reverted-hunk-highlight ((,class (:inherit (highlight)))))
   `(diff-hl-dired-change ((,class (:inherit (diff-hl-change)))))
   `(diff-hl-dired-delete ((,class (:inherit (diff-hl-delete)))))
   ;; `(diff-hl-dired-ignored ((,class (:inherit (font-lock-comment-face)))))
   `(diff-hl-dired-insert ((,class (:inherit (diff-hl-insert)))))
   ;; `(diff-hl-dired-unknown ((,class (:inherit (diff-hl-change)))))

   ;; Diff
   `(diff-added ((,class (:foreground ,green-4 :background ,green-00 :bold t))))
   `(diff-changed ((,class (:foreground ,yellow-4 :background ,yellow-00 :bold t))))
   `(diff-context ((,class (:foreground ,white-4))))
   `(diff-file-header ((,class (:foreground ,blue-3 :background ,blue-0 :bold t :underline t))))
   `(diff-function ((,class (:foreground ,black-2 :background ,white-2))))
   `(diff-header ((,class (:foreground ,blue-3 :background ,blue-0))))
   `(diff-hunk-header ((,class (:foreground ,blue-3 :background ,blue-00 :overline t))))
   `(diff-index ((,class (:foreground ,black-4 :background ,white-3 :bold t))))
   `(diff-indicator-added ((,class (:foreground ,white-0 :background ,green-3 :bold t))))
   `(diff-indicator-changed ((,class (:foreground ,white-0 :background ,yellow-3 :bold t))))
   `(diff-indicator-removed ((,class (:foreground ,white-0 :background ,red-3 :bold t))))
   `(diff-nonexistent ((,class (:foreground ,white-0 :background ,red-3 :bold t))))
   `(diff-refine-added ((,class (:foreground ,white-0 :background ,green-3 :bold t))))
   `(diff-refine-change ((,class (:foreground ,white-0 :background ,yellow-3 :bold t))))
   `(diff-refine-removed ((,class (:foreground ,white-0 :background ,red-3 :bold t))))
   `(diff-removed ((,class (:foreground ,red-3 :background ,red-00 :bold t))))

   ;; Ediff
   ;; `current': Face for highlighting the selected difference in buffer A/B/C
   ;; `fine':    Face for highlighting the refinement of the selected diff in buffer A/B/C.
   ;; `even':    Face for highlighting even-numbered non-current differences in buffer A/B/C
   ;; `odd':     Face for highlighting odd-numbered non-current differences in buffer A/B/C.
   `(ediff-current-diff-A        ((,class (:background ,green-00 :foreground ,black-5))))
   `(ediff-current-diff-Ancestor ((,class (:background ,green-00 :foreground ,black-5))))
   `(ediff-current-diff-B        ((,class (:background ,green-00 :foreground ,black-5))))
   `(ediff-current-diff-C        ((,class (:background ,green-00 :foreground ,black-5))))
   `(ediff-fine-diff-A           ((,class (:background ,green-0  :foreground ,green-5 :bold t))))
   `(ediff-fine-diff-Ancestor    ((,class (:background ,green-0  :foreground ,green-5 :bold t))))
   `(ediff-fine-diff-B           ((,class (:background ,green-0  :foreground ,green-5 :bold t))))
   `(ediff-fine-diff-C           ((,class (:background ,green-0  :foreground ,green-5 :bold t))))
   `(ediff-even-diff-A           ((,class (:background ,white-2 :foreground ,black-2))))
   `(ediff-even-diff-Ancestor    ((,class (:background ,white-2 :foreground ,black-2))))
   `(ediff-even-diff-B           ((,class (:background ,white-2 :foreground ,black-2))))
   `(ediff-even-diff-C           ((,class (:background ,white-2 :foreground ,black-2))))
   `(ediff-odd-diff-A            ((,class (:background ,white-2 :foreground ,black-2))))
   `(ediff-odd-diff-Ancestor     ((,class (:background ,white-2 :foreground ,black-2))))
   `(ediff-odd-diff-B            ((,class (:background ,white-2 :foreground ,black-2))))
   `(ediff-odd-diff-C            ((,class (:background ,white-2 :foreground ,black-2))))

   ;; smerge
   `(smerge-refined-change ((,class (:background ,blue-3 :foreground ,white-0))))

   ;; Flyspell faces
   `(flyspell-duplicate ((,class (:underline t foreground-color,orange-1))))
   `(flyspell-incorrect ((,class (:background ,red-1 :foreground ,white-0 :bold t))))

   ;; Semantic faces
   `(semantic-decoration-on-includes ((,class (:underline ,black-1))))
   `(semantic-decoration-on-private-members-face   ((,class (:foreground ,white-0 :background ,purple-0))))
   `(semantic-decoration-on-protected-members-face ((,class (:foreground ,white-0 :background ,magenta-1))))
   `(semantic-decoration-on-unknown-includes       ((,class (:foreground ,white-0 :background ,red-0))))
   `(semantic-decoration-on-unparsed-includes      ((,class (:foreground unspecified      :background ,yellow-1))))
   `(semantic-highlight-edits-face                 ((,class (:foreground unspecified :background ,green-0))))
   `(semantic-highlight-func-current-tag-face      ((,class (:foreground unspecified :background ,green-0))))
   `(semantic-tag-boundary-face ((,class (:overline ,blue-1))))
   `(semantic-unmatched-syntax-face ((,class (:underline ,red-1))))

   ;; CUA
   `(cua-rectangle ((,class (:background ,magenta-3 :foreground ,white-0))))

   ;; Ace-jump
   `(ace-jump-face-background ((,class (:foreground ,white-4))))
   `(ace-jump-face-foreground ((,class (:foreground ,red-2 :bold t))))

   ;; avy-mode
   `(avy-lead-face ((,class (:background ,cyan-1 :foreground ,black-4))))
   `(avy-lead-face-0 ((,class (:background ,purple-00 :foreground ,black-4))))
   `(avy-lead-face-1 ((,class (:background ,white-2 :foreground ,black-4))))
   `(avy-lead-face-2 ((,class (:background ,green-2 :foreground ,black-4))))

   ;; Rainbow-delimiters
   `(rainbow-delimiters-depth-1-face ((,class (:bold t :foreground ,red-2))))
   `(rainbow-delimiters-depth-2-face ((,class (:bold t :foreground ,blue-2))))
   `(rainbow-delimiters-depth-3-face ((,class (:bold t :foreground ,green-3))))
   `(rainbow-delimiters-depth-4-face ((,class (:bold t :foreground ,magenta-2))))
   `(rainbow-delimiters-depth-5-face ((,class (:bold t :foreground ,cyan-3))))
   `(rainbow-delimiters-depth-6-face ((,class (:bold t :foreground ,orange-2))))
   `(rainbow-delimiters-depth-7-face ((,class (:bold t :foreground ,purple-2))))
   `(rainbow-delimiters-depth-8-face ((,class (:bold t :foreground ,yellow-3))))
   `(rainbow-delimiters-depth-9-face ((,class (:bold t :foreground ,black-5))))
   `(rainbow-delimiters-unmatched-face ((,class (:foreground ,white-0 :background ,red-3 :bold t))))

   ;; EShell
   `(eshell-ls-archive ((,class (:foreground ,purple-2))))
   `(eshell-ls-backup ((,class (:foreground ,white-3))))
   `(eshell-ls-clutter ((,class (:foreground ,black-1))))
   `(eshell-ls-directory ((,class (:foreground ,blue-1 :bold t))))
   `(eshell-ls-executable ((,class (:foreground ,green-3))))
   `(eshell-ls-missing ((,class (:foreground ,white-0 :background ,red-3))))
   `(eshell-ls-product ((,class (:foreground ,white-0 :background ,green-2))))
   `(eshell-ls-readonly ((,class (:foreground ,orange-3))))
   `(eshell-ls-special ((,class (:foreground ,yellow-3))))
   `(eshell-ls-symlink  ((,class (:foreground ,magenta-2))))
   `(eshell-ls-unreadable ((,class (:foreground ,black-2))))
   `(eshell-prompt ((,class (:foreground ,black-3 :background ,yellow-0 :bold t))))

   ;; Comint prompt
   `(comint-highlight-prompt ((,class (:foreground ,black-3 :background ,yellow-0 :bold t))))

   ;; which-function-mode
   `(which-func ((,class (:foreground ,blue-3 :background unspecified))))

   ;; Flymake
   `(flymake-warnline ((,class (:underline ,orange-2))))
   `(flymake-errline ((,class (:underline ,red-2))))

   ;; Flycheck
   `(flycheck-error ((,class (:background ,red-2 :foreground ,white-0 :bold t))))
   `(flycheck-warnline ((,class (:background ,orange-2 :foreground ,white-0 :bold t))))

   ;; Malabar
   `(malabar-error-face ((,class (:underline ,red-2))))
   `(malabar-warning-face ((,class (:underline ,orange-2))))
   `(malabar-info-face ((,class (:underline ,blue-2))))

   ;; MMM-Mode
   `(mmm-cleanup-submode-face ((,class (:background ,orange-00))))
   `(mmm-code-submode-face ((,class (:background ,blue-00))))
   `(mmm-comment-submode-face ((,class (:background ,blue-0))))
   `(mmm-declaration-submode-face ((,class (:background ,cyan-1))))
   `(mmm-default-submode-face ((,class (:background unspecified))))
   `(mmm-delimiter-face ((,class (:background unspecified :foreground ,black-5))))
   `(mmm-init-submode-face ((,class (:background ,magenta-0))))
   `(mmm-output-submode-face ((,class (:background ,purple-00))))
   `(mmm-special-submode-face ((,class (:background ,green-00))))

   ;; Clojure/Cider
   `(clojure-test-failure-face ((,class (:underline ,orange-2))))
   `(clojure-test-error-face ((,class (:underline ,red-2))))
   `(clojure-test-success-face ((,class (:underline ,green-3))))
   `(cider-deprecated-face ((,class (:background ,red-00))))

   ;; Javascript
   `(js2-function-param-face ((,class (:foreground ,green-3))))
   `(js2-external-variable ((,class (:foreground ,orange-2 :underline t))))
   `(js2-error ((,class (:foreground ,red-2 :underline t :bold t))))
   `(js2-warning ((,class (:foreground unspecified :underline t :bold t))))

   ;; rcirc
   `(rcirc-bright-nick ((,class (:foreground ,blue-1 :bold t))))
   `(rcirc-dim-nick ((,class (:foreground ,black-2 :bold t))))
   `(rcirc-keyword ((,class (:foreground ,magenta-2 :bold t))))
   `(rcirc-my-nick ((,class (:foreground ,green-2 :bold t))))
   `(rcirc-nick-in-message ((,class (:foreground ,green-3))))
   `(rcirc-nick-in-message-full-line ((,class (:foreground ,blue-3))))
   `(rcirc-other-nick ((,class (:foreground ,blue-4 :bold t))))
   `(rcirc-prompt ((,class (:foreground ,black-3 :background ,green-01 :bold t))))
   `(rcirc-server ((,class (:foreground ,black-1))))
   `(rcirc-server-prefix ((,class (:foreground ,black-1))))
   `(rcirc-timestamp ((,class (:foreground ,orange-2))))
   `(rcirc-track-keyword ((,class (:foreground ,magenta-2))))
   `(rcirc-track-nick ((,class (:foreground ,blue-1))))
   `(rcirc-url ((,class (:foreground ,blue-2 :bold nil :underline ,blue-2))))

   ;; ERC
   `(erc-button ((,class (:foreground ,blue-2 :underline ,blue-2 :bold nil))))
   `(erc-current-nick-face ((,class (:foreground ,green-3))))
   `(erc-dangerous-hosts ((,class (:foreground ,red-3 :bold t))))
   `(erc-direct-msg-face ((,class (:foreground ,orange-2))))
   `(erc-error-face ((,class (:foreground ,red-2))))
   `(erc-header-face ((,class (:background ,blue-1))))
   `(erc-input-face ((,class (:foreground ,black-3))))
   `(erc-keyword-face ((,class (:foreground ,magenta-2 :bold t))))
   `(erc-my-nick-face ((,class (:foreground ,green-2 :bold t))))
   `(erc-nick-default-face ((,class (:bold t :foreground ,blue-4))))
   `(erc-nick-msg-face ((,class (:weight normal :foreground ,orange-2))))
   `(erc-notice-face ((,class (:foreground ,black-1))))
   `(erc-pal-face ((,class (:foreground ,purple-1))))
   `(erc-prompt-face ((,class (:bold t :foreground ,black-3 :background ,green-01))))
   `(erc-timestamp-face ((,class (:foreground ,orange-2))))

   ;; ReStructuredText
   `(rst-level-1-face ((,class (:foreground ,orange-2 :background unspecified :bold t))))
   `(rst-level-2-face ((,class (:foreground ,orange-2 :background unspecified :bold t))))
   `(rst-level-3-face ((,class (:foreground ,orange-2 :background unspecified :bold t))))
   `(rst-level-4-face ((,class (:foreground ,orange-2 :background unspecified :bold t))))
   `(rst-level-5-face ((,class (:foreground ,orange-2 :background unspecified :bold t))))
   `(rst-level-6-face ((,class (:foreground ,orange-2 :background unspecified :bold t))))
   `(rst-level-1 ((,class (:foreground ,orange-2 :background unspecified :bold t))))
   `(rst-level-2 ((,class (:foreground ,orange-2 :background unspecified :bold t))))
   `(rst-level-3 ((,class (:foreground ,orange-2 :background unspecified :bold t))))
   `(rst-level-4 ((,class (:foreground ,orange-2 :background unspecified :bold t))))
   `(rst-level-5 ((,class (:foreground ,orange-2 :background unspecified :bold t))))
   `(rst-level-6 ((,class (:foreground ,orange-2 :background unspecified :bold t))))
   `(rst-adornment ((,class (:foreground ,orange-2 :background unspecified :bold t))))
   `(rst-block ((,class (:foreground ,blue-3 :background ,blue-0 :bold t))))
   `(rst-comment ((,class (:foreground ,red-3 :background ,red-00 :bold t))))
   `(rst-literal ((,class (:foreground ,blue-3 :background ,blue-000))))
   `(rst-reference ((,class (:foreground ,magenta-3 :background ,LIGHT_BG))))
   `(rst-definition ((,class (:foreground ,yellow-3 :background ,LIGHT_BG))))
   `(rst-directive ((,class (:foreground ,purple-2 :background ,purple-00 :bold t))))
   `(rst-external ((,class (:foreground ,blue-2 :background ,LIGHT_BG))))
   `(rst-transition ((,class (:foreground ,green-3 :background ,green-00 :bold t))))

   ;; yalinum
   `(yalinum-bar-face ((,class (:foreground "#d7d7af" :background "#87875f"))))
   `(yalinum-face ((,class (:foreground "#87875f" :background "#d7d7af"))))
   `(yalinum-track-face ((,class (:foreground "#87875f" :background "#d7d7af"))))

   ;; Ruby
   `(enh-ruby-heredoc-delimiter-face ((,class (:foreground ,purple-2))))
   `(enh-ruby-op-face ((,class (:foreground ,orange-3 :bold t))))
   `(enh-ruby-regexp-delimiter-face ((,class (:foreground ,purple-2))))
   `(enh-ruby-string-delimiter-face ((,class (:foreground ,purple-3))))
   `(erm-syn-errline ((,class (:foreground ,red-3 :background ,red-00 :bold t :underline t))))
   `(erm-syn-warnline ((,class (:bold t :underline t))))

   ;; ansi-term
   `(term-color-black ((,class (:background ,black-5 :foreground ,black-5))))
   `(term-color-blue ((,class (:background ,blue-1 :foreground ,blue-1))))
   `(term-color-cyan ((,class (:background ,cyan-3 :foreground ,cyan-3))))
   `(term-color-green ((,class (:background ,green-2 :foreground ,green-2))))
   `(term-color-magenta ((,class (:background ,magenta-3 :foreground ,magenta-3))))
   `(term-color-red ((,class (:background ,red-2 :foreground ,red-2))))
   `(term-color-white ((,class (:background ,white-0 :foreground ,white-0))))
   `(term-color-yellow ((,class (:background ,orange-2 :foreground ,orange-2))))

   ;; ido-mode
   `(ido-first-match ((,class (:foreground ,orange-2 :bold t))))
   `(ido-incomplete-regexp ((,class (:foreground ,red-2 :bold t))))
   `(ido-indicator ((,class (:foreground ,yellow-4 :background ,orange-00))))
   `(ido-only-match ((,class (:foreground ,green-4 :background ,green-00 :bold t))))
   `(ido-subdir ((,class (:foreground ,blue-1 :bold t))))
   `(ido-virtual ((,class (:foreground ,magenta-3))))

   ;; ivy-mode
   `(ivy-current-match ((,class (:foreground ,orange-2 :bold t :inherit highlight))))
   `(ivy-confirm-face ((,class (:foreground ,green-4 :background ,green-00 :bold t))))
   `(ivy-subdir ((,class (:foreground ,blue-1 :bold t))))
   `(ivy-virtual ((,class (:foreground ,magenta-3))))

   `(ivy-minibuffer-match-face-1 ((,class (:background ,blue-1 :foreground ,white-0))))
   `(ivy-minibuffer-match-face-2 ((,class (:bold t :background ,green-2 :foreground ,white-0))))
   `(ivy-minibuffer-match-face-3 ((,class (:bold t :background ,magenta-2 :foreground ,white-0))))
   `(ivy-minibuffer-match-face-4 ((,class (:bold t :background ,cyan-3 :foreground ,white-0))))

   ;; swiper
   `(swiper-match-face-1 ((,class (:background ,blue-1 :foreground ,white-0))))
   `(swiper-match-face-2 ((,class (:bold t :background ,green-3 :foreground ,white-0))))
   `(swiper-match-face-3 ((,class (:bold t :background ,magenta-2 :foreground ,white-0))))
   `(swiper-match-face-4 ((,class (:bold t :background ,cyan-3 :foreground ,white-0))))
   `(swiper-line-face ((,class (:foreground ,orange-2 :bold t :inherit highlight))))

   ;; volatile-highlights
   `(vhl/default-face ((,class (:foreground ,white-0 :background ,blue-1))))

   ;; notmuch
   `(notmuch-search-unread-face ((,class (:weight bold))))
   `(notmuch-message-summary-face ((,class (:background ,white-1))))

   ;; git-gutter (&-fringe)
   `(git-gutter:added ((,class (:foreground ,green-4 :background ,green-0 :bold t))))
   `(git-gutter:deleted ((,class (:foreground ,red-3 :background ,red-00 :bold t))))
   `(git-gutter:modified ((,class (:foreground ,yellow-4 :background ,yellow-0 :bold t))))

   ;; cfw: Calendar Framework
   ;;   `(cfw:face-annotation ((,class (:foreground , :background ,))))
   `(cfw:face-day-title ((,class (:background "#f8f9ff" :foreground ,black-3))))
   ;;   `(cfw:face-default-content ((,class (:foreground , :background ,))))
   ;;   `(cfw:face-default-day ((,class (:foreht , :background ,))))
   ;;   `(cfw:face-disable ((,class (:foreground , :background ,))))
   `(cfw:face-grid ((,class (:foreground ,black-3))))
   `(cfw:face-header ((,class (:foreground ,cyan-6 :background ,white-1 :bold t))))
   `(cfw:face-holiday ((,class (:foreground ,purple-3 :background ,red-000))))
   ;;   `(cfw:face-periods ((,class (:foreground , :background ,))))
   `(cfw:face-saturday ((,class (:foreground ,blue-2 :background ,blue-000 :bold t))))
   `(cfw:face-select ((,class (:foreground unspecified :background ,blue-0))))
   `(cfw:face-sunday ((,class (:foreground ,red-2 :background ,red-000 :bold t))))
   ;;   `(cfw:face-title ((,class (:foreground , :background ,))))
   `(cfw:face-today ((,class (:background ,yellow-00 :foreground ,orange-3))))
   `(cfw:face-today-title ((,class (:foreground ,orange-3 :background "#fad163"))))
   `(cfw:face-toolbar ((,class (:foreground ,white-1 :background ,white-1))))
   `(cfw:face-toolbar-button-off ((,class (:foreground ,cyan-6 :background ,white-1))))
   `(cfw:face-toolbar-button-on ((,class (:foreground ,red-1 :background ,white-0))))

   ;; Column marker
   `(column-marker-1 ((,class (:background ,white-3))))
   `(column-marker-2 ((,class (:background ,yellow-0))))
   `(column-marker-3 ((,class (:background ,red-00))))

   ;; Swoop / Helm-Swoop
   `(swoop-face-header-format-line ((,class (:foreground ,black-6 :background unspecified :underline nil))))
   `(swoop-face-line-buffer-name ((,class (:foreground ,green-4 :background ,green-0))))
   `(swoop-face-line-number ((,class (:foreground "#87875f" :background "#d7d7af"))))
   `(swoop-face-target-line ((,class (:foreground ,yellow-4 :background ,yellow-0))))
   `(swoop-face-target-words ((,class (:foreground ,magenta-3 :background ,magenta-00 :bold t))))
   `(helm-swoop-target-line-block-face ((,class (:foreground ,yellow-4 :background ,yellow-0))))
   `(helm-swoop-target-line-face ((,class (:foreground ,black-3 :background ,green-01))))
   `(helm-swoop-target-word-face ((,class (:foreground ,magenta-3 :background ,magenta-00 :bold t))))

   ;; widget
   `(widget-button ((,class (:foreground ,blue-2 :underline t :bold t))))
   `(widget-button-pressed ((,class (:foreground ,blue-1))))
   `(widget-documentation ((,class (:foreground ,green-3))))
   `(widget-field ((,class (:foreground ,black-6 :background ,green-00))))
   `(widget-inactive ((,class (:foreground ,white-4))))
   `(widget-single-line-field ((,class (:foreground ,black-6 :background ,orange-2))))

   ;; compilation
   `(compilation-column-number ((,class (:foreground ,green-3))))
   `(compilation-error ((,class (:foreground ,red-3 :background ,red-000 :bold t))))
   `(compilation-info ((,class (:foreground ,orange-2 :background ,white-1))))
   `(compilation-line-number ((,class (:foreground ,blue-2))))
   `(compilation-mode-line-exit ((,class (:foreground ,green-4 :background ,green-0 :bold t))))
   `(compilation-mode-line-fail ((,class (:foreground ,red-3 :background ,red-00 :bold t))))
   `(compilation-mode-line-run ((,class (:foreground ,orange-4 :background ,orange-00 :bold t))))
   `(compilation-warning ((,class (:foreground ,orange-3))))

   ;; Neotree
   `(neo-banner-face ((,class (:foreground ,green-5 :background ,green-00))))
   `(neo-header-face ((,class (:foreground ,green-4 :background unspecified))))
   `(neo-root-dir-face ((,class (:foreground ,magenta-2))))
   `(neo-button-face ((,class (:foreground ,blue-1 :bold t))))
   `(neo-dir-link-face ((,class (:foreground ,blue-1 :bold t))))
   `(neo-expand-btn-face ((,class (:foreground ,blue-3 :background ,blue-00))))
   `(neo-file-link-face ((,class (:foreground ,black-4))))

   ;; info
   `(info-header-node ((,class (:foreground ,red-3 :bold t))))
   `(info-header-xref ((,class (:foreground ,black-5 ::bold t))))
   `(info-index-match ((,class (:background ,yellow-0))))
   `(info-menu-header ((,class (:foreground ,black-4 :bold t :underline t))))
   `(info-menu-star ((,class (:foreground ,red-1))))
   `(info-node ((,class (:foreground ,red-3))))
   `(info-title-1 ((,class (:foreground ,blue-1 :bold t))))
   `(info-title-2 ((,class (:foreground ,green-02 :bold t))))
   `(info-title-3 ((,class (:foreground ,orange-2 :bold t))))
   `(info-title-4 ((,class (:foreground ,magenta-2 :bold t))))
   `(info-xref ((,class (:foreground ,blue-2 :underline t))))
   `(info-xref-visited ((,class (:foreground ,purple-1 :underline t))))

   `(whitespace-empty ((,class (:foreground ,magenta-3 :background ,magenta-00))))
   `(whitespace-hspace ((,class (:foreground ,blue-0 :background "#f5f5dc"))))
   `(whitespace-indentation ((,class (:foreground "#dadada" :background "#f5f5dc"))))
   `(whitespace-line ((,class (:foreground unspecified :background ,yellow-00))))
   `(whitespace-newline ((,class (:foreground "#dadada" :background unspecified))))
   `(whitespace-space ((,class (:foreground "#dadada" :background "#f5f5dc"))))
   `(whitespace-space-after-tab ((,class (:foreground ,cyan-2 :background "#f5f5dc"))))
   `(whitespace-space-before-tab ((,class (:foreground ,orange-3 :background ,orange-00))))
   `(whitespace-tab ((,class (:foreground ,cyan-2 :background "#f5f5dc"))))
   `(whitespace-trailing ((,class (:foreground ,red-1 :background ,red-000))))

   ;; Tuareg
   `(tuareg-font-lock-error-face ((,class (:foreground ,red-3 :background ,red-00 :bold t))))
   `(tuareg-font-lock-governing-face ((,class (:foreground ,black-4 :bold t))))
   `(tuareg-font-lock-interactive-error-face ((,class (:foreground ,red-3 :background ,red-00 :bold t))))
   `(tuareg-font-lock-interactive-output-face ((,class (:foreground ,blue-3))))
   `(tuareg-font-lock-multistage-face ((,class (:foreground ,blue-3 :background ,blue-0))))
   `(tuareg-font-lock-operator-face ((,class (:foreground ,green-3 :bold t))))

   ;; CPerl
   `(cperl-array-face ((,class (:foreground ,blue-3 :background ,blue-00))))
   `(cperl-hash-face ((,class (:foreground ,orange-3 :background ,orange-000))))
   `(cperl-nonoverridable-face ((,class (:foreground ,green-3 :background ,green-00))))

   ;; Haskell
   `(haskell-interactive-face-compile-error ((,class (:foreground ,red-2 :background unspecified :bold t))))
   `(haskell-interactive-face-compile-warning ((,class (:foreground ,orange-2 :background unspecified :bold t))))
   `(haskell-interactive-face-garbage ((,class (:foreground ,black-2))))
   `(haskell-interactive-face-prompt ((,class (:foreground ,black-4 :background ,yellow-0 :bold t))))
   `(haskell-interactive-face-result ((,class (:foreground ,blue-2))))

   ;; EMMS
   `(emms-state-current-playing-time ((,class (:foreground ,blue-3 :bold t))))
   `(emms-state-total-playing-time ((,class (:foreground ,blue-3))))
   `(emms-playlist-selected-face ((,class (:foreground ,green-2 :bold t))))
   `(emms-playlist-track-face ((,class (:foreground ,cyan-5))))

   ;; tty-menu
   `(menu ((,class (:foreground ,linum-light :background ,linum-dark))))
   `(tty-menu-disabled-face ((,class (:foreground ,black-1 :background ,black-3))))
   `(tty-menu-enabled-face ((,class (:foreground ,white-0 :background ,black-3 :bold t))))
   `(tty-menu-selected-face ((,class (:background ,blue-3))))

   ;; web-mode
   `(web-mode-comment-face ((,class (:foreground ,white-3))))
   `(web-mode-current-element-highlight-face ((,class (:background ,green-00))))
   `(web-mode-current-column-highlight-face ((,class (:background ,green-00))))
   `(web-mode-symbol-face ((,class (:foreground ,yellow-3))))
   `(web-mode-type-face ((,class (:foreground ,cyan-4))))

   ;; Custom
   `(custom-button ((,class (:foreground ,white-0 :background ,black-3
                                         :box (:line-width 1 :style released-button)))))
   `(custom-button-mouse ((,class (:foreground ,white-0 :background ,black-2
                                               :box (:line-width 1 :style released-button)))))
   `(custom-button-pressed ((,class (:foreground ,black-3 :background ,white-1
                                                 :box (:line-width 1 :style pressed-button)))))

   ;; Hydra
   `(hydra-face-red ((,class (:foreground ,red-2))))
   `(hydra-face-blue ((,class (:foreground ,blue-2))))
   `(hydra-face-amaranth ((,class (:foreground ,magenta-2))))

   ;; rpm-spec-mode
   `(rpm-spec-tag-face ((,class (:foreground ,blue-2))))
   `(rpm-spec-obsolete-tag-face ((,class (:foreground ,white-0 :bold t :background ,red-2))))
   `(rpm-spec-macro-face ((,class (:foreground ,red-1))))
   `(rpm-spec-var-face ((,class (:foreground ,purple-2))))
   `(rpm-spec-doc-face ((,class (:foreground ,magenta-3))))
   `(rpm-spec-dir-face ((,class (:foreground ,green-3))))
   `(rpm-spec-package-face ((,class (:foreground ,red-2))))
   `(rpm-spec-ghost-face ((,class (:foreground ,red-2))))
   `(rpm-spec-section-face ((,class (:foreground ,red-1))))

   ;; ansi-color
   `(ansi-color-black ((,class (:background ,black-5 :foreground ,black-5))))
   `(ansi-color-red ((,class (:background ,red-0 :foreground ,red-0))))
   `(ansi-color-green ((,class (:background ,green-2 :foreground ,green-2))))
   `(ansi-color-yellow ((,class (:background ,yellow-1 :foreground ,yellow-1))))
   `(ansi-color-blue ((,class (:background ,blue-1 :foreground ,blue-1))))
   `(ansi-color-magenta ((,class (:background ,purple-1 :foreground ,purple-1))))
   `(ansi-color-cyan ((,class (:background ,blue-0 :foreground ,blue-0))))
   `(ansi-color-white ((,class (:background ,white-0 :foreground ,white-0))))
   `(ansi-color-bright-black ((,class (:background ,black-5 :foreground ,black-5))))
   `(ansi-color-bright-red ((,class (:background ,red-0 :foreground ,red-0))))
   `(ansi-color-bright-green ((,class (:background ,green-2 :foreground ,green-2))))
   `(ansi-color-bright-yellow ((,class (:background ,yellow-1 :foreground ,yellow-1))))
   `(ansi-color-bright-blue ((,class (:background ,blue-1 :foreground ,blue-1))))
   `(ansi-color-bright-magenta ((,class (:background ,purple-1 :foreground ,purple-1))))
   `(ansi-color-bright-cyan ((,class (:background ,blue-0 :foreground ,blue-0))))
   `(ansi-color-bright-white ((,class (:background ,white-0 :foreground ,white-0))))
   `(ansi-color-bold ((,class (:inherit bold)))))

  (custom-theme-set-variables
   'moe-light
   `(ansi-color-names-vector [,black-5 ,red-0 ,green-2 ,yellow-1 ,blue-1 ,purple-1 ,blue-0 ,white-0])))

(provide-theme 'moe-light)

;; Local Variables:
;; no-byte-compile: t
;; End:

;;; moe-light-theme.el ends here
