/******************************************************************************
 * Copyright 2010 by Thomas E. Dickey.  All Rights Reserved.                  *
 *                                                                            *
 * Permission to use, copy, modify, and distribute this software and its      *
 * documentation for any purpose and without fee is hereby granted, provided  *
 * that the above copyright notice appear in all copies and that both that    *
 * copyright notice and this permission notice appear in supporting           *
 * documentation, and that the name of the above listed copyright holder(s)   *
 * not be used in advertising or publicity pertaining to distribution of the  *
 * software without specific, written prior permission.                       *
 *                                                                            *
 * The above copyright notice and this permission notice shall be included in *
 * all copies or substantial portions of the Software.                        *
 *                                                                            *
 * THE ABOVE LISTED COPYRIGHT HOLDER(S) DISCLAIM ALL WARRANTIES WITH REGARD   *
 * TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND  *
 * FITNESS, IN NO EVENT SHALL THE ABOVE LISTED COPYRIGHT HOLDER(S) BE LIABLE  *
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES          *
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN      *
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR *
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.                *
 *                                                                            *
 ******************************************************************************/
/* vile:cmode cts=8
 * $XTermId: gnreight.h,v 1.12 2010/12/05 18:24:12 tom Exp $
 *
 * This is a generated set of single-byte encodings,
 * using all available locales in libc6 2.11.2-7 - T.E.Dickey
 */
#ifndef GNREIGHT_H
#define GNREIGHT_H 1
/* *INDENT-OFF* */

/* use minimal ctype information to reduce table size */
#ifndef vl_alpha
#define vl_alpha 0x01
#define vl_cntrl 0x02
#define vl_digit 0x04
#define vl_lower 0x08
#define vl_print 0x10
#define vl_punct 0x20
#define vl_space 0x40
#define vl_upper 0x80
#endif

typedef struct {
    unsigned short chmap[128];
    unsigned char lower[128];
    unsigned char upper[128];
    unsigned char ctype[128];
} GNREIGHT_ENC;

typedef struct {
    const char *name;
    const GNREIGHT_ENC *data;
} GNREIGHT_INX;

/* POSIX table for 0-127 */
static const GNREIGHT_ENC encode_POSIX = {
    /* encode_POSIX.chmap */
    {
	     0,   0x1,   0x2,   0x3,   0x4,   0x5,   0x6,   0x7,
	   0x8,   0x9,   0xa,   0xb,   0xc,   0xd,   0xe,   0xf,
	  0x10,  0x11,  0x12,  0x13,  0x14,  0x15,  0x16,  0x17,
	  0x18,  0x19,  0x1a,  0x1b,  0x1c,  0x1d,  0x1e,  0x1f,
	  0x20,  0x21,  0x22,  0x23,  0x24,  0x25,  0x26,  0x27,
	  0x28,  0x29,  0x2a,  0x2b,  0x2c,  0x2d,  0x2e,  0x2f,
	  0x30,  0x31,  0x32,  0x33,  0x34,  0x35,  0x36,  0x37,
	  0x38,  0x39,  0x3a,  0x3b,  0x3c,  0x3d,  0x3e,  0x3f,
	  0x40,  0x41,  0x42,  0x43,  0x44,  0x45,  0x46,  0x47,
	  0x48,  0x49,  0x4a,  0x4b,  0x4c,  0x4d,  0x4e,  0x4f,
	  0x50,  0x51,  0x52,  0x53,  0x54,  0x55,  0x56,  0x57,
	  0x58,  0x59,  0x5a,  0x5b,  0x5c,  0x5d,  0x5e,  0x5f,
	  0x60,  0x61,  0x62,  0x63,  0x64,  0x65,  0x66,  0x67,
	  0x68,  0x69,  0x6a,  0x6b,  0x6c,  0x6d,  0x6e,  0x6f,
	  0x70,  0x71,  0x72,  0x73,  0x74,  0x75,  0x76,  0x77,
	  0x78,  0x79,  0x7a,  0x7b,  0x7c,  0x7d,  0x7e,  0x7f,
    },
    /* encode_POSIX.lower */
    {
	     0,   0x1,   0x2,   0x3,   0x4,   0x5,   0x6,   0x7,
	   0x8,   0x9,   0xa,   0xb,   0xc,   0xd,   0xe,   0xf,
	  0x10,  0x11,  0x12,  0x13,  0x14,  0x15,  0x16,  0x17,
	  0x18,  0x19,  0x1a,  0x1b,  0x1c,  0x1d,  0x1e,  0x1f,
	  0x20,  0x21,  0x22,  0x23,  0x24,  0x25,  0x26,  0x27,
	  0x28,  0x29,  0x2a,  0x2b,  0x2c,  0x2d,  0x2e,  0x2f,
	  0x30,  0x31,  0x32,  0x33,  0x34,  0x35,  0x36,  0x37,
	  0x38,  0x39,  0x3a,  0x3b,  0x3c,  0x3d,  0x3e,  0x3f,
	  0x40,  0x61,  0x62,  0x63,  0x64,  0x65,  0x66,  0x67,
	  0x68,  0x69,  0x6a,  0x6b,  0x6c,  0x6d,  0x6e,  0x6f,
	  0x70,  0x71,  0x72,  0x73,  0x74,  0x75,  0x76,  0x77,
	  0x78,  0x79,  0x7a,  0x5b,  0x5c,  0x5d,  0x5e,  0x5f,
	  0x60,  0x61,  0x62,  0x63,  0x64,  0x65,  0x66,  0x67,
	  0x68,  0x69,  0x6a,  0x6b,  0x6c,  0x6d,  0x6e,  0x6f,
	  0x70,  0x71,  0x72,  0x73,  0x74,  0x75,  0x76,  0x77,
	  0x78,  0x79,  0x7a,  0x7b,  0x7c,  0x7d,  0x7e,  0x7f,
    },
    /* encode_POSIX.upper */
    {
	     0,   0x1,   0x2,   0x3,   0x4,   0x5,   0x6,   0x7,
	   0x8,   0x9,   0xa,   0xb,   0xc,   0xd,   0xe,   0xf,
	  0x10,  0x11,  0x12,  0x13,  0x14,  0x15,  0x16,  0x17,
	  0x18,  0x19,  0x1a,  0x1b,  0x1c,  0x1d,  0x1e,  0x1f,
	  0x20,  0x21,  0x22,  0x23,  0x24,  0x25,  0x26,  0x27,
	  0x28,  0x29,  0x2a,  0x2b,  0x2c,  0x2d,  0x2e,  0x2f,
	  0x30,  0x31,  0x32,  0x33,  0x34,  0x35,  0x36,  0x37,
	  0x38,  0x39,  0x3a,  0x3b,  0x3c,  0x3d,  0x3e,  0x3f,
	  0x40,  0x41,  0x42,  0x43,  0x44,  0x45,  0x46,  0x47,
	  0x48,  0x49,  0x4a,  0x4b,  0x4c,  0x4d,  0x4e,  0x4f,
	  0x50,  0x51,  0x52,  0x53,  0x54,  0x55,  0x56,  0x57,
	  0x58,  0x59,  0x5a,  0x5b,  0x5c,  0x5d,  0x5e,  0x5f,
	  0x60,  0x41,  0x42,  0x43,  0x44,  0x45,  0x46,  0x47,
	  0x48,  0x49,  0x4a,  0x4b,  0x4c,  0x4d,  0x4e,  0x4f,
	  0x50,  0x51,  0x52,  0x53,  0x54,  0x55,  0x56,  0x57,
	  0x58,  0x59,  0x5a,  0x7b,  0x7c,  0x7d,  0x7e,  0x7f,
    },
    /* encode_POSIX.ctype */
    {
	/* 0 */	(vl_cntrl),
	/* 0x1 */	(vl_cntrl),
	/* 0x2 */	(vl_cntrl),
	/* 0x3 */	(vl_cntrl),
	/* 0x4 */	(vl_cntrl),
	/* 0x5 */	(vl_cntrl),
	/* 0x6 */	(vl_cntrl),
	/* 0x7 */	(vl_cntrl),
	/* 0x8 */	(vl_cntrl),
	/* 0x9 */	(vl_cntrl | vl_space),
	/* 0xa */	(vl_cntrl | vl_space),
	/* 0xb */	(vl_cntrl | vl_space),
	/* 0xc */	(vl_cntrl | vl_space),
	/* 0xd */	(vl_cntrl | vl_space),
	/* 0xe */	(vl_cntrl),
	/* 0xf */	(vl_cntrl),
	/* 0x10 */	(vl_cntrl),
	/* 0x11 */	(vl_cntrl),
	/* 0x12 */	(vl_cntrl),
	/* 0x13 */	(vl_cntrl),
	/* 0x14 */	(vl_cntrl),
	/* 0x15 */	(vl_cntrl),
	/* 0x16 */	(vl_cntrl),
	/* 0x17 */	(vl_cntrl),
	/* 0x18 */	(vl_cntrl),
	/* 0x19 */	(vl_cntrl),
	/* 0x1a */	(vl_cntrl),
	/* 0x1b */	(vl_cntrl),
	/* 0x1c */	(vl_cntrl),
	/* 0x1d */	(vl_cntrl),
	/* 0x1e */	(vl_cntrl),
	/* 0x1f */	(vl_cntrl),
	/* 0x20 */	(vl_print | vl_space),
	/* 0x21 */	(vl_print | vl_punct),
	/* 0x22 */	(vl_print | vl_punct),
	/* 0x23 */	(vl_print | vl_punct),
	/* 0x24 */	(vl_print | vl_punct),
	/* 0x25 */	(vl_print | vl_punct),
	/* 0x26 */	(vl_print | vl_punct),
	/* 0x27 */	(vl_print | vl_punct),
	/* 0x28 */	(vl_print | vl_punct),
	/* 0x29 */	(vl_print | vl_punct),
	/* 0x2a */	(vl_print | vl_punct),
	/* 0x2b */	(vl_print | vl_punct),
	/* 0x2c */	(vl_print | vl_punct),
	/* 0x2d */	(vl_print | vl_punct),
	/* 0x2e */	(vl_print | vl_punct),
	/* 0x2f */	(vl_print | vl_punct),
	/* 0x30 */	(vl_digit | vl_print),
	/* 0x31 */	(vl_digit | vl_print),
	/* 0x32 */	(vl_digit | vl_print),
	/* 0x33 */	(vl_digit | vl_print),
	/* 0x34 */	(vl_digit | vl_print),
	/* 0x35 */	(vl_digit | vl_print),
	/* 0x36 */	(vl_digit | vl_print),
	/* 0x37 */	(vl_digit | vl_print),
	/* 0x38 */	(vl_digit | vl_print),
	/* 0x39 */	(vl_digit | vl_print),
	/* 0x3a */	(vl_print | vl_punct),
	/* 0x3b */	(vl_print | vl_punct),
	/* 0x3c */	(vl_print | vl_punct),
	/* 0x3d */	(vl_print | vl_punct),
	/* 0x3e */	(vl_print | vl_punct),
	/* 0x3f */	(vl_print | vl_punct),
	/* 0x40 */	(vl_print | vl_punct),
	/* 0x41 */	(vl_alpha | vl_print | vl_upper),
	/* 0x42 */	(vl_alpha | vl_print | vl_upper),
	/* 0x43 */	(vl_alpha | vl_print | vl_upper),
	/* 0x44 */	(vl_alpha | vl_print | vl_upper),
	/* 0x45 */	(vl_alpha | vl_print | vl_upper),
	/* 0x46 */	(vl_alpha | vl_print | vl_upper),
	/* 0x47 */	(vl_alpha | vl_print | vl_upper),
	/* 0x48 */	(vl_alpha | vl_print | vl_upper),
	/* 0x49 */	(vl_alpha | vl_print | vl_upper),
	/* 0x4a */	(vl_alpha | vl_print | vl_upper),
	/* 0x4b */	(vl_alpha | vl_print | vl_upper),
	/* 0x4c */	(vl_alpha | vl_print | vl_upper),
	/* 0x4d */	(vl_alpha | vl_print | vl_upper),
	/* 0x4e */	(vl_alpha | vl_print | vl_upper),
	/* 0x4f */	(vl_alpha | vl_print | vl_upper),
	/* 0x50 */	(vl_alpha | vl_print | vl_upper),
	/* 0x51 */	(vl_alpha | vl_print | vl_upper),
	/* 0x52 */	(vl_alpha | vl_print | vl_upper),
	/* 0x53 */	(vl_alpha | vl_print | vl_upper),
	/* 0x54 */	(vl_alpha | vl_print | vl_upper),
	/* 0x55 */	(vl_alpha | vl_print | vl_upper),
	/* 0x56 */	(vl_alpha | vl_print | vl_upper),
	/* 0x57 */	(vl_alpha | vl_print | vl_upper),
	/* 0x58 */	(vl_alpha | vl_print | vl_upper),
	/* 0x59 */	(vl_alpha | vl_print | vl_upper),
	/* 0x5a */	(vl_alpha | vl_print | vl_upper),
	/* 0x5b */	(vl_print | vl_punct),
	/* 0x5c */	(vl_print | vl_punct),
	/* 0x5d */	(vl_print | vl_punct),
	/* 0x5e */	(vl_print | vl_punct),
	/* 0x5f */	(vl_print | vl_punct),
	/* 0x60 */	(vl_print | vl_punct),
	/* 0x61 */	(vl_alpha | vl_lower | vl_print),
	/* 0x62 */	(vl_alpha | vl_lower | vl_print),
	/* 0x63 */	(vl_alpha | vl_lower | vl_print),
	/* 0x64 */	(vl_alpha | vl_lower | vl_print),
	/* 0x65 */	(vl_alpha | vl_lower | vl_print),
	/* 0x66 */	(vl_alpha | vl_lower | vl_print),
	/* 0x67 */	(vl_alpha | vl_lower | vl_print),
	/* 0x68 */	(vl_alpha | vl_lower | vl_print),
	/* 0x69 */	(vl_alpha | vl_lower | vl_print),
	/* 0x6a */	(vl_alpha | vl_lower | vl_print),
	/* 0x6b */	(vl_alpha | vl_lower | vl_print),
	/* 0x6c */	(vl_alpha | vl_lower | vl_print),
	/* 0x6d */	(vl_alpha | vl_lower | vl_print),
	/* 0x6e */	(vl_alpha | vl_lower | vl_print),
	/* 0x6f */	(vl_alpha | vl_lower | vl_print),
	/* 0x70 */	(vl_alpha | vl_lower | vl_print),
	/* 0x71 */	(vl_alpha | vl_lower | vl_print),
	/* 0x72 */	(vl_alpha | vl_lower | vl_print),
	/* 0x73 */	(vl_alpha | vl_lower | vl_print),
	/* 0x74 */	(vl_alpha | vl_lower | vl_print),
	/* 0x75 */	(vl_alpha | vl_lower | vl_print),
	/* 0x76 */	(vl_alpha | vl_lower | vl_print),
	/* 0x77 */	(vl_alpha | vl_lower | vl_print),
	/* 0x78 */	(vl_alpha | vl_lower | vl_print),
	/* 0x79 */	(vl_alpha | vl_lower | vl_print),
	/* 0x7a */	(vl_alpha | vl_lower | vl_print),
	/* 0x7b */	(vl_print | vl_punct),
	/* 0x7c */	(vl_print | vl_punct),
	/* 0x7d */	(vl_print | vl_punct),
	/* 0x7e */	(vl_print | vl_punct),
	/* 0x7f */	(vl_cntrl),
    },
};

/*
 * Sorted encodings:
 */

/*   0:ANSI_X3.4-1968 */
static const GNREIGHT_ENC encode_ANSI_X3_4_1968 = {
    /* encode_ANSI_X3_4_1968.chmap */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_ANSI_X3_4_1968.lower */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_ANSI_X3_4_1968.upper */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_ANSI_X3_4_1968.ctype */
    {
	/* 0x80 */	0,
	/* 0x81 */	0,
	/* 0x82 */	0,
	/* 0x83 */	0,
	/* 0x84 */	0,
	/* 0x85 */	0,
	/* 0x86 */	0,
	/* 0x87 */	0,
	/* 0x88 */	0,
	/* 0x89 */	0,
	/* 0x8a */	0,
	/* 0x8b */	0,
	/* 0x8c */	0,
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	0,
	/* 0x92 */	0,
	/* 0x93 */	0,
	/* 0x94 */	0,
	/* 0x95 */	0,
	/* 0x96 */	0,
	/* 0x97 */	0,
	/* 0x98 */	0,
	/* 0x99 */	0,
	/* 0x9a */	0,
	/* 0x9b */	0,
	/* 0x9c */	0,
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	0,
	/* 0xa0 */	0,
	/* 0xa1 */	0,
	/* 0xa2 */	0,
	/* 0xa3 */	0,
	/* 0xa4 */	0,
	/* 0xa5 */	0,
	/* 0xa6 */	0,
	/* 0xa7 */	0,
	/* 0xa8 */	0,
	/* 0xa9 */	0,
	/* 0xaa */	0,
	/* 0xab */	0,
	/* 0xac */	0,
	/* 0xad */	0,
	/* 0xae */	0,
	/* 0xaf */	0,
	/* 0xb0 */	0,
	/* 0xb1 */	0,
	/* 0xb2 */	0,
	/* 0xb3 */	0,
	/* 0xb4 */	0,
	/* 0xb5 */	0,
	/* 0xb6 */	0,
	/* 0xb7 */	0,
	/* 0xb8 */	0,
	/* 0xb9 */	0,
	/* 0xba */	0,
	/* 0xbb */	0,
	/* 0xbc */	0,
	/* 0xbd */	0,
	/* 0xbe */	0,
	/* 0xbf */	0,
	/* 0xc0 */	0,
	/* 0xc1 */	0,
	/* 0xc2 */	0,
	/* 0xc3 */	0,
	/* 0xc4 */	0,
	/* 0xc5 */	0,
	/* 0xc6 */	0,
	/* 0xc7 */	0,
	/* 0xc8 */	0,
	/* 0xc9 */	0,
	/* 0xca */	0,
	/* 0xcb */	0,
	/* 0xcc */	0,
	/* 0xcd */	0,
	/* 0xce */	0,
	/* 0xcf */	0,
	/* 0xd0 */	0,
	/* 0xd1 */	0,
	/* 0xd2 */	0,
	/* 0xd3 */	0,
	/* 0xd4 */	0,
	/* 0xd5 */	0,
	/* 0xd6 */	0,
	/* 0xd7 */	0,
	/* 0xd8 */	0,
	/* 0xd9 */	0,
	/* 0xda */	0,
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	0,
	/* 0xe0 */	0,
	/* 0xe1 */	0,
	/* 0xe2 */	0,
	/* 0xe3 */	0,
	/* 0xe4 */	0,
	/* 0xe5 */	0,
	/* 0xe6 */	0,
	/* 0xe7 */	0,
	/* 0xe8 */	0,
	/* 0xe9 */	0,
	/* 0xea */	0,
	/* 0xeb */	0,
	/* 0xec */	0,
	/* 0xed */	0,
	/* 0xee */	0,
	/* 0xef */	0,
	/* 0xf0 */	0,
	/* 0xf1 */	0,
	/* 0xf2 */	0,
	/* 0xf3 */	0,
	/* 0xf4 */	0,
	/* 0xf5 */	0,
	/* 0xf6 */	0,
	/* 0xf7 */	0,
	/* 0xf8 */	0,
	/* 0xf9 */	0,
	/* 0xfa */	0,
	/* 0xfb */	0,
	/* 0xfc */	0,
	/* 0xfd */	0,
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/*   1:ARMSCII-8 */
static const GNREIGHT_ENC encode_ARMSCII_8 = {
    /* encode_ARMSCII_8.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0, 0x587, 0x589,  0x29,  0x28,  0xbb,  0xab,
	0x2014,  0x2e, 0x55d,  0x2c,  0x2d, 0x58a,0x2026, 0x55c,
	 0x55b, 0x55e, 0x531, 0x561, 0x532, 0x562, 0x533, 0x563,
	 0x534, 0x564, 0x535, 0x565, 0x536, 0x566, 0x537, 0x567,
	 0x538, 0x568, 0x539, 0x569, 0x53a, 0x56a, 0x53b, 0x56b,
	 0x53c, 0x56c, 0x53d, 0x56d, 0x53e, 0x56e, 0x53f, 0x56f,
	 0x540, 0x570, 0x541, 0x571, 0x542, 0x572, 0x543, 0x573,
	 0x544, 0x574, 0x545, 0x575, 0x546, 0x576, 0x547, 0x577,
	 0x548, 0x578, 0x549, 0x579, 0x54a, 0x57a, 0x54b, 0x57b,
	 0x54c, 0x57c, 0x54d, 0x57d, 0x54e, 0x57e, 0x54f, 0x57f,
	 0x550, 0x580, 0x551, 0x581, 0x552, 0x582, 0x553, 0x583,
	 0x554, 0x584, 0x555, 0x585, 0x556, 0x586, 0x55a,     0
    },
    /* encode_ARMSCII_8.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb3,  0xb3,  0xb5,  0xb5,  0xb7,  0xb7,
	  0xb9,  0xb9,  0xbb,  0xbb,  0xbd,  0xbd,  0xbf,  0xbf,
	  0xc1,  0xc1,  0xc3,  0xc3,  0xc5,  0xc5,  0xc7,  0xc7,
	  0xc9,  0xc9,  0xcb,  0xcb,  0xcd,  0xcd,  0xcf,  0xcf,
	  0xd1,  0xd1,  0xd3,  0xd3,  0xd5,  0xd5,  0xd7,  0xd7,
	  0xd9,  0xd9,  0xdb,  0xdb,  0xdd,  0xdd,  0xdf,  0xdf,
	  0xe1,  0xe1,  0xe3,  0xe3,  0xe5,  0xe5,  0xe7,  0xe7,
	  0xe9,  0xe9,  0xeb,  0xeb,  0xed,  0xed,  0xef,  0xef,
	  0xf1,  0xf1,  0xf3,  0xf3,  0xf5,  0xf5,  0xf7,  0xf7,
	  0xf9,  0xf9,  0xfb,  0xfb,  0xfd,  0xfd,  0xfe,     0
    },
    /* encode_ARMSCII_8.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb2,  0xb4,  0xb4,  0xb6,  0xb6,
	  0xb8,  0xb8,  0xba,  0xba,  0xbc,  0xbc,  0xbe,  0xbe,
	  0xc0,  0xc0,  0xc2,  0xc2,  0xc4,  0xc4,  0xc6,  0xc6,
	  0xc8,  0xc8,  0xca,  0xca,  0xcc,  0xcc,  0xce,  0xce,
	  0xd0,  0xd0,  0xd2,  0xd2,  0xd4,  0xd4,  0xd6,  0xd6,
	  0xd8,  0xd8,  0xda,  0xda,  0xdc,  0xdc,  0xde,  0xde,
	  0xe0,  0xe0,  0xe2,  0xe2,  0xe4,  0xe4,  0xe6,  0xe6,
	  0xe8,  0xe8,  0xea,  0xea,  0xec,  0xec,  0xee,  0xee,
	  0xf0,  0xf0,  0xf2,  0xf2,  0xf4,  0xf4,  0xf6,  0xf6,
	  0xf8,  0xf8,  0xfa,  0xfa,  0xfc,  0xfc,  0xfe,     0
    },
    /* encode_ARMSCII_8.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	0,
	/* 0xa2 */	(vl_alpha | vl_print),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	0,
	/* 0xa5 */	0,
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	0,
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	0,
	/* 0xac */	0,
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_alpha | vl_print | vl_upper),
	/* 0xbb */	(vl_alpha | vl_lower | vl_print),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_alpha | vl_lower | vl_print),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_lower | vl_print),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_lower | vl_print),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_lower | vl_print),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_lower | vl_print),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_print | vl_upper),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_print | vl_upper),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_print | vl_upper),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	0,
    },
};

/*   2:BIG5 */
static const GNREIGHT_ENC encode_BIG5 = {
    /* encode_BIG5.chmap */
    {
	  0x80,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_BIG5.lower */
    {
	  0x80,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_BIG5.upper */
    {
	  0x80,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_BIG5.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	0,
	/* 0x82 */	0,
	/* 0x83 */	0,
	/* 0x84 */	0,
	/* 0x85 */	0,
	/* 0x86 */	0,
	/* 0x87 */	0,
	/* 0x88 */	0,
	/* 0x89 */	0,
	/* 0x8a */	0,
	/* 0x8b */	0,
	/* 0x8c */	0,
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	0,
	/* 0x92 */	0,
	/* 0x93 */	0,
	/* 0x94 */	0,
	/* 0x95 */	0,
	/* 0x96 */	0,
	/* 0x97 */	0,
	/* 0x98 */	0,
	/* 0x99 */	0,
	/* 0x9a */	0,
	/* 0x9b */	0,
	/* 0x9c */	0,
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	0,
	/* 0xa0 */	0,
	/* 0xa1 */	0,
	/* 0xa2 */	0,
	/* 0xa3 */	0,
	/* 0xa4 */	0,
	/* 0xa5 */	0,
	/* 0xa6 */	0,
	/* 0xa7 */	0,
	/* 0xa8 */	0,
	/* 0xa9 */	0,
	/* 0xaa */	0,
	/* 0xab */	0,
	/* 0xac */	0,
	/* 0xad */	0,
	/* 0xae */	0,
	/* 0xaf */	0,
	/* 0xb0 */	0,
	/* 0xb1 */	0,
	/* 0xb2 */	0,
	/* 0xb3 */	0,
	/* 0xb4 */	0,
	/* 0xb5 */	0,
	/* 0xb6 */	0,
	/* 0xb7 */	0,
	/* 0xb8 */	0,
	/* 0xb9 */	0,
	/* 0xba */	0,
	/* 0xbb */	0,
	/* 0xbc */	0,
	/* 0xbd */	0,
	/* 0xbe */	0,
	/* 0xbf */	0,
	/* 0xc0 */	0,
	/* 0xc1 */	0,
	/* 0xc2 */	0,
	/* 0xc3 */	0,
	/* 0xc4 */	0,
	/* 0xc5 */	0,
	/* 0xc6 */	0,
	/* 0xc7 */	0,
	/* 0xc8 */	0,
	/* 0xc9 */	0,
	/* 0xca */	0,
	/* 0xcb */	0,
	/* 0xcc */	0,
	/* 0xcd */	0,
	/* 0xce */	0,
	/* 0xcf */	0,
	/* 0xd0 */	0,
	/* 0xd1 */	0,
	/* 0xd2 */	0,
	/* 0xd3 */	0,
	/* 0xd4 */	0,
	/* 0xd5 */	0,
	/* 0xd6 */	0,
	/* 0xd7 */	0,
	/* 0xd8 */	0,
	/* 0xd9 */	0,
	/* 0xda */	0,
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	0,
	/* 0xe0 */	0,
	/* 0xe1 */	0,
	/* 0xe2 */	0,
	/* 0xe3 */	0,
	/* 0xe4 */	0,
	/* 0xe5 */	0,
	/* 0xe6 */	0,
	/* 0xe7 */	0,
	/* 0xe8 */	0,
	/* 0xe9 */	0,
	/* 0xea */	0,
	/* 0xeb */	0,
	/* 0xec */	0,
	/* 0xed */	0,
	/* 0xee */	0,
	/* 0xef */	0,
	/* 0xf0 */	0,
	/* 0xf1 */	0,
	/* 0xf2 */	0,
	/* 0xf3 */	0,
	/* 0xf4 */	0,
	/* 0xf5 */	0,
	/* 0xf6 */	0,
	/* 0xf7 */	0,
	/* 0xf8 */	0,
	/* 0xf9 */	0,
	/* 0xfa */	0,
	/* 0xfb */	0,
	/* 0xfc */	0,
	/* 0xfd */	0,
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/*   3:BIG5-HKSCS */
static const GNREIGHT_ENC encode_BIG5_HKSCS = {
    /* encode_BIG5_HKSCS.chmap */
    {
	  0x80,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_BIG5_HKSCS.lower */
    {
	  0x80,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_BIG5_HKSCS.upper */
    {
	  0x80,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_BIG5_HKSCS.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	0,
	/* 0x82 */	0,
	/* 0x83 */	0,
	/* 0x84 */	0,
	/* 0x85 */	0,
	/* 0x86 */	0,
	/* 0x87 */	0,
	/* 0x88 */	0,
	/* 0x89 */	0,
	/* 0x8a */	0,
	/* 0x8b */	0,
	/* 0x8c */	0,
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	0,
	/* 0x92 */	0,
	/* 0x93 */	0,
	/* 0x94 */	0,
	/* 0x95 */	0,
	/* 0x96 */	0,
	/* 0x97 */	0,
	/* 0x98 */	0,
	/* 0x99 */	0,
	/* 0x9a */	0,
	/* 0x9b */	0,
	/* 0x9c */	0,
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	0,
	/* 0xa0 */	0,
	/* 0xa1 */	0,
	/* 0xa2 */	0,
	/* 0xa3 */	0,
	/* 0xa4 */	0,
	/* 0xa5 */	0,
	/* 0xa6 */	0,
	/* 0xa7 */	0,
	/* 0xa8 */	0,
	/* 0xa9 */	0,
	/* 0xaa */	0,
	/* 0xab */	0,
	/* 0xac */	0,
	/* 0xad */	0,
	/* 0xae */	0,
	/* 0xaf */	0,
	/* 0xb0 */	0,
	/* 0xb1 */	0,
	/* 0xb2 */	0,
	/* 0xb3 */	0,
	/* 0xb4 */	0,
	/* 0xb5 */	0,
	/* 0xb6 */	0,
	/* 0xb7 */	0,
	/* 0xb8 */	0,
	/* 0xb9 */	0,
	/* 0xba */	0,
	/* 0xbb */	0,
	/* 0xbc */	0,
	/* 0xbd */	0,
	/* 0xbe */	0,
	/* 0xbf */	0,
	/* 0xc0 */	0,
	/* 0xc1 */	0,
	/* 0xc2 */	0,
	/* 0xc3 */	0,
	/* 0xc4 */	0,
	/* 0xc5 */	0,
	/* 0xc6 */	0,
	/* 0xc7 */	0,
	/* 0xc8 */	0,
	/* 0xc9 */	0,
	/* 0xca */	0,
	/* 0xcb */	0,
	/* 0xcc */	0,
	/* 0xcd */	0,
	/* 0xce */	0,
	/* 0xcf */	0,
	/* 0xd0 */	0,
	/* 0xd1 */	0,
	/* 0xd2 */	0,
	/* 0xd3 */	0,
	/* 0xd4 */	0,
	/* 0xd5 */	0,
	/* 0xd6 */	0,
	/* 0xd7 */	0,
	/* 0xd8 */	0,
	/* 0xd9 */	0,
	/* 0xda */	0,
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	0,
	/* 0xe0 */	0,
	/* 0xe1 */	0,
	/* 0xe2 */	0,
	/* 0xe3 */	0,
	/* 0xe4 */	0,
	/* 0xe5 */	0,
	/* 0xe6 */	0,
	/* 0xe7 */	0,
	/* 0xe8 */	0,
	/* 0xe9 */	0,
	/* 0xea */	0,
	/* 0xeb */	0,
	/* 0xec */	0,
	/* 0xed */	0,
	/* 0xee */	0,
	/* 0xef */	0,
	/* 0xf0 */	0,
	/* 0xf1 */	0,
	/* 0xf2 */	0,
	/* 0xf3 */	0,
	/* 0xf4 */	0,
	/* 0xf5 */	0,
	/* 0xf6 */	0,
	/* 0xf7 */	0,
	/* 0xf8 */	0,
	/* 0xf9 */	0,
	/* 0xfa */	0,
	/* 0xfb */	0,
	/* 0xfc */	0,
	/* 0xfd */	0,
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/*   4:CP1251 */
static const GNREIGHT_ENC encode_CP1251 = {
    /* encode_CP1251.chmap */
    {
	 0x402, 0x403,0x201a, 0x453,0x201e,0x2026,0x2020,0x2021,
	0x20ac,0x2030, 0x409,0x2039, 0x40a, 0x40c, 0x40b, 0x40f,
	 0x452,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	     0,0x2122, 0x459,0x203a, 0x45a, 0x45c, 0x45b, 0x45f,
	  0xa0, 0x40e, 0x45e, 0x408,  0xa4, 0x490,  0xa6,  0xa7,
	 0x401,  0xa9, 0x404,  0xab,  0xac,  0xad,  0xae, 0x407,
	  0xb0,  0xb1, 0x406, 0x456, 0x491,  0xb5,  0xb6,  0xb7,
	 0x451,0x2116, 0x454,  0xbb, 0x458, 0x405, 0x455, 0x457,
	 0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
	 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
	 0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
	 0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
	 0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
	 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
	 0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
	 0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e, 0x44f
    },
    /* encode_CP1251.lower */
    {
	  0x90,  0x83,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x9a,  0x8b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa2,  0xa2,  0xbc,  0xa4,  0xb4,  0xa6,  0xa7,
	  0xb8,  0xa9,  0xba,  0xab,  0xac,  0xad,  0xae,  0xbf,
	  0xb0,  0xb1,  0xb3,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbe,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_CP1251.upper */
    {
	  0x80,  0x81,  0x82,  0x81,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x80,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,  0x99,  0x8a,  0x9b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0xa0,  0xa1,  0xa1,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb2,  0xa5,  0xb5,  0xb6,  0xb7,
	  0xa8,  0xb9,  0xaa,  0xbb,  0xa3,  0xbd,  0xbd,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf
    },
    /* encode_CP1251.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_print | vl_upper),
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_print | vl_punct),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_lower | vl_print),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	0,
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	(vl_alpha | vl_lower | vl_print),
	/* 0x9e */	(vl_alpha | vl_lower | vl_print),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_print | vl_upper),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*   5:CP1255 */
static const GNREIGHT_ENC encode_CP1255 = {
    /* encode_CP1255.chmap */
    {
	0x20ac,     0,0x201a, 0x192,0x201e,0x2026,0x2020,0x2021,
	 0x2c6,0x2030,     0,0x2039,     0,     0,     0,     0,
	     0,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	 0x2dc,0x2122,     0,0x203a,     0,     0,     0,     0,
	  0xa0,  0xa1,  0xa2,  0xa3,0x20aa,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xd7,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xf7,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	 0x5b0, 0x5b1, 0x5b2, 0x5b3, 0x5b4, 0x5b5, 0x5b6, 0x5b7,
	 0x5b8, 0x5b9,     0, 0x5bb, 0x5bc, 0x5bd, 0x5be, 0x5bf,
	 0x5c0, 0x5c1, 0x5c2, 0x5c3, 0x5c3, 0x5f0, 0x5f1, 0x5f2,
	 0x5f4,     0,     0,     0,     0,     0,     0,     0,
	 0x5f4, 0x5d0, 0x5d1, 0x5d2, 0x5d3, 0x5d4, 0x5d5, 0x5d6,
	 0x5d7, 0x5d8, 0x5d9, 0x5da, 0x5db, 0x5dc, 0x5dd, 0x5de,
	 0x5df, 0x5e0, 0x5e1, 0x5e2, 0x5e3, 0x5e4, 0x5e5, 0x5e6,
	 0x5e7, 0x5e8, 0x5e9,     0,     0, 0x5ea,0x200f,     0
    },
    /* encode_CP1255.lower */
    {
	  0x80,     0,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,     0,  0x8b,     0,     0,     0,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,     0,  0x9b,     0,     0,     0,     0,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,     0,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,     0,     0,     0,     0,     0,     0,     0,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,     0,     0,  0xfd,  0xfe,     0
    },
    /* encode_CP1255.upper */
    {
	  0x80,     0,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,     0,  0x8b,     0,     0,     0,     0,
	     0,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,     0,  0x9b,     0,     0,     0,     0,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,     0,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,     0,     0,     0,     0,     0,     0,     0,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,     0,     0,  0xfd,  0xfe,     0
    },
    /* encode_CP1255.ctype */
    {
	/* 0x80 */	(vl_print | vl_punct),
	/* 0x81 */	0,
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_alpha | vl_print),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	0,
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	0,
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_print | vl_punct),
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	0,
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	0,
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	0,
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_print | vl_punct),
	/* 0xc1 */	(vl_print | vl_punct),
	/* 0xc2 */	(vl_print | vl_punct),
	/* 0xc3 */	(vl_print | vl_punct),
	/* 0xc4 */	(vl_print | vl_punct),
	/* 0xc5 */	(vl_print | vl_punct),
	/* 0xc6 */	(vl_print | vl_punct),
	/* 0xc7 */	(vl_print | vl_punct),
	/* 0xc8 */	(vl_print | vl_punct),
	/* 0xc9 */	(vl_print | vl_punct),
	/* 0xca */	0,
	/* 0xcb */	(vl_print | vl_punct),
	/* 0xcc */	(vl_print | vl_punct),
	/* 0xcd */	(vl_print | vl_punct),
	/* 0xce */	(vl_print | vl_punct),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_print | vl_punct),
	/* 0xd1 */	(vl_print | vl_punct),
	/* 0xd2 */	(vl_print | vl_punct),
	/* 0xd3 */	(vl_print | vl_punct),
	/* 0xd4 */	(vl_alpha | vl_print),
	/* 0xd5 */	(vl_alpha | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_print | vl_punct),
	/* 0xd9 */	0,
	/* 0xda */	0,
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	0,
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_alpha | vl_print),
	/* 0xe7 */	(vl_alpha | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print),
	/* 0xe9 */	(vl_alpha | vl_print),
	/* 0xea */	(vl_alpha | vl_print),
	/* 0xeb */	(vl_alpha | vl_print),
	/* 0xec */	(vl_alpha | vl_print),
	/* 0xed */	(vl_alpha | vl_print),
	/* 0xee */	(vl_alpha | vl_print),
	/* 0xef */	(vl_alpha | vl_print),
	/* 0xf0 */	(vl_alpha | vl_print),
	/* 0xf1 */	(vl_alpha | vl_print),
	/* 0xf2 */	(vl_alpha | vl_print),
	/* 0xf3 */	(vl_alpha | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print),
	/* 0xf5 */	(vl_alpha | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print),
	/* 0xf7 */	(vl_alpha | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print),
	/* 0xf9 */	(vl_alpha | vl_print),
	/* 0xfa */	(vl_alpha | vl_print),
	/* 0xfb */	0,
	/* 0xfc */	0,
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	0,
    },
};

/*   6:EUC-JP */
static const GNREIGHT_ENC encode_EUC_JP = {
    /* encode_EUC_JP.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,     0,     0,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_EUC_JP.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,     0,     0,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_EUC_JP.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,     0,     0,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_EUC_JP.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	0,
	/* 0xa1 */	0,
	/* 0xa2 */	0,
	/* 0xa3 */	0,
	/* 0xa4 */	0,
	/* 0xa5 */	0,
	/* 0xa6 */	0,
	/* 0xa7 */	0,
	/* 0xa8 */	0,
	/* 0xa9 */	0,
	/* 0xaa */	0,
	/* 0xab */	0,
	/* 0xac */	0,
	/* 0xad */	0,
	/* 0xae */	0,
	/* 0xaf */	0,
	/* 0xb0 */	0,
	/* 0xb1 */	0,
	/* 0xb2 */	0,
	/* 0xb3 */	0,
	/* 0xb4 */	0,
	/* 0xb5 */	0,
	/* 0xb6 */	0,
	/* 0xb7 */	0,
	/* 0xb8 */	0,
	/* 0xb9 */	0,
	/* 0xba */	0,
	/* 0xbb */	0,
	/* 0xbc */	0,
	/* 0xbd */	0,
	/* 0xbe */	0,
	/* 0xbf */	0,
	/* 0xc0 */	0,
	/* 0xc1 */	0,
	/* 0xc2 */	0,
	/* 0xc3 */	0,
	/* 0xc4 */	0,
	/* 0xc5 */	0,
	/* 0xc6 */	0,
	/* 0xc7 */	0,
	/* 0xc8 */	0,
	/* 0xc9 */	0,
	/* 0xca */	0,
	/* 0xcb */	0,
	/* 0xcc */	0,
	/* 0xcd */	0,
	/* 0xce */	0,
	/* 0xcf */	0,
	/* 0xd0 */	0,
	/* 0xd1 */	0,
	/* 0xd2 */	0,
	/* 0xd3 */	0,
	/* 0xd4 */	0,
	/* 0xd5 */	0,
	/* 0xd6 */	0,
	/* 0xd7 */	0,
	/* 0xd8 */	0,
	/* 0xd9 */	0,
	/* 0xda */	0,
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	0,
	/* 0xe0 */	0,
	/* 0xe1 */	0,
	/* 0xe2 */	0,
	/* 0xe3 */	0,
	/* 0xe4 */	0,
	/* 0xe5 */	0,
	/* 0xe6 */	0,
	/* 0xe7 */	0,
	/* 0xe8 */	0,
	/* 0xe9 */	0,
	/* 0xea */	0,
	/* 0xeb */	0,
	/* 0xec */	0,
	/* 0xed */	0,
	/* 0xee */	0,
	/* 0xef */	0,
	/* 0xf0 */	0,
	/* 0xf1 */	0,
	/* 0xf2 */	0,
	/* 0xf3 */	0,
	/* 0xf4 */	0,
	/* 0xf5 */	0,
	/* 0xf6 */	0,
	/* 0xf7 */	0,
	/* 0xf8 */	0,
	/* 0xf9 */	0,
	/* 0xfa */	0,
	/* 0xfb */	0,
	/* 0xfc */	0,
	/* 0xfd */	0,
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/*   7:EUC-KR */
static const GNREIGHT_ENC encode_EUC_KR = {
    /* encode_EUC_KR.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_EUC_KR.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_EUC_KR.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_EUC_KR.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	0,
	/* 0xa1 */	0,
	/* 0xa2 */	0,
	/* 0xa3 */	0,
	/* 0xa4 */	0,
	/* 0xa5 */	0,
	/* 0xa6 */	0,
	/* 0xa7 */	0,
	/* 0xa8 */	0,
	/* 0xa9 */	0,
	/* 0xaa */	0,
	/* 0xab */	0,
	/* 0xac */	0,
	/* 0xad */	0,
	/* 0xae */	0,
	/* 0xaf */	0,
	/* 0xb0 */	0,
	/* 0xb1 */	0,
	/* 0xb2 */	0,
	/* 0xb3 */	0,
	/* 0xb4 */	0,
	/* 0xb5 */	0,
	/* 0xb6 */	0,
	/* 0xb7 */	0,
	/* 0xb8 */	0,
	/* 0xb9 */	0,
	/* 0xba */	0,
	/* 0xbb */	0,
	/* 0xbc */	0,
	/* 0xbd */	0,
	/* 0xbe */	0,
	/* 0xbf */	0,
	/* 0xc0 */	0,
	/* 0xc1 */	0,
	/* 0xc2 */	0,
	/* 0xc3 */	0,
	/* 0xc4 */	0,
	/* 0xc5 */	0,
	/* 0xc6 */	0,
	/* 0xc7 */	0,
	/* 0xc8 */	0,
	/* 0xc9 */	0,
	/* 0xca */	0,
	/* 0xcb */	0,
	/* 0xcc */	0,
	/* 0xcd */	0,
	/* 0xce */	0,
	/* 0xcf */	0,
	/* 0xd0 */	0,
	/* 0xd1 */	0,
	/* 0xd2 */	0,
	/* 0xd3 */	0,
	/* 0xd4 */	0,
	/* 0xd5 */	0,
	/* 0xd6 */	0,
	/* 0xd7 */	0,
	/* 0xd8 */	0,
	/* 0xd9 */	0,
	/* 0xda */	0,
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	0,
	/* 0xe0 */	0,
	/* 0xe1 */	0,
	/* 0xe2 */	0,
	/* 0xe3 */	0,
	/* 0xe4 */	0,
	/* 0xe5 */	0,
	/* 0xe6 */	0,
	/* 0xe7 */	0,
	/* 0xe8 */	0,
	/* 0xe9 */	0,
	/* 0xea */	0,
	/* 0xeb */	0,
	/* 0xec */	0,
	/* 0xed */	0,
	/* 0xee */	0,
	/* 0xef */	0,
	/* 0xf0 */	0,
	/* 0xf1 */	0,
	/* 0xf2 */	0,
	/* 0xf3 */	0,
	/* 0xf4 */	0,
	/* 0xf5 */	0,
	/* 0xf6 */	0,
	/* 0xf7 */	0,
	/* 0xf8 */	0,
	/* 0xf9 */	0,
	/* 0xfa */	0,
	/* 0xfb */	0,
	/* 0xfc */	0,
	/* 0xfd */	0,
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/*   8:EUC-TW */
static const GNREIGHT_ENC encode_EUC_TW = {
    /* encode_EUC_TW.chmap */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_EUC_TW.lower */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_EUC_TW.upper */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_EUC_TW.ctype */
    {
	/* 0x80 */	0,
	/* 0x81 */	0,
	/* 0x82 */	0,
	/* 0x83 */	0,
	/* 0x84 */	0,
	/* 0x85 */	0,
	/* 0x86 */	0,
	/* 0x87 */	0,
	/* 0x88 */	0,
	/* 0x89 */	0,
	/* 0x8a */	0,
	/* 0x8b */	0,
	/* 0x8c */	0,
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	0,
	/* 0x92 */	0,
	/* 0x93 */	0,
	/* 0x94 */	0,
	/* 0x95 */	0,
	/* 0x96 */	0,
	/* 0x97 */	0,
	/* 0x98 */	0,
	/* 0x99 */	0,
	/* 0x9a */	0,
	/* 0x9b */	0,
	/* 0x9c */	0,
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	0,
	/* 0xa0 */	0,
	/* 0xa1 */	0,
	/* 0xa2 */	0,
	/* 0xa3 */	0,
	/* 0xa4 */	0,
	/* 0xa5 */	0,
	/* 0xa6 */	0,
	/* 0xa7 */	0,
	/* 0xa8 */	0,
	/* 0xa9 */	0,
	/* 0xaa */	0,
	/* 0xab */	0,
	/* 0xac */	0,
	/* 0xad */	0,
	/* 0xae */	0,
	/* 0xaf */	0,
	/* 0xb0 */	0,
	/* 0xb1 */	0,
	/* 0xb2 */	0,
	/* 0xb3 */	0,
	/* 0xb4 */	0,
	/* 0xb5 */	0,
	/* 0xb6 */	0,
	/* 0xb7 */	0,
	/* 0xb8 */	0,
	/* 0xb9 */	0,
	/* 0xba */	0,
	/* 0xbb */	0,
	/* 0xbc */	0,
	/* 0xbd */	0,
	/* 0xbe */	0,
	/* 0xbf */	0,
	/* 0xc0 */	0,
	/* 0xc1 */	0,
	/* 0xc2 */	0,
	/* 0xc3 */	0,
	/* 0xc4 */	0,
	/* 0xc5 */	0,
	/* 0xc6 */	0,
	/* 0xc7 */	0,
	/* 0xc8 */	0,
	/* 0xc9 */	0,
	/* 0xca */	0,
	/* 0xcb */	0,
	/* 0xcc */	0,
	/* 0xcd */	0,
	/* 0xce */	0,
	/* 0xcf */	0,
	/* 0xd0 */	0,
	/* 0xd1 */	0,
	/* 0xd2 */	0,
	/* 0xd3 */	0,
	/* 0xd4 */	0,
	/* 0xd5 */	0,
	/* 0xd6 */	0,
	/* 0xd7 */	0,
	/* 0xd8 */	0,
	/* 0xd9 */	0,
	/* 0xda */	0,
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	0,
	/* 0xe0 */	0,
	/* 0xe1 */	0,
	/* 0xe2 */	0,
	/* 0xe3 */	0,
	/* 0xe4 */	0,
	/* 0xe5 */	0,
	/* 0xe6 */	0,
	/* 0xe7 */	0,
	/* 0xe8 */	0,
	/* 0xe9 */	0,
	/* 0xea */	0,
	/* 0xeb */	0,
	/* 0xec */	0,
	/* 0xed */	0,
	/* 0xee */	0,
	/* 0xef */	0,
	/* 0xf0 */	0,
	/* 0xf1 */	0,
	/* 0xf2 */	0,
	/* 0xf3 */	0,
	/* 0xf4 */	0,
	/* 0xf5 */	0,
	/* 0xf6 */	0,
	/* 0xf7 */	0,
	/* 0xf8 */	0,
	/* 0xf9 */	0,
	/* 0xfa */	0,
	/* 0xfb */	0,
	/* 0xfc */	0,
	/* 0xfd */	0,
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/*   9:GB18030 */
static const GNREIGHT_ENC encode_GB18030 = {
    /* encode_GB18030.chmap */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_GB18030.lower */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_GB18030.upper */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_GB18030.ctype */
    {
	/* 0x80 */	0,
	/* 0x81 */	0,
	/* 0x82 */	0,
	/* 0x83 */	0,
	/* 0x84 */	0,
	/* 0x85 */	0,
	/* 0x86 */	0,
	/* 0x87 */	0,
	/* 0x88 */	0,
	/* 0x89 */	0,
	/* 0x8a */	0,
	/* 0x8b */	0,
	/* 0x8c */	0,
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	0,
	/* 0x92 */	0,
	/* 0x93 */	0,
	/* 0x94 */	0,
	/* 0x95 */	0,
	/* 0x96 */	0,
	/* 0x97 */	0,
	/* 0x98 */	0,
	/* 0x99 */	0,
	/* 0x9a */	0,
	/* 0x9b */	0,
	/* 0x9c */	0,
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	0,
	/* 0xa0 */	0,
	/* 0xa1 */	0,
	/* 0xa2 */	0,
	/* 0xa3 */	0,
	/* 0xa4 */	0,
	/* 0xa5 */	0,
	/* 0xa6 */	0,
	/* 0xa7 */	0,
	/* 0xa8 */	0,
	/* 0xa9 */	0,
	/* 0xaa */	0,
	/* 0xab */	0,
	/* 0xac */	0,
	/* 0xad */	0,
	/* 0xae */	0,
	/* 0xaf */	0,
	/* 0xb0 */	0,
	/* 0xb1 */	0,
	/* 0xb2 */	0,
	/* 0xb3 */	0,
	/* 0xb4 */	0,
	/* 0xb5 */	0,
	/* 0xb6 */	0,
	/* 0xb7 */	0,
	/* 0xb8 */	0,
	/* 0xb9 */	0,
	/* 0xba */	0,
	/* 0xbb */	0,
	/* 0xbc */	0,
	/* 0xbd */	0,
	/* 0xbe */	0,
	/* 0xbf */	0,
	/* 0xc0 */	0,
	/* 0xc1 */	0,
	/* 0xc2 */	0,
	/* 0xc3 */	0,
	/* 0xc4 */	0,
	/* 0xc5 */	0,
	/* 0xc6 */	0,
	/* 0xc7 */	0,
	/* 0xc8 */	0,
	/* 0xc9 */	0,
	/* 0xca */	0,
	/* 0xcb */	0,
	/* 0xcc */	0,
	/* 0xcd */	0,
	/* 0xce */	0,
	/* 0xcf */	0,
	/* 0xd0 */	0,
	/* 0xd1 */	0,
	/* 0xd2 */	0,
	/* 0xd3 */	0,
	/* 0xd4 */	0,
	/* 0xd5 */	0,
	/* 0xd6 */	0,
	/* 0xd7 */	0,
	/* 0xd8 */	0,
	/* 0xd9 */	0,
	/* 0xda */	0,
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	0,
	/* 0xe0 */	0,
	/* 0xe1 */	0,
	/* 0xe2 */	0,
	/* 0xe3 */	0,
	/* 0xe4 */	0,
	/* 0xe5 */	0,
	/* 0xe6 */	0,
	/* 0xe7 */	0,
	/* 0xe8 */	0,
	/* 0xe9 */	0,
	/* 0xea */	0,
	/* 0xeb */	0,
	/* 0xec */	0,
	/* 0xed */	0,
	/* 0xee */	0,
	/* 0xef */	0,
	/* 0xf0 */	0,
	/* 0xf1 */	0,
	/* 0xf2 */	0,
	/* 0xf3 */	0,
	/* 0xf4 */	0,
	/* 0xf5 */	0,
	/* 0xf6 */	0,
	/* 0xf7 */	0,
	/* 0xf8 */	0,
	/* 0xf9 */	0,
	/* 0xfa */	0,
	/* 0xfb */	0,
	/* 0xfc */	0,
	/* 0xfd */	0,
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/*  10:GB2312 */
static const GNREIGHT_ENC encode_GB2312 = {
    /* encode_GB2312.chmap */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_GB2312.lower */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_GB2312.upper */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_GB2312.ctype */
    {
	/* 0x80 */	0,
	/* 0x81 */	0,
	/* 0x82 */	0,
	/* 0x83 */	0,
	/* 0x84 */	0,
	/* 0x85 */	0,
	/* 0x86 */	0,
	/* 0x87 */	0,
	/* 0x88 */	0,
	/* 0x89 */	0,
	/* 0x8a */	0,
	/* 0x8b */	0,
	/* 0x8c */	0,
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	0,
	/* 0x92 */	0,
	/* 0x93 */	0,
	/* 0x94 */	0,
	/* 0x95 */	0,
	/* 0x96 */	0,
	/* 0x97 */	0,
	/* 0x98 */	0,
	/* 0x99 */	0,
	/* 0x9a */	0,
	/* 0x9b */	0,
	/* 0x9c */	0,
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	0,
	/* 0xa0 */	0,
	/* 0xa1 */	0,
	/* 0xa2 */	0,
	/* 0xa3 */	0,
	/* 0xa4 */	0,
	/* 0xa5 */	0,
	/* 0xa6 */	0,
	/* 0xa7 */	0,
	/* 0xa8 */	0,
	/* 0xa9 */	0,
	/* 0xaa */	0,
	/* 0xab */	0,
	/* 0xac */	0,
	/* 0xad */	0,
	/* 0xae */	0,
	/* 0xaf */	0,
	/* 0xb0 */	0,
	/* 0xb1 */	0,
	/* 0xb2 */	0,
	/* 0xb3 */	0,
	/* 0xb4 */	0,
	/* 0xb5 */	0,
	/* 0xb6 */	0,
	/* 0xb7 */	0,
	/* 0xb8 */	0,
	/* 0xb9 */	0,
	/* 0xba */	0,
	/* 0xbb */	0,
	/* 0xbc */	0,
	/* 0xbd */	0,
	/* 0xbe */	0,
	/* 0xbf */	0,
	/* 0xc0 */	0,
	/* 0xc1 */	0,
	/* 0xc2 */	0,
	/* 0xc3 */	0,
	/* 0xc4 */	0,
	/* 0xc5 */	0,
	/* 0xc6 */	0,
	/* 0xc7 */	0,
	/* 0xc8 */	0,
	/* 0xc9 */	0,
	/* 0xca */	0,
	/* 0xcb */	0,
	/* 0xcc */	0,
	/* 0xcd */	0,
	/* 0xce */	0,
	/* 0xcf */	0,
	/* 0xd0 */	0,
	/* 0xd1 */	0,
	/* 0xd2 */	0,
	/* 0xd3 */	0,
	/* 0xd4 */	0,
	/* 0xd5 */	0,
	/* 0xd6 */	0,
	/* 0xd7 */	0,
	/* 0xd8 */	0,
	/* 0xd9 */	0,
	/* 0xda */	0,
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	0,
	/* 0xe0 */	0,
	/* 0xe1 */	0,
	/* 0xe2 */	0,
	/* 0xe3 */	0,
	/* 0xe4 */	0,
	/* 0xe5 */	0,
	/* 0xe6 */	0,
	/* 0xe7 */	0,
	/* 0xe8 */	0,
	/* 0xe9 */	0,
	/* 0xea */	0,
	/* 0xeb */	0,
	/* 0xec */	0,
	/* 0xed */	0,
	/* 0xee */	0,
	/* 0xef */	0,
	/* 0xf0 */	0,
	/* 0xf1 */	0,
	/* 0xf2 */	0,
	/* 0xf3 */	0,
	/* 0xf4 */	0,
	/* 0xf5 */	0,
	/* 0xf6 */	0,
	/* 0xf7 */	0,
	/* 0xf8 */	0,
	/* 0xf9 */	0,
	/* 0xfa */	0,
	/* 0xfb */	0,
	/* 0xfc */	0,
	/* 0xfd */	0,
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/*  11:GBK */
static const GNREIGHT_ENC encode_GBK = {
    /* encode_GBK.chmap */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_GBK.lower */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_GBK.upper */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_GBK.ctype */
    {
	/* 0x80 */	0,
	/* 0x81 */	0,
	/* 0x82 */	0,
	/* 0x83 */	0,
	/* 0x84 */	0,
	/* 0x85 */	0,
	/* 0x86 */	0,
	/* 0x87 */	0,
	/* 0x88 */	0,
	/* 0x89 */	0,
	/* 0x8a */	0,
	/* 0x8b */	0,
	/* 0x8c */	0,
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	0,
	/* 0x92 */	0,
	/* 0x93 */	0,
	/* 0x94 */	0,
	/* 0x95 */	0,
	/* 0x96 */	0,
	/* 0x97 */	0,
	/* 0x98 */	0,
	/* 0x99 */	0,
	/* 0x9a */	0,
	/* 0x9b */	0,
	/* 0x9c */	0,
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	0,
	/* 0xa0 */	0,
	/* 0xa1 */	0,
	/* 0xa2 */	0,
	/* 0xa3 */	0,
	/* 0xa4 */	0,
	/* 0xa5 */	0,
	/* 0xa6 */	0,
	/* 0xa7 */	0,
	/* 0xa8 */	0,
	/* 0xa9 */	0,
	/* 0xaa */	0,
	/* 0xab */	0,
	/* 0xac */	0,
	/* 0xad */	0,
	/* 0xae */	0,
	/* 0xaf */	0,
	/* 0xb0 */	0,
	/* 0xb1 */	0,
	/* 0xb2 */	0,
	/* 0xb3 */	0,
	/* 0xb4 */	0,
	/* 0xb5 */	0,
	/* 0xb6 */	0,
	/* 0xb7 */	0,
	/* 0xb8 */	0,
	/* 0xb9 */	0,
	/* 0xba */	0,
	/* 0xbb */	0,
	/* 0xbc */	0,
	/* 0xbd */	0,
	/* 0xbe */	0,
	/* 0xbf */	0,
	/* 0xc0 */	0,
	/* 0xc1 */	0,
	/* 0xc2 */	0,
	/* 0xc3 */	0,
	/* 0xc4 */	0,
	/* 0xc5 */	0,
	/* 0xc6 */	0,
	/* 0xc7 */	0,
	/* 0xc8 */	0,
	/* 0xc9 */	0,
	/* 0xca */	0,
	/* 0xcb */	0,
	/* 0xcc */	0,
	/* 0xcd */	0,
	/* 0xce */	0,
	/* 0xcf */	0,
	/* 0xd0 */	0,
	/* 0xd1 */	0,
	/* 0xd2 */	0,
	/* 0xd3 */	0,
	/* 0xd4 */	0,
	/* 0xd5 */	0,
	/* 0xd6 */	0,
	/* 0xd7 */	0,
	/* 0xd8 */	0,
	/* 0xd9 */	0,
	/* 0xda */	0,
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	0,
	/* 0xe0 */	0,
	/* 0xe1 */	0,
	/* 0xe2 */	0,
	/* 0xe3 */	0,
	/* 0xe4 */	0,
	/* 0xe5 */	0,
	/* 0xe6 */	0,
	/* 0xe7 */	0,
	/* 0xe8 */	0,
	/* 0xe9 */	0,
	/* 0xea */	0,
	/* 0xeb */	0,
	/* 0xec */	0,
	/* 0xed */	0,
	/* 0xee */	0,
	/* 0xef */	0,
	/* 0xf0 */	0,
	/* 0xf1 */	0,
	/* 0xf2 */	0,
	/* 0xf3 */	0,
	/* 0xf4 */	0,
	/* 0xf5 */	0,
	/* 0xf6 */	0,
	/* 0xf7 */	0,
	/* 0xf8 */	0,
	/* 0xf9 */	0,
	/* 0xfa */	0,
	/* 0xfb */	0,
	/* 0xfc */	0,
	/* 0xfd */	0,
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/*  12:GEORGIAN-PS */
static const GNREIGHT_ENC encode_GEORGIAN_PS = {
    /* encode_GEORGIAN_PS.chmap */
    {
	  0x80,  0x81,0x201a, 0x192,0x201e,0x2026,0x2020,0x2021,
	 0x2c6,0x2030, 0x160,0x2039, 0x152,  0x8d,  0x8e,  0x8f,
	  0x90,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	 0x2dc,0x2122, 0x161,0x203a, 0x153,  0x9d,  0x9e, 0x178,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	0x10d0,0x10d1,0x10d2,0x10d3,0x10d4,0x10d5,0x10d6,0x10f1,
	0x10d7,0x10d8,0x10d9,0x10da,0x10db,0x10dc,0x10f2,0x10dd,
	0x10de,0x10df,0x10e0,0x10e1,0x10e2,0x10f3,0x10e3,0x10e4,
	0x10e5,0x10e6,0x10e7,0x10e8,0x10e9,0x10ea,0x10eb,0x10ec,
	0x10ed,0x10ee,0x10f4,0x10ef,0x10f0,0x10f5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_GEORGIAN_PS.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x9a,  0x8b,  0x9c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0xff,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_GEORGIAN_PS.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x8a,  0x9b,  0x8c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0x9f
    },
    /* encode_GEORGIAN_PS.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_alpha | vl_print),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_print | vl_punct),
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_alpha | vl_print | vl_upper),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print),
	/* 0xc2 */	(vl_alpha | vl_print),
	/* 0xc3 */	(vl_alpha | vl_print),
	/* 0xc4 */	(vl_alpha | vl_print),
	/* 0xc5 */	(vl_alpha | vl_print),
	/* 0xc6 */	(vl_alpha | vl_print),
	/* 0xc7 */	(vl_alpha | vl_print),
	/* 0xc8 */	(vl_alpha | vl_print),
	/* 0xc9 */	(vl_alpha | vl_print),
	/* 0xca */	(vl_alpha | vl_print),
	/* 0xcb */	(vl_alpha | vl_print),
	/* 0xcc */	(vl_alpha | vl_print),
	/* 0xcd */	(vl_alpha | vl_print),
	/* 0xce */	(vl_alpha | vl_print),
	/* 0xcf */	(vl_alpha | vl_print),
	/* 0xd0 */	(vl_alpha | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print),
	/* 0xd3 */	(vl_alpha | vl_print),
	/* 0xd4 */	(vl_alpha | vl_print),
	/* 0xd5 */	(vl_alpha | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print),
	/* 0xd7 */	(vl_alpha | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print),
	/* 0xda */	(vl_alpha | vl_print),
	/* 0xdb */	(vl_alpha | vl_print),
	/* 0xdc */	(vl_alpha | vl_print),
	/* 0xdd */	(vl_alpha | vl_print),
	/* 0xde */	(vl_alpha | vl_print),
	/* 0xdf */	(vl_alpha | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  13:ISO-8859-1 */
static const GNREIGHT_ENC encode_ISO_8859_1 = {
    /* encode_ISO_8859_1.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_1.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_1.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xff
    },
    /* encode_ISO_8859_1.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  14:ISO-8859-10 */
static const GNREIGHT_ENC encode_ISO_8859_10 = {
    /* encode_ISO_8859_10.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0, 0x104, 0x112, 0x122, 0x12a, 0x128, 0x136,  0xa7,
	 0x13b, 0x110, 0x160, 0x166, 0x17d,  0xad, 0x16a, 0x14a,
	  0xb0, 0x105, 0x113, 0x123, 0x12b, 0x129, 0x137,  0xb7,
	 0x13c, 0x111, 0x161, 0x167, 0x17e,0x2015, 0x16b, 0x14b,
	 0x100,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6, 0x12e,
	 0x10c,  0xc9, 0x118,  0xcb, 0x116,  0xcd,  0xce,  0xcf,
	  0xd0, 0x145, 0x14c,  0xd3,  0xd4,  0xd5,  0xd6, 0x168,
	  0xd8, 0x172,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	 0x101,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6, 0x12f,
	 0x10d,  0xe9, 0x119,  0xeb, 0x117,  0xed,  0xee,  0xef,
	  0xf0, 0x146, 0x14d,  0xf3,  0xf4,  0xf5,  0xf6, 0x169,
	  0xf8, 0x173,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe, 0x138
    },
    /* encode_ISO_8859_10.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xa7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xad,  0xbe,  0xbf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_10.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xb7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xbd,  0xae,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xff
    },
    /* encode_ISO_8859_10.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_alpha | vl_print | vl_upper),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_print | vl_upper),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_alpha | vl_lower | vl_print),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_print),
    },
};

/*  15:ISO-8859-13 */
static const GNREIGHT_ENC encode_ISO_8859_13 = {
    /* encode_ISO_8859_13.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,0x201d,  0xa2,  0xa3,  0xa4,0x201e,  0xa6,  0xa7,
	  0xd8,  0xa9, 0x156,  0xab,  0xac,  0xad,  0xae,  0xc6,
	  0xb0,  0xb1,  0xb2,  0xb3,0x201c,  0xb5,  0xb6,  0xb7,
	  0xf8,  0xb9, 0x157,  0xbb,  0xbc,  0xbd,  0xbe,  0xe6,
	 0x104, 0x12e, 0x100, 0x106,  0xc4,  0xc5, 0x118, 0x112,
	 0x10c,  0xc9, 0x179, 0x116, 0x122, 0x136, 0x12a, 0x13b,
	 0x160, 0x143, 0x145,  0xd3, 0x14c,  0xd5,  0xd6,  0xd7,
	 0x172, 0x141, 0x15a, 0x16a,  0xdc, 0x17b, 0x17d,  0xdf,
	 0x105, 0x12f, 0x101, 0x107,  0xe4,  0xe5, 0x119, 0x113,
	 0x10d,  0xe9, 0x17a, 0x117, 0x123, 0x137, 0x12b, 0x13c,
	 0x161, 0x144, 0x146,  0xf3, 0x14d,  0xf5,  0xf6,  0xf7,
	 0x173, 0x142, 0x15b, 0x16b,  0xfc, 0x17c, 0x17e,0x2019
    },
    /* encode_ISO_8859_13.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xb8,  0xa9,  0xba,  0xab,  0xac,  0xad,  0xae,  0xbf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_13.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xa8,  0xb9,  0xaa,  0xbb,  0xbc,  0xbd,  0xbe,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xff
    },
    /* encode_ISO_8859_13.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  16:ISO-8859-14 */
static const GNREIGHT_ENC encode_ISO_8859_14 = {
    /* encode_ISO_8859_14.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,0x1e02,0x1e03,  0xa3, 0x10a, 0x10b,0x1e0a,  0xa7,
	0x1e80,  0xa9,0x1e82,0x1e0b,0x1ef2,  0xad,  0xae, 0x178,
	0x1e1e,0x1e1f, 0x120, 0x121,0x1e40,0x1e41,  0xb6,0x1e56,
	0x1e81,0x1e57,0x1e83,0x1e60,0x1ef3,0x1e84,0x1e85,0x1e61,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	 0x174,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,0x1e6a,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd, 0x176,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	 0x175,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,0x1e6b,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd, 0x177,  0xff
    },
    /* encode_ISO_8859_14.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa2,  0xa2,  0xa3,  0xa5,  0xa5,  0xab,  0xa7,
	  0xb8,  0xa9,  0xba,  0xab,  0xbc,  0xad,  0xae,  0xff,
	  0xb1,  0xb1,  0xb3,  0xb3,  0xb5,  0xb5,  0xb6,  0xb9,
	  0xb8,  0xb9,  0xba,  0xbf,  0xbc,  0xbe,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_14.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa1,  0xa3,  0xa4,  0xa4,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xa6,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb0,  0xb2,  0xb2,  0xb4,  0xb4,  0xb6,  0xb7,
	  0xa8,  0xb7,  0xaa,  0xbb,  0xac,  0xbd,  0xbd,  0xbb,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xaf
    },
    /* encode_ISO_8859_14.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_alpha | vl_lower | vl_print),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_alpha | vl_print | vl_upper),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  17:ISO-8859-15 */
static const GNREIGHT_ENC encode_ISO_8859_15 = {
    /* encode_ISO_8859_15.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,0x20ac,  0xa5, 0x160,  0xa7,
	 0x161,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3, 0x17d,  0xb5,  0xb6,  0xb7,
	 0x17e,  0xb9,  0xba,  0xbb, 0x152, 0x153, 0x178,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_15.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa8,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb8,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbd,  0xbd,  0xff,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_15.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa6,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb4,  0xb9,  0xba,  0xbb,  0xbc,  0xbc,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xbe
    },
    /* encode_ISO_8859_15.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_alpha | vl_lower | vl_print),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  18:ISO-8859-2 */
static const GNREIGHT_ENC encode_ISO_8859_2 = {
    /* encode_ISO_8859_2.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0, 0x104, 0x2d8, 0x141,  0xa4, 0x13d, 0x15a,  0xa7,
	  0xa8, 0x160, 0x15e, 0x164, 0x179,  0xad, 0x17d, 0x17b,
	  0xb0, 0x105, 0x2db, 0x142,  0xb4, 0x13e, 0x15b, 0x2c7,
	  0xb8, 0x161, 0x15f, 0x165, 0x17a, 0x2dd, 0x17e, 0x17c,
	 0x154,  0xc1,  0xc2, 0x102,  0xc4, 0x139, 0x106,  0xc7,
	 0x10c,  0xc9, 0x118,  0xcb, 0x11a,  0xcd,  0xce, 0x10e,
	 0x110, 0x143, 0x147,  0xd3,  0xd4, 0x150,  0xd6,  0xd7,
	 0x158, 0x16e,  0xda, 0x170,  0xdc,  0xdd, 0x162,  0xdf,
	 0x155,  0xe1,  0xe2, 0x103,  0xe4, 0x13a, 0x107,  0xe7,
	 0x10d,  0xe9, 0x119,  0xeb, 0x11b,  0xed,  0xee, 0x10f,
	 0x111, 0x144, 0x148,  0xf3,  0xf4, 0x151,  0xf6,  0xf7,
	 0x159, 0x16f,  0xfa, 0x171,  0xfc,  0xfd, 0x163, 0x2d9
    },
    /* encode_ISO_8859_2.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xb1,  0xa2,  0xb3,  0xa4,  0xb5,  0xb6,  0xa7,
	  0xa8,  0xb9,  0xba,  0xbb,  0xbc,  0xad,  0xbe,  0xbf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_2.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xa1,  0xb2,  0xa3,  0xb4,  0xa5,  0xa6,  0xb7,
	  0xb8,  0xa9,  0xaa,  0xab,  0xac,  0xbd,  0xae,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xff
    },
    /* encode_ISO_8859_2.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_alpha | vl_print | vl_upper),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_print | vl_upper),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb7 */	(vl_alpha | vl_print),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_alpha | vl_lower | vl_print),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  19:ISO-8859-3 */
static const GNREIGHT_ENC encode_ISO_8859_3 = {
    /* encode_ISO_8859_3.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0, 0x126, 0x2d8,  0xa3,  0xa4,     0, 0x124,  0xa7,
	  0xa8, 0x130, 0x15e, 0x11e, 0x134,  0xad,     0, 0x17b,
	  0xb0, 0x127,  0xb2,  0xb3,  0xb4,  0xb5, 0x125,  0xb7,
	  0xb8, 0x131, 0x15f, 0x11f, 0x135,  0xbd,     0, 0x17c,
	  0xc0,  0xc1,  0xc2,     0,  0xc4, 0x10a, 0x108,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	     0,  0xd1,  0xd2,  0xd3,  0xd4, 0x120,  0xd6,  0xd7,
	 0x11c,  0xd9,  0xda,  0xdb,  0xdc, 0x16c, 0x15c,  0xdf,
	  0xe0,  0xe1,  0xe2,     0,  0xe4, 0x10b, 0x109,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	     0,  0xf1,  0xf2,  0xf3,  0xf4, 0x121,  0xf6,  0xf7,
	 0x11d,  0xf9,  0xfa,  0xfb,  0xfc, 0x16d, 0x15d, 0x2d9
    },
    /* encode_ISO_8859_3.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xb1,  0xa2,  0xa3,  0xa4,     0,  0xb6,  0xa7,
	  0xa8,  0x69,  0xba,  0xbb,  0xbc,  0xad,     0,  0xbf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,     0,  0xbf,
	  0xe0,  0xe1,  0xe2,     0,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	     0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,     0,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	     0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_3.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,     0,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,     0,  0xaf,
	  0xb0,  0xa1,  0xb2,  0xb3,  0xb4,  0xb5,  0xa6,  0xb7,
	  0xb8,  0x49,  0xaa,  0xab,  0xac,  0xbd,     0,  0xaf,
	  0xc0,  0xc1,  0xc2,     0,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	     0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,     0,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	     0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xff
    },
    /* encode_ISO_8859_3.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	0,
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_alpha | vl_print | vl_upper),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	0,
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_alpha | vl_lower | vl_print),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	0,
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	0,
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	0,
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	0,
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	0,
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_print | vl_punct),
    },
};

/*  20:ISO-8859-5 */
static const GNREIGHT_ENC encode_ISO_8859_5 = {
    /* encode_ISO_8859_5.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0, 0x401, 0x402, 0x403, 0x404, 0x405, 0x406, 0x407,
	 0x408, 0x409, 0x40a, 0x40b, 0x40c,  0xad, 0x40e, 0x40f,
	 0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
	 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
	 0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
	 0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
	 0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
	 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
	 0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
	 0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e, 0x44f,
	0x2116, 0x451, 0x452, 0x453, 0x454, 0x455, 0x456, 0x457,
	 0x458, 0x459, 0x45a, 0x45b, 0x45c,  0xa7, 0x45e, 0x45f
    },
    /* encode_ISO_8859_5.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xad,  0xfe,  0xff,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_5.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xf0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xfd,  0xae,  0xaf
    },
    /* encode_ISO_8859_5.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_alpha | vl_print | vl_upper),
	/* 0xac */	(vl_alpha | vl_print | vl_upper),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_alpha | vl_print | vl_upper),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xba */	(vl_alpha | vl_print | vl_upper),
	/* 0xbb */	(vl_alpha | vl_print | vl_upper),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_alpha | vl_print | vl_upper),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	(vl_alpha | vl_lower | vl_print),
	/* 0xdb */	(vl_alpha | vl_lower | vl_print),
	/* 0xdc */	(vl_alpha | vl_lower | vl_print),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  21:ISO-8859-6 */
static const GNREIGHT_ENC encode_ISO_8859_6 = {
    /* encode_ISO_8859_6.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,     0,     0,  0xa4,     0,     0,     0,
	     0,     0,     0,     0, 0x60c,  0xad,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0, 0x61b,     0,     0,     0, 0x61f,
	     0, 0x621, 0x622, 0x623, 0x624, 0x625, 0x626, 0x627,
	 0x628, 0x629, 0x62a, 0x62b, 0x62c, 0x62d, 0x62e, 0x62f,
	 0x630, 0x631, 0x632, 0x633, 0x634, 0x635, 0x636, 0x637,
	 0x638, 0x639, 0x63a,     0,     0,     0,     0,     0,
	 0x640, 0x641, 0x642, 0x643, 0x644, 0x645, 0x646, 0x647,
	 0x648, 0x649, 0x64a, 0x64b, 0x64c, 0x64d, 0x64e, 0x64f,
	 0x650, 0x651, 0x652,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_ISO_8859_6.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,     0,     0,  0xa4,     0,     0,     0,
	     0,     0,     0,     0,  0xac,  0xad,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,  0xbb,     0,     0,     0,  0xbf,
	     0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,     0,     0,     0,     0,     0,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_ISO_8859_6.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,     0,     0,  0xa4,     0,     0,     0,
	     0,     0,     0,     0,  0xac,  0xad,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,  0xbb,     0,     0,     0,  0xbf,
	     0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,     0,     0,     0,     0,     0,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0
    },
    /* encode_ISO_8859_6.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	0,
	/* 0xa2 */	0,
	/* 0xa3 */	0,
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	0,
	/* 0xa6 */	0,
	/* 0xa7 */	0,
	/* 0xa8 */	0,
	/* 0xa9 */	0,
	/* 0xaa */	0,
	/* 0xab */	0,
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	0,
	/* 0xaf */	0,
	/* 0xb0 */	0,
	/* 0xb1 */	0,
	/* 0xb2 */	0,
	/* 0xb3 */	0,
	/* 0xb4 */	0,
	/* 0xb5 */	0,
	/* 0xb6 */	0,
	/* 0xb7 */	0,
	/* 0xb8 */	0,
	/* 0xb9 */	0,
	/* 0xba */	0,
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	0,
	/* 0xbd */	0,
	/* 0xbe */	0,
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	0,
	/* 0xc1 */	(vl_alpha | vl_print),
	/* 0xc2 */	(vl_alpha | vl_print),
	/* 0xc3 */	(vl_alpha | vl_print),
	/* 0xc4 */	(vl_alpha | vl_print),
	/* 0xc5 */	(vl_alpha | vl_print),
	/* 0xc6 */	(vl_alpha | vl_print),
	/* 0xc7 */	(vl_alpha | vl_print),
	/* 0xc8 */	(vl_alpha | vl_print),
	/* 0xc9 */	(vl_alpha | vl_print),
	/* 0xca */	(vl_alpha | vl_print),
	/* 0xcb */	(vl_alpha | vl_print),
	/* 0xcc */	(vl_alpha | vl_print),
	/* 0xcd */	(vl_alpha | vl_print),
	/* 0xce */	(vl_alpha | vl_print),
	/* 0xcf */	(vl_alpha | vl_print),
	/* 0xd0 */	(vl_alpha | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print),
	/* 0xd3 */	(vl_alpha | vl_print),
	/* 0xd4 */	(vl_alpha | vl_print),
	/* 0xd5 */	(vl_alpha | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print),
	/* 0xd7 */	(vl_alpha | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print),
	/* 0xda */	(vl_alpha | vl_print),
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	0,
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_alpha | vl_print),
	/* 0xe7 */	(vl_alpha | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print),
	/* 0xe9 */	(vl_alpha | vl_print),
	/* 0xea */	(vl_alpha | vl_print),
	/* 0xeb */	(vl_print | vl_punct),
	/* 0xec */	(vl_print | vl_punct),
	/* 0xed */	(vl_print | vl_punct),
	/* 0xee */	(vl_print | vl_punct),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_print | vl_punct),
	/* 0xf1 */	(vl_print | vl_punct),
	/* 0xf2 */	(vl_print | vl_punct),
	/* 0xf3 */	0,
	/* 0xf4 */	0,
	/* 0xf5 */	0,
	/* 0xf6 */	0,
	/* 0xf7 */	0,
	/* 0xf8 */	0,
	/* 0xf9 */	0,
	/* 0xfa */	0,
	/* 0xfb */	0,
	/* 0xfc */	0,
	/* 0xfd */	0,
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/*  22:ISO-8859-7 */
static const GNREIGHT_ENC encode_ISO_8859_7 = {
    /* encode_ISO_8859_7.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,0x2018,0x2019,  0xa3,0x20ac,0x20af,  0xa6,  0xa7,
	  0xa8,  0xa9, 0x37a,  0xab,  0xac,  0xad,     0,0x2015,
	  0xb0,  0xb1,  0xb2,  0xb3, 0x384, 0x385, 0x386,  0xb7,
	 0x388, 0x389, 0x38a,  0xbb, 0x38c,  0xbd, 0x38e, 0x38f,
	 0x390, 0x391, 0x392, 0x393, 0x394, 0x395, 0x396, 0x397,
	 0x398, 0x399, 0x39a, 0x39b, 0x39c, 0x39d, 0x39e, 0x39f,
	 0x3a0, 0x3a1,     0, 0x3a3, 0x3a4, 0x3a5, 0x3a6, 0x3a7,
	 0x3a8, 0x3a9, 0x3aa, 0x3ab, 0x3ac, 0x3ad, 0x3ae, 0x3af,
	 0x3b0, 0x3b1, 0x3b2, 0x3b3, 0x3b4, 0x3b5, 0x3b6, 0x3b7,
	 0x3b8, 0x3b9, 0x3ba, 0x3bb, 0x3bc, 0x3bd, 0x3be, 0x3bf,
	 0x3c0, 0x3c1, 0x3c2, 0x3c3, 0x3c4, 0x3c5, 0x3c6, 0x3c7,
	 0x3c8, 0x3c9, 0x3ca, 0x3cb, 0x3cc, 0x3cd, 0x3ce,     0
    },
    /* encode_ISO_8859_7.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,     0,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xdc,  0xb7,
	  0xdd,  0xde,  0xdf,  0xbb,  0xfc,  0xbd,  0xfd,  0xfe,
	  0xc0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,     0,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,     0
    },
    /* encode_ISO_8859_7.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,     0,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,     0,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xb6,  0xb8,  0xb9,  0xba,
	  0xe0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd3,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xbc,  0xbe,  0xbf,     0
    },
    /* encode_ISO_8859_7.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	0,
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xba */	(vl_alpha | vl_print | vl_upper),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_alpha | vl_print | vl_upper),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_alpha | vl_print | vl_upper),
	/* 0xbf */	(vl_alpha | vl_print | vl_upper),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	0,
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_lower | vl_print),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	0,
    },
};

/*  23:ISO-8859-8 */
static const GNREIGHT_ENC encode_ISO_8859_8 = {
    /* encode_ISO_8859_8.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xd7,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xf7,  0xbb,  0xbc,  0xbd,  0xbe,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,0x2017,
	 0x5d0, 0x5d1, 0x5d2, 0x5d3, 0x5d4, 0x5d5, 0x5d6, 0x5d7,
	 0x5d8, 0x5d9, 0x5da, 0x5db, 0x5dc, 0x5dd, 0x5de, 0x5df,
	 0x5e0, 0x5e1, 0x5e2, 0x5e3, 0x5e4, 0x5e5, 0x5e6, 0x5e7,
	 0x5e8, 0x5e9, 0x5ea,     0,     0,0x200e,0x200f,     0
    },
    /* encode_ISO_8859_8.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,     0,     0,  0xfd,  0xfe,     0
    },
    /* encode_ISO_8859_8.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,     0,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,     0,     0,  0xfd,  0xfe,     0
    },
    /* encode_ISO_8859_8.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	0,
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	0,
	/* 0xc0 */	0,
	/* 0xc1 */	0,
	/* 0xc2 */	0,
	/* 0xc3 */	0,
	/* 0xc4 */	0,
	/* 0xc5 */	0,
	/* 0xc6 */	0,
	/* 0xc7 */	0,
	/* 0xc8 */	0,
	/* 0xc9 */	0,
	/* 0xca */	0,
	/* 0xcb */	0,
	/* 0xcc */	0,
	/* 0xcd */	0,
	/* 0xce */	0,
	/* 0xcf */	0,
	/* 0xd0 */	0,
	/* 0xd1 */	0,
	/* 0xd2 */	0,
	/* 0xd3 */	0,
	/* 0xd4 */	0,
	/* 0xd5 */	0,
	/* 0xd6 */	0,
	/* 0xd7 */	0,
	/* 0xd8 */	0,
	/* 0xd9 */	0,
	/* 0xda */	0,
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_alpha | vl_print),
	/* 0xe7 */	(vl_alpha | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print),
	/* 0xe9 */	(vl_alpha | vl_print),
	/* 0xea */	(vl_alpha | vl_print),
	/* 0xeb */	(vl_alpha | vl_print),
	/* 0xec */	(vl_alpha | vl_print),
	/* 0xed */	(vl_alpha | vl_print),
	/* 0xee */	(vl_alpha | vl_print),
	/* 0xef */	(vl_alpha | vl_print),
	/* 0xf0 */	(vl_alpha | vl_print),
	/* 0xf1 */	(vl_alpha | vl_print),
	/* 0xf2 */	(vl_alpha | vl_print),
	/* 0xf3 */	(vl_alpha | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print),
	/* 0xf5 */	(vl_alpha | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print),
	/* 0xf7 */	(vl_alpha | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print),
	/* 0xf9 */	(vl_alpha | vl_print),
	/* 0xfa */	(vl_alpha | vl_print),
	/* 0xfb */	0,
	/* 0xfc */	0,
	/* 0xfd */	(vl_print | vl_punct),
	/* 0xfe */	(vl_print | vl_punct),
	/* 0xff */	0,
    },
};

/*  24:ISO-8859-9 */
static const GNREIGHT_ENC encode_ISO_8859_9 = {
    /* encode_ISO_8859_9.chmap */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	 0x11e,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc, 0x130, 0x15e,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	 0x11f,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc, 0x131, 0x15f,  0xff
    },
    /* encode_ISO_8859_9.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xd7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0x69,  0xfe,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_ISO_8859_9.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xf7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0x49,  0xde,  0xff
    },
    /* encode_ISO_8859_9.ctype */
    {
	/* 0x80 */	(vl_cntrl),
	/* 0x81 */	(vl_cntrl),
	/* 0x82 */	(vl_cntrl),
	/* 0x83 */	(vl_cntrl),
	/* 0x84 */	(vl_cntrl),
	/* 0x85 */	(vl_cntrl),
	/* 0x86 */	(vl_cntrl),
	/* 0x87 */	(vl_cntrl),
	/* 0x88 */	(vl_cntrl),
	/* 0x89 */	(vl_cntrl),
	/* 0x8a */	(vl_cntrl),
	/* 0x8b */	(vl_cntrl),
	/* 0x8c */	(vl_cntrl),
	/* 0x8d */	(vl_cntrl),
	/* 0x8e */	(vl_cntrl),
	/* 0x8f */	(vl_cntrl),
	/* 0x90 */	(vl_cntrl),
	/* 0x91 */	(vl_cntrl),
	/* 0x92 */	(vl_cntrl),
	/* 0x93 */	(vl_cntrl),
	/* 0x94 */	(vl_cntrl),
	/* 0x95 */	(vl_cntrl),
	/* 0x96 */	(vl_cntrl),
	/* 0x97 */	(vl_cntrl),
	/* 0x98 */	(vl_cntrl),
	/* 0x99 */	(vl_cntrl),
	/* 0x9a */	(vl_cntrl),
	/* 0x9b */	(vl_cntrl),
	/* 0x9c */	(vl_cntrl),
	/* 0x9d */	(vl_cntrl),
	/* 0x9e */	(vl_cntrl),
	/* 0x9f */	(vl_cntrl),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_print | vl_punct),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_print | vl_punct),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_print | vl_punct),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_print | vl_punct),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  25:KOI8-R */
static const GNREIGHT_ENC encode_KOI8_R = {
    /* encode_KOI8_R.chmap */
    {
	0x2500,0x2502,0x250c,0x2510,0x2514,0x2518,0x251c,0x2524,
	0x252c,0x2534,0x253c,0x2580,0x2584,0x2588,0x258c,0x2590,
	0x2591,0x2592,0x2593,0x2320,0x25a0,0x2219,0x221a,0x2248,
	0x2264,0x2265,  0xa0,0x2321,  0xb0,  0xb2,  0xb7,  0xf7,
	0x2550,0x2551,0x2552, 0x451,0x2553,0x2554,0x2555,0x2556,
	0x2557,0x2558,0x2559,0x255a,0x255b,0x255c,0x255d,0x255e,
	0x255f,0x2560,0x2561, 0x401,0x2562,0x2563,0x2564,0x2565,
	0x2566,0x2567,0x2568,0x2569,0x256a,0x256b,0x256c,  0xa9,
	 0x44e, 0x430, 0x431, 0x446, 0x434, 0x435, 0x444, 0x433,
	 0x445, 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e,
	 0x43f, 0x44f, 0x440, 0x441, 0x442, 0x443, 0x436, 0x432,
	 0x44c, 0x44b, 0x437, 0x448, 0x44d, 0x449, 0x447, 0x44a,
	 0x42e, 0x410, 0x411, 0x426, 0x414, 0x415, 0x424, 0x413,
	 0x425, 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e,
	 0x41f, 0x42f, 0x420, 0x421, 0x422, 0x423, 0x416, 0x412,
	 0x42c, 0x42b, 0x417, 0x428, 0x42d, 0x429, 0x427, 0x42a
    },
    /* encode_KOI8_R.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xa3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf
    },
    /* encode_KOI8_R.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xb3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_KOI8_R.ctype */
    {
	/* 0x80 */	(vl_print | vl_punct),
	/* 0x81 */	(vl_print | vl_punct),
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_print | vl_punct),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_print | vl_punct),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_print | vl_punct),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_print | vl_punct),
	/* 0x8d */	(vl_print | vl_punct),
	/* 0x8e */	(vl_print | vl_punct),
	/* 0x8f */	(vl_print | vl_punct),
	/* 0x90 */	(vl_print | vl_punct),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_print | vl_punct),
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_print | vl_punct),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_print | vl_punct),
	/* 0x9d */	(vl_print | vl_punct),
	/* 0x9e */	(vl_print | vl_punct),
	/* 0x9f */	(vl_print | vl_punct),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb4 */	(vl_print | vl_punct),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_print | vl_punct),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xca */	(vl_alpha | vl_lower | vl_print),
	/* 0xcb */	(vl_alpha | vl_lower | vl_print),
	/* 0xcc */	(vl_alpha | vl_lower | vl_print),
	/* 0xcd */	(vl_alpha | vl_lower | vl_print),
	/* 0xce */	(vl_alpha | vl_lower | vl_print),
	/* 0xcf */	(vl_alpha | vl_lower | vl_print),
	/* 0xd0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	(vl_alpha | vl_lower | vl_print),
	/* 0xdb */	(vl_alpha | vl_lower | vl_print),
	/* 0xdc */	(vl_alpha | vl_lower | vl_print),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_print | vl_upper),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_print | vl_upper),
	/* 0xf0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xfa */	(vl_alpha | vl_print | vl_upper),
	/* 0xfb */	(vl_alpha | vl_print | vl_upper),
	/* 0xfc */	(vl_alpha | vl_print | vl_upper),
	/* 0xfd */	(vl_alpha | vl_print | vl_upper),
	/* 0xfe */	(vl_alpha | vl_print | vl_upper),
	/* 0xff */	(vl_alpha | vl_print | vl_upper),
    },
};

/*  26:KOI8-T */
static const GNREIGHT_ENC encode_KOI8_T = {
    /* encode_KOI8_T.chmap */
    {
	 0x49b, 0x493,0x201a, 0x492,0x201e,0x2026,0x2020,0x2021,
	     0,0x2030, 0x4b3,0x2039, 0x4b2, 0x4b7, 0x4b6,     0,
	 0x49a,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	     0,0x2122,     0,0x203a,     0,     0,     0,     0,
	     0, 0x4ef, 0x4ee, 0x451,  0xa4, 0x4e3,  0xa6,  0xa7,
	     0,     0,     0,  0xab,  0xac,  0xad,  0xae,     0,
	  0xb0,  0xb1,  0xb2, 0x401,     0, 0x4e2,  0xb6,  0xb7,
	     0,0x2116,     0,  0xbb,     0,     0,     0,  0xa9,
	 0x44e, 0x430, 0x431, 0x446, 0x434, 0x435, 0x444, 0x433,
	 0x445, 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e,
	 0x43f, 0x44f, 0x440, 0x441, 0x442, 0x443, 0x436, 0x432,
	 0x44c, 0x44b, 0x437, 0x448, 0x44d, 0x449, 0x447, 0x44a,
	 0x42e, 0x410, 0x411, 0x426, 0x414, 0x415, 0x424, 0x413,
	 0x425, 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e,
	 0x41f, 0x42f, 0x420, 0x421, 0x422, 0x423, 0x416, 0x412,
	 0x42c, 0x42b, 0x417, 0x428, 0x42d, 0x429, 0x427, 0x42a
    },
    /* encode_KOI8_T.lower */
    {
	  0x80,  0x81,  0x82,  0x81,  0x84,  0x85,  0x86,  0x87,
	     0,  0x89,  0x8a,  0x8b,  0x8a,  0x8d,  0x8d,     0,
	  0x80,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,  0x99,     0,  0x9b,     0,     0,     0,     0,
	     0,  0xa1,  0xa1,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	     0,     0,     0,  0xab,  0xac,  0xad,  0xae,     0,
	  0xb0,  0xb1,  0xb2,  0xa3,     0,  0xa5,  0xb6,  0xb7,
	     0,  0xb9,     0,  0xbb,     0,     0,     0,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf
    },
    /* encode_KOI8_T.upper */
    {
	  0x90,  0x83,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	     0,  0x89,  0x8c,  0x8b,  0x8c,  0x8e,  0x8e,     0,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,  0x99,     0,  0x9b,     0,     0,     0,     0,
	     0,  0xa2,  0xa2,  0xb3,  0xa4,  0xb5,  0xa6,  0xa7,
	     0,     0,     0,  0xab,  0xac,  0xad,  0xae,     0,
	  0xb0,  0xb1,  0xb2,  0xb3,     0,  0xb5,  0xb6,  0xb7,
	     0,  0xb9,     0,  0xbb,     0,     0,     0,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_KOI8_T.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_lower | vl_print),
	/* 0x81 */	(vl_alpha | vl_lower | vl_print),
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_print | vl_upper),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	0,
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_alpha | vl_lower | vl_print),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_lower | vl_print),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	0,
	/* 0x90 */	(vl_alpha | vl_print | vl_upper),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	0,
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	0,
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	0,
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	0,
	/* 0xa0 */	0,
	/* 0xa1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	0,
	/* 0xa9 */	0,
	/* 0xaa */	0,
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	0,
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb4 */	0,
	/* 0xb5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	0,
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	0,
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	0,
	/* 0xbd */	0,
	/* 0xbe */	0,
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xca */	(vl_alpha | vl_lower | vl_print),
	/* 0xcb */	(vl_alpha | vl_lower | vl_print),
	/* 0xcc */	(vl_alpha | vl_lower | vl_print),
	/* 0xcd */	(vl_alpha | vl_lower | vl_print),
	/* 0xce */	(vl_alpha | vl_lower | vl_print),
	/* 0xcf */	(vl_alpha | vl_lower | vl_print),
	/* 0xd0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	(vl_alpha | vl_lower | vl_print),
	/* 0xdb */	(vl_alpha | vl_lower | vl_print),
	/* 0xdc */	(vl_alpha | vl_lower | vl_print),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_print | vl_upper),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_print | vl_upper),
	/* 0xf0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xfa */	(vl_alpha | vl_print | vl_upper),
	/* 0xfb */	(vl_alpha | vl_print | vl_upper),
	/* 0xfc */	(vl_alpha | vl_print | vl_upper),
	/* 0xfd */	(vl_alpha | vl_print | vl_upper),
	/* 0xfe */	(vl_alpha | vl_print | vl_upper),
	/* 0xff */	(vl_alpha | vl_print | vl_upper),
    },
};

/*  27:KOI8-U */
static const GNREIGHT_ENC encode_KOI8_U = {
    /* encode_KOI8_U.chmap */
    {
	0x2500,0x2502,0x250c,0x2510,0x2514,0x2518,0x251c,0x2524,
	0x252c,0x2534,0x253c,0x2580,0x2584,0x2588,0x258c,0x2590,
	0x2591,0x2592,0x2593,0x2320,0x25a0,0x2219,0x221a,0x2248,
	0x2264,0x2265,  0xa0,0x2321,  0xb0,  0xb2,  0xb7,  0xf7,
	0x2550,0x2551,0x2552, 0x451, 0x454,0x2554, 0x456, 0x457,
	0x2557,0x2558,0x2559,0x255a,0x255b, 0x491,0x255d,0x255e,
	0x255f,0x2560,0x2561, 0x401, 0x404,0x2563, 0x406, 0x407,
	0x2566,0x2567,0x2568,0x2569,0x256a, 0x490,0x256c,  0xa9,
	 0x44e, 0x430, 0x431, 0x446, 0x434, 0x435, 0x444, 0x433,
	 0x445, 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e,
	 0x43f, 0x44f, 0x440, 0x441, 0x442, 0x443, 0x436, 0x432,
	 0x44c, 0x44b, 0x437, 0x448, 0x44d, 0x449, 0x447, 0x44a,
	 0x42e, 0x410, 0x411, 0x426, 0x414, 0x415, 0x424, 0x413,
	 0x425, 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e,
	 0x41f, 0x42f, 0x420, 0x421, 0x422, 0x423, 0x416, 0x412,
	 0x42c, 0x42b, 0x417, 0x428, 0x42d, 0x429, 0x427, 0x42a
    },
    /* encode_KOI8_U.lower */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xa3,  0xa4,  0xb5,  0xa6,  0xa7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xad,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf
    },
    /* encode_KOI8_U.upper */
    {
	  0x80,  0x81,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	  0x98,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa1,  0xa2,  0xb3,  0xb4,  0xa5,  0xb6,  0xb7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xbd,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_KOI8_U.ctype */
    {
	/* 0x80 */	(vl_print | vl_punct),
	/* 0x81 */	(vl_print | vl_punct),
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_print | vl_punct),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_print | vl_punct),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_print | vl_punct),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_print | vl_punct),
	/* 0x8d */	(vl_print | vl_punct),
	/* 0x8e */	(vl_print | vl_punct),
	/* 0x8f */	(vl_print | vl_punct),
	/* 0x90 */	(vl_print | vl_punct),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	(vl_print | vl_punct),
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_print | vl_punct),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_print | vl_punct),
	/* 0x9d */	(vl_print | vl_punct),
	/* 0x9e */	(vl_print | vl_punct),
	/* 0x9f */	(vl_print | vl_punct),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_print | vl_punct),
	/* 0xa2 */	(vl_print | vl_punct),
	/* 0xa3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa5 */	(vl_print | vl_punct),
	/* 0xa6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa8 */	(vl_print | vl_punct),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_print | vl_punct),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_alpha | vl_lower | vl_print),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_print | vl_punct),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_print | vl_punct),
	/* 0xb3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb5 */	(vl_print | vl_punct),
	/* 0xb6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb8 */	(vl_print | vl_punct),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_print | vl_punct),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_print | vl_punct),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_print | vl_punct),
	/* 0xbf */	(vl_print | vl_punct),
	/* 0xc0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xc9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xca */	(vl_alpha | vl_lower | vl_print),
	/* 0xcb */	(vl_alpha | vl_lower | vl_print),
	/* 0xcc */	(vl_alpha | vl_lower | vl_print),
	/* 0xcd */	(vl_alpha | vl_lower | vl_print),
	/* 0xce */	(vl_alpha | vl_lower | vl_print),
	/* 0xcf */	(vl_alpha | vl_lower | vl_print),
	/* 0xd0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xd9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xda */	(vl_alpha | vl_lower | vl_print),
	/* 0xdb */	(vl_alpha | vl_lower | vl_print),
	/* 0xdc */	(vl_alpha | vl_lower | vl_print),
	/* 0xdd */	(vl_alpha | vl_lower | vl_print),
	/* 0xde */	(vl_alpha | vl_lower | vl_print),
	/* 0xdf */	(vl_alpha | vl_lower | vl_print),
	/* 0xe0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xe9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xea */	(vl_alpha | vl_print | vl_upper),
	/* 0xeb */	(vl_alpha | vl_print | vl_upper),
	/* 0xec */	(vl_alpha | vl_print | vl_upper),
	/* 0xed */	(vl_alpha | vl_print | vl_upper),
	/* 0xee */	(vl_alpha | vl_print | vl_upper),
	/* 0xef */	(vl_alpha | vl_print | vl_upper),
	/* 0xf0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xf9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xfa */	(vl_alpha | vl_print | vl_upper),
	/* 0xfb */	(vl_alpha | vl_print | vl_upper),
	/* 0xfc */	(vl_alpha | vl_print | vl_upper),
	/* 0xfd */	(vl_alpha | vl_print | vl_upper),
	/* 0xfe */	(vl_alpha | vl_print | vl_upper),
	/* 0xff */	(vl_alpha | vl_print | vl_upper),
    },
};

/*  28:RK1048 */
static const GNREIGHT_ENC encode_RK1048 = {
    /* encode_RK1048.chmap */
    {
	 0x402, 0x403,0x201a, 0x453,0x201e,0x2026,0x2020,0x2021,
	0x20ac,0x2030, 0x409,0x2039, 0x40a, 0x49a, 0x4ba, 0x40f,
	 0x452,0x2018,0x2019,0x201c,0x201d,0x2022,0x2013,0x2014,
	     0,0x2122, 0x459,0x203a, 0x45a, 0x49b, 0x4bb, 0x45f,
	  0xa0, 0x4b0, 0x4b1, 0x4d8,  0xa4, 0x4e8,  0xa6,  0xa7,
	 0x401,  0xa9, 0x492,  0xab,  0xac,  0xad,  0xae, 0x4ae,
	  0xb0,  0xb1, 0x406, 0x456, 0x4e9,  0xb5,  0xb6,  0xb7,
	 0x451,0x2116, 0x493,  0xbb, 0x4d9, 0x4a2, 0x4a3, 0x4af,
	 0x410, 0x411, 0x412, 0x413, 0x414, 0x415, 0x416, 0x417,
	 0x418, 0x419, 0x41a, 0x41b, 0x41c, 0x41d, 0x41e, 0x41f,
	 0x420, 0x421, 0x422, 0x423, 0x424, 0x425, 0x426, 0x427,
	 0x428, 0x429, 0x42a, 0x42b, 0x42c, 0x42d, 0x42e, 0x42f,
	 0x430, 0x431, 0x432, 0x433, 0x434, 0x435, 0x436, 0x437,
	 0x438, 0x439, 0x43a, 0x43b, 0x43c, 0x43d, 0x43e, 0x43f,
	 0x440, 0x441, 0x442, 0x443, 0x444, 0x445, 0x446, 0x447,
	 0x448, 0x449, 0x44a, 0x44b, 0x44c, 0x44d, 0x44e, 0x44f
    },
    /* encode_RK1048.lower */
    {
	  0x90,  0x83,  0x82,  0x83,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x9a,  0x8b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0x90,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,  0x99,  0x9a,  0x9b,  0x9c,  0x9d,  0x9e,  0x9f,
	  0xa0,  0xa2,  0xa2,  0xbc,  0xa4,  0xb4,  0xa6,  0xa7,
	  0xb8,  0xa9,  0xba,  0xab,  0xac,  0xad,  0xae,  0xbf,
	  0xb0,  0xb1,  0xb3,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbe,  0xbe,  0xbf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,  0xfc,  0xfd,  0xfe,  0xff
    },
    /* encode_RK1048.upper */
    {
	  0x80,  0x81,  0x82,  0x81,  0x84,  0x85,  0x86,  0x87,
	  0x88,  0x89,  0x8a,  0x8b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0x80,  0x91,  0x92,  0x93,  0x94,  0x95,  0x96,  0x97,
	     0,  0x99,  0x8a,  0x9b,  0x8c,  0x8d,  0x8e,  0x8f,
	  0xa0,  0xa1,  0xa1,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb2,  0xa5,  0xb5,  0xb6,  0xb7,
	  0xa8,  0xb9,  0xaa,  0xbb,  0xa3,  0xbd,  0xbd,  0xaf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,  0xdb,  0xdc,  0xdd,  0xde,  0xdf
    },
    /* encode_RK1048.ctype */
    {
	/* 0x80 */	(vl_alpha | vl_print | vl_upper),
	/* 0x81 */	(vl_alpha | vl_print | vl_upper),
	/* 0x82 */	(vl_print | vl_punct),
	/* 0x83 */	(vl_alpha | vl_lower | vl_print),
	/* 0x84 */	(vl_print | vl_punct),
	/* 0x85 */	(vl_print | vl_punct),
	/* 0x86 */	(vl_print | vl_punct),
	/* 0x87 */	(vl_print | vl_punct),
	/* 0x88 */	(vl_print | vl_punct),
	/* 0x89 */	(vl_print | vl_punct),
	/* 0x8a */	(vl_alpha | vl_print | vl_upper),
	/* 0x8b */	(vl_print | vl_punct),
	/* 0x8c */	(vl_alpha | vl_print | vl_upper),
	/* 0x8d */	(vl_alpha | vl_print | vl_upper),
	/* 0x8e */	(vl_alpha | vl_print | vl_upper),
	/* 0x8f */	(vl_alpha | vl_print | vl_upper),
	/* 0x90 */	(vl_alpha | vl_lower | vl_print),
	/* 0x91 */	(vl_print | vl_punct),
	/* 0x92 */	(vl_print | vl_punct),
	/* 0x93 */	(vl_print | vl_punct),
	/* 0x94 */	(vl_print | vl_punct),
	/* 0x95 */	(vl_print | vl_punct),
	/* 0x96 */	(vl_print | vl_punct),
	/* 0x97 */	(vl_print | vl_punct),
	/* 0x98 */	0,
	/* 0x99 */	(vl_print | vl_punct),
	/* 0x9a */	(vl_alpha | vl_lower | vl_print),
	/* 0x9b */	(vl_print | vl_punct),
	/* 0x9c */	(vl_alpha | vl_lower | vl_print),
	/* 0x9d */	(vl_alpha | vl_lower | vl_print),
	/* 0x9e */	(vl_alpha | vl_lower | vl_print),
	/* 0x9f */	(vl_alpha | vl_lower | vl_print),
	/* 0xa0 */	(vl_print | vl_punct),
	/* 0xa1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa4 */	(vl_print | vl_punct),
	/* 0xa5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa6 */	(vl_print | vl_punct),
	/* 0xa7 */	(vl_print | vl_punct),
	/* 0xa8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xa9 */	(vl_print | vl_punct),
	/* 0xaa */	(vl_alpha | vl_print | vl_upper),
	/* 0xab */	(vl_print | vl_punct),
	/* 0xac */	(vl_print | vl_punct),
	/* 0xad */	(vl_print | vl_punct),
	/* 0xae */	(vl_print | vl_punct),
	/* 0xaf */	(vl_alpha | vl_print | vl_upper),
	/* 0xb0 */	(vl_print | vl_punct),
	/* 0xb1 */	(vl_print | vl_punct),
	/* 0xb2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xb3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb6 */	(vl_print | vl_punct),
	/* 0xb7 */	(vl_print | vl_punct),
	/* 0xb8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xb9 */	(vl_print | vl_punct),
	/* 0xba */	(vl_alpha | vl_lower | vl_print),
	/* 0xbb */	(vl_print | vl_punct),
	/* 0xbc */	(vl_alpha | vl_lower | vl_print),
	/* 0xbd */	(vl_alpha | vl_print | vl_upper),
	/* 0xbe */	(vl_alpha | vl_lower | vl_print),
	/* 0xbf */	(vl_alpha | vl_lower | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xc9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xca */	(vl_alpha | vl_print | vl_upper),
	/* 0xcb */	(vl_alpha | vl_print | vl_upper),
	/* 0xcc */	(vl_alpha | vl_print | vl_upper),
	/* 0xcd */	(vl_alpha | vl_print | vl_upper),
	/* 0xce */	(vl_alpha | vl_print | vl_upper),
	/* 0xcf */	(vl_alpha | vl_print | vl_upper),
	/* 0xd0 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd1 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd2 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd3 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd4 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd5 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd6 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd7 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd8 */	(vl_alpha | vl_print | vl_upper),
	/* 0xd9 */	(vl_alpha | vl_print | vl_upper),
	/* 0xda */	(vl_alpha | vl_print | vl_upper),
	/* 0xdb */	(vl_alpha | vl_print | vl_upper),
	/* 0xdc */	(vl_alpha | vl_print | vl_upper),
	/* 0xdd */	(vl_alpha | vl_print | vl_upper),
	/* 0xde */	(vl_alpha | vl_print | vl_upper),
	/* 0xdf */	(vl_alpha | vl_print | vl_upper),
	/* 0xe0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xe9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xea */	(vl_alpha | vl_lower | vl_print),
	/* 0xeb */	(vl_alpha | vl_lower | vl_print),
	/* 0xec */	(vl_alpha | vl_lower | vl_print),
	/* 0xed */	(vl_alpha | vl_lower | vl_print),
	/* 0xee */	(vl_alpha | vl_lower | vl_print),
	/* 0xef */	(vl_alpha | vl_lower | vl_print),
	/* 0xf0 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf1 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf2 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf3 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf4 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf5 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf6 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf7 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf8 */	(vl_alpha | vl_lower | vl_print),
	/* 0xf9 */	(vl_alpha | vl_lower | vl_print),
	/* 0xfa */	(vl_alpha | vl_lower | vl_print),
	/* 0xfb */	(vl_alpha | vl_lower | vl_print),
	/* 0xfc */	(vl_alpha | vl_lower | vl_print),
	/* 0xfd */	(vl_alpha | vl_lower | vl_print),
	/* 0xfe */	(vl_alpha | vl_lower | vl_print),
	/* 0xff */	(vl_alpha | vl_lower | vl_print),
    },
};

/*  30:TIS-620 */
static const GNREIGHT_ENC encode_TIS_620 = {
    /* encode_TIS_620.chmap */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0, 0xe01, 0xe02, 0xe03, 0xe04, 0xe05, 0xe06, 0xe07,
	 0xe08, 0xe09, 0xe0a, 0xe0b, 0xe0c, 0xe0d, 0xe0e, 0xe0f,
	 0xe10, 0xe11, 0xe12, 0xe13, 0xe14, 0xe15, 0xe16, 0xe17,
	 0xe18, 0xe19, 0xe1a, 0xe1b, 0xe1c, 0xe1d, 0xe1e, 0xe1f,
	 0xe20, 0xe21, 0xe22, 0xe23, 0xe24, 0xe25, 0xe26, 0xe27,
	 0xe28, 0xe29, 0xe2a, 0xe2b, 0xe2c, 0xe2d, 0xe2e, 0xe2f,
	 0xe30, 0xe31, 0xe32, 0xe33, 0xe34, 0xe35, 0xe36, 0xe37,
	 0xe38, 0xe39, 0xe3a,     0,     0,     0,     0, 0xe3f,
	 0xe40, 0xe41, 0xe42, 0xe43, 0xe44, 0xe45, 0xe46, 0xe47,
	 0xe48, 0xe49, 0xe4a, 0xe4b, 0xe4c, 0xe4d, 0xe4e, 0xe4f,
	 0xe50, 0xe51, 0xe52, 0xe53, 0xe54, 0xe55, 0xe56, 0xe57,
	 0xe58, 0xe59, 0xe5a, 0xe5b,     0,     0,     0,     0
    },
    /* encode_TIS_620.lower */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,     0,     0,     0,     0,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,     0,     0,     0,     0
    },
    /* encode_TIS_620.upper */
    {
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,     0,     0,     0,     0,     0,     0,     0,
	     0,  0xa1,  0xa2,  0xa3,  0xa4,  0xa5,  0xa6,  0xa7,
	  0xa8,  0xa9,  0xaa,  0xab,  0xac,  0xad,  0xae,  0xaf,
	  0xb0,  0xb1,  0xb2,  0xb3,  0xb4,  0xb5,  0xb6,  0xb7,
	  0xb8,  0xb9,  0xba,  0xbb,  0xbc,  0xbd,  0xbe,  0xbf,
	  0xc0,  0xc1,  0xc2,  0xc3,  0xc4,  0xc5,  0xc6,  0xc7,
	  0xc8,  0xc9,  0xca,  0xcb,  0xcc,  0xcd,  0xce,  0xcf,
	  0xd0,  0xd1,  0xd2,  0xd3,  0xd4,  0xd5,  0xd6,  0xd7,
	  0xd8,  0xd9,  0xda,     0,     0,     0,     0,  0xdf,
	  0xe0,  0xe1,  0xe2,  0xe3,  0xe4,  0xe5,  0xe6,  0xe7,
	  0xe8,  0xe9,  0xea,  0xeb,  0xec,  0xed,  0xee,  0xef,
	  0xf0,  0xf1,  0xf2,  0xf3,  0xf4,  0xf5,  0xf6,  0xf7,
	  0xf8,  0xf9,  0xfa,  0xfb,     0,     0,     0,     0
    },
    /* encode_TIS_620.ctype */
    {
	/* 0x80 */	0,
	/* 0x81 */	0,
	/* 0x82 */	0,
	/* 0x83 */	0,
	/* 0x84 */	0,
	/* 0x85 */	0,
	/* 0x86 */	0,
	/* 0x87 */	0,
	/* 0x88 */	0,
	/* 0x89 */	0,
	/* 0x8a */	0,
	/* 0x8b */	0,
	/* 0x8c */	0,
	/* 0x8d */	0,
	/* 0x8e */	0,
	/* 0x8f */	0,
	/* 0x90 */	0,
	/* 0x91 */	0,
	/* 0x92 */	0,
	/* 0x93 */	0,
	/* 0x94 */	0,
	/* 0x95 */	0,
	/* 0x96 */	0,
	/* 0x97 */	0,
	/* 0x98 */	0,
	/* 0x99 */	0,
	/* 0x9a */	0,
	/* 0x9b */	0,
	/* 0x9c */	0,
	/* 0x9d */	0,
	/* 0x9e */	0,
	/* 0x9f */	0,
	/* 0xa0 */	0,
	/* 0xa1 */	(vl_alpha | vl_print),
	/* 0xa2 */	(vl_alpha | vl_print),
	/* 0xa3 */	(vl_alpha | vl_print),
	/* 0xa4 */	(vl_alpha | vl_print),
	/* 0xa5 */	(vl_alpha | vl_print),
	/* 0xa6 */	(vl_alpha | vl_print),
	/* 0xa7 */	(vl_alpha | vl_print),
	/* 0xa8 */	(vl_alpha | vl_print),
	/* 0xa9 */	(vl_alpha | vl_print),
	/* 0xaa */	(vl_alpha | vl_print),
	/* 0xab */	(vl_alpha | vl_print),
	/* 0xac */	(vl_alpha | vl_print),
	/* 0xad */	(vl_alpha | vl_print),
	/* 0xae */	(vl_alpha | vl_print),
	/* 0xaf */	(vl_alpha | vl_print),
	/* 0xb0 */	(vl_alpha | vl_print),
	/* 0xb1 */	(vl_alpha | vl_print),
	/* 0xb2 */	(vl_alpha | vl_print),
	/* 0xb3 */	(vl_alpha | vl_print),
	/* 0xb4 */	(vl_alpha | vl_print),
	/* 0xb5 */	(vl_alpha | vl_print),
	/* 0xb6 */	(vl_alpha | vl_print),
	/* 0xb7 */	(vl_alpha | vl_print),
	/* 0xb8 */	(vl_alpha | vl_print),
	/* 0xb9 */	(vl_alpha | vl_print),
	/* 0xba */	(vl_alpha | vl_print),
	/* 0xbb */	(vl_alpha | vl_print),
	/* 0xbc */	(vl_alpha | vl_print),
	/* 0xbd */	(vl_alpha | vl_print),
	/* 0xbe */	(vl_alpha | vl_print),
	/* 0xbf */	(vl_alpha | vl_print),
	/* 0xc0 */	(vl_alpha | vl_print),
	/* 0xc1 */	(vl_alpha | vl_print),
	/* 0xc2 */	(vl_alpha | vl_print),
	/* 0xc3 */	(vl_alpha | vl_print),
	/* 0xc4 */	(vl_alpha | vl_print),
	/* 0xc5 */	(vl_alpha | vl_print),
	/* 0xc6 */	(vl_alpha | vl_print),
	/* 0xc7 */	(vl_alpha | vl_print),
	/* 0xc8 */	(vl_alpha | vl_print),
	/* 0xc9 */	(vl_alpha | vl_print),
	/* 0xca */	(vl_alpha | vl_print),
	/* 0xcb */	(vl_alpha | vl_print),
	/* 0xcc */	(vl_alpha | vl_print),
	/* 0xcd */	(vl_alpha | vl_print),
	/* 0xce */	(vl_alpha | vl_print),
	/* 0xcf */	(vl_print | vl_punct),
	/* 0xd0 */	(vl_alpha | vl_print),
	/* 0xd1 */	(vl_alpha | vl_print),
	/* 0xd2 */	(vl_alpha | vl_print),
	/* 0xd3 */	(vl_alpha | vl_print),
	/* 0xd4 */	(vl_alpha | vl_print),
	/* 0xd5 */	(vl_alpha | vl_print),
	/* 0xd6 */	(vl_alpha | vl_print),
	/* 0xd7 */	(vl_alpha | vl_print),
	/* 0xd8 */	(vl_alpha | vl_print),
	/* 0xd9 */	(vl_alpha | vl_print),
	/* 0xda */	(vl_alpha | vl_print),
	/* 0xdb */	0,
	/* 0xdc */	0,
	/* 0xdd */	0,
	/* 0xde */	0,
	/* 0xdf */	(vl_print | vl_punct),
	/* 0xe0 */	(vl_alpha | vl_print),
	/* 0xe1 */	(vl_alpha | vl_print),
	/* 0xe2 */	(vl_alpha | vl_print),
	/* 0xe3 */	(vl_alpha | vl_print),
	/* 0xe4 */	(vl_alpha | vl_print),
	/* 0xe5 */	(vl_alpha | vl_print),
	/* 0xe6 */	(vl_print | vl_punct),
	/* 0xe7 */	(vl_alpha | vl_print),
	/* 0xe8 */	(vl_alpha | vl_print),
	/* 0xe9 */	(vl_alpha | vl_print),
	/* 0xea */	(vl_alpha | vl_print),
	/* 0xeb */	(vl_alpha | vl_print),
	/* 0xec */	(vl_alpha | vl_print),
	/* 0xed */	(vl_alpha | vl_print),
	/* 0xee */	(vl_alpha | vl_print),
	/* 0xef */	(vl_print | vl_punct),
	/* 0xf0 */	(vl_alpha | vl_print),
	/* 0xf1 */	(vl_alpha | vl_print),
	/* 0xf2 */	(vl_alpha | vl_print),
	/* 0xf3 */	(vl_alpha | vl_print),
	/* 0xf4 */	(vl_alpha | vl_print),
	/* 0xf5 */	(vl_alpha | vl_print),
	/* 0xf6 */	(vl_alpha | vl_print),
	/* 0xf7 */	(vl_alpha | vl_print),
	/* 0xf8 */	(vl_alpha | vl_print),
	/* 0xf9 */	(vl_alpha | vl_print),
	/* 0xfa */	(vl_print | vl_punct),
	/* 0xfb */	(vl_print | vl_punct),
	/* 0xfc */	0,
	/* 0xfd */	0,
	/* 0xfe */	0,
	/* 0xff */	0,
    },
};

/* Sorted encodings */
static const GNREIGHT_INX all_encodings[] = {
    { "ANSI_X3.4-1968",              &encode_ANSI_X3_4_1968 },
    { "ARMSCII-8",                   &encode_ARMSCII_8 },
    { "BIG5",                        &encode_BIG5 },
    { "BIG5-HKSCS",                  &encode_BIG5_HKSCS },
    { "CP1251",                      &encode_CP1251 },
    { "CP1255",                      &encode_CP1255 },
    { "EUC-JP",                      &encode_EUC_JP },
    { "EUC-KR",                      &encode_EUC_KR },
    { "EUC-TW",                      &encode_EUC_TW },
    { "GB18030",                     &encode_GB18030 },
    { "GB2312",                      &encode_GB2312 },
    { "GBK",                         &encode_GBK },
    { "GEORGIAN-PS",                 &encode_GEORGIAN_PS },
    { "ISO-8859-1",                  &encode_ISO_8859_1 },
    { "ISO-8859-10",                 &encode_ISO_8859_10 },
    { "ISO-8859-13",                 &encode_ISO_8859_13 },
    { "ISO-8859-14",                 &encode_ISO_8859_14 },
    { "ISO-8859-15",                 &encode_ISO_8859_15 },
    { "ISO-8859-2",                  &encode_ISO_8859_2 },
    { "ISO-8859-3",                  &encode_ISO_8859_3 },
    { "ISO-8859-5",                  &encode_ISO_8859_5 },
    { "ISO-8859-6",                  &encode_ISO_8859_6 },
    { "ISO-8859-7",                  &encode_ISO_8859_7 },
    { "ISO-8859-8",                  &encode_ISO_8859_8 },
    { "ISO-8859-9",                  &encode_ISO_8859_9 },
    { "KOI8-R",                      &encode_KOI8_R },
    { "KOI8-T",                      &encode_KOI8_T },
    { "KOI8-U",                      &encode_KOI8_U },
    { "RK1048",                      &encode_RK1048 },
    { "TIS-620",                     &encode_TIS_620 },
    { 0, 0 }
};

/* Sorted aliases */
static const GNREIGHT_INX all_locales[] = {
    { "C",                           &encode_ANSI_X3_4_1968 },
    { "POSIX",                       &encode_ANSI_X3_4_1968 },
    { "aa_DJ",                       &encode_ISO_8859_1 },
    { "aa_DJ.iso88591",              &encode_ISO_8859_1 },
    { "af_ZA",                       &encode_ISO_8859_1 },
    { "af_ZA.iso88591",              &encode_ISO_8859_1 },
    { "an_ES",                       &encode_ISO_8859_15 },
    { "an_ES.iso885915",             &encode_ISO_8859_15 },
    { "ar_AE",                       &encode_ISO_8859_6 },
    { "ar_AE.iso88596",              &encode_ISO_8859_6 },
    { "ar_BH",                       &encode_ISO_8859_6 },
    { "ar_BH.iso88596",              &encode_ISO_8859_6 },
    { "ar_DZ",                       &encode_ISO_8859_6 },
    { "ar_DZ.iso88596",              &encode_ISO_8859_6 },
    { "ar_EG",                       &encode_ISO_8859_6 },
    { "ar_EG.iso88596",              &encode_ISO_8859_6 },
    { "ar_IQ",                       &encode_ISO_8859_6 },
    { "ar_IQ.iso88596",              &encode_ISO_8859_6 },
    { "ar_JO",                       &encode_ISO_8859_6 },
    { "ar_JO.iso88596",              &encode_ISO_8859_6 },
    { "ar_KW",                       &encode_ISO_8859_6 },
    { "ar_KW.iso88596",              &encode_ISO_8859_6 },
    { "ar_LB",                       &encode_ISO_8859_6 },
    { "ar_LB.iso88596",              &encode_ISO_8859_6 },
    { "ar_LY",                       &encode_ISO_8859_6 },
    { "ar_LY.iso88596",              &encode_ISO_8859_6 },
    { "ar_MA",                       &encode_ISO_8859_6 },
    { "ar_MA.iso88596",              &encode_ISO_8859_6 },
    { "ar_OM",                       &encode_ISO_8859_6 },
    { "ar_OM.iso88596",              &encode_ISO_8859_6 },
    { "ar_QA",                       &encode_ISO_8859_6 },
    { "ar_QA.iso88596",              &encode_ISO_8859_6 },
    { "ar_SA",                       &encode_ISO_8859_6 },
    { "ar_SA.iso88596",              &encode_ISO_8859_6 },
    { "ar_SD",                       &encode_ISO_8859_6 },
    { "ar_SD.iso88596",              &encode_ISO_8859_6 },
    { "ar_SY",                       &encode_ISO_8859_6 },
    { "ar_SY.iso88596",              &encode_ISO_8859_6 },
    { "ar_TN",                       &encode_ISO_8859_6 },
    { "ar_TN.iso88596",              &encode_ISO_8859_6 },
    { "ar_YE",                       &encode_ISO_8859_6 },
    { "ar_YE.iso88596",              &encode_ISO_8859_6 },
    { "ast_ES",                      &encode_ISO_8859_15 },
    { "ast_ES.iso885915",            &encode_ISO_8859_15 },
    { "be_BY",                       &encode_CP1251 },
    { "be_BY.cp1251",                &encode_CP1251 },
    { "bg_BG",                       &encode_CP1251 },
    { "bg_BG.cp1251",                &encode_CP1251 },
    { "bokmal",                      &encode_ISO_8859_1 },
    { "bokm\303\245l",               &encode_ISO_8859_1 },
    { "br_FR",                       &encode_ISO_8859_1 },
    { "br_FR.iso88591",              &encode_ISO_8859_1 },
    { "br_FR.iso885915@euro",        &encode_ISO_8859_15 },
    { "br_FR@euro",                  &encode_ISO_8859_15 },
    { "bs_BA",                       &encode_ISO_8859_2 },
    { "bs_BA.iso88592",              &encode_ISO_8859_2 },
    { "ca_AD",                       &encode_ISO_8859_15 },
    { "ca_AD.iso885915",             &encode_ISO_8859_15 },
    { "ca_ES",                       &encode_ISO_8859_1 },
    { "ca_ES.iso88591",              &encode_ISO_8859_1 },
    { "ca_ES.iso885915@euro",        &encode_ISO_8859_15 },
    { "ca_ES.iso885915@valencia",    &encode_ISO_8859_15 },
    { "ca_ES@euro",                  &encode_ISO_8859_15 },
    { "ca_ES@valencia",              &encode_ISO_8859_15 },
    { "ca_FR",                       &encode_ISO_8859_15 },
    { "ca_FR.iso885915",             &encode_ISO_8859_15 },
    { "ca_IT",                       &encode_ISO_8859_15 },
    { "ca_IT.iso885915",             &encode_ISO_8859_15 },
    { "catalan",                     &encode_ISO_8859_1 },
    { "croatian",                    &encode_ISO_8859_2 },
    { "cs_CZ",                       &encode_ISO_8859_2 },
    { "cs_CZ.iso88592",              &encode_ISO_8859_2 },
    { "cy_GB",                       &encode_ISO_8859_14 },
    { "cy_GB.iso885914",             &encode_ISO_8859_14 },
    { "czech",                       &encode_ISO_8859_2 },
    { "da_DK",                       &encode_ISO_8859_1 },
    { "da_DK.iso88591",              &encode_ISO_8859_1 },
    { "danish",                      &encode_ISO_8859_1 },
    { "dansk",                       &encode_ISO_8859_1 },
    { "de_AT",                       &encode_ISO_8859_1 },
    { "de_AT.iso88591",              &encode_ISO_8859_1 },
    { "de_AT.iso885915@euro",        &encode_ISO_8859_15 },
    { "de_AT@euro",                  &encode_ISO_8859_15 },
    { "de_BE",                       &encode_ISO_8859_1 },
    { "de_BE.iso88591",              &encode_ISO_8859_1 },
    { "de_BE.iso885915@euro",        &encode_ISO_8859_15 },
    { "de_BE@euro",                  &encode_ISO_8859_15 },
    { "de_CH",                       &encode_ISO_8859_1 },
    { "de_CH.iso88591",              &encode_ISO_8859_1 },
    { "de_DE",                       &encode_ISO_8859_1 },
    { "de_DE.iso88591",              &encode_ISO_8859_1 },
    { "de_DE.iso885915@euro",        &encode_ISO_8859_15 },
    { "de_DE@euro",                  &encode_ISO_8859_15 },
    { "de_LU",                       &encode_ISO_8859_1 },
    { "de_LU.iso88591",              &encode_ISO_8859_1 },
    { "de_LU.iso885915@euro",        &encode_ISO_8859_15 },
    { "de_LU@euro",                  &encode_ISO_8859_15 },
    { "deutsch",                     &encode_ISO_8859_1 },
    { "dutch",                       &encode_ISO_8859_1 },
    { "eesti",                       &encode_ISO_8859_15 },
    { "el_CY",                       &encode_ISO_8859_7 },
    { "el_CY.iso88597",              &encode_ISO_8859_7 },
    { "el_GR",                       &encode_ISO_8859_7 },
    { "el_GR.iso88597",              &encode_ISO_8859_7 },
    { "en_AU",                       &encode_ISO_8859_1 },
    { "en_AU.iso88591",              &encode_ISO_8859_1 },
    { "en_BW",                       &encode_ISO_8859_1 },
    { "en_BW.iso88591",              &encode_ISO_8859_1 },
    { "en_CA",                       &encode_ISO_8859_1 },
    { "en_CA.iso88591",              &encode_ISO_8859_1 },
    { "en_DK",                       &encode_ISO_8859_1 },
    { "en_DK.iso88591",              &encode_ISO_8859_1 },
    { "en_DK.iso885915",             &encode_ISO_8859_15 },
    { "en_GB",                       &encode_ISO_8859_1 },
    { "en_GB.iso88591",              &encode_ISO_8859_1 },
    { "en_GB.iso885915",             &encode_ISO_8859_15 },
    { "en_HK",                       &encode_ISO_8859_1 },
    { "en_HK.iso88591",              &encode_ISO_8859_1 },
    { "en_IE",                       &encode_ISO_8859_1 },
    { "en_IE.iso88591",              &encode_ISO_8859_1 },
    { "en_IE.iso885915@euro",        &encode_ISO_8859_15 },
    { "en_IE@euro",                  &encode_ISO_8859_15 },
    { "en_NZ",                       &encode_ISO_8859_1 },
    { "en_NZ.iso88591",              &encode_ISO_8859_1 },
    { "en_PH",                       &encode_ISO_8859_1 },
    { "en_PH.iso88591",              &encode_ISO_8859_1 },
    { "en_SG",                       &encode_ISO_8859_1 },
    { "en_SG.iso88591",              &encode_ISO_8859_1 },
    { "en_US",                       &encode_ISO_8859_1 },
    { "en_US.iso88591",              &encode_ISO_8859_1 },
    { "en_US.iso885915",             &encode_ISO_8859_15 },
    { "en_ZA",                       &encode_ISO_8859_1 },
    { "en_ZA.iso88591",              &encode_ISO_8859_1 },
    { "en_ZW",                       &encode_ISO_8859_1 },
    { "en_ZW.iso88591",              &encode_ISO_8859_1 },
    { "eo",                          &encode_ISO_8859_3 },
    { "eo.iso88593",                 &encode_ISO_8859_3 },
    { "es_AR",                       &encode_ISO_8859_1 },
    { "es_AR.iso88591",              &encode_ISO_8859_1 },
    { "es_BO",                       &encode_ISO_8859_1 },
    { "es_BO.iso88591",              &encode_ISO_8859_1 },
    { "es_CL",                       &encode_ISO_8859_1 },
    { "es_CL.iso88591",              &encode_ISO_8859_1 },
    { "es_CO",                       &encode_ISO_8859_1 },
    { "es_CO.iso88591",              &encode_ISO_8859_1 },
    { "es_CR",                       &encode_ISO_8859_1 },
    { "es_CR.iso88591",              &encode_ISO_8859_1 },
    { "es_DO",                       &encode_ISO_8859_1 },
    { "es_DO.iso88591",              &encode_ISO_8859_1 },
    { "es_EC",                       &encode_ISO_8859_1 },
    { "es_EC.iso88591",              &encode_ISO_8859_1 },
    { "es_ES",                       &encode_ISO_8859_1 },
    { "es_ES.iso88591",              &encode_ISO_8859_1 },
    { "es_ES.iso885915@euro",        &encode_ISO_8859_15 },
    { "es_ES@euro",                  &encode_ISO_8859_15 },
    { "es_GT",                       &encode_ISO_8859_1 },
    { "es_GT.iso88591",              &encode_ISO_8859_1 },
    { "es_HN",                       &encode_ISO_8859_1 },
    { "es_HN.iso88591",              &encode_ISO_8859_1 },
    { "es_MX",                       &encode_ISO_8859_1 },
    { "es_MX.iso88591",              &encode_ISO_8859_1 },
    { "es_NI",                       &encode_ISO_8859_1 },
    { "es_NI.iso88591",              &encode_ISO_8859_1 },
    { "es_PA",                       &encode_ISO_8859_1 },
    { "es_PA.iso88591",              &encode_ISO_8859_1 },
    { "es_PE",                       &encode_ISO_8859_1 },
    { "es_PE.iso88591",              &encode_ISO_8859_1 },
    { "es_PR",                       &encode_ISO_8859_1 },
    { "es_PR.iso88591",              &encode_ISO_8859_1 },
    { "es_PY",                       &encode_ISO_8859_1 },
    { "es_PY.iso88591",              &encode_ISO_8859_1 },
    { "es_SV",                       &encode_ISO_8859_1 },
    { "es_SV.iso88591",              &encode_ISO_8859_1 },
    { "es_US",                       &encode_ISO_8859_1 },
    { "es_US.iso88591",              &encode_ISO_8859_1 },
    { "es_UY",                       &encode_ISO_8859_1 },
    { "es_UY.iso88591",              &encode_ISO_8859_1 },
    { "es_VE",                       &encode_ISO_8859_1 },
    { "es_VE.iso88591",              &encode_ISO_8859_1 },
    { "estonian",                    &encode_ISO_8859_15 },
    { "et_EE",                       &encode_ISO_8859_1 },
    { "et_EE.iso88591",              &encode_ISO_8859_1 },
    { "et_EE.iso885915",             &encode_ISO_8859_15 },
    { "eu_ES",                       &encode_ISO_8859_1 },
    { "eu_ES.iso88591",              &encode_ISO_8859_1 },
    { "eu_ES.iso885915@euro",        &encode_ISO_8859_15 },
    { "eu_ES@euro",                  &encode_ISO_8859_15 },
    { "eu_FR",                       &encode_ISO_8859_1 },
    { "eu_FR.iso88591",              &encode_ISO_8859_1 },
    { "eu_FR.iso885915@euro",        &encode_ISO_8859_15 },
    { "eu_FR@euro",                  &encode_ISO_8859_15 },
    { "fi_FI",                       &encode_ISO_8859_1 },
    { "fi_FI.iso88591",              &encode_ISO_8859_1 },
    { "fi_FI.iso885915@euro",        &encode_ISO_8859_15 },
    { "fi_FI@euro",                  &encode_ISO_8859_15 },
    { "finnish",                     &encode_ISO_8859_1 },
    { "fo_FO",                       &encode_ISO_8859_1 },
    { "fo_FO.iso88591",              &encode_ISO_8859_1 },
    { "fr_BE",                       &encode_ISO_8859_1 },
    { "fr_BE.iso88591",              &encode_ISO_8859_1 },
    { "fr_BE.iso885915@euro",        &encode_ISO_8859_15 },
    { "fr_BE@euro",                  &encode_ISO_8859_15 },
    { "fr_CA",                       &encode_ISO_8859_1 },
    { "fr_CA.iso88591",              &encode_ISO_8859_1 },
    { "fr_CH",                       &encode_ISO_8859_1 },
    { "fr_CH.iso88591",              &encode_ISO_8859_1 },
    { "fr_FR",                       &encode_ISO_8859_1 },
    { "fr_FR.iso88591",              &encode_ISO_8859_1 },
    { "fr_FR.iso885915@euro",        &encode_ISO_8859_15 },
    { "fr_FR@euro",                  &encode_ISO_8859_15 },
    { "fr_LU",                       &encode_ISO_8859_1 },
    { "fr_LU.iso88591",              &encode_ISO_8859_1 },
    { "fr_LU.iso885915@euro",        &encode_ISO_8859_15 },
    { "fr_LU@euro",                  &encode_ISO_8859_15 },
    { "fran\303\247ais",             &encode_ISO_8859_1 },
    { "french",                      &encode_ISO_8859_1 },
    { "ga_IE",                       &encode_ISO_8859_1 },
    { "ga_IE.iso88591",              &encode_ISO_8859_1 },
    { "ga_IE.iso885915@euro",        &encode_ISO_8859_15 },
    { "ga_IE@euro",                  &encode_ISO_8859_15 },
    { "galego",                      &encode_ISO_8859_1 },
    { "galician",                    &encode_ISO_8859_1 },
    { "gd_GB",                       &encode_ISO_8859_15 },
    { "gd_GB.iso885915",             &encode_ISO_8859_15 },
    { "german",                      &encode_ISO_8859_1 },
    { "gl_ES",                       &encode_ISO_8859_1 },
    { "gl_ES.iso88591",              &encode_ISO_8859_1 },
    { "gl_ES.iso885915@euro",        &encode_ISO_8859_15 },
    { "gl_ES@euro",                  &encode_ISO_8859_15 },
    { "greek",                       &encode_ISO_8859_7 },
    { "gv_GB",                       &encode_ISO_8859_1 },
    { "gv_GB.iso88591",              &encode_ISO_8859_1 },
    { "he_IL",                       &encode_ISO_8859_8 },
    { "he_IL.iso88598",              &encode_ISO_8859_8 },
    { "hebrew",                      &encode_ISO_8859_8 },
    { "hr_HR",                       &encode_ISO_8859_2 },
    { "hr_HR.iso88592",              &encode_ISO_8859_2 },
    { "hrvatski",                    &encode_ISO_8859_2 },
    { "hsb_DE",                      &encode_ISO_8859_2 },
    { "hsb_DE.iso88592",             &encode_ISO_8859_2 },
    { "hu_HU",                       &encode_ISO_8859_2 },
    { "hu_HU.iso88592",              &encode_ISO_8859_2 },
    { "hungarian",                   &encode_ISO_8859_2 },
    { "hy_AM.armscii8",              &encode_ARMSCII_8 },
    { "icelandic",                   &encode_ISO_8859_1 },
    { "id_ID",                       &encode_ISO_8859_1 },
    { "id_ID.iso88591",              &encode_ISO_8859_1 },
    { "is_IS",                       &encode_ISO_8859_1 },
    { "is_IS.iso88591",              &encode_ISO_8859_1 },
    { "it_CH",                       &encode_ISO_8859_1 },
    { "it_CH.iso88591",              &encode_ISO_8859_1 },
    { "it_IT",                       &encode_ISO_8859_1 },
    { "it_IT.iso88591",              &encode_ISO_8859_1 },
    { "it_IT.iso885915@euro",        &encode_ISO_8859_15 },
    { "it_IT@euro",                  &encode_ISO_8859_15 },
    { "italian",                     &encode_ISO_8859_1 },
    { "iw_IL",                       &encode_ISO_8859_8 },
    { "iw_IL.iso88598",              &encode_ISO_8859_8 },
    { "ja_JP",                       &encode_EUC_JP },
    { "ja_JP.eucjp",                 &encode_EUC_JP },
    { "ja_JP.ujis",                  &encode_EUC_JP },
    { "japanese",                    &encode_EUC_JP },
    { "japanese.euc",                &encode_EUC_JP },
    { "ka_GE",                       &encode_GEORGIAN_PS },
    { "ka_GE.georgianps",            &encode_GEORGIAN_PS },
    { "kk_KZ",                       &encode_RK1048 },
    { "kk_KZ.pt154",                 &encode_RK1048 },
    { "kk_KZ.rk1048",                &encode_RK1048 },
    { "kl_GL",                       &encode_ISO_8859_1 },
    { "kl_GL.iso88591",              &encode_ISO_8859_1 },
    { "ko_KR",                       &encode_EUC_KR },
    { "ko_KR.euckr",                 &encode_EUC_KR },
    { "korean",                      &encode_EUC_KR },
    { "korean.euc",                  &encode_EUC_KR },
    { "ku_TR",                       &encode_ISO_8859_9 },
    { "ku_TR.iso88599",              &encode_ISO_8859_9 },
    { "kw_GB",                       &encode_ISO_8859_1 },
    { "kw_GB.iso88591",              &encode_ISO_8859_1 },
    { "lg_UG",                       &encode_ISO_8859_10 },
    { "lg_UG.iso885910",             &encode_ISO_8859_10 },
    { "lithuanian",                  &encode_ISO_8859_13 },
    { "lt_LT",                       &encode_ISO_8859_13 },
    { "lt_LT.iso885913",             &encode_ISO_8859_13 },
    { "lv_LV",                       &encode_ISO_8859_13 },
    { "lv_LV.iso885913",             &encode_ISO_8859_13 },
    { "mg_MG",                       &encode_ISO_8859_15 },
    { "mg_MG.iso885915",             &encode_ISO_8859_15 },
    { "mi_NZ",                       &encode_ISO_8859_13 },
    { "mi_NZ.iso885913",             &encode_ISO_8859_13 },
    { "mk_MK",                       &encode_ISO_8859_5 },
    { "mk_MK.iso88595",              &encode_ISO_8859_5 },
    { "ms_MY",                       &encode_ISO_8859_1 },
    { "ms_MY.iso88591",              &encode_ISO_8859_1 },
    { "mt_MT",                       &encode_ISO_8859_3 },
    { "mt_MT.iso88593",              &encode_ISO_8859_3 },
    { "nb_NO",                       &encode_ISO_8859_1 },
    { "nb_NO.iso88591",              &encode_ISO_8859_1 },
    { "nl_BE",                       &encode_ISO_8859_1 },
    { "nl_BE.iso88591",              &encode_ISO_8859_1 },
    { "nl_BE.iso885915@euro",        &encode_ISO_8859_15 },
    { "nl_BE@euro",                  &encode_ISO_8859_15 },
    { "nl_NL",                       &encode_ISO_8859_1 },
    { "nl_NL.iso88591",              &encode_ISO_8859_1 },
    { "nl_NL.iso885915@euro",        &encode_ISO_8859_15 },
    { "nl_NL@euro",                  &encode_ISO_8859_15 },
    { "nn_NO",                       &encode_ISO_8859_1 },
    { "nn_NO.iso88591",              &encode_ISO_8859_1 },
    { "no_NO",                       &encode_ISO_8859_1 },
    { "norwegian",                   &encode_ISO_8859_1 },
    { "nynorsk",                     &encode_ISO_8859_1 },
    { "oc_FR",                       &encode_ISO_8859_1 },
    { "oc_FR.iso88591",              &encode_ISO_8859_1 },
    { "om_KE",                       &encode_ISO_8859_1 },
    { "om_KE.iso88591",              &encode_ISO_8859_1 },
    { "pl_PL",                       &encode_ISO_8859_2 },
    { "pl_PL.iso88592",              &encode_ISO_8859_2 },
    { "polish",                      &encode_ISO_8859_2 },
    { "portuguese",                  &encode_ISO_8859_1 },
    { "pt_BR",                       &encode_ISO_8859_1 },
    { "pt_BR.iso88591",              &encode_ISO_8859_1 },
    { "pt_PT",                       &encode_ISO_8859_1 },
    { "pt_PT.iso88591",              &encode_ISO_8859_1 },
    { "pt_PT.iso885915@euro",        &encode_ISO_8859_15 },
    { "pt_PT@euro",                  &encode_ISO_8859_15 },
    { "ro_RO",                       &encode_ISO_8859_2 },
    { "ro_RO.iso88592",              &encode_ISO_8859_2 },
    { "romanian",                    &encode_ISO_8859_2 },
    { "ru_RU",                       &encode_ISO_8859_5 },
    { "ru_RU.cp1251",                &encode_CP1251 },
    { "ru_RU.iso88595",              &encode_ISO_8859_5 },
    { "ru_RU.koi8r",                 &encode_KOI8_R },
    { "ru_UA",                       &encode_KOI8_U },
    { "ru_UA.koi8u",                 &encode_KOI8_U },
    { "russian",                     &encode_KOI8_R },
    { "sk_SK",                       &encode_ISO_8859_2 },
    { "sk_SK.iso88592",              &encode_ISO_8859_2 },
    { "sl_SI",                       &encode_ISO_8859_2 },
    { "sl_SI.iso88592",              &encode_ISO_8859_2 },
    { "slovak",                      &encode_ISO_8859_2 },
    { "slovene",                     &encode_ISO_8859_2 },
    { "slovenian",                   &encode_ISO_8859_2 },
    { "so_DJ",                       &encode_ISO_8859_1 },
    { "so_DJ.iso88591",              &encode_ISO_8859_1 },
    { "so_KE",                       &encode_ISO_8859_1 },
    { "so_KE.iso88591",              &encode_ISO_8859_1 },
    { "so_SO",                       &encode_ISO_8859_1 },
    { "so_SO.iso88591",              &encode_ISO_8859_1 },
    { "spanish",                     &encode_ISO_8859_1 },
    { "sq_AL",                       &encode_ISO_8859_1 },
    { "sq_AL.iso88591",              &encode_ISO_8859_1 },
    { "st_ZA",                       &encode_ISO_8859_1 },
    { "st_ZA.iso88591",              &encode_ISO_8859_1 },
    { "sv_FI",                       &encode_ISO_8859_1 },
    { "sv_FI.iso88591",              &encode_ISO_8859_1 },
    { "sv_FI.iso885915@euro",        &encode_ISO_8859_15 },
    { "sv_FI@euro",                  &encode_ISO_8859_15 },
    { "sv_SE",                       &encode_ISO_8859_1 },
    { "sv_SE.iso88591",              &encode_ISO_8859_1 },
    { "sv_SE.iso885915",             &encode_ISO_8859_15 },
    { "swedish",                     &encode_ISO_8859_1 },
    { "tg_TJ",                       &encode_KOI8_T },
    { "tg_TJ.koi8t",                 &encode_KOI8_T },
    { "th_TH",                       &encode_TIS_620 },
    { "th_TH.tis620",                &encode_TIS_620 },
    { "thai",                        &encode_TIS_620 },
    { "tl_PH",                       &encode_ISO_8859_1 },
    { "tl_PH.iso88591",              &encode_ISO_8859_1 },
    { "tr_CY",                       &encode_ISO_8859_9 },
    { "tr_CY.iso88599",              &encode_ISO_8859_9 },
    { "tr_TR",                       &encode_ISO_8859_9 },
    { "tr_TR.iso88599",              &encode_ISO_8859_9 },
    { "turkish",                     &encode_ISO_8859_9 },
    { "uk_UA",                       &encode_KOI8_U },
    { "uk_UA.koi8u",                 &encode_KOI8_U },
    { "uz_UZ",                       &encode_ISO_8859_1 },
    { "uz_UZ.iso88591",              &encode_ISO_8859_1 },
    { "wa_BE",                       &encode_ISO_8859_1 },
    { "wa_BE.iso88591",              &encode_ISO_8859_1 },
    { "wa_BE.iso885915@euro",        &encode_ISO_8859_15 },
    { "wa_BE@euro",                  &encode_ISO_8859_15 },
    { "xh_ZA",                       &encode_ISO_8859_1 },
    { "xh_ZA.iso88591",              &encode_ISO_8859_1 },
    { "yi_US",                       &encode_CP1255 },
    { "yi_US.cp1255",                &encode_CP1255 },
    { "zh_CN",                       &encode_GB2312 },
    { "zh_CN.gb18030",               &encode_GB18030 },
    { "zh_CN.gb2312",                &encode_GB2312 },
    { "zh_CN.gbk",                   &encode_GBK },
    { "zh_HK",                       &encode_BIG5_HKSCS },
    { "zh_HK.big5hkscs",             &encode_BIG5_HKSCS },
    { "zh_SG",                       &encode_GB2312 },
    { "zh_SG.gb2312",                &encode_GB2312 },
    { "zh_SG.gbk",                   &encode_GBK },
    { "zh_TW",                       &encode_BIG5 },
    { "zh_TW.big5",                  &encode_BIG5 },
    { "zh_TW.euctw",                 &encode_EUC_TW },
    { "zu_ZA",                       &encode_ISO_8859_1 },
    { "zu_ZA.iso88591",              &encode_ISO_8859_1 },
    { 0, 0 }
};
/* *INDENT-ON* */

#endif /* GNREIGHT_H */
