#include "uart.h"
#include <dos.h>
#include <stdlib.h>

// routines for poll operation


int cdecl uart_poll_receive_byte(unsigned baseaddr)
{
	// returns -1 if no character available; else returns character
	if ((inp(baseaddr+5)&0x01)==0) return -1;
	return inp(baseaddr);
}

int cdecl uart_poll_send_byte(unsigned baseaddr, int character)
{
	// returns -1 if timeout (one second)
	
	long far * volatile timer=(long far * volatile)0x0040006cUL;
	long time;

	time=*timer;
	do
		{
		if ((inp(baseaddr+5)&0x20)!=0) {
			outp(baseaddr,character);
			return 0;
			}
		}
	while (labs(time-*timer)<18);
	return -1;
}

int cdecl uart_poll_send_string(unsigned baseaddr, char *string)
{
	// sends a null-terminated string in polled mode
	// returns # of chars transmitted or -(# of chars +1) until timeout
	// that is, if timeout occurs with the first char, this function returns -1

	int counter=0;

	while (*string!=0) {
		counter++;
		if (uart_poll_send_byte(baseaddr,*string)==-1) return -counter;
		string++;
		}
	return counter;
}

int cdecl uart_poll_send_block(unsigned baseaddr, void *block, unsigned blocksize)
{
	// sends a block of data in polled mode
	// returns # of chars transmitted or -(# of chars +1) until timeout
	// that is, if timeout occurs with the first char, this function returns -1

	int counter=0;
	char *blk;

	blk=(char *)block;
	while (blocksize!=0) {
		counter++;
		if (uart_poll_send_byte(baseaddr,*blk)==-1) return -counter;
		blk++;
		blocksize--;
		}
	return counter;
}


