;DEBUG	equ	1	; uncomment this if you want debug code (you won't want)

; assembler part...

MODEL_DEFINED	=	0
CODE_NEAR	=	0
DATA_NEAR	=	0

ifdef MODEL_SMALL
.model small
MODEL_DEFINED	=	1
CODE_NEAR	=	1
DATA_NEAR	=	1
endif
ifdef MODEL_COMPACT
.model compact
MODEL_DEFINED	=	1
CODE_NEAR	=	1
DATA_NEAR	=	0
endif
ifdef MODEL_MEDIUM
.model medium
MODEL_DEFINED	=	1
CODE_NEAR	=	0
DATA_NEAR	=	1
endif
ifdef MODEL_LARGE
.model large
MODEL_DEFINED	=	1
CODE_NEAR	=	0
DATA_NEAR	=	0
endif
ife MODEL_DEFINED
.err
%out	No memory model defined. Assemble using the makefiles...
endif

.stack

if CODE_NEAR
	extrn	_free:NEAR
else
	extrn	_free:FAR
endif

nullseg		segment at 0000h
nullseg		ends

videoseg	segment at 0b800h
videoseg	ends

XOFFCHAR	equ	19
XONCHAR		equ	17

FIFOMODE	equ	10000111b

UE_OK			equ	0
UE_ERROR		equ	-1
UE_BAD_HANDLE		equ	-2
UE_NO_HANDLES		equ	-3
UE_NO_FREE_MEMORY	equ	-4
UE_BAD_INBUF_SIZE	equ	-5
UE_BAD_OUTBUF_SIZE	equ	-6
UE_BAD_HANDSHAKING	equ	-7
UE_BAD_INTLEVEL		equ	-8
UE_TIMEOUT		equ	-9
UE_BAD_FIFO		equ	-10
UE_BAD_HANDLER		equ	-11

MAXUARTS	equ	32
UARTSIZE	equ	32

; uartstruct.flags:
;	bit 0	RTS/CTS mode
;	bit 1	XON/XOFF mode
;	bit 3	XOFF to be sent (set by _rx_int_handler, reset by _tx_int_handler)
;	bit 4	receiver buffer full signaled (that is, XOFF has been sent or RTS has been dropped)
;	bit 5	TX running
;	bit 6	TX disable
;	bit 7	overrun error

uartstruct	STRUC
base		dw	?
intlevel	db	?
flags		db	?
inbuf_ofs	dw	?
inbuf_seg	dw	?
inbuf_size	dw	?
inbuf_head	dw	?
inbuf_tail	dw	?
outbuf_ofs	dw	?
outbuf_seg	dw	?
outbuf_size	dw	?
outbuf_head	dw	?
outbuf_tail	dw	?
msi_handler	dd	?
lsi_handler	dd	?
uartstruct	ENDS

.fardata
_uart		uartstruct 32 dup (<>)
lasthandle	dw	?
_uarts		dw	0
handler_tab2	dw	__modem_int_handler,__tx_int_handler,__rx_int_handler,__status_int_handler
handler_tab	dd	0,0,0,__uart_asm_handler_3,__uart_asm_handler_4,__uart_asm_handler_5,__uart_asm_handler_6,__uart_asm_handler_7
		dd	0,__uart_asm_handler_9,__uart_asm_handler_10,__uart_asm_handler_11,__uart_asm_handler_12,0,__uart_asm_handler_14,__uart_asm_handler_15
intmask		dw	0ffffh


push_all	macro
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	ds
	push	es
	endm

pop_all		macro
	pop	es
	pop	ds
	pop	bp
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	endm

entrycode	macro
	push	bp
	mov	bp,sp
	push	ds
	push	es
	push	di
	endm

exitcode	macro
	pop	di
	pop	es
	pop	ds
	pop	bp
	endm

segregs	macro
	mov	ax,SEG _uart
	mov	ds,ax
	assume	ds:SEG _uart,ss:STACK,es:nothing
	endm



.code
__uart_asm_handler_3	proc far		; handler for int level 3
	; this type of handler programming has proved itself as "bullet-proof"
	push_all

	mov	bp,3
	in	al,21h
	or	al,00001000b
	out	21h,al
	mov	al,20h
	out	20h,al
	sti
	
	call	__uart_asm_interrupt_handler

	cli
	in	al,21h
	and	al,11110111b
	out	21h,al

	pop_all
	iret
__uart_asm_handler_3	endp

.code
__uart_asm_handler_4	proc far		; handler for int level 4
	; this type of handler programming has proved itself as "bullet-proof"
	push_all

	mov	bp,4
	in	al,21h
	or	al,00010000b
	out	21h,al
	mov	al,20h
	out	20h,al
	sti

	call	__uart_asm_interrupt_handler

	cli
	in	al,21h
	and	al,11101111b
	out	21h,al

	pop_all
	iret
__uart_asm_handler_4	endp

.code
__uart_asm_handler_5	proc far		; handler for int level 5
	; this type of handler programming has proved itself as "bullet-proof"
	push_all

	mov	bp,5
	in	al,21h
	or	al,00100000b
	out	21h,al
	mov	al,20h
	out	20h,al
	sti
	
	call	__uart_asm_interrupt_handler

	cli
	in	al,21h
	and	al,11011111b
	out	21h,al

	pop_all
	iret
__uart_asm_handler_5	endp

.code
__uart_asm_handler_6	proc far		; handler for int level 6
	; this type of handler programming has proved itself as "bullet-proof"
	push_all

	mov	bp,6
	in	al,21h
	or	al,01000000b
	out	21h,al
	mov	al,20h
	out	20h,al
	sti
	
	call	__uart_asm_interrupt_handler

	cli
	in	al,21h
	and	al,10111111b
	out	21h,al

	pop_all
	iret
__uart_asm_handler_6	endp

.code
__uart_asm_handler_7	proc far		; handler for int level 7
	; this type of handler programming has proved itself as "bullet-proof"
	push_all

	mov	bp,7
	in	al,21h
	or	al,10000000b
	out	21h,al
	mov	al,20h
	out	20h,al
	sti
	
	call	__uart_asm_interrupt_handler

	cli
	in	al,21h
	and	al,01111111b
	out	21h,al

	pop_all
	iret
__uart_asm_handler_7	endp

.code
__uart_asm_handler_9	proc far		; handler for int level 9
	; this type of handler programming has proved itself as "bullet-proof"
	push_all

	mov	bp,9
	in	al,0a1h
	or	al,00000010b
	out	0a1h,al
	mov	al,20h
	out	0a0h,al
	out	20h,al
	sti
	
	call	__uart_asm_interrupt_handler

	cli
	in	al,0a1h
	and	al,11111101b
	out	0a1h,al

	pop_all
	iret
__uart_asm_handler_9	endp

.code
__uart_asm_handler_10	proc far		; handler for int level 10
	; this type of handler programming has proved itself as "bullet-proof"
	push_all

	mov	bp,10
	in	al,0a1h
	or	al,00000100b
	out	0a1h,al
	mov	al,20h
	out	0a0h,al
	out	20h,al
	sti
	
	call	__uart_asm_interrupt_handler

	cli
	in	al,0a1h
	and	al,11111011b
	out	0a1h,al

	pop_all
	iret
__uart_asm_handler_10	endp

.code
__uart_asm_handler_11	proc far		; handler for int level 11
	; this type of handler programming has proved itself as "bullet-proof"
	push_all

	mov	bp,11
	in	al,0a1h
	or	al,00001000b
	out	0a1h,al
	mov	al,20h
	out	0a0h,al
	out	20h,al
	sti
	
	call	__uart_asm_interrupt_handler

	cli
	in	al,0a1h
	and	al,11110111b
	out	0a1h,al

	pop_all
	iret
__uart_asm_handler_11	endp

.code
__uart_asm_handler_12	proc far		; handler for int level 12
	; this type of handler programming has proved itself as "bullet-proof"
	push_all

	mov	bp,12
	in	al,0a1h
	or	al,00010000b
	out	0a1h,al
	mov	al,20h
	out	0a0h,al
	out	20h,al
	sti
	
	call	__uart_asm_interrupt_handler

	cli
	in	al,0a1h
	and	al,11101111b
	out	0a1h,al

	pop_all
	iret
__uart_asm_handler_12	endp

.code
__uart_asm_handler_14	proc far		; handler for int level 14
	; this type of handler programming has proved itself as "bullet-proof"
	push_all

	mov	bp,14
	in	al,0a1h
	or	al,01000000b
	out	0a1h,al
	mov	al,20h
	out	0a0h,al
	out	20h,al
	sti
	
	call	__uart_asm_interrupt_handler

	cli
	in	al,0a1h
	and	al,10111111b
	out	0a1h,al

	pop_all
	iret
__uart_asm_handler_14	endp

.code
__uart_asm_handler_15	proc far		; handler for int level 15
	; this type of handler programming has proved itself as "bullet-proof"
	push_all

	mov	bp,15
	in	al,0a1h
	or	al,10000000b
	out	0a1h,al
	mov	al,20h
	out	0a0h,al
	out	20h,al
	sti
	
	call	__uart_asm_interrupt_handler

	cli
	in	al,0a1h
	and	al,01111111b
	out	0a1h,al

	pop_all
	iret
__uart_asm_handler_15	endp


.code
; these handler functions are called by __uart_asm_interrupt_handler. They can rely on
; the following info:
;  DS: SEG _uart
;  DI: pointer to this table (so ds:_uart[DI].foobar means variable foobar of the current UART)
;  BX: current handle
;  AH: the state if the IIR that triggered this call
; DS & DI have to be kept in peace

	assume	ds:SEG _uart,es:nothing,ss:STACK

__modem_int_handler	proc near
; this proc calls the msi handler function that belongs to this UART. It has
; to follow these guidelines:
;  void msi_handler(int handler, unsigned baseaddr, unsigned char MSR)
ifdef DEBUG
	mov	cx,videoseg
	mov	es,cx
	inc	byte ptr es:[6]
endif
	mov	dx,_uart[di].base
	add	dx,6
	in	al,dx
	sub	dx,6
	test	_uart[di].flags,1	; RTSCTS-mode?
	jz	__mih1			; no
	push	ax
	xor	al,00010000b		; invert CTS bit
	and	al,00010000b
	shl	al,1
	shl	al,1			; shift it to TX disable position
	mov	ah,_uart[di].flags
	and	ah,10111111b
	or	ah,al
	mov	_uart[di].flags,ah	; and store it there
	pop	ax
	push	ax
	and	al,00010001b
	cmp	al,00010001b		; delta CTS; CTS changed to 1?
	jne	__mih2
	push	bx
	push	dx
	call	__tx_int_handler	; restart TX if there's data to be sent
	pop	dx
	pop	bx
__mih2:
	pop	ax
__mih1:
	push_all
	push	ds			; this was reversed in the last release... sorry for that
	pop	es
	mov	cx,DGROUP
	mov	ds,cx
	cbw
	push	ax
	push	dx
	push	bx
if CODE_NEAR
	call	word ptr es:_uart[di].msi_handler
else
	call	dword ptr es:_uart[di].msi_handler
endif
	add	sp,6
	pop_all
	ret
__modem_int_handler	endp


__tx_int_handler	proc near
; Don't even try to understand it... Enjoy it :)
; OK, I'll try to explain, just for you. This routine is highly optimized for
; the 16550A UART, but it also works with those old 16450s etc. If the int
; has been triggered by a 16550A with the FIFOs enabled, CX is set to 16, else
; to 1 (that's the number of bytes that are sent to the UART). Then we send bytes
; from the ring buffer (taking care to wrap at the upper boundary and not to
; pass the head pointer), with a maximum of CX bytes being passed to the UART.
; That's all! Easy, isn't it? :)

	mov	al,_uart[di].flags
	test	al,00001100b			; XOFF or XON to be sent?
	jnz	__tihx				; do it; it has priority over buffer data
	test	al,01000000b			; OFF condition?
	jnz	__tih5				; don't send
	
ifdef DEBUG
	mov	cx,videoseg
	mov	es,cx
	inc	byte ptr es:[2]
endif
	or	_uart[di].flags,00100000b	; set tx running flag, just in case...
	
	mov	es,_uart[di].outbuf_seg
	assume	es:nothing	; not really, but it's not a variable known to the assembler
	mov	cx,16		; assume we have a FIFO
	and	ah,11000000b
	cmp	ah,11000000b
	je	__tih1
	mov	cx,1
__tih1:	mov	bx,_uart[di].outbuf_ofs
	add	bx,_uart[di].outbuf_size
	mov	si,_uart[di].outbuf_tail
	mov	dx,_uart[di].base
	mov	bp,_uart[di].outbuf_head
__tih2:	cmp	si,bp
	je	__tih6
	mov	al,byte ptr es:[si]
	out	dx,al
	inc	si
	cmp	si,bx
	jne	__tih3
	mov	si,_uart[di].outbuf_ofs
__tih3:	loop	__tih2
__tih4:	mov	_uart[di].outbuf_tail,si
__tih5:	ret
__tih6:	; end of transmission
	and	_uart[di].flags,11011111b
	jmp	__tih4
__tihx:	mov	dx,_uart[di].base
	test	al,00000100b	; is it XON?
	jnz	__tihx1
	mov	al,XOFFCHAR
	out	dx,al
	and	_uart[di].flags,11110111b	; clear XOFF_TO_BE_SENT
	ret
__tihx1:
	mov	al,XONCHAR
	out	dx,al
	and	_uart[di].flags,11101011b	; clear OFF_SIGNALED and XON_TO_BE_SENT
	ret
__tx_int_handler	endp


__rx_int_handler	proc near
; OK, same is true for this proc; it's optimized for 16550A's...
; We test if there are bytes pending; if yes, we get them from the UART, stow
; them away in the ring buffer, then check if this has destroyed data not yet
; read from the buffer again (if yes, we set a flag), increment the buffer
; pointer, make sure it wraps at the upper boundary of the buffer, and if
; no more bytes are to be received from the UART, we get out of here.

ifdef DEBUG
	mov	cx,videoseg
	mov	es,cx
	inc	byte ptr es:[0]
endif
	mov	es,_uart[di].inbuf_seg
	assume	es:nothing	; not really, but it's not a variable known to the assembler
	mov	dx,_uart[di].base
	mov	si,_uart[di].inbuf_head
	mov	bx,_uart[di].inbuf_ofs
	add	bx,_uart[di].inbuf_size
	mov	bp,_uart[di].inbuf_tail
__rih4:	add	dx,5
	in	al,dx
	test	al,1
	jz	__rih1
	sub	dx,5
	in	al,dx
	test	_uart[di].flags,02h	; XONXOFF-mode?
	jz	__rih5			; no
	cmp	al,XOFFCHAR
	jne	__rih6
	or	_uart[di].flags,01000000b
	jmp	__rih4
__rih6:	cmp	al,XONCHAR
	jne	__rih5
	and	_uart[di].flags,10111111b
	push_all
	call	__tx_int_handler	; restart TX if there's data to be sent
	pop_all
	jmp	__rih4
__rih5:	mov	byte ptr es:[si],al
	inc	si
	cmp	si,bx	; upper boundary reached?
	jne	__rih4a
	mov	si,_uart[di].inbuf_ofs
__rih4a:
	cmp	si,bp	; overrun?
	jne	__rih4
	or	_uart[di].flags,80h
	jmp	__rih4
__rih1:	mov	_uart[di].inbuf_head,si
	; now see if handshaking is to be done
	test	_uart[di].flags,00000011b
	jz	__rih7	; no
	mov	cx,_uart[di].inbuf_size
	mov	dx,cx
	shr	dx,1
	shr	dx,1
	shr	dx,1
	mov	ax,_uart[di].inbuf_tail
	sub	ax,_uart[di].inbuf_head
	jns	__rih9
	add	ax,cx
__rih9:	; now AX contains the free bytes in the inbuf
	cmp	ax,dx
	jae	__rih7	; still enough buf free
	test	_uart[di].flags,00010000b	; see if already XOFF/RTS low
	jnz	__rih7	; once is enough...
	or	_uart[di].flags,00010000b
	; see if it's XON/XOFF we are using
	test	_uart[di].flags,00000010b
	jz	__rih8	; no, it's RTS/CTS
	; set the XOFF_TO_BE_SENT flag
	or	_uart[di].flags,00001000b
	test	_uart[di].flags,00100000b	; see if transmission is running
	jnz	__rih7	; OK, then nothing else is to be done
	call	__tx_int_handler
	jmp	__rih7
__rih8:	; clear RTS
	mov	dx,_uart[di].base
	add	dx,4
	cli
	in	al,dx
	and	al,11111101b
	out	dx,al
	sti
__rih7:	ret
__rx_int_handler	endp


__status_int_handler	proc near
; this proc calls the lsi handler function that belongs to this UART. It has
; to follow these guidelines:
;  void lsi_handler(int handler, unsigned baseaddr, unsigned char LSR)
ifdef DEBUG
	mov	cx,videoseg
	mov	es,cx
	inc	byte ptr es:[4]
endif
	mov	dx,_uart[di].base
	add	dx,5
	in	al,dx
	sub	dx,5
	push_all
	push	ds
	pop	es
	mov	cx,DGROUP
	mov	ds,cx
	cbw
	push	ax
	push	dx
	push	bx
if CODE_NEAR
	call	word ptr es:_uart[di].lsi_handler
else
	call	dword ptr es:_uart[di].lsi_handler
endif
	add	sp,6
	pop_all
	ret
__status_int_handler	endp


.code
__uart_asm_interrupt_handler	proc near		; sic!
	; BP contains the interrupt level to be serviced
	; all registers are pushed, we can 'go berserk'
	mov	ax,SEG _uart
	mov	ds,ax
	assume	ss:nothing,ds:SEG _uart,es:nothing
	xor	bx,bx	; BX is our UART counter
	xor	di,di	; DS:[uart]DI points to the current UART table entry
__aih2:
	mov	al,_uart[di].intlevel
	cbw
	cmp	ax,bp	; has this UART the current intlevel?
	jne	__aih1	; no, skip it

__aih3:
	mov	dx,_uart[di].base
	add	dx,2
	in	al,dx	; see if there's an interrupt pending in this chip
	test	al,1	; has this chip triggered interrupt?
	jnz	__aih1	; no, skip it

	mov	si,ax
	mov	ah,al	; preserve bits 6 & 7 (FIFO ident)
	and	si,6	; make a pointer...

	; make sure these are not changed
	push	bp
	push	bx

	call	handler_tab2[si]	; call the appropriate handler for this kind of int

	pop	bx
	pop	bp
	jmp	__aih3	; look out for more int conditions from the same UART

__aih1:
	add	di,UARTSIZE
	inc	bx
	cmp	bx,_uarts
	jne	__aih2
	ret
__uart_asm_interrupt_handler	endp


.code
public __uart_asm_create_new_intlevel
; this function sets the int vector of the selected interrupt level and enables this
; interrupt at the ICU mask register
__uart_asm_create_new_intlevel	proc
if CODE_NEAR
ilev	= byte ptr [bp+4]
else
ilev	= byte ptr [bp+6]
endif
	entrycode
	push	si
	mov	ax,nullseg
	mov	ds,ax
	mov	ax,SEG handler_tab
	mov	es,ax
	assume	ss:STACK,ds:nullseg,es:SEG handler_tab
	mov	bl,ilev
	xor	bh,bh
	mov	ax,0fffeh
	mov	cl,bl
	rol	ax,cl
	and	intmask,ax
	shl	bx,1
	shl	bx,1
	les	si,handler_tab[bx]
	cmp	bx,20h
	jb	__uacnix
	add	bx,180h
__uacnix:
	assume	es:nothing
	cli
	mov	word ptr ds:[bx+20h],si
	mov	word ptr ds:[bx+22h],es
	sti
	pop	si
	exitcode
	ret
__uart_asm_create_new_intlevel	endp

.code
public _uart_int_receive_byte	; (int handle)
_uart_int_receive_byte	proc
; returns: -1 if no byte available
;          -2 if illegal handle
;          0-255 the next byte
if CODE_NEAR
handle	= word ptr [bp+4]
else
handle	= word ptr [bp+6]
endif
	entrycode
	push	si
	segregs
	mov	ax,handle
	cmp	ax,_uarts		; illegal handle?
__uirb9:
	mov	ax,UE_BAD_HANDLE	; then return -2
	je	__uirb1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax			; now DI is an index to the UART table
	cmp	_uart[di].intlevel,0
	je	__uirb9
	mov	si,_uart[di].inbuf_tail
	cmp	si,_uart[di].inbuf_head	; no bytes available?
	mov	ax,UE_ERROR		; then return -1
	je	__uirb1
	mov	es,_uart[di].inbuf_seg
	assume	es:nothing
	mov	al,byte ptr es:[si]
	xor	ah,ah
	inc	si
	mov	bx,_uart[di].inbuf_ofs
	add	bx,_uart[di].inbuf_size
	cmp	si,bx
	jne	__uirb2
	mov	si,_uart[di].inbuf_ofs
__uirb2:
	mov	_uart[di].inbuf_tail,si
__uirb1:
	; see if we're in handshaking mode, buffer full has been signaled, and buffer empty enough again
	mov	bl,_uart[di].flags
	test	bl,00000011b
	jz	__uirbn		; no handshaking at all
	test	bl,00010000b
	jz	__uirbn		; no XOFF/RTSlow signaled
	; see if buffer empty enough
	mov	dx,_uart[di].inbuf_size
	mov	si,_uart[di].inbuf_tail
	sub	si,_uart[di].inbuf_head
	jns	__uirbn1
	add	si,dx
__uirbn1:
	shr	dx,1
	shr	dx,1
	cmp	si,dx
	jb	__uirbn		; not free enough again
	; we have to signal that everything is fine again...
	test	bl,00000010b
	jz	__uirbn2	; it's RTS/CTS
	or	_uart[di].flags,00000100b	; set XON_TO_BE_SENT flag
	test	bl,00100000b
	jnz	__uirbn		; transmission running?
	push_all		; no, start it
	call	__tx_int_handler
	pop_all
	jmp	__uirbn
__uirbn2:
	and	_uart[di].flags,11101111b	; clear the OFF_SIGNALED flag (it's done by the int with XONXOFF)
	mov	dx,_uart[di].base
	add	dx,4
	mov	cx,ax
	cli
	in	al,dx
	or	al,00000010b
	out	dx,al
	sti
	mov	ax,cx
__uirbn:
	pop	si
	exitcode
	ret
_uart_int_receive_byte	endp

.code
public _uart_int_send_byte	; (int handle, int byte)	; int keeps the compiler from generating warnings
_uart_int_send_byte	proc
; returns: -2 if illegal handle
;          -1 if buffer full (try again some time later)
;          0 otherwise
if CODE_NEAR
char	= byte ptr [bp+6]
handle	= word ptr [bp+4]
else
char	= byte ptr [bp+8]
handle	= word ptr [bp+6]
endif
	entrycode
	push	si
	segregs
	mov	ax,handle
	cmp	ax,_uarts		; illegal handle?
__uisb9:
	mov	ax,UE_BAD_HANDLE	; then return -2
	jae	__uisb1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax			; now DI is an index to the UART table
	cmp	_uarts[di].intlevel,0
	je	__uisb9

	mov	si,_uart[di].outbuf_head
	mov	es,_uart[di].outbuf_seg
	assume	es:nothing
	mov	al,char
	mov	byte ptr es:[si],al
	inc	si
	mov	bx,_uart[di].outbuf_ofs
	add	bx,_uart[di].outbuf_size
	cmp	si,bx
	jne	__uisb2
	mov	si,_uart[di].outbuf_ofs
__uisb2:
	cmp	si,_uart[di].outbuf_tail	; buffer full?
	mov	ax,UE_ERROR			; then return -1
	je	__uisb1				; the byte written is ignored...
	mov	_uart[di].outbuf_head,si

	; see if transmission is running
	test	_uart[di].flags,01000000b	; OFF condition?
	jnz	__uisb1a
	cli
	test	_uart[di].flags,00100000b
	jnz	__uisb_running
ifdef DEBUG
	mov	ax,videoseg
	mov	es,ax
	assume	es:nothing
	inc	byte ptr es:[8]
endif
	or	_uart[di].flags,00100000b	; set tx runnning flag
	push_all
	mov	bx,handle
	xor	ax,ax
	call	__tx_int_handler
	pop_all
__uisb_running:
	sti
__uisb1a:
	xor	ax,ax
__uisb1:
	pop	si
	exitcode
	ret
_uart_int_send_byte	endp

public __uart_asm_cleanup
__uart_asm_cleanup	proc
	; called at exit

	entrycode
	segregs

	; first shut down all interrupts that are in use
	mov	cx,_uarts
	jcxz	__ac3
	xor	di,di
__ac1:	cmp	_uart[di].intlevel,0
	je	__ac5
	mov	dx,_uart[di].base
	inc	dx
	xor	ax,ax
	out	dx,al
	add	dx,3
	in	al,dx
	and	al,0f7h
	out	dx,al
	push	cx
	mov	cl,_uart[di].intlevel
	mov	ax,1
	rol	ax,cl
	mov	cx,ax
	in	al,21h
	or	al,cl
	out	21h,al
	in	al,0a1h
	or	al,ch
	out	0a1h,al
	pop	cx
	sub	dx,2
	xor	ax,ax
	out	dx,al
__ac5:
	add	di,UARTSIZE
	loop	__ac1

	mov	cx,_uarts
	xor	di,di
__ac2:	cmp	_uart[di].intlevel,0
	je	__ac4
	push	cx
	push	es
if DATA_NEAR
	mov	ax,_uart[di].inbuf_ofs
	push	ax
	call	_free
	add	sp,2
	mov	ax,_uart[di].outbuf_ofs
	push	ax
	call	_free
	add	sp,2
else
	mov	ax,_uart[di].inbuf_seg
	push	ax
	mov	ax,_uart[di].inbuf_ofs
	push	ax
	call	_free
	add	sp,4
	mov	ax,_uart[di].outbuf_seg
	push	ax
	mov	ax,_uart[di].outbuf_ofs
	push	ax
	call	_free
	add	sp,4
endif
	pop	es
	pop	cx
__ac4:	add	di,UARTSIZE
	loop	__ac2

	mov	_uarts,0
__ac3:
	exitcode
	ret
__uart_asm_cleanup	endp

public _uart_int_default_handler
_uart_int_default_handler	proc
	ret
_uart_int_default_handler	endp


public __uart_asm_define_port_1
__uart_asm_define_port_1	proc	; (unsigned baseaddr, unsigned char intlvl, unsigned inbuf_siz, unsigned outbuf_siz,
				; unsigned char handshake)
if CODE_NEAR
baseaddr	=	word ptr [bp+4]
intlvl		=	byte ptr [bp+6]
inbuf_siz	=	word ptr [bp+8]
outbuf_siz	=	word ptr [bp+10]
handshake	=	byte ptr [bp+12]
else
baseaddr	=	word ptr [bp+6]
intlvl		=	byte ptr [bp+8]
inbuf_siz	=	word ptr [bp+10]
outbuf_siz	=	word ptr [bp+12]
handshake	=	byte ptr [bp+14]
endif
	entrycode
	segregs

	; find the first available handle
	mov	cx,_uarts
	xor	bx,bx
	xor	di,di
	jcxz	__ad11
__ad12:	cmp	_uart[di].intlevel,0
	je	__ad11
	inc	bx
	add	di,UARTSIZE
	loop	__ad12
	cmp	bx,MAXUARTS
	mov	ax,UE_NO_HANDLES
	jae	__ad13
__ad11:
	mov	ax,baseaddr
	mov	_uart[di].base,ax
	mov	al,intlvl
	mov	_uart[di].intlevel,al
	mov	al,handshake
	mov	_uart[di].flags,al
	mov	ax,inbuf_siz
	mov	_uart[di].inbuf_size,ax
	mov	ax,outbuf_siz
	mov	_uart[di].outbuf_size,ax

	mov	lasthandle,bx
	mov	ax,bx
__ad13:
	exitcode
	ret
__uart_asm_define_port_1	endp



public __uart_asm_define_port_2
__uart_asm_define_port_2	proc	; (unsigned offs, unsigned segm)
if CODE_NEAR
offs	=	word ptr [bp+4]
segm	=	word ptr [bp+6]
else
offs	=	word ptr [bp+6]
segm	=	word ptr [bp+8]
endif
	entrycode
	segregs

	mov	ax,UARTSIZE
	mul	lasthandle
	mov	di,ax

	mov	ax,offs
	mov	_uart[di].inbuf_ofs,ax
	mov	_uart[di].inbuf_head,ax
	mov	_uart[di].inbuf_tail,ax
	mov	ax,segm
	mov	_uart[di].inbuf_seg,ax

	exitcode
	ret
__uart_asm_define_port_2	endp


public __uart_asm_define_port_3
__uart_asm_define_port_3	proc	; (unsigned offs, unsigned segm)
if CODE_NEAR
offs	=	word ptr [bp+4]
segm	=	word ptr [bp+6]
else
offs	=	word ptr [bp+6]
segm	=	word ptr [bp+8]
endif
	entrycode
	segregs

	mov	ax,UARTSIZE
	mul	lasthandle
	mov	di,ax

	mov	ax,offs
	mov	_uart[di].outbuf_ofs,ax
	mov	_uart[di].outbuf_head,ax
	mov	_uart[di].outbuf_tail,ax
	mov	ax,segm
	mov	_uart[di].outbuf_seg,ax

	exitcode
	ret
__uart_asm_define_port_3	endp


public __uart_asm_define_port_4
__uart_asm_define_port_4	proc	; (unsigned char intlvl)
if CODE_NEAR
intlvl		=	byte ptr [bp+4]
else
intlvl		=	byte ptr [bp+6]
endif
	entrycode
	segregs

	mov	ax,UARTSIZE
	mul	lasthandle
	mov	di,ax

	mov	word ptr _uart[di].msi_handler,offset _uart_int_default_handler
	mov	word ptr _uart[di].msi_handler+2,seg _uart_int_default_handler
	mov	word ptr _uart[di].lsi_handler,offset _uart_int_default_handler
	mov	word ptr _uart[di].lsi_handler+2,seg _uart_int_default_handler

	; try to enable fifos
	mov	dx,_uart[di].base
	add	dx,2
	mov	al,FIFOMODE
	out	dx,al
	in	al,dx
	and	al,11000000b
	cmp	al,10000000b	; is it a defective 16550?
	jne	__ad40
	xor	ax,ax		; then disable them again
	out	dx,al
__ad40:
	mov	cx,_uarts
	jcxz	__ad42
	xor	di,di
	mov	bl,intlvl
__ad41:
	cmp	bl,_uart[di].intlevel
	je	__ad42
	add	di,UARTSIZE
	loop	__ad41
__ad42:	mov	al,intlvl
	push	ax
	call	__uart_asm_create_new_intlevel
	add	sp,2

	mov	ax,lasthandle	; did we assign a handle at the butt of the table?
	cmp	ax,_uarts	; yep, so the table has one more entry now
	jne	_ad43
	inc	_uarts
_ad43:
	exitcode
	ret
__uart_asm_define_port_4	endp


public _uart_int_set_break
_uart_int_set_break	proc	; (int handle)
if CODE_NEAR
handle		=	word ptr [bp+4]
else
handle		=	word ptr [bp+6]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uisbr9:
	mov	ax,UE_BAD_HANDLE
	jae	__uisbr1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uisbr9
	mov	dx,_uart[di].base
	add	dx,3
	in	al,dx
	or	al,40h
	out	dx,al
	xor	ax,ax
__uisbr1:
	exitcode
	ret
_uart_int_set_break	endp

public _uart_int_clear_break
_uart_int_clear_break	proc	; (int handle)
if CODE_NEAR
handle		=	word ptr [bp+4]
else
handle		=	word ptr [bp+6]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uicbr9:
	mov	ax,UE_BAD_HANDLE
	jae	__uicbr1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uicbr9
	mov	dx,_uart[di].base
	add	dx,3
	in	al,dx
	and	al,10111111b
	out	dx,al
	xor	ax,ax
__uicbr1:
	exitcode
	ret
_uart_int_clear_break	endp

public _uart_int_set_dtr
_uart_int_set_dtr	proc	; (int handle)
if CODE_NEAR
handle		=	word ptr [bp+4]
else
handle		=	word ptr [bp+6]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uisd9:
	mov	ax,UE_BAD_HANDLE
	jae	__uisd1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uisd9
	mov	dx,_uart[di].base
	add	dx,4
	in	al,dx
	or	al,1
	out	dx,al
	xor	ax,ax
__uisd1:
	exitcode
	ret
_uart_int_set_dtr	endp

public _uart_int_clear_dtr
_uart_int_clear_dtr	proc	; (int handle)
if CODE_NEAR
handle		=	word ptr [bp+4]
else
handle		=	word ptr [bp+6]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uicd9:
	mov	ax,UE_BAD_HANDLE
	jae	__uicd1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uicd9
	mov	dx,_uart[di].base
	add	dx,4
	in	al,dx
	and	al,0feh
	out	dx,al
	xor	ax,ax
__uicd1:
	exitcode
	ret
_uart_int_clear_dtr	endp

public _uart_int_set_rts
_uart_int_set_rts	proc	; (int handle)
if CODE_NEAR
handle		=	word ptr [bp+4]
else
handle		=	word ptr [bp+6]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uisr9:
	mov	ax,UE_BAD_HANDLE
	jae	__uisr1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uisr9
	mov	dx,_uart[di].base
	add	dx,4
	in	al,dx
	or	al,2
	out	dx,al
	xor	ax,ax
__uisr1:
	exitcode
	ret
_uart_int_set_rts	endp

public _uart_int_clear_rts
_uart_int_clear_rts	proc	; (int handle)
if CODE_NEAR
handle		=	word ptr [bp+4]
else
handle		=	word ptr [bp+6]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uicr9:
	mov	ax,UE_BAD_HANDLE
	jae	__uicr1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uicr9
	mov	dx,_uart[di].base
	add	dx,4
	in	al,dx
	and	al,11111101b
	out	dx,al
	xor	ax,ax
__uicr1:
	exitcode
	ret
_uart_int_clear_rts	endp

public _uart_int_set_local_loopback
_uart_int_set_local_loopback	proc	; (int handle)
if CODE_NEAR
handle		=	word ptr [bp+4]
else
handle		=	word ptr [bp+6]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uisll9:
	mov	ax,UE_BAD_HANDLE
	jae	__uisll1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uisll9
	mov	dx,_uart[di].base
	add	dx,4
	in	al,dx
	or	al,10h
	out	dx,al
	xor	ax,ax
__uisll1:
	exitcode
	ret
_uart_int_set_local_loopback	endp

public _uart_int_clear_local_loopback
_uart_int_clear_local_loopback	proc	; (int handle)
if CODE_NEAR
handle		=	word ptr [bp+4]
else
handle		=	word ptr [bp+6]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uicll9:
	mov	ax,UE_BAD_HANDLE
	jae	__uicll1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uicll9
	mov	dx,_uart[di].base
	add	dx,4
	in	al,dx
	and	al,11101111b
	out	dx,al
	xor	ax,ax
__uicll1:
	exitcode
	ret
_uart_int_clear_local_loopback	endp

public _uart_int_clear_receive_buffer
_uart_int_clear_receive_buffer	proc	; (int handle)
if CODE_NEAR
handle		=	word ptr [bp+4]
else
handle		=	word ptr [bp+6]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uicrx9:
	mov	ax,UE_BAD_HANDLE
	jae	__uicrx1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uicrx9
	mov	ax,_uart[di].inbuf_ofs
	cli
	mov	_uart[di].inbuf_head,ax
	mov	_uart[di].inbuf_tail,ax
	mov	dx,_uart[di].base
	add	dx,2
	in	al,dx
	and	al,11000000b
	cmp	al,11000000b
	jne	__uicrx2
	mov	al,FIFOMODE AND 11111011b
	out	dx,al
__uicrx2:
	sti
	xor	ax,ax
__uicrx1:
	exitcode
	ret
_uart_int_clear_receive_buffer	endp

public _uart_int_clear_send_buffer
_uart_int_clear_send_buffer	proc	; (int handle)
if CODE_NEAR
handle		=	word ptr [bp+4]
else
handle		=	word ptr [bp+6]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uictx9:
	mov	ax,UE_BAD_HANDLE
	jae	__uictx1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uictx9
	mov	ax,_uart[di].outbuf_ofs
	cli
	mov	_uart[di].outbuf_head,ax
	mov	_uart[di].outbuf_tail,ax
	mov	dx,_uart[di].base
	add	dx,2
	in	al,dx
	and	al,11000000b
	cmp	al,11000000b
	jne	__uictx2
	mov	al,FIFOMODE AND 11111101b
	out	dx,al
__uictx2:
	sti
	xor	ax,ax
__uictx1:
	exitcode
	ret
_uart_int_clear_send_buffer	endp

public _uart_int_set_bps_rate
_uart_int_set_bps_rate	proc	; (int handle, unsigned rate)
if CODE_NEAR
handle		=	word ptr [bp+4]
rate		=	word ptr [bp+6]
else
handle		=	word ptr [bp+6]
rate		=	word ptr [bp+8]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uisbps9:
	mov	ax,UE_BAD_HANDLE
	jae	__uisbps1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uisbps9
	mov	dx,_uart[di].base
	add	dx,3
	cli
	in	al,dx
	or	al,80h
	out	dx,al
	sub	dx,3
	mov	ax,rate
	out	dx,ax
	add	dx,3
	in	al,dx
	and	al,7fh
	out	dx,al
	sti
	xor	ax,ax
__uisbps1:
	exitcode
	ret
_uart_int_set_bps_rate	endp

public _uart_int_set_line_params
_uart_int_set_line_params	proc	; (int handle, unsigned char lineparams)
if CODE_NEAR
handle		=	word ptr [bp+4]
lineparams	=	byte ptr [bp+6]
else
handle		=	word ptr [bp+6]
lineparams	=	byte ptr [bp+8]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uislp9:
	mov	ax,UE_BAD_HANDLE
	jae	__uislp1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uislp9
	mov	dx,_uart[di].base
	add	dx,3
	mov	al,lineparams
	and	al,01111111b
	out	dx,al
	xor	ax,ax
__uislp1:
	exitcode
	ret
_uart_int_set_line_params	endp

public _uart_int_read_line_params
_uart_int_read_line_params	proc	; (int handle)
if CODE_NEAR
handle		=	word ptr [bp+4]
else
handle		=	word ptr [bp+6]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uirlp9:
	mov	ax,UE_BAD_HANDLE
	jae	__uirlp1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uirlp9
	mov	dx,_uart[di].base
	add	dx,3
	in 	al,dx
	xor	ah,ah
__uirlp1:
	exitcode
	ret
_uart_int_read_line_params	endp

public _uart_int_write_scr
_uart_int_write_scr	proc	; (int handle, unsigned char value)
if CODE_NEAR
handle		=	word ptr [bp+4]
value		=	byte ptr [bp+6]
else
handle		=	word ptr [bp+6]
value		=	byte ptr [bp+8]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uiwscr9:
	mov	ax,UE_BAD_HANDLE
	jae	__uiwscr1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uiwscr9
	mov	dx,_uart[di].base
	add	dx,7
	mov	al,value
	out	dx,al
	xor	ax,ax
__uiwscr1:
	exitcode
	ret
_uart_int_write_scr	endp

public _uart_int_read_scr
_uart_int_read_scr	proc	; (int handle)
if CODE_NEAR
handle		=	word ptr [bp+4]
else
handle		=	word ptr [bp+6]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uirscr9:
	mov	ax,UE_BAD_HANDLE
	jae	__uirscr1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uirscr9
	mov	dx,_uart[di].base
	add	dx,7
	in 	al,dx
	xor	ah,ah
__uirscr1:
	exitcode
	ret
_uart_int_read_scr	endp

public _uart_int_set_handshake
_uart_int_set_handshake	proc	; (int handle, int handshake)
if CODE_NEAR
handle		=	word ptr [bp+4]
handshake	=	byte ptr [bp+6]
else
handle		=	word ptr [bp+6]
handshake	=	byte ptr [bp+6]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uish9:
	mov	ax,UE_BAD_HANDLE
	jae	__uish1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uish9
	mov	bl,handshake
	cmp	bl,2
	mov	ax,UE_BAD_HANDSHAKING
	ja	__uish1
	mov	_uart[di].flags,bl
	xor	ax,ax
__uish1:
	exitcode
	ret
_uart_int_set_handshake	endp

public _uart_int_set_msi_handler
_uart_int_set_msi_handler	proc	; (int handle, void (*msihandler)(int handle, unsigned baseaddr, unsigned char msr));
if CODE_NEAR
handle		=	word ptr [bp+4]
handler		=	word ptr [bp+6]
else
handle		=	word ptr [bp+6]
handler		=	dword ptr [bp+8]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uismh9:
	mov	ax,UE_BAD_HANDLE
	jae	__uismh1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uismh9
if CODE_NEAR
	mov	bx,handler
	cmp	bx,0
else
	les	bx,handler
	mov	ax,es
	or	ax,bx
endif
	mov	ax,UE_BAD_HANDLER
	je	__uismh1
if CODE_NEAR
	mov	word ptr _uart[di].msi_handler,bx
else
	cli
	mov	word ptr _uart[di].msi_handler,bx
	mov	word ptr _uart[di].msi_handler+2,es
	sti
endif
	xor	ax,ax
__uismh1:
	exitcode
	ret
_uart_int_set_msi_handler	endp

public _uart_int_set_lsi_handler
_uart_int_set_lsi_handler	proc	; (int handle, void (*lsihandler)(int handle, unsigned baseaddr, unsigned char lsr));
if CODE_NEAR
handle		=	word ptr [bp+4]
handler		=	word ptr [bp+6]
else
handle		=	word ptr [bp+6]
handler		=	dword ptr [bp+8]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uislh9:
	mov	ax,UE_BAD_HANDLE
	jae	__uislh1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uislh9
if CODE_NEAR
	mov	bx,handler
	cmp	bx,0
else
	les	bx,handler
	mov	ax,es
	or	ax,bx
endif
	mov	ax,UE_BAD_HANDLER
	je	__uislh1
if CODE_NEAR
	mov	word ptr _uart[di].lsi_handler,bx
else
	cli
	mov	word ptr _uart[di].lsi_handler,bx
	mov	word ptr _uart[di].lsi_handler+2,es
	sti
endif
	xor	ax,ax
__uislh1:
	exitcode
	ret
_uart_int_set_lsi_handler	endp

public _uart_int_undef_port
_uart_int_undef_port	proc	; (int handle)
if CODE_NEAR
handle		=	word ptr [bp+4]
else
handle		=	word ptr [bp+6]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uiup9:
	mov	ax,UE_BAD_HANDLE
	jae	__uiup1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uiup9

	mov	dx,_uart[di].base
	inc	dx
	xor	ax,ax
	out	dx,al		; turn off ints from this UART
	; note that I don't clear OUT2 of the MCR! This makes sure the int
	; line stays low; if it would stick to high, that'd be quite messy...
	; these lines are quasi-level-triggered with my code...
	mov	_uart[di].intlevel,0	; turn off int service for this UART
	; now the handle does no longer exist and we free the buffers
if DATA_NEAR
	mov	ax,_uart[di].inbuf_ofs
	push	ax
	call	_free
	add	sp,2
	mov	ax,_uart[di].outbuf_ofs
	push	ax
	call	_free
	add	sp,2
else
	mov	ax,_uart[di].inbuf_seg
	push	ax
	mov	ax,_uart[di].inbuf_ofs
	push	ax
	call	_free
	add	sp,4
	mov	ax,_uart[di].outbuf_seg
	push	ax
	mov	ax,_uart[di].outbuf_ofs
	push	ax
	call	_free
	add	sp,4
endif
	; see if the very last entry in the table is now invalid
__uiup3:
	mov	ax,UARTSIZE
	mov	cx,_uarts
	jcxz	__uiup2
	dec	cx
	mul	cx
	mov	di,ax
	cmp	_uart[di].intlevel,0
	jne	__uiup2
	dec	_uarts		; yep, so reduce the table size by one
	jmp	__uiup3		; and see if we can kill more entries
__uiup2:
	; that's it!
	xor	ax,ax
__uiup1:
	exitcode
	ret
_uart_int_undef_port	endp

public _uart_int_enable
_uart_int_enable	proc
	; start interrupt servicing
	entrycode
	segregs
	cli
	in	al,21h
	and	al,byte ptr intmask
	out	21h,al
	in	al,0a1h
	and	al,byte ptr intmask+1
	out	0a1h,al
	sti
	exitcode
	ret
_uart_int_enable	endp

public _uart_int_disable
_uart_int_disable	proc
	; end interrupt servicing
	entrycode
	segregs
	cli
	in	al,21h
	mov	ah,byte ptr intmask
	not	ah
	and	al,ah
	out	21h,al
	in	al,0a1h
	mov	ah,byte ptr intmask+1
	not	ah
	and	al,ah
	out	0a1h,al
	sti
	exitcode
	ret
_uart_int_disable	endp

public _uart_int_get_baseaddr
_uart_int_get_baseaddr	proc
	entrycode
	segregs
if CODE_NEAR
handle		=	word ptr [bp+4]
else
handle		=	word ptr [bp+6]
endif
	entrycode
	segregs
	mov	ax,handle
	cmp	ax,_uarts
__uigb9:
	mov	ax,UE_BAD_HANDLE
	jae	__uigb1
	mov	ax,UARTSIZE
	mul	handle
	mov	di,ax
	cmp	_uart[di].intlevel,0
	je	__uigb9
	mov	ax,_uart[di].base
__uigb1:
	exitcode
	ret
_uart_int_get_baseaddr	endp
end

